`include "../lib/ramdefs.h"
module
pktengine
(
sclk
,
srst
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
parameter
PORT
=
1
;
parameter
IBW
=
64
;
parameter
SBW
=
32
;
parameter
DBW
=
32
;
input
sclk
;
input
srst
;
input
scs
;
input
swr
;
input
srd
;
input
[
31
:
0
]
saddr
;
input
[
31
:
0
]
swrbus
;
output
[
31
:
0
]
srdbus
;
output
sack
;
input
ioclk
;
output
istat
;
input
iena
;
input
[
7
:
0
]
isel
;
input
[
IBW
-
1
:
0
]
ibus
;
output
ostat
;
input
oena
;
output
[
7
:
0
]
osel
;
output
[
IBW
-
1
:
0
]
obus
;
output
[
7
:
0
]
test
;
wire
z1
=
0
,
z2
=
1
;
assign
sack
=
z2
;
wire
[
11
:
0
]
z3
;
swrbank
#
(
0
,
1
)
swb
(
sclk
,
scs
,
swr
,
saddr
,
z3
);
wire
z4
=
z3
[
0
];
reg
[
31
:
0
]
z5
;
always
@(
posedge
sclk
)
begin
if
(
srst
)
z5
<=
0
;
else
if
(
z4
)
z5
<=
swrbus
;
end
wire
z6
=
z5
[
0
];
wire
z7
=
z5
[
1
];
wire
z8
=
!
z6
;
wire
z9
,
z10
,
z11
,
z12
,
z13
,
z14
,
z15
,
z16
;
wire
[
DBW
-
1
:
0
]
z17
,
z18
,
z19
,
z20
;
wire
z21
,
z22
,
z23
,
z24
,
z25
;
wire
[
3
:
0
]
z26
,
z27
;
wire
[
31
:
0
]
z28
;
wire
[
7
:
0
]
z29
;
reg
z30
;
always
@(
posedge
ioclk
)
z30
<=
iena
;
fifoNxM
#
(
IBW
,
DBW
,
4
,
3
)
fi
(
ioclk
,
z8
,
istat
,
z30
,
ibus
,
sclk
,
z8
,
z13
,
z9
,
z17
);
dat2pkt
d2p
(
sclk
,
srst
,
scs
&
swr
,
saddr
,
swrbus
,
srdbus
,
z13
,
z9
,
z27
,
z17
,
z15
&
z23
,
z10
,
z18
,
z21
,
test
);
`ifdef PKTETH
pkt2eth
p2e
(
sclk
,
z8
,
z23
,
z10
,
z1
,
z18
,
z26
,
z28
,
z22
);
eth2pkt
e2p
(
sclk
,
z8
,
z26
,
z28
,
z11
,
z19
);
`else
assign
z19
=
z18
;
assign
z11
=
z10
;
assign
z23
=
z15
;
`endif
`ifdef PKTENGINE
wire
[
SBW
-
1
:
0
]
z31
;
wire
z32
;
wire
[
7
:
0
]
z33
;
`PKTENGINE #(0,DBW,IBW,0,1) p2d (sclk,srst, scs,saddr, swr,swrbus, srd,z31, z32,
ioclk
,
z15
,
z11
,
z33
,
z19
,
ostat
,
oena
,
osel
,
obus
,
test
);
`else
fifoNxM
#
(
DBW
,
IBW
,
4
,
3
)
fo
(
sclk
,
z8
,
z15
,
z11
,
z19
,
ioclk
,
z8
,
ostat
,
oena
,
obus
);
assign
osel
=
0
;
`endif
assign
test
=
{
oena
,
ostat
,
iena
,
istat
,
z10
,
z9
,
z7
,
z8
};
endmodule
module
dat2pkt
(
clk
,
z8
,
pwr
,
paddr
,
pdata
,
pdatar
,
z13
,
z9
,
z27
,
z17
,
z14
,
z10
,
z18
,
bypass
,
test
);
parameter
DBW
=
32
;
parameter
NC
=
1
;
input
clk
,
z8
;
input
pwr
;
input
[
15
:
0
]
paddr
;
input
[
31
:
0
]
pdata
;
output
[
31
:
0
]
pdatar
;
input
[
1
:
0
]
z13
;
output
[
2
:
0
]
z9
;
input
[
3
:
0
]
z27
;
input
[
DBW
-
1
:
0
]
z17
;
input
z14
;
output
z10
;
output
[
DBW
-
1
:
0
]
z18
;
output
bypass
;
output
[
7
:
0
]
test
;
wire
z1
=
0
,
z2
=
1
;
reg
[
3
:
0
]
z34
;
reg
[
2
:
0
]
z35
;
reg
[
7
:
0
]
z36
,
z37
;
reg
[
11
:
0
]
z38
;
reg
[
31
:
0
]
z39
;
reg
[
3
:
0
]
z40
;
reg
z41
,
z42
,
z43
,
z44
,
z45
,
z46
;
reg
z47
,
z48
,
z49
,
z50
,
z51
,
z52
;
reg
z53
,
z54
,
z55
,
z56
;
reg
[
31
:
0
]
z57
;
wire
z6
=
z57
[
0
];
assign
bypass
=
z57
[
4
];
wire
z58
=
z57
[
6
];
wire
[
31
:
0
]
z59
,
z60
;
dpram
#
(
4
,
32
,
32
)
rseq
(
clk
,
z2
,
paddr
[
11
:
2
],
pwr
,
pdata
,
z60
,
clk
,
z2
,
{
z34
,
z36
},
z1
,
32'h0
,
z59
);
wire
[
7
:
0
]
z61
=
z39
[
7
:
0
];
wire
[
10
:
0
]
z62
=
z39
[
7
:
0
];
wire
[
3
:
0
]
z63
=
z39
[
11
:
8
];
wire
[
1
:
0
]
z64
=
z39
[
13
:
12
];
wire
z65
=
z39
[
20
];
wire
z66
=
z59
[
21
];
wire
z67
=
z59
[
22
];
wire
z68
=
z39
[
23
]&
z53
;
wire
z69
=
z39
[
24
];
wire
z70
=
z39
[
25
];
wire
z71
=
z39
[
26
];
wire
z72
=
z39
[
27
];
wire
z73
=
z39
[
28
];
wire
z74
=
z39
[
29
];
wire
z75
=
z39
[
30
];
wire
z76
=
z39
[
31
];
wire
z77
=
z59
[
31
]&&
z45
;
wire
z78
=
z41
||
z45
||
z42
;
wire
z79
=
z67
;
wire
[
1
:
0
]
z80
=
z27
;
wire
[
7
:
0
]
z81
=
z40
[
z80
]?
z57
[
31
:
24
]
:
z57
[
23
:
16
];
wire
z82
=
z35
[
2
]
||
(!
z58
&&
!
z78
&&
!
z13
[
z55
]
&&
!
z56
);
always
@(
posedge
clk
)
begin
z50
<=
pwr
&&
(
paddr
[
11
:
0
]==
0
);
z51
<=
pwr
&&
(
paddr
[
11
:
2
]==
0
);
if
(
z8
)
z57
<=
0
;
else
if
(
z50
)
z57
<=
pdata
;
if
(
z8
)
z52
<=
0
;
else
if
(
z51
)
z52
<=
pdata
[
0
];
z35
<=
{
z35
,
z38
==
4
};
z41
<=
z13
[
z55
]
&&
z14
&&
!
z41
&&
!
z46
&&
!
z56
&&
z52
;
z42
<=
(
z45
&&
z77
)
||
(
z42
&&
!
z35
[
2
]
&&
!
z8
);
z43
<=
(
z45
&&
z66
)
||
(
z43
&&
!
z35
[
0
]
&&
!
z8
);
z44
<=
z43
;
z45
<=
z41
||
(
z45
&&
!
z79
&&
!
z8
);
z46
<=
z78
;
z56
<=
z82
;
if
(
z41
)
z34
<=
z80
;
if
(
z77
)
z38
<=
z59
[
11
:
0
];
else
if
(
z42
)
z38
<=
z38
-
1
;
if
(
z77
)
z47
<=
z59
[
12
];
if
(
z77
)
z48
<=
z59
[
13
];
if
(
z77
)
z49
<=
z59
[
14
];
if
(!
z78
)
z36
<=
z81
;
else
if
(
z68
)
z36
<=
z39
[
7
:
0
];
else
if
(!
z43
)
z36
<=
z36
+
1
;
if
(!
z45
||
z43
||
z44
)
z39
<=
0
;
else
z39
<=
z59
;
if
(
z8
)
z55
<=
0
;
else
if
(
z82
)
z55
<=
!
z55
;
end
assign
z9
=
(
NC
<
2
)?
z42
:
{
!
z42
&&
z55
,
z42
&&
z55
,
z42
&&
!
z55
};
wire
[
3
:
0
]
z83
;
reg
[
3
:
0
]
z84
;
wire
[
4
:
0
]
z85
=
{
z1
,
z83
}
+
z63
+
z54
;
always
@(
posedge
clk
)
begin
if
(
z69
)
z84
<=
z63
;
else
if
(
z70
)
z84
<=
z85
;
if
(
z73
)
z53
<=
z64
[
0
];
else
if
(
z75
)
z53
<=
z54
^
z64
[
0
];
if
(
z74
)
z54
<=
z64
[
1
];
else
if
(
z70
)
z54
<=
z85
[
4
];
if
(
z51
)
z40
<=
{
4
{
pdata
[
5
]}};
else
if
(
z65
)
z40
[
z34
]
<=
z54
;
end
wire
z86
=
pwr
&&
!
z72
;
wire
[
9
:
0
]
z87
=
z72
?
{
z34
,
z61
}
:
paddr
[
11
:
2
];
wire
[
12
:
0
]
z88
=
{
z34
,
z62
};
wire
[
31
:
0
]
z89
;
dpram
#
(
4
,
4
,
32
)
rhdr
(
clk
,
z2
,
z88
,
z71
&
z53
,
z84
,
z83
,
clk
,
z2
,
z87
,
z86
,
pdata
,
z89
);
reg
z90
,
z10
,
z91
;
reg
[
1
:
0
]
z92
,
z93
;
reg
[
31
:
0
]
z20
;
wire
[
31
:
0
]
z19
;
always
@(
posedge
clk
)
begin
z92
<=
z72
?
3
:
z48
?
2
:
z47
?
1
:
0
;
z90
<=
z72
||
z42
;
z10
<=
z90
;
z91
<=
z42
&&
z49
;
if
(
z72
)
z93
<=
0
;
else
if
(
z91
)
z93
<=
(
z93
==
3
)?
1
:
z93
+
1
;
z20
<=
z19
;
end
mux4xNp
#
(
DBW
)
dom
(
z19
,
z17
,
{
z17
[
23
:
16
],
z17
[
31
:
24
],
z17
[
7
:
0
],
z17
[
15
:
8
]},
{
z17
[
7
:
0
],
z17
[
15
:
8
],
z17
[
23
:
16
],
z17
[
31
:
24
]},
z89
,
z92
,
clk
);
`ifdef NIO_SWAP12
mux4xN
#
(
DBW
)
dox
(
z18
,
z19
,
{
z17
[
3
:
0
],
z19
[
31
:
28
],
z19
[
19
:
12
],
z19
[
3
:
0
],
z19
[
23
:
20
],
z19
[
11
:
4
]},{
z19
[
19
:
16
],
z17
[
7
:
4
],
z19
[
27
:
20
],
z19
[
11
:
4
],
z20
[
27
:
24
],
z19
[
15
:
12
]},{
z19
[
27
:
20
],
z19
[
11
:
8
],
z19
[
31
:
28
],
z19
[
19
:
12
],
z19
[
3
:
0
],
z20
[
31
:
28
]},
z93
);
`else
assign
z18
=
z19
;
`endif
assign
test
=
{
z9
,
z42
,
z13
,
z55
,
z90
};
assign
pdatar
=
z89
;
endmodule
module
pkt2eth
(
clk
,
z8
,
trdy
,
tval
,
tvax
,
tbus
,
z26
,
z28
);
parameter
DBW
=
32
;
input
clk
,
z8
;
output
trdy
;
input
tval
,
tvax
;
input
[
31
:
0
]
tbus
;
output
[
3
:
0
]
z26
;
output
[
31
:
0
]
z28
;
wire
z1
=
0
,
z2
=
1
;
wire
[
31
:
0
]
z94
;
wire
[
31
:
0
]
z95
=
~
z94
;
reg
[
63
:
0
]
z96
;
reg
[
31
:
0
]
z28
;
reg
[
3
:
0
]
z26
;
reg
z97
,
z98
;
wire
z99
=
tval
&&
!
z97
;
wire
z100
=
z97
&&
!(
tval
|
tvax
);
wire
z101
;
delaypipe
#
(
1
)
dlst1
(
clk
,
z99
,
z101
);
wire
z102
;
delaypipe
#
(
2
)
dlst2
(
clk
,
z99
,
z102
);
wire
z103
;
delaypipe
#
(
2
)
dlval
(
clk
,
tval
|
tvax
,
z103
);
wire
z104
;
delaypipe
#
(
2
)
dlend
(
clk
,
z100
,
z104
);
wire
z105
;
delaypipe
#
(
3
)
dlvax
(
clk
,
tvax
,
z105
);
delaypipe
#
(
3
)
dlrdy
(
clk
,!
z97
,
trdy
);
always
@(
posedge
clk
)
begin
z98
<=
tvax
;
z97
<=
tval
||
tvax
;
z96
<=
z98
?
{
z95
,
z96
[
47
:
32
]}
:
z100
?
{
z95
,
z96
[
63
:
32
]}
:
{
tbus
,
z96
[
63
:
32
]};
z28
<=
z99
?
32'h555555FB
:
z101
?
32'hD5555555
:
z103
?
z96
[
47
:
16
]
:
z105
?
32'h070707FD
:
z104
?
{
16'h07FD
,
z96
[
31
:
16
]}
:
32'h07070707
;
z26
<=
z99
?
4'h1
:
z101
?
4'h0
:
z103
?
4'h0
:
z105
?
4'hF
:
z104
?
4'hC
:
4'hF
;
end
crc32_d32
txcrc
(
clk
,
z1
,!
z97
,
tval
,
tvax
,
tbus
,
z94
);
endmodule
module
eth2pkt
(
clk
,
rst
,
z26
,
z28
,
z90
,
obus
,
pena
,
pbus
);
parameter
DBW
=
32
;
parameter
NP
=
12
;
input
clk
,
rst
;
input
[
3
:
0
]
z26
;
input
[
31
:
0
]
z28
;
output
z90
,
pena
;
output
[
31
:
0
]
obus
,
pbus
;
wire
z1
=
0
,
z2
=
1
;
reg
[
63
:
0
]
z96
;
reg
z106
,
z107
,
z99
,
z108
,
z109
;
reg
[
NP
-
1
:
0
]
z110
;
wire
z100
=
z107
&&
!
z106
;
always
@(
posedge
clk
)
begin
if
(
rst
)
z106
<=
0
;
else
z106
<=
z106
?
(
z26
==
0
)
:
(
z26
==
4'h1
&&
z28
==
32'h555555FB
);
if
(
rst
)
z107
<=
0
;
else
z107
<=
z106
;
if
(
rst
)
z99
<=
0
;
else
z99
<=
(
z110
==
8
);
if
(!
z107
)
z110
<=
0
;
else
z110
<=
z110
+
1
;
z96
<=
{
z28
,
z96
[
63
:
32
]};
z108
<=
z99
;
z109
<=
z100
;
end
assign
z90
=
z106
;
assign
obus
=
z96
[
47
:
16
];
assign
pena
=
z99
||
z100
;
assign
pbus
=
{
z109
,
z108
,
2'b0
,
z110
,
2'b0
};
endmodule
module
pkt2dat
(
clk
,
rst
,
pwr
,
paddr
,
pdata
,
pdatar
,
z107
,
tbus
,
oval
,
obus
);
parameter
DBW
=
32
;
parameter
NP
=
12
;
parameter
INST
=
0
;
input
clk
,
rst
;
input
pwr
;
input
[
15
:
0
]
paddr
;
input
[
31
:
0
]
pdata
;
output
[
31
:
0
]
pdatar
;
input
z107
;
input
[
31
:
0
]
tbus
;
output
oval
;
output
[
31
:
0
]
obus
;
wire
z1
=
0
,
z2
=
1
;
reg
z111
;
reg
[
31
:
0
]
z112
,
z113
,
z114
,
z115
;
wire
z99
=
z107
&&
!
z111
;
wire
z100
=
!
z107
&&
z111
;
wire
[
1
:
0
]
z34
=
INST
;
wire
z8
=
rst
||
z112
[
0
];
wire
[
31
:
0
]
z116
=
{
16'h01CE
,
3'h0
,
z8
,
2'h0
,
z34
};
always
@(
posedge
clk
)
begin
if
(
pwr
)
z112
<=
pdata
;
if
(
z107
)
z115
<=
tbus
;
z111
<=
z107
;
if
(
z8
)
z114
<=
0
;
else
if
(
z100
)
z114
<=
z114
+
1
;
if
(
z8
)
z113
<=
~
0
;
else
if
(
z107
)
z113
<=
z113
^
tbus
;
end
muxMxNp
#
(
4
,
32
)
rm
(
pdatar
,
{
z115
,
z116
,
z113
,
z114
},
paddr
[
3
:
2
],
clk
);
assign
oval
=
z111
;
assign
obus
=
z115
;
endmodule
`define Z117 1
`include "../lib/crc32.v"
