`ifndef BOT_ORDER
`define BOT_ORDER 10
`endif
module
botengine
(
sclk
,
rst
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
parameter
PORT
=
1
;
parameter
IBW
=
64
;
parameter
DBW
=
16
;
localparam
CBW
=
18
;
localparam
CBX
=
16
;
localparam
UBW
=
18
;
localparam
WBW
=
UBW
;
localparam
XBW
=
UBW
;
localparam
MA
=`BOT_ORDER
;
localparam
MPP
=
3
;
`ifdef BOT_RAW
localparam
MRF
=
1
;
localparam
YBW
=
32
;
localparam
ZBW
=
32
;
`else
localparam
MRF
=
6
;
localparam
YBW
=
UBW
;
localparam
ZBW
=
DBW
;
`endif
`ifdef BOT_I2X
localparam
NPC
=
2
;
localparam
NIC
=
1
;
`else
localparam
NPC
=
1
;
localparam
NIC
=
3
;
`endif
input
sclk
;
input
rst
;
input
scs
;
input
swr
;
input
srd
;
input
[
31
:
0
]
saddr
;
input
[
31
:
0
]
swrbus
;
output
[
31
:
0
]
srdbus
;
output
sack
;
input
ioclk
;
output
istat
;
input
iena
;
input
[
7
:
0
]
isel
;
input
[
IBW
-
1
:
0
]
ibus
;
output
ostat
;
input
oena
;
output
[
MA
-
1
:
0
]
osel
;
output
[
IBW
-
1
:
0
]
obus
;
output
[
7
:
0
]
test
;
wire
z1
=
0
,
z2
=
1
;
assign
sack
=
z2
;
wire
z3
,
z4
,
z5
,
z6
,
z7
;
wire
z8
,
z9
,
z10
,
z11
;
wire
[
NPC
*
2
*
DBW
-
1
:
0
]
z12
;
wire
[
NPC
*
2
*
WBW
-
1
:
0
]
z13
;
wire
[
NPC
*
2
*
XBW
-
1
:
0
]
z14
;
wire
[
NPC
*
2
*
YBW
-
1
:
0
]
z15
;
wire
[
NPC
*
2
*
ZBW
-
1
:
0
]
z16
;
reg
z17
,
z18
,
z19
,
z20
,
z21
;
reg
[
31
:
0
]
z22
;
reg
[
15
:
0
]
z23
,
z24
;
reg
[
MA
:
0
]
z25
,
z26
;
reg
[
MPP
-
1
:
0
]
z27
;
reg
[
7
:
0
]
z28
,
z29
;
wire
[
31
:
0
]
z30
;
statusblkdbg
#
(
"BOT"
,
MA
,
MPP
,
MRF
,
NPC
)
rs
(
sclk
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
sclk
,
z30
);
wire
[
11
:
0
]
z31
;
swrbank
#
(
0
,
12
)
swb
(
sclk
,
scs
,
swr
,
saddr
,
z31
);
wire
z32
=
z31
[
0
];
wire
z33
=
z31
[
1
];
wire
z34
=
z31
[
2
];
wire
z35
=
z31
[
4
];
wire
z36
=
z31
[
5
];
wire
z37
=
z31
[
6
];
wire
z38
=
z31
[
7
];
wire
z39
=
z31
[
8
];
wire
z40
=
z31
[
9
];
wire
z41
=
z31
[
10
];
wire
z42
=
z31
[
11
];
reg
z43
,
z44
,
z45
,
z46
;
always
@(
posedge
sclk
)
begin
z21
<=
rst
||
!
z22
[
0
];
if
(
z32
)
z22
<=
swrbus
;
if
(
z36
)
z25
<=
swrbus
;
if
(
z36
)
z28
<=
swrbus
[
23
:
16
];
if
(
z33
)
z26
<=
swrbus
;
if
(
z34
)
z23
<=
swrbus
;
if
(
z40
)
z27
<=
swrbus
;
if
(
z38
)
z24
<=
swrbus
;
end
wire
z47
=
z22
[
0
];
wire
[
3
:
0
]
z48
=
z22
[
11
:
8
];
wire
[
3
:
0
]
z49
=
z22
[
15
:
12
];
wire
z50
=
z24
[
0
];
wire
z51
=
z24
[
1
]
||
(
MRF
==
1
);
wire
z52
=
z22
[
3
];
wire
z53
=
!
z52
;
wire
z54
=
z24
[
2
];
wire
z55
=
z24
[
3
];
wire
z56
=
!
z49
[
3
]
&&
(
MRF
!=
1
);
wire
[
3
:
0
]
z57
=
{
z47
,
z50
,
z24
[
9
:
8
]};
wire
[
MA
:
0
]
z58
=
z53
?
z26
:
z26
>>
1
;
wire
[
MA
:
0
]
z59
=
z53
?
{
z25
,
z2
}
:
z25
;
wire
[
7
:
0
]
z60
;
localparam
SIDE
=(
PORT
-
1
)%
2
;
reg
z61
,
z62
,
z63
,
z64
,
z65
;
reg
[
31
:
0
]
z66
;
reg
[
1
:
0
]
z67
;
wire
[
1
:
0
]
z68
,
z69
;
wire
z70
=
z52
?
SIDE
:
0
;
assign
z68
[
0
]
=
(
NPC
>
1
)?
(
z53
?
z62
&&!
z61
:
z63
&&(
z61
==
SIDE
))
:
(
z53
?
z62
:
z62
&&(
z61
==
SIDE
)
);
assign
z68
[
1
]
=
(
NPC
>
1
)?
(
z53
?
z62
&&
z61
:
z63
&&(
z61
==
SIDE
))
:
z1
;
assign
z69
[
0
]
=
(
NPC
>
1
)?
(
z53
?
z65
&&!
z61
:
z65
&&(
z61
==
SIDE
))
:
(
z53
?
z65
:
z65
&&(
z61
==
SIDE
)
);
assign
z69
[
1
]
=
(
NPC
>
1
)?
(
z53
?
z65
&&
z61
:
z62
&&(
z61
==
SIDE
))
:
z1
;
always
@(
posedge
sclk
)
begin
z62
<=
z37
;
z63
<=
z62
;
z64
<=
z63
;
z65
<=
z64
;
if
(
z32
)
z61
<=
z2
;
else
if
(
z65
)
z61
<=
!
z61
;
if
(
z37
)
z66
<=
swrbus
;
else
if
(
z62
)
z66
<=
z66
<<
1
;
else
if
(
z64
)
z66
<=
0
;
if
(
z21
)
z67
<=
z70
;
else
if
(
z11
)
z67
<=
z67
+(
z52
?
2
:
1
);
end
always
@(
posedge
sclk
)
z17
<=
(
z5
&&
z3
)
&&
!(
NPC
==
1
&&
z53
&&
z17
);
always
@(
posedge
sclk
)
z18
<=
z17
;
always
@(
posedge
sclk
)
z19
<=
z17
||
(
NPC
==
1
&&
z53
&&
z18
);
always
@(
posedge
ioclk
)
z20
<=
iena
;
fifoNxMfmt
#
(
IBW
,
DBW
*
2
,
0
,
NPC
)
fi
(
ioclk
,
z21
,
z48
,
istat
,
z20
,
ibus
,
sclk
,
z21
,
{
z52
,
4'h8
},
z3
,
z17
,
z12
);
cxtuner
#
(
DBW
,
CBX
,
WBW
,
NIC
,
NPC
)
cxt
(
sclk
,
z21
,
z68
,
z69
,
z66
,
{
z53
,
z19
},
z12
,
z8
,
z13
);
fppfilter
#
(
MPP
,
MA
,
WBW
,
CBW
,
XBW
,
NIC
,
NPC
)
ppf
(
sclk
,
z21
,
z27
,
z25
,
z41
,
swrbus
,
{
z53
,
z8
},
z13
,
z9
,
z14
);
cfft
#
(
MA
,
XBW
,
CBW
,
YBW
,
NIC
,
NPC
)
fft
(
sclk
,
z21
,
z1
,
z28
,
z25
,
z23
,
z5
,{
z53
,
z9
},
z14
,
z6
,
z10
,
z15
,
z60
);
mresampler
#
(
MRF
,
MA
,
YBW
,
CBW
,
ZBW
,
NPC
)
mres
(
sclk
,
z21
,
z51
,
z56
,
z59
,
z58
,
z35
,
z42
,
swrbus
,
z6
,
z10
,
z15
,
z7
,
z11
,
z16
);
wire
[
ZBW
*
2
-
1
:
0
]
z71
=
{
z16
[
ZBW
*
2
-
1
:
ZBW
+
1
],
z54
?
z67
[
1
]:
z16
[
ZBW
],
z16
[
ZBW
-
1
:
1
],
z54
?
z67
[
0
]:
z16
[
0
]};
fifoNxMpkt8fe
#
(
ZBW
*
2
,
IBW
,
0
,
5
,
0
,
0
,
MA
)
fo
(
sclk
,
z21
,
z7
,
z11
,
z71
,
ioclk
,
z21
,
ostat
,
oena
,
obus
,
z50
,
z58
,
osel
);
assign
test
=
{
z57
,
oena
,
z11
,
z10
,
z9
};
endmodule
module
fppfilter
(
clk
,
rst
,
taps
,
size
,
sload
,
sbus
,
vinc
,
din
,
vout
,
dout
);
parameter
MT
=
3
;
parameter
MA
=
10
;
parameter
IBW
=
16
;
parameter
CBW
=
16
;
parameter
OBW
=
16
;
parameter
NIC
=
1
;
parameter
NPC
=
1
;
localparam
MTAP
=
2
**
MT
;
localparam
MB
=(
NIC
==
2
)?
MA
+
1
:
MA
;
localparam
GBW
=
3
;
localparam
PBW
=
IBW
+
CBW
-
1
;
localparam
SBW
=
PBW
+
GBW
;
localparam
RBW
=
6
;
localparam
BPD
=(
IBW
>
18
)?
8
:
4
;
localparam
BPC
=(
CBW
>
18
)?
4
:
2
;
localparam
KRD
=(
1
<<
MB
)*
BPD
/
1024
;
localparam
KRC
=(
1
<<
MA
)*
BPC
/
1024
;
input
clk
,
rst
;
input
[
MT
-
1
:
0
]
taps
;
input
[
MA
-
1
:
0
]
size
;
input
sload
;
input
[
31
:
0
]
sbus
;
input
[
1
:
0
]
vinc
;
input
[
NPC
*
2
*
IBW
-
1
:
0
]
din
;
output
vout
;
output
[
NPC
*
2
*
OBW
-
1
:
0
]
dout
;
wire
z1
=
0
,
z2
=
1
;
wire
z72
=
vinc
[
0
];
wire
z53
=
(
NIC
>
1
)
&&
vinc
[
1
];
wire
z52
=
(
NPC
>
1
)
&&
!
vinc
[
1
];
reg
[
MT
-
1
:
0
]
z73
;
reg
[
MB
-
1
:
0
]
z74
,
z75
,
z76
,
z77
;
reg
z78
,
z79
;
wire
z80
;
delaypipe
#
(
5
)
ogos
(
clk
,
z72
,
z80
);
wire
z81
=
(
z74
==
z77
)
&&
z72
;
wire
z82
=
(
z75
==
z77
)
&&
z80
;
wire
z83
=
(
z73
==
taps
);
always
@(
posedge
clk
)
begin
z77
<=
z52
?
size
>>
1
:
z53
?
{
size
,
z2
}
:
size
;
if
(
rst
|
z81
)
z74
<=
0
;
else
if
(
z72
)
z74
<=
z74
+
1
;
if
(
rst
|
z82
)
z75
<=
0
;
else
if
(
z80
)
z75
<=
z75
+
1
;
z76
<=
z75
;
z78
<=
z80
;
if
(
rst
)
z73
<=
0
;
else
if
(
z82
)
z73
<=
z73
+
1
;
if
(
rst
)
z79
<=
0
;
else
z79
<=
z79
||
z83
;
end
delaypipe
#
(
4
+
MT
)
rdys
(
clk
,
z80
&(
z83
|
z79
),
vout
);
wire
[
MA
-
1
:
0
]
z84
=
sbus
[
MA
-
1
:
0
];
wire
[
CBW
-
1
:
0
]
z85
=
sbus
[
32
-
1
:
32
-
CBW
];
wire
signed
[
MT
:
0
]
z86
=
taps
;
genvar
n
,
i
,
j
,
k
;
generate
for
(
n
=
0
;
n
<
NPC
;
n
=
n
+
1
)
begin
:
chx
localparam
k
=
n
*
2
;
wire
[
2
*
IBW
-
1
:
0
]
z87
[
MTAP
:
0
];
assign
z87
[
0
]
=
din
[(
2
+
k
)*
IBW
-
1
:(
0
+
k
)*
IBW
];
wire
signed
[
CBW
-
1
:
0
]
z88
[
MTAP
-
1
:
0
],
z89
[
MTAP
:
0
];
reg
signed
[
PBW
-
1
:
0
]
z90
[
MTAP
-
1
:
0
],
z91
[
MTAP
-
1
:
0
];
reg
signed
[
SBW
-
1
:
0
]
z92
[
MTAP
-
1
:
0
][
MT
-
1
:
0
],
z93
[
MTAP
-
1
:
0
][
MT
-
1
:
0
];
for
(
i
=
0
;
i
<
MTAP
;
i
=
i
+
1
)
begin
:
tap
sdpram
#
(
KRD
,
2
*
IBW
,
2
*
IBW
)
dram
(
clk
,
z2
,
(
i
==
0
)?
z74
:
z76
,(
i
==
0
)?
z72
:
z78
,
z87
[
i
],
clk
,
z2
,
z75
,
z87
[
i
+
1
]);
reg
z94
;
wire
signed
[
MT
:
0
]
z95
=
i
;
reg
signed
[
CBW
-
1
:
0
]
z96
;
reg
signed
[
IBW
-
1
:
0
]
z97
,
z98
;
assign
z89
[
0
]
=
z85
;
wire
[
MB
-
1
:
0
]
z99
=
z52
?
{
z75
,(
n
&
1
)?
z2
:
z1
}
:
z53
?
z75
>>
1
:
z75
;
dpram
#
(
KRC
,
CBW
,
CBW
)
cram
(
clk
,
z2
,
z84
,
sload
,
z89
[
i
],
z89
[
i
+
1
],
clk
,
z2
,
z99
,
z1
,
z1
,
z88
[
i
]);
always
@(
posedge
clk
)
begin
z94
<=
(
z95
>
z86
);
z96
<=
z88
[
i
];
z97
<=
z87
[
i
+
1
][
1
*
IBW
-
1
:
0
*
IBW
];
z98
<=
z87
[
i
+
1
][
2
*
IBW
-
1
:
1
*
IBW
];
if
(
z94
)
z90
[
i
]
<=
0
;
else
z90
[
i
]
<=
z97
*
z96
;
if
(
z94
)
z91
[
i
]
<=
0
;
else
z91
[
i
]
<=
z98
*
z96
;
end
end
for
(
j
=
0
;
j
<
MT
;
j
=
j
+
1
)
begin
:
stage
for
(
i
=
0
;
i
<(
2
**
j
);
i
=
i
+
1
)
begin
:
stap
always
@(
posedge
clk
)
z92
[
i
][
j
]
<=
(
j
+
1
==
MT
)?
z90
[
i
+
i
]
+
z90
[
i
+
i
+
1
]
:
z92
[
i
+
i
][
j
+
1
]
+
z92
[
i
+
i
+
1
][
j
+
1
];
always
@(
posedge
clk
)
z93
[
i
][
j
]
<=
(
j
+
1
==
MT
)?
z91
[
i
+
i
]
+
z91
[
i
+
i
+
1
]
:
z93
[
i
+
i
][
j
+
1
]
+
z93
[
i
+
i
+
1
][
j
+
1
];
end
end
wire
signed
[
SBW
-
1
:
0
]
z100
=
z92
[
0
][
0
];
roundN2M
#
(
OBW
+
RBW
,
OBW
)
rndr
(
z100
[
SBW
-
GBW
-
1
:
SBW
-
GBW
-
OBW
-
RBW
],
dout
[(
k
+
1
)*
OBW
-
1
:(
k
+
0
)*
OBW
],
clk
);
wire
signed
[
SBW
-
1
:
0
]
z101
=
z93
[
0
][
0
];
roundN2M
#
(
OBW
+
RBW
,
OBW
)
rndi
(
z101
[
SBW
-
GBW
-
1
:
SBW
-
GBW
-
OBW
-
RBW
],
dout
[(
k
+
2
)*
OBW
-
1
:(
k
+
1
)*
OBW
],
clk
);
end
endgenerate
endmodule
module
mresampler
(
clk
,
rst
,
oraw_
,
oreal_
,
size
,
z26
,
sratio
,
sload
,
sbus
,
virdy
,
z72
,
din
,
vordy
,
vout
,
dout
);
parameter
MT
=
6
;
parameter
MA
=
10
;
parameter
IBW
=
16
;
parameter
CBW
=
16
;
parameter
OBW
=
16
;
parameter
NPC
=
1
;
localparam
MPT
=
6
;
localparam
MIT
=
16
;
localparam
BPW
=(
IBW
>
18
)?
8
:
4
;
localparam
TAP
=(
2
**
MT
);
localparam
KDR
=(
1
<<
MA
)*
BPW
/
1024
;
localparam
KCR
=
4096
*
2
/
1024
;
localparam
GBW
=
4
;
localparam
RBW
=
6
;
localparam
PBW
=
IBW
+
CBW
-
1
;
localparam
SBW
=
PBW
+
GBW
;
input
clk
,
rst
,
oraw_
,
oreal_
;
input
[
MA
-
1
:
0
]
size
,
z26
;
input
sratio
,
sload
;
input
[
31
:
0
]
sbus
;
input
z72
,
vordy
;
input
[
2
*
IBW
*
NPC
-
1
:
0
]
din
;
output
vout
,
virdy
;
output
[
2
*
OBW
-
1
:
0
]
dout
;
wire
z1
=
0
,
z2
=
1
;
reg
z80
,
z83
,
z51
,
z56
,
z102
,
z103
,
z104
,
z105
,
z106
,
z107
,
z108
,
z109
;
reg
[
MA
-
1
:
0
]
z74
,
z75
,
z110
;
reg
[
MT
-
1
:
0
]
z111
,
z73
,
z112
,
z113
;
reg
[
2
*
IBW
*
NPC
-
1
:
0
]
z114
;
reg
[
31
:
0
]
z115
;
reg
[
MT
-
1
+
30
:
0
]
z61
;
always
@(
posedge
clk
)
begin
z51
<=
oraw_
;
z56
<=
oreal_
;
z103
<=
rst
;
end
wire
[
MT
-
1
:
0
]
z116
=
~
0
;
wire
[
MT
-
1
:
0
]
z117
=
z111
-
z112
;
wire
[
MT
-
1
:
0
]
z118
=
~
0
;
wire
z119
;
wire
z81
=
z72
&&
z104
;
wire
z82
=
z80
&&
z105
;
wire
z120
=
z81
&&
(
z111
==
z116
);
wire
z121
=
z82
&&
(
z73
==
z116
);
wire
z122
=
z117
[
MT
-
1
];
always
@(
posedge
clk
)
begin
if
(
rst
)
z104
<=
0
;
else
if
(
z72
)
z104
<=
(
z74
[
MA
-
1
:
NPC
]==
size
[
MA
-
1
:
NPC
])
&&
!
z74
[
NPC
-
1
];
if
(
rst
)
z106
<=
0
;
else
if
(
z72
)
z106
<=
(
z74
[
MA
-
1
:
NPC
]==
z26
[
MA
-
1
:
NPC
])
&&
!
z74
[
NPC
-
1
];
if
(
rst
)
z105
<=
0
;
else
if
(
z80
)
z105
<=
(
z75
[
MA
-
1
:
1
]
==
z26
[
MA
-
1
:
1
])
&&
!
z75
[
0
];
if
(
rst
)
z107
<=
1
;
else
if
(
z72
)
z107
<=
z104
;
if
(
rst
)
z108
<=
1
;
else
if
(
z80
)
z108
<=
z105
;
z109
<=
z72
;
z114
<=
din
;
z110
<=
z74
>>(
NPC
-
1
);
if
(
rst
)
z83
<=
z1
;
else
z83
<=
z120
||
z83
;
if
(
rst
|
z120
)
z111
<=
0
;
else
if
(
z81
)
z111
<=
z111
+
1
;
if
(
rst
|
z121
)
z73
<=
0
;
else
if
(
z82
)
z73
<=
z73
+
1
;
if
(
rst
|
z81
)
z74
<=
0
;
else
if
(
z72
)
z74
<=
z74
+
NPC
;
if
(
rst
|
z82
)
z75
<=
0
;
else
if
(
z80
)
z75
<=
z75
+
1
;
if
(
rst
|
z120
)
z113
<=
0
;
else
if
(
z81
)
z113
<=
z111
;
z80
<=
vordy
&&
!
z122
&&
z83
&&
!
z119
;
z102
<=
((
z117
<
2
||
z122
)
||
!
z83
)
&&
!
z119
;
end
wire
[
CBW
-
1
:
0
]
z85
=
sbus
[
32
-
1
:
32
-
CBW
];
wire
[
MT
+
MPT
-
1
:
0
]
z84
=
sbus
[
MT
+
MPT
-
1
:
0
];
reg
signed
[
CBW
-
1
:
0
]
z96
[
TAP
:
0
];
reg
z123
,
z124
,
z125
,
z126
,
z127
,
z128
;
reg
[
MT
-
1
:
0
]
z129
,
z130
;
reg
[
MIT
:
0
]
z131
,
z132
;
wire
[
MPT
-
1
:
0
]
z133
=
z61
[
30
-
1
:
30
-
MPT
];
wire
[
MIT
:
0
]
z134
=
z61
[
30
-
MPT
-
1
:
30
-
MPT
-
MIT
];
wire
[
MIT
:
0
]
z135
=
{
z2
,{
MIT
{
z1
}}};
wire
[
MT
-
1
:
0
]
z136
=
z61
[
MT
-
1
+
30
:
30
];
wire
[
MT
+
MPT
-
1
:
0
]
z137
=
rst
?
z84
:
{
z130
,
z133
};
wire
[
MT
+
MPT
-
1
:
0
]
z138
=
{
z130
,
z133
}+
1
;
wire
signed
[
CBW
-
1
:
0
]
z139
,
z140
,
z141
,
z142
;
reg
signed
[
CBW
-
1
:
0
]
z143
,
z144
;
reg
signed
[
CBW
-
1
+
MIT
:
0
]
z145
,
z146
,
z88
;
dpram
#
(
KCR
,
CBW
,
CBW
)
cram
(
clk
,
z2
,
z137
,
sload
,
z85
,
z139
,
clk
,
z2
,
z138
,
z1
,
z1
,
z140
);
always
@(
posedge
clk
)
begin
if
(
sratio
)
z115
<=
sbus
;
if
(
rst
)
z61
<=
0
;
else
if
(
z123
)
z61
<=
z61
+
z115
;
z125
<=
sload
&&
(
z84
[
MPT
-
1
:
0
]==
0
);
z124
<=
z127
||
z125
;
z131
<=
z134
;
z132
<=
z135
-
z134
;
z143
<=
z139
;
z144
<=
z140
;
z145
<=
z143
*
$signed
({
z1
,
z132
});
z146
<=
z144
*
$signed
({
z1
,
z131
});
z88
<=
z145
+
z146
;
z123
<=
z108
&&
z80
&&
!
rst
;
z126
<=
z123
||
(
z126
&&
z129
!=
z118
&&
!
rst
);
z127
<=
z126
;
if
(!
z126
)
z129
<=
0
;
else
z129
<=
z129
+
1
;
z130
<=
z136
+
z129
;
if
(
rst
|
z82
)
z112
<=
z136
;
z128
<=
z126
&&
(
z130
==
1
);
end
wire
z147
;
srl16xNp
#
(
1
)
loads
(
clk
,
z2
,
4'h2
,
z124
,
z147
);
roundN2M
#
(
CBW
+
MIT
,
CBW
)
rndc
(
z88
,
z141
,
clk
);
assign
z142
=
!
z51
?
z141
:
z128
?
1
<<(
CBW
-
1
)
:
0
;
assign
z119
=
(
z105
||
z108
)
&&
z147
;
reg
signed
[
PBW
-
1
:
0
]
z148
[
TAP
-
1
:
0
],
z149
[
TAP
-
1
:
0
];
reg
signed
[
SBW
-
1
:
0
]
z150
[
TAP
-
1
:
0
][
MT
-
1
:
0
],
z151
[
TAP
-
1
:
0
][
MT
-
1
:
0
];
genvar
i
,
j
;
generate
for
(
i
=
0
;
i
<
TAP
;
i
=
i
+
1
)
begin
:
tap
reg
z152
;
wire
[
2
*
IBW
-
1
:
0
]
z87
;
reg
[
2
*
IBW
-
1
:
0
]
z153
;
reg
signed
[
IBW
-
1
:
0
]
z154
,
z155
;
reg
signed
[
CBW
-
1
:
0
]
z156
,
z157
;
sdpram
#
(
KDR
,
2
*
IBW
*
NPC
,
2
*
IBW
)
dram
(
clk
,
z2
,
z110
,
z152
,
z114
,
clk
,
z2
,
z75
,
z87
);
always
@(
posedge
clk
)
begin
z152
<=
z72
&&
(
z111
==
i
)
&&
!
rst
;
if
(
z147
)
z96
[
i
]
<=
(
i
==
0
)?
z142
:
z96
[
i
-
1
];
if
(
z123
)
z156
<=
z96
[
i
];
z157
<=
z156
;
z153
<=
z87
;
z154
<=
z153
[
IBW
-
1
:
0
];
z155
<=
z153
[
2
*
IBW
-
1
:
IBW
];
z148
[
i
]
<=
z154
*
z157
;
z149
[
i
]
<=
z155
*
z157
;
end
end
for
(
j
=
0
;
j
<
MT
;
j
=
j
+
1
)
begin
:
stage
for
(
i
=
0
;
i
<(
2
**
j
);
i
=
i
+
1
)
begin
:
stap
always
@(
posedge
clk
)
z150
[
i
][
j
]
<=
(
j
+
1
==
MT
)?
z148
[
i
+
i
]
+
z148
[
i
+
i
+
1
]
:
z150
[
i
+
i
][
j
+
1
]
+
z150
[
i
+
i
+
1
][
j
+
1
];
always
@(
posedge
clk
)
z151
[
i
][
j
]
<=
(
j
+
1
==
MT
)?
z149
[
i
+
i
]
+
z149
[
i
+
i
+
1
]
:
z151
[
i
+
i
][
j
+
1
]
+
z151
[
i
+
i
+
1
][
j
+
1
];
end
end
endgenerate
wire
signed
[
SBW
-
1
:
0
]
z100
=
z150
[
0
][
0
];
wire
signed
[
SBW
-
1
:
0
]
z101
=
z151
[
0
][
0
];
delaypipe
#
(
5
+
MT
)
rdys
(
clk
,
z80
,
vout
);
wire
signed
[
SBW
-
1
:
0
]
z158
,
z159
;
wire
z160
;
roundN2Mc
#
(
SBW
,
OBW
,
GBW
)
rndr
(
z100
,
z158
,
z2
,
z2
,
clk
,
z160
);
roundN2Mc
#
(
SBW
,
OBW
,
GBW
)
rndi
(
z101
,
z159
,
z2
,
z2
,
clk
,
z160
);
wire
signed
[
OBW
-
1
:
0
]
z161
=
z158
[
PBW
-
1
:
PBW
-
OBW
];
wire
signed
[
OBW
-
1
:
0
]
z162
=
z159
[
PBW
-
1
:
PBW
-
OBW
];
assign
dout
=
{
z162
,
z161
};
endmodule
