/* verilator lint_off CASEX */
/* verilator lint_off COMBDLY */
/* verilator lint_off REDEFMACRO */
`define pdly 0
module
aisengine
(
sclk
,
srst
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
parameter
PORT
=
1
;
parameter
IBW
=
64
;
parameter
SBW
=
32
;
parameter
DBW
=
32
;
input
sclk
;
input
srst
;
input
scs
;
input
swr
;
input
srd
;
input
[
31
:
0
]
saddr
;
input
[
31
:
0
]
swrbus
;
output
[
31
:
0
]
srdbus
;
output
sack
;
input
ioclk
;
output
istat
;
input
iena
;
input
[
7
:
0
]
isel
;
input
[
IBW
-
1
:
0
]
ibus
;
output
ostat
;
input
oena
;
output
[
7
:
0
]
osel
;
output
[
IBW
-
1
:
0
]
obus
;
output
[
7
:
0
]
test
;
wire
z1
=
0
,
z2
=
1
;
assign
sack
=
z2
;
assign
osel
=
0
;
statusblk
#
(
"AIS"
,
0
)
ss
(
sclk
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
);
reg
[
31
:
0
]
z3
,
z4
,
z5
;
wire
z6
=
scs
&&
swr
&&
(
saddr
[
5
:
2
]==
0
);
wire
z7
=
scs
&&
swr
&&
(
saddr
[
5
:
2
]==
1
);
wire
z8
;
assign
#
`pdly
z8
=
(
swrbus
<
8
);
always
@(
posedge
sclk
)
begin
if
(
srst
)
z3
<=
0
;
else
if
(
z6
)
z3
<=
swrbus
;
casez
({
z8
,
z7
,
srst
})
3'bzz1
:
z4
<=
#
`pdly
8
;
3'b010
:
z4
<=
#
`pdly
swrbus
;
3'b110
:
z4
<=
#
`pdly
8
;
default
:
begin
end
endcase
end
wire
z9
=
z3
[
0
];
wire
z10
=
z3
[
1
];
wire
z11
=
z3
[
2
];
wire
z12
=
z3
[
3
];
wire
[
3
:
0
]
z13
=
z3
[
11
:
8
];
wire
[
3
:
0
]
z14
=
z3
[
15
:
12
];
wire
[
15
:
0
]
z15
=
z4
[
15
:
0
];
wire
z16
=
!
z9
;
wire
z17
,
z18
,
z19
,
z20
;
wire
[
DBW
-
1
:
0
]
z21
,
z22
;
reg
z23
;
always
@(
posedge
ioclk
)
z23
<=
iena
;
fifoNxMfmt
#
(
IBW
,
DBW
)
fi
(
ioclk
,
z16
,
z13
,
istat
,
z23
,
ibus
,
sclk
,
z16
,
4'h8
,
z19
,
z17
,
z21
);
ais
inst
(
sclk
,
z16
,
z15
,
z12
,
z19
,
z17
,
z21
,
z20
,
z18
,
z22
);
fifoNxMfmti
#
(
IBW
,
DBW
)
fo
(
ioclk
,
z16
,
z14
,
ostat
,
oena
,
obus
,
sclk
,
z16
,
4'h8
,
z20
,
z18
,
z22
);
assign
test
=
{
oena
,
ostat
,
iena
,
istat
,
z3
[
3
:
0
]};
endmodule
module
ais
(
clk
,
z16
,
z15
,
z12
,
z19
,
z17
,
z21
,
z20
,
z18
,
z22
);
parameter
POWSAMPS
=
19
;
parameter
PPREC
=
16
;
parameter
PSCALE
=
14
;
parameter
SPREC
=
22
;
parameter
ASIZE
=
64
+
SPREC
;
parameter
ABETA
=
12
;
parameter
APREC
=
10
;
parameter
ADJSCALE
=
APREC
+
PSCALE
;
parameter
PLEVSHIFT
=
ASIZE
-
32
;
input
clk
,
z16
,
z12
,
z19
,
z20
;
input
[
15
:
0
]
z15
;
input
signed
[
31
:
0
]
z21
;
output
z17
,
z18
;
output
signed
[
31
:
0
]
z22
;
reg
z17
,
z24
;
reg
[
1
:
0
]
z25
;
reg
[
5
:
0
]
z26
;
reg
[
6
:
0
]
z27
;
reg
[
17
:
0
]
z28
,
z29
;
reg
[
31
:
0
]
z22
;
reg
signed
[
15
:
0
]
z30
,
z31
,
z32
,
z33
,
z34
,
z35
;
reg
signed
[
15
+
PPREC
:
0
]
z36
;
reg
signed
[
ASIZE
:
0
]
z37
,
z38
,
z39
;
reg
signed
[
15
+
SPREC
:
0
]
z40
,
z41
,
z42
,
z43
,
z44
,
z45
,
z46
,
z47
;
wire
[
15
:
0
]
z48
;
wire
[
ASIZE
:
0
]
z49
,
z50
,
z51
,
z52
,
z53
,
z54
,
z55
;
wire
signed
[
15
:
0
]
z56
,
z57
,
z58
,
z59
;
wire
signed
[
15
+
PPREC
:
0
]
z60
;
wire
signed
[
15
:
0
]
z61
,
z62
;
wire
signed
[
15
+
PPREC
:
0
]
z63
;
wire
signed
[
ASIZE
:
0
]
z64
;
reg
signed
[
ASIZE
:
0
]
z65
,
z66
,
z67
,
z68
,
z69
;
reg
signed
[
ASIZE
:
0
]
z70
,
z71
;
wire
signed
[
31
:
0
]
z72
;
wire
signed
[
ASIZE
-
SPREC
:
0
]
z73
,
z74
,
z75
;
wire
signed
[
ASIZE
-
1
:
0
]
z76
;
wire
signed
[
ASIZE
-(
PSCALE
+
SPREC
):
0
]
scaledr
,
scaledi
;
wire
signed
[
ASIZE
-(
PSCALE
+
SPREC
)+
1
:
0
]
aden
;
wire
signed
[(
15
+
SPREC
):
0
]
re_filt
,
im_filt
;
wire
signed
[(
31
+
2
*
SPREC
):
0
]
crl
,
rr
,
ii
;
wire
signed
[(
32
+
2
*
SPREC
):
0
]
cil
;
wire
signed
[(
33
+
2
*
SPREC
):
0
]
bl
;
`ifdef SYNTHESIS
`else
initial
begin
end
`endif
assign
z18
=
z24
;
assign
#
`pdly
z61
=
(
z34
<
0
)
?
-
z34
:
z34
;
assign
#
`pdly
z62
=
(
z35
<
0
)
?
-
z35
:
z35
;
assign
#
`pdly
z63
=
(
z61
+
z62
)
<<<
(
PPREC
-
1
)
;
assign
#
`pdly
z60
=
z36
+
(
(
z63
-
z36
)>>>
POWSAMPS
);
assign
#
`pdly
z48
=
(
z36
>>
PPREC
);
always
@*
begin
casex
({
z16
,
z48
})
17'b0_1xxx_xxxx_xxxx_xxxx
:
z26
<=
#
`pdly
25
;
17'b0_01xx_xxxx_xxxx_xxxx
:
z26
<=
#
`pdly
25
;
17'b0_001x_xxxx_xxxx_xxxx
:
z26
<=
#
`pdly
25
;
17'b0_0001_xxxx_xxxx_xxxx
:
z26
<=
#
`pdly
25
;
17'b0_0000_1xxx_xxxx_xxxx
:
z26
<=
#
`pdly
25
;
17'b0_0000_01xx_xxxx_xxxx
:
z26
<=
#
`pdly
25
;
17'b0_0000_001x_xxxx_xxxx
:
z26
<=
#
`pdly
26
;
17'b0_0000_0001_xxxx_xxxx
:
z26
<=
#
`pdly
26
;
17'b0_0000_0000_1xxx_xxxx
:
z26
<=
#
`pdly
27
;
17'b0_0000_0000_01xx_xxxx
:
z26
<=
#
`pdly
27
;
17'b0_0000_0000_001x_xxxx
:
z26
<=
#
`pdly
28
;
17'b0_0000_0000_0001_xxxx
:
z26
<=
#
`pdly
28
;
17'b0_0000_0000_0000_1xxx
:
z26
<=
#
`pdly
29
;
17'b0_0000_0000_0000_01xx
:
z26
<=
#
`pdly
29
;
default
:
z26
<=
#
`pdly
63
;
endcase
end
assign
#
`pdly
rr
=
z46
*
z46
;
assign
#
`pdly
ii
=
z47
*
z47
;
assign
#
`pdly
cil
=
(
z46
*
z47
)
<<<
1
;
assign
#
`pdly
bl
=
(
rr
+
ii
)
<<<
1
;
assign
#
`pdly
crl
=
rr
-
ii
;
assign
#
`pdly
z65
=
z37
+
((
bl
-
z37
)
>>>
z26
);
assign
#
`pdly
z66
=
z38
+
((
crl
-
z38
)
>>>
z26
);
assign
#
`pdly
z67
=
z39
+
((
cil
-
z39
)
>>>
z26
);
assign
#
`pdly
z72
=
z65
>>>
PLEVSHIFT
;
always
@*
begin
casex
(
z72
)
32'b1xxx_xxxx_xxxx_xxxx___xxxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
32
+
SPREC
);
32'b01xx_xxxx_xxxx_xxxx___xxxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
31
+
SPREC
);
32'b001x_xxxx_xxxx_xxxx___xxxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
30
+
SPREC
);
32'b0001_xxxx_xxxx_xxxx___xxxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
29
+
SPREC
);
32'b0000_1xxx_xxxx_xxxx___xxxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
28
+
SPREC
);
32'b0000_01xx_xxxx_xxxx___xxxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
27
+
SPREC
);
32'b0000_001x_xxxx_xxxx___xxxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
26
+
SPREC
);
32'b0000_0001_xxxx_xxxx___xxxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
25
+
SPREC
);
32'b0000_0000_1xxx_xxxx___xxxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
24
+
SPREC
);
32'b0000_0000_01xx_xxxx___xxxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
23
+
SPREC
);
32'b0000_0000_001x_xxxx___xxxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
22
+
SPREC
);
32'b0000_0000_0001_xxxx___xxxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
21
+
SPREC
);
32'b0000_0000_0000_1xxx___xxxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
20
+
SPREC
);
32'b0000_0000_0000_01xx___xxxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
19
+
SPREC
);
32'b0000_0000_0000_001x___xxxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
18
+
SPREC
);
32'b0000_0000_0000_0001___xxxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
17
+
SPREC
);
32'b0000_0000_0000_0000___1xxx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
16
+
SPREC
);
32'b0000_0000_0000_0000___01xx_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
15
+
SPREC
);
32'b0000_0000_0000_0000___001x_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
14
+
SPREC
);
32'b0000_0000_0000_0000___0001_xxxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
13
+
SPREC
);
32'b0000_0000_0000_0000___0000_1xxx_xxxx_xxxx
:
z27
<=
#
`pdly
(
12
+
SPREC
);
32'b0000_0000_0000_0000___0000_01xx_xxxx_xxxx
:
z27
<=
#
`pdly
(
11
+
SPREC
);
32'b0000_0000_0000_0000___0000_001x_xxxx_xxxx
:
z27
<=
#
`pdly
(
10
+
SPREC
);
32'b0000_0000_0000_0000___0000_0001_xxxx_xxxx
:
z27
<=
#
`pdly
(
9
+
SPREC
);
32'b0000_0000_0000_0000___0000_0000_xxxx_xxxx
:
z27
<=
#
`pdly
(
8
+
SPREC
);
32'b0000_0000_0000_0000___0000_0000_01xx_xxxx
:
z27
<=
#
`pdly
(
7
+
SPREC
);
32'b0000_0000_0000_0000___0000_0000_001x_xxxx
:
z27
<=
#
`pdly
(
6
+
SPREC
);
32'b0000_0000_0000_0000___0000_0000_0001_xxxx
:
z27
<=
#
`pdly
(
5
+
SPREC
);
32'b0000_0000_0000_0000___0000_0000_0000_1xxx
:
z27
<=
#
`pdly
(
4
+
SPREC
);
32'b0000_0000_0000_0000___0000_0000_0000_01xx
:
z27
<=
#
`pdly
(
3
+
SPREC
);
32'b0000_0000_0000_0000___0000_0000_0000_001x
:
z27
<=
#
`pdly
(
2
+
SPREC
);
32'b0000_0000_0000_0000___0000_0000_0000_0001
:
z27
<=
#
`pdly
(
1
+
SPREC
);
default
:
z27
<=
#
`pdly
SPREC
;
endcase
end
assign
#
`pdly
z73
=
(
z65
>>>
z27
);
assign
#
`pdly
z74
=
(
z66
>>>
z27
);
assign
#
`pdly
z75
=
(
z67
>>>
z27
);
assign
#
`pdly
z64
=
(
z73
*
z73
-
((
z74
*
z74
+
z75
*
z75
)
<<
2
));
assign
#
`pdly
z49
=
(
z73
+
z64
/
z73
)
>>>
1
;
assign
#
`pdly
z50
=
(
z49
+
z64
/
z49
)
>>>
1
;
assign
#
`pdly
z51
=
(
z50
+
z64
/
z50
)
>>>
1
;
assign
#
`pdly
z52
=
(
z51
+
z64
/
z51
)
>>>
1
;
assign
#
`pdly
z53
=
(
z52
+
z64
/
z52
)
>>>
1
;
assign
#
`pdly
z54
=
(
z53
+
z64
/
z53
)
>>>
1
;
assign
#
`pdly
z55
=
((
z64
<
0
)
?
{
ASIZE
+
1
{
1'b0
}}
:
(
z54
<<<
z27
));
assign
#
`pdly
z76
=
(
z65
-
z55
)
>>>
1
;
assign
#
`pdly
scaledr
=
z66
>>>
(
PSCALE
+
SPREC
);
assign
#
`pdly
scaledi
=
z67
>>>
(
PSCALE
+
SPREC
);
assign
#
`pdly
aden
=
scaledr
*
scaledr
+
scaledi
*
scaledi
;
assign
#
`pdly
z68
=
(
scaledr
*
z76
)/
aden
;
assign
#
`pdly
z69
=
(
scaledi
*
z76
)/
aden
;
always
@(
posedge
clk
)
begin
z17
<=
#
`pdly
z19
&
z20
&
!
z16
;
z24
<=
#
`pdly
z17
;
if
(
z16
)
begin
z29
<=
#
`pdly
0
;
z28
<=
#
`pdly
0
;
z32
<=
#
`pdly
0
;
z33
<=
#
`pdly
0
;
z36
<=
#
`pdly
0
;
z70
<=
#
`pdly
0
;
z71
<=
#
`pdly
0
;
z37
<=
#
`pdly
0
;
z38
<=
#
`pdly
0
;
z39
<=
#
`pdly
0
;
z46
<=
#
`pdly
0
;
z47
<=
#
`pdly
0
;
z25
<=
#
`pdly
0
;
end
else
if
(
z18
)
begin
z28
<=
#
`pdly
z28
+
1
;
z32
<=
#
`pdly
z21
[
15
:
0
];
z33
<=
#
`pdly
z21
[
31
:
16
];
if
(
z29
==
z28
)
begin
z29
<=
#
`pdly
z29
+
z15
;
if
(
z25
==
3
)
begin
z36
<=
#
`pdly
z60
;
z37
<=
#
`pdly
z65
;
z38
<=
#
`pdly
z66
;
z39
<=
#
`pdly
z67
;
z46
<=
#
`pdly
re_filt
;
z47
<=
#
`pdly
im_filt
;
end
else
z25
<=
#
`pdly
z25
+
1
;
end
end
if
(
z18
)
begin
z30
<=
#
`pdly
z32
-
z58
;
z31
<=
#
`pdly
z33
-
z59
;
z42
<=
#
`pdly
z30
<<<
SPREC
;
z43
<=
#
`pdly
z31
<<<
SPREC
;
z70
<=
#
`pdly
z70
+
(
((
z68
<<<
APREC
)
-
z70
)>>>
ABETA
);
z71
<=
#
`pdly
z71
+
(
((
z69
<<<
APREC
)
-
z71
)>>>
ABETA
);
z40
<=
#
`pdly
(
z30
*
z70
+
z31
*
z71
)
>>>
ADJSCALE
;
z41
<=
#
`pdly
(
z30
*
z71
-
z31
*
z70
)
>>>
ADJSCALE
;
z44
<=
#
`pdly
z42
-
z40
;
z45
<=
#
`pdly
z43
-
z41
;
if
(
z29
==
z28
)
begin
z34
<=
#
`pdly
z30
;
z35
<=
#
`pdly
z31
;
end
z22
<=
#
`pdly
{
z57
,
z56
};
end
end
roundN2M
#
(
16
+
SPREC
,
16
)
cvtr
(
z44
,
z56
,
clk
);
roundN2M
#
(
16
+
SPREC
,
16
)
cvti
(
z45
,
z57
,
clk
);
confilt
#
(
SPREC
)
cinst
(
clk
,
z16
,
z18
,
z42
,
z43
,
re_filt
,
im_filt
);
calcmean
#
(
POWSAMPS
)
minst
(
clk
,
z16
,
z12
,
z32
,
z33
,
z58
,
z59
);
endmodule
module
confilt
(
clk
,
z16
,
z18
,
z30
,
z31
,
z56
,
z57
);
parameter
SPREC
=
11
;
input
clk
,
z16
,
z18
;
input
signed
[
15
+
SPREC
:
0
]
z30
,
z31
;
output
signed
[
15
+
SPREC
:
0
]
z56
,
z57
;
parameter
MFIR_WIDTH
=
16
;
parameter
SSCALE
=
11
;
parameter
ORDER
=
4
;
parameter
CELLS
=(
2
**
ORDER
);
reg
signed
[
MFIR_WIDTH
-
1
:
0
]
z77
[
0
:
CELLS
];
reg
[
ORDER
-
1
:
0
]
z78
;
reg
[
ORDER
-
1
:
0
]
z79
[
CELLS
:
0
];
reg
signed
[
SPREC
+
15
:
0
]
z56
,
z57
;
reg
signed
[
SPREC
+
15
:
0
]
z80
[
0
:
CELLS
];
reg
signed
[
SPREC
+
15
:
0
]
z81
[
0
:
CELLS
];
reg
signed
[
SPREC
+
SSCALE
+
15
:
0
]
z82
[
0
:
CELLS
];
reg
signed
[
SPREC
+
SSCALE
+
15
:
0
]
z83
[
0
:
CELLS
];
reg
signed
[
SPREC
+
SSCALE
+
15
:
0
]
z84
[
CELLS
-
1
:
0
][
ORDER
:
0
];
reg
signed
[
SPREC
+
SSCALE
+
15
:
0
]
z85
[
CELLS
-
1
:
0
][
ORDER
:
0
];
`ifdef SYNTHESIS
`else
initial
begin
$readmemh
(
"/midas/opt/static/mfir_16.txt"
,
z77
);
z78
=
0
;
end
`endif
always
@(
posedge
clk
)
begin
if
(
z18
)
begin
z80
[
z78
]
<=
#
`pdly
z30
;
z81
[
z78
]
<=
#
`pdly
z31
;
z56
<=
#
`pdly
z84
[
0
][
0
]
>>>
SSCALE
;
z57
<=
#
`pdly
z85
[
0
][
0
]
>>>
SSCALE
;
z78
<=
#
`pdly
z78
+
1
;
end
end
genvar
m
,
n
;
generate
for
(
m
=
0
;
m
<
CELLS
;
m
=
m
+
1
)
begin
:
conv_loop
always
@(
posedge
clk
)
begin
if
(
z18
)
begin
z79
[
m
]
<=
#
`pdly
(
z78
-
m
);
z82
[
m
]
<=
#
`pdly
z80
[
z79
[
m
]]*
z77
[
m
];
z83
[
m
]
<=
#
`pdly
z81
[
z79
[
m
]]*
z77
[
m
];
end
end
end
endgenerate
generate
for
(
m
=
0
;
m
<
ORDER
;
m
=
m
+
1
)
begin
:
order
for
(
n
=
0
;
n
<(
2
**
m
);
n
=
n
+
1
)
begin
:
tree
always
@(
posedge
clk
)
begin
if
(
z18
)
begin
z84
[
n
][
m
]
<=
#
`pdly
(
m
+
1
==
ORDER
)
?
z82
[
n
+
n
]+
z82
[
n
+
n
+
1
]
:
z84
[
n
+
n
][
m
+
1
]+
z84
[
n
+
n
+
1
][
m
+
1
];
z85
[
n
][
m
]
<=
#
`pdly
(
m
+
1
==
ORDER
)
?
z83
[
n
+
n
]+
z83
[
n
+
n
+
1
]
:
z85
[
n
+
n
][
m
+
1
]+
z85
[
n
+
n
+
1
][
m
+
1
];
end
end
end
end
endgenerate
endmodule
module
calcmean
(
clk
,
z16
,
z12
,
z42
,
z43
,
z58
,
z59
);
parameter
PAVE
=
18
;
parameter
UP
=
3
+
PAVE
;
input
clk
,
z16
,
z12
;
input
signed
[
15
:
0
]
z42
;
input
signed
[
15
:
0
]
z43
;
output
signed
[
15
:
0
]
z58
;
output
signed
[
15
:
0
]
z59
;
reg
signed
[
UP
+
15
:
0
]
z86
;
reg
signed
[
UP
+
15
:
0
]
z87
;
reg
signed
[
UP
+
15
:
0
]
z88
;
reg
signed
[
UP
+
15
:
0
]
z89
;
reg
signed
[
15
:
0
]
z58
;
reg
signed
[
15
:
0
]
z59
;
always
@(
posedge
clk
)
begin
z86
<=
#
`pdly
z42
<<<
UP
;
z87
<=
#
`pdly
z43
<<<
UP
;
if
(
z16
)
begin
z88
<=
#
`pdly
0
;
z89
<=
#
`pdly
0
;
end
else
begin
z88
<=
#
`pdly
z88
+
(
(
z86
-
z88
)>>>
PAVE
);
z89
<=
#
`pdly
z89
+
(
(
z87
-
z89
)>>>
PAVE
);
end
if
(
!
z12
)
begin
z58
<=
#
`pdly
0
;
z59
<=
#
`pdly
0
;
end
else
begin
z58
<=
#
`pdly
z88
>>>
UP
;
z59
<=
#
`pdly
z89
>>>
UP
;
end
end
endmodule
/* verilator lint_on REDEFMACRO */
/* verilator lint_on COMBDLY */
/* verilator lint_on CASEX */
