! Demonstrates NeXtMidas Client-Side Mapping Capabilities
!
! @author  J. Czechowski IV
! @since   NeXtMidas 2.4.1
!
startmacro fn:url u:type

  ! Set the look and feel based on the /LOOK=<str> switch.
  switch LOOK lookAndFeel GET "" ""
  if lookAndFeel neqs "" then
    lookandfeel "^{lookAndFeel}"
  endif


  env set KEYMAP {PLOT={LEFT="L",RIGHT="R",in=i,down=d,up=u,out=o}}
  set maps { }
  if "^type" eqs "GMap" then
    ! Connecting to Google Maps is a special case
    set maps.LT   "GMap"
    info "MAPDEMO: Connecting to Google Maps"
  else
    set maps.LT        "^{type}"  ! Layer Type
    set maps.URL       "^{url}"   ! URL
    set maps.USETILES  "TRUE"     ! Turns on/off use of tiles
    info "MAPDEMO: Connecting to server '^{maps.url}' (type=^{maps.lt})"
  endif

  if "^type" eqs "NMS" then
    set maps.BACKGROUND  "BLUEMARBLE"  ! Add a default background for NMS
  endif

  pipe on
    panel/setup/controls=gc


    ! Plot the files:
    !   (1) world.shp   - Country names when you hover over
    !   (2) <maps>      - The maps
    !   (3) cities.prm  - Major cities
    plot/id=idplot/readout=+OnAxis &
                   nxm.sys.dat.world.shp{LAYER={LABEL=NAME,OPAQ=0}}|&
                   ^{maps}|&
                   nxm.sys.dat.cities.prm{LAYER={COLOR=red}} view=latlon

    set worldLayer  reg.idplot.layers.world
    set mapLayer    reg.idplot.layers.^{maps.lt}
    set citiesLayer reg.idplot.layers.cities

    
    gcontrol button state  ""        "Quit"
    gcontrol choice view   "View:    " "LatLon,Mercator,Geodetic,LatLonContinuous" "LatLon" /tleft
    gcontrol button maps   "Maps:    " "Configure" /tleft
    gcontrol button cities "Cities:  " "SetColor"  /tleft
    gcontrol lval   prog   "Progress:" -1 0 100 1  /tleft /Gauge /edit=no /mon=reg.idplot.layers.^{maps.lt}.progress
    set gc.cities.itemColors {SetColor=red}
    

  pipe off

endmacro


procedure processMessage m:msg
  !say "Got message name=^{msg.name} info=^{msg.info} data=^{msg.data} from=^{msg.fid}"

  if msg.name eqs "PROG" then
    ! ignore
  elseif msg.name eqs "STATE" and msg.data eqs "QUIT" then
    ! Stops the pipe, and let the macro terminate
    pipe stop

  elseif msg.name eqs "VIEW" then
    ! Sets the plot view
    set reg.idplot.view "^{msg.data}"

  elseif msg.name eqs "MAPS" and msg.data eqs "CONFIGURE" then
    ! Brings up the layer config window
    invoke ,, mapLayer.configure()

  elseif msg.name eqs "CITIES" and msg.data eqs "SETCOLOR" then
    ! Bring up the color chooser
    popup/cancelmsg=false ,, color /msgid=main /msgname="CITIESCOLOR" /blocking=None

  elseif msg.name eqs "CITIESCOLOR" then
    ! Set the color for the cities based on message from color popup
    set gc.cities.itemColors  {SetColor="^msg.data"}
    set citiesLayer.color "^{msg.data}"

  else
    warn "Unhandled message name=^{msg.name} info=^{msg.info} data=^{msg.data} from=^{msg.fid}"
  endif


return
