/*
-----------------------------------------------------------------------
   Description:  Includes for FFT library routines            

   Authors:      RDH

   Revisions:

   DATE         AUTHOR          DESCRIPTION
   -----------  --------------  ---------------------------------------
   05/21/00     rdh          	baseline
   08/17/01     rdh          	modified to use radix pass "profiles"

-----------------------------------------------------------------------
*/

/* Preprocessor Defines */
#ifdef _FFTDOUBLE_
  typedef double fft_real; 
  typedef double fft_dble;
#else
  typedef float  fft_real; 
  typedef double fft_dble;
#endif

/* Constants, macros, and flags */
#define FFT_CONST(x)  ((fft_real) x)
#define FFT_RADIX_MIN         2 
#define FFT_RADIX_MAX         32
#define FFT_MAX_PLANS         32

/* FFT Configuration and Processing Flags */
#define FFT_FLAGS_NULL        0x00000000
#define FFT_FLAGS_REAL        0x00000001
#define FFT_FLAGS_COMPLEX     0x00000002
#define FFT_FLAGS_FORWARD     0x00000008
#define FFT_FLAGS_INVERSE     0x00000010
#define FFT_FLAGS_PACKED      0x00000020
#define FFT_FLAGS_UNPACKED    0x00000040
#define FFT_FLAGS_NONYQUIST   0x00000080
#define FFT_FLAGS_SCALE       0x00000100
#define FFT_FLAGS_INITPLANS   0x10000000
#define FFT_FLAGS_FREEPLANS   0x20000000
#define FFT_FLAGS_VALIDPLAN   0x40000000
#define FFT_FLAGS_OUTOFMEM    0x80000000

/* Data type definitions */
typedef int    fft_bool;
typedef int    fft_int;
typedef struct { fft_real re; fft_real im; } fft_cmplx;

typedef struct 
{
    fft_int   flags;                             /* Copy of calling flags        */
    fft_int   validflag;                         /* Is plan valid?               */
    fft_int   scale;                             /* Scale FFT for correctness    */
    fft_int   size;                              /* Complex FFT size             */
    fft_int   type;                              /* FFT type (real/complex)      */
    fft_int   direction;                         /* Forward/Inverse FFT          */
    fft_int   packing;                           /* Type of packing/unpack       */
    fft_int   radixevenodd;                      /* Even/odd number radix passes */
    fft_int   radixgeneric;                      /* Generic Radix Pass ID        */
    fft_int   radixcount;                        /* Total known radix passes     */
    fft_int   radixpassid[FFT_RADIX_MAX+1];      /* Specific radix pass ID's     */ 
    fft_int   radixpasscnt[FFT_RADIX_MAX+1];     /* Specific radix pass cnts     */
    fft_cmplx *rdxgen_t;                         /* Generic Radix t-vector       */
    fft_cmplx *rdxgen_w;                         /* Generic radix w-matrix       */
    fft_real  *twidtable;                        /* Radix pass twiddle table     */
    fft_real  *workbuf;                          /* Working buffer               */
} FFT_Plan; 


/* Processor Specific Profiles */
#if defined _PROFILE_RISC_              /* General Profile for RISC/ALPHA */
 static fft_int radix_decomp_profile[7][4] =
         { 2,    0, 2147483647, 2147483647,
           3,    0, 2147483647, 2147483647,
           4,    0, 2147483647, 2147483647,
           5,    0, 2147483647, 2147483647,
           8,    0, 2147483647, 2147483647,
          16, 6000, 2147483647, 2147483647,
          32, 8000, 2147483647, 2147483647 };
 
#elif defined _PROFILE_NORISC_          /* General Profile for CISC chips */
 static fft_int radix_decomp_profile[7][4] =
         { 2,    0, 2147483647, 2147483647,
           3,    0, 2147483647, 2147483647,
           4,    0, 2147483647, 2147483647,
           5,    0, 2147483647, 2147483647,
           8,    0, 2147483647, 2147483647,
          16, 4000, 2147483647,          1,
          32,    0,          0,          0 };
 
#elif defined _PROFILE_XEON_            /* Intel XEON: no 32,16, or 8 */
 static fft_int radix_decomp_profile[7][4] =
         { 2,    0, 2147483647, 2147483647,
           3,    0, 2147483647, 2147483647,
           4,    0, 2147483647, 2147483647,
           5,    0, 2147483647, 2147483647,
           8,    0,          0,          0,
          16,    0,          0,          0,
          32,    0,          0,          0 };
 
#else                                   /* Default profile: single 16,32 */
 static fft_int radix_decomp_profile[7][4] =
         { 2,    0, 2147483647, 2147483647,
           3,    0, 2147483647, 2147483647,
           4,    0, 2147483647, 2147483647,
           5,    0, 2147483647, 2147483647,
           8,    0, 2147483647, 2147483647,
          16, 4000, 2147483647,          1,
          32, 8000, 2147483647,          1 };
#endif
