! A graphical demo of the SIGSTATISTICS command.
!
! @author   J. Czechowski
!
startmacro FN:inFile S:inNFFT D:inFreq D:inBW
    pipe on
        panel/setup/controls=gc

        ! Omit the /WAITFORPIPE unless you need the primitive to stay up even
        ! after it is complete. An example being a GUI that may still query the
        ! "widgets" after the primitive is done.
        sigstat/WAITFORPIPE/id=sigstat/res=stats IN=inFile FFT=_fft NFFT=^inNFFT FREQ=^inFreq BW=^inBW

        plot/id=rasterPlot _fft readout=+OnAxis|+ExtPrec|+T|+DATESTRING cm=Mag Y1=0 Y2=60
        plot/id=linePlot   _fft readout=+OnAxis|+ExtPrec|+T|+DATESTRING cm=Mag type=Line

        feature label=SIGNAL_BW                 plot=linePlot table={name="SIGNAL_BW",                  type=DATA,           LINE={COLOR=BLUE},X=^{inFreq},DX=^{inBW}}
        feature label=AVG_NOISE_FLOOR           plot=linePlot table={name="AVG_NOISE_FLOOR",            type=HLINE|TEXT|BTAG,LINE={COLOR=YELLOW}}
        feature label=AVG_NOISE_THRESHOLD       plot=linePlot table={name="AVG_NOISE_THRESHOLD",        type=HLINE|TEXT|BTAG,LINE={COLOR=YELLOW}}
        feature label=AVG_PEAK_SIGNAL_FREQ      plot=linePlot table={name="AVG_PEAK_SIGNAL_FREQ",       type=VLINE,          LINE={COLOR=GRAY}}
        feature label=AVG_PEAK_SIGNAL_STRENGTH  plot=linePlot table={name="AVG_PEAK_SIGNAL_STRENGTH",   type=HLINE|TEXT|BTAG,LINE={COLOR=WHITE}}
        feature label=AVG_SIGNAL_STRENGTH       plot=linePlot table={name="AVG_SIGNAL_STRENGTH",        type=HLINE|TEXT|BTAG,LINE={COLOR=CYAN}}

        gcontrol "LABEL"    "CTRL_LABEL"    "Controls"          "AlwaysOpen"
        gcontrol "BUTTON"   "CONTROLS"      ""                  "Quit"          /msg=YES
        gcontrol "PROMPT"   "INPUT_NAME"    "InputFile      "   "^inFile"       /msg=YES
        gcontrol "DVAL"     "FREQUENCY"     "SignalFrequency"   inFreq -1 1e12  /msg=YES
        gcontrol "DVAL"     "BANDWIDTH"     "SignalBandwidth"   inBW    0 1e12  /msg=YES
        gcontrol "CHOICE"   "FFT_SIZE"      "FFTSize        "   "1K,4K,8K,16K,32K,64K,128K,256K,512K,1M,2M,4M"  "^inNFFT" /msg=YES
        gcontrol "LABEL"    "STAT_LABEL"    "SignalStatistics"  "Open"

        gcontrol "LVAL"     "NOISE_FLOOR"               "NoiseFloor             (dB)" 0 -Inf +Inf /mon=reg.sigstat.NoiseFloor            /edit=NO /msg=NO
        gcontrol "LVAL"     "AVG_NOISE_FLOOR"           "AvgNoiseFloor          (dB)" 0 -Inf +Inf /mon=reg.sigstat.AvgNoiseFloor         /edit=NO /msg=YES /WTHEME={CWFG=YELLOW}
        gcontrol "LVAL"     "NOISE_THRESHOLD"           "NoiseThreshold         (dB)" 0 -Inf +Inf /mon=reg.sigstat.NoiseThreshold        /edit=NO /msg=NO
        gcontrol "LVAL"     "AVG_NOISE_THRESHOLD"       "AvgNoiseThreshold      (dB)" 0 -Inf +Inf /mon=reg.sigstat.AvgNoiseThreshold     /edit=NO /msg=YES /WTHEME={CWFG=YELLOW}
        gcontrol "LINE"
        gcontrol "LVAL"     "SIGNAL_STRENGTH"           "SignalStrength         (dB)" 0 -Inf +Inf /mon=reg.sigstat.SignalStrength        /edit=NO /msg=NO
        gcontrol "LVAL"     "AVG_SIGNAL_STRENGTH"       "AvgSignalStrength      (dB)" 0 -Inf +Inf /mon=reg.sigstat.AvgSignalStrength     /edit=NO /msg=YES
        gcontrol "LVAL"     "SIGNAL_SNR"                "SignalSNR              (dB)" 0 -Inf +Inf /mon=reg.sigstat.SignalSNR             /edit=NO /msg=NO
        gcontrol "LVAL"     "AVG_SIGNAL_SNR"            "AvgSignalSNR           (dB)" 0 -Inf +Inf /mon=reg.sigstat.AvgSignalSNR          /edit=NO /msg=NO /WTHEME={CWFG=CYAN}
        gcontrol "LINE"
        gcontrol "LVAL"     "PEAK_SIGNAL_FREQ"          "PeakSignalFreq         (dB)" 0 -Inf +Inf /mon=reg.sigstat.PeakSignalFreq        /edit=NO /msg=NO
        gcontrol "LVAL"     "AVG_PEAK_SIGNAL_FREQ"      "AvgPeakSignalFreq      (dB)" 0 -Inf +Inf /mon=reg.sigstat.AvgPeakSignalFreq     /edit=NO /msg=YES /WTHEME={CWFG=WHITE}
        gcontrol "LVAL"     "PEAK_SIGNAL_STRENGTH"      "PeakSignalStrength     (dB)" 0 -Inf +Inf /mon=reg.sigstat.PeakSignalStrength    /edit=NO /msg=NO
        gcontrol "LVAL"     "AVG_PEAK_SIGNAL_STRENGTH"  "AvgPeakSignalStrength  (dB)" 0 -Inf +Inf /mon=reg.sigstat.AvgPeakSignalStrength /edit=NO /msg=YES /WTHEME={CWFG=WHITE}
        gcontrol "LVAL"     "PEAK_SIGNAL_SNR"           "PeakSignalSNR          (dB)" 0 -Inf +Inf /mon=reg.sigstat.PeakSignalSNR         /edit=NO /msg=NO
        gcontrol "LVAL"     "AVG_PEAK_SIGNAL_SNR"       "AvgPeakSignalSNR       (dB)" 0 -Inf +Inf /mon=reg.sigstat.AvgPeakSignalSNR      /edit=NO /msg=NO
    pipe off
endmacro

procedure processMessage m:msg
    !info "Got message ^msg DATA=^msg.data"

    if ((msg.name eqs "CONTROLS") and (msg.data eqs "QUIT")) then
        pipe stop

    elseif (msg.name eqs "INPUT_NAME") then
        invoke ,, reg.sigstat.setArg("IN",msg.data)
        invoke ,, reg.sigstat.setState("RESTART")

    elseif (msg.name eqs "FREQUENCY") then
        set reg.linePlot.features.SIGNAL_BW.X msg.data
        invoke ,, reg.sigstat.setArg("FREQ",msg.data)
        invoke ,, reg.sigstat.setState("RESTART")
        set SIGNAL_BW.X msg.data

    elseif (msg.name eqs "BANDWIDTH") then
        set reg.linePlot.features.SIGNAL_BW.DX msg.data
        invoke ,, reg.sigstat.setArg("BW",msg.data)
        invoke ,, reg.sigstat.setState("RESTART")
        set SIGNAL_BW.DX msg.data

    elseif (msg.name eqs "FFT_SIZE") then
        set reg.sigstat.nfft            msg.data

    elseif (msg.name eqs "AVG_NOISE_FLOOR") then
        set AVG_NOISE_FLOOR.Y           msg.data

    elseif (msg.name eqs "AVG_NOISE_THRESHOLD") then
        set AVG_NOISE_THRESHOLD.Y       msg.data

    elseif (msg.name eqs "AVG_PEAK_SIGNAL_FREQ") then
        set AVG_PEAK_SIGNAL_FREQ.X      msg.data
        set AVG_PEAK_SIGNAL_STRENGTH.X  msg.data
        set AVG_NOISE_FLOOR.X           msg.data
        set AVG_NOISE_THRESHOLD.X       msg.data
        set AVG_SIGNAL_STRENGTH.X       msg.data

    elseif (msg.name eqs "AVG_PEAK_SIGNAL_STRENGTH") then
        set AVG_PEAK_SIGNAL_STRENGTH.Y  msg.data

    elseif (msg.name eqs "AVG_SIGNAL_STRENGTH") then
        set AVG_SIGNAL_STRENGTH.Y       msg.data

    else
        info "Got message ^msg DATA=^msg.data"
    endif
return