/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.Tablizable;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataOp;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libm.Fft;
import nxm.sys.prim.fft;

public class sigstatistics
extends Primitive {
    public static final String windoList = nxm.sys.prim.fft.windowList;
    public static final String partialList = "None,All,Start";
    public static final int P_NONE = 1;
    public static final int P_ALL = 2;
    public static final int P_START = 3;
    public static final String packList = "Unpack,DC,Zero";
    public static final int P_UNPACK = 1;
    public static final int P_DC = 2;
    public static final int P_ZERO = 3;
    private static final SNRResult NO_RESULT = new SNRResult();
    private DataFile inFile;
    private DataFile outFile;
    private DataFile fftFile;
    private String outResult;
    private Data inData;
    private Data fftData;
    private Data outData;
    private Data winData;
    private Data addData;
    private Data acData;
    private int nfft;
    private int nin;
    private int nrot;
    private int nout;
    private int navg;
    private int iavg;
    private int stride;
    private int nexp;
    private int pack;
    private int partial;
    private double factor;
    private double over;
    private double size;
    private double rnavg;
    private double rnexp;
    private boolean mag;
    private final boolean psd = true;
    private final boolean log = false;
    private final boolean fdb = true;
    private boolean cxm;
    private final boolean out1d = false;
    private boolean in2d;
    private boolean dp;
    private boolean ac;
    private String wname;
    private Fft fft;
    private double fftFreqMin;
    private double fftFreqMax;
    private double fftFreqCentre;
    private double fftFreqDelta;
    private double fftBandwidth;
    private double signalFreq;
    private double signalBW;
    private double rcvrCF;
    private int rcvrTF;
    private double rcvrBW;
    private Double startTime;
    private Double endTime;
    private String kwMode;
    private int signalBinMin;
    private int signalBinMax;
    private int rcvrBinMin;
    private int rcvrBinMax;
    private int maxHistPoints;
    private Table statTable;
    private final List<SNRResult> histSignal = new LinkedList<SNRResult>();
    private final List<SNRResult> histPeak = new LinkedList<SNRResult>();
    private static final int COMPLETED = 12;
    private boolean waitForPipe;

    public synchronized int checkin(Midas M) {
        int status = super.checkin(M);
        this.waitForPipe = this.MA.getState("/WAITFORPIPE");
        return status;
    }

    public int process() {
        int status = this._process();
        if (this.waitForPipe && status == 9) {
            status = 12;
        }
        return status;
    }

    public int open() {
        double maxFreq;
        int type;
        double stry;
        double dely;
        this.inFile = this.MA.getDataFile("IN", "1000", "S#,C#", 0);
        this.inFile.open(131072);
        this.in2d = this.inFile.typeClass == 2;
        this.nfft = this.MA.getL("NFFT");
        if (this.nfft == -1) {
            this.nfft = (int)this.inFile.getSize();
        }
        this.nin = this.MA.getL("/TL", this.nfft);
        this.mag = true;
        this.ac = this.MA.getState("/AC");
        this.dp = this.MA.getState("/DP");
        this.partial = this.MA.getSelectionIndex("/PARTIAL", partialList, 3);
        this.signalFreq = this.MA.getD("FREQ", -1.0);
        this.signalBW = this.MA.getD("BW", -1.0);
        this.signalBinMin = -1;
        this.signalBinMax = -1;
        this.maxHistPoints = this.MA.getL("/AVGPTS", 1024);
        this.statTable = new Table();
        this.outResult = this.MA.getU("/RES", null);
        this.rcvrCF = this.MA.getD("/RCVR_CF");
        this.rcvrBW = this.MA.getD("/RVCR_BW");
        this.kwMode = this.MA.getS("/KWMODE", "AUTO");
        this.startTime = this.MA.getD("STARTTIME", null);
        this.endTime = this.MA.getD("ENDTIME", null);
        if (this.startTime != null && this.startTime <= 0.0) {
            this.startTime = null;
        }
        if (this.endTime != null && this.endTime <= 0.0) {
            this.endTime = null;
        }
        if (this.outResult != null) {
            this.MR.put(this.outResult, (Object)this.getStatTable());
        }
        if (this.state != 7) {
            this.navg = this.MA.getL("/NAVG", 5);
            this.over = this.MA.getD("/OVER", 0.25);
            this.nexp = this.MA.getL("/NEXP", 1);
            this.wname = this.MA.getS("/WIN", "HANN");
        }
        double delx = this.inFile.getXDelta();
        double delf = 1.0 / ((double)this.nfft * delx);
        boolean bl = this.cxm = this.inFile.spa == 2;
        if (this.in2d) {
            this.nin = this.inFile.getSubSize();
            dely = this.inFile.getYDelta();
            stry = this.inFile.getYStart();
            this.inFile.setFS(0);
            this.setOverlap(this.over);
        } else {
            this.setOverlap(this.over);
            dely = delx * (double)this.stride;
            stry = this.inFile.getXStart();
        }
        this.size = this.inFile.size;
        if (this.navg < 0) {
            this.navg = (int)((this.size - (double)this.nfft) / (double)this.stride) + 1;
        }
        this.setNExp(this.nexp);
        this.setNAvg(this.navg);
        int flags = 8;
        byte dtype = this.dp ? (byte)68 : 70;
        String cform = this.dp ? "CD" : "CF";
        String sform = this.dp ? "SD" : "SF";
        this.pack = 3;
        this.pack = this.MA.getSelectionIndex("/PACK", packList, this.pack);
        if (this.cxm) {
            this.nout = this.nfft;
            this.nrot = this.nfft / 2 - 1;
            flags |= 2;
            this.factor = 1.0 / (double)this.nfft;
            this.pack = 0;
        } else {
            this.nout = this.nfft / 2;
            if (this.nfft != this.nout * 2) {
                throw new MidasException("Invalid FFT size parameter: " + this.nfft);
            }
            this.nrot = 0;
            flags |= 1;
            if (this.pack == 1) {
                flags |= 0x40;
                ++this.nout;
            } else {
                flags |= 0x20;
            }
            this.factor = 1.0 / (double)(2 * this.nfft);
        }
        this.fft = new Fft(this.nfft, flags);
        this.factor /= Math.sqrt(delf);
        if (!this.MA.getState("/ROTATE", this.cxm)) {
            this.nrot = 0;
        }
        this.fftFreqDelta = delf;
        this.fftFreqMin = (double)(-this.nrot) * delf;
        this.fftBandwidth = delf * (double)this.nout;
        this.fftFreqMax = this.fftFreqMin + this.fftBandwidth;
        this.fftFreqCentre = this.fftFreqMin + this.fftBandwidth * 0.5;
        String oform = this.mag ? sform : cform;
        double osize = Math.max(1.0, Math.floor((this.size - (double)this.nfft) / (double)this.stride / (double)this.navg));
        this.fftFile = this.MA.getDataFile("FFT", "2000", oform, 0);
        this.fftFile.propagate(this.inFile, "TIMECODE|KEYWORDS");
        this.fftFile.setSubSize(this.nout);
        this.fftFile.setXStart(this.fftFreqMin);
        this.fftFile.setXDelta(delf);
        this.fftFile.setXUnits(3);
        this.fftFile.setYStart(stry + (double)((this.nfft + (this.navg - 1) * this.stride) / 2) * delx);
        this.fftFile.setYDelta(dely * (double)this.navg);
        this.fftFile.setYUnits(1);
        this.fftFile.setSize(osize);
        this.fftFile.open(131136);
        this.outFile = this.MA.getDataFile("OUT");
        this.outFile.propagate(this.inFile, "TIMECODE|KEYWORDS");
        this.outFile.setXStart(stry + (double)((this.nfft + (this.navg - 1) * this.stride) / 2) * delx);
        this.outFile.setXDelta(dely * (double)this.navg);
        this.outFile.setYUnits(1);
        Table quals = this.outFile.getQualifiers();
        int n = type = quals == null ? 6000 : quals.getL("TYPE", 6000);
        if (type / 1000 < 6) {
            this.outFile.setType(type);
            this.outFile.addSubRec("NFLR", "SL", -1, 0, 35);
            this.outFile.addSubRec("NTHR", "SL", -1, 0, 35);
            this.outFile.addSubRec("SIG", "SL", -1, 0, 35);
            this.outFile.addSubRec("SSNR", "SL", -1, 0, 35);
            this.outFile.addSubRec("FREQ", "SL", -1, 0, 3);
            this.outFile.addSubRec("PEAK", "SL", -1, 0, 35);
            this.outFile.addSubRec("PSNR", "SL", -1, 0, 35);
            this.outFile.addSubRec("ANF", "SL", -1, 0, 35);
            this.outFile.addSubRec("ANT", "SL", -1, 0, 35);
            this.outFile.addSubRec("ASIG", "SL", -1, 0, 35);
            this.outFile.addSubRec("ASNR", "SL", -1, 0, 35);
            this.outFile.addSubRec("AFRQ", "SL", -1, 0, 3);
            this.outFile.addSubRec("APSG", "SL", -1, 0, 35);
            this.outFile.addSubRec("APSN", "SL", -1, 0, 35);
        } else {
            this.outFile.setType(type);
            this.outFile.addSubRec("NOISE_FLOOR", "SL", -1, 0, 35);
            this.outFile.addSubRec("NOISE_THRESHOLD", "SL", -1, 0, 35);
            this.outFile.addSubRec("SIGNAL_STRENGTH", "SL", -1, 0, 35);
            this.outFile.addSubRec("SIGNAL_SNR", "SL", -1, 0, 35);
            this.outFile.addSubRec("PEAK_SIGNAL_FREQ", "SL", -1, 0, 3);
            this.outFile.addSubRec("PEAK_SIGNAL_STRENGTH", "SL", -1, 0, 35);
            this.outFile.addSubRec("PEAK_SIGNAL_SNR", "SL", -1, 0, 35);
            this.outFile.addSubRec("AVG_NOISE_FLOOR", "SL", -1, 0, 35);
            this.outFile.addSubRec("AVG_NOISE_THRESHOLD", "SL", -1, 0, 35);
            this.outFile.addSubRec("AVG_SIGNAL_STRENGTH", "SL", -1, 0, 35);
            this.outFile.addSubRec("AVG_SIGNAL_SNR", "SL", -1, 0, 35);
            this.outFile.addSubRec("AVG_PEAK_SIGNAL_FREQ", "SL", -1, 0, 3);
            this.outFile.addSubRec("AVG_PEAK_SIGNAL_STRENGTH", "SL", -1, 0, 35);
            this.outFile.addSubRec("AVG_PEAK_SIGNAL_SNR", "SL", -1, 0, 35);
            this.outFile.addSubRec("SIGNAL_MEAN", "SF", -1, 0, 35);
            this.outFile.addSubRec("SIGNAL_SDEV", "SF", -1, 0, 35);
            this.outFile.addSubRec("SIGNAL_ELEM", "SL", -1, 0, 0);
            this.outFile.addSubRec("SIGNAL_MIN", "SF", -1, 0, 35);
            this.outFile.addSubRec("SIGNAL_MAX", "SF", -1, 0, 35);
            this.outFile.addSubRec("SIGNAL_AMIN", "SL", -1, 0, 3);
            this.outFile.addSubRec("SIGNAL_AMAX", "SL", -1, 0, 3);
            this.outFile.addSubRec("SIGNAL_OMIN", "SL", -1, 0, 0);
            this.outFile.addSubRec("SIGNAL_OMAX", "SL", -1, 0, 0);
            this.outFile.addSubRec("SIGNAL_SUM", "SF", -1, 0, 35);
            this.outFile.addSubRec("SPECTRUM_MEAN", "SF", -1, 0, 35);
            this.outFile.addSubRec("SPECTRUM_SDEV", "SF", -1, 0, 35);
            this.outFile.addSubRec("SPECTRUM_ELEM", "SL", -1, 0, 0);
            this.outFile.addSubRec("SPECTRUM_MIN", "SF", -1, 0, 35);
            this.outFile.addSubRec("SPECTRUM_MAX", "SF", -1, 0, 35);
            this.outFile.addSubRec("SPECTRUM_AMIN", "SL", -1, 0, 3);
            this.outFile.addSubRec("SPECTRUM_AMAX", "SL", -1, 0, 3);
            this.outFile.addSubRec("SPECTRUM_OMIN", "SL", -1, 0, 0);
            this.outFile.addSubRec("SPECTRUM_OMAX", "SL", -1, 0, 0);
            this.outFile.addSubRec("SPECTRUM_SUM", "SF", -1, 0, 35);
        }
        this.outFile.setSize(osize);
        this.outFile.open(131136);
        this.setWindow(this.wname);
        this.inData = this.inFile.getDataBuffer(this.nin, dtype);
        this.fftData = new Data(cform, this.nout);
        this.outData = this.fftFile.getDataBuffer(1, dtype);
        this.addData = this.fftFile.getDataBuffer(1, dtype);
        switch (this.kwMode.toUpperCase()) {
            case "AUTO": {
                this.M.deprecate((CharSequence)"/KWMODE=AUTO currently matches /KWMODE=LEGACY to be backwards-compatible with NeXtMidas 4.1.3; this will change in a future release to give preference to the /KWMODE=JICD keywords");
            }
            case "LEGACY": {
                if (this.rcvrCF <= 0.0) {
                    this.rcvrCF = Convert.o2d((Object)this.inFile.getKeyWord("TLA_VRF")) * 1000000.0;
                }
                if (this.rcvrCF <= 0.0) {
                    this.rcvrCF = Convert.o2d((Object)this.inFile.getKeyWord("TLA_CENTER_FREQ")) * 1000000.0;
                }
                if (this.rcvrCF <= 0.0) {
                    this.rcvrCF = Convert.o2d((Object)this.inFile.getKeyWord("VRF")) * 1000000.0;
                }
                if (this.rcvrCF <= 0.0) {
                    this.rcvrCF = Convert.o2d((Object)this.inFile.getKeyWord("ETF")) * 1000000.0;
                }
                if (this.rcvrBW <= 0.0) {
                    this.rcvrBW = Convert.o2d((Object)this.inFile.getKeyWord("TLA_VRBW")) * 1000000.0;
                }
                if (this.rcvrBW <= 0.0) {
                    this.rcvrBW = Convert.o2d((Object)this.inFile.getKeyWord("TLA_BANDWIDTH")) * 1000000.0;
                }
                if (this.rcvrBW <= 0.0) {
                    this.rcvrBW = Convert.o2d((Object)this.inFile.getKeyWord("VRBW")) * 1000000.0;
                }
                if (!(this.rcvrBW <= 0.0)) break;
                this.rcvrBW = Convert.o2d((Object)this.inFile.getKeyWord("EBW")) * 1000000.0;
                break;
            }
            case "JICD": 
            case "JICD4.2": 
            case "JICD 4.2": {
                if (this.rcvrCF <= 0.0) {
                    this.rcvrCF = Convert.o2d((Object)this.inFile.getKeyWord("VRF"));
                }
                if (!(this.rcvrBW <= 0.0)) break;
                this.rcvrBW = Convert.o2d((Object)this.inFile.getKeyWord("BANDWIDTH"));
                break;
            }
            default: {
                throw new MidasException("Unsupported keyword mode /KWMODE=" + this.kwMode);
            }
        }
        if (this.MA.getState("/IF", false)) {
            this.rcvrCF = this.fftFreqCentre;
            this.rcvrTF = 0;
        } else if (this.rcvrCF <= 0.0) {
            this.M.warning((CharSequence)("No receiver RVCR_CF given, assuming " + this.signalFreq + " is IF."));
            this.rcvrCF = this.fftFreqCentre;
            this.rcvrTF = 0;
        } else {
            this.rcvrTF = (int)Math.rint(this.rcvrCF - this.fftFreqCentre);
            this.fftFile.setXStart(this.fftFreqMin + (double)this.rcvrTF);
        }
        if (this.rcvrBW <= 0.0) {
            this.M.warning((CharSequence)"No receiver RVCR_BW given, assuming full-band.");
            this.rcvrBW = this.fftBandwidth;
        } else if (this.rcvrBW > this.fftBandwidth) {
            this.M.warning((CharSequence)"Receiver RVCR_BW exceeds full-band, assuming full-band.");
            this.rcvrBW = this.fftBandwidth;
        }
        if (this.rcvrBW <= 0.0) {
            this.rcvrBinMin = 0;
            this.rcvrBinMax = this.nout;
        } else {
            double minFreq = this.fftFreqCentre - this.rcvrBW / 2.0;
            maxFreq = this.fftFreqCentre + this.rcvrBW / 2.0;
            this.rcvrBinMin = (int)Math.floor((minFreq - this.fftFreqMin) / this.fftFreqDelta);
            this.rcvrBinMax = (int)Math.ceil((maxFreq - this.fftFreqMin) / this.fftFreqDelta);
        }
        double minFreq = this.signalFreq - (double)this.rcvrTF - this.signalBW / 2.0;
        maxFreq = this.signalFreq - (double)this.rcvrTF + this.signalBW / 2.0;
        if (minFreq >= this.fftFreqMin && maxFreq <= this.fftFreqMax) {
            this.signalBinMin = (int)Math.floor((minFreq - this.fftFreqMin) / this.fftFreqDelta);
            this.signalBinMax = (int)Math.ceil((maxFreq - this.fftFreqMin) / this.fftFreqDelta);
            if (this.signalBW / this.fftFreqDelta < 0.25) {
                this.M.warning((CharSequence)("Signal bandwidth (" + this.signalBW + " Hz) is sufficiently below the width of the FFT bins (" + this.fftFreqDelta + " Hz) that the SNR results will be unreliable."));
            }
        } else {
            this.signalBinMin = -1;
            this.signalBinMax = -1;
        }
        this.inFile.setTransLength(this.nin);
        this.inFile.setConsLength(this.nin);
        this.iavg = 1;
        this.rnavg = 1.0 / (double)this.navg;
        return 0;
    }

    public int _process() {
        Data statData;
        int stat = 0;
        double time0 = this.inFile.getTimeAt();
        int numRead = this.inFile.read(this.inData);
        double time1 = this.inFile.getTimeAt();
        if (numRead < 0) {
            stat = 9;
            if (this.iavg == 1) {
                return stat;
            }
            this.navg = this.iavg;
            this.rnavg = 1.0 / (double)this.navg;
            numRead = Math.max(0, numRead);
        }
        if (!(numRead != this.nin && this.partial == 1 || (statData = this.processInput(this.nfft, this.fftFile, this.inData, this.fftData, this.addData)) == null || this.startTime != null && time1 < this.startTime || this.endTime != null && time0 > this.endTime)) {
            this.computeSigStatistics(statData);
            if (this.outResult != null) {
                this.MR.put(this.outResult, (Object)this.getStatTable());
            }
        }
        if (++this.iavg > this.navg) {
            this.iavg = 1;
            this.rnavg = 1.0 / (double)this.navg / (double)this.nexp;
            if (this.partial == 3) {
                this.partial = 1;
            }
        }
        return stat;
    }

    public int processReady() {
        if (this.state != 2) {
            return 0;
        }
        int n = this.inFile.processReady(this.nin);
        if (this.fftFile.isOpen) {
            n = Math.min(n, this.fftFile.processReady(1));
        }
        return n;
    }

    public int close() {
        if (this.verbose || this.outResult == null && !this.outFile.isOpen()) {
            this.M.println((CharSequence)("  NOISE_FLOOR              : " + sigstatistics.roundTo3(this.statTable.get("NOISE_FLOOR")) + " dB\t  AVG_NOISE_FLOOR          : " + sigstatistics.roundTo3(this.statTable.get("AVG_NOISE_FLOOR")) + " dB"));
            this.M.println((CharSequence)("  NOISE_THRESHOLD          : " + sigstatistics.roundTo3(this.statTable.get("NOISE_THRESHOLD")) + " dB\t  AVG_NOISE_THRESHOLD      : " + sigstatistics.roundTo3(this.statTable.get("AVG_NOISE_THRESHOLD")) + " dB"));
            this.M.println((CharSequence)"  ");
            this.M.println((CharSequence)("  SIGNAL_STRENGTH          : " + sigstatistics.roundTo3(this.statTable.get("SIGNAL_STRENGTH")) + " dB\t  AVG_SIGNAL_STRENGTH      : " + sigstatistics.roundTo3(this.statTable.get("AVG_SIGNAL_STRENGTH")) + " dB"));
            this.M.println((CharSequence)("  SIGNAL_SNR               : " + sigstatistics.roundTo3(this.statTable.get("SIGNAL_SNR")) + " dB\t  AVG_SIGNAL_SNR           : " + sigstatistics.roundTo3(this.statTable.get("AVG_SIGNAL_SNR")) + " dB"));
            this.M.println((CharSequence)"  ");
            this.M.println((CharSequence)("  PEAK_SIGNAL_FREQ         : " + sigstatistics.roundMhz(this.statTable.get("PEAK_SIGNAL_FREQ")) + " MHz\t  AVG_PEAK_SIGNAL_FREQ     : " + sigstatistics.roundMhz(this.statTable.get("AVG_PEAK_SIGNAL_FREQ")) + " MHz"));
            this.M.println((CharSequence)("  PEAK_SIGNAL_STRENGTH     : " + sigstatistics.roundTo3(this.statTable.get("PEAK_SIGNAL_STRENGTH")) + " dB\t  AVG_PEAK_SIGNAL_STRENGTH : " + sigstatistics.roundTo3(this.statTable.get("AVG_PEAK_SIGNAL_STRENGTH")) + " dB"));
            this.M.println((CharSequence)("  PEAK_SIGNAL_SNR          : " + sigstatistics.roundTo3(this.statTable.get("PEAK_SIGNAL_SNR")) + " dB\t  AVG_PEAK_SIGNAL_SNR      : " + sigstatistics.roundTo3(this.statTable.get("AVG_PEAK_SIGNAL_SNR")) + " dB"));
            this.M.println((CharSequence)"  ");
            this.M.println((CharSequence)("  SIGNAL_MEAN              : " + sigstatistics.roundTo3(this.statTable.get("SIGNAL_MEAN")) + " dB\t  SPECTRUM_MEAN            : " + sigstatistics.roundTo3(this.statTable.get("SPECTRUM_MEAN")) + " dB"));
            this.M.println((CharSequence)("  SIGNAL_SDEV              : " + sigstatistics.roundTo3(this.statTable.get("SIGNAL_SDEV")) + " dB\t  SPECTRUM_SDEV            : " + sigstatistics.roundTo3(this.statTable.get("SPECTRUM_SDEV")) + " dB"));
            this.M.println((CharSequence)("  SIGNAL_ELEM              : " + sigstatistics.roundTo3(this.statTable.get("SIGNAL_ELEM")) + "\t  SPECTRUM_ELEM            : " + sigstatistics.roundTo3(this.statTable.get("SPECTRUM_ELEM")) + ""));
            this.M.println((CharSequence)("  SIGNAL_MIN               : " + sigstatistics.roundTo3(this.statTable.get("SIGNAL_MIN")) + " dB\t  SPECTRUM_MIN             : " + sigstatistics.roundTo3(this.statTable.get("SPECTRUM_MIN")) + " dB"));
            this.M.println((CharSequence)("  SIGNAL_MAX               : " + sigstatistics.roundTo3(this.statTable.get("SIGNAL_MAX")) + " dB\t  SPECTRUM_MAX             : " + sigstatistics.roundTo3(this.statTable.get("SPECTRUM_MAX")) + " dB"));
            this.M.println((CharSequence)("  SIGNAL_AMIN              : " + sigstatistics.roundMhz(this.statTable.get("SIGNAL_AMIN")) + " MHz\t  SPECTRUM_AMIN            : " + sigstatistics.roundMhz(this.statTable.get("SPECTRUM_AMIN")) + " MHz"));
            this.M.println((CharSequence)("  SIGNAL_AMAX              : " + sigstatistics.roundMhz(this.statTable.get("SIGNAL_AMAX")) + " MHz\t  SPECTRUM_AMAX            : " + sigstatistics.roundMhz(this.statTable.get("SPECTRUM_AMAX")) + " MHz"));
            this.M.println((CharSequence)("  SIGNAL_OMIN              : " + sigstatistics.roundTo3(this.statTable.get("SIGNAL_OMIN")) + "\t  SPECTRUM_OMIN            : " + sigstatistics.roundTo3(this.statTable.get("SPECTRUM_OMIN")) + ""));
            this.M.println((CharSequence)("  SIGNAL_OMAX              : " + sigstatistics.roundTo3(this.statTable.get("SIGNAL_OMAX")) + "\t  SPECTRUM_OMAX            : " + sigstatistics.roundTo3(this.statTable.get("SPECTRUM_OMAX")) + ""));
            this.M.println((CharSequence)("  SIGNAL_SUM               : " + sigstatistics.roundTo3(this.statTable.get("SIGNAL_SUM")) + " dB\t  SPECTRUM_SUM             : " + sigstatistics.roundTo3(this.statTable.get("SPECTRUM_SUM")) + " dB"));
        }
        if (this.outResult != null) {
            this.MR.put(this.outResult, (Object)this.getStatTable());
        }
        this.fft.free();
        this.inFile.close();
        this.outFile.close();
        this.fftFile.close();
        this.histSignal.clear();
        this.histPeak.clear();
        return 0;
    }

    private static Object roundTo3(Object obj) {
        if (obj instanceof Number) {
            obj = new Data(((Number)obj).doubleValue());
        }
        if (obj instanceof Data) {
            return StringUtil.padLeft((String)((Data)obj).toString("0.000"), (int)12);
        }
        return StringUtil.padLeft((String)Objects.toString(obj), (int)12);
    }

    private static Object roundMhz(Object obj) {
        if (obj instanceof Number || obj instanceof Data) {
            return sigstatistics.roundTo3(Convert.o2d((Object)obj) / 1000000.0);
        }
        return StringUtil.padLeft((String)Objects.toString(obj), (int)12);
    }

    private Data processInput(int numRead, DataFile testFile, Data inData, Data fftData, Data addData) {
        fftData.setSPA(inData.spa);
        if (this.ac) {
            DataOp.sum((Data)inData, (Data)this.acData, (int)numRead);
            DataOp.scale((Data)this.acData, (Data)this.acData, (int)1, (double)(-1.0 / (double)numRead));
            DataOp.add((Data)inData, (Data)this.acData, (Data)inData, (int)numRead);
        }
        DataOp.mul((Data)this.winData, (Data)inData, (Data)fftData);
        if (numRead < this.nfft) {
            DataOp.zero((Data)fftData, (int)numRead, (int)(this.nfft - numRead));
        }
        if (this.cxm && inData.spa == 1) {
            DataOp.cmplx((Data)fftData, (Data)fftData, (int)this.nfft, (int)33);
        }
        this.fft.work(fftData);
        fftData.setSPA(2);
        Data db = fftData;
        if (this.pack == 3) {
            fftData.setF(1, 0.0f);
        }
        if (this.mag) {
            DataOp.mag2((Data)db, (Data)this.outData);
            db = this.outData;
        }
        if (this.nexp > 1) {
            DataOp.add((Data)db, (Data)addData, (Data)addData);
            if (this.iavg < this.navg) {
                return null;
            }
            DataOp.scale((Data)addData, (Data)this.outData, (int)this.nout, (double)this.rnavg);
            DataOp.scale((Data)this.outData, (Data)addData, (int)this.nout, (double)this.rnexp);
            db = this.outData;
        } else if (this.navg > 1) {
            if (this.iavg == 1) {
                DataOp.copy((Data)db, (Data)addData);
            } else {
                DataOp.add((Data)db, (Data)addData, (Data)addData);
            }
            if (this.iavg < this.navg) {
                return null;
            }
            DataOp.scale((Data)addData, (Data)addData, (int)this.nout, (double)this.rnavg);
            db = addData;
        }
        DataOp.dbf((Data)db, (int)this.nout, (int)0);
        if (this.nrot != 0) {
            this.fft.rotate(db);
        }
        db.setHeader(inData.getHeader());
        testFile.write(db);
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeSigStatistics(Data statData) {
        SNRResult signalSNR;
        SNRResult peakSNR;
        float[] fbuf;
        double[] dbuf = this.dp ? statData.castD(true) : null;
        float[] fArray = fbuf = !this.dp ? statData.castF(true) : null;
        if (this.signalBinMin < 0) {
            peakSNR = this.findSNR(dbuf, fbuf, 1, 0, this.nout);
            signalSNR = NO_RESULT;
        } else {
            peakSNR = this.findSNR(dbuf, fbuf, 1, this.rcvrBinMin, this.rcvrBinMax);
            SNRResult tempSNR = this.findSNR(dbuf, fbuf, 1, this.signalBinMin, this.signalBinMax);
            int noise = peakSNR.noise;
            int signal = tempSNR.noise;
            signalSNR = new SNRResult(tempSNR.freq, signal, noise, peakSNR.thresh, "dB", tempSNR.stats);
        }
        if (this.dp) {
            statData.uncast(dbuf, false);
        } else {
            statData.uncast(fbuf, false);
        }
        sigstatistics noise = this;
        synchronized (noise) {
            this.histSignal.add(signalSNR);
            this.histPeak.add(peakSNR);
            if (this.histSignal.size() > this.maxHistPoints) {
                this.histSignal.remove(0);
                this.histPeak.remove(0);
            }
        }
        SNRResult avgPeak = this.avgResult(this.histPeak);
        SNRResult avgSignal = this.avgResult(this.histSignal);
        this.statTable_put("NOISE_FLOOR", "NFLR", peakSNR.noise);
        this.statTable_put("NOISE_THRESHOLD", "NTHR", peakSNR.thresh);
        this.statTable_put("SIGNAL_STRENGTH", "SIG", signalSNR.signal);
        this.statTable_put("SIGNAL_SNR", "SSNR", signalSNR.snr);
        this.statTable_put("PEAK_SIGNAL_FREQ", "FREQ", peakSNR.freq);
        this.statTable_put("PEAK_SIGNAL_STRENGTH", "PEAK", peakSNR.signal);
        this.statTable_put("PEAK_SIGNAL_SNR", "PSNR", peakSNR.snr);
        this.statTable_put("AVG_NOISE_FLOOR", "ANF", avgPeak.noise);
        this.statTable_put("AVG_NOISE_THRESHOLD", "ANT", avgPeak.thresh);
        this.statTable_put("AVG_SIGNAL_STRENGTH", "ASIG", avgSignal.signal);
        this.statTable_put("AVG_SIGNAL_SNR", "ASNR", avgSignal.snr);
        this.statTable_put("AVG_PEAK_SIGNAL_FREQ", "AFRQ", avgPeak.freq);
        this.statTable_put("AVG_PEAK_SIGNAL_STRENGTH", "APSG", avgPeak.signal);
        this.statTable_put("AVG_PEAK_SIGNAL_SNR", "APSN", avgPeak.snr);
        if (avgSignal.stats != null) {
            this.statTable_put("SIGNAL_MEAN", null, avgSignal.stats.mean);
            this.statTable_put("SIGNAL_SDEV", null, avgSignal.stats.stdDev);
            this.statTable_put("SIGNAL_ELEM", null, avgSignal.stats.nelem);
            this.statTable_put("SIGNAL_MIN", null, avgSignal.stats.min);
            this.statTable_put("SIGNAL_MAX", null, avgSignal.stats.max);
            this.statTable_put("SIGNAL_AMIN", null, avgSignal.stats.minAbs);
            this.statTable_put("SIGNAL_AMAX", null, avgSignal.stats.maxAbs);
            this.statTable_put("SIGNAL_OMIN", null, avgSignal.stats.minIndex);
            this.statTable_put("SIGNAL_OMAX", null, avgSignal.stats.maxIndex);
            this.statTable_put("SIGNAL_SUM", null, avgSignal.stats.sum);
        }
        if (avgPeak.stats != null) {
            this.statTable_put("SPECTRUM_MEAN", null, avgPeak.stats.mean);
            this.statTable_put("SPECTRUM_SDEV", null, avgPeak.stats.stdDev);
            this.statTable_put("SPECTRUM_ELEM", null, avgPeak.stats.nelem);
            this.statTable_put("SPECTRUM_MIN", null, avgPeak.stats.min);
            this.statTable_put("SPECTRUM_MAX", null, avgPeak.stats.max);
            this.statTable_put("SPECTRUM_AMIN", null, avgPeak.stats.minAbs);
            this.statTable_put("SPECTRUM_AMAX", null, avgPeak.stats.maxAbs);
            this.statTable_put("SPECTRUM_OMIN", null, avgPeak.stats.minIndex);
            this.statTable_put("SPECTRUM_OMAX", null, avgPeak.stats.maxIndex);
            this.statTable_put("SPECTRUM_SUM", null, avgPeak.stats.sum);
        }
        if (this.outFile.isOpen()) {
            if (statData.getHeader() instanceof Time) {
                this.outFile.setTimeAt((Time)statData.getHeader());
            }
            this.outFile.writeDataTable(this.statTable);
        }
    }

    private SNRResult avgResult(List<SNRResult> res) {
        switch (res.size()) {
            case 0: {
                return NO_RESULT;
            }
            case 1: {
                return res.get(0);
            }
        }
        double freq = 0.0;
        double signal = 0.0;
        double noise = 0.0;
        double thresh = 0.0;
        double rmean = 0.0;
        double imean = 0.0;
        double stdDev = 0.0;
        double min = 0.0;
        double max = 0.0;
        int minIndex = 0;
        int maxIndex = 0;
        int count = 0;
        Double rsum = null;
        Double isum = null;
        Integer nelem = null;
        Boolean complex = null;
        boolean hasStats = true;
        Stats stats = null;
        for (SNRResult r : res) {
            freq += (double)r.freq;
            signal += (double)r.signal;
            noise += (double)r.noise;
            thresh += (double)r.thresh;
            ++count;
            if (!hasStats || r.stats == null) {
                hasStats = false;
                continue;
            }
            if (count == 1) {
                rmean = r.stats.rmean;
                imean = r.stats.imean;
                rsum = r.stats.rsum;
                isum = r.stats.isum;
                stdDev = r.stats.stdDev;
                nelem = r.stats.nelem;
                complex = r.stats.complex;
                min = r.stats.min;
                max = r.stats.max;
                minIndex = r.stats.minIndex;
                maxIndex = r.stats.maxIndex;
                continue;
            }
            rmean += r.stats.rmean;
            imean += r.stats.imean;
            stdDev += r.stats.stdDev;
            rsum = rsum == null || r.stats.rsum == null ? null : Double.valueOf(rsum + r.stats.rsum);
            Double d = isum = isum == null || r.stats.isum == null ? null : Double.valueOf(isum + r.stats.isum);
            if (nelem == null && r.stats.nelem != null || nelem != null && (r.stats.nelem == null || nelem.intValue() != r.stats.nelem.intValue())) {
                hasStats = false;
            }
            if (complex == null && r.stats.complex != null || complex != null && (r.stats.complex == null || complex.booleanValue() != r.stats.complex.booleanValue())) {
                hasStats = false;
            }
            if (min > r.stats.min) {
                min = r.stats.min;
                minIndex = r.stats.minIndex;
            }
            if (!(max < r.stats.max)) continue;
            max = r.stats.max;
            maxIndex = r.stats.maxIndex;
        }
        if (hasStats) {
            double minAbs = this.fftFreqMin + (double)this.rcvrTF + (double)minIndex * this.fftFreqDelta;
            double maxAbs = this.fftFreqMin + (double)this.rcvrTF + (double)maxIndex * this.fftFreqDelta;
            stats = new Stats(rmean / (double)count, imean / (double)count, rsum, isum, stdDev / (double)count, min, max, minAbs, maxAbs, minIndex, maxIndex, nelem, complex);
        }
        return new SNRResult((int)Math.rint(freq / (double)count), (int)Math.rint(signal / (double)count), (int)Math.rint(noise / (double)count), (int)Math.rint(thresh / (double)count), "dB", stats);
    }

    private void statTable_put(String t6key, String t3key, Object val) {
        if (val != null) {
            if (t6key != null) {
                this.statTable.put(t6key, val);
            }
            if (t3key != null) {
                this.statTable.put(t3key, val);
            }
        } else {
            if (t6key != null) {
                this.statTable.remove(t6key);
            }
            if (t3key != null) {
                this.statTable.remove(t3key);
            }
        }
    }

    private SNRResult findSNR(double[] dbuf, float[] fbuf, int spa, int first, int last) {
        double dMean;
        double dStdDev;
        Stats thisStats;
        Stats initStats;
        boolean FUNC_DEBUG = false;
        double CLIP_WEIGHT = 1.0;
        double CLIP_DELTA = 0.5;
        Stats lastStats = initStats = dbuf != null ? this.computeStatistics(dbuf, spa, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0, first, last) : this.computeStatistics(fbuf, spa, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0, first, last);
        double peakFreq = (double)initStats.maxIndex * this.fftFreqDelta + this.fftFreqMin + (double)this.rcvrTF;
        double peak = initStats.max;
        double upperClip = initStats.max;
        double lowerClip = initStats.min;
        double upperFloor = initStats.max;
        double lowerFloor = initStats.min;
        while (true) {
            Stats stats = thisStats = dbuf != null ? this.computeStatistics(dbuf, spa, lowerClip, upperClip, 1.0, first, last) : this.computeStatistics(fbuf, spa, lowerClip, upperClip, 1.0, first, last);
            if (thisStats == null) break;
            dStdDev = thisStats.stdDev - lastStats.stdDev;
            dMean = thisStats.rmean - lastStats.rmean;
            if (Math.abs(dMean) > Math.abs(dStdDev) || thisStats.min >= thisStats.max) break;
            lowerFloor = lowerClip;
            lowerClip += 0.5;
            lastStats = thisStats;
        }
        lastStats = initStats;
        while (true) {
            Stats stats = thisStats = dbuf != null ? this.computeStatistics(dbuf, spa, lowerClip, upperClip, 1.0, first, last) : this.computeStatistics(fbuf, spa, lowerClip, upperClip, 1.0, first, last);
            if (thisStats == null) break;
            dStdDev = thisStats.stdDev - lastStats.stdDev;
            dMean = thisStats.rmean - lastStats.rmean;
            if (Math.abs(dMean) > Math.abs(dStdDev) || thisStats.min >= thisStats.max) break;
            upperFloor = upperClip;
            upperClip -= 0.5;
            lastStats = thisStats;
        }
        return sigstatistics._snr(peak, upperFloor, lowerFloor, peakFreq, initStats);
    }

    public int getNAvg() {
        return this.navg;
    }

    public int getNExp() {
        return this.nexp;
    }

    public int getNFft() {
        return this.nfft;
    }

    public double getOverlap() {
        return this.over;
    }

    public String getWindow() {
        return this.wname;
    }

    public void setNAvg(int value) {
        this.navg = Math.max(1, value);
        this.rnavg = 1.0 / (double)this.navg / (double)this.nexp;
    }

    public void setNExp(int value) {
        this.nexp = Math.max(1, value);
        this.rnexp = (1.0 - 1.0 / (double)this.nexp) * (double)this.nexp * (double)this.navg;
    }

    public void setNFft(int value) {
        if (value == this.nfft) {
            return;
        }
        this.MA.put("NFFT", "" + value);
        this.setState(7);
    }

    public void setOverlap(double value) {
        if (this.in2d && this.stride % this.nin != 0) {
            this.M.warning((CharSequence)("Type 2000 inputs don't have integral overlap=" + this.over));
        }
        this.over = value;
        this.stride = Math.max(0, (int)((1.0 - this.over) * (double)this.nin));
        this.inFile.setXferLength(this.nin);
        this.inFile.setConsLength(this.stride);
    }

    public void setWindow(String value) {
        int nwind = Math.min(this.nin, this.nfft);
        this.wname = value;
        this.winData = DataOp.getWindow((String)this.wname, (int)nwind, (double)this.factor, (Midas)this.M);
    }

    public synchronized Table getStatTable() {
        return this.statTable.copy();
    }

    public int getNoiseFloor() {
        return this.statTable.getL("NOISE_FLOOR");
    }

    public int getAvgNoiseFloor() {
        return this.statTable.getL("AVG_NOISE_FLOOR");
    }

    public int getNoiseThreshold() {
        return this.statTable.getL("NOISE_THRESHOLD");
    }

    public int getAvgNoiseThreshold() {
        return this.statTable.getL("AVG_NOISE_THRESHOLD");
    }

    public int getSignalStrength() {
        return this.statTable.getL("SIGNAL_STRENGTH");
    }

    public int getAvgSignalStrength() {
        return this.statTable.getL("AVG_SIGNAL_STRENGTH");
    }

    public int getSignalSNR() {
        return this.statTable.getL("SIGNAL_SNR");
    }

    public int getAvgSignalSNR() {
        return this.statTable.getL("AVG_SIGNAL_SNR");
    }

    public int getPeakSignalFreq() {
        return this.statTable.getL("PEAK_SIGNAL_FREQ");
    }

    public int getAvgPeakSignalFreq() {
        return this.statTable.getL("AVG_PEAK_SIGNAL_FREQ");
    }

    public int getPeakSignalStrength() {
        return this.statTable.getL("PEAK_SIGNAL_STRENGTH");
    }

    public int getAvgPeakSignalStrength() {
        return this.statTable.getL("AVG_PEAK_SIGNAL_STRENGTH");
    }

    public int getPeakSignalSNR() {
        return this.statTable.getL("PEAK_SIGNAL_SNR");
    }

    public int getAvgPeakSignalSNR() {
        return this.statTable.getL("AVG_PEAK_SIGNAL_SNR");
    }

    public static int snr(int Sp, int Np) {
        return sigstatistics._snr((double)((double)Sp), (double)((double)Np), (double)0.0, (double)0.0, null).snr;
    }

    @InternalUseOnly
    @Deprecated
    public static SNRResult _snr(double Sp, double Np, double Nt, double freq) {
        return sigstatistics._snr(Sp, Np, Nt, freq, null);
    }

    @InternalUseOnly
    public static SNRResult _snr(double Sp, double Np, double Nt, double freq, Stats stats) {
        if (Sp > Np) {
            double cn = Math.pow(10.0, Sp / 10.0);
            double n = Math.pow(10.0, Np / 10.0);
            double t = Math.pow(10.0, Nt / 10.0);
            return new SNRResult(freq, cn - n, n, t, stats);
        }
        double n = Math.pow(10.0, Np / 10.0);
        double t = Math.pow(10.0, Nt / 10.0);
        return new SNRResult(freq, n, n, t, stats);
    }

    private Stats computeStatistics(double[] buf, int spa, double lowerClip, double upperClip, double clipWeight, int first, int last) {
        double rsum = 0.0;
        double isum = 0.0;
        double stdDev = 0.0;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double count = 0.0;
        int nelem = last - first;
        int minIndex = -1;
        int maxIndex = -1;
        boolean complex = spa == 2;
        double upperClipSum = upperClip * clipWeight;
        double lowerClipSum = lowerClip * clipWeight;
        double upperClipSD = upperClipSum * upperClipSum;
        double lowerClipSD = lowerClipSum * lowerClipSum;
        if (spa != 2) {
            for (int i = first * spa; i < last * spa; ++i) {
                double val = buf[i];
                if (val > upperClip) {
                    rsum += upperClipSum;
                    stdDev += upperClipSD;
                    count += clipWeight;
                } else if (val < lowerClip) {
                    rsum += lowerClipSum;
                    stdDev += lowerClipSD;
                    count += clipWeight;
                } else {
                    double abs = val * val;
                    rsum += val;
                    stdDev += abs;
                    count += 1.0;
                }
                if (val > max) {
                    max = val;
                    maxIndex = i;
                }
                if (!(val < min)) continue;
                min = val;
                minIndex = i;
            }
        }
        double rmean = rsum / count;
        double imean = isum / count;
        stdDev = stdDev / count - rmean * rmean - imean * imean;
        double d = stdDev = stdDev < 0.0 ? 0.0 : Math.sqrt(stdDev);
        if (complex) {
            min = Math.sqrt(min);
            max = Math.sqrt(max);
        }
        double minAbs = this.fftFreqMin + (double)this.rcvrTF + (double)minIndex * this.fftFreqDelta;
        double maxAbs = this.fftFreqMin + (double)this.rcvrTF + (double)maxIndex * this.fftFreqDelta;
        return count == 0.0 ? null : new Stats(rmean, imean, rsum, isum, stdDev, min, max, minAbs, maxAbs, minIndex, maxIndex, nelem, complex);
    }

    private Stats computeStatistics(float[] buf, int spa, double lowerClip, double upperClip, double clipWeight, int first, int last) {
        double rsum = 0.0;
        double isum = 0.0;
        double stdDev = 0.0;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double count = 0.0;
        int nelem = last - first;
        int minIndex = -1;
        int maxIndex = -1;
        boolean complex = spa == 2;
        double upperClipSum = upperClip * clipWeight;
        double lowerClipSum = lowerClip * clipWeight;
        double upperClipSD = upperClipSum * upperClipSum;
        double lowerClipSD = lowerClipSum * lowerClipSum;
        if (spa != 2) {
            for (int i = first * spa; i < last * spa; ++i) {
                double val = buf[i];
                if (val > upperClip) {
                    rsum += upperClipSum;
                    stdDev += upperClipSD;
                    count += clipWeight;
                } else if (val < lowerClip) {
                    rsum += lowerClipSum;
                    stdDev += lowerClipSD;
                    count += clipWeight;
                } else {
                    double abs = val * val;
                    rsum += val;
                    stdDev += abs;
                    count += 1.0;
                }
                if (val > max) {
                    max = val;
                    maxIndex = i;
                }
                if (!(val < min)) continue;
                min = val;
                minIndex = i;
            }
        }
        double rmean = rsum / count;
        double imean = isum / count;
        stdDev = stdDev / count - rmean * rmean - imean * imean;
        double d = stdDev = stdDev < 0.0 ? 0.0 : Math.sqrt(stdDev);
        if (complex) {
            min = Math.sqrt(min);
            max = Math.sqrt(max);
        }
        double minAbs = this.fftFreqMin + (double)this.rcvrTF + (double)minIndex * this.fftFreqDelta;
        double maxAbs = this.fftFreqMin + (double)this.rcvrTF + (double)maxIndex * this.fftFreqDelta;
        return count == 0.0 ? null : new Stats(rmean, imean, rsum, isum, stdDev, min, max, minAbs, maxAbs, minIndex, maxIndex, nelem, complex);
    }

    @InternalUseOnly
    public static final class SNRResult
    implements Tablizable {
        final int freq;
        final int signal;
        final int noise;
        final int thresh;
        final int snr;
        final Stats stats;

        @Deprecated
        public SNRResult() {
            this(0, 0, 0, 0, "dB", null);
        }

        @Deprecated
        public SNRResult(double freq, double signal, double noise, double thresh) {
            this(freq, signal, noise, thresh, null);
        }

        SNRResult(double freq, double signal, double noise, double thresh, Stats stats) {
            this.freq = (int)Math.rint(freq);
            this.signal = (int)Math.rint(10.0 * Math.log10(signal));
            this.noise = (int)Math.rint(10.0 * Math.log10(noise));
            this.thresh = (int)Math.rint(10.0 * Math.log10(thresh));
            this.snr = (int)Math.rint(10.0 * Math.log10(signal / noise));
            this.stats = stats;
        }

        SNRResult(int freq, int signal, int noise, int thresh, String units, Stats stats) {
            if (!units.equals("dB")) {
                throw new IllegalArgumentException("Expected units=dB but found units=" + units);
            }
            this.freq = freq;
            this.signal = signal;
            this.noise = noise;
            this.thresh = thresh;
            this.snr = signal - noise;
            this.stats = stats;
        }

        public String toString() {
            return this.toTable().toString();
        }

        public Table toTable() {
            Table table = this.stats != null ? this.stats.toTable() : new Table();
            table.put("FREQ", this.freq);
            table.put("SIGNAL", this.signal);
            table.put("NOISE", this.noise);
            table.put("THRESH", this.thresh);
            table.put("SNR", this.snr);
            return table;
        }
    }

    @InternalUseOnly
    public static final class Stats
    implements Tablizable {
        final double rmean;
        final double imean;
        final double stdDev;
        final double min;
        final double max;
        final int minIndex;
        final int maxIndex;
        final Double rsum;
        final Double isum;
        final Double minAbs;
        final Double maxAbs;
        final Integer nelem;
        final Boolean complex;
        final Data sum;
        final Data mean;

        public Stats(double rmean, double imean, double stdDev, double min, double max, int minIndex, int maxIndex) {
            this(rmean, imean, null, null, stdDev, min, max, null, null, minIndex, maxIndex, null, null);
        }

        Stats(double rmean, double imean, Double rsum, Double isum, double stdDev, double min, double max, Double minAbs, Double maxAbs, int minIndex, int maxIndex, Integer nelem, Boolean complex) {
            this.rmean = rmean;
            this.imean = imean;
            this.rsum = rsum;
            this.isum = isum;
            this.stdDev = stdDev;
            this.min = min;
            this.max = max;
            this.minAbs = minAbs;
            this.maxAbs = maxAbs;
            this.minIndex = minIndex;
            this.maxIndex = maxIndex;
            this.nelem = nelem;
            this.complex = complex;
            if (complex == null) {
                this.sum = null;
                this.mean = null;
            } else if (complex.booleanValue()) {
                this.sum = new Data("CD", 1);
                this.mean = new Data("CD", 1);
                this.sum.setD(0, rsum.doubleValue());
                if (complex.booleanValue()) {
                    this.sum.setD(1, isum.doubleValue());
                }
                this.mean.setD(0, rmean);
                if (complex.booleanValue()) {
                    this.mean.setD(1, imean);
                }
            } else {
                this.sum = new Data("SD", 1);
                this.mean = new Data("SD", 1);
                this.sum.setD(0, rsum.doubleValue());
                this.mean.setD(0, rmean);
            }
        }

        public String toString() {
            return this.toTable().toString();
        }

        public Table toTable() {
            Table table = new Table();
            if (this.mean != null) {
                table.put("MEAN", (Object)this.mean);
            }
            table.put("SDEV", this.stdDev);
            if (this.nelem != null) {
                table.put("ELEM", (Object)this.nelem);
            }
            table.put("MIN", this.min);
            table.put("MAX", this.max);
            if (this.minAbs != null) {
                table.put("AMIN", (Object)this.minAbs);
            }
            if (this.maxAbs != null) {
                table.put("AMAX", (Object)this.maxAbs);
            }
            table.put("OMIN", this.minIndex);
            table.put("OMAX", this.maxIndex);
            if (this.sum != null) {
                table.put("SUM", (Object)this.sum);
            }
            return table;
        }
    }
}

