/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Shell;

public class normalize
extends Primitive {
    public static final String modeList = "MEAN,SD,PEAK,NONE";
    private static final int MEAN = 1;
    private static final int SD = 2;
    private static final int PEAK = 3;
    private static final int NONE = 4;
    private static boolean nativeLoaded = Shell.loadLibrary((String)"dsp", (String)"prim", (String)"normalize");
    private boolean useNative;
    private int fs = 16384;
    private int mode;
    private double scale;
    private double shift;
    private DataFile inputFile;
    private DataFile outputFile;
    private Data data;
    private int ape;
    private int numRead;
    private double rmean;
    private double imean;
    private double rsum;
    private double isum;
    private double magsum;
    private double stdDev;
    private double max;
    private double min;
    private boolean complex;

    private static native int nativeScaleAndShift(Object var0, double var1, double var3, int var5, int var6);

    public int open() {
        this.useNative = this.MA.getState("/NATIVE", true) && Native.useMath && nativeLoaded;
        this.mode = this.MA.getChoice("MODE", modeList, 2);
        this.scale = this.MA.getD("SCALE", 1.0);
        this.shift = this.MA.getD("SHIFT", 0.0);
        this.inputFile = this.MA.getDataFile("IN", "1000,2000", "S#,C#", 0);
        this.inputFile.open(131072);
        this.outputFile = this.MA.getDataFile("OUT", this.inputFile, 0);
        this.complex = this.inputFile.getFormatMode() == 67;
        this.ape = this.inputFile.getAPE();
        byte outType = Data.promoteType((byte)this.inputFile.dataType, (byte)70);
        this.outputFile.setFormatType(outType);
        this.outputFile.setSize(this.inputFile.getSize());
        this.outputFile.open(131136);
        if (this.inputFile.getTypeCodeClass() == 2) {
            this.fs = this.inputFile.getFrameSize();
            this.xfer = 1;
        } else {
            this.fs = this.MA.getL("FS", this.fs);
            if (this.fs <= 0) {
                this.M.error("Invalid frame size specified: " + this.fs);
                return 9;
            }
            this.xfer = this.fs = Math.max(Math.min(this.fs, (int)this.inputFile.getSize()), 1);
        }
        this.data = this.outputFile.getDataBuffer(this.xfer);
        this.resetAccumulators();
        return 0;
    }

    public int process() {
        this.numRead = this.inputFile.read(this.data);
        if (this.numRead == 0) {
            return -1;
        }
        if (this.numRead == -1) {
            return 9;
        }
        this.resetAccumulators();
        if (this.mode != 4) {
            this.computeStatistics(this.data, this.numRead, this.ape, this.complex);
        }
        switch (this.mode) {
            case 2: {
                this.sdNormalize(this.data, this.scale, this.shift);
                break;
            }
            case 1: {
                this.zeroMean(this.data, this.scale, this.shift);
                break;
            }
            case 3: {
                this.normalizePeaks(this.data, this.scale, this.shift);
                break;
            }
            case 4: {
                this.scaleAndShift(this.data, this.scale, this.shift);
            }
        }
        this.outputFile.write(this.data, this.numRead);
        return 0;
    }

    public int close() {
        this.inputFile.close();
        this.outputFile.close();
        return 0;
    }

    public String getMode() {
        return Parser.get((String)modeList, (int)this.mode);
    }

    public void setMode(String modeStr) {
        this.mode = Parser.find((String)modeList, (String)modeStr, (int)this.mode, (int)0, (int)2);
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scaleFactor) {
        this.scale = scaleFactor;
    }

    public double getShift() {
        return this.shift;
    }

    public void setShift(double shiftAmount) {
        this.shift = shiftAmount;
    }

    protected void resetAccumulators() {
        this.stdDev = 0.0;
        this.magsum = 0.0;
        this.isum = 0.0;
        this.rsum = 0.0;
        this.max = -1.0E37;
        this.min = 1.0E37;
    }

    protected void computeStatistics(Data data, int ngot, int atomsPerElement, boolean complex) {
        double[] dbuf = data.castD(true);
        if (complex) {
            int i = 0;
            while (i < ngot * atomsPerElement * 2) {
                double rval = dbuf[i++];
                double ival = dbuf[i++];
                this.rsum += rval;
                this.isum += ival;
                double mag = rval * rval + ival * ival;
                this.magsum += mag;
                if (mag > this.max) {
                    this.max = mag;
                }
                if (!(mag < this.min)) continue;
                this.min = mag;
            }
        } else {
            int i = 0;
            while (i < ngot * atomsPerElement) {
                double dval = dbuf[i++];
                this.rsum += dval;
                this.magsum += dval * dval;
                if (dval > this.max) {
                    this.max = dval;
                }
                if (!(dval < this.min)) continue;
                this.min = dval;
            }
        }
        data.uncast(dbuf, false);
        this.finishCalculations();
    }

    protected void finishCalculations() {
        int nelem = this.numRead * this.ape;
        this.rmean = this.rsum / (double)nelem;
        this.imean = this.isum / (double)nelem;
        this.stdDev = this.magsum / (double)nelem - this.rmean * this.rmean - this.imean * this.imean;
        this.stdDev = Math.sqrt(Math.max(0.0, this.stdDev));
        if (this.complex) {
            this.min = Math.sqrt(this.min);
            this.max = Math.sqrt(this.max);
        }
    }

    private void sdNormalize(Data data, double scale, double shift) {
        boolean noScale = this.stdDev == 0.0;
        scale = noScale ? 1.0 : scale / this.stdDev;
        this.zeroMean(data, scale, shift);
    }

    private void zeroMean(Data data, double scale, double shift) {
        this.scaleAndShift(data, scale, shift -= this.rmean * scale);
        if (this.complex) {
            this.shiftImaginary(data, this.rmean * scale - this.imean * scale);
        }
    }

    private void shiftImaginary(Data data, double shift) {
        double[] dbuf = data.castD(true);
        this.scalarAddToArray(dbuf, shift, 1, 2);
        data.uncast(dbuf, true);
    }

    private void normalizePeaks(Data data, double scale, double shift) {
        double range = this.max - this.min;
        if (range == 0.0) {
            this.scaleAndShift(data, 1.0, shift - this.max);
            return;
        }
        if (this.complex) {
            Data norm = data.copy();
            this.sdNormalize(norm, 1.0, 0.0);
            this.resetAccumulators();
            this.computeStatistics(norm, this.numRead, this.ape, true);
            range = this.max - this.min;
            scale = range == 0.0 ? 1.0 : scale / range;
            this.scaleAndShift(data, scale, shift -= scale * (this.max + this.min) / 2.0);
        } else {
            shift += 0.5 * scale - this.max * scale / range;
            this.scaleAndShift(data, scale /= range, shift);
        }
    }

    private void scaleAndShift(Data data, double scale, double shift) {
        float[] array = data.castF(true);
        if (this.useNative) {
            normalize.nativeScaleAndShift(array, scale, shift, 0, array.length);
        } else if (scale == 1.0 || shift == 0.0) {
            this.scalarMultiplyToArray(array, scale);
            this.scalarAddToArray(array, shift);
        } else {
            int i;
            int unroll = 4;
            int end = array.length;
            int unrolledEnd = end - end % unroll;
            for (i = 0; i < unrolledEnd; i += unroll) {
                array[i] = (float)((double)array[i] * scale + shift);
                array[i + 1] = (float)((double)array[i + 1] * scale + shift);
                array[i + 2] = (float)((double)array[i + 2] * scale + shift);
                array[i + 3] = (float)((double)array[i + 3] * scale + shift);
            }
            while (i < end) {
                array[i] = (float)((double)array[i] * scale + shift);
                ++i;
            }
        }
        data.uncast(array, true);
    }

    private void scalarMultiplyToArray(float[] array, double scale) {
        int i;
        if (scale == 1.0) {
            return;
        }
        int unroll = 4;
        int end = array.length;
        int unrolledEnd = end - end % unroll;
        for (i = 0; i < unrolledEnd; i += unroll) {
            int n = i;
            array[n] = (float)((double)array[n] * scale);
            int n2 = i + 1;
            array[n2] = (float)((double)array[n2] * scale);
            int n3 = i + 2;
            array[n3] = (float)((double)array[n3] * scale);
            int n4 = i + 3;
            array[n4] = (float)((double)array[n4] * scale);
        }
        while (i < end) {
            int n = i++;
            array[n] = (float)((double)array[n] * scale);
        }
    }

    private void scalarAddToArray(float[] array, double shift) {
        int i;
        if (shift == 0.0) {
            return;
        }
        int unroll = 4;
        int end = array.length;
        int unrolledEnd = end - end % unroll;
        for (i = 0; i < unrolledEnd; i += unroll) {
            int n = i;
            array[n] = (float)((double)array[n] + shift);
            int n2 = i + 1;
            array[n2] = (float)((double)array[n2] + shift);
            int n3 = i + 2;
            array[n3] = (float)((double)array[n3] + shift);
            int n4 = i + 3;
            array[n4] = (float)((double)array[n4] + shift);
        }
        while (i < end) {
            int n = i++;
            array[n] = (float)((double)array[n] + shift);
        }
    }

    private void scalarAddToArray(double[] data, double shift, int start, int stride) {
        int i;
        if (shift == 0.0) {
            return;
        }
        int unroll = 4;
        int move = unroll * stride;
        int end = data.length - start;
        int unrolledEnd = end - end % move;
        for (i = start; i < unrolledEnd; i += move) {
            int n = i;
            data[n] = data[n] + shift;
            int n2 = i + stride;
            data[n2] = data[n2] + shift;
            int n3 = i + 2 * stride;
            data[n3] = data[n3] + shift;
            int n4 = i + 3 * stride;
            data[n4] = data[n4] + shift;
        }
        while (i < end) {
            int n = i;
            data[n] = data[n] + shift;
            i += stride;
        }
    }
}

