/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataOp;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Primitive;
import nxm.sys.libm.Fft;

public class invfft
extends Primitive {
    private static final String windowList = DataOp.windowList;
    private static final String partialList = "None,All,Start";
    private static final int P_NONE = 1;
    private static final int P_ALL = 2;
    private static final int P_START = 3;
    private static final String packList = "Unpack,DC,Zero";
    private static final int P_UNPACK = 1;
    private static final int P_DC = 2;
    private static final int P_ZERO = 3;
    private DataFile hi1;
    private DataFile ho1;
    private Data dbi1;
    private Data dbf1;
    private Data dbw;
    private Data dba1;
    private Data db;
    private Data dbr1;
    private Data dbr2;
    private Data dbo;
    private int nfft;
    private int nin;
    private int nrot;
    private int nout;
    private int stride;
    private int pack;
    private int partial;
    private double over;
    private int keepSamples;
    private double size;
    private boolean cxm;
    private boolean out1d;
    private boolean outReal;
    private boolean in2d;
    private boolean dp;
    private boolean deRotate;
    private Fft fft;
    private String wname;

    public int open() {
        double stry;
        double dely;
        this.hi1 = this.MA.getDataFile("IN", "1000,2000", "S#,C#", 0);
        this.hi1.open(131072);
        this.in2d = this.hi1.typeClass == 2;
        this.outReal = this.MA.getState("/REAL", false);
        this.pack = this.in2d ? this.MA.getSelectionIndex("/PACK", packList, 3) : this.MA.getSelectionIndex("/PACK", packList, 1);
        this.nfft = this.MA.getL("NFFT");
        if (this.nfft == -1) {
            this.nfft = (int)this.hi1.getSize();
        }
        this.nin = this.MA.getL("/TL", this.nfft);
        if (this.nin != this.nfft) {
            throw new MidasException("Transfer lengths other than FFT size not yet implemented.");
        }
        if (this.outReal) {
            this.nin = this.pack == 1 ? this.nfft / 2 + 1 : this.nfft / 2;
        }
        this.out1d = this.MA.getState("/1D");
        this.partial = this.MA.getSelectionIndex("/PARTIAL", partialList, 3);
        if (this.state != 7) {
            this.over = this.MA.getD("OVER");
            this.wname = this.MA.getS("WIN");
        }
        double delf = this.hi1.getXDelta();
        double delx = 0.0;
        boolean bl = this.cxm = this.hi1.spa == 2;
        if (this.in2d) {
            this.nin = this.hi1.getSubSize();
            dely = this.hi1.getYDelta();
            stry = this.hi1.getYStart();
            stry -= this.hi1.getYDelta() / 2.0;
            this.hi1.setFS(0);
        } else {
            dely = this.hi1.getYDelta();
            stry = this.hi1.getYStart();
            dely = delx * (double)this.stride;
            stry = this.hi1.getXStart();
        }
        this.hi1.setXferLength(this.nin);
        this.hi1.setConsLength(this.nin);
        this.setOverlap(this.over);
        this.size = this.hi1.size;
        int flags = 16;
        byte dtype = this.dp ? (byte)68 : 70;
        String cform = this.dp ? "CD" : "CF";
        String sform = this.dp ? "SD" : "SF";
        this.deRotate = this.MA.getState("/ROTATE", true);
        if (!this.outReal) {
            this.nout = this.nfft;
            this.nrot = this.nfft / 2 - 1;
            flags |= 2;
            this.pack = 0;
            if (!this.deRotate) {
                this.nrot = 0;
            }
        } else {
            this.nout = this.nfft;
            this.nrot = 0;
            flags |= 2;
        }
        this.fft = new Fft(this.nfft, flags);
        String oform = this.outReal ? sform : cform;
        double osize = this.out1d ? 1.0 : Math.max(1.0, Math.floor(this.size - (double)this.nfft));
        this.ho1 = this.MA.getDataFile("OUT", "2000", oform, 0);
        this.ho1.propagate(this.hi1, "TIMECODE|KEYWORDS");
        this.ho1.setSubSize(this.keepSamples);
        this.ho1.setXStart(0.0);
        this.ho1.setXDelta(1.0 / (delf * (double)this.nfft));
        this.ho1.setXUnits(1);
        this.ho1.setYStart(stry);
        this.ho1.setYDelta(dely);
        if (!this.out1d) {
            this.ho1.setYUnits(1);
        }
        this.ho1.setSize(osize);
        this.ho1.open(131136);
        this.setWindow(this.wname);
        this.dbi1 = this.hi1.getDataBuffer(this.nin, dtype);
        this.dbf1 = new Data(cform, this.nout);
        if (this.over > 0.0) {
            this.dbo = new Data(cform, this.nout);
        }
        this.dbr1 = new Data(cform, this.nout);
        this.dbr2 = new Data(sform, this.nout);
        this.dba1 = this.ho1.getDataBuffer(1, dtype);
        return 0;
    }

    public int process() {
        int n1;
        int stat = 0;
        int n = n1 = this.hi1.isOpen ? this.hi1.read(this.dbi1) : 0;
        if (n1 < 0) {
            stat = 9;
            return stat;
        }
        if (this.outReal) {
            n1 = this.nfft;
        }
        if (this.outReal) {
            if ((n1 == this.nin * 2 || this.partial != 1) && this.hi1.isOpen) {
                this.processInput(n1, this.ho1, this.dbi1, this.dbf1, this.dba1);
            }
        } else if ((n1 == this.nin || this.partial != 1) && this.hi1.isOpen) {
            this.processInput(n1, this.ho1, this.dbi1, this.dbf1, this.dba1);
        }
        if (this.out1d) {
            stat = 9;
        }
        if (this.partial == 3) {
            this.partial = 1;
        }
        return stat;
    }

    private void processInput(int n, DataFile ho, Data dbi, Data dbf, Data dba) {
        try {
            dbf.setSPA(dbi.spa);
            DataOp.copy((Data)dbi, (Data)dbf);
            if (this.outReal) {
                if (this.pack == 2) {
                    DataOp.copy((Data)dbi, (int)dbi.bpe, (int)dbi.bpe, (Data)dbf, (int)((this.nfft - 1) * dbf.bpe), (int)(-dbf.bpe), (int)dbf.bpe, (int)(this.nin - 1));
                    for (int i = this.nfft / 2; i < this.nfft; ++i) {
                        dbf.setF(2 * i + 1, -dbf.getF(2 * i + 1));
                    }
                    dbf.setF(this.nfft, dbf.getF(1));
                    dbf.setF(1, 0.0f);
                } else if (this.pack == 3) {
                    DataOp.copy((Data)dbi, (int)dbi.bpe, (int)dbi.bpe, (Data)dbf, (int)((this.nfft - 1) * dbf.bpe), (int)(-dbf.bpe), (int)dbf.bpe, (int)(this.nin - 1));
                    for (int i = this.nfft / 2; i < this.nfft; ++i) {
                        dbf.setF(2 * i + 1, -dbf.getF(2 * i + 1));
                    }
                } else {
                    DataOp.copy((Data)dbi, (int)dbi.bpe, (int)dbi.bpe, (Data)dbf, (int)((this.nfft - 1) * dbf.bpe), (int)(-dbf.bpe), (int)dbf.bpe, (int)(this.nin - 1));
                    for (int i = this.nfft / 2 + 1; i < this.nfft; ++i) {
                        dbf.setF(2 * i + 1, -dbf.getF(2 * i + 1));
                    }
                }
            }
            if (n < this.nfft) {
                DataOp.zero((Data)dbf, (int)n, (int)(this.nfft - n));
            }
            if (this.cxm && dbi.spa == 1) {
                DataOp.cmplx((Data)dbf, (Data)dbf, (int)this.nfft, (int)33);
            }
            if (this.nrot != 0) {
                this.fft.unrotate(dbf, this.nrot);
            }
            this.fft.work(dbf);
            if (!this.wname.equalsIgnoreCase("none")) {
                DataOp.copy((Data)dbf, (Data)this.dbr1);
                DataOp.div((Data)this.dbr1, (Data)this.dbw, (Data)dbf);
            }
            dbf.setSPA(2);
            this.db = dbf;
            if (this.keepSamples < this.nin) {
                DataOp.copy((Data)dbf, (Data)this.dbo);
                this.dbo.setSize(this.keepSamples);
                this.db = this.dbo;
            }
            if (this.outReal) {
                DataOp.real((Data)this.db, (Data)this.dbr2);
                this.db = this.dbr2;
            }
            ho.write(this.db);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int close() {
        this.fft.free();
        if (this.out1d && this.ho1.isOpen) {
            this.ho1.setFS(0);
        }
        this.hi1.close();
        this.ho1.close();
        return 0;
    }

    public int processReady() {
        if (this.state != 2) {
            return 0;
        }
        int n = this.hi1.processReady(this.nin);
        if (this.ho1.isOpen) {
            n = Math.min(n, this.ho1.processReady(1));
        }
        return n;
    }

    public void setOverlap(double value) {
        this.over = value;
        this.keepSamples = Math.max(0, (int)((1.0 - this.over) * (double)this.nfft));
    }

    public int getNFft() {
        return this.nfft;
    }

    public void setNFft(int value) {
        if (value == this.nfft) {
            return;
        }
        this.MA.put("NFFT", "" + value);
        this.setState(7);
    }

    public void setWindow(String value) {
        int nwind = this.nfft;
        this.wname = value;
        this.dbw = DataOp.getWindow((String)this.wname, (int)nwind, (double)1.0, (Midas)this.M);
        for (int i = 0; i < this.dbw.getSize(); ++i) {
            if (!((double)Math.abs(this.dbw.getF(i)) < 1.0E-4)) continue;
            this.dbw.setF(i, 1.0f);
        }
    }
}

