/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataOp;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Primitive;

public class firhlbrt
extends Primitive {
    private DataFile ho;
    private Data dbo;
    private Data dbw;
    private int ntap;
    private int nhlf;
    private int tl;
    private double scale;
    private String wname;

    public int open() {
        this.tl = this.MA.getL("/TL", 0x100000);
        this.ntap = this.MA.getL("NTAP");
        if (this.ntap < 3 || this.ntap > this.tl) {
            this.M.error("Number taps=" + this.ntap + " out of range [3," + this.tl + "]");
        }
        if (this.ntap % 2 == 0) {
            --this.ntap;
            this.M.warning((CharSequence)("Number taps reduced by one to an odd value=" + this.ntap));
        }
        this.nhlf = this.ntap / 2;
        this.wname = this.MA.getS("WIND");
        if (this.wname.startsWith("Y")) {
            this.wname = "HANN";
        }
        this.scale = this.MA.getD("/SCALE", 1.0);
        this.ho = this.MA.getDataFile("OUT", "1000", "SF", 0);
        this.ho.setSize((double)this.ntap);
        this.ho.setXStart((double)(-this.nhlf));
        this.ho.open(2);
        this.dbo = this.ho.getDataBuffer(this.ntap, (byte)70);
        float[] fbo = this.dbo.castF(false);
        this.dbw = DataOp.getWindow((String)this.wname, (int)(-this.ntap), (double)this.scale, (Midas)this.M);
        float[] fbw = this.dbw.castF(true);
        firhlbrt.generate(this.ntap, fbw, fbo);
        this.dbw.uncast(fbw, false);
        this.dbo.uncast(fbo, true);
        this.ho.write(this.dbo, this.ntap);
        this.ho.close();
        return 9;
    }

    public static void generate(int ntap, float[] wind, float[] filt) {
        int i;
        int nhlf = ntap / 2;
        float c = 0.63661975f;
        for (i = 0; i < ntap; ++i) {
            filt[i] = wind[i];
        }
        for (i = 1; i <= nhlf; i += 2) {
            float s = c / (float)i;
            filt[nhlf + i] = s * filt[nhlf + i];
            filt[nhlf - i] = -filt[nhlf + i];
        }
        for (i = 0; i <= nhlf; i += 2) {
            filt[nhlf + i] = 0.0f;
            filt[nhlf - i] = 0.0f;
        }
    }
}

