/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataOp;
import nxm.sys.lib.Primitive;
import nxm.sys.libm.Fft;

public class fdfilter
extends Primitive {
    private DataFile hi;
    private DataFile hf;
    private DataFile ho;
    private Data dbw;
    private Data dbf;
    private Data dbm;
    private int nfft;
    private int nfir;
    private int nbins;
    private int flags;
    private int bias;
    private int keep;
    private int over;
    private int pad1;
    private int pad2;
    private boolean mux;
    private boolean pad;
    private boolean cxm;
    private Fft fft;
    private Fft ifft;
    private double scale;

    public int open() {
        this.hi = this.MA.getDataFile("IN", "1000", "S#,C#", 0);
        this.hi.open();
        this.hf = this.MA.getDataFile("FIR", "1000", "S#,C#", 0);
        this.hf.open();
        this.cxm = this.hi.spa == 2 || this.hf.spa == 2;
        this.mux = this.MA.getState("/MUX");
        boolean bl = this.pad = this.MA.getState("/PAD") || this.mux;
        if (this.mux && this.cxm) {
            this.M.error("Cannot /MUX with complex input file");
        }
        this.nfft = 8192;
        if (this.MA.getState("/FFT")) {
            this.nfft = this.MA.getL("/FFT");
            this.M.deprecate((CharSequence)"FDFILTER: Use of /FFT is deprecated. Use /NFFT instead.");
        }
        this.nfft = this.MA.getL("/NFFT", this.nfft);
        this.nfir = (int)this.hf.size;
        this.over = this.nfir - 1;
        this.keep = this.nfft - this.over;
        this.bias = (int)Math.round(this.hf.getXStart() / this.hf.getXDelta());
        if (this.pad) {
            this.pad1 = this.over + this.bias;
            this.pad2 = -this.bias;
        } else {
            this.pad2 = 0;
            this.pad1 = 0;
        }
        if (this.cxm) {
            this.flags = 2;
            this.scale = 1.0 / (double)this.nfft;
            this.nbins = this.nfft;
        } else {
            this.flags = 65;
            this.scale = 1.0 / (double)(4 * this.nfft);
            this.nbins = this.nfft / 2 + 1;
        }
        this.fft = new Fft(this.nfft, this.flags | 8);
        this.ifft = new Fft(this.nfft, this.flags | 0x10);
        this.ho = this.MA.getDataFile("OUT", this.hi, 0);
        this.ho.setSize(this.hi.getSize() - (double)this.over + (double)this.pad1 + (double)this.pad2);
        this.ho.setXStart(this.hi.getXStart() + (double)(this.bias + this.over - this.pad1) * this.hi.getXDelta());
        if (this.cxm || this.mux) {
            this.ho.setFormatMode((byte)67);
        }
        this.ho.open();
        this.hi.setXferLength(this.nfft);
        this.hi.setConsLength(this.keep);
        this.dbw = new Data("CF", this.nbins);
        this.dbf = new Data("CF", this.nbins);
        this.dbm = new Data("CF", this.nfft);
        return 0;
    }

    public int process() {
        int n;
        if (this.hf.avail() > 0.0) {
            this.loadFilter();
        }
        if (this.pad1 > 0) {
            DataOp.zero((Data)this.dbw, (int)0, (int)this.pad1);
            this.dbw.boff = this.pad1 * this.dbw.bpe;
            this.hi.setXferLength(this.nfft - this.pad1);
            this.hi.setConsLength(this.keep - this.pad1);
        }
        if ((n = this.hi.read(this.dbw)) == 0) {
            return -1;
        }
        if (n < this.over) {
            return 9;
        }
        if (this.pad1 > 0) {
            this.dbw.boff = 0;
            this.hi.setXferLength(this.nfft);
            this.hi.setConsLength(this.keep);
            n += this.pad1;
            this.pad1 = Math.max(0, this.pad1 - this.keep);
        }
        if (n < this.nfft) {
            DataOp.zero((Data)this.dbw, (int)n, (int)(this.nfft - n));
            n = Math.min(this.nfft, n + this.pad2);
        }
        if (this.cxm && this.hi.spa == 1) {
            DataOp.cmplx((Data)this.dbw, (Data)this.dbw, (int)this.nfft, (int)33);
        }
        if (this.mux) {
            DataOp.copy((Data)this.dbw, (int)(-this.bias * 4), (int)4, (Data)this.dbm, (int)0, (int)8, (int)4, (int)(n - this.over));
        }
        this.fft.work(this.dbw);
        this.dbw.setSPA(2);
        DataOp.mul((Data)this.dbw, (Data)this.dbf, (Data)this.dbw, (int)this.nbins, (int)546);
        this.ifft.work(this.dbw);
        if (this.mux) {
            this.dbw.setSPA(1);
            DataOp.copy((Data)this.dbw, (int)0, (int)4, (Data)this.dbm, (int)4, (int)8, (int)4, (int)(n - this.over));
            this.ho.write(this.dbm, n - this.over);
        } else {
            this.dbw.setSPA(this.ho.spa);
            this.ho.write(this.dbw, n - this.over);
        }
        return 0;
    }

    public int close() {
        this.fft.free();
        this.ifft.free();
        this.hi.close();
        this.hf.close();
        this.ho.close();
        return 0;
    }

    private void loadFilter() {
        float fscale = (float)this.scale;
        this.dbw.setSPA(this.hf.spa);
        this.hf.read(this.dbw, this.nfir);
        if (this.MA.find("/SCALE")) {
            float cscale = this.MA.getF("/SCALE");
            fscale *= cscale;
        }
        Data dbs = new Data(fscale);
        DataOp.mul((Data)this.dbw, (Data)dbs, (Data)this.dbw, (int)this.nfir);
        this.dbf.setSPA(this.hf.spa);
        DataOp.zero((Data)this.dbf, (int)0, (int)this.nfft);
        DataOp.copy((Data)this.dbw, (int)0, (Data)this.dbf, (int)(this.nfft - this.over), (int)this.over);
        DataOp.copy((Data)this.dbw, (int)this.over, (Data)this.dbf, (int)0, (int)1);
        if (this.cxm && this.hf.spa == 1) {
            DataOp.cmplx((Data)this.dbf, (Data)this.dbf, (int)this.nfft, (int)33);
        }
        this.fft.work(this.dbf);
        this.dbf.setSPA(2);
    }

    public int getNFft() {
        return this.nfft;
    }

    public void setNFft(int value) {
        this.MA.put("/NFFT", "" + value);
        this.setState(7);
    }
}

