/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.XmUtil;

public class dpco
extends Primitive {
    private DataFile chirpFile;
    private DataFile freqFile;
    private DataFile phaseFile;
    private double chirpValue;
    private double freqValue;
    private double phaseValue;
    private int chirpNGot;
    private int freqNGot;
    private int phaseNGot;
    private Data chirpBuf;
    private Data freqBuf;
    private Data phaseBuf;
    private DataFile outSin;
    private DataFile outCos;
    private DataFile outCmplx;
    private DataFile outPhase;
    private DataFile outFreq;
    private Data sinOut;
    private Data cosOut;
    private Data cmplxOut;
    private Data phaseOut;
    private Data freqOut;
    private double xStart;
    private double xDelta;
    private double start;
    private double end;
    private double chirpStart;
    private double chirpEnd;
    private double freqStart;
    private double freqEnd;
    private double freqInst;
    private double freqInstOld;
    private double phaseStart;
    private double phaseEnd;
    private double phase;
    private double phaseOld;
    private double ntogo;
    private int ntodo;
    private boolean abscissa;
    private boolean first;

    public int open() {
        double numPoints;
        String addressing = this.MA.getS("ADDRESSING");
        this.xDelta = this.MA.getD("DELTA");
        this.xStart = this.MA.getD("START");
        this.abscissa = addressing.equals("ABSCISSA") || addressing.startsWith("AB");
        double origNumPoints = numPoints = Math.rint(this.MA.getD("ELEM"));
        double xEnd = this.xStart + (numPoints - 1.0) * this.xDelta;
        String _inFreq = this.MA.getO("INFREQ", (Object)0).toString();
        String _inPahse = this.MA.getO("INPHASE", (Object)0).toString();
        String _inChirp = this.MA.getO("INCHIRP", (Object)0).toString();
        if (StringUtil.isNumber((String)_inFreq)) {
            this.freqFile = null;
            this.freqValue = Convert.o2d((Object)_inFreq);
        } else {
            this.freqFile = this.MA.getDataFile("INFREQ", "1000", "S#,-SP", 1);
            this.freqValue = 0.0;
        }
        if (StringUtil.isNumber((String)_inPahse)) {
            this.phaseFile = null;
            this.phaseValue = Convert.o2d((Object)_inPahse);
        } else {
            this.phaseFile = this.MA.getDataFile("INPHASE", "1000", "S#,-SP", 1);
            this.phaseValue = 0.0;
        }
        if (StringUtil.isNumber((String)_inChirp)) {
            this.chirpFile = null;
            this.chirpValue = Convert.o2d((Object)_inChirp);
        } else {
            this.chirpFile = this.MA.getDataFile("INCHIRP", "1000", "S#,-SP", 1);
            this.chirpValue = 0.0;
        }
        if (this.freqFile != null) {
            this.freqFile.open();
            if (this.abscissa) {
                if (this.freqFile.getXDelta() < this.xDelta) {
                    throw new MidasException("Frequency file increment too small");
                }
                this.xStart = Math.max(this.freqFile.getXStart(), this.xStart);
                xEnd = Math.min(this.freqFile.getXStart() + this.freqFile.getSize() * this.freqFile.getXDelta(), xEnd);
            } else {
                this.freqFile.setXStart(this.xStart);
                this.freqFile.setXDelta(this.xDelta);
                numPoints = Math.min(this.freqFile.getSize(), numPoints);
            }
        }
        if (this.phaseFile != null) {
            this.phaseFile.open();
            if (this.abscissa) {
                if (this.phaseFile.getXDelta() < this.xDelta) {
                    throw new MidasException("Phase file increment too small");
                }
                this.xStart = Math.max(this.phaseFile.getXStart(), this.xStart);
                xEnd = Math.min(this.phaseFile.getXStart() + this.phaseFile.getSize() * this.phaseFile.getXDelta(), xEnd);
            } else {
                this.phaseFile.setXStart(this.xStart);
                this.phaseFile.setXDelta(this.xDelta);
                numPoints = Math.min(this.phaseFile.getSize(), numPoints);
            }
        }
        if (this.chirpFile != null) {
            this.chirpFile.open();
            if (this.abscissa) {
                if (this.chirpFile.getXDelta() < this.xDelta) {
                    throw new MidasException("Chirp file increment too small");
                }
                this.xStart = Math.max(this.chirpFile.getXStart(), this.xStart);
                xEnd = Math.min(this.chirpFile.getXStart() + this.chirpFile.getSize() * this.chirpFile.getXDelta(), xEnd);
            } else {
                this.chirpFile.setXStart(this.xStart);
                this.chirpFile.setXDelta(this.xDelta);
                numPoints = Math.min(this.chirpFile.getSize(), numPoints);
            }
        }
        if (this.abscissa) {
            numPoints = this.freqFile != null || this.phaseFile != null || this.chirpFile != null ? (double)((int)((xEnd - this.xStart) / this.xDelta + 1.0)) : Math.rint((xEnd - this.xStart) / this.xDelta + 1.0);
        }
        if (numPoints <= 0.0) {
            throw new MidasException("Input files outside output abscissa range");
        }
        if (numPoints != origNumPoints) {
            this.M.warning((CharSequence)("Number of points reduced from " + origNumPoints + " to " + numPoints));
        }
        this.outSin = this.openOutputDataFile("OUTSIN", "SF", numPoints);
        this.outCos = this.openOutputDataFile("OUTCOS", "SF", numPoints);
        this.outPhase = this.openOutputDataFile("OUTPHASE", "SF", numPoints);
        this.outFreq = this.openOutputDataFile("OUTFREQ", "SF", numPoints);
        this.outCmplx = this.openOutputDataFile("OUTCOMPLEX", "CF", numPoints);
        this.outFreq.setXStart(this.outFreq.getXStart() + this.outFreq.getXDelta());
        if (!(this.outSin.isOpen() || this.outCos.isOpen() || this.outCmplx.isOpen() || this.outPhase.isOpen() || this.outFreq.isOpen())) {
            this.M.warning((CharSequence)"No output files specified");
            return 9;
        }
        this.xfer = this.MA.getL("/TL", 16384);
        this.freqBuf = new Data("SD", this.xfer, (Number)this.freqValue);
        this.phaseBuf = new Data("SD", this.xfer, (Number)(this.phaseValue / 360.0));
        this.chirpBuf = new Data("SD", this.xfer, (Number)this.chirpValue);
        this.freqOut = new Data("SD", this.xfer);
        this.sinOut = new Data("SD", this.xfer);
        this.cosOut = new Data("SD", this.xfer);
        this.phaseOut = new Data("SD", this.xfer);
        this.cmplxOut = new Data("CD", this.xfer);
        if (this.freqFile != null) {
            this.freqFile.buffer = this.freqFile.getDataBuffer(this.xfer, 'D');
            this.freqEnd = this.xStart - 1.0;
        }
        if (this.phaseFile != null) {
            this.phaseFile.buffer = this.phaseFile.getDataBuffer(this.xfer, 'D');
            this.phaseEnd = this.xStart - 1.0;
        }
        if (this.chirpFile != null) {
            this.chirpFile.buffer = this.chirpFile.getDataBuffer(this.xfer, 'D');
            this.chirpEnd = this.xStart - 1.0;
        }
        this.phase = 0.0;
        this.phaseOld = 0.0;
        this.freqInst = 0.0;
        this.freqInstOld = 0.0;
        this.ntogo = numPoints;
        this.ntodo = (int)Math.min(this.ntogo, (double)this.xfer);
        this.start = this.xStart - (double)this.ntodo * this.xDelta;
        this.end = this.xStart - this.xDelta;
        this.first = true;
        return 0;
    }

    public int process() {
        int j;
        int index;
        if (this.ntogo <= 0.0) {
            return 9;
        }
        this.start += (double)this.ntodo * this.xDelta;
        this.end += (double)this.ntodo * this.xDelta;
        this.ntodo = (int)Math.min(this.ntogo, (double)this.xfer);
        this.ntogo -= (double)this.ntodo;
        if (this.freqFile != null) {
            if (this.freqEnd < this.end) {
                index = (int)((this.start - this.freqFile.getXStart()) / this.freqFile.getXDelta());
                this.freqNGot = this.abscissa ? this.freqFile.read(this.freqFile.buffer, (double)index, this.xfer) : this.freqFile.read(this.freqBuf, (double)index, this.xfer);
                this.freqStart = this.freqFile.getXStart() + (double)index * this.freqFile.getXDelta();
                this.freqEnd = this.freqStart + (double)(this.freqNGot - 1) * this.freqFile.getXDelta();
            }
            if (this.abscissa) {
                XmUtil.interpd((int)this.freqNGot, (double)this.freqStart, (double)this.freqFile.getXDelta(), (Data)this.freqFile.buffer, (int)this.ntodo, (double)this.start, (double)this.xDelta, (Data)this.freqBuf, (int)1, (int)1);
            }
        }
        if (this.phaseFile != null) {
            if (this.phaseEnd < this.end) {
                int j2;
                double[] _phase;
                index = (int)((this.start - this.phaseFile.getXStart()) / this.phaseFile.getXDelta());
                if (this.abscissa) {
                    this.phaseNGot = this.phaseFile.read(this.phaseFile.buffer, (double)index, this.xfer);
                    _phase = this.phaseFile.buffer.castD(true);
                    for (j2 = 0; j2 < this.phaseNGot; ++j2) {
                        _phase[j2] = _phase[j2] / 360.0;
                    }
                    this.phaseFile.buffer.uncast(_phase, true);
                } else {
                    this.phaseNGot = this.phaseFile.read(this.phaseBuf, (double)index, this.xfer);
                    _phase = this.phaseBuf.castD(true);
                    for (j2 = 0; j2 < this.phaseNGot; ++j2) {
                        _phase[j2] = _phase[j2] / 360.0;
                    }
                    this.phaseBuf.uncast(_phase, true);
                }
                this.phaseStart = this.phaseFile.getXStart() + (double)index * this.phaseFile.getXDelta();
                this.phaseEnd = this.phaseStart + (double)(this.phaseNGot - 1) * this.phaseFile.getXDelta();
            }
            if (this.abscissa) {
                XmUtil.interpd((int)this.phaseNGot, (double)this.phaseStart, (double)this.phaseFile.getXDelta(), (Data)this.phaseFile.buffer, (int)this.ntodo, (double)this.start, (double)this.xDelta, (Data)this.phaseBuf, (int)1, (int)1);
            }
        }
        if (this.chirpFile != null) {
            if (this.chirpEnd < this.end) {
                index = (int)((this.start - this.chirpFile.getXStart()) / this.chirpFile.getXDelta());
                this.chirpNGot = this.abscissa ? this.chirpFile.read(this.chirpFile.buffer, (double)index, this.xfer) : this.chirpFile.read(this.chirpBuf, (double)index, this.xfer);
                this.chirpStart = this.chirpFile.getXStart() + (double)index * this.chirpFile.getXDelta();
                this.chirpEnd = this.chirpStart + (double)(this.chirpNGot - 1) * this.chirpFile.getXDelta();
            }
            if (this.abscissa) {
                XmUtil.interpd((int)this.chirpNGot, (double)this.chirpStart, (double)this.chirpFile.getXDelta(), (Data)this.chirpFile.buffer, (int)this.ntodo, (double)this.start, (double)this.xDelta, (Data)this.chirpBuf, (int)1, (int)1);
            }
        }
        double[] _chirpIn = this.chirpBuf.castD(true);
        double[] _freqIn = this.freqBuf.castD(true);
        double[] _phaseIn = this.phaseBuf.castD(true);
        double[] _freqOut = this.freqOut.castD(false);
        double[] _phaseOut = this.phaseOut.castD(false);
        for (j = 0; j < this.ntodo; ++j) {
            double phaseTemp = _phaseIn[j];
            phaseTemp -= Math.rint(phaseTemp);
            this.phase = this.phase + phaseTemp - this.phaseOld;
            this.phase -= Math.rint(this.phase);
            _phaseOut[j] = this.phase;
            this.phaseOld = phaseTemp;
            this.freqInst += _chirpIn[j] * this.xDelta;
            _freqOut[j] = _freqIn[j] + (this.freqInst + this.freqInstOld) * 0.5;
            phaseTemp = _freqOut[j] * this.xDelta;
            phaseTemp -= Math.rint(phaseTemp);
            this.phase += phaseTemp;
            this.freqInstOld = this.freqInst;
        }
        this.chirpBuf.uncast(_chirpIn, false);
        this.freqBuf.uncast(_freqIn, false);
        this.phaseBuf.uncast(_phaseIn, false);
        this.freqBuf.uncast(_freqOut, this.outFreq.isOpen());
        if (this.outCmplx.isOpen() || this.outSin.isOpen() || this.outCos.isOpen()) {
            double[] _cosOut = this.cosOut.castD(false);
            double[] _sinOut = this.sinOut.castD(false);
            double[] _cmplxOut = this.cmplxOut.castD(false);
            for (int j3 = 0; j3 < this.ntodo; ++j3) {
                _cosOut[j3] = Math.cos(_phaseOut[j3] * (Math.PI * 2));
                _sinOut[j3] = Math.sin(_phaseOut[j3] * (Math.PI * 2));
                _cmplxOut[j3 * 2 + 0] = _cosOut[j3];
                _cmplxOut[j3 * 2 + 1] = _sinOut[j3];
            }
            this.cosOut.uncast(_cosOut, this.outCos.isOpen());
            this.sinOut.uncast(_sinOut, this.outSin.isOpen());
            this.cmplxOut.uncast(_cmplxOut, this.outCmplx.isOpen());
            if (this.outSin.isOpen()) {
                this.outSin.write(this.sinOut, this.ntodo);
            }
            if (this.outCos.isOpen()) {
                this.outCos.write(this.cosOut, this.ntodo);
            }
            if (this.outCmplx.isOpen()) {
                this.outCmplx.write(this.cmplxOut, this.ntodo);
            }
        }
        if (this.outPhase.isOpen()) {
            for (j = 0; j < this.ntodo; ++j) {
                if (_phaseOut[j] > 0.5) {
                    _phaseOut[j] = _phaseOut[j] - 1.0;
                }
                _phaseOut[j] = _phaseOut[j] * 360.0;
            }
            this.phaseBuf.uncast(_phaseOut, true);
            this.outPhase.write(this.phaseOut, this.ntodo);
        } else {
            this.phaseBuf.uncast(_phaseOut, false);
        }
        if (this.outFreq.isOpen()) {
            if (this.first) {
                this.freqOut.boff += this.freqOut.bpe;
                this.outFreq.write(this.freqOut, this.ntodo - 1);
                this.first = false;
                this.freqOut.boff -= this.freqOut.bpe;
            } else {
                this.outFreq.write(this.freqOut, this.ntodo);
            }
        }
        return 0;
    }

    public int close() {
        if (this.phaseFile != null) {
            this.phaseFile.close();
            this.phaseFile = null;
        }
        if (this.freqFile != null) {
            this.freqFile.close();
            this.freqFile = null;
        }
        if (this.chirpFile != null) {
            this.chirpFile.close();
            this.chirpFile = null;
        }
        if (this.outSin != null) {
            this.outSin.close();
            this.outSin = null;
        }
        if (this.outCos != null) {
            this.outCos.close();
            this.outCos = null;
        }
        if (this.outCmplx != null) {
            this.outCmplx.close();
            this.outCmplx = null;
        }
        if (this.outPhase != null) {
            this.outPhase.close();
            this.outPhase = null;
        }
        if (this.outFreq != null) {
            this.outFreq.close();
            this.outFreq = null;
        }
        return 0;
    }

    private DataFile openOutputDataFile(String name, String format, double size) {
        DataFile df = this.MA.getDataFile(name, "1000", format, 66);
        df.setSize(size);
        df.setXStart(this.xStart);
        df.setXDelta(this.xDelta);
        df.setXUnits(1);
        df.open();
        return df;
    }
}

