/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import java.util.Arrays;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Native;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Shell;

public class correlate
extends Primitive {
    private static boolean loaded = Shell.loadLibrary((String)"dsp", (String)"prim", (String)"correlate");
    private int tl = 4096;
    private boolean useNative;
    private boolean normalize;
    private boolean quiet;
    private DataFile inputFile;
    private DataFile in1File;
    private DataFile outputFile;
    private DataFile impulseFile;
    private DataFile in2File;
    private Data inputData;
    private Data impulseData;
    private Data outputData;
    private double outXStart;
    private float[] inNormFactors;
    private float[] input;
    private float[] impulse;
    private float[] output;
    private float max;
    private int maxIndex;
    private int impulseTransfer;
    private int numInput;
    private int numImpulse;
    private int unprocessed;
    private int totalProcessed;
    private int shouldProcess;
    private boolean done;
    private boolean noop;
    private boolean complexIn;
    private boolean complexImp;

    private static native int correlateNative(Object var0, Object var1, Object var2, int var3, int var4);

    private static native int normalizedCorrelateNative(Object var0, Object var1, Object var2, int var3, int var4, Object var5);

    public int open() {
        this.totalProcessed = 0;
        this.maxIndex = 0;
        this.max = 0;
        this.useNative = this.MA.getState("/NATIVE", true) && Native.useMath && loaded;
        this.normalize = this.MA.getState("/NORMALIZE", false);
        this.quiet = this.MA.getState("/QUIET", false);
        this.inputFile = this.MA.getDataFile("IN", "1000", "S#, C#", 0);
        this.impulseFile = this.MA.getDataFile("IMPULSE", "1000", "S#, C#", 0);
        this.inputFile.open(131072);
        this.impulseFile.open(131072);
        this.complexIn = this.inputFile.spa == 2;
        this.complexImp = this.impulseFile.spa == 2;
        int inputSize = (int)this.inputFile.getSize();
        int impulseSize = (int)this.impulseFile.getSize();
        if (inputSize <= 0 || impulseSize <= 0) {
            this.M.error("An input file is empty.  Check IN and IMPULSE.");
        }
        if (inputSize >= impulseSize) {
            this.in1File = this.inputFile;
            this.in2File = this.impulseFile;
        } else {
            this.in1File = this.impulseFile;
            this.in2File = this.inputFile;
            int tempSize = inputSize;
            inputSize = impulseSize;
            impulseSize = tempSize;
        }
        if (this.in1File.getXDelta() != this.in2File.getXDelta()) {
            this.M.warning((CharSequence)"Deltas are not the same");
        }
        this.outputFile = this.MA.getDataFile("OUT", this.in1File, 0);
        this.outXStart = this.in1File.getXStart() - this.in2File.getXStart() - (this.in2File.getSize() - 1.0);
        this.outputFile.setXStart(this.outXStart);
        this.outputFile.setSize((double)(inputSize + impulseSize) - 1.0);
        this.outputFile.open();
        this.tl = this.MA.getL("/TL", this.tl);
        if (this.tl <= 0) {
            this.M.error("Invalid transfer length.");
            return 9;
        }
        this.tl = Math.min(inputSize, this.tl);
        this.impulseTransfer = impulseSize;
        this.outputData = this.outputFile.getDataBuffer(this.tl, (byte)70);
        this.impulseData = this.in2File.getDataBuffer(this.impulseTransfer, (byte)70);
        this.inputData = this.in1File.getDataBuffer(this.tl, (byte)70);
        this.setupImpulseArray();
        this.input = new float[this.tl + this.impulseTransfer];
        if (this.normalize) {
            this.inNormFactors = new float[this.tl];
        }
        this.unprocessed = this.numImpulse - 1;
        for (int i = 0; i < this.unprocessed; ++i) {
            this.input[i] = 0.0f;
        }
        return 0;
    }

    public int process() {
        int shouldProcess;
        int processed;
        if (this.noop) {
            this.noop = false;
            return -1;
        }
        for (shouldProcess = this.setupInput(); shouldProcess > this.tl; shouldProcess -= processed) {
            processed = this.work(this.tl);
        }
        while (shouldProcess > 0) {
            processed = this.work(shouldProcess);
            shouldProcess -= processed;
        }
        return this.done ? 9 : 0;
    }

    public int close() {
        if (!this.quiet) {
            this.M.info((CharSequence)("max was " + this.max + ", at abcissa " + this.maxIndex + " in the larger file"));
        }
        this.inputFile.close();
        this.impulseFile.close();
        this.outputFile.close();
        return 0;
    }

    private int setupInput() {
        int shouldProcess = 0;
        int read = Math.min(this.input.length - this.unprocessed, this.tl);
        this.numInput = this.in1File.read(this.inputData, read);
        if (this.numInput == 0 && read > 0) {
            this.noop = true;
            return shouldProcess;
        }
        boolean bl = this.done = this.numInput < 0;
        if (!this.done) {
            float[] temp = this.inputData.castF(true);
            int i = 0;
            int j = this.unprocessed;
            while (i < this.numInput) {
                this.input[j] = temp[i];
                ++i;
                ++j;
            }
            this.inputData.uncast(temp, false);
            this.unprocessed += this.numInput;
            shouldProcess = Math.max(this.unprocessed - this.numImpulse + 1, 0);
        } else {
            shouldProcess = this.unprocessed;
            int length = this.input.length;
            for (int i = this.unprocessed; i < length; ++i) {
                this.input[i] = 0.0f;
            }
        }
        return shouldProcess;
    }

    private void setupImpulseArray() {
        this.numImpulse = this.in2File.read(this.impulseData);
        float[] temp = this.impulseData.castF(true);
        this.impulse = Arrays.copyOf(temp, temp.length);
        if (this.normalize) {
            this.normalize(this.impulse);
        }
        this.impulseData.uncast(temp, false);
    }

    private int work(int toProcess) {
        int processed;
        if (toProcess == 0) {
            return 0;
        }
        this.output = this.outputData.castF(false);
        if (this.normalize) {
            this.getNormalizationFactors(toProcess);
            processed = this.useNative ? correlate.normalizedCorrelateNative(this.input, this.impulse, this.output, toProcess, this.numImpulse, this.inNormFactors) : this.normalizedCorrelation(toProcess);
        } else {
            processed = this.useNative ? correlate.correlateNative(this.input, this.impulse, this.output, toProcess, this.numImpulse) : this.correlation(toProcess);
        }
        this.unprocessed -= processed;
        this.totalProcessed += processed;
        if (!this.quiet) {
            this.updateMax(processed);
        }
        this.outputData.uncast(this.output, true);
        this.outputFile.write(this.outputData, processed);
        int i = 0;
        int j = processed;
        while (i < this.unprocessed) {
            this.input[i] = this.input[j];
            ++i;
            ++j;
        }
        if (this.done) {
            int end = this.unprocessed + processed;
            for (i = this.unprocessed; i < end; ++i) {
                this.input[i] = 0.0f;
            }
        }
        return processed;
    }

    private int normalizedCorrelation(int toProcess) {
        int j;
        int ij;
        int i;
        int unrolledEnd = toProcess - 4;
        for (i = 0; i < unrolledEnd; i += 4) {
            double sum4 = 0.0;
            double sum3 = 0.0;
            double sum2 = 0.0;
            double sum1 = 0.0;
            ij = i;
            j = 0;
            while (j < this.numImpulse) {
                float impVal = this.impulse[j];
                sum1 += (double)(this.input[ij] * impVal);
                sum2 += (double)(this.input[ij + 1] * impVal);
                sum3 += (double)(this.input[ij + 2] * impVal);
                sum4 += (double)(this.input[ij + 3] * impVal);
                ++j;
                ++ij;
            }
            this.output[i] = (float)(sum1 / (double)this.inNormFactors[i]);
            this.output[i + 1] = (float)(sum2 / (double)this.inNormFactors[i + 1]);
            this.output[i + 2] = (float)(sum3 / (double)this.inNormFactors[i + 2]);
            this.output[i + 3] = (float)(sum4 / (double)this.inNormFactors[i + 3]);
        }
        while (i < toProcess) {
            double sum = 0.0;
            ij = i;
            j = 0;
            while (j < this.numImpulse) {
                sum += (double)(this.input[ij] * this.impulse[j]);
                ++j;
                ++ij;
            }
            this.output[i] = (float)sum / this.inNormFactors[i];
            ++i;
        }
        return toProcess;
    }

    private int correlation(int toProcess) {
        int j;
        int ij;
        double sum1;
        double sum2;
        double sum3;
        double sum4;
        int i;
        int unroll = 4;
        int unrolledEnd = toProcess - 4;
        if (this.complexIn && this.complexImp) {
            float in2;
            float in1;
            float impVal2;
            float impVal1;
            for (i = 0; i < unrolledEnd; i += unroll) {
                sum4 = 0.0;
                sum3 = 0.0;
                sum2 = 0.0;
                sum1 = 0.0;
                ij = 2 * i;
                for (j = 0; j < 2 * this.numImpulse; j += 2) {
                    impVal1 = this.impulse[j];
                    impVal2 = this.impulse[j + 1];
                    in1 = this.input[ij];
                    in2 = this.input[ij + 1];
                    sum1 += (double)(in1 * impVal1 - in2 * impVal2);
                    sum2 += (double)(in1 * impVal2 + in2 * impVal1);
                    in1 = this.input[ij += 2];
                    in2 = this.input[ij + 1];
                    sum3 += (double)(in1 * impVal1 - in2 * impVal2);
                    sum4 += (double)(in1 * impVal2 + in2 * impVal1);
                }
                this.output[i] = (float)sum1;
                this.output[i + 1] = (float)sum2;
                this.output[i + 2] = (float)sum3;
                this.output[i + 3] = (float)sum4;
            }
            while (i < toProcess) {
                sum2 = 0.0;
                sum1 = 0.0;
                ij = 2 * i;
                j = 0;
                while (j < 2 * this.numImpulse) {
                    impVal1 = this.impulse[j];
                    impVal2 = this.impulse[j + 1];
                    in1 = this.input[ij];
                    in2 = this.input[ij + 1];
                    sum1 += (double)(in1 * impVal1 - in2 * impVal2);
                    sum2 += (double)(in1 * impVal2 + in2 * impVal1);
                    j += 2;
                    ij += 2;
                }
                this.output[i] = (float)sum1;
                this.output[i + 1] = (float)sum2;
                i += 2;
            }
        } else if (this.complexIn || this.complexImp) {
            // empty if block
        }
        for (i = 0; i < unrolledEnd; i += unroll) {
            sum4 = 0.0;
            sum3 = 0.0;
            sum2 = 0.0;
            sum1 = 0.0;
            ij = i;
            j = 0;
            while (j < this.numImpulse) {
                float impVal = this.impulse[j];
                sum1 += (double)(this.input[ij] * impVal);
                sum2 += (double)(this.input[ij + 1] * impVal);
                sum3 += (double)(this.input[ij + 2] * impVal);
                sum4 += (double)(this.input[ij + 3] * impVal);
                ++j;
                ++ij;
            }
            this.output[i] = (float)sum1;
            this.output[i + 1] = (float)sum2;
            this.output[i + 2] = (float)sum3;
            this.output[i + 3] = (float)sum4;
        }
        while (i < toProcess) {
            double sum = 0.0;
            ij = i;
            j = 0;
            while (j < this.numImpulse) {
                sum += (double)(this.input[ij] * this.impulse[j]);
                ++j;
                ++ij;
            }
            this.output[i] = (float)sum;
            ++i;
        }
        return toProcess;
    }

    private void updateMax(int processed) {
        for (int i = 0; i < processed; ++i) {
            float temp = this.output[i];
            if (!(temp > this.max)) continue;
            this.max = temp;
            this.maxIndex = this.totalProcessed - processed + i + (int)this.outXStart;
        }
    }

    private void getNormalizationFactors(int toProcess) {
        double temp;
        int i;
        double sumsquared = 0.0;
        double sum = 0.0;
        for (i = 0; i < this.numImpulse; ++i) {
            temp = this.input[i];
            sum += temp;
            sumsquared += temp * temp;
        }
        i = 0;
        int j = this.numImpulse;
        while (i < toProcess) {
            temp = sum / (double)this.numImpulse;
            double temp2 = Math.sqrt(sumsquared - sum * temp);
            this.inNormFactors[i] = temp2 == 0.0 ? 1.0f : (float)temp2;
            temp = this.input[i];
            temp2 = this.input[j];
            sum += temp2 - temp;
            sumsquared += temp2 * temp2 - temp * temp;
            ++i;
            ++j;
        }
    }

    @Deprecated
    public float[] copyArray(float[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public void normalize(float[] array) {
        int i;
        int length = array.length;
        double mean = 0.0;
        for (int i2 = 0; i2 < length; ++i2) {
            mean += (double)array[i2];
        }
        mean /= (double)length;
        double stdDevFactorFactor = 0.0;
        for (i = 0; i < length; ++i) {
            double centered = (double)array[i] - mean;
            array[i] = (float)centered;
            stdDevFactorFactor += centered * centered;
        }
        if ((stdDevFactorFactor = Math.sqrt(stdDevFactorFactor)) != 0.0) {
            i = 0;
            while (i < length) {
                int n = i++;
                array[n] = (float)((double)array[n] / stdDevFactorFactor);
            }
        }
    }

    static String array2String(float[] arr) {
        String str = "" + arr[0];
        for (int i = 1; i < arr.length; ++i) {
            str = str + ", " + arr[i];
        }
        return str;
    }
}

