/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.prim;

import nxm.dsp.lib.Complex;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;

public class amfsync
extends Primitive {
    private DataFile inputFile;
    private DataFile outputFile;
    private DataFile syncOutFile;
    private Data inputBuffer;
    private Data outputBuffer;
    private Data syncOutBuffer;
    private boolean cxin = false;
    private int nget;
    private double p_start;
    private double bufstart;
    private double pp_delta;
    private double pstep_nominal;
    private int nextout;
    private double ifirst;
    private double indlast;
    private double rfirst;
    private int ngot;
    private int nhave;
    private int npts;
    private int ncleft;
    private int lfilt;
    private int decfac;
    private float[][] cbufin;
    private float[][] cbufout;
    private float[] magbuf;
    private float[] bufin;
    private float[] bufout;
    private int kfilt;
    private double istart;
    private double indbase;
    private int blksize;
    private int outblk;
    private String sync_mode;
    private int pbufsize;
    private float[] phasebuf;
    private boolean syncout;
    private float[] cfilt;
    private float[] sfilt;
    private double timelast;
    private double time_now;
    private double time_step;
    private double pri;
    private double xx_delta1;
    private int sup_fact;
    private double x_start1;
    private float sumr;
    private float sumi;
    private boolean[] warn;
    private static final int L_BBUF = 524288;
    private static final int L_RBUF = 131072;
    private static final int L_CBUF = 65536;
    private static final int PBUFSIZE_MAX = 4096;
    private static final int REAL = 0;
    private static final int IMAG = 1;

    public int open() {
        int i;
        double brate = this.MA.getD("BRATE");
        this.pri = 1.0 / brate;
        this.lfilt = this.MA.getL("LFILT");
        this.decfac = this.lfilt / 4;
        this.sync_mode = this.MA.getS("SYNC_MODE");
        this.sup_fact = Math.max(this.MA.getL("SUP_FACT"), 1);
        this.inputFile = this.MA.getDataFile("IN", "1000", "S#,-SP,C#", 0);
        this.inputFile.open();
        this.cxin = this.inputFile.getSPA() == 2;
        this.x_start1 = this.inputFile.getXStart();
        this.xx_delta1 = this.inputFile.getXDelta();
        double size1 = this.inputFile.getSize();
        double size2 = size1 * this.xx_delta1 / this.pri * (double)this.sup_fact;
        if (this.lfilt < 128) {
            this.M.warning((CharSequence)"AMFSYNC - BPF length increased to 128");
            this.lfilt = 128;
        } else if (this.lfilt > 131072) {
            this.M.warning((CharSequence)"AMFSYNC - BPF length too large, decreased.");
            this.lfilt = 131072;
        }
        this.blksize = Math.min(524288 / (int)Math.max(this.inputFile.getBPE(), 4.0) + this.lfilt * 3 / 4, 524288 / (int)Math.max(this.inputFile.getBPE(), 4.0));
        if (this.blksize < this.lfilt) {
            this.M.error("Buffer too short for filter");
        }
        this.kfilt = (this.blksize - this.lfilt) / this.decfac;
        this.blksize = this.lfilt + this.kfilt * this.decfac;
        this.outblk = this.MA.getL("/OTL", -1);
        this.outblk = Math.min(131072, this.outblk);
        if (this.outblk < 0) {
            this.outblk = this.blksize / 2;
        }
        this.outputFile = this.MA.getDataFile("OUT", this.inputFile, 0);
        this.outputFile.setXDelta(this.pri / (double)this.sup_fact);
        this.outputFile.setSize(size2);
        this.outputFile.setXStart(this.inputFile.getXStart() + 0.5 * this.pri);
        this.outputFile.open();
        String name3 = this.MA.getS("SYNCOUT");
        this.syncout = !name3.equals("");
        this.p_start = this.x_start1 + ((double)this.lfilt - 1.0) * 0.5 * this.xx_delta1;
        this.pp_delta = this.xx_delta1 * (double)(this.lfilt / 4);
        if (this.syncout) {
            this.syncOutFile = this.MA.getDataFile("SYNCOUT", "1000", "SF", 0);
            this.syncOutFile.setXStart(this.p_start);
            this.syncOutFile.setXDelta(this.pp_delta);
            this.syncOutFile.open();
        }
        if (this.syncout && name3.charAt(0) == '_' && this.pp_delta != 0.0) {
            this.pbufsize = (int)((double)this.blksize * this.xx_delta1 / this.pp_delta);
            this.pbufsize = Math.min(Math.max(this.pbufsize, 2), 4096);
        } else {
            this.pbufsize = 4096;
        }
        this.sumr = 0.0f;
        this.sumi = 0.0f;
        this.cfilt = new float[this.lfilt + 1];
        this.sfilt = new float[this.lfilt + 1];
        for (i = 1; i <= this.lfilt; ++i) {
            double t = (double)i - ((double)this.lfilt + 1.0) / 2.0;
            this.cfilt[i] = (float)((1.0 + Math.cos(t * (Math.PI * 2) / (double)this.lfilt)) * Math.cos(t * this.xx_delta1 * brate * (Math.PI * 2)));
            this.sumr += this.cfilt[i];
            this.sfilt[i] = (float)((1.0 + Math.cos(t * (Math.PI * 2) / (double)this.lfilt)) * Math.sin(t * this.xx_delta1 * brate * (Math.PI * 2)));
            this.sumi += this.sfilt[i];
        }
        this.sumr /= (float)this.lfilt;
        this.sumi /= (float)this.lfilt;
        for (i = 1; i <= this.lfilt; ++i) {
            this.cfilt[i] = this.cfilt[i] - this.sumr;
            this.sfilt[i] = this.sfilt[i] - this.sumi;
        }
        this.bufstart = this.p_start = this.x_start1 + ((double)this.lfilt - 1.0) * 0.5 * this.xx_delta1;
        this.pp_delta = this.xx_delta1 * (double)this.decfac;
        this.pstep_nominal = this.pp_delta * brate;
        this.nextout = 1;
        this.ifirst = 1.0;
        this.indlast = 0.0;
        this.rfirst = 1.0;
        this.ngot = 0;
        this.nget = 0;
        this.nhave = 0;
        this.npts = 0;
        this.ncleft = 0;
        this.timelast = this.x_start1 - this.pri;
        this.warn = new boolean[5];
        for (i = 1; i <= 4; ++i) {
            this.warn[i] = true;
        }
        this.inputBuffer = this.inputFile.getDataBuffer(this.blksize, (byte)70);
        this.outputBuffer = this.outputFile.getDataBuffer(this.blksize, (byte)70);
        if (this.syncout) {
            this.syncOutBuffer = this.syncOutFile.getDataBuffer(this.pbufsize, (byte)70);
        }
        this.cbufin = new float[65537][2];
        this.cbufout = new float[65537][2];
        this.magbuf = new float[131073];
        this.bufin = new float[131073];
        this.bufout = new float[131073];
        this.phasebuf = new float[4099];
        return 0;
    }

    public int process() {
        int j;
        double index;
        int i;
        if ((double)Math.round(this.rfirst) >= this.indlast) {
            int i2;
            int j2;
            float[] inputWork;
            int i3;
            if (this.ngot < this.nget) {
                return 9;
            }
            int nsave = Math.min(this.lfilt - this.decfac, this.nhave);
            if (this.cxin) {
                if (nsave > 65536) {
                    this.M.error("nsave too large complex");
                }
                for (i3 = 1; i3 <= nsave; ++i3) {
                    this.cbufin[i3][0] = this.cbufin[(this.kfilt + 1) * this.decfac + i3][0];
                    this.cbufin[i3][1] = this.cbufin[(this.kfilt + 1) * this.decfac + i3][1];
                    this.magbuf[i3] = this.magbuf[(this.kfilt + 1) * this.decfac + i3];
                }
            } else {
                if (nsave > 131072) {
                    this.M.error("nsave too large real");
                }
                for (i3 = 1; i3 <= nsave; ++i3) {
                    this.bufin[i3] = this.bufin[(this.kfilt + 1) * this.decfac + i3];
                    this.magbuf[i3] = this.magbuf[(this.kfilt + 1) * this.decfac + i3];
                }
            }
            this.ifirst = this.ifirst + (double)this.nhave - (double)nsave;
            this.istart = this.ifirst + (double)nsave;
            this.indbase = this.ifirst - 1.0;
            this.nget = this.blksize - nsave;
            if (this.cxin) {
                if (nsave + this.nget > 65536) {
                    this.M.error("grab too large complex");
                }
            } else if (nsave + this.nget > 131072) {
                this.M.error("grab too large real");
            }
            this.ngot = this.inputFile.read(this.inputBuffer, this.nget);
            if (this.ngot == 0) {
                return -1;
            }
            if (this.cxin) {
                inputWork = this.inputBuffer.castF(true);
                j2 = nsave + 1;
                try {
                    for (i2 = 0; i2 < this.ngot * 2; i2 += 2) {
                        this.cbufin[j2][0] = inputWork[i2];
                        this.cbufin[j2][1] = inputWork[i2 + 1];
                        ++j2;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.M.error("amfsync: array index of cbufin or inputWork out of bounds");
                }
                this.inputBuffer.uncast(inputWork, false);
                if (this.sync_mode.equalsIgnoreCase("REA")) {
                    for (i2 = nsave + 1; i2 <= nsave + this.ngot; ++i2) {
                        this.magbuf[i2] = Math.abs(this.cbufin[i2][0]);
                    }
                } else if (this.sync_mode.equalsIgnoreCase("IMA")) {
                    for (i2 = nsave + 1; i2 <= nsave + this.ngot; ++i2) {
                        this.magbuf[i2] = Math.abs(this.cbufin[i2][1]);
                    }
                } else {
                    for (i2 = nsave + 1; i2 <= nsave + this.ngot; ++i2) {
                        this.magbuf[i2] = Complex.cabs(this.cbufin[i2][0], this.cbufin[i2][1]);
                    }
                }
            } else {
                inputWork = this.inputBuffer.castF(true);
                j2 = nsave + 1;
                for (i2 = 0; i2 < this.ngot; ++i2) {
                    this.bufin[j2++] = inputWork[i2];
                }
                this.inputBuffer.uncast(inputWork, false);
                for (i2 = nsave + 1; i2 <= nsave + this.ngot; ++i2) {
                    this.magbuf[i2] = Math.abs(this.bufin[i2]);
                }
            }
            this.nhave = nsave + this.ngot;
            this.indlast = this.ngot == this.nget ? this.indbase + (double)((this.kfilt + 2) * this.decfac) : this.indbase + (double)this.nhave;
            if (this.npts + this.kfilt >= Math.min(this.outblk, this.pbufsize)) {
                if (this.syncout) {
                    float[] syncWork = this.syncOutBuffer.castF(false);
                    for (int i4 = 0; i4 < this.npts - 3 && i4 < this.phasebuf.length - 1; ++i4) {
                        syncWork[i4] = this.phasebuf[i4 + 1];
                    }
                    this.syncOutBuffer.uncast(syncWork, true);
                    this.syncOutFile.write(this.syncOutBuffer, this.npts - 2);
                }
                this.phasebuf[1] = this.phasebuf[this.npts - 1];
                this.phasebuf[2] = this.phasebuf[this.npts];
                this.bufstart += (double)(this.npts - 2) * this.pp_delta;
                this.npts = 2;
            }
            int klast = (this.nhave - this.lfilt) / this.decfac;
            for (int k = 0; k <= klast; ++k) {
                this.sumr = 0.0f;
                this.sumi = 0.0f;
                for (i2 = 1; i2 <= this.lfilt; ++i2) {
                    this.sumr += this.magbuf[i2 + this.decfac * k] * this.cfilt[i2];
                    this.sumi += this.magbuf[i2 + this.decfac * k] * this.sfilt[i2];
                }
                ++this.npts;
                if (this.npts > this.pbufsize) {
                    this.M.error("store past end of phase buf");
                }
                this.phasebuf[this.npts] = (double)this.sumi == 0.0 && (double)this.sumr == 0.0 ? 0.0f : (float)(-Math.atan2(this.sumi, this.sumr) / (Math.PI * 2));
            }
        }
        double rstep = 0.0;
        double rfstep = 0.0;
        if (this.ncleft < 1) {
            this.next_clock(this.timelast, this.time_now, this.time_step, this.ncleft);
            if (this.ncleft < 1) {
                this.M.warning((CharSequence)"AMFSYNC: Serious bug after next_clock");
                this.ncleft = 1;
            }
            rstep = this.time_step / this.xx_delta1;
            rfstep = rstep / (double)this.sup_fact;
            this.rfirst = (this.time_now - this.x_start1) / this.xx_delta1 + 1.0;
            this.timelast = this.time_now - this.time_step;
        }
        int ndleft = (int)((this.indlast - (double)Math.round(this.rfirst)) / rstep + 1.0);
        int nloop = Math.min(ndleft, Math.min(this.ncleft, this.blksize + 1 - this.nextout));
        if (this.nextout < 1) {
            if (this.warn[1]) {
                this.M.warning((CharSequence)"Increasing nextout to 1");
                this.nextout = 1;
                this.warn[1] = false;
            }
        } else if (this.nextout + nloop - 1 > 131072 && this.warn[2]) {
            this.M.warning((CharSequence)"nloop too large, reducing");
            nloop = 131072 - this.nextout + 1;
            this.warn[2] = false;
        }
        if (this.cxin) {
            for (i = 0; i <= nloop * this.sup_fact - 1; ++i) {
                index = 0.5 + this.rfirst + (double)i * rfstep;
                j = (int)(index - this.indbase);
                if (j < 1) {
                    if (this.warn[3]) {
                        this.M.warning((CharSequence)"Trying to get data before start of input");
                    }
                    j = 1;
                    this.warn[3] = false;
                } else if (j > 131072) {
                    if (this.warn[4]) {
                        this.M.warning((CharSequence)"Trying to get data past end of input");
                    }
                    j = 131072;
                    this.warn[4] = false;
                }
                if (this.nextout + i > 65536) {
                    this.M.error("nextout too large cx");
                }
                try {
                    this.cbufout[this.nextout + i][0] = this.cbufin[j][0];
                    this.cbufout[this.nextout + i][1] = this.cbufin[j][1];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.M.error("amfsync: cbufout or cbufin array out of bounds");
                    return 9;
                }
            }
        } else {
            for (i = 0; i <= nloop * this.sup_fact - 1; ++i) {
                index = 0.5 + this.rfirst + (double)i * rfstep;
                j = (int)(index - this.indbase);
                if (j < 1) {
                    if (this.warn[3]) {
                        this.M.warning((CharSequence)"Trying to get data before start of input");
                    }
                    j = 1;
                    this.warn[3] = false;
                } else if (j > 131072) {
                    if (this.warn[4]) {
                        this.M.warning((CharSequence)"Trying to get data past end of input");
                    }
                    j = 131072;
                    this.warn[4] = false;
                }
                if (this.nextout + i > 131072) {
                    this.M.error("Nextout too large re");
                }
                this.bufout[this.nextout + i] = this.bufin[j];
            }
        }
        this.nextout += nloop;
        this.ncleft -= nloop;
        this.rfirst += (double)nloop * rstep;
        this.timelast += (double)nloop * this.time_step;
        if (this.nextout > this.outblk) {
            if (this.nextout > this.blksize) {
                this.M.error("nextout too big");
            }
            if (this.cxin) {
                float[] outbuf = this.outputBuffer.castF(false);
                int count = 0;
                for (int i5 = 1; i5 <= this.nextout - 1; ++i5) {
                    outbuf[count++] = this.cbufout[i5][0];
                    outbuf[count++] = this.cbufout[i5][1];
                }
                this.outputBuffer.uncast(outbuf, true);
            } else {
                float[] outbuf = this.outputBuffer.castF(false);
                int count = 0;
                for (int i6 = 1; i6 <= this.nextout - 1; ++i6) {
                    outbuf[count++] = this.bufout[i6];
                }
                this.outputBuffer.uncast(outbuf, true);
            }
            this.outputFile.write(this.outputBuffer, this.nextout - 1);
            this.nextout = 1;
        }
        return 0;
    }

    public int close() {
        int i;
        int count;
        if (this.nextout > 1) {
            float[] outbuf;
            if (this.nextout > this.blksize) {
                this.M.error("nextout too big");
            }
            if (this.cxin) {
                outbuf = this.outputBuffer.castF(false);
                count = 0;
                for (i = 1; i <= this.nextout - 1; ++i) {
                    outbuf[count++] = this.cbufout[i][0];
                    outbuf[count++] = this.cbufout[i][1];
                }
                this.outputBuffer.uncast(outbuf, true);
            } else {
                outbuf = this.outputBuffer.castF(false);
                count = 0;
                for (i = 1; i <= this.nextout - 1; ++i) {
                    outbuf[count++] = this.bufout[i];
                }
                this.outputBuffer.uncast(outbuf, true);
            }
            this.outputFile.write(this.outputBuffer, this.nextout - 1);
            this.outputFile.flush();
        }
        this.inputFile.close();
        this.outputFile.close();
        if (this.syncout) {
            float[] syncBuf = this.syncOutBuffer.castF(false);
            count = 0;
            for (i = 1; i <= this.npts; ++i) {
                syncBuf[count++] = this.phasebuf[i];
            }
            this.syncOutBuffer.uncast(syncBuf, true);
            this.syncOutFile.write(this.syncOutBuffer, this.npts);
            this.syncOutFile.close();
        }
        return 0;
    }

    private void next_clock(double time_last, double t_next, double tstep, int nsyms) {
        int MAXINT = Integer.MAX_VALUE;
        t_next = time_last + this.pri;
        int bindex = (int)((t_next - this.bufstart) / this.pp_delta + 1.0);
        if (bindex < 1) {
            int ioff;
            t_next = this.bufstart - (double)this.phasebuf[1] % 1.0 * this.pri;
            if ((t_next += (double)(ioff = (int)Math.round((time_last - t_next) / this.pri)) * this.pri) < this.x_start1) {
                ioff = (int)((this.x_start1 - t_next) / this.pri) + 1;
                t_next += (double)ioff * this.pri;
            }
            tstep = this.pri;
            nsyms = (int)((this.bufstart - t_next) / this.pri + 1.0);
        } else if (bindex >= this.npts) {
            tstep = this.pri;
            nsyms = MAXINT;
        } else {
            double phasint;
            double tleft;
            double phase1 = this.phasebuf[bindex];
            double time1 = this.bufstart + (double)(bindex - 1) * this.pp_delta;
            double phase2 = this.phasebuf[bindex + 1];
            double pdif = phase2 - phase1;
            if ((tleft = time1 + this.pp_delta - (t_next = time_last - ((phasint = phase1 + (pdif += (double)Math.round(this.pstep_nominal - pdif)) * (t_next - time1) / this.pp_delta) - (double)Math.round(phasint) - 1.0) * this.pri)) < 0.0) {
                tleft += this.pp_delta;
            }
            tstep = this.pp_delta / pdif;
            nsyms = (int)(tleft / tstep + 1.0);
        }
        this.time_now = t_next;
        this.time_step = tstep;
        this.ncleft = nsyms;
    }
}

