/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.lib;

import nxm.sys.inc.Constants;
import nxm.sys.lib.Convert;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;

public class DSPLib
implements Constants {
    protected long handle;
    protected boolean useNative;

    public native long alloc();

    public native int setkey(long var1, int var3, byte[] var4, int var5);

    public native int getkey(long var1, int var3, byte[] var4, int var5);

    public native int init(long var1);

    public native int work(long var1);

    public native int free(long var1);

    public boolean hasNative() {
        return false;
    }

    public DSPLib(boolean useNative) {
        if (useNative && this.hasNative()) {
            this.useNative = Shell.loadLibrary((String)this.getClass().getName());
            if (this.useNative) {
                this.handle = this.alloc();
                if (this.handle == 0L) {
                    throw new MidasException("Problem with native library alloc()");
                }
            }
        }
    }

    public int open() {
        if (this.useNative) {
            return this.init(this.handle);
        }
        return 0;
    }

    public int process() {
        if (this.useNative) {
            return this.work(this.handle);
        }
        return 0;
    }

    public int close() {
        if (this.useNative) {
            return this.free(this.handle);
        }
        return 0;
    }

    public void setKeyD(int key, double value) {
        byte[] buffer = new byte[8];
        Convert.packD((byte[])buffer, (int)0, (double)value);
        if (this.setkey(this.handle, key, buffer, 8) < 0) {
            throw new MidasException("Problem setting key=" + key + " to value=" + value);
        }
    }

    public double getKeyD(int key) {
        byte[] buffer = new byte[8];
        if (this.getkey(this.handle, key, buffer, 8) < 0) {
            throw new MidasException("Problem getting key=" + key);
        }
        return Convert.unpackD((byte[])buffer, (int)0);
    }

    public void setKeyF(int key, float value) {
        byte[] buffer = new byte[4];
        Convert.packF((byte[])buffer, (int)0, (float)value);
        if (this.setkey(this.handle, key, buffer, 4) < 0) {
            throw new MidasException("Problem setting key=" + key + " to value=" + value);
        }
    }

    public float getKeyF(int key) {
        byte[] buffer = new byte[4];
        if (this.getkey(this.handle, key, buffer, 4) < 0) {
            throw new MidasException("Problem getting key=" + key);
        }
        return Convert.unpackF((byte[])buffer, (int)0);
    }

    public void setKeyL(int key, int value) {
        byte[] buffer = new byte[4];
        Convert.packL((byte[])buffer, (int)0, (int)value);
        if (this.setkey(this.handle, key, buffer, 4) < 0) {
            throw new MidasException("Problem setting key=" + key + " to value=" + value);
        }
    }

    public int getKeyL(int key) {
        byte[] buffer = new byte[4];
        if (this.getkey(this.handle, key, buffer, 4) < 0) {
            throw new MidasException("Problem getting key=" + key);
        }
        return Convert.unpackL((byte[])buffer, (int)0);
    }
}

