/*
 * Decompiled with CFR 0.152.
 */
package nxm.dsp.lib;

import nxm.sys.inc.InternalUseOnly;

@InternalUseOnly
public class Complex {
    public float real;
    public float imag;

    public Complex() {
        this(0.0f, 0.0f);
    }

    public Complex(float r, float i) {
        this.real = r;
        this.imag = i;
    }

    public Complex(double r, double i) {
        this.real = (float)r;
        this.imag = (float)i;
    }

    public Complex(Complex c) {
        this(c.real(), c.imag());
    }

    public float real() {
        return this.real;
    }

    public float imag() {
        return this.imag;
    }

    public void add(Complex c) {
        Complex.add(this.real, this.imag, c.real(), c.imag(), this);
    }

    public void mult(Complex c) {
        float tempReal = this.real * c.real() - this.imag * c.imag();
        this.imag = this.real * c.imag() + this.imag * c.real();
        this.real = tempReal;
    }

    public void div(float b) {
        Complex.div(this.real, this.imag, b, this);
    }

    public void abs(float b) {
        Complex.abs(this.real, this.imag);
    }

    public static void mult(float real, float imag, float b, Complex result) {
        result.real = real * b;
        result.imag = imag * b;
    }

    public static void mult(float real1, float imag1, float real2, float imag2, Complex result) {
        result.real = real1 * real2 - imag1 * imag2;
        result.imag = real1 * imag2 + imag1 * real2;
    }

    public static void add(float real1, float imag1, float real2, float imag2, Complex result) {
        result.real = real1 + real2;
        result.imag = imag1 + imag2;
    }

    public static void div(float real, float imag, float b, Complex result) {
        result.real = real / b;
        result.imag = imag / b;
    }

    public static void divide(float real, float imag, float b, Complex result) {
        Complex.div(real, imag, b, result);
    }

    public static float abs(float real, float imag) {
        return (float)Math.sqrt(real * real + imag * imag);
    }

    public static float cabs(float real, float imag) {
        return Complex.abs(real, imag);
    }
}

