/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.Table;
import nxm.sys.libg.Layer1D;

public class LayerPA
extends Layer1D {
    public static String protoList = "Raw,USB2,USB3,PCIE,TGBE";
    private static int P_RAW = 1;
    private static int P_USB2 = 2;
    private static int P_USB3 = 3;
    private static int P_PCIE = 4;
    private static int P_TGBE = 5;
    private int proto = P_RAW;

    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        this.setFile(pf);
        this.setXAxis(pf.getXStart(), pf.getXDelta());
        int ts = (int)Math.min(pf.getSize(), 1.0E7);
        int fs = MA.getL("/FS", Math.min(ts, 32768));
        this.setFrame(fs);
        int lps = MA.getL("/LPS", 1);
        this.setSize(lps);
        this.setData(pf.getDataBuffer(fs * lps));
        this.isPaged = !this.realtime && fs * lps < ts;
        this.xIsTime = pf.getXUnits() == 1;
        this.setTimeAlign(MA.getState("/TIMEALIGN", false));
        return true;
    }

    public void setProto(String protocol) {
        this.proto = Parser.find((String)protoList, (String)protocol, (int)0);
    }

    public String getProto() {
        return Parser.get((String)protoList, (int)this.proto);
    }

    public void process() {
        this.ndata = 0;
        if (this.data == null) {
            return;
        }
        this.ndata = this.data.size * this.data.ape;
        this.fbuf = this.data2fa(this.data, this.ndata, this.fbuf, 0, this.MP.mode);
    }

    public String getReadOut(Position mp) {
        int iy = (int)mp.y;
        int ix = (int)(mp.x / this.xdelta);
        String tmp = " PA ()";
        return tmp;
    }
}

