/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.text.DecimalFormat;
import javax.swing.JOptionPane;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.GPrimitive;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.MFormat;
import nxm.sys.lib.Message;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPrompt;
import nxm.sys.libg.GValue;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MWindow;
import nxm.sys.libg.Theme;

public class view
extends GPrimitive
implements Keyable {
    private int controls = 1;
    private int scale = 0;
    private int mode = 0;
    private int view = 0;
    private int type = 0;
    private int realtime = 0;
    private int hilite = 1;
    private int exit = -1;
    private int poll = 0;
    private int flags = 0;
    private int outtype = 1;
    private int settings = -1;
    private int curmode = 0;
    private int colrIdx = 1;
    private long polltime = System.currentTimeMillis();
    private DataFile hcb;
    private Object obj;
    private Table tab;
    private Keywords tkw;
    private Table ttbl;
    private Data data;
    private Data datb;
    private KeyVector kv;
    private Table kvo;
    private double offset;
    private double size;
    private boolean rescale = false;
    private boolean isReadyF;
    private boolean isReadyT;
    private boolean isEdit;
    private boolean isEditing;
    private String form;
    private String currentName;
    private String templateName;
    private int th = 12;
    private int ta = 16;
    private int tw = 8;
    private int tv;
    private int selRow;
    private int selCol;
    private int curRow;
    private int curCol;
    private int numRows;
    private int numCols;
    private int nc;
    private int ds;
    private int dh;
    private int bh;
    private int ch;
    private int cw;
    private int sx;
    private int sw = 6;
    private int sy;
    private int sh;
    private Color cbg0;
    private Color cbg1;
    private Color cbg2;
    private Color cbs0;
    private Color cbs1;
    private Color cwfh;
    private boolean showLN;
    private boolean useTemplate;
    private boolean useDataList;
    private boolean useTable;
    private boolean useAuto;
    private boolean isTable;
    private boolean isFile;
    private GWidget gedit;
    static final String exitList = "RETURN,MENU,MESSAGE";
    static final int EXIT_RETURN = 1;
    static final int EXIT_MENU = 2;
    static final int EXIT_MESSAGE = 4;
    static final int EXIT_ALL = 15;
    static final int ONCLICK = 1;
    static final int ONMOTION = 2;
    static final int T_CELL = 1;
    static final int T_ROW = 2;
    static final int T_COL = 3;
    static final int GRID = 1;
    static final int FILL = 2;
    static final int SCROLL = 4;
    static final int CENTER = 8;
    static final int HEADER = 16;
    static final int NUMBER = 32;
    static final int SDEF_FILE = 61;
    static final int SDEF_TABLE = 12;
    static final String settingsList = "Grid,Fill,Scroll,Center,Header,Number";
    private Column[] columns;
    private static String[] keys = new String[]{"NUMROWS", "NUMCOLS", "CURROW", "CURCOL", "CELL"};

    public int open() {
        this.hilite = this.MA.getSelectionIndex("HILITE", "BACK,FORE", 1);
        this.controls = this.MA.getSelectionIndex("CNT=", "CLICK,CONT", 1);
        this.poll = this.MA.getI("/POLL", (short)0);
        this.curmode = this.MA.getSelectionIndex("CURSOR", "CELL,ROW,COL", 1);
        if (this.curmode == -1) {
            this.curmode = 1;
        }
        this.realtime = this.MA.getL("/RT", 0);
        this.exit = this.M.pipeMode == 1 ? 0 : -1;
        this.exit = this.MA.getOptionMask("/EXIT", exitList, this.exit);
        if (this.MA.getState("/HEX")) {
            this.flags |= 1;
        } else if (this.MA.getState("/BIN")) {
            this.flags |= 2;
        }
        this.showLN = this.MA.getState("/L", true);
        this.isEdit = this.MA.getState("/EDIT", false);
        this.MW = new MWView("View", (MessageHandler)this);
        this.MW.open();
        this.MW.setSize(800, 500);
        this.MW.addTo((Object)this);
        if (this.MW.fm != null) {
            this.tw = this.MW.fm.charWidth('0');
            this.th = this.MW.fm.getHeight();
            this.ta = this.MW.fm.getAscent();
        }
        this.bh = 4;
        this.dh = 0;
        this.cw = this.tw;
        this.ch = this.dh + this.th + this.bh - 2;
        this.tv = this.tw / 2;
        this.cbg0 = this.MW.theme.cwms;
        this.cbs0 = this.MW.theme.cwbs;
        this.cbg1 = this.MW.theme.cwbs;
        this.cbs1 = this.MW.theme.cwts;
        this.cbg2 = this.MW.theme.cwbs.brighter();
        this.cwfh = this.MW.theme.cwfh;
        this.selRow = 0;
        this.selCol = 0;
        this.openTemplateFile(this.MA.getCS("TEMPLATE"));
        this.openAny(this.MA.getCS("FILE"));
        this.refresh(1);
        return 0;
    }

    private boolean isVisible() {
        if (this.MW.panel == null) {
            return false;
        }
        Frame frame = JOptionPane.getFrameForComponent(this.MW.panel);
        if (!this.MW.panel.isShowing()) {
            return false;
        }
        return frame == null || frame.getExtendedState() != 1;
    }

    public int process() {
        if (this.MW.status == -2) {
            return -1;
        }
        if (this.checkPollTime()) {
            this.refresh();
            return 0;
        }
        return -1;
    }

    public int close() {
        if (this.hcb != null) {
            this.hcb.close();
        }
        this.MW.close();
        return 0;
    }

    private boolean checkPollTime() {
        if (this.poll <= 0) {
            return false;
        }
        long ctm = System.currentTimeMillis();
        if (ctm - this.polltime > (long)(this.poll * 1000)) {
            this.polltime = ctm;
            return true;
        }
        return false;
    }

    private boolean autoConfig() {
        int onc = this.nc;
        int onr = this.numRows;
        this.applyTemplate();
        return this.isTable || this.nc != onc || this.numRows != onr;
    }

    private void openAny(String name) {
        Object obj = this.MR.getO(name.toUpperCase());
        if (name.endsWith(".tbl")) {
            obj = this.openTableFromFile(name);
        }
        if (obj instanceof Table) {
            this.openTable((Table)obj);
        } else {
            this.openFile(name);
        }
    }

    private Table openTableFromFile(String name) {
        TextFile tf = new TextFile((MidasReference)this.M, (Object)name);
        return new Table(tf);
    }

    private void openTable(Table t) {
        this.tab = t;
        this.isTable = true;
        this.isFile = false;
        this.parseTable();
        this.applyTemplate();
        this.isReadyF = true;
        this.refresh();
    }

    private void closeTable() {
        this.tab = new Table();
    }

    private void parseTable() {
        if (this.kv == null) {
            this.kv = new KeyVector();
        }
        if (this.kvo == null) {
            this.kvo = new Table();
        }
        this.kv.clear();
        this.addTable(this.tab, 0, "");
        this.size = this.kv.getSize();
    }

    private void addTable(Table t, int level, String prefix) {
        String pad = "";
        for (int i = 0; i < level; ++i) {
            pad = pad + "  ";
        }
        Table.Iterator ti = t.iterator();
        while (ti.getNext()) {
            if (ti.value instanceof Table) {
                prefix = prefix + ti.key;
                Table tbl = (Table)ti.value;
                boolean topen = this.kvo.containsKey(prefix);
                this.kv.add(pad + ti.key + "@" + prefix, (Object)tbl);
                String toStr = tbl.getS("TOSTR");
                if (toStr != null) {
                    this.kvo.put(prefix + "_TOSTR", (Object)toStr);
                }
                if (!topen) continue;
                this.addTable(tbl, level + 1, prefix);
                continue;
            }
            if (ti.key.equals("TOSTR")) continue;
            this.kv.add(pad + ti.key, ti.value);
        }
    }

    private void openFile(String name) {
        int ioflg;
        this.isReadyF = false;
        this.closeFile();
        if (!name.equals(this.currentName)) {
            this.offset = 0.0;
        }
        this.isTable = false;
        this.isFile = true;
        this.hcb = new DataFile();
        this.hcb.init((MidasReference)this.M, (Object)name);
        int n = ioflg = this.isEdit ? 3 : 1;
        if (this.hcb.open(ioflg | 0x40)) {
            this.size = this.hcb.size;
            this.data = this.hcb.getDataBuffer(1);
            this.datb = this.hcb.getDataBuffer(1);
            this.form = this.hcb.getFormat();
            this.autoConfig();
            this.isReadyF = true;
        }
        this.refresh();
    }

    private boolean is(int mask) {
        return (this.settings & mask) != 0;
    }

    private void getSettings() {
        if (this.settings >= 0) {
            return;
        }
        this.settings = this.isTable ? 12 : 61;
        this.settings = this.MA.getOptionMask("/SETTINGS", settingsList, this.settings);
    }

    private void openTemplateFile(String filename) {
        this.tkw = null;
        this.ttbl = null;
        this.isReadyT = false;
        this.templateName = filename.toLowerCase();
        this.useAuto = this.templateName.equals("auto");
        this.useTable = this.templateName.endsWith(".tbl");
        this.useDataList = this.templateName.equals("");
        boolean bl = this.useTemplate = !this.useDataList && !this.useAuto && !this.useTable;
        if (this.useTemplate && this.tkw == null) {
            DataFile thcb = new DataFile();
            thcb.init((MidasReference)this.M, (Object)this.templateName);
            thcb.open();
            this.tkw = thcb.keywords;
            thcb.close();
        }
        if (this.useTable && this.ttbl == null) {
            this.ttbl = Convert.o2t((Object)this.templateName, (Object)((Object)this));
        }
    }

    private void applyTemplate() {
        this.isReadyT = false;
        this.getSettings();
        this.numRows = this.MW.pos.h / this.ch;
        if (this.is(16)) {
            --this.numRows;
        }
        if (this.isTable) {
            this.numCols = 1;
        } else if (this.useDataList) {
            this.numCols = 1;
        } else if (this.useAuto) {
            this.numCols = this.hcb.getSubSize();
        } else if (this.useTable) {
            this.numCols = this.ttbl.getL("FIELDS");
        } else {
            this.tkw.setScope("SECTION=XDATALIST");
            this.numCols = this.tkw.getL("FIELDS", 0);
        }
        if (this.columns == null || this.numCols + 1 > this.columns.length) {
            this.columns = new Column[this.numCols + 1];
        }
        int px = 0;
        int colw0 = this.useDataList || this.useAuto ? 5 : 3;
        boolean center = this.is(8);
        boolean numb = this.is(32);
        boolean scroll = this.is(4);
        this.nc = 1;
        String cname = "CFG";
        for (int c = 0; c <= this.numCols; ++c) {
            Column col = new Column();
            if (c == 0 && !numb) {
                col.width = 0;
            } else if (c == 0 && (this.isTable || this.useDataList || this.useAuto || this.useTable)) {
                col.label = "#";
                col.width = colw0;
            } else if (this.isTable) {
                col.width = -1;
            } else if (this.useDataList) {
                col.width = -1;
                if (this.hcb != null && this.hcb.isOpen) {
                    this.nc = this.hcb.listElementsPerLine(this.MW.pos.w / this.cw - (this.showLN ? 6 : 1), this.form, this.flags);
                    if (this.nc < 1) {
                        this.nc = 1;
                    }
                    this.nc = this.MA.getL("/NC", this.nc);
                    col.label = "FILE=" + this.hcb.getURL() + " TYPE=" + this.hcb.getType() + " FORM=" + this.hcb.getFormat() + " SIZE=" + this.hcb.getSize();
                }
            } else if (this.useAuto) {
                String name = this.hcb.getRecName(c - 1);
                String form = this.hcb.getRecFormat(c - 1);
                char type = form.charAt(1);
                col.subr = name;
                col.label = name.substring(0, 1) + name.substring(1).toLowerCase();
                if (type == 'A') {
                    col.form = "ASCII";
                } else {
                    col.df = type == 'F' || type == 'D' ? new DecimalFormat("#.000") : new DecimalFormat("##");
                }
                col.width = 8;
                col.soff = -1;
                col.center = center;
            } else {
                if (this.useTable && this.ttbl.getO("FIELD" + c) != null) {
                    Table ftbl = this.ttbl.getTable("FIELD" + c);
                    col.subr = ftbl.getS("SUBR", "NONE").trim();
                    col.form = ftbl.getS("DISPFORM", "ASCII").trim();
                    col.label = ftbl.getS("LABEL", "").trim();
                    col.width = ftbl.getL("WIDTH", colw0);
                    col.items = ftbl.getS("ITEMS");
                    cname = ftbl.getS("COLOR", "CFG").trim();
                } else if (this.useTemplate && this.tkw.setScope("SECTION=XDATALIST,FIELD=" + c) == 2) {
                    col.subr = this.tkw.getS("SUBR", "NONE").trim();
                    col.form = this.tkw.getS("DISPFORM", "ASCII").trim();
                    col.label = this.tkw.getS("LABEL", "").trim();
                    col.width = this.tkw.getL("WIDTH", colw0);
                    cname = this.tkw.getS("COLOR", "CFG").trim();
                    col.items = this.tkw.getS("ITEMS", null);
                } else {
                    col.form = "ASCII";
                    col.label = "";
                    col.width = colw0;
                }
                col.soff = -1;
                boolean bl = col.center = c > 0 && center;
                if (col.form.equals("TOGGLE")) {
                    col.toggle = true;
                    col.colors = new Color[3];
                    col.letters = new String[3];
                    col.letters[0] = "-";
                    col.colors[0] = Color.RED.darker();
                    col.letters[1] = "*";
                    col.colors[1] = Color.GREEN.darker();
                    col.letters[2] = "?";
                    col.colors[2] = Color.BLUE.darker();
                } else if (col.form.equals("METER")) {
                    col.meter = true;
                } else if (col.form.equals("MENU")) {
                    col.menu = true;
                } else if (!col.form.equals("ASCII")) {
                    if (col.form.indexOf(35) >= 0) {
                        col.df = new DecimalFormat(col.form);
                    } else {
                        col.mf = MFormat.getNumberFormatFor((String)col.form);
                    }
                }
            }
            Color color = this.MW.theme.getColor(cname);
            if (color == null) {
                color = MColor.getColor((Object)cname);
            }
            col.color = color;
            int n = col.pw = col.width >= 0 ? (col.width + 1) * this.cw : this.MW.pos.w - px - this.sw;
            if (c == 0 && col.width == 0 && scroll) {
                col.pw = this.sw + this.cw;
            }
            col.px = px;
            px += col.pw;
            this.columns[c] = col;
        }
        this.isReadyT = true;
    }

    private void closeFile() {
        this.isReadyF = false;
        if (this.hcb != null && this.hcb.isOpen()) {
            this.hcb.close();
        }
        this.refresh();
    }

    private String padi(int off, int w) {
        if (!this.showLN) {
            return " ";
        }
        String padoff = "" + off;
        --w;
        while (padoff.length() < w) {
            padoff = " " + padoff;
        }
        return padoff;
    }

    private String formatCell(Data data, int ic) {
        Column col = this.columns[ic];
        if (col.soff < 0) {
            int fn = this.hcb.findRec(col.subr);
            if (fn < 0) {
                this.M.warning((CharSequence)("Subrecord " + col.subr + " not found in file: " + this.hcb.getURL()));
            }
            col.soff = this.hcb.getRecOffset(fn);
            col.sfmt = this.hcb.getRecFormat(fn);
            col.sbpa = Data.getBPA((String)col.sfmt);
            col.type = col.sfmt.charAt(1);
        }
        Object ocv = this.getValue(data, ic);
        if (col.toggle) {
            int state;
            int n = col.type != 'A' ? Convert.o2l((Object)ocv) : (state = ocv.toString().equalsIgnoreCase("On") ? 1 : 0);
            if (state < 0 || state > 2) {
                state = 0;
            }
            col.dcolor = col.colors[state];
            return col.letters[state];
        }
        if (col.mf != null || col.df != null) {
            double d = Convert.o2d((Object)ocv);
            if (col.df != null) {
                return col.df.format(d);
            }
            return col.mf.format((Object)d);
        }
        if (col.form.equals("ASCII") || col.form.equals("MENU")) {
            int ls;
            for (ls = 0; data.buf[col.soff + ls] > 32 && ls < col.sbpa; ++ls) {
            }
            return new String(data.buf, col.soff, ls);
        }
        return null;
    }

    private Object getValue(Data data, int c) {
        Column col = this.columns[c];
        switch (col.type) {
            case 'D': {
                return new Double(Convert.unpackD((byte[])data.buf, (int)col.soff));
            }
            case 'F': {
                return new Float(Convert.unpackF((byte[])data.buf, (int)col.soff));
            }
            case 'L': {
                return new Integer(Convert.unpackL((byte[])data.buf, (int)col.soff));
            }
            case 'I': {
                return new Short(Convert.unpackI((byte[])data.buf, (int)col.soff));
            }
            case 'B': {
                return new Byte(Convert.unpackB((byte[])data.buf, (int)col.soff));
            }
            case 'A': {
                return Convert.unpackS((byte[])data.buf, (int)col.soff, (int)col.sbpa);
            }
        }
        return null;
    }

    private Object getValue(int r, int c) {
        if (this.isTable) {
            return this.getTableLineAll(r - 1);
        }
        if (this.useDataList) {
            return null;
        }
        if (r <= 0) {
            return null;
        }
        double index = r - 1;
        if (index < 0.0 || index >= this.size) {
            return null;
        }
        if (this.hcb == null || !this.hcb.isOpen) {
            return null;
        }
        if (this.hcb.read(this.datb, index, 1) != 1) {
            return null;
        }
        if (c > 0) {
            return this.getValue(this.datb, c);
        }
        Table t = new Table();
        for (c = 1; c <= this.numCols; ++c) {
            Column col = this.columns[c];
            t.put(col.subr, this.getValue(this.datb, c));
        }
        return t;
    }

    private void setValue(int r, int c, Object data) {
        if (this.useDataList) {
            return;
        }
        double index = r - 1;
        if (index < 0.0 || index >= this.size) {
            return;
        }
        if (this.hcb == null || !this.hcb.isOpen) {
            return;
        }
        if (this.hcb.read(this.datb, index, 1) != 1) {
            return;
        }
        Column col = this.columns[c];
        if (col.type == 'D') {
            Convert.packD((byte[])this.datb.buf, (int)col.soff, (double)Convert.o2d((Object)data));
        }
        if (col.type == 'F') {
            Convert.packF((byte[])this.datb.buf, (int)col.soff, (float)Convert.o2f((Object)data));
        }
        if (col.type == 'L') {
            Convert.packL((byte[])this.datb.buf, (int)col.soff, (int)Convert.o2l((Object)data));
        }
        if (col.type == 'A') {
            Convert.packS((byte[])this.datb.buf, (int)col.soff, (int)col.sbpa, (String)data.toString());
        }
        if (this.hcb.write(this.datb, index, 1) != 1) {
            return;
        }
    }

    public void drawSymbol(String s, int sx, int sy, int sr, Graphics g) {
        if (s.equals("*")) {
            g.drawOval(sx, sy, sr, sr);
        }
        if (s.equals("-")) {
            g.drawRect(sx, sy, sr, sr);
        }
    }

    private void refresh() {
        this.refresh(0);
    }

    private void refresh(int flag) {
        this.MW.refresh();
    }

    private void resize() {
        this.MW.resize(1);
        if (this.autoConfig()) {
            this.refresh();
        }
    }

    private void getCurrent() {
        this.curCol = -1;
        for (int c = 0; c <= this.numCols; ++c) {
            Column col = this.columns[c];
            if (this.MW.px <= col.px || this.MW.px >= col.px + col.pw) continue;
            this.curCol = c;
        }
        this.curRow = this.MW.py / this.ch;
        if (!this.is(16)) {
            ++this.curRow;
        }
        if (this.curRow > 0) {
            this.curRow += (int)this.offset;
        }
        if ((double)this.curRow > this.size) {
            this.curRow = -1;
        }
    }

    private void select() {
        this.getCurrent();
        if (this.curRow < 0 || this.curCol < 0) {
            return;
        }
        this.select(this.curRow, this.curCol, true);
    }

    private void select(int r, int c) {
        this.select(r, c, false);
    }

    private void editCell(int r, int c) {
        Column col = this.columns[c];
        Object ocv = this.getValue(r == 0 ? 1 : r, c);
        if (col.toggle) {
            Object val;
            if (col.type == 'A') {
                val = ocv.toString().equalsIgnoreCase("On") ? "Off" : "On";
            } else {
                int lval = Convert.o2l((Object)ocv);
                val = Convert.l2o((int)(1 - lval));
            }
            if (r > 0) {
                this.setValue(r, c, val);
            } else {
                int i = 1;
                while ((double)i <= this.size) {
                    this.setValue(i, c, val);
                    ++i;
                }
            }
            this.refresh();
            return;
        }
        if (this.isEditing) {
            this.isEditing = false;
            return;
        }
        this.isEditing = true;
        String name = "Edit-" + r + "-" + c + "-" + col.subr;
        char type = col.type;
        int flags = 0;
        if (col.menu) {
            this.gedit = new GMenu((Object)this.MW, name, col.items, 0, flags |= 0x400000, (MessageHandler)this);
        } else if (type == 'L' || type == 'F' || type == 'D' || type == 'T') {
            double v = Convert.o2d((Object)ocv);
            this.gedit = new GValue((Object)this.MW, name, v, 1.0, -1.0, 1.0, type, flags, (MessageHandler)this);
        } else {
            String v = ocv.toString();
            this.gedit = new GPrompt((Object)this.MW, name, v, flags, (MessageHandler)this);
        }
    }

    private void sendCell(int r, int c, String name) {
        Table t = new Table();
        t.put("TYPE", (Object)(c == 0 ? "ROW" : (r == 0 ? "COL" : "CELL")));
        t.put("ROW", (Object)r);
        t.put("COLUMN", (Object)c);
        t.put("NAME", (Object)this.columns[c].subr);
        t.put("VALUE", this.getValue(r, c));
        this.sendMessage(name, 0, t);
    }

    private void select(int r, int c, boolean smsg) {
        this.selRow = r;
        this.selCol = c;
        if ((double)this.selRow >= this.offset + (double)this.numRows) {
            this.offset = Math.max(0.0, Math.min(this.size, (double)r) - (double)this.numRows + 1.0);
        }
        if ((double)this.selRow < this.offset + 2.0) {
            this.offset = Math.max(0, r - this.numRows / 2);
        }
        this.offset = Math.floor(this.offset / (double)this.nc) * (double)this.nc;
        this.refresh();
        if (smsg) {
            this.sendCell(r, c, "SELECT");
        }
    }

    private void deselect(boolean smsg) {
        this.isEditing = false;
        this.select(0, 0, smsg);
    }

    private String getTableLine(int kvi) {
        String pre;
        String text;
        if (kvi < 0 || (double)kvi >= this.size) {
            return "Oops";
        }
        String key = this.kv.getKey(kvi);
        Object val = this.kv.get(kvi);
        if (val instanceof Table) {
            Table t = (Table)val;
            int ia = key.indexOf(64);
            String prefix = key.substring(ia + 1);
            key = key.substring(0, ia);
            boolean topen = this.kvo.containsKey(prefix);
            text = this.kvo.getS(prefix + "_TOSTR");
            if (text == null) {
                text = "Table of " + t.getSize() + " entries";
            }
            pre = topen ? "- " : "+ ";
        } else {
            text = val.toString();
            pre = "  ";
        }
        return pre + key + " : " + text;
    }

    private String getTableLineAll(int kvi) {
        String text;
        if (kvi < 0 || (double)kvi >= this.size) {
            return "Oops";
        }
        String key = this.kv.getKey(kvi);
        Object val = this.kv.get(kvi);
        if (val instanceof Table) {
            Table t = (Table)val;
            int ia = key.indexOf(64);
            String prefix = key.substring(ia + 1);
            key = key.substring(0, ia);
            text = t.toString();
        } else {
            text = val.toString();
        }
        return key + ":" + text;
    }

    private void handleTableHit(int row) {
        int kvi = row - 1;
        if (kvi < 0 || (double)kvi >= this.size) {
            return;
        }
        String key = this.kv.getKey(kvi);
        Object val = this.kv.get(kvi);
        if (val instanceof Table) {
            Table t = (Table)val;
            int ia = key.indexOf(64);
            String prefix = key.substring(ia + 1);
            if (this.kvo.containsKey(prefix)) {
                this.kvo.remove(prefix);
            } else {
                this.kvo.put(prefix, (Object)"Open");
            }
            this.parseTable();
            this.applyTemplate();
        }
    }

    private void scroll(int rows) {
        double loffset = this.offset;
        this.offset = Math.max(0.0, Math.min(this.size + (double)(2 * this.nc) - Math.floor(this.numRows * this.nc), Math.floor(this.offset + (double)rows)));
        this.offset = Math.floor(this.offset / (double)this.nc) * (double)this.nc;
        if (this.offset != loffset) {
            this.refresh();
        }
    }

    private void getHit() {
        this.getHit(this.MW.px, this.MW.py, 0, 0, false);
    }

    private void getHit(int px, int py, int dx, int dy, boolean drag) {
        if (px >= this.sx && px <= this.sx + this.sw && py >= this.sy && py < this.sy + this.sh) {
            this.offset = (double)(py + dy - this.sy) * this.size / (double)this.sh;
            this.offset = Math.max(0.0, Math.min(this.size + (double)(2 * this.nc) - Math.floor(this.numRows * this.nc), Math.floor(this.offset)));
            this.offset = Math.floor(this.offset / (double)this.nc) * (double)this.nc;
        } else if (!drag) {
            this.getCurrent();
            if (this.curRow < 0 || this.curCol < 0) {
                return;
            }
            if (this.isTable && this.curRow >= 0 && this.curCol > 0 && this.curRow == this.selRow && this.curCol == this.selCol) {
                this.handleTableHit(this.curRow);
            } else if (this.isEdit && this.curRow >= 0 && this.curCol > 0 && this.curRow == this.selRow && this.curCol == this.selCol) {
                this.editCell(this.curRow, this.curCol);
            } else {
                this.isEditing = false;
                this.select();
            }
        }
        this.refresh();
    }

    public int processMessage(Message msg) {
        if (this.MW == null || this.MW.status == 0 || !this.thisIsMe()) {
            if (msg.name.equals("POINTER")) {
                this.MQ.remove(msg.name);
            }
            if (msg.name.equals("REFRESH") || msg.name.equals("RESIZE")) {
                this.MQ.remove(msg.name);
            }
            if (msg.name.startsWith("PAN") || msg.name.startsWith("DRAG")) {
                this.MQ.remove(msg.name);
            }
            this.MQ.put(msg);
            return -1;
        }
        if (msg.name.equals("KEYPRESS")) {
            String text = (String)msg.data;
            if (text.equalsIgnoreCase("M")) {
                msg.name = "MENU";
            }
            if (text.equalsIgnoreCase("Enter") && (this.exit & 1) != 0) {
                msg.name = "EXIT";
            }
        }
        if (msg.name.equals("BUTTON") && msg.info == 2) {
            msg.name = "MENU";
        }
        boolean handled = true;
        if (msg.name.equals("POINTER")) {
            if (this.controls == 2) {
                msg.data = null;
                this.sendMessage(msg);
            }
        } else if (msg.name.equals("BUTTON")) {
            if (msg.info == 1) {
                this.getHit();
            }
            if (msg.info == 3) {
                this.deselect(true);
            }
        } else if (msg.name.equals("DRAG")) {
            MBox mb = (MBox)msg.data;
            if (msg.info == 1) {
                this.getHit(mb.x, mb.y, mb.w, mb.h, true);
            }
        } else if (msg.name.startsWith("EDIT-")) {
            String key = msg.name;
            int i1 = key.indexOf(45);
            int i2 = key.indexOf(45, i1 + 1);
            int i3 = key.indexOf(45, i2 + 1);
            int r = Convert.s2l((String)key.substring(i1 + 1, i2));
            int c = Convert.s2l((String)key.substring(i2 + 1, i3));
            if (r > 0) {
                this.setValue(r, c, msg.data);
            } else {
                int i = 1;
                while ((double)i <= this.size) {
                    this.setValue(i, c, msg.data);
                    ++i;
                }
            }
            this.refresh();
            this.sendCell(r, c, "UPDATE");
            this.isEditing = false;
        } else {
            handled = false;
        }
        if (handled) {
            return 0;
        }
        switch (msg.name) {
            case "SCROLL": {
                this.scroll(msg.info);
                break;
            }
            case "REFRESH": {
                this.refresh(1);
                break;
            }
            case "RESIZE": {
                this.resize();
                break;
            }
            case "SELECTROW": {
                this.select(Convert.o2l((Object)msg.data), 0);
                break;
            }
            case "SELECTCOL": {
                this.select(0, Convert.o2l((Object)msg.data));
                break;
            }
            case "SELECTCELL": {
                Table t = Convert.o2t((Object)msg.data);
                this.select(t.getL("ROW"), t.getL("COL"));
                break;
            }
            case "DESELECT": {
                this.deselect(false);
                break;
            }
            case "MENU": {
                new GMenu((Object)this.MW, "List", "Files...,Template...,Settings...,Control...,Window...,Other...,Exit", 0, 0, (MessageHandler)this);
                break;
            }
            case "LIST": {
                switch ((String)msg.data) {
                    case "FILES...": {
                        new GMenu((Object)this.MW, "Files", "Open,Close,Reread,ReOpen", 0, 0, (MessageHandler)this);
                        break;
                    }
                    case "TEMPLATE...": {
                        new GMenu((Object)this.MW, "Template", "Open,Default", 0, 0, (MessageHandler)this);
                        break;
                    }
                    case "CONTROL...": {
                        new GMenu((Object)this.MW, "Controls", "Off,Click,Continuous,Assign...", this.controls + 1, 0, (MessageHandler)this);
                        break;
                    }
                    case "WINDOW...": {
                        new GMenu((Object)this.MW, "Window", "Toggle,Push,Pop", 0, 0, (MessageHandler)this);
                        break;
                    }
                    case "OTHER...": {
                        new GMenu((Object)this.MW, "Other", "Theme", 0, 0, (MessageHandler)this);
                        break;
                    }
                    case "SETTINGS...": {
                        new GMenu((Object)this.MW, "Settings", settingsList, this.settings, 1024, (MessageHandler)this);
                        break;
                    }
                    case "EXIT": {
                        msg.name = "EXIT";
                        if ((this.exit & 2) == 0) break;
                        this.MQ.put(msg);
                    }
                }
                break;
            }
            case "FILES": {
                switch ((String)msg.data) {
                    case "OPEN": {
                        new GPrompt((Object)this.MW, "OpenFile", "", 0, (MessageHandler)this);
                        break;
                    }
                    case "CLOSE": {
                        this.closeFile();
                        break;
                    }
                    case "REREAD": {
                        if (this.isTable) {
                            this.parseTable();
                            this.applyTemplate();
                        }
                        this.refresh();
                        break;
                    }
                    case "REOPEN": {
                        this.openFile(this.currentName);
                    }
                }
                break;
            }
            case "TEMPLATE": {
                switch ((String)msg.data) {
                    case "OPEN": {
                        new GPrompt((Object)this.MW, "OPENTEMPLATE", "", 0, (MessageHandler)this);
                        break;
                    }
                    case "DEFAULT": {
                        this.openFile(this.currentName);
                    }
                }
                break;
            }
            case "SETTINGS": {
                this.settings = msg.info;
                this.applyTemplate();
                this.refresh();
                break;
            }
            case "CONTROLS": {
                if (msg.info == 4) break;
                this.controls = msg.info - 1;
                break;
            }
            case "WINDOW": {
                break;
            }
            case "OTHER": {
                switch ((String)msg.data) {
                    case "THEME": {
                        new GMenu((Object)this.MW, "THEME", "DeskTop,Default,WoB,GoB,BoW,MnM,Browser,Gear1,Gear2,Gear3,Gear4,Nak", 0, 0, (MessageHandler)this);
                    }
                }
                break;
            }
            case "OPENTABLE": {
                this.openTable((Table)msg.data);
                break;
            }
            case "CLOSETABLE": {
                this.closeTable();
                break;
            }
            case "OPENFILE": {
                if (msg.info >= 0) {
                    this.isEdit = msg.info > 0;
                }
                this.openFile((String)msg.data);
                break;
            }
            case "CLOSEFILE": {
                this.closeFile();
                break;
            }
            case "OPENTEMPLATE": {
                this.openTemplateFile((String)msg.data);
                break;
            }
            case "APPLYTEMPLATE": {
                this.openTemplateFile((String)msg.data);
                break;
            }
            case "THEME": {
                this.MW.setTheme((String)msg.data);
                this.refresh();
                break;
            }
            case "CURSOR": {
                this.curmode = msg.info;
                break;
            }
            case "COLOR": {
                this.colrIdx = msg.info;
                break;
            }
            case "POP": {
                this.MW.pop(-1);
                this.refresh(1);
                break;
            }
            case "EXIT": {
                if ((this.exit & 4) == 0) break;
                return 9;
            }
            case "FINISH": {
                return 9;
            }
        }
        return 0;
    }

    public Object getCell(int row, int col) {
        return null;
    }

    public Object setKey(String name, Object value) {
        switch (name) {
            case "CURROW": {
                this.curRow = Convert.o2l((Object)value);
                break;
            }
            case "CURCOL": {
                this.curCol = Convert.o2l((Object)value);
                break;
            }
            case "SELECTROW": {
                this.select(Convert.o2l((Object)value), 0);
                break;
            }
            case "SELECTCOL": {
                this.select(0, Convert.o2l((Object)value));
                break;
            }
            case "SELECTCELL": {
                Table t = Convert.o2t((Object)value);
                this.select(t.getL("ROW"), t.getL("COL"));
                break;
            }
            case "DESELECT": {
                this.deselect(false);
                break;
            }
            case "ADDROW": 
            case "ADDROWS": 
            case "SETROW": 
            case "ROWBYVALUE": 
            case "REMOVEROW": 
            case "REMOVECURRROW": 
            case "SELECTMROW": 
            case "SELECTCELLS": 
            case "SORTA": 
            case "SORTD": 
            case "SHOWCOL": 
            case "HIDECOL": 
            case "SHOWALL": 
            case "HIDEALL": 
            case "SETCELL": 
            case "SETCELLCOLORS": 
            case "SETROWCOLORS": 
            case "SETCOLCOLORS": {
                this.M.warning((CharSequence)("Key " + name + " not supported for this version of list"));
                break;
            }
            default: {
                return null;
            }
        }
        return value;
    }

    public String[] getKeys() {
        return keys;
    }

    public Object getKey(String name) {
        switch (name) {
            case "NUMROWS": {
                return this.numRows;
            }
            case "NUMCOLS": {
                return this.numCols;
            }
            case "CURROW": {
                return this.curRow;
            }
            case "CURCOL": {
                return this.curCol;
            }
            case "SELROW": {
                return this.selRow;
            }
            case "SELCOL": {
                return this.selCol;
            }
            case "SELECTEDROW": {
                return this.selRow;
            }
            case "SELECTEDCOL": {
                return this.selCol;
            }
            case "CELL": {
                return this.getCell(this.curRow, this.curCol);
            }
        }
        return null;
    }

    public int getPollInterval() {
        return this.poll;
    }

    public void setPollInterval(int pollInterval) {
        this.poll = pollInterval;
    }

    private class MWView
    extends MWindow {
        public MWView(String name, MessageHandler mh) {
            super(name, mh, (Object)true);
        }

        public synchronized void paintComponent(Graphics g) {
            int px = 0;
            int py = 0;
            if (!view.this.isReadyF || !view.this.isReadyT) {
                g.setColor(view.this.cbg1);
                g.fillRect(0, 0, this.pos.w, this.pos.h);
                return;
            }
            boolean fill = view.this.is(2);
            boolean grid = view.this.is(1);
            boolean scroll = view.this.is(4);
            boolean head = view.this.is(16);
            boolean numb = view.this.is(32);
            int sr = head ? 0 : 1;
            boolean hr = head;
            long aoff = (long)view.this.offset / 1000L * 1000L;
            for (int r = sr; r <= view.this.numRows; ++r) {
                boolean labels = r == 0;
                double index = view.this.offset + (double)((r - 1) * view.this.nc);
                long arow = -1L;
                long brow = -1L;
                if (!labels) {
                    if (index >= view.this.size) break;
                    brow = (long)(index + 1.0);
                    arow = (long)(index + 1.0);
                    if (!view.this.isTable) {
                        if (view.this.useDataList) {
                            arow = (long)index;
                        } else if (view.this.hcb == null || !((view)view.this).hcb.isOpen || view.this.hcb.read(view.this.data, index, 1) != 1) break;
                    }
                }
                for (int c = 0; c <= view.this.numCols; ++c) {
                    Column col = view.this.columns[c];
                    boolean border = c == 0 || r == 0;
                    boolean center = labels || col.center;
                    boolean selected = !((long)view.this.selRow != brow && view.this.selRow != 0 || view.this.selCol != c && view.this.selCol != 0 || view.this.selRow == 0 && view.this.selCol == 0);
                    px = col.px;
                    int pw = col.pw;
                    g.setColor(border ? view.this.cbg0 : (selected ? view.this.cbg2 : view.this.cbg1));
                    g.fillRect(px, py, pw, view.this.ch);
                    if (c == 0 && !numb) continue;
                    String s = null;
                    s = r == 0 ? (c == 0 && aoff > 0L ? "" + aoff + "+" : col.label) : (c == 0 ? view.this.padi((int)(arow - aoff), col.width) : (view.this.isTable ? view.this.getTableLine((int)index) : (view.this.useDataList ? view.this.hcb.listElements(index, view.this.nc, view.this.form, view.this.flags) : view.this.formatCell(view.this.data, c))));
                    if (s != null) {
                        int lx;
                        if (r == 0 && c == 0) {
                            pw -= view.this.sw;
                        }
                        int ls = s.length();
                        int n = lx = center ? pw - ls * view.this.cw >> 1 : view.this.tv;
                        if (lx < 0) {
                            lx = 0;
                        }
                        int lw = view.this.useDataList ? ls * view.this.tw : pw - 1;
                        g.setColor(view.this.cbs1);
                        if (grid && !border && c != view.this.numCols) {
                            g.drawLine(px + lw, py + 1, px + lw, py + view.this.ch - 2);
                        }
                        if (grid && !border) {
                            g.drawLine(px + 1, py + view.this.ch - 1, px + lw - 2, py + view.this.ch - 1);
                        }
                        g.setColor(selected ? view.this.cwfh : (col.toggle && !border ? col.dcolor : col.color));
                        g.drawString(s, px + lx, py + view.this.ch - view.this.bh);
                    }
                    px += col.pw;
                }
                py += view.this.ch;
            }
            g.setColor(fill ? view.this.cbg0 : view.this.cbg1);
            if (px < this.pos.w) {
                g.fillRect(px, 0, this.pos.w - px, this.pos.h);
            }
            if (py < this.pos.h) {
                g.fillRect(0, py, px, this.pos.h - py);
            }
            g.setColor(view.this.cbs1);
            g.drawLine(0, 0, px, 0);
            g.drawLine(0, 0, 0, py);
            g.setColor(fill ? view.this.cbg2 : view.this.cbg0);
            g.drawLine(0, py, px, py);
            g.drawLine(px, 0, px, py);
            if (scroll) {
                Column col = view.this.columns[0];
                view.this.sx = col.px + col.pw - view.this.sw;
                view.this.sy = view.this.ch;
                view.this.sh = py - view.this.ch;
                MWView.drawVSlider((int)view.this.sx, (int)view.this.sy, (int)view.this.sw, (int)view.this.sh, (double)(view.this.offset / Math.max(1.0, view.this.size)), (int)0, (Graphics)g, (Theme)this.theme);
            }
        }
    }

    private class Column {
        int px;
        int pw;
        int width;
        int soff;
        int sbpa;
        String subr;
        String form;
        String label;
        String sfmt;
        String items;
        Color color;
        Color dcolor;
        Color[] colors;
        String[] letters;
        char type;
        DecimalFormat df;
        MFormat mf;
        boolean toggle;
        boolean menu;
        boolean meter;
        boolean center;

        private Column() {
        }
    }
}

