/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.inc.PicSlave;
import nxm.ice.lib.Archiver;
import nxm.ice.lib.DevIce;
import nxm.ice.lib.ICEPacket;
import nxm.ice.lib.MDevIce;
import nxm.ice.lib.RamDiskResource;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PacketHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileResource;
import nxm.sys.lib.NFileResource;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libg.GValue;

public final class sourcepic
extends Primitive
implements PicSlave,
Keyable {
    private static int rFILE = -1;
    private static int rSTOPPED = 0;
    private static int rONESHOT = 1;
    private static int rCONTINUOUS = 2;
    private static int rSTOPTOP = 3;
    private static int rSTOPNOW = 4;
    private static int rSPIN = 5;
    private static int rARCHIVE = 6;
    private static int rRESTART = 7;
    private static int rABORT = 8;
    private static int rFINISH = 9;
    private static int rNEWDEVICE = 10;
    private static int rREOPEN = 11;
    private static int rRECONNECT = 12;
    private static int rRELEASE = 13;
    private static int rRESTART_WAIT = 99;
    public static String replayList = "-NShot,File,Stopped,OneShot,Continuous,StopTop,StopNow,Spin,Archive,Restart,Abort,Finish,NewDevice,Reopen,Reconnect,Release";
    private static int replayListOffset = -3;
    public static String algorithmList = "NOOP,USER,SWAP,LUT,AM,FM,PM,PSK,QPSK";
    private static int sMASTER = 1;
    private static int sWAIT = 2;
    private static int sRUN = 3;
    public static String syncList = "Master,SlaveWait,SlaveRun";
    private static int aOFF = 0;
    private static int aOPEN = 1;
    private static int aSNAP = 2;
    private static int aRT = 3;
    public static String archList = "Off,Open,SnapShot,RealTime";
    private static int pOFF = 0;
    private static int pICE = 1;
    private static int pICET = 2;
    private static int pSDDS = 3;
    public static String pktmodeList = "Off,Ice,IceT,SDDS";
    private static int mOFF = 0;
    private static int mASYNC = 1;
    private static int mINFO = 2;
    private static int mFULL = 3;
    public static String monitorList = "Off,Async,Info,Full";
    private long rndx;
    private long ondx;
    private long andx;
    private long ramsz;
    private int rcyc;
    private int ocyc;
    private int acyc;
    private int stats;
    private int pmin;
    private int pmax;
    private int pavg;
    private int ptot;
    private int snaptc;
    private int autors;
    private int renum;
    private int status;
    private int frame;
    private int bytes;
    private int dmamode;
    private int skip;
    private int oskip;
    private int nchan;
    private int nchano;
    private int multi;
    private int chan = 0;
    private int dmac;
    private int port;
    private int bits;
    private int rate;
    private int xfer;
    private int dec;
    private int rfgain;
    private int gain;
    private int replay;
    private int block;
    private int lost;
    private int lostc;
    private int mcs;
    private int vctl;
    private int packet;
    private int apacket;
    private int pktmod;
    private int apktmod;
    private int ptype;
    private int mnbytes;
    private int tinc;
    private int tcmode;
    private int tcpp;
    private int tccnt;
    private int archmode = aOFF;
    private int archtl;
    private int archtc;
    private int archcn;
    private int alg;
    private int nargs;
    private int ipflag;
    private int aipflag;
    private int archsf;
    private int monitor;
    private int maxGain;
    private int minGain;
    private int select = -1;
    private boolean module;
    private boolean tuner;
    private boolean core;
    private boolean host;
    private boolean fdec;
    private boolean flush;
    private boolean autoss;
    private boolean sgo;
    private boolean sss;
    private boolean xts;
    private boolean reset;
    private boolean isSlave;
    private boolean sdds;
    private boolean nodma;
    private boolean rtfile;
    private boolean nyfreq;
    private boolean skiponcard;
    private boolean w2e;
    private double freq;
    private double afreq;
    private double dfreq;
    private double rffreq;
    private double mtodo;
    private double delta;
    private double ratio;
    private double drate;
    private double wait;
    private double sfactor;
    private double maxout;
    private double fscale;
    private double tctolr;
    private double tcmaxtolr;
    private double tcows;
    private double tcofs = 0.0;
    private double timer;
    private double timetop;
    private double timeout;
    private double timeRTF;
    private double timecur;
    private double archfs;
    private double archto;
    private double archdur = -1.0;
    private double archoff = -1.0;
    private double syncoff;
    private double timearch;
    private double agcLevel;
    private double agcWidth;
    private double agcTime;
    private double agcPeriod;
    private String sport;
    private String alias;
    private String slave;
    private String archfn;
    private String pmss;
    private String apmss;
    private DevIce.TimeCode tc = new DevIce.TimeCode();
    private DevIce.TimeCode tclast = new DevIce.TimeCode();
    private Time tco;
    private Time time = new Time();
    private DataFile hr;
    private DataFile ho;
    private Archiver ha;
    private DevIce.DmaMap map;
    private DevIce.DmaMap smap;
    private ICEPacket pkt;
    private ICEPacket apkt;
    private MDevIce pic;
    private int[] dmacs;
    private int[] ports;
    private int[] gains;
    private PicSlave picSlave;
    private Table keys = new Table();
    private float mbps = 0.0f;
    private byte[] tbuf;
    private GValue gpw;
    private Table archkw;
    int tcretry = 5;
    private Table agcFreqs = null;
    private int agcFreq = 0;
    short[] mcsbuf = new short[8];
    short[] agcbuf;

    /*
     * Unable to fully structure code
     */
    public int open() {
        this.alias = this.MA.getS("DEV");
        this.pic = new MDevIce(this.MA, this.alias);
        if (this.pic.open() <= 0) {
            this.M.error("Problem opening device: " + this.alias);
        }
        this.autors = this.MA.getL("/AUTORS");
        this.autoss = this.MA.getState("/AUTOSS");
        this.renum = this.MA.getL("/RENUM");
        this.sdds = this.MA.getState("/SDDS");
        this.rtfile = this.MA.getState("/RTFILE");
        this.multi = this.MA.getL("/MULTI", 1);
        this.nyfreq = this.MA.getState("/NYFREQ");
        this.w2e = this.MA.getState("/WARN2ERR");
        this.archfn = this.MA.getS("/ARCH");
        this.dmacs = new int[this.multi];
        this.ports = new int[this.multi];
        this.ptype = this.pic.getKeyL(0, 102);
        this.port = this.pic.getKeyL(0, 103);
        this.reset = this.ptype != 0 && this.port != 0 && (this.multi <= 1 || this.autoss != false);
        this.reset = this.MA.getState("/RESET", this.reset);
        this.tinc = this.pic.getKeyL(this.port, 114);
        if (this.ptype == 4) ** GOTO lbl-1000
        if (this.ptype == 9) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        this.tuner = v0;
        if (this.ptype == 7) ** GOTO lbl-1000
        if (this.ptype == 8) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        this.core = v1;
        this.module = this.ptype == 3;
        this.host = this.MA.getState("/HOST", this.module);
        this.nchan = this.ptype == 9 ? this.pic.getKeyL(this.port, 107) : 1;
        this.nchan = this.MA.getL("/NCHN", this.nchan);
        this.nchano = this.MA.getL("/NCHNOUT", this.nchan);
        this.fdec = this.MA.getState("/FRAMEDEC");
        this.gains = new int[this.nchan];
        this.pktmod = sourcepic.pOFF;
        this.apacket = this.MA.getLength("/APACKET");
        if (this.apacket >= 0) {
            this.apmss = this.parsePacketMode(this.MA.getS("/APACKET"));
        }
        this.apktmod = this.pktmod;
        if (this.apktmod == sourcepic.pSDDS) {
            this.apacket = -1;
        }
        this.pktmod = sourcepic.pOFF;
        this.packet = this.MA.getLength("/PACKET");
        if (this.packet >= 0) {
            this.pmss = this.parsePacketMode(this.MA.getS("/PACKET"));
        }
        if (this.pktmod == sourcepic.pOFF && this.apktmod == sourcepic.pSDDS) {
            this.pktmod = this.apktmod;
            this.pmss = this.apmss;
        }
        if (this.pktmod == sourcepic.pSDDS) {
            this.packet = -1;
        }
        this.ipflag = 2 | (this.pktmod == sourcepic.pICET ? 1 : 0);
        this.aipflag = 2 | (this.apktmod == sourcepic.pICET ? 1 : 0);
        this.mcs = this.pic.getIntFlagDef("MCS", 0);
        this.vctl = this.pic.getIntFlagDef("VCTL", -1);
        this.hr = this.MA.getDataFile("IN");
        this.hr.open(3);
        this.hr.setOutput(false);
        v2 = this.frame = this.hr.typeClass == 2 ? this.hr.getSubSize() : 1;
        if (this.pktmod == sourcepic.pSDDS) {
            this.frame = this.frame * 1088 / 1024;
        }
        this.bits = this.hr.bps > 0 ? this.hr.bps * 8 : -this.hr.bps;
        if (this.hr.spa == 2) {
            this.bits = -this.bits;
        }
        this.bits = this.MA.getL("/BITS", this.bits);
        this.dec = Math.max(1, this.MA.getL("DEC"));
        this.skip = Math.max(1, this.MA.getL("/SKIP"));
        this.skiponcard = this.module != false && this.host == false && this.dec == 1 && this.skip > 1;
        this.skiponcard = this.MA.getState("/SKIPONCARD", this.skiponcard);
        v3 = this.skiponcard = this.MA.getState("/SKIPONHOST", this.skiponcard == false) == false;
        if (this.module && this.host && this.dec > 1 && !this.skiponcard) {
            this.skip *= this.dec;
            this.dec = 1;
        }
        this.oskip = this.skiponcard != false ? 1 : this.skip;
        this.delta = this.hr.getXDelta();
        this.ratio = this.MA.getD("/RATIO");
        if (this.ratio > 0.0) {
            this.pic.setKeyD(0, 13, this.ratio);
        }
        this.xfer = this.frame * this.MA.getL("/TL", this.frame > 1 ? 1 : 4096);
        this.replay = this.M.pipeMode == 1 ? sourcepic.rCONTINUOUS : sourcepic.rFILE;
        this.replay = this.MA.getSelectionIndex("/REPLAY", sourcepic.replayList, this.replay, sourcepic.replayListOffset);
        this.flush = this.MA.getState("/FLUSH");
        this.wait = this.MA.getD("/WAIT");
        this.timeout = this.MA.getD("/TIMEOUT", 2.0);
        this.maxout = this.MA.getD("/MAXOUT");
        this.pkt = new ICEPacket(this.hr.getFormat(), this.xfer, this.ipflag);
        this.pkt.setChannel(this.renum > 0 ? this.renum : this.port);
        this.ho = this.MA.getDataFile("OUT", this.hr, 0);
        this.ho.setYDelta(this.delta * (double)this.frame * (double)this.skip);
        this.ho.size = (this.hr.size - 1.0) / (double)this.oskip + 1.0;
        this.ho.setDataRep(this.hr.getDataRep());
        if (this.pktmod == sourcepic.pICE || this.pktmod == sourcepic.pICET) {
            this.ho.setPacketHandler((PacketHandler)this.pkt);
            if (this.packet > 0) {
                this.ho.setPacket(this.ho.getPacket() + this.pmss);
            }
        }
        this.ho.open(128 | 64);
        if (this.pktmod == sourcepic.pSDDS) {
            this.ho.keywords.putMain("PACKET", this.pmss);
        }
        this.hr.setFS(0);
        this.hr.update();
        this.ramsz = (long)this.hr.size;
        if (this.ramsz % (long)this.xfer != 0L || this.ramsz == (long)this.xfer) {
            this.M.info((CharSequence)("Ram size=" + this.ramsz + " should be an integer multiple>1 of /TL=" + this.xfer));
        }
        this.bytes = (int)((double)this.xfer * this.hr.dbpe);
        this.block = this.MA.getL("/BLOCK", this.bytes);
        if (this.oskip > 1 || this.dec > 1) {
            this.block = -1;
        }
        this.drate = 1.0 / this.delta;
        if (this.tuner) {
            this.drate = (double)(this.hr.spa * this.dec) / this.delta;
        }
        if (this.core && !this.fdec) {
            this.drate = (double)this.dec / this.delta;
        }
        if (this.ratio > 0.0) {
            this.drate /= this.ratio;
        }
        if (this.pic.getIntFlagDef("PRER2C", 0) > 0) {
            this.drate *= 2.0;
        }
        this.drate = this.MA.getD("/SRATE", this.drate);
        this.freq = this.MA.getD("FREQ", 0.0);
        this.dfreq = this.MA.getD("/DFREQ", 0.0);
        this.gain = this.MA.getL("GAIN");
        this.fscale = this.nyfreq != false ? 1.0 : 2.0 / this.drate;
        agcTable = this.MA.getTable("/AGC");
        if (agcTable != null) {
            this.setAGC(agcTable);
        }
        this.rate = (int)Math.round(this.drate);
        this.gains = new int[this.nchan];
        for (i = 0; i < this.nchan; ++i) {
            this.gains[i] = this.gain;
        }
        this.time.fromCurrent();
        this.tcmode = this.pic.getKeyL(0, 116);
        if (this.tcmode != 0) {
            this.pic.setKeyD(0, 9, this.time.getWSec(), this.time.getFSec(), -1.0);
        }
        if (this.tcmode == 1) ** GOTO lbl-1000
        if (this.tcmode == 12) ** GOTO lbl-1000
        if (this.tcmode == 8) lbl-1000:
        // 3 sources

        {
            this.tcows = 0.0;
        } else {
            this.tcows = this.time.getYiS();
        }
        this.tco = this.MA.getTime("/TCOFF");
        if (this.tco != null) {
            this.tcows = this.tco.getWSec();
            this.tcofs = this.tco.getFSec();
        }
        this.tctolr = this.MA.getD("/TCTOLR");
        this.tcmaxtolr = this.MA.getD("/TCMAXTOLR");
        tcps = this.MA.getD("/TCPS");
        sptc = tcps > 0.0 ? 1.0 / (tcps * this.delta) : this.hr.size / 2.0 / (double)Math.max(this.multi, this.nchan);
        this.tcpp = Math.max(1, (int)Math.round(sptc / (double)(this.multi * this.xfer * this.skip)));
        this.tcpp = this.MA.getL("/TCPP", this.tcpp);
        this.tcpp *= this.oskip;
        this.slave = this.MA.getS("/SLAVE", "NONE");
        this.isSlave = this.slave.equals("NONE") == false;
        this.sss = this.slave.equals("SS");
        this.xts = this.slave.equals("XT");
        this.sgo = this.isSlave != false && this.sss == false && this.xts == false;
        this.slave = this.MA.getS("/MASTER", null);
        this.alg = this.MA.getSelectionIndex("/ALG", sourcepic.algorithmList, 0, 0);
        if (this.alg > 0) {
            this.pic.setKeyL(0, 7, this.alg);
        }
        this.status = this.reset != false ? this.pic.reset(0) : 1;
        if (this.status < 0) {
            this.M.error("Problem resetting device");
        }
        this.map = this.pic.mapFile(this.hr);
        if (this.map == null) {
            this.M.error("Problem mapping DMA memory");
        }
        if (this.multi > 1 || !this.MA.getState("/PAGED", true)) {
            this.map.setPaged(false);
        }
        if (this.ptype == 1) {
            this.map.setPaged(false);
            this.map.getVirtualAddress(0L, (int)this.map.bytes);
        }
        this.openPorts();
        this.MR.put(this.MA.getU("/DMAC"), this.dmac);
        v4 = this.nodma = this.pic.getKeyL(this.dmac, 37) > 0;
        if (this.skiponcard) {
            this.pic.setKeyL(this.dmac, 6, this.frame * this.nchano);
            this.pic.setKeyL(this.dmac, 28, this.skip);
        }
        if (this.ratio > 0.0) {
            this.setRatio(this.ratio);
        }
        this.sport = this.pic.getPortKey();
        this.hr.keywords.put("PORT", (Object)this.sport);
        if (this.archfn != null) {
            this.hr.keywords.put("ARCHIVE", (Object)this.getArchFN());
        }
        if (this.pic.getDblFlagDef("RFFREQ", 0.0) > 0.0) {
            this.rffreq = this.pic.getKeyD(this.dmac, 61);
            this.hr.keywords.put("D:RFFREQ", (Object)this.rffreq);
            this.rfgain = this.pic.getKeyL(this.dmac, 62);
            this.hr.keywords.put("L:RFGAIN", (Object)this.rfgain);
        }
        if (this.multi > 1) {
            this.hr.keywords.put("L:MULTI", (Object)this.multi);
        }
        if (this.nchan > 1) {
            this.hr.keywords.put("L:NCHAN", (Object)this.nchan);
        }
        if (this.tuner) {
            this.hr.keywords.put("D:FREQ", (Object)this.freq);
        }
        this.hr.update();
        if (this.isSlave) {
            this.replay = sourcepic.rSTOPPED;
        }
        if (!this.MA.find("/POLL")) {
            this.setPollTime(0.025);
        }
        this.dmamode = 0;
        this.mtodo = this.smap.bytes;
        this.todo = 0.0;
        this.acyc = 0;
        this.ocyc = 0;
        this.andx = 0L;
        this.ondx = 0L;
        this.sfactor = 100.0 / (double)this.smap.bytes;
        if ((long)(this.bytes * this.oskip) > this.smap.bytes) {
            this.M.error("Skip cannot be greater than one buffer");
        }
        if (this.rtfile) {
            this.updateRTF(true);
        }
        this.archtl = this.MA.getL("/ARCHTL", 131072);
        this.archto = this.MA.getL("/ARCHTO", -1);
        this.archsf = this.MA.getL("/ARCHSF", 0);
        this.archfs = this.MA.getD("/ARCHSFS", -1.0);
        this.archcn = this.MA.getL("/ARCHCHN");
        this.archkw = this.MA.getTable("/ARCHKW");
        if (this.archsf != 0 && this.archsf == 1) {
            this.archsf = -1;
        }
        if (this.nchano > 1 && (this.apacket >= 0 || this.archcn >= 0)) {
            this.archtl = this.xfer;
        }
        this.apkt = new ICEPacket(this.ho.getFormat(), this.archtl, this.aipflag);
        if (this.apktmod == sourcepic.pSDDS) {
            this.archtl = this.archtl * 1088 / 1024;
        }
        this.startArch(this.archfn, this.archoff, this.archdur);
        this.setDelta(this.delta);
        this.stats = this.MA.getL("/STATS");
        gpwo = this.MA.getO("/GPWR");
        if (gpwo instanceof GValue) {
            this.gpw = (GValue)gpwo;
        }
        if (this.gpw != null) {
            this.gpw.setValue(0.0);
        }
        this.monitor = this.MA.getSelectionIndex("/MONITOR", sourcepic.monitorList, sourcepic.mFULL, -1);
        this.setKeys(this.MA.getTable("/PICKEYS"));
        return 0;
    }

    public synchronized int process() {
        this.timecur = Time.current();
        if (this.rtfile) {
            this.updateRTF(false);
        }
        if (this.replay == rABORT) {
            return 9;
        }
        if (this.replay == rRELEASE) {
            for (int n = 0; n < this.multi; ++n) {
                this.pic.dmaFunc(this.dmacs[n], -8);
            }
            this.replay = rSTOPPED;
        }
        if (this.todo == 0.0) {
            int newmode;
            if (this.replay == rSTOPTOP || this.replay == rSTOPNOW) {
                this.replay = rSTOPPED;
            }
            if (this.replay == rSTOPPED) {
                return -1;
            }
            if (this.replay == rFINISH) {
                return 9;
            }
            if (this.replay == rRESTART && this.autors >= 2) {
                Time.sleep((double)0.2);
                this.pic.dmaFunc(this.dmac, -15);
                this.replay = rRESTART_WAIT;
                this.timer = Time.current();
            }
            if (this.replay == rRESTART_WAIT) {
                if (this.pic.dmaFunc(this.dmac, -12) == 0) {
                    Time.sleep((double)0.2);
                } else {
                    if (Time.current() - this.timer < this.timeout + 1.0) {
                        return -1;
                    }
                    if (this.autors >= 3) {
                        this.pic.dmaFunc(this.dmac, -16);
                    }
                    this.warning("All DMA channels on this input did not shut down");
                    Time.sleep((double)0.5);
                }
                this.replay = rCONTINUOUS;
            }
            this.lostc = 0;
            this.lost = 0;
            this.acyc = 0;
            this.ocyc = 0;
            this.rcyc = 0;
            this.andx = 0L;
            this.ondx = 0L;
            this.rndx = 0L;
            this.pmin = 100;
            this.pmax = 0;
            this.ptot = 0;
            this.pkt.setCount(0);
            this.apkt.setCount(0);
            int n = this.nodma ? -20 : (this.replay == rONESHOT ? 1 : (newmode = -2));
            if (this.slave != null) {
                this.setSlaveReplay(this.replay, newmode);
            }
            if (this.wait > 0.0) {
                Time.sleep((double)this.wait);
            }
            if (this.stats > 0) {
                this.M.info((CharSequence)("Sourcepic-" + this.dmac + " START"));
            }
            for (int n2 = this.multi - 1; n2 >= 0; --n2) {
                this.pic.dmaFunc(this.dmacs[n2], newmode);
            }
            this.dmamode = newmode;
            this.todo = this.mtodo;
            this.snaptc = 1;
            this.tc.initMetrics();
            this.tclast.initMetrics();
            this.timearch = this.agcTime = (this.timecur = Time.current());
            this.timetop = this.agcTime;
            this.timer = this.agcTime;
        }
        if (this.ha.isOpen && this.archto > 0.0 && this.timecur - this.timearch > this.archto) {
            this.ha.checkChannels();
            this.ha.flush();
            this.timearch = this.timecur;
        }
        if (this.archmode == aOPEN) {
            this.startArch(this.archfn, this.archoff, this.archdur);
        }
        if (this.replay == rSPIN) {
            return -1;
        }
        long index = this.pic.dmaFuncX(this.dmac, -4);
        if (index == -1L) {
            if (this.pic.getKeyL(0, 147) < 0) {
                this.replay = rSTOPNOW;
            }
        }
        if (this.replay == rSTOPNOW || this.replay == rRESTART || this.replay == rFINISH) {
            this.todo = 0.0;
        }
        if (this.agcPeriod > 0.0 && !this.tuner && this.timer - this.agcTime > this.agcPeriod) {
            this.processWBAGC();
        }
        if (this.todo > 0.0) {
            int n;
            int tbytes;
            if (index < this.rndx) {
                this.rcyc = this.pic.dmaFunc(this.dmac, -5);
            }
            if (this.rcyc - this.ocyc > 10 || this.ocyc - this.rcyc > 10) {
                this.warning("Probable bad rcyc=" + this.rcyc + " ocyc=" + this.ocyc + " read");
                this.rcyc = this.pic.dmaFunc(this.dmac, -5);
            }
            this.rndx = index;
            int behind = this.rcyc - (this.ocyc + this.lost);
            if (behind > 1 || behind == 1 && this.rndx > this.ondx) {
                this.warning("Falling behind " + behind + " buffers. Rcyc=" + this.rcyc + " Ocyc=" + this.ocyc + " Lost=" + this.lost + " ID=" + this.id);
                this.lost = this.rcyc - this.ocyc;
            }
            int sbytes = tbytes = this.bytes * this.nchano;
            if (this.ha.isOpen) {
                sbytes *= this.oskip;
            }
            if (this.ondx + (long)sbytes > this.smap.bytes) {
                sbytes = (int)(this.smap.bytes - this.ondx);
            }
            if (this.rcyc < this.ocyc + this.lost || this.rndx < this.ondx + (long)sbytes && this.rcyc <= this.ocyc + this.lost) {
                if (this.timeout <= 0.0 || this.timecur - this.timer < this.timeout) {
                    return -1;
                }
                this.warning("Detected DMA stall > timeout. Rcyc=" + this.rcyc + " Ocyc=" + this.ocyc + " Lost=" + this.lost);
                if (this.autors > 0) {
                    this.setReplay(rRESTART);
                }
                this.timer = this.timecur;
                return -1;
            }
            for (int n3 = 1; n3 < this.multi; ++n3) {
                index = this.pic.dmaFuncX(this.dmacs[n3], -4);
                if (index >= this.ondx + (long)sbytes || this.rcyc > this.ocyc + this.lost) continue;
                return -1;
            }
            if (this.tcmode != 0) {
                this.processTimeCode();
            }
            if (this.ho.isOpen) {
                long vaddr;
                if (this.ondx + (long)tbytes > this.smap.bytes) {
                    this.M.info((CharSequence)("Partial buffer out " + this.ondx + " " + this.smap.bytes));
                    vaddr = this.map.getVirtualAddress(this.ondx - (long)tbytes, tbytes);
                } else {
                    vaddr = this.map.getVirtualAddress(this.ondx, tbytes);
                }
                if (this.monitor == mOFF || this.monitor != mFULL && this.ho.io.avail() < (long)tbytes) {
                    if (this.monitor == mINFO) {
                        this.M.info((CharSequence)"Dropping monitor frame");
                    }
                } else if (this.nchano > 1 || this.mcs > 0) {
                    if (this.packet < 0) {
                        this.ho.write(vaddr, 0, tbytes);
                    } else {
                        for (n = 0; n < this.nchano; ++n) {
                            if (this.mcs > 0) {
                                this.pkt.setChannel(this.getMCSchn(vaddr, n, this.bytes));
                            } else {
                                this.pkt.setChannel(n + 1);
                            }
                            this.ho.write(vaddr, 0 + n * this.bytes, this.bytes);
                        }
                    }
                } else if (this.multi > 1) {
                    for (n = 0; n < this.multi; ++n) {
                        this.pkt.setChannel(this.renum > 0 ? this.renum + n : this.ports[n]);
                        this.ho.write(vaddr, 0 + n * (int)this.smap.bytes, this.bytes);
                    }
                } else {
                    this.ho.write(vaddr, 0, this.bytes);
                }
                if (this.maxout > 0.0 && this.ho.seek() >= this.maxout) {
                    return 9;
                }
            }
            if (this.ha.isOpen) {
                index = this.ondx + (long)sbytes;
                tbytes = (int)((double)this.archtl * this.ha.dbpe);
                if (this.nchano > 1 && (this.apacket >= 0 || this.archcn >= 0)) {
                    tbytes *= this.nchano;
                }
                while (this.acyc < this.ocyc || this.acyc == this.ocyc && this.andx + (long)tbytes <= index) {
                    long vaddr = this.map.getVirtualAddress(this.andx, tbytes);
                    if (this.nchano > 1) {
                        if (this.archcn == -2) {
                            this.ha.write(vaddr, 0, tbytes, -2);
                        } else if (this.apacket < 0 && this.archcn < 0) {
                            this.ha.write(vaddr, 0, tbytes, -1);
                        } else {
                            for (n = 0; n < this.nchano; ++n) {
                                this.apkt.setChannel(n + 1);
                                if (this.archcn >= 0 && n != this.archcn) continue;
                                this.ha.write(vaddr, 0 + n * this.bytes, this.bytes, n);
                            }
                        }
                    } else if (this.multi == 1) {
                        this.ha.write(vaddr, 0, tbytes, -1);
                    } else {
                        for (n = 0; n < this.multi; ++n) {
                            this.apkt.setChannel(this.renum > 0 ? this.renum + n : this.ports[n]);
                            this.ha.write(vaddr, 0 + n * (int)this.smap.bytes, tbytes, n);
                        }
                    }
                    this.apkt.upCount();
                    this.apkt.decTCO(this.archtl);
                    this.andx += (long)tbytes;
                    if (!((double)this.andx >= this.mtodo)) continue;
                    ++this.acyc;
                    this.andx = 0L;
                }
                if (this.archmode == aSNAP && this.ha.seek() * this.delta > this.archdur) {
                    this.archmode = aOFF;
                }
                if (this.archmode == aOFF) {
                    this.stopArch();
                }
                if (this.ha.isFinished()) {
                    return 9;
                }
            }
            this.ondx += (long)(this.bytes * this.nchano * this.oskip);
            this.todo = this.mtodo - (double)this.ondx;
            this.pkt.decTCO(this.xfer * this.skip);
            this.pkt.upCount(this.skip);
            this.time.addSec(this.delta * (double)this.xfer * (double)this.skip);
            this.timer = this.timecur;
        }
        if (this.todo <= 0.0) {
            int lostd;
            boolean partial;
            if (this.replay == rONESHOT) {
                if (this.pic.dmaFunc(this.dmac, -13) != 0) {
                    this.todo = -1.0;
                    return -1;
                }
            }
            ++this.ocyc;
            this.todo = 0.0;
            this.ondx -= this.smap.bytes;
            boolean bl = partial = this.replay == rSTOPNOW || this.replay == rRESTART || this.replay == rFINISH;
            if (!partial) {
                this.mbps = (float)(1.0E-6 * (double)this.multi * (double)this.smap.bytes / Math.max(0.01, this.timer - this.timetop));
            }
            if (this.stats > 0 && !partial) {
                int pf = 0;
                if (this.pic.dmaFunc(this.dmac, -5) == this.ocyc + this.lost) {
                    pf = (int)Math.round(this.sfactor * (double)this.pic.dmaFuncX(this.dmac, -22));
                }
                if (pf == 100) {
                    pf = 0;
                }
                if (pf < this.pmin) {
                    this.pmin = pf;
                }
                if (pf > this.pmax) {
                    this.pmax = pf;
                }
                this.ptot += pf;
                if (this.ocyc % this.stats == 0) {
                    this.pavg = this.ptot / this.stats;
                    String s = "CYC=" + this.ocyc + ",LOST=" + this.lost + ",FAVG=" + this.pavg;
                    if (this.sdds) {
                        int gap = this.pic.getKeyL(this.dmac, 39);
                        s = s + ",GMIN=" + (gap & 0xFFFF) + ",GMAX=" + (gap >> 16 & 0xFFFF);
                    } else if (this.stats > 1) {
                        s = s + ",FMIN=" + this.pmin + ",FMAX=" + this.pmax;
                    }
                    this.M.info((CharSequence)("Sourcepic-" + this.dmac + " STATS={" + s + ",MBPS=" + this.mbps + "}"));
                    this.pmin = 100;
                    this.pmax = 0;
                    this.ptot = 0;
                }
            }
            this.timetop = this.timer;
            if (this.agcPeriod != 0.0 && this.tuner) {
                this.processNBAGC();
            }
            if (this.ha.isOpen && this.flush) {
                this.ha.flush();
            }
            if ((lostd = this.pic.dmaFunc(this.dmac, -10)) > this.lostc) {
                this.warning("Sourcepic-" + this.dmac + " LOST=" + (lostd - this.lostc) + " card buffers");
                this.lostc = lostd;
            }
            if (this.replay < rFILE) {
                ++this.replay;
                this.todo = this.mtodo;
                return 0;
            }
            if (this.replay == rCONTINUOUS) {
                this.todo = this.mtodo;
                return 0;
            }
            if (this.replay == rRESTART && this.autors >= 2) {
                Time.sleep((double)0.2);
                this.pic.dmaFunc(this.dmac, -15);
            }
            if (this.stats > 0) {
                this.M.info((CharSequence)("Sourcepic-" + this.dmac + " STOP"));
            }
            for (int n = 0; n < this.multi; ++n) {
                this.pic.dmaFunc(this.dmacs[n], 0);
                this.pic.dmaFunc(this.dmacs[n], -8);
            }
            this.dmamode = 0;
            if (this.slave != null) {
                this.setSlaveReplay(this.replay, this.dmamode);
            }
            if (this.replay == rFILE || this.replay == rFINISH) {
                return 9;
            }
            if (this.replay == rONESHOT) {
                if (this.snaptc < 0) {
                    this.hr.update();
                }
                if (this.flush) {
                    this.flushRamBuffer();
                }
                this.rcyc = 1;
            }
            this.replay = this.replay != rRESTART ? rSTOPPED : (this.autors >= 2 ? rRESTART_WAIT : rCONTINUOUS);
            this.timer = this.timecur;
            if (this.ha.isOpen) {
                this.ha.checkChannels();
            }
            if (this.ha.isOpen) {
                this.ha.discontinue();
            }
        }
        if (this.gpw != null) {
            this.gpw.setValue(this.getProgress());
        }
        return 0;
    }

    public int close() {
        if (this.dmamode != 0 && this.stats > 0) {
            this.M.info((CharSequence)"Sourcepic CANCEL");
        }
        for (int n = 0; n < this.multi; ++n) {
            if (this.dmacs == null || this.dmacs[n] <= 0) continue;
            this.pic.dmaFunc(this.dmacs[n], -9);
        }
        this.stopArch();
        if (this.gpw != null) {
            this.gpw.setValue(1.0);
        }
        if (this.hr != null) {
            this.hr.close();
        }
        if (this.ho != null) {
            this.ho.close();
        }
        if (this.map != null) {
            this.map.close();
        }
        if (this.pic != null) {
            this.pic.close();
        }
        this.replay = rSTOPPED;
        this.dmamode = 0;
        return 0;
    }

    private void warning(String text) {
        if (this.w2e) {
            this.M.error(text);
        } else {
            this.M.warning((CharSequence)text);
        }
    }

    private void flushRamBuffer() {
        if (this.hr.io instanceof RamDiskResource) {
            return;
        }
        int tbytes = (int)(this.hr.size * this.hr.dbpe);
        this.hr.setOutput(true);
        this.hr.seek(0.0);
        long vaddr = this.map.getVirtualAddress(0L, tbytes);
        this.hr.write(vaddr, 0, tbytes);
        this.hr.setOutput(false);
    }

    private void updateRTF(boolean init) {
        if (init) {
            this.timeRTF = Time.current();
        } else if (this.timecur - this.timeRTF < 0.05) {
            return;
        }
        this.timeRTF = this.timecur;
        if (this.snaptc < 0) {
            sourcepic.setTime(this.hr, this.tc.wsec, this.tc.fsec - this.tc.offset * this.delta);
        }
        double inbytes = this.getBytes();
        this.hr.setInByte(inbytes);
        this.hr.ioh.write(this.hr.hb, 80, 8, 80L);
        this.hr.ioh.read(this.hr.hb, 88, 8, 88L);
        double fill = (inbytes - this.hr.getOutByte(0)) / (double)this.map.bytes;
        if (this.vctl > 0) {
            this.pic.setKeyD(this.dmac, 174, fill);
        }
    }

    private void openPorts() {
        if (this.ptype == 9) {
            int pktlen = this.MA.getL("/PKTLEN", this.bytes);
            this.pic.setKeyL(this.port, 107, this.nchan);
            this.pic.setKeyL(this.port, 19, pktlen);
            this.pic.setKeyD(this.port, 20, this.dfreq * this.fscale);
        }
        for (int n = 0; n < this.multi; ++n) {
            int flags = 0;
            if (n == 0) {
                if (this.sgo) {
                    flags = 0x100000;
                }
                if (this.sss) {
                    flags = 0x40000000;
                }
                if (this.xts) {
                    flags = 0x800000 | 0x200000;
                }
            } else {
                flags = n == 1 && !this.autoss ? 0x100000 : 0x40000000;
            }
            double nfreq = (this.freq + (double)n * this.dfreq) * 2.0 / (double)this.rate;
            this.dmac = this.pic.ioPort(this.ptype, this.port, -1, -1, this.bits, this.rate, nfreq, this.dec, this.gain, flags);
            if (this.dmac <= 0) {
                this.M.error("Problem setting up IO port");
            }
            this.smap = this.map.getSubMap(n, this.multi);
            this.status = this.pic.dmaSetup(this.dmac, -1, this.smap, this.block, 0);
            if (this.status < 0) {
                this.M.error("Problem setting up DMA channel " + this.status);
            }
            this.dmacs[n] = this.dmac;
            this.ports[n] = this.port++;
            if (this.autoss) {
                this.port += this.tinc;
                continue;
            }
            if (n % 2 == 0) continue;
            this.port = this.port - 1 + this.tinc;
        }
        this.dmac = this.dmacs[0];
        this.port = this.ports[0];
        this.afreq = this.pic.getKeyD(this.dmac, 2) / this.fscale;
    }

    private String parsePacketMode(String ss) {
        String pmss = ss == null || ss.length() == 0 ? "ICE" : (ss.startsWith("DET") ? "ICE/" + ss : (ss.equals("SDDS") ? "SDDS/ICE" : ss));
        if (pmss.startsWith("SDDS")) {
            this.pktmod = pSDDS;
        } else if (pmss.startsWith("ICET")) {
            this.pktmod = pICET;
            pmss = pmss.substring(4);
        } else if (pmss.startsWith("ICE")) {
            this.pktmod = pICE;
            pmss = pmss.substring(3);
        } else {
            this.M.error("Illegal Packet Mode Switch String: " + ss);
        }
        return pmss;
    }

    private void processTimeCode() {
        int days;
        if (this.snaptc > 0 && this.snaptc < this.tcretry) {
            ++this.snaptc;
        } else if (this.archtc > 0 && this.archtc < this.tcretry) {
            ++this.archtc;
        } else {
            this.tccnt += this.oskip;
            if (this.tccnt < this.tcpp) {
                return;
            }
            this.tccnt -= this.tcpp;
        }
        int tcstat = this.pic.tc(this.dmac, -1.0, this.delta, this.tc, 0);
        if (this.tcmode != 1 && tcstat > 0 && this.tc.wsec < 100.0 && ((days = (int)Math.round(-(this.tc.diff(this.tclast) + this.tcows) / 86400.0)) == 365 || days == 366)) {
            this.tcows += (double)(days * 86400);
        }
        this.tc.wsec += this.tcows;
        this.tc.fsec += this.tcofs;
        double tboff = (double)(this.ocyc + this.lost) * this.mtodo;
        int cskip = this.skiponcard ? this.skip : 1;
        double toff = this.tc.offset - (double)cskip * (tboff + (double)this.ondx) / (double)this.hr.bpa / (double)this.nchano;
        this.pkt.setTC(this.tcmode, tcstat, toff, this.tc.wsec, this.tc.fsec);
        if (tcstat == -7) {
            this.warning("Time code NOCLOCK err detected");
            if (this.autors > 0) {
                this.setReplay(rRESTART);
            }
        }
        if (tcstat < 0 && tcstat != -9) {
            return;
        }
        if (this.tctolr > 0.0 && this.tclast.delta >= 0.0) {
            double tcerr = this.tc.err(this.tclast);
            if (this.tcmaxtolr > 0.0 && Math.abs(tcerr) > this.tcmaxtolr) {
                this.warning("Time code slip=" + tcerr + " > maxtolr=" + this.tcmaxtolr + ". Assumed bogus and ignored");
                this.tclast.update(this.tc);
                return;
            }
            if (Math.abs(tcerr) > this.tctolr) {
                this.warning("Time code slip=" + tcerr + " > tolr=" + this.tctolr + " delta=" + this.tc.delta);
                if (this.autors > 0) {
                    this.setReplay(rRESTART);
                }
            }
        }
        this.tc.computeMetrics(this.tclast, this.delta);
        if (this.snaptc > 0) {
            this.snaptc = -1;
            sourcepic.setTime(this.hr, this.tc.wsec, this.tc.fsec - this.tc.offset * this.delta);
            this.hr.update();
            sourcepic.setTime(this.ho, this.tc.wsec, this.tc.fsec - this.tc.offset * this.delta);
        }
        this.ho.setTimeAt(this.tc.wsec + (this.tc.fsec - toff * this.delta));
        if (this.ha.isOpen) {
            toff = this.tc.offset - (tboff + (double)this.andx) / (double)this.hr.bpa / (double)this.nchano;
            if (this.archtc != 0) {
                this.archtc = 0;
                this.ha.setTime(this.tc.wsec, this.tc.fsec - (this.tc.offset - this.archoff) * this.delta);
            }
            this.apkt.setTC(this.tcmode, tcstat, toff, this.tc.wsec, this.tc.fsec);
            this.ha.setTimeAt(this.tc.wsec + (this.tc.fsec - toff * this.delta));
        }
        this.pkt.getTC(this.time, 0.0, this.delta);
        this.tclast.update(this.tc);
    }

    public void setArchFN(String value) {
        this.archfn = value;
    }

    public void setArchDur(double value) {
        this.archdur = value;
    }

    public void setArchOff(double value) {
        this.archoff = value;
    }

    public void setSyncOff(double value) {
        this.syncoff = ((double)this.rcyc * this.mtodo + (double)this.rndx) / (double)this.hr.bpa;
    }

    public void setArchMode(String value) {
        this.setArchMode(Parser.find((String)archList, (String)value, (int)this.archmode, (int)-1));
    }

    private void setArchMode(int mode) {
        if (mode == aOFF) {
            this.stopArchiver();
        } else if (this.archmode != aOFF) {
            this.warning("Cannot restart an archive without stopping first");
        } else if (mode == aSNAP) {
            if (this.archdur < 0.0) {
                this.archdur = this.hr.getLength();
            }
            this.archmode = aOPEN;
        } else if (mode == aRT) {
            this.archdur = -1.0;
            this.archmode = aOPEN;
        } else {
            this.archmode = mode;
        }
    }

    public void startArchiver(String fname) {
        this.archfn = fname;
        this.startArchiver();
    }

    public void startArchiver(String fname, double dur) {
        this.archfn = fname;
        this.archdur = dur;
        this.startArchiver();
    }

    public void startArchiver(String fname, double off, double dur) {
        this.archfn = fname;
        this.archoff = off;
        this.archdur = dur;
        this.startArchiver();
    }

    public void startArchiver() {
        this.setArchMode(aOPEN);
    }

    public void stopArchiver() {
        this.archmode = aOFF;
    }

    private void startArch(String fname, double time, double dur) {
        this.stopArch();
        this.ha = new Archiver(this);
        if (fname == null || fname.length() == 0 || fname.startsWith("NULL")) {
            return;
        }
        if (this.ramsz <= (long)this.archtl) {
            this.M.error("Ram buffer length=" + this.ramsz + " must be increased to at least 2x the /ARCHTL=" + this.archtl);
        }
        if (this.ramsz % (long)this.archtl != 0L) {
            this.M.error("Ram size=" + this.ramsz + " must be an integer multiple>1 of /ARCHTL=" + this.archtl);
        }
        if (this.MA.getL("/SDDSMULTI") > 0) {
            this.M.error("Switch /SDDSMULTI=n deprecated. Replace with file qualifier {FUNC=SDDSUNPACK,MULTI=n}");
        }
        this.ha.init((MidasReference)this, fname, this.hr, 0);
        if (this.multi > 1) {
            this.ha.setMulti(this.multi);
        }
        if (this.nchan > 1) {
            this.ha.setNChan(this.nchan);
        }
        if (this.archsf != 0) {
            this.ha.setMulti(-1);
            this.ha.setMaxLines(this.archsf);
            this.ha.setMaxLineSize(this.archfs > 0.0 ? this.archfs : (double)this.map.bytes);
        }
        if (this.apacket >= 0) {
            this.apkt.setCount(0);
            this.ha.setPacketHandler(this.apkt);
        }
        if (this.apacket > 0) {
            this.ha.setPacket(this.ha.getPacket() + this.apmss);
        }
        this.ha.setFS(0);
        this.ha.open(0x80 | 0x40);
        if (!this.ha.isOpen) {
            return;
        }
        if (this.apktmod == pSDDS) {
            this.ha.keywords.putMain("PACKET", this.apmss);
        }
        if (this.ha.io instanceof FileResource && !(this.ha.io instanceof NFileResource)) {
            this.warning("UhOh. Using slower non-native file access.  Check installation.");
        }
        this.archmode = dur > 0.0 ? aSNAP : aRT;
        this.archtc = 1;
        int tbytes = (int)((double)this.archtl * this.ha.dbpe);
        if (this.archoff >= 0.0) {
            this.archoff *= (double)this.hr.bpa;
            this.acyc = (int)(this.archoff / this.mtodo);
            this.andx = (long)(this.archoff - (double)this.acyc * this.mtodo);
            this.andx = this.andx / (long)tbytes * (long)tbytes;
        } else {
            this.acyc = this.ocyc;
            this.andx = this.ondx / (long)tbytes * (long)tbytes;
        }
        this.archoff = ((double)this.acyc * this.mtodo + (double)this.andx) / (double)this.hr.bpa;
        this.ha.keywords.put("D:ARCHOFF", (Object)this.archoff);
    }

    private void stopArch() {
        this.archmode = aOFF;
        this.archoff = -1.0;
        if (this.ha != null && this.ha.isOpen) {
            this.ha.close();
        }
    }

    @Override
    public void setReplay(String value) {
        if (value.equalsIgnoreCase("STOP")) {
            value = "STOPNOW";
        }
        if (value.equalsIgnoreCase("START")) {
            value = "CONTINUOUS";
        }
        int nreplay = Parser.find((String)replayList, (String)value, (int)this.replay, (int)replayListOffset);
        this.setReplay(nreplay);
    }

    private void setReplay(int nreplay) {
        if (nreplay == 0 && this.replay != 0) {
            this.replay = rSTOPNOW;
        } else if (nreplay == rRESTART && this.replay == 0) {
            this.replay = rCONTINUOUS;
        } else if (nreplay == rONESHOT && this.replay == rCONTINUOUS) {
            this.replay = rSTOPTOP;
        } else if (nreplay >= rNEWDEVICE && this.replay != 0) {
            this.warning("Port must be Stopped to perform NewDevice|Reopen|Reconnect");
        } else {
            this.replay = nreplay;
        }
        if (this.replay == rSTOPNOW) {
            this.process();
        }
        if (this.replay == rRECONNECT) {
            this.openPorts();
            this.replay = 0;
        }
        if (this.replay >= rABORT && this.slave != null) {
            this.setSlaveReplay(this.replay, 0);
        }
        if (this.replay == rCONTINUOUS && this.nodma) {
            this.replay = rSPIN;
        }
    }

    private void setSlaveReplay(int value, int mode) {
        int smode;
        if (this.picSlave == null) {
            this.picSlave = (PicSlave)this.M.registry.get(this.slave);
        }
        if (this.picSlave == null) {
            this.warning("Slave=" + this.slave + " does not exist");
            return;
        }
        if (mode == 0 && value < rABORT) {
            value = rSTOPNOW;
        }
        if (this.nodma && value == rSPIN) {
            value = rCONTINUOUS;
        }
        this.picSlave.setReplay(this.getReplay(value));
        while ((smode = this.picSlave.getDmaMode()) != mode) {
            if (smode == -20) {
                if (mode == -2) break;
            }
            if (mode == -20) {
                if (smode == -2) break;
            }
            Time.sleep((double)this.pollTime);
        }
    }

    public void setRate(int value) {
        if (value == this.rate) {
            return;
        }
        if (this.pic.setKeyL(this.dmac, 1, this.rate) < 0) {
            this.MA.put("/SRATE", "" + value);
            this.setState(7);
        } else {
            this.rate = value;
        }
        this.fscale = this.nyfreq ? 1.0 : 2.0 / (double)this.rate;
    }

    public void setFreq(double value) {
        this.freq = value;
        if (this.ptype == 9) {
            this.pic.setKeyD(this.dmac, 2, value * this.fscale);
        } else if (this.chan > 0) {
            this.pic.setKeyD(this.dmacs[this.chan - 1], 2, value * this.fscale);
        } else {
            for (int n = 0; n < this.multi; ++n) {
                this.pic.setKeyD(this.dmacs[n], 2, (value + (double)n * this.dfreq) * this.fscale);
            }
        }
        this.afreq = this.pic.getKeyD(this.dmac, 2) / this.fscale;
    }

    public void setFreqs(Data value) {
        for (int i = 0; i < value.size; ++i) {
            this.pic.setKeyL(this.dmac, 16, i + 1);
            this.pic.setKeyD(this.dmac, 2, value.getD(i) * this.fscale);
        }
    }

    public void setDec(int value) {
        for (int n = 0; n < this.multi; ++n) {
            this.pic.setKeyL(this.dmacs[n], 3, value);
        }
        this.dec = this.pic.getKeyL(this.dmac, 3);
        if (this.dec != value) {
            this.M.info((CharSequence)("Decimation " + value + " rounded to " + this.dec));
        }
        if (this.dmamode != 0 && this.autors > 0) {
            this.setReplay(rRESTART);
        }
        this.setDelta(this.getDelta());
    }

    private void setDelta(double value) {
        this.delta = value;
        if ((this.ipflag & 1) != 0) {
            this.pkt.setAbscissa(0.0, this.delta);
        }
        if ((this.aipflag & 1) != 0) {
            this.apkt.setAbscissa(0.0, this.delta);
        }
    }

    public void setGain(int value) {
        this.gain = Math.max(this.minGain, Math.min(this.maxGain, value));
        if (this.ptype == 9) {
            this.pic.setKeyL(this.dmac, 4, this.gain);
        } else if (this.chan > 0) {
            this.pic.setKeyL(this.dmacs[this.chan - 1], 4, this.gain);
        } else {
            for (int n = 0; n < this.multi; ++n) {
                this.pic.setKeyL(this.dmacs[n], 4, this.gain);
            }
        }
    }

    public void setRatio(double value) {
        if (this.ptype == 9) {
            this.pic.setKeyD(this.dmac, 13, value);
        } else if (this.chan > 0) {
            this.pic.setKeyD(this.dmacs[this.chan - 1], 13, value);
        } else {
            for (int n = 0; n < this.multi; ++n) {
                this.pic.setKeyD(this.dmacs[n], 13, value);
            }
        }
        this.ratio = this.pic.getKeyD(this.dmac, 13);
    }

    public void setSelect(int value) {
        int i;
        if (value == this.select) {
            return;
        }
        for (i = 1; i <= this.mcs; ++i) {
            if (value < 0 || this.select >= 0 && i != this.select) continue;
            this.pic.setKeyL(this.dmac, 16, i);
            this.pic.setKeyL(this.dmac, 165, 0);
        }
        for (i = 1; i <= this.mcs; ++i) {
            if (value >= 0 && (value <= 0 || i != value)) continue;
            this.pic.setKeyL(this.dmac, 16, i);
            this.pic.setKeyL(this.dmac, 165, 1);
        }
        this.select = value;
    }

    public void setChannel(int value) {
        if (this.multi > 1) {
            this.chan = Math.max(1, Math.min(this.multi, value));
            this.gain = this.pic.getKeyL(this.dmacs[this.chan - 1], 4);
            this.afreq = this.pic.getKeyD(this.dmacs[this.chan - 1], 2) / this.fscale;
            this.chan = Math.max(0, Math.min(this.multi, value));
        } else if (this.ptype == 9) {
            this.chan = value;
            this.pic.setKeyL(this.dmac, 16, this.chan);
            this.afreq = this.pic.getKeyD(this.dmac, 2) / this.fscale;
        } else if (value > 1) {
            this.M.warning((CharSequence)"Should not be setting channel>1 when not in TBANK or MULTI modes");
        } else {
            this.chan = value;
        }
    }

    public void setEnable(int value) {
        this.pic.setKeyL(this.dmac, 165, value);
    }

    public void setAlgorithm(String value) {
        this.alg = Parser.find((String)algorithmList, (String)value, (int)this.alg, (int)0);
        this.pic.setKeyL(this.dmac, 7, this.alg);
    }

    public void setMonitor(String value) {
        this.monitor = Parser.find((String)monitorList, (String)value, (int)this.monitor, (int)-1);
    }

    public void setArgument(int n, int value) {
        this.pic.setKeyL(this.dmac, 300 + n, value);
    }

    public void setStats(int value) {
        this.stats = value;
    }

    public void setMinGain(int value) {
        this.minGain = value;
    }

    public void setMaxGain(int value) {
        this.maxGain = value;
    }

    public void setAgcLevel(double value) {
        this.agcLevel = value;
    }

    public void setAgcWidth(double value) {
        this.agcWidth = value;
    }

    public void setGPW(GValue value) {
        this.gpw = value;
    }

    private String getReplay(int replay) {
        return Parser.get((String)replayList, (int)(replay - replayListOffset));
    }

    @Override
    public String getReplay() {
        return this.getReplay(this.replay);
    }

    public int getDec() {
        return this.dec;
    }

    public int getGain() {
        return this.gain;
    }

    public int getRate() {
        return this.rate;
    }

    public double getRatio() {
        return this.ratio;
    }

    public double getFreq() {
        return this.afreq;
    }

    public String getPort() {
        return this.sport;
    }

    public int getRfGain() {
        return this.rfgain;
    }

    public double getRfFreq() {
        return this.rffreq;
    }

    public int getChannel() {
        return this.chan;
    }

    public int getCycle() {
        return this.rcyc;
    }

    public long getIndex() {
        return this.rndx;
    }

    public double getProgress() {
        if (this.maxout > 0.0) {
            return this.ho.seek() / this.maxout;
        }
        if (this.archdur > 0.0) {
            return this.ha.getOffset() * this.ha.getDelta() / this.archdur;
        }
        return (double)this.rndx / (double)this.map.bytes;
    }

    public double getBytes() {
        return (double)this.rcyc * (double)this.map.bytes + (double)this.rndx;
    }

    public double getBytesOut() {
        return (double)this.ocyc * (double)this.map.bytes + (double)this.ondx;
    }

    public int getSkip() {
        return this.skip;
    }

    public String getAlgorithm() {
        return Parser.get((String)algorithmList, (int)this.alg);
    }

    public String getMonitor() {
        return Parser.get((String)monitorList, (int)this.monitor, (int)-1);
    }

    public int getArgument(int n) {
        return this.pic.getKeyL(this.dmac, 300 + n);
    }

    public Time getTime() {
        return this.time;
    }

    public DevIce.TimeCode getTimeCode() {
        return this.tclast;
    }

    public String getFormat() {
        return this.hr.getFormat();
    }

    public int getHBLost() {
        return this.lost;
    }

    public int getPFull() {
        return this.pavg;
    }

    public int getCBLost() {
        return this.lostc;
    }

    @Override
    public int getDmaMode() {
        return this.dmamode;
    }

    public double getOffset() {
        return this.ha.isOpen ? this.ha.getOffset() : this.ho.getOffset();
    }

    public MDevIce getDevIce() {
        return this.pic;
    }

    public Archiver getArchiver() {
        return this.ha;
    }

    public String getArchFN() {
        if (this.archfn == null) {
            return null;
        }
        int i = this.archfn.indexOf(123);
        if (i > 0) {
            return this.archfn.substring(0, i);
        }
        return this.archfn;
    }

    public String getArchMode() {
        return Parser.get((String)archList, (int)(this.archmode + 1));
    }

    public double getArchDur() {
        return this.archmode == aRT ? this.ha.getLength() : this.archdur;
    }

    public double getArchOff() {
        return this.archmode == aRT ? this.ha.getOffset() * this.ha.getDelta() : this.archoff;
    }

    public double getArchTop() {
        return this.archmode == aRT ? this.ha.getTimeAt(0.0) : 0.0;
    }

    public Table getArchKW() {
        return this.archkw;
    }

    public double getSyncOff() {
        return this.syncoff;
    }

    public ICEPacket getPkt() {
        return this.pkt;
    }

    public ICEPacket getAPkt() {
        return this.apkt;
    }

    public float getMBPS() {
        return this.mbps;
    }

    public int getTCMode() {
        return this.tcmode;
    }

    public boolean isTuner() {
        return this.tuner;
    }

    public double getDelta() {
        double delta = 1.0 / (double)this.rate;
        if (this.core) {
            delta *= (double)this.dec;
        }
        if (this.tuner) {
            delta *= (double)(this.hr.spa * this.dec);
        }
        if (this.ratio > 0.0) {
            delta /= this.ratio;
        }
        return delta;
    }

    public double getChannelFreq(int chn) {
        double fcny = 0.0;
        if (this.ptype == 9) {
            this.pic.setKeyL(this.dmac, 16, chn);
            Data data = new Data(this.freq * 2.0 / (double)this.rate);
            this.pic.getKey(this.dmac, 51, data);
            this.pic.setKeyL(this.dmac, 16, this.chan);
            fcny = data.getD(0);
        } else {
            int n = Math.max(1, Math.min(this.multi, chn)) - 1;
            fcny = this.pic.getKeyD(this.dmacs[n], 2);
        }
        return fcny * (double)this.rate / 2.0;
    }

    public void setAGC(Table tbl) {
        this.agcLevel = tbl.getD("LEVEL", 0.0);
        this.agcWidth = tbl.getD("WIDTH", 1.0);
        this.maxGain = tbl.getL("MAXGAIN", 100);
        this.minGain = tbl.getL("MINGAIN", -100);
        this.agcPeriod = tbl.getD("PERIOD", 1.0);
        this.agcTime = Time.current();
    }

    public void setRfGain(int value) {
        this.pic.setKeyL(this.dmac, 62, value);
        this.rfgain = this.pic.getKeyL(this.dmac, 62);
        this.hr.keywords.put("L:RFGAIN", (Object)this.rfgain);
        this.hr.update();
    }

    public void setRfFreqKWO(double value) {
        this.rffreq = value;
    }

    public void setRfFreq(double value) {
        if (this.agcLevel != 0.0) {
            int tfreq = (int)(Math.round(value * 0.1) * 10L);
            if (tfreq != this.agcFreq && this.agcFreq != 0) {
                if (this.agcFreqs == null) {
                    this.agcFreqs = new Table();
                }
                this.agcFreqs.put("F" + this.agcFreq, this.gain);
                Object tobj = this.agcFreqs.get("F" + tfreq);
                if (tobj != null) {
                    this.setGain(Convert.o2l((Object)tobj));
                    this.agcTime = Time.current();
                }
            }
            this.agcFreq = tfreq;
        }
        this.pic.setKeyD(this.dmac, 61, value);
        this.rffreq = this.pic.getKeyD(this.dmac, 61);
        this.hr.keywords.put("D:RFFREQ", (Object)this.rffreq);
        this.hr.update();
        this.ha.addEventKey("RFFREQ", this.rffreq);
    }

    public Table getTable(Table t) {
        return new Table(this.pic.getKeyTable(this.dmac, t.toString()));
    }

    private void setKeys(Table kt) {
        if (kt == null || kt.size() == 0) {
            return;
        }
        Table.Iterator ti = kt.iterator();
        while (ti.getNext()) {
            String sval;
            String string = sval = ti.value == null ? "QUERY" : ti.value.toString();
            if (sval.length() == 0 || sval.equals("QUERY")) {
                this.keys.put(ti.key, ti.value);
                continue;
            }
            this.setKey(ti.key, ti.value);
        }
    }

    public String[] getKeys() {
        return this.keys.getKeys();
    }

    public synchronized Object setKey(String key, Object value) {
        block10: {
            byte ityp;
            int ikey;
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                block14: {
                                                    block13: {
                                                        block12: {
                                                            block11: {
                                                                block9: {
                                                                    if (!key.equals("REPLAY")) break block9;
                                                                    this.setReplay(Convert.o2s((Object)value));
                                                                    break block10;
                                                                }
                                                                if (!key.equals("RATE")) break block11;
                                                                this.setRate(Convert.o2l((Object)value));
                                                                break block10;
                                                            }
                                                            if (!key.equals("FREQ")) break block12;
                                                            this.setFreq(Convert.o2d((Object)value));
                                                            break block10;
                                                        }
                                                        if (!key.equals("DEC")) break block13;
                                                        this.setDec(Convert.o2l((Object)value));
                                                        break block10;
                                                    }
                                                    if (!key.equals("GAIN")) break block14;
                                                    this.setGain(Convert.o2l((Object)value));
                                                    break block10;
                                                }
                                                if (!key.equals("RATIO")) break block15;
                                                this.setRatio(Convert.o2d((Object)value));
                                                break block10;
                                            }
                                            if (!key.equals("RFFREQ")) break block16;
                                            this.setRfFreq(Convert.o2d((Object)value));
                                            break block10;
                                        }
                                        if (!key.equals("RFGAIN")) break block17;
                                        this.setRfGain(Convert.o2l((Object)value));
                                        break block10;
                                    }
                                    if (!key.equals("TABLE")) break block18;
                                    value = this.pic.setKeyTable(this.dmac, value.toString());
                                    break block10;
                                }
                                if (!key.startsWith("ALG")) break block19;
                                this.setAlgorithm(Convert.o2s((Object)value));
                                break block10;
                            }
                            if (!key.startsWith("CHAN")) break block20;
                            this.setChannel(Convert.o2l((Object)value));
                            break block10;
                        }
                        if (!key.startsWith("SELECT")) break block21;
                        this.setSelect(Convert.o2l((Object)value));
                        break block10;
                    }
                    ikey = this.pic.name2key(key);
                    if (ikey <= 0 && key.equals("VLAN")) {
                        ikey = 404;
                    }
                    if (ikey <= 0 && key.equals("JOIN")) {
                        ikey = 402;
                    }
                    if (ikey <= 0 && key.equals("LEAVE")) {
                        ikey = 403;
                    }
                    if (ikey <= 0) {
                        return null;
                    }
                    ityp = this.pic.getKeyType(ikey);
                    if (ikey == 402) break block22;
                    if (ikey != 403) break block23;
                }
                value = new Integer(this.pic.str2ip(Convert.o2s((Object)value)));
            }
            if (ityp == 68) {
                this.pic.setKeyD(this.dmac, ikey, Convert.o2d((Object)value));
            } else {
                this.pic.setKeyL(this.dmac, ikey, Convert.o2l((Object)value));
            }
            this.keys.put(key, value);
        }
        return value;
    }

    public synchronized Object getKey(String key) {
        Object value = null;
        if (key.equals("REPLAY")) {
            value = this.getReplay();
        } else if (key.equals("RATE")) {
            value = Convert.l2o((int)this.getRate());
        } else if (key.equals("FREQ")) {
            value = Convert.d2o((double)this.getFreq());
        } else if (key.equals("DEC")) {
            value = Convert.l2o((int)this.getDec());
        } else if (key.equals("GAIN")) {
            value = Convert.l2o((int)this.getGain());
        } else if (key.equals("RATIO")) {
            value = Convert.d2o((double)this.getRatio());
        } else {
            int ikey = this.pic.name2key(key);
            if (ikey <= 0) {
                return null;
            }
            byte ityp = this.pic.getKeyType(ikey);
            value = ityp == 68 ? Convert.d2o((double)this.pic.getKeyD(this.dmac, ikey)) : Convert.l2o((int)this.pic.getKeyL(this.dmac, ikey));
        }
        return value;
    }

    private int getMCSchn(long vaddr, int n, int bytes) {
        int off = n * bytes;
        Native.p2ja((long)vaddr, (int)off, (Object)this.mcsbuf, (int)0, (int)8);
        int chan = ((this.mcsbuf[0] & 1) << 0) + ((this.mcsbuf[1] & 1) << 1) + ((this.mcsbuf[2] & 1) << 2) + ((this.mcsbuf[3] & 1) << 3);
        if (++chan >= this.mcs) {
            chan = this.mcs;
        }
        return chan;
    }

    private void processWBAGC() {
        this.agcTime = Time.current();
        int adlm = this.pic.getKeyL(this.dmac, 155);
        if (adlm <= -90) {
            return;
        }
        double diff = (double)adlm - this.agcLevel;
        int dgain = 0;
        if (diff > 6.0) {
            dgain = -3;
        } else if (diff > 1.0) {
            dgain = -1;
        } else if (diff < -1.0) {
            dgain = 1;
        } else if (diff < -6.0) {
            dgain = 3;
        }
        if (dgain != 0) {
            this.setGain(this.gain + dgain);
        }
    }

    private void processNBAGC() {
        int n = this.ptype == 9 ? 256 : 8192;
        int loop = this.ptype == 9 ? this.nchan * 4 : 1;
        int bytes = n * 4;
        int done = (1 << this.nchan) - 1;
        long offset = this.map.bytes / 2L;
        if (this.agcbuf == null) {
            this.agcbuf = new short[n * 2];
        }
        for (int i = 0; i < loop && done != 0; ++i) {
            long vaddr = this.map.getVirtualAddress(offset, bytes);
            Native.p2ja((long)vaddr, (int)0, (Object)this.agcbuf, (int)0, (int)bytes);
            float avg = this.hr.spa == 2 ? this.calcAvgM(this.agcbuf, n) : this.calcAvg(this.agcbuf, n * 2);
            avg = (float)(20.0 * Math.log(avg));
            int gmod = 0;
            if ((double)avg < this.agcLevel - this.agcWidth) {
                gmod = 1;
            }
            if ((double)avg < this.agcLevel - this.agcWidth * 4.0) {
                gmod = 2;
            }
            if ((double)avg > this.agcLevel + this.agcWidth) {
                gmod = -1;
            }
            if ((double)avg > this.agcLevel + this.agcWidth * 4.0) {
                gmod = -2;
            }
            if (gmod != 0) {
                if (this.ptype == 9) {
                    int lchan = this.chan;
                    int lgain = this.gain;
                    this.chan = this.getMCSchn(vaddr, 0, bytes);
                    int dmask = 1 << this.chan - 1;
                    if ((dmask & done) != 0) {
                        this.gain = this.gains[this.chan - 1];
                        this.pic.setKeyL(this.dmac, 16, this.chan);
                        this.setGain(this.gain + gmod);
                        this.gains[this.chan - 1] = this.gain;
                        this.chan = lchan;
                        this.gain = lgain;
                        this.pic.setKeyL(this.dmac, 16, this.chan);
                        done ^= dmask;
                    }
                } else {
                    this.setGain(this.gain + gmod);
                    done = 0;
                }
            }
            offset += (long)bytes;
        }
    }

    public int getChnGain(int chan) {
        return this.gains[Math.max(1, Math.min(this.nchan, chan)) - 1];
    }

    private float calcAvg(short[] buf, int ns) {
        float mavg = 0.0f;
        for (int i = 0; i < ns; ++i) {
            mavg += (float)Math.abs(buf[i]);
        }
        return mavg / ((float)ns * 32768.0f);
    }

    private float calcAvgM(short[] buf, int ns) {
        float mavg = 0.0f;
        int j = 0;
        for (int i = 0; i < ns; ++i) {
            float ar = buf[j++];
            float ai = buf[j++];
            mavg = (float)((double)mavg + Math.sqrt(ar * ar + ai * ai));
        }
        return mavg / ((float)ns * 32768.0f);
    }

    public static void setTime(DataFile df, double wsec, double fsec) {
        double timeu = 1.0E-6 * Math.floor(fsec * 1000000.0 + 0.5);
        int timep = (int)Math.floor((fsec - timeu) * 1.0E12 + 0.5);
        df.setTimeCode(wsec + timeu);
        df.keywords.putMain("TC_PREC", "" + timep + "e-12");
    }
}

