/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.inc.PicSlave;
import nxm.ice.lib.ArchSFN;
import nxm.ice.lib.DevIce;
import nxm.ice.lib.ICEPacket;
import nxm.ice.lib.MDevIce;
import nxm.ice.lib.RamDiskResource;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasThread;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public final class sinkpic
extends Primitive
implements PicSlave,
Keyable {
    private static int rFILE = -1;
    private static int rSTOPPED = 0;
    private static int rONESHOT = 1;
    private static int rCONTINUOUS = 2;
    private static int rSTOPTOP = 3;
    private static int rSTOPNOW = 4;
    private static int rSPIN = 5;
    private static int rARCHIVE = 6;
    private static int rRESTART = 7;
    private static int rABORT = 8;
    private static int rFINISH = 9;
    private static int rNEWDEVICE = 10;
    private static int rREOPEN = 11;
    private static int rRECONNECT = 12;
    private static int rRELEASE = 13;
    private static int rRESTART_WAIT = 99;
    public static String replayList = "-NShot,File,Stopped,OneShot,Continuous,StopTop,StopNow,Spin,Archive,Restart,Abort,Finish,NewDevice,Reopen,Reconnect,Release";
    private static int replayListOffset = -3;
    public static String algorithmList = "NOOP,USER,SWAP,LUT,AM,FM,PM,PSK,QPSK";
    private static int sSTOP = 1;
    private static int sWAIT = 2;
    private static int sRUN = 3;
    public static String syncList = "Master,SlaveWait,SlaveRun";
    private static int tOFF = 0;
    private static int tONESHOTS = 1;
    private static int tCONTINUOUS = 2;
    private static int tTHROTTLED = 3;
    private static int tONDEMAND = 4;
    private static int tBYPASS = 5;
    public static String throttleList = "Off,OneShots,Continuous,Throttled,OnDemand,Bypass";
    private static int mOFF = 0;
    private static int mASYNC = 1;
    private static int mINFO = 2;
    private static int mFULL = 3;
    public static String monitorList = "Off,Async,Info,Full";
    private long ondx;
    private long indx;
    private long lndx;
    private long rndx;
    private long bdelay;
    private long bstart;
    private long ramsz;
    private int ocyc;
    private int icyc;
    private int lcyc;
    private int rcyc;
    private int status;
    private int frame;
    private int bytes;
    private int bpa;
    private int flags;
    private int dmamode;
    private int throttle;
    private int monitor;
    private int dmac;
    private int port;
    private int bits;
    private int gain;
    private int rate;
    private int trate;
    private int xfer;
    private int dec;
    private int skip;
    private int oskip;
    private int replay;
    private int lost;
    private int lostc;
    private int block;
    private int packet;
    private int pktmod;
    private int ipkt;
    private int ptype;
    private int mnbytes;
    private int tinc;
    private int tcmode;
    private int tcpp;
    private int archtl;
    private int archsf;
    private int nchn;
    private int rtfile;
    private int stats;
    private int pmin;
    private int pmax;
    private int pavg;
    private int ptot;
    private boolean sgo;
    private boolean sss;
    private boolean xts;
    private boolean autors;
    private boolean reset;
    private boolean inmem;
    private boolean ramoncard;
    private boolean wrap;
    private boolean doneReading;
    private boolean isSlave;
    private boolean isCX;
    private boolean nodma;
    private boolean async;
    private boolean w2e;
    private boolean skiponcard;
    private boolean lbdma;
    private boolean nopref;
    private boolean tuner;
    private boolean core;
    private double freq;
    private double dfreq;
    private double fscale;
    private double mtodo;
    private double delta;
    private double ratio;
    private double drate;
    private double tcoff;
    private double poll;
    private double wait;
    private double delay;
    private double prefill;
    private double sfactor;
    private double timer;
    private double timetop;
    private double tctolr = 1.0E-8;
    private String archfn;
    private String alias;
    private String slave;
    private DevIce.TimeCode tc = new DevIce.TimeCode();
    private Time tcs;
    private Time time = new Time();
    private DataFile hr;
    private DataFile ho;
    private DataFile hi;
    private MDevIce pic;
    private DevIce.DmaMap map;
    private DevIce.DmaMap omap;
    private ICEPacket pkt;
    private PicSlave picSlave;
    private Table keys = new Table();
    private float mbps = 0.0f;
    private ArchSFN asfn;

    /*
     * Unable to fully structure code
     */
    public int open() {
        this.alias = this.MA.getS("DEV");
        this.pic = new MDevIce(this.MA, this.alias);
        if (this.pic.open() <= 0) {
            this.M.error("Problem opening device: " + this.alias);
        }
        this.stats = this.MA.getL("/STATS");
        this.autors = this.MA.getState("/AUTORS");
        this.wrap = this.MA.getState("/WRAP");
        this.rtfile = this.MA.getL("/RTFILE");
        this.throttle = this.MA.getSelectionIndex("/THROTTLE", sinkpic.throttleList, 0, -1);
        this.w2e = this.MA.getState("/WARN2ERR");
        this.lbdma = this.pic.getIntFlagDef("LBDMA", 0) > 0;
        this.nopref = this.pic.getIntFlagDef("NOPREFILL", 0) > 0;
        this.ptype = this.pic.getKeyL(0, 102);
        this.port = this.pic.getKeyL(0, 103);
        if (this.ptype == 4) ** GOTO lbl-1000
        if (this.ptype == 9) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        this.tuner = v0;
        if (this.ptype == 7) ** GOTO lbl-1000
        if (this.ptype == 8) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        this.core = v1;
        this.reset = this.ptype != 0 && this.port != 0;
        this.reset = this.MA.getState("/RESET", this.reset);
        this.archfn = this.MA.getCS("IN");
        this.archsf = this.MA.getL("/ARCHSF", 0);
        this.archtl = this.MA.getL("/ARCHTL", 0x100000);
        if (this.archsf != 0) {
            if (this.archsf == 1) {
                this.archsf = -1;
            }
            this.asfn = new ArchSFN(this, this.archfn, this.archsf);
            this.asfn.setTL(this.archtl);
            this.asfn.setTop(this.MA.getD("/ARCHTOP"));
            this.asfn.setDur(this.MA.getD("/ARCHDUR"));
            this.openNextFile(true);
        } else {
            this.hi = this.MA.getDataFile("IN");
            this.hi.open(128);
        }
        this.tcs = this.hi.getTime();
        this.hr = this.MA.getDataFile("OUT");
        this.hr.open(3);
        this.hr.setOutput(false);
        this.frame = this.hr.typeClass == 2 ? this.hr.getSubSize() : 1;
        this.isCX = this.hr.getSPA() == 2;
        this.bpa = this.hr.getBPA();
        this.dec = this.MA.getL("DEC");
        this.skip = Math.max(1, this.MA.getL("/SKIP"));
        this.skiponcard = this.MA.getState("/SKIPONCARD");
        if (this.ptype == 3 && this.dec > 1 && this.skip == 1) {
            this.skip = this.dec;
            this.dec = 1;
        }
        this.oskip = this.skiponcard != false ? 1 : this.skip;
        this.delta = this.hr.getXDelta();
        this.ratio = this.MA.getD("/RATIO");
        this.nchn = this.MA.getL("/NCHN", 1);
        this.ho = this.MA.getDataFile("/MON", this.hr, 0);
        this.ho.setYDelta(this.delta * (double)this.frame * (double)this.skip);
        this.ho.size = (this.hr.size - 1.0) / (double)this.oskip + 1.0;
        this.ho.open(64);
        this.hi.setDFS(0);
        this.hr.setFS(0);
        this.hr.update();
        this.bits = this.hr.bps > 0 ? this.hr.bps * 8 : -this.hr.bps;
        if (this.hr.spa == 2) {
            this.bits = -this.bits;
        }
        this.bits = this.MA.getL("/BITS", this.bits);
        this.drate = this.MA.getD("/SRATE");
        if (this.dec <= 0) {
            this.dec = Math.max(1, (int)Math.round(this.delta * this.drate));
        }
        this.drate = Math.round((double)this.dec / this.delta);
        this.dfreq = this.MA.getD("/DFREQ", this.drate);
        if (this.ratio > 0.0) {
            this.drate *= this.ratio;
        }
        this.drate = this.MA.getD("/SRATE", this.drate);
        if (this.ratio < 0.0) {
            this.ratio = this.drate / ((double)this.dec / this.delta);
        }
        this.delay = this.MA.getD("/DELAY", 0.2);
        this.prefill = this.MA.getD("/PREFILL", this.nopref != false ? 0.0 : -1.0);
        this.nopref |= this.prefill == 0.0;
        if (this.prefill > 0.0) {
            this.delay = this.prefill;
        }
        this.freq = this.MA.getD("FREQ", 0.0 * this.drate);
        this.gain = this.MA.getL("GAIN");
        this.rate = (int)Math.round(this.drate);
        this.trate = this.MA.getL("/TRATE", Math.max(10000, this.rate / 8));
        v2 = this.fscale = this.isCX != false ? 1.0 / this.drate : 2.0 / this.drate;
        if (this.ratio > 0.0 && this.ratio != 1.0) {
            this.pic.setKeyD(0, 13, this.ratio);
        }
        if (this.ptype == 9) {
            this.ratio = this.drate * this.delta;
            this.pic.setKeyD(0, 20, this.fscale * this.dfreq);
            this.pic.setKeyD(0, 13, this.ratio);
            this.pic.setKeyL(0, 107, this.nchn);
        }
        this.xfer = this.frame * this.MA.getL("/TL", this.hr.typeClass == 2 ? 1 : 4096);
        this.ramsz = (long)this.hr.size;
        if (this.ramsz % (long)this.xfer != 0L || this.ramsz == (long)this.xfer) {
            this.warning("Ram size=" + this.ramsz + " should be an integer multiple>1 of /TL=" + this.xfer);
        }
        this.bytes = (int)((double)this.xfer * this.hr.dbpe);
        this.ramsz = (long)(this.hr.size * this.hr.dbpe);
        if ((long)(this.bytes * this.oskip) > this.ramsz / 2L) {
            this.warning("/TL * DEC should be less than 1/2 ram buffer");
        }
        this.block = this.MA.getL("/BLOCK", -1);
        this.replay = this.M.pipeMode == 1 ? sinkpic.rCONTINUOUS : sinkpic.rFILE;
        this.replay = this.MA.getSelectionIndex("/REPLAY", sinkpic.replayList, this.replay, sinkpic.replayListOffset);
        this.tcmode = this.pic.getKeyL(0, 116);
        if (!this.tcs.isZero()) {
            this.time.fromTime(this.tcs);
        } else {
            this.time.fromCurrent();
        }
        this.tcoff = this.tcmode == 1 ? 0.0 : this.time.getYiS();
        this.tcoff = this.MA.getD("/TCOFF", this.tcoff);
        this.tctolr = this.MA.getD("/TCTOLR", this.tctolr);
        this.tcpp = this.MA.getL("/TCPP", Math.max(1, (int)(this.hr.size / (double)this.xfer / (double)this.oskip)));
        this.packet = this.MA.getLength("/PACKET");
        this.pktmod = this.MA.getL("/PKTMODE", -1);
        this.pkt = new ICEPacket(this.hi.getFormat(), this.xfer, this.pktmod);
        this.slave = this.MA.getS("/SLAVE", "NONE");
        this.isSlave = this.slave.equals("NONE") == false;
        this.sss = this.slave.equals("SS");
        this.xts = this.slave.equals("XT");
        this.sgo = this.isSlave != false && this.sss == false && this.xts == false && this.slave.equals("NS") == false;
        this.slave = this.MA.getS("/MASTER", null);
        this.status = this.reset != false ? this.pic.reset(0) : 1;
        if (this.status < 0) {
            this.M.error("Problem resetting device");
        }
        this.map = this.pic.mapFile(this.hr);
        if (this.map == null) {
            this.M.error("Problem mapping DMA memory");
        }
        if (!this.MA.getState("/PAGED", true)) {
            this.map.setPaged(false);
        }
        if (this.ptype == 1) {
            this.map.setPaged(false);
            this.map.getVirtualAddress(0L, (int)this.map.bytes);
        }
        this.omap = this.map.getSubMap(0, 1);
        this.flags = 0;
        if (this.sgo) {
            this.flags = 0x100000;
        }
        if (this.sss) {
            this.flags = 0x40000000;
        }
        if (this.xts) {
            this.flags = 0x800000 | 0x200000;
        }
        if (this.throttle == sinkpic.tONESHOTS || this.throttle == sinkpic.tONDEMAND) {
            this.flags |= 2048;
        }
        this.openPorts();
        this.status = this.pic.dmaSetup(this.dmac, 1, this.map, this.block, 0);
        if (this.status < 0) {
            this.M.error("Problem setting up DMA channel " + this.status);
        }
        this.MR.put(this.MA.getU("/DMAC"), this.dmac);
        v3 = this.nodma = this.pic.getKeyL(this.dmac, 37) > 0;
        if (this.skiponcard) {
            this.pic.setKeyL(this.dmac, 6, this.frame);
            this.pic.setKeyL(this.dmac, 28, this.skip);
        }
        this.inmem = this.hi.getURL().equals(this.hr.getURL());
        this.inmem = this.MA.getState("/INMEM", this.inmem);
        this.ramoncard = this.MA.getState("/RAMONCARD");
        this.wait = this.MA.getD("/WAIT");
        if (this.replay == sinkpic.rSTOPPED && this.MA.getState("/RELEASE")) {
            this.replay = sinkpic.rSTOPNOW;
        }
        if (this.isSlave) {
            this.replay = sinkpic.rSTOPPED;
        }
        if (!this.MA.find("/POLL")) {
            this.setPollTime(0.025);
        }
        if (!this.tcs.isZero()) {
            this.pic.setKeyD(this.dmac, 9, this.tcs.getWSec(), this.tcs.getFSec());
        }
        this.dmamode = 0;
        this.todo = 0.0;
        this.mtodo = this.map.bytes;
        this.rcyc = 0;
        this.lcyc = 0;
        this.icyc = 0;
        this.ocyc = 0;
        this.rndx = 0L;
        this.lndx = 0L;
        this.indx = 0L;
        this.ondx = 0L;
        if (this.inmem && this.rtfile != 1) {
            this.doneReading = this.loadRamBuffer();
        }
        this.sfactor = 100.0 / (double)this.map.bytes;
        if (this.ramoncard) {
            for (p2 = 4096L; p2 < this.map.bytes; p2 *= 2L) {
            }
            if (p2 != this.map.bytes) {
                this.M.warning((CharSequence)("RamOnCard file size=" + this.map.bytes + " must be a power of 2"));
            }
        }
        csize = this.pic.getKeyL(this.dmac, 112);
        this.bdelay = Math.round(this.delay / this.delta * this.hi.dbpe);
        this.bstart = Math.min((long)(0.95 * (double)this.map.bytes), this.bdelay);
        if (this.bstart > 0L) {
            this.bstart = Math.min(this.map.bytes, Math.max(this.bstart, (long)(2 * csize)));
        }
        if (this.throttle == sinkpic.tONESHOTS) {
            this.bstart = this.map.bytes;
        }
        if (this.throttle == sinkpic.tONDEMAND && this.prefill < 0.0) {
            this.bstart = 0L;
        }
        if (this.nodma | this.lbdma | this.nopref) {
            this.bstart = 0L;
        }
        if (this.lbdma) {
            this.pic.setKeyD(this.dmac, 164, this.delay * 1.0E9);
        }
        this.async = this.MA.getState("/ASYNC");
        if (this.async && !this.doneReading) {
            dearch = new DeArchiver();
            thread = new MidasThread(this.M, (Runnable)dearch);
            thread.start();
        }
        sport = this.pic.getPortKey();
        this.hr.keywords.put("PORT", (Object)sport);
        if (this.archfn != null) {
            this.hr.keywords.put("ARCHIVE", (Object)this.getArchFN());
        }
        if ((rffreq = this.pic.getKeyD(this.dmac, 61)) > 0.0) {
            this.hr.keywords.put("D:RFFREQ", (Object)rffreq);
        }
        this.hr.update();
        this.monitor = this.MA.getSelectionIndex("/MONITOR", sinkpic.monitorList, sinkpic.mFULL, -1);
        this.setKeys(this.MA.getTable("/PICKEYS"));
        return 0;
    }

    public synchronized int process() {
        long index;
        if (this.replay == rABORT) {
            return 9;
        }
        int noop = -1;
        if (this.replay != rSTOPPED) {
            if (!this.async && !this.doneReading && this.readBuffer()) {
                noop = 0;
            }
            if (this.throttle == tONDEMAND && this.indx != this.lndx) {
                this.pic.setKeyL(this.dmac, 60, (int)(this.indx >> 6));
            }
            if (this.throttle == tONESHOTS && this.icyc != this.lcyc && this.icyc > 1) {
                this.pic.dmaFunc(this.dmac, -11);
            }
            if (this.throttle == tCONTINUOUS || this.throttle == tTHROTTLED) {
                double full;
                index = this.pic.dmaFuncX(this.dmac, -4);
                double d = full = this.doneReading ? 1.0 : (double)(this.indx - index) / (double)this.map.bytes;
                if (full <= 0.0) {
                    full += 1.0;
                }
                if (this.throttle == tCONTINUOUS && full < 0.25) {
                    this.pic.setKeyL(this.dmac, 1, this.trate);
                    this.throttle = tTHROTTLED;
                }
                if (this.throttle == tTHROTTLED && full > 0.75) {
                    this.pic.setKeyL(this.dmac, 1, this.rate);
                    this.throttle = tCONTINUOUS;
                }
            }
            this.lndx = this.indx;
            this.lcyc = this.icyc;
        }
        if (this.todo == 0.0) {
            int newmode;
            if (this.replay == rSTOPTOP || this.replay == rSTOPNOW) {
                this.pic.dmaFunc(this.dmac, -8);
                this.replay = rSTOPPED;
            }
            if (this.replay == rSTOPPED) {
                return noop;
            }
            this.lostc = 0;
            this.lost = 0;
            this.rcyc = 0;
            this.ocyc = 0;
            this.rndx = 0L;
            this.ondx = 0L;
            this.pkt.setCount(0);
            if (this.icyc == 0 && this.indx < this.bstart && !this.doneReading) {
                return noop;
            }
            if (this.rtfile > 1) {
                this.updateRTF();
            }
            int n = this.nodma ? -20 : (this.ramoncard ? -19 : (this.lbdma ? -23 : (newmode = -2)));
            if (this.replay == rSPIN) {
                newmode = -1;
            }
            if (this.replay == rONESHOT) {
                newmode = 1;
            }
            if (this.throttle == tONESHOTS) {
                newmode = -11;
            }
            if (this.throttle == tONDEMAND) {
                newmode = -17;
            }
            if (this.slave != null) {
                this.setSlaveReplay(this.replay, newmode);
            }
            if (this.wait > 0.0) {
                Time.sleep((double)this.wait);
            }
            if (this.stats > 0) {
                this.M.info((CharSequence)("Sinkpic-" + this.dmac + " START"));
            }
            this.pic.dmaFunc(this.dmac, newmode);
            this.dmamode = newmode;
            this.todo = this.mtodo;
            this.timer = this.timetop = Time.current();
        }
        if (this.replay == rSPIN) {
            return noop;
        }
        index = this.pic.dmaFuncX(this.dmac, -4);
        if (index == -1L) {
            if (this.pic.getKeyL(0, 147) < 0) {
                this.replay = rSTOPNOW;
            }
        }
        if (this.replay == rSTOPNOW || this.replay == rFINISH) {
            this.todo = 0.0;
        }
        if (this.todo > 0.0) {
            int tbytes;
            if (index < this.rndx) {
                this.rcyc = this.pic.dmaFunc(this.dmac, -5);
            }
            this.rndx = index;
            if (this.inmem && this.rtfile != 1) {
                this.indx = this.rndx;
                this.icyc = this.rcyc + 1;
            }
            if (this.rcyc < this.ocyc + this.lost) {
                return noop;
            }
            if (this.doneReading && !this.inmem && (this.ocyc > this.icyc || this.ondx >= this.indx)) {
                this.replay = rFINISH;
                return 0;
            }
            int behind = this.rcyc - (this.icyc + this.lost);
            if (index > this.indx) {
                ++behind;
            }
            if (behind > 0) {
                if (!this.inmem) {
                    this.warning("Falling behind " + behind + " buffers");
                }
                this.lost += behind;
            }
            if (this.ondx + (long)(tbytes = this.bytes) > this.map.bytes) {
                tbytes = (int)(this.map.bytes - this.ondx);
            }
            if (index < this.ondx + (long)tbytes && this.rcyc <= this.ocyc + this.lost) {
                return noop;
            }
            int count = this.pkt.getCount();
            if (this.tcmode != 0 && count % this.tcpp == 0) {
                int tcstat = this.pic.tc(this.dmac, -1.0, this.delta, this.tc, 0);
                this.tc.wsec += this.tcoff;
                this.pkt.setTC(this.tcmode, tcstat, this.tc.offset, this.tc.wsec, this.tc.fsec);
                if (count == 0) {
                    this.ho.setTime(this.tc.wsec, this.tc.fsec - this.tc.offset * this.delta);
                }
            }
            if (this.rtfile > 1) {
                this.updateRTF();
            }
            if (this.ho.isOpen && tbytes > 0) {
                long vaddr;
                if (this.ondx + (long)this.bytes > this.map.bytes) {
                    this.M.warning((CharSequence)("Partial buffer out " + this.ondx + " " + this.map.bytes));
                    vaddr = this.omap.getVirtualAddress(this.ondx - (long)this.bytes, this.bytes);
                } else {
                    vaddr = this.omap.getVirtualAddress(this.ondx, this.bytes);
                }
                if (this.monitor != mOFF) {
                    if (this.monitor != mFULL && this.ho.io.avail() < (long)tbytes) {
                        if (this.monitor == mINFO) {
                            this.M.info((CharSequence)"Dropping monitor frame");
                        }
                    } else {
                        this.ho.write(vaddr, 0, this.bytes);
                    }
                }
            }
            if (tbytes <= 0) {
                this.todo = 0.0;
            } else {
                this.ondx += (long)(this.bytes * this.oskip);
                this.todo = this.mtodo - (double)this.ondx;
                this.pkt.upCount();
            }
            if (this.tcmode == 1) {
                this.time.fromCurrent();
            } else if (this.tcmode != 0) {
                double dtc = (double)((long)this.ocyc * this.map.bytes + this.ondx) / this.hr.dbpe;
                if (this.wrap && dtc > this.hi.size) {
                    dtc %= this.hi.size;
                }
                this.time.fromJ1950(this.hi.getTimeAt(dtc));
            }
        }
        if (this.todo <= 0.0) {
            int lostd;
            boolean partial;
            ++this.ocyc;
            this.todo = 0.0;
            this.ondx -= this.map.bytes;
            long gap = this.rndx - this.indx + (long)(this.rcyc - this.icyc - this.lost + 1) * this.map.bytes;
            int pf = this.doneReading ? 0 : (int)Math.round(this.sfactor * (double)gap);
            this.timer = Time.current();
            boolean bl = partial = this.replay == rSTOPNOW || this.replay == rFINISH;
            if (this.stats > 0 && !partial) {
                if (pf < this.pmin) {
                    this.pmin = pf;
                }
                if (pf > this.pmax) {
                    this.pmax = pf;
                }
                this.ptot += pf;
                if (this.ocyc % this.stats == 0) {
                    this.pavg = this.ptot / this.stats;
                    this.mbps = (float)(1.0E-6 * (double)this.map.bytes * (double)this.stats / Math.max(0.01, this.timer - this.timetop));
                    String smm = this.stats > 1 ? ",FMIN=" + this.pmin + ",FMAX=" + this.pmax : "";
                    this.M.info((CharSequence)("Sinkpic-" + this.dmac + " STATS={CYC=" + this.ocyc + ",LOST=" + this.lost + ",FAVG=" + this.pavg + smm + ",MBPS=" + this.mbps + "}"));
                    this.pmin = 100;
                    this.pmax = 0;
                    this.ptot = 0;
                    this.timetop = this.timer;
                }
            }
            if ((lostd = this.pic.dmaFunc(this.dmac, -10)) > this.lostc) {
                this.warning("Lost " + (lostd - this.lostc) + " card buffers");
                this.lostc = lostd;
            }
            if (this.rtfile > 1) {
                this.updateRTF();
            }
            if (this.replay == rCONTINUOUS) {
                this.todo = this.mtodo;
                return noop;
            }
            if (this.replay == rONESHOT) {
                this.pic.dmaFunc(this.dmac, -3);
                this.rcyc = 1;
            }
            if (this.stats > 0) {
                this.M.info((CharSequence)("Sinkpic-" + this.dmac + " STOP"));
            }
            this.pic.dmaFunc(this.dmac, 0);
            this.pic.dmaFunc(this.dmac, -8);
            this.dmamode = 0;
            if (this.slave != null) {
                this.setSlaveReplay(this.replay, this.dmamode);
            }
            if (this.replay == rFILE || this.replay == rFINISH) {
                return 9;
            }
            this.replay = this.replay == rRESTART ? rCONTINUOUS : rSTOPPED;
        }
        return 0;
    }

    public int close() {
        while (this.async) {
            this.doneReading = true;
            Time.sleep((double)0.1);
        }
        if (this.dmac > 0) {
            this.pic.dmaFunc(this.dmac, -9);
        }
        if (this.dmamode != 0 && this.stats > 0) {
            this.M.info((CharSequence)("Sinkpic-" + this.dmac + " CANCEL"));
        }
        if (this.hr != null) {
            this.hr.close();
        }
        if (this.ho != null) {
            this.ho.close();
        }
        if (this.hi != null) {
            this.hi.close();
        }
        if (this.omap != null) {
            this.omap.close(10);
        }
        if (this.map != null) {
            this.map.close();
        }
        if (this.pic != null) {
            this.pic.close();
        }
        this.replay = rSTOPPED;
        this.dmamode = 0;
        return 0;
    }

    private void warning(String text) {
        if (this.w2e) {
            this.M.error(text);
        } else {
            this.M.warning((CharSequence)text);
        }
    }

    private void openPorts() {
        this.dmac = this.pic.ioPort(this.ptype, this.port, -1, 1, this.bits, this.rate, this.fscale * this.freq, this.dec, this.gain, this.flags);
        if (this.dmac <= 0) {
            this.M.error("Problem setting up IO port");
        }
    }

    private boolean loadRamBuffer() {
        if (!(this.hi.io instanceof RamDiskResource)) {
            int tbytes = (int)(this.hr.size * this.hr.dbpe);
            long vaddr = this.map.getVirtualAddress(0L, tbytes);
            this.hi.read(vaddr, 0, tbytes);
        }
        this.icyc = 1;
        this.indx = 0L;
        return true;
    }

    public boolean readBuffer() {
        boolean isStream;
        boolean bl = isStream = this.rtfile == 1 || this.hi.isStream();
        long maxavail = this.rtfile == 1 ? this.availRTF() : (isStream ? this.hi.io.avail() : (long)((this.hi.size - this.hi.seek()) * this.hi.dbpe));
        int avail = (int)Math.min(0x40000000L, maxavail);
        int abytes = (int)Math.min((long)(this.archtl * this.bpa), this.map.bytes - this.indx);
        if (avail > 0) {
            abytes = Math.min(abytes, avail);
        } else if (!(isStream || this.archsf != 0 && this.openNextFile(false))) {
            if (this.wrap) {
                this.hi.seek(0.0);
            } else {
                this.doneReading = true;
            }
        }
        if (avail > 0 && avail < abytes) {
            abytes = avail;
        }
        if (this.icyc > this.rcyc - this.lost && this.indx + (long)abytes > this.rndx || this.icyc > this.ocyc && this.indx + (long)abytes > this.ondx) {
            avail = 0;
        }
        if (this.packet >= 0) {
            if (avail > 64) {
                this.hi.read(this.pkt.buf, 0, 64);
                avail = abytes = this.pkt.getBytes();
            }
        }
        if (avail >= abytes) {
            if (!this.inmem) {
                long vaddr = this.map.getVirtualAddress(this.indx, abytes);
                abytes = this.hi.read(vaddr, 0, abytes);
            }
            if (abytes > 0) {
                this.indx += (long)abytes;
                if (this.indx >= this.map.bytes) {
                    ++this.icyc;
                    this.indx = 0L;
                }
                if (this.wrap && !isStream && (long)abytes == maxavail && this.archsf == 0) {
                    this.hi.seek(0.0);
                }
            }
            return true;
        }
        return false;
    }

    private boolean openNextFile(boolean reload) {
        int index;
        String sfn;
        if (this.hi != null && this.hi.isOpen()) {
            this.hi.close();
        }
        if ((sfn = this.asfn.getSFN(index = reload ? this.asfn.getIndex() : this.asfn.nextIndex())) == null || sfn.equals("NULL") || sfn.equals("NONE")) {
            return false;
        }
        if (this.archsf < 0 && this.hi != null) {
            this.hi.setName((Object)sfn);
            if (!this.hi.find(-1)) {
                index = this.asfn.resetIndex();
                sfn = this.asfn.getSFN(index);
            }
        }
        if (this.stats != 0 && (this.archsf > 0 || this.asfn.isLegit())) {
            this.M.info((CharSequence)("Sinkpic-" + this.dmac + " ArchSF index=" + index + " fn=" + sfn));
        }
        this.hi = new DataFile((MidasReference)this, (Object)sfn, "", "", 0);
        this.hi.open(128);
        if (!this.hi.isOpen) {
            return false;
        }
        this.tcs = this.hi.getTime();
        if (this.tcmode != 0) {
            if (this.tcmode != 1 && !this.tcs.isZero()) {
                double dtc = (double)((long)this.icyc * this.map.bytes + this.indx) / this.hr.dbpe;
                this.pic.setKeyD(this.dmac, 9, this.tcs.getWSec(), this.tcs.getFSec(), dtc);
            }
        }
        this.hi.setDFS(0);
        return !this.asfn.isTop();
    }

    private void updateRTF() {
        long rbyte = this.map.bytes * (long)this.rcyc + this.rndx;
        this.hr.setOutByte(0, (double)rbyte);
        this.hr.ioh.write(this.hr.hb, 88, 8, 88L);
    }

    private long availRTF() {
        long ibyte = this.map.bytes * (long)this.icyc + this.indx;
        long inbyte = (long)this.hi.getInByte();
        long avail = inbyte - ibyte;
        if (this.throttle == tONDEMAND && this.prefill < 0.0) {
            avail -= this.bdelay;
        }
        if (avail < (long)(this.archtl * this.bpa)) {
            this.hi.ioh.read(this.hi.hb, 80, 8, 80L);
        }
        if (this.inmem) {
            this.updateRTF();
        }
        return avail;
    }

    @Override
    public void setReplay(String value) {
        int nreplay;
        if (value.equalsIgnoreCase("STOP")) {
            value = "STOPNOW";
        }
        if (value.equalsIgnoreCase("START")) {
            value = "CONTINUOUS";
        }
        if ((nreplay = Parser.find((String)replayList, (String)value, (int)this.replay, (int)replayListOffset)) > replayListOffset) {
            this.setReplay(nreplay);
        } else {
            this.warning("Illegal replay mode: " + value);
        }
    }

    private void setReplay(int nreplay) {
        if (nreplay == 0 && this.replay != 0) {
            this.replay = rSTOPNOW;
        } else if (nreplay == rRESTART && this.replay == 0) {
            this.replay = rCONTINUOUS;
        } else if (nreplay == rONESHOT && this.replay == rCONTINUOUS) {
            this.replay = rSTOPTOP;
        } else if (nreplay == rRECONNECT) {
            this.openPorts();
            this.replay = 0;
        } else {
            this.replay = nreplay;
        }
        if (this.replay == rSTOPNOW) {
            this.process();
        }
        if (this.replay >= rABORT && this.slave != null) {
            this.setSlaveReplay(this.replay, 0);
        }
        if (this.replay == rCONTINUOUS && this.nodma) {
            this.replay = rSPIN;
        }
    }

    private void setSlaveReplay(int value, int mode) {
        int smode;
        if (this.picSlave == null) {
            this.picSlave = (PicSlave)this.M.registry.get(this.slave);
        }
        if (this.picSlave == null) {
            this.warning("Slave=" + this.slave + " does not exist");
            return;
        }
        if (mode == 0 && value < rABORT) {
            value = rSTOPNOW;
        }
        if (this.nodma && value == rSPIN) {
            value = rCONTINUOUS;
        }
        this.picSlave.setReplay(this.getReplay(value));
        while ((smode = this.picSlave.getDmaMode()) != mode) {
            if (smode == -20) {
                if (mode == -2) break;
            }
            if (mode == -20) {
                if (smode == -2) break;
            }
            if (mode == -17) {
                if (smode == -2) break;
            }
            Time.sleep((double)this.pollTime);
        }
    }

    public void setMonitor(String value) {
        this.monitor = Parser.find((String)monitorList, (String)value, (int)this.monitor, (int)-1);
    }

    public void setChan(int chan) {
        this.pic.setKeyD(this.dmac, 16, chan);
    }

    public void setRate(int value) {
        this.rate = value;
        this.pic.setKeyL(this.dmac, 1, this.rate);
    }

    public void setFreq(double value) {
        this.freq = value;
        this.pic.setKeyD(this.dmac, 2, this.fscale * this.freq);
    }

    public void setDec(int value) {
        this.dec = value;
    }

    public void setGain(int value) {
        this.gain = value;
        this.pic.setKeyL(this.dmac, 4, this.gain);
    }

    public void setSkip(int value) {
        this.skip = value;
    }

    public void setStats(int value) {
        this.stats = value;
    }

    public String setSFName(String value) {
        if (value != null && value.length() > 0) {
            String fn;
            int i;
            if (value.startsWith("_") && (i = (fn = this.hi.getName().toString()).lastIndexOf(95)) > 0) {
                value = fn.substring(0, i) + value;
            }
            this.asfn.setFormat(value);
        }
        if (this.archsf < 0 && !this.asfn.isLegit()) {
            this.archsf = 0;
        }
        return value;
    }

    public void setArchTop(double top) {
        if (this.archsf != 0) {
            this.asfn.setTop(top);
            this.openNextFile(true);
        }
    }

    public void setArchDur(double dur) {
        if (this.archsf != 0) {
            this.asfn.setDur(dur);
        }
    }

    private String getReplay(int replay) {
        return Parser.get((String)replayList, (int)(replay - replayListOffset));
    }

    @Override
    public String getReplay() {
        return this.getReplay(this.replay);
    }

    public int getRate() {
        return this.rate;
    }

    public double getFreq() {
        return this.freq;
    }

    public int getDec() {
        return this.dec;
    }

    public int getGain() {
        return this.gain;
    }

    public int getSkip() {
        return this.skip;
    }

    public int getCycle() {
        return this.rcyc;
    }

    public long getIndex() {
        return this.rndx;
    }

    public double getProgress() {
        return this.doneReading ? (double)this.rndx / (double)this.map.bytes : this.hi.seek() / this.hi.size;
    }

    public String getMonitor() {
        return Parser.get((String)monitorList, (int)this.monitor, (int)-1);
    }

    public String getThrottle() {
        return Parser.get((String)throttleList, (int)this.throttle, (int)-1);
    }

    public DevIce.TimeCode getTimeCode() {
        return this.tc;
    }

    public Time getTime() {
        return this.time;
    }

    public int getHBLost() {
        return this.lost;
    }

    public int getCBLost() {
        return this.lostc;
    }

    public int getPFull() {
        return this.pavg;
    }

    public ArchSFN getASFN() {
        return this.asfn;
    }

    public ArchSFN getArchiver() {
        return this.asfn;
    }

    public double getArchDur() {
        return this.archsf != 0 ? this.asfn.getLength() : this.hi.getLength();
    }

    public double getArchOff() {
        return this.archsf != 0 ? this.asfn.getLengthTo(this.hi.getOffset()) : this.hi.getOffset() * this.hi.getDelta();
    }

    public double getArchTop() {
        return this.archsf != 0 ? this.asfn.getTimeTop() : this.hi.getTimeAt(0.0);
    }

    public String getSFName() {
        return this.asfn.getSFN();
    }

    @Override
    public int getDmaMode() {
        return this.dmamode;
    }

    public double getOffset() {
        return this.hi.getOffset();
    }

    public double getDelta() {
        return this.hi.getDelta();
    }

    public MDevIce getDevIce() {
        return this.pic;
    }

    public float getMBPS() {
        return this.mbps;
    }

    public String getArchFN() {
        if (this.archfn == null) {
            return null;
        }
        int i = this.archfn.indexOf(123);
        if (i > 0) {
            return this.archfn.substring(0, i);
        }
        return this.archfn;
    }

    public Table getTable(Table t) {
        return new Table(this.pic.getKeyTable(this.dmac, t.toString()));
    }

    private void setKeys(Table kt) {
        if (kt == null || kt.size() == 0) {
            return;
        }
        Table.Iterator ti = kt.iterator();
        while (ti.getNext()) {
            String sval;
            String string = sval = ti.value == null ? "QUERY" : ti.value.toString();
            if (sval.length() == 0 || sval.equals("QUERY")) {
                this.keys.put(ti.key, ti.value);
                continue;
            }
            this.setKey(ti.key, ti.value);
        }
    }

    public String[] getKeys() {
        return this.keys.getKeys();
    }

    public synchronized Object setKey(String key, Object value) {
        block8: {
            byte ityp;
            int ikey;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block7: {
                                            if (!key.equals("REPLAY")) break block7;
                                            this.setReplay(Convert.o2s((Object)value));
                                            break block8;
                                        }
                                        if (!key.equals("RATE")) break block9;
                                        this.setRate(Convert.o2l((Object)value));
                                        break block8;
                                    }
                                    if (!key.equals("FREQ")) break block10;
                                    this.setFreq(Convert.o2d((Object)value));
                                    break block8;
                                }
                                if (!key.equals("DEC")) break block11;
                                this.setDec(Convert.o2l((Object)value));
                                break block8;
                            }
                            if (!key.equals("GAIN")) break block12;
                            this.setGain(Convert.o2l((Object)value));
                            break block8;
                        }
                        if (!key.equals("TABLE")) break block13;
                        value = this.pic.setKeyTable(this.dmac, value.toString());
                        break block8;
                    }
                    ikey = this.pic.name2key(key);
                    if (ikey <= 0) {
                        return null;
                    }
                    ityp = this.pic.getKeyType(ikey);
                    if (ikey == 402) break block14;
                    if (ikey != 403) break block15;
                }
                value = new Integer(this.pic.str2ip(Convert.o2s((Object)value)));
            }
            if (ityp == 68) {
                this.pic.setKeyD(this.dmac, ikey, Convert.o2d((Object)value));
            } else {
                this.pic.setKeyL(this.dmac, ikey, Convert.o2l((Object)value));
            }
            if (ikey == 61) {
                this.hr.keywords.put("D:RFFREQ", (Object)this.pic.getKeyD(this.dmac, 61));
                this.hr.update();
            }
            this.keys.put(key, value);
        }
        return value;
    }

    public synchronized Object getKey(String key) {
        Object value = null;
        if (key.equals("REPLAY")) {
            value = this.getReplay();
        } else if (key.equals("RATE")) {
            value = Convert.l2o((int)this.getRate());
        } else if (key.equals("FREQ")) {
            value = Convert.d2o((double)this.getFreq());
        } else if (key.equals("DEC")) {
            value = Convert.l2o((int)this.getDec());
        } else if (key.equals("GAIN")) {
            value = Convert.l2o((int)this.getGain());
        } else {
            int ikey = this.pic.name2key(key);
            if (ikey <= 0) {
                return null;
            }
            byte ityp = this.pic.getKeyType(ikey);
            value = ityp == 68 ? Convert.d2o((double)this.pic.getKeyD(this.dmac, ikey)) : Convert.l2o((int)this.pic.getKeyL(this.dmac, ikey));
        }
        return value;
    }

    public class DeArchiver
    implements Runnable {
        @Override
        public void run() {
            while (!sinkpic.this.doneReading) {
                if (sinkpic.this.state == 2 && sinkpic.this.readBuffer()) continue;
                Time.sleep((double)0.01);
            }
            sinkpic.this.async = false;
        }
    }
}

