/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.ArchSFN;
import nxm.ice.lib.DevIce;
import nxm.ice.lib.ICEPacket;
import nxm.ice.lib.MDevIce;
import nxm.ice.lib.NetIO;
import nxm.ice.lib.SDDSPacket;
import nxm.ice.lib.VRTPacket;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PacketHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Native;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Time;

public class sinkice
extends Primitive {
    private Data data;
    private DataFile hi;
    private DataFile ho;
    private PacketHandler pkh;
    private ICEPacket opkh;
    private ICEPacket ipkh;
    private VRTPacket vpkh;
    private SDDSPacket spkh;
    private NetIO nio = new NetIO(true);
    private ArchSFN asfn;
    private DevIce.DmaMap map;
    private MDevIce pic;
    private boolean rt;
    private boolean wrap;
    private boolean skip;
    private boolean net;
    private boolean ram;
    private boolean inputIsICE;
    private boolean fromHdr;
    private boolean swap2;
    private boolean swap4;
    private boolean needContext;
    private double tdelta;
    private double tstart;
    private double dout;
    private double osize;
    private double maxout;
    private double outRTF;
    private double timeRTF;
    private double tcur;
    private double flush;
    private double tflush;
    private int sock = 0;
    private int sink;
    private int bxfer;
    private int hxfer;
    private int cxfer;
    private int pt;
    private int sid;
    private int archsf;
    private int preoff;
    private int tc;
    private int ctx;
    private long pdata = 0L;
    private long offset = 0L;
    private Time time;
    private String drep;
    private byte[] prenet;
    public static String ptList = "NONE,ICE,SDDS,VRT,VRTL,VRTW,VRTX,VRTD";
    public static int ICE = 1;
    public static int SDDS = 2;
    public static int VRT = 3;
    public static int VRTL = 4;
    public static int VRTW = 5;
    public static int VRTX = 6;
    public static int VRTD = 7;
    public static String pkthdrList = "Strip,Copy,Attach,Detach";
    public static int STRIP = 1;
    public static int COPY = 2;
    public static int ATTACH = 3;
    public static int DETACH = 4;
    public static String sinkList = "Net,File,RtFile,DevIce,PktFile,UdpFile,EthFile";
    public static int NET = 1;
    public static int FILE = 2;
    public static int RTFILE = 3;
    public static int DEVICE = 4;
    public static int PKTF = 5;
    public static int UDPF = 6;
    public static int ETHF = 7;
    public static String tcList = "Off,CPU";
    public static int TC_OFF = 1;
    public static int TC_CPU = 2;
    private int lossy;
    private int loss;
    private int lcnt;

    public int open() {
        this.sid = this.MA.getL("/SID", 0);
        this.lossy = this.MA.getL("/LOSSY");
        this.wrap = this.MA.getState("/WRAP");
        this.rt = this.MA.getState("/RT");
        this.archsf = this.MA.getL("/ARCHSF", 0);
        this.maxout = this.MA.getD("/MAXOUT");
        this.flush = this.MA.getD("/FLUSH");
        boolean isPipe = this.MA.getS("IN").startsWith("_");
        if (isPipe) {
            this.wrap = false;
            this.archsf = 0;
        }
        if (this.archsf != 0) {
            if (this.archsf == 1) {
                this.archsf = -1;
            }
            String fn = this.MA.getCS("IN");
            this.asfn = new ArchSFN((Object)this, fn, this.archsf);
            this.asfn.setTL(this.MA.getL("/ARCHTL", 262144));
            this.asfn.setTop(this.MA.getD("/ARCHTOP"));
            this.asfn.setDur(this.MA.getD("/ARCHDUR"));
            this.openNextFile(true);
            this.osize = this.MA.getD("/ARCHDUR") / this.hi.getXDelta();
            if (this.osize <= 0.0) {
                this.osize = this.hi.getSize();
            }
        } else {
            this.hi = this.MA.getDataFile("IN", "1000,2000", "S#,C#", 0);
            this.hi.open();
            this.osize = this.hi.getSize();
        }
        this.opkh = (ICEPacket)this.hi.getPacketHandler();
        this.fromHdr = this.inputIsICE = this.opkh != null;
        this.time = this.hi.getTime();
        if (this.time.getWSec() == 0.0) {
            this.time.fromCurrent();
        }
        double wsec = this.time.getWSec();
        double fsec = this.time.getFSec();
        this.pt = this.MA.getState("/SDDS") ? SDDS : ICE;
        this.pt = this.MA.getChoice("/PT", ptList, this.pt + 1) - 1;
        this.drep = this.MA.getS("/REP", this.hi.getDataRep());
        this.ho = this.MA.getDataFile("OUT", this.hi, 0);
        this.ho.setDataRep(this.drep);
        this.ram = this.ho.getURL().startsWith("ramd:");
        this.net = this.ho.getURL().startsWith("udp:");
        this.sink = this.MA.getSelectionIndex("/SINK", sinkList, this.net ? NET : FILE);
        this.bxfer = this.MA.getL("/PKTLEN", 1024);
        if (this.net) {
            this.bxfer = Math.min(this.bxfer, 8192);
        }
        this.xfer = this.MA.getL("/TL", (int)((double)this.bxfer / this.hi.dbpe));
        this.bxfer = (int)((double)this.xfer * this.hi.dbpe);
        this.ctx = this.MA.getL("CTX", 1);
        if (this.pt == ICE) {
            this.ipkh = new ICEPacket();
            this.pkh = this.ipkh;
            this.ipkh.setFormat(this.hi.getFormat());
            this.ipkh.setSize(this.xfer);
            this.ipkh.setTC(1, 1, 0.0, wsec, fsec);
            this.hxfer = 64;
        } else if (this.pt == SDDS) {
            this.spkh = new SDDSPacket();
            this.pkh = this.spkh;
            this.spkh.setFormat(this.hi.getFormat());
            this.spkh.setTC(1, 0.0, wsec, fsec);
            this.swap2 = this.hi.bps == 2;
            this.hxfer = 56;
            this.bxfer = 1024;
        } else if (this.pt >= VRT && this.pt <= VRTD) {
            this.vpkh = new VRTPacket(this.hi.getFormat(), this.MA.getS("/PT"));
            this.pkh = this.vpkh;
            this.vpkh.setSID(this.sid);
            this.vpkh.setBytes(this.bxfer);
            this.vpkh.setTC(wsec, fsec);
            this.hxfer = this.vpkh.getHeaderLength();
            int rate = (int)(1.0 / this.hi.getDelta());
            int freq = this.MA.getL("/FREQ", 0);
            int gain = this.MA.getL("/GAIN", 0);
            this.vpkh.createContextFor(this.ctx, rate, freq, gain);
            this.needContext = this.ctx > 0;
        }
        this.cxfer = this.bxfer;
        int bits = this.MA.getL("/BITS", 0);
        if (this.vpkh != null && bits > 0) {
            this.vpkh.setBits(bits);
            this.cxfer = this.bxfer / this.hi.bps * bits / 8;
            this.vpkh.setBytes(this.cxfer);
        }
        if (this.sink == NET) {
            this.sock = this.nio.nioOpen(this.ho.getURL(), 0, NetIO.OUTPUT | NetIO.UDP);
            if (this.sock <= 0) {
                this.M.error("Could not open ICE formatted network stream URL=" + this.ho.getURL());
            }
            this.pdata = this.nio.nioAlloc(this.bxfer + 64);
        } else if (this.sink >= PKTF) {
            this.genprenet();
            this.pdata = this.nio.nioAlloc(this.bxfer + 64);
            this.ho.setSize(this.osize);
            this.ho.open();
        } else if (this.sink == RTFILE && this.ram) {
            this.ho.open(3);
            this.osize = this.ho.getSize();
            this.ho.setOutput(false);
            this.pic = new MDevIce(this.MA, "ICEPIC,DEVNO=0,IOM=NONE,PM=NONE");
            if (this.pic.open() <= 0) {
                this.M.error("Problem opening PIC device");
            }
            this.map = this.pic.mapFile(this.ho);
            if (this.map == null) {
                this.M.error("Problem mapping DMA memory");
            }
        } else {
            this.ho.setSize(this.osize);
            if (this.pt == ICE && this.inputIsICE) {
                this.ipkh = this.opkh;
                this.pkh = this.ipkh;
            } else if (this.pt > 0) {
                this.ho.setPacketHandler(this.pkh);
            }
            this.ho.open();
        }
        this.data = this.hi.getDataBuffer(this.xfer);
        this.tdelta = this.hi.getDelta();
        this.dout = 0.0;
        this.tstart = 0.0;
        if (this.rt && this.tdelta >= 0.1) {
            this.M.warning((CharSequence)"Realtime with dt>0.1 ?");
        }
        this.tcur = Time.current();
        if (this.sink == RTFILE) {
            this.updateRTF(0);
        }
        return 0;
    }

    public int process() {
        if (this.rt || this.flush > 0.0) {
            this.tcur = Time.current();
        }
        if (this.rt) {
            if (this.tstart == 0.0 && this.hi.avail() < (double)this.xfer) {
                return -1;
            }
            if (this.tstart == 0.0) {
                this.tstart = this.tcur;
            }
            if (this.tcur < this.tstart + this.dout * this.tdelta) {
                return -1;
            }
        }
        if (this.needContext) {
            int npkt = this.vpkh.ctx2pkt(this.pdata);
            if (this.sink == NET) {
                this.nio.nioSend(this.sock, 0, this.pdata, npkt, 0);
            }
            if (this.sink == PKTF) {
                this.ho.write(this.pdata, 0, npkt);
            }
            this.needContext = false;
        }
        int n = this.hi.read(this.data);
        int bytes = (int)((double)n * this.ho.dbpe);
        if (n == this.xfer) {
            if (this.pt == ICE && this.fromHdr) {
                this.ipkh.setTC(this.opkh);
            }
            if (this.pt == ICE && !this.fromHdr) {
                this.ipkh.setTC(0, 0, 0.0, this.time.getWSec(), this.time.getFSec());
            }
            if (this.pt >= VRT && this.pt <= VRTD) {
                this.vpkh.setTC(this.time.getWSec(), this.time.getFSec());
            }
            if (this.swap2) {
                Convert.swap2((byte[])this.data.buf, (int)0, (int)(bytes >> 1));
            }
            if (this.lossy <= 0 || !this.simdrop()) {
                if (this.sink == NET) {
                    for (int i = 0; i < bytes; i += this.bxfer) {
                        if (this.pt == ICE) {
                            Native.ja2p((Object)this.ipkh.buf, (int)0, (long)this.pdata, (int)0, (int)this.hxfer);
                            Native.ja2p((Object)this.data.buf, (int)i, (long)this.pdata, (int)this.hxfer, (int)this.bxfer);
                            this.nio.nioSend(this.sock, 0, this.pdata, this.hxfer + this.bxfer, 0);
                            this.ipkh.upCount();
                            continue;
                        }
                        if (this.pt == SDDS) {
                            Native.ja2p((Object)this.spkh.buf, (int)8, (long)this.pdata, (int)0, (int)this.hxfer);
                            Native.ja2p((Object)this.data.buf, (int)i, (long)this.pdata, (int)this.hxfer, (int)this.bxfer);
                            this.nio.nioSend(this.sock, 0, this.pdata, this.hxfer + this.bxfer, 0);
                            this.spkh.upCount();
                            continue;
                        }
                        if (this.pt < VRT || this.pt > VRTD) continue;
                        int npkt = this.vpkh.buf2pkt(this.data.buf, i, this.pdata, this.bxfer);
                        this.nio.nioSend(this.sock, 0, this.pdata, npkt, 0);
                        this.vpkh.upCount();
                    }
                } else if (this.sink >= PKTF) {
                    for (int i = 0; i < bytes; i += this.bxfer) {
                        this.ho.write(this.prenet, this.preoff, 48 - this.preoff);
                        if (this.pt == ICE) {
                            this.ho.write(this.ipkh.buf, 0, this.hxfer);
                            this.ho.write(this.data.buf, i, this.bxfer);
                            this.ipkh.upCount();
                            continue;
                        }
                        if (this.pt == SDDS) {
                            this.ho.write(this.spkh.buf, 8, this.hxfer);
                            this.ho.write(this.data.buf, i, this.bxfer);
                            this.spkh.upCount();
                            continue;
                        }
                        if (this.pt < VRT || this.pt > VRTD) continue;
                        int npkt = this.vpkh.buf2pkt(this.data.buf, i, this.pdata, this.bxfer);
                        this.ho.write(this.pdata, 0, npkt);
                        this.vpkh.upCount();
                    }
                } else if (this.sink == RTFILE && this.ram) {
                    long vaddr = this.map.getVirtualAddress(this.offset, bytes);
                    Native.ja2p((Object)this.data.buf, (int)0, (long)vaddr, (int)0, (int)bytes);
                    this.offset += (long)bytes;
                    if (this.offset >= this.map.bytes) {
                        this.offset = 0L;
                    }
                } else {
                    this.ho.write(this.data);
                    if (this.sink == RTFILE) {
                        this.updateRTF(this.bxfer);
                    }
                }
            }
            if (this.sink != NET && this.sink < PKTF) {
                if (this.pt == ICE && !this.fromHdr) {
                    this.ipkh.upCount();
                }
                if (this.pt == SDDS) {
                    this.spkh.upCount();
                }
                if (this.pt == VRT) {
                    this.vpkh.upCount();
                }
            }
            if (this.maxout > 0.0 && this.ho.seek() >= this.maxout) {
                if (this.sink == RTFILE) {
                    this.ho.seek(0.0);
                } else {
                    return 9;
                }
            }
            this.time.addSec((double)this.xfer * this.tdelta);
            this.dout += (double)n;
        } else if (n > 0) {
            this.M.warning((CharSequence)("Partial packet of " + n + " elements not output"));
        } else {
            if (n == 0) {
                return -1;
            }
            if (this.archsf == 0 || !this.openNextFile(false)) {
                if (this.wrap && this.hi.isFile()) {
                    this.hi.seek(0.0);
                } else {
                    return 9;
                }
            }
        }
        if (this.flush > 0.0 && this.tcur - this.tflush > this.flush) {
            this.ho.flush();
            this.tflush = this.tcur;
        }
        return 0;
    }

    public int close() {
        if (this.net) {
            this.nio.nioClose(this.sock);
        }
        if (this.pdata != 0L) {
            this.nio.nioFree(this.pdata);
        }
        if (this.map != null) {
            this.map.close();
        }
        if (this.pic != null) {
            this.pic.close();
        }
        this.hi.close();
        this.ho.close();
        return 0;
    }

    private boolean simdrop() {
        if (this.lossy <= 0) {
            return false;
        }
        if (++this.lcnt > 100) {
            if (++this.loss > this.lossy) {
                this.loss = 1;
            }
            this.lcnt = 1;
        }
        return this.lcnt <= this.loss;
    }

    public void setArchTop(double top) {
        if (this.archsf != 0 && top >= 0.0) {
            this.asfn.setTop(top);
            this.openNextFile(true);
        }
    }

    public void setArchDur(double dur) {
        if (this.archsf != 0 && dur >= 0.0) {
            this.asfn.setDur(dur);
        }
    }

    private boolean openNextFile(boolean reload) {
        if (this.hi != null && this.hi.isOpen()) {
            this.hi.close();
        }
        int index = reload ? this.asfn.getIndex() : this.asfn.nextIndex();
        String sfn = this.asfn.getSFN(index);
        this.hi = new DataFile((MidasReference)this, (Object)sfn, "", "", 0);
        this.hi.open(128);
        if (!this.hi.isOpen) {
            return false;
        }
        return !this.asfn.isTop();
    }

    private void updateRTF(int bytes) {
        boolean init;
        boolean bl = init = bytes == 0;
        if (init) {
            this.timeRTF = this.tcur;
        } else if (this.tcur - this.timeRTF < 0.05) {
            return;
        }
        this.timeRTF = this.tcur;
        this.outRTF += (double)bytes;
        this.ho.setInByte(this.outRTF);
        if (init) {
            this.ho.setSize(this.maxout);
        }
        this.ho.update();
    }

    private void genprenet() {
        this.prenet = new byte[48];
        int srcport = this.MA.getL("/SRCPORT", 7000);
        int dstport = this.MA.getL("/DSTPORT", 7000);
        int srcaddr = this.MA.getL("/SRCADDR", -1062731775);
        int dstaddr = this.MA.getL("/DSTADDR", -536870911);
        int udplen = 8 + this.hxfer + this.cxfer;
        int udpchk = 0;
        int iplen = 20 + udplen;
        int ipchk = 0;
        long srcaddreth = 0x1CE000000000L | (long)srcaddr & 0xFFFFFFFFL;
        long dstaddreth = 0x1005E000000L | (long)dstaddr & 0x7FFFFFL;
        Convert.packX((byte[])this.prenet, (int)0, (long)0xD55555555555L);
        Convert.packX((byte[])this.prenet, (int)6, (long)(dstaddreth << 16), (byte)73);
        Convert.packX((byte[])this.prenet, (int)12, (long)(srcaddreth << 16), (byte)73);
        Convert.packI((byte[])this.prenet, (int)18, (short)8);
        Convert.packL((byte[])this.prenet, (int)20, (int)(0x45000000 | iplen), (byte)73);
        Convert.packL((byte[])this.prenet, (int)24, (int)32768, (byte)73);
        Convert.packL((byte[])this.prenet, (int)28, (int)(0x20110000 | ipchk), (byte)73);
        Convert.packL((byte[])this.prenet, (int)32, (int)srcaddr, (byte)73);
        Convert.packL((byte[])this.prenet, (int)36, (int)dstaddr, (byte)73);
        Convert.packL((byte[])this.prenet, (int)40, (int)(dstport << 16 | srcport), (byte)73);
        Convert.packL((byte[])this.prenet, (int)44, (int)(udplen << 16 | udpchk), (byte)73);
        this.preoff = this.sink == ETHF ? 0 : (this.sink == UDPF ? 40 : 48);
    }
}

