/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.ICEPacket;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Time;
import nxm.sys.libm.Add;
import nxm.sys.libm.Fft;
import nxm.sys.libm.Fill;
import nxm.sys.libm.Magnitude;
import nxm.sys.libm.Multiply;
import nxm.sys.libm.Noop;
import nxm.sys.libm.Scale;
import nxm.sys.libm.Window;

public class picmeasure
extends Primitive {
    private DataFile hi;
    private DataFile ho;
    private Data dbi;
    private Data dbo;
    private byte ftype;
    private int bpa;
    private int nchan;
    private int nfft;
    private int nfit;
    private int nffti;
    private int npkts;
    private ICEPacket pkt;
    private ChanData[] chns;
    private double tdelta;
    private double scale;
    private float[] fwin;
    private float[] fbuf;
    private float[] fbufa;
    private float[] fbufb;
    private float[] fbufi;
    private float[] fbufp;
    private Fft fftf;
    private Fft ffti;

    public int open() {
        this.hi = this.MA.getDataFile("IN");
        this.hi.open();
        this.tdelta = this.hi.getXDelta();
        this.bpa = this.hi.getBPA();
        this.ftype = this.hi.getFormatType();
        this.pkt = (ICEPacket)this.hi.getPacketHandler();
        if (this.pkt == null) {
            this.M.error("Input file is not packetized: " + this.hi.getTag());
        }
        this.ho = this.MA.getDataFile("OUT");
        this.ho.setSubRecords("CHAN|SI,STAT|SI,DIFF|SL,TIME|SD,TDIF|SD,SDIF|SD");
        this.ho.open(2 | 0x40);
        this.nchan = this.MA.getL("NCHAN");
        this.npkts = this.MA.getL("/NPKT", 5);
        this.nfft = this.MA.getL("/NFFT", 16384);
        this.nfit = this.MA.getL("/NFIT", 16384);
        this.nffti = this.MA.getL("/NFFTI", 131072);
        this.scale = 1.0 / (double)this.nfft;
        this.xfer = this.MA.getL("/TL", this.pkt.getFixedSize());
        this.dbi = this.hi.getDataBuffer(this.xfer);
        this.dbo = this.ho.getDataBuffer(1);
        this.chns = new ChanData[this.nchan];
        for (int i = 0; i < this.nchan; ++i) {
            this.chns[i] = new ChanData();
            this.chns[i].chan = (short)(i + 1);
            this.chns[i].clear();
        }
        this.fbuf = new float[this.nfft];
        this.fbufi = new float[this.nfft];
        this.fbufa = new float[this.nfft];
        this.fbufb = new float[this.nfft];
        this.fwin = Window.get((String)"HANN", (int)this.nfft, (double)this.scale);
        this.fftf = new Fft(this.nfft, 137);
        this.ffti = new Fft(this.nffti, 18);
        this.fbufp = new float[this.nffti * 2];
        return 0;
    }

    public int process() {
        int n = this.hi.read(this.dbi);
        if (n == 0) {
            return -1;
        }
        if (n < 0) {
            return 9;
        }
        int nc = this.pkt.getChannel();
        if (nc <= 0 || nc > this.nchan) {
            this.M.warning((CharSequence)("Channel " + nc + " out of range [1-" + this.nchan + "]"));
            return -1;
        }
        ChanData cd = this.chns[nc - 1];
        if (nc == 1 && cd.ipkts == this.npkts) {
            int i;
            this.MT.writeln((CharSequence)("At time " + cd.tc));
            for (i = 0; i < this.nchan; ++i) {
                ChanData ci = this.chns[i];
                if (ci.ipkts == 0) continue;
                this.measure(cd, ci);
                this.MT.writeln((CharSequence)ci.toString());
                ci.setDataBuffer(this.dbo);
                this.ho.write(this.dbo);
                n = 0;
                while (this.hi.isStream() && this.hi.avail() > 0.0) {
                    this.hi.read(this.dbi);
                    ++n;
                }
            }
            if (this.hi.isStream()) {
                Time.sleep((double)0.1);
                for (i = 0; i < this.nchan; ++i) {
                    this.chns[i].clear();
                }
            }
        } else {
            cd.addData(this.dbi, this.pkt, this.xfer);
        }
        return 0;
    }

    public int close() {
        this.fftf.free();
        this.ffti.free();
        this.hi.close();
        this.ho.close();
        return 0;
    }

    public int getChannels() {
        return this.nchan;
    }

    public void measure(ChanData ca, ChanData cb) {
        int ioff = 0;
        int ia = 0;
        int ib = 0;
        int nfft = 16384;
        cb.time = cb.tc.getSec();
        cb.tdif = cb.tc.diff(ca.tc);
        ioff = (int)Math.round(cb.tdif / this.tdelta);
        if (ioff > 0) {
            ia = ioff;
        } else {
            ib = -ioff;
        }
        cb.tdif -= (double)ioff * this.tdelta;
        if (Math.abs(cb.tdif) < 1.0E-12) {
            cb.tdif = 0.0;
        }
        int iover = Math.min(ca.ipkts * this.xfer - ia, cb.ipkts * this.xfer - ib);
        int navg = Math.max(0, iover / nfft);
        cb.sdif = 0.0;
        cb.difn = 0;
        cb.stat = (short)navg;
        cb.navg = navg;
        if (navg <= 0) {
            return;
        }
        Fill.S((float[])this.fbufi, (int)nfft, (double)0.0);
        for (int n = 0; n < navg; ++n) {
            Convert.bb2ja((byte[])ca.bbuf, (int)(n * nfft + ia), (byte)this.ftype, (Object)this.fbufa, (int)0, (byte)70, (int)nfft);
            Convert.bb2ja((byte[])cb.bbuf, (int)(n * nfft + ib), (byte)this.ftype, (Object)this.fbufb, (int)0, (byte)70, (int)nfft);
            Multiply.SSS((float[])this.fbufa, (float[])this.fwin, (float[])this.fbufa, (int)nfft);
            Multiply.SSS((float[])this.fbufb, (float[])this.fwin, (float[])this.fbufb, (int)nfft);
            this.fftf.work((Object)this.fbufa);
            this.fftf.work((Object)this.fbufb);
            Multiply.GCC((float[])this.fbufa, (float[])this.fbufb, (float[])this.fbuf, (int)(nfft / 2));
            Add.SSS((float[])this.fbufi, (float[])this.fbuf, (float[])this.fbufi, (int)nfft);
        }
        if (navg > 1) {
            double rnavg = 1.0 / (double)navg;
            Scale.SS((float[])this.fbufi, (float[])this.fbufi, (int)nfft, (double)rnavg);
        }
        Fill.C((float[])this.fbufp, (int)this.nffti, (double)0.0);
        Noop.CC((float[])this.fbufi, (float[])this.fbufp, (int)(nfft / 2));
        this.ffti.work((Object)this.fbufp);
        Magnitude.CS((float[])this.fbufp, (float[])this.fbufp, (int)this.nffti);
        int imax = 0;
        float fmax = this.fbufp[0];
        for (int i = 1; i < this.nffti; ++i) {
            if (!(this.fbufp[i] > fmax)) continue;
            imax = i;
            fmax = this.fbufp[i];
        }
        if (imax >= this.nffti / 2) {
            imax -= this.nffti;
        }
        double a0 = Math.sqrt(this.fbufp[(imax - 1 + this.nffti) % this.nffti]);
        double a1 = Math.sqrt(this.fbufp[(imax + 0 + this.nffti) % this.nffti]);
        double a2 = Math.sqrt(this.fbufp[(imax + 1 + this.nffti) % this.nffti]);
        double x = a2 + a0 - 2.0 * a1;
        if (Math.abs(x) < 1.0E-20) {
            x = 1.0E-20;
        }
        x = ((double)imax - (a2 - a0) / (2.0 * x)) * (double)nfft / (double)this.nffti;
        cb.sdif = x * this.tdelta;
        cb.difn = (int)((cb.sdif + cb.tdif) * 1.0E9);
    }

    private class ChanData {
        int ipkts;
        short chan;
        short stat;
        int difn;
        int navg;
        int count;
        double time;
        double tdif;
        double sdif;
        double delta;
        Time tc;
        byte[] bbuf;

        private ChanData() {
            this.delta = picmeasure.this.tdelta;
            this.tc = new Time();
            this.bbuf = new byte[picmeasure.this.xfer * picmeasure.this.npkts * picmeasure.this.bpa];
        }

        public void setDataBuffer(Data db) {
            Convert.packI((byte[])db.buf, (int)0, (short)this.chan);
            Convert.packI((byte[])db.buf, (int)2, (short)this.stat);
            Convert.packL((byte[])db.buf, (int)4, (int)this.difn);
            Convert.packD((byte[])db.buf, (int)8, (double)this.time);
            Convert.packD((byte[])db.buf, (int)16, (double)this.tdif);
            Convert.packD((byte[])db.buf, (int)24, (double)this.sdif);
        }

        public int addData(Data db, ICEPacket pkt, int xfer) {
            int pcount = pkt.getCount();
            if (this.ipkts > 0 && ++this.count != pcount) {
                this.ipkts = 0;
            }
            if (this.ipkts < picmeasure.this.npkts) {
                int status;
                System.arraycopy(db.buf, 0, this.bbuf, this.ipkts * xfer * picmeasure.this.bpa, xfer * picmeasure.this.bpa);
                if (this.ipkts == 0 && (status = pkt.getTC(this.tc, 0.0, picmeasure.this.tdelta)) < 0) {
                    picmeasure.this.M.warning((CharSequence)("Bad TimeCode status: " + status));
                }
                ++this.ipkts;
            }
            this.count = pcount;
            return this.ipkts;
        }

        public void clear() {
            this.ipkts = 0;
            this.time = 0.0;
            this.tdif = 0.0;
        }

        public String toString() {
            return "Chan " + this.chan + " Pkts " + this.ipkts + " NAvg " + this.navg + " Diff " + this.difn;
        }
    }
}

