/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.ICEPacket;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;

public class picfanout
extends Primitive {
    private DataFile hi;
    private DataFile[] ho;
    private Data data;
    private boolean strip;
    private int nchan;
    private ICEPacket pkt;
    private byte[] buffer;
    private int maxbytes;
    private int index = 1;

    public int open() {
        this.hi = this.MA.getDataFile("IN");
        this.hi.open();
        this.pkt = (ICEPacket)this.hi.getPacketHandler();
        if (this.pkt == null) {
            this.M.error("Input file is not packetized: " + this.hi.getTag());
        }
        String root = this.MA.getCS("OUT");
        this.nchan = this.MA.getL("NCHAN");
        this.ho = new DataFile[this.nchan];
        this.strip = this.MA.getState("/STRIP", false);
        this.index = this.MA.getL("/INDEX", this.index);
        for (int nc = 0; nc < this.nchan; ++nc) {
            this.ho[nc] = new DataFile();
            this.ho[nc].init((MidasReference)this, (Object)(root + (nc + this.index)), this.hi, 0);
            if (this.strip) {
                this.ho[nc].setPacketHandler(null);
            }
            this.ho[nc].open();
        }
        this.maxbytes = this.hi.bpa * this.MA.getL("/TL", this.pkt.getFixedSize());
        this.buffer = new byte[this.maxbytes];
        return 0;
    }

    public int process() {
        int n = this.hi.read(this.buffer, 0, this.maxbytes);
        if (n == 0) {
            return -1;
        }
        if (n < 0) {
            return 9;
        }
        int nc = this.pkt.getChannel();
        if (nc <= 0 || nc > this.nchan) {
            return 0;
        }
        this.ho[--nc].write(this.buffer, 0, n);
        return 0;
    }

    public int close() {
        this.hi.close();
        for (int nc = 0; nc < this.nchan; ++nc) {
            this.ho[nc].close();
        }
        return 0;
    }

    public int getChannels() {
        return this.nchan;
    }
}

