/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.Archiver;
import nxm.ice.lib.ICEPacket;
import nxm.ice.prim.sourcepic;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PacketHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.StringUtil;

public class picfanin
extends Primitive {
    private DataFile hi;
    private DataFile[] his;
    private DataFile ho;
    private int nchan;
    private int ichan;
    private int lchan;
    private int xferp;
    private int select;
    private int cper;
    private int skip;
    private int[] iskp;
    private ICEPacket pkt;
    private Data db;
    private boolean renumo;
    private boolean renumi;
    private boolean swap;
    private boolean strip;
    private boolean hasip;
    private Archiver ha;

    public int open() {
        this.nchan = this.MA.getL("NCHAN");
        this.skip = this.MA.getL("/SKIP", 0);
        this.swap = this.MA.getState("/SWAP");
        this.strip = this.MA.getState("/STRIP");
        this.renumo = this.MA.getState("/RENUM");
        this.renumi = this.MA.getState("/RENUMI");
        this.select = this.MA.getL("/SELECT", -1);
        String root = this.MA.getCS("IN");
        this.his = new DataFile[this.nchan];
        this.iskp = new int[this.nchan];
        for (int nc = 0; nc < this.nchan; ++nc) {
            this.hi = new DataFile();
            this.hi.init((MidasReference)this, (Object)(root + (nc + 1)), "1000,2000", "S#,C#", 0);
            this.hi.open();
            this.his[nc] = this.hi;
            this.iskp[nc] = 0;
        }
        this.hi = this.his[0];
        this.pkt = (ICEPacket)this.hi.getPacketHandler();
        this.hasip = this.pkt != null;
        this.ho = this.MA.getDataFile("OUT", this.hi, 0);
        if (!this.hasip) {
            this.xfer = this.MA.getL("/TL", (int)(4096.0 / this.hi.dbpe));
            this.pkt = new ICEPacket(this.hi.getFormat(), this.xfer, 2);
            this.ho.setPacketHandler((PacketHandler)this.pkt);
        }
        if (this.strip) {
            this.ho.setPacketHandler(null);
        }
        this.ho.open(2);
        if (!this.strip) {
            this.pkt = (ICEPacket)this.ho.getPacketHandler();
        }
        if (this.pkt == null) {
            this.M.error("Could not packetize output file");
        }
        this.startArchiver();
        this.xfer = this.MA.getL("/TL", this.pkt.getFixedSize());
        if (this.ho.getTypeCodeClass() == 2) {
            this.xfer = 1;
        }
        this.db = this.ho.getDataBuffer(this.xfer);
        this.ichan = this.nchan - 1;
        return 0;
    }

    public int process() {
        block12: {
            int lchan = this.ichan;
            do {
                ++this.ichan;
                this.ichan %= this.nchan;
                this.hi = this.his[this.ichan];
                if (this.hi.avail() >= (double)this.xfer) break block12;
            } while (this.ichan != lchan);
            return -1;
        }
        int n = this.hi.read(this.db);
        if (n == 0) {
            return -1;
        }
        if (n < 0) {
            return 9;
        }
        if (this.hasip) {
            this.pkt.copyFrom((ICEPacket)this.hi.getPacketHandler());
        }
        int cn = this.ichan + 1;
        if (this.renumi) {
            cn += (this.pkt.getChannel() - 1) * this.nchan;
        }
        if (this.renumo) {
            this.pkt.setChannel(cn);
        }
        if (this.select >= 0 && this.select != cn) {
            return 0;
        }
        if (this.ha != null) {
            this.ha.setPktHeader((ICEPacket)this.hi.getPacketHandler());
            this.ha.write(0L, this.db.buf, 0, n * this.ha.bpa, this.ichan);
        }
        if (this.skip > 0) {
            int n2 = this.ichan;
            this.iskp[n2] = this.iskp[n2] - 1;
            if (this.iskp[n2] <= 0) {
                this.iskp[this.ichan] = this.skip;
            } else {
                return 0;
            }
        }
        if (this.swap) {
            Convert.swap2((byte[])this.db.buf, (int)0, (int)(this.db.buf.length >> 1));
        }
        this.ho.write(this.db);
        return 0;
    }

    public int close() {
        for (int nc = 0; nc < this.nchan; ++nc) {
            this.his[nc].close();
        }
        this.ho.close();
        if (this.ha != null) {
            this.ha.close();
        }
        return 0;
    }

    public int getChannels() {
        return this.nchan;
    }

    public int getSelect() {
        return this.select;
    }

    public void setSelect(int chan) {
        this.select = chan;
    }

    private void startArchiver() {
        String fname = this.MA.getS("/ARCH");
        if (StringUtil.isNullOrEmpty((Object)fname)) {
            return;
        }
        sourcepic sp = (sourcepic)this.MA.getO("/SP");
        ICEPacket apkt = new ICEPacket(this.ho.getFormat(), this.pkt.getSize(), 0);
        this.ha = new Archiver(sp);
        this.ha.init((MidasReference)sp, fname, this.ho, 0);
        this.ha.setPacketHandler(apkt);
        this.ha.setNChan(this.nchan);
        this.ha.setFS(0);
        this.ha.open(0x80 | 0x40);
        if (!this.ha.isOpen) {
            this.ha = null;
        }
    }
}

