/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.dsp.lib.FilterFIR;
import nxm.dsp.prim.firkais;
import nxm.ice.lib.FileIO;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Time;
import nxm.sys.libm.Add;
import nxm.sys.libm.Fft;
import nxm.sys.libm.Multiply;
import nxm.sys.libm.Waveform;

public final class icewave
extends Primitive {
    private int shape;
    private int throttle;
    private int cur = 0;
    private int tcur = 0;
    private int olut = 0;
    private int nlut = 0;
    private int hlut = 0;
    private int mode;
    private int wmode;
    private int spb = 1;
    private int lrs;
    private int lrsx;
    private int lrsy;
    private int seed = 123456;
    private int seedx = 123456;
    private int seedy = 654321;
    private int lrsp;
    private int ntap = 0;
    private int nfft = 0;
    private int fb = 0;
    private int nbins = 0;
    private int nrpt;
    private int nper;
    private int mper;
    private int ndone = 0;
    private int ovsr = 1;
    private int itag = 0;
    private double size;
    private double amp;
    private double freq;
    private double dfreq;
    private double freq1;
    private double freq2;
    private double chirp;
    private double poff;
    private double var;
    private double sdev;
    private double delta;
    private double tstart;
    private double rate;
    private double gain;
    private double baud;
    private double phase;
    private double phase1;
    private double phase2;
    private double timer;
    private double sweep = 0.0;
    private String form;
    private DataFile ho;
    private DataFile hf;
    private float[] tbuf;
    private float[] rtap;
    private byte[] bbuf;
    private boolean wrap;
    private boolean filter;
    private boolean lut;
    private boolean dfs;
    private boolean stats;
    private boolean iqoff;
    private boolean fsk;
    private boolean fram;
    private boolean scrambler;
    private byte type;
    private float midx = 1.0f;
    private float stag;
    static final byte _JINT = 74;
    static final int LRSPM = 0x2000023;
    public static final String shapeList = "Sine,Cosine,Square,Triangle,SawTooth,Pulse,Constant,Zero,White,LRS,Ramp,TRamp,Notch,TwoTone,MixLS,MuxLS,MixNS,NFloor,CW,FSK,4FSK,BPSK,QPSK,OQPSK,1P4QPSK,3P4QPSK,8PSK,16PSK,16APSK,32APSK,64APSK,8QAM,16QAM,32QAM,64QAM,128QAM,256QAM,512QAM,1024QAM";
    public static final int SIN = 1;
    public static final int COS = 2;
    public static final int SQU = 3;
    public static final int TRI = 4;
    public static final int SAW = 5;
    public static final int PUL = 6;
    public static final int CON = 7;
    public static final int ZER = 8;
    public static final int WHI = 9;
    public static final int LRS = 10;
    public static final int RAMP = 11;
    public static final int TRAM = 12;
    public static final int NOTCH = 13;
    public static final int TTONE = 14;
    public static final int MIXLS = 15;
    public static final int MUXLS = 16;
    public static final int MIXNS = 17;
    public static final int NFLR = 18;
    public static final int CW = 19;
    public static final int FSK = 20;
    public static final int FSK4 = 21;
    public static final int BPSK = 22;
    public static final int QPSK = 23;
    public static final int OQPSK = 24;
    public static final int QPSK14 = 25;
    public static final int QPSK34 = 26;
    public static final int PSK8 = 27;
    public static final int PSK16 = 28;
    public static final int APSK16 = 29;
    public static final int APSK32 = 30;
    public static final int APSK64 = 31;
    public static final int QAM8 = 32;
    public static final int QAM16 = 33;
    public static final int QAM32 = 34;
    public static final int QAM64 = 35;
    public static final int QAM128 = 36;
    public static final int QAM256 = 37;
    public static final int QAM512 = 38;
    public static final int QAM1024 = 39;
    public static final String throttleList = "RealTime,Full,Block";
    private static final int REALTIME = 1;
    private static final int FULL = 2;
    private static final int BLOCK = 3;
    private Fft fft;
    private Fft ifft;
    private float[] filt;
    private float[] save;
    private float[] loop;
    private float[] work;
    private long iloop;
    private long qloop;
    float[] ilut;
    float[] qlut;
    float[] idat;
    float[] qdat;
    float[] idat0;
    float[] qdat0;
    static final int MLUT = 1024;
    int[] scram;
    int[] lrsbuf;
    int nr = 0;
    int n;
    float sar = 0.0f;
    float[] rings;
    int iscram;
    static final int NSCRAM = 1024;
    static final int MSCRAM = 1023;
    float fskp = 0.0f;

    public int open() {
        this.shape = this.MA.getChoice("SHAPE", shapeList, 0);
        this.form = this.MA.getFormat("FORM", "S#,C#");
        this.size = this.MA.getD("ELEM");
        this.rate = this.MA.getD("RATE");
        this.gain = this.MA.getD("GAIN");
        if (this.shape == 25 || this.shape == 26) {
            this.shape = 27;
        }
        if (this.shape == 9) {
            this.gain -= 6.0;
        }
        if (this.shape == 10 || this.shape == 13 || this.shape == 17) {
            this.gain -= 3.0;
        }
        if (this.shape == 13 || this.shape == 17) {
            this.filter = true;
            this.gain -= 1.0;
        }
        if (this.shape >= 20) {
            this.lut = true;
            this.gain -= 3.0;
        }
        if (this.shape >= 22) {
            this.gain -= 3.0;
        }
        if (this.shape == 14) {
            this.dfs = true;
        }
        if (this.shape == 24) {
            this.spb = 2;
            this.iqoff = true;
        }
        this.freq = this.MA.getD("FREQ", this.lut ? 0.0 : this.rate / 10.0);
        this.baud = this.MA.getD("BAUD", this.lut ? this.rate / 4.0 : 0.0);
        this.type = (byte)this.form.charAt(1);
        this.fsk = this.shape == 20 || this.shape == 21;
        boolean bl = this.fram = this.shape == 11 && this.type == 76;
        this.amp = this.type == 76 ? 2.0E9 : (this.type == 73 || this.type == 74 ? 30720.0 : (this.type == 66 ? 120.0 : (this.type == 78 ? 7.0 : 1.0)));
        this.amp = this.MA.getD("/AMP", this.amp);
        this.amp *= Math.pow(2.0, this.gain / 6.0);
        int n = this.ntap = this.shape >= 38 ? 11 : 7;
        this.ntap = this.lut ? this.ntap : (this.filter ? 512 : 0);
        this.poff = this.MA.getD("/PHASE", 0.0);
        this.chirp = this.MA.getD("/CHIRP", 0.0);
        this.var = this.MA.getD("/VARIANCE", Math.pow(this.amp / 2.3025850929940455, 2.0));
        this.sdev = this.MA.getD("/SDEV", Math.sqrt(this.var));
        this.dfreq = this.MA.getD("/DFREQ", this.baud > 0.0 ? this.baud : this.rate / 50.0);
        this.ntap = this.MA.getL("/NTAP", this.ntap);
        this.nrpt = this.MA.getL("/NRPT", 16384);
        this.lrsp = this.MA.getL("/LRSP", 0);
        this.fb = this.MA.getL("/FB", 0);
        this.midx = this.MA.getF("/MIDX", this.midx);
        this.ovsr = this.MA.getL("/OVSR", this.ovsr);
        this.stag = this.MA.getF("/STAG");
        this.itag = this.MA.getL("/STAGOFF", 0);
        this.delta = 1.0 / this.rate;
        this.freq1 = this.freq - this.dfreq;
        this.freq2 = this.freq + this.dfreq;
        if (this.lut) {
            this.freq1 = this.baud;
        }
        this.hf = this.MA.getDataFile("/FIR", "1000", "SF", 0);
        this.hf.open(64);
        if (this.hf.isOpen) {
            this.ntap = (int)this.hf.getSize();
            Data db = this.hf.getDataBuffer(this.ntap, (byte)70);
            this.hf.read(db);
            this.hf.close();
            this.rtap = new float[this.ntap];
            db.toArray((Object)this.rtap);
            if (this.lut) {
                this.ntap /= this.nrpt;
            }
        } else if (this.lut) {
            double fw = this.MA.getD("/FWIDTH", 1.0);
            if (this.fsk) {
                this.ntap = 256;
                this.nrpt = 1;
                this.filter = true;
                fw *= 2.0 * this.baud * (double)this.midx / this.rate;
                if (this.shape == 21) {
                    fw *= 2.0;
                }
            }
            int n2 = this.ntap * this.nrpt;
            this.rtap = new float[n2 + 1];
            float[] ctap = new float[n2 * 2];
            if (this.fsk) {
                firkais.generate((int)1, (double)fw, (double)0.0, (double)(fw / 20.0), (double)80.0, (float[])ctap, (int)n2, (boolean)false);
            } else {
                firkais.generate((int)1, (double)(fw / (double)this.nrpt / (double)this.ovsr), (double)0.0, (double)(0.05 / (double)this.nrpt), (double)80.0, (float[])ctap, (int)n2, (boolean)false);
            }
            for (int i = 0; i < n2; ++i) {
                this.rtap[i] = ctap[i + i] * (float)this.nrpt;
            }
            this.rtap[n2] = this.rtap[0];
        }
        this.ho = this.MA.getDataFile("OUT", "1000", "SF", 0);
        this.ho.setFormat(this.form);
        this.ho.setXDelta(this.delta);
        this.ho.setXUnits(1);
        this.ho.setSize(this.size);
        this.ho.open(130);
        this.throttle = this.MA.getState("/RT") ? 1 : 2;
        this.throttle = this.MA.getChoice("/THROTTLE", throttleList, this.throttle);
        if (this.throttle == 1) {
            this.ho.setTimeAt(Time.current());
        }
        this.wrap = this.MA.getState("/WRAP");
        if (this.wrap) {
            double len = this.size * this.delta;
            this.freq = (double)Math.round(this.freq * len) / len;
            this.freq1 = (double)Math.round(this.freq1 * len) / len;
            this.freq2 = (double)Math.round(this.freq2 * len) / len;
        }
        this.mode = this.ho.spa;
        this.wmode = this.shape >= 20 ? 2 : this.mode;
        this.xfer = (int)(8192.0 / this.ho.dbpe);
        this.nbins = this.xfer = this.MA.getL("/TL", this.xfer);
        if (this.filter) {
            this.nfft = this.xfer;
            this.xfer -= this.ntap;
            this.filterPrep(this.fsk ? this.rtap : this.getNotchFilter());
        }
        int nbuf = 4 * Math.max(this.xfer * this.wmode, this.nbins * 2);
        byte[] byArray = this.bbuf = this.fb > 0 ? FileIO.allocBuffer(nbuf) : new byte[nbuf];
        if (this.fb > 1) {
            this.ho.seek(this.size);
            this.ho.seek(0.0);
        }
        this.todo(this.size);
        this.seed = this.MA.getL("/SEED", this.seed);
        Waveform.setSeed((int)this.seed);
        this.lrs = ~this.seed;
        this.lrsx = ~this.seedx;
        this.lrsy = ~this.seedy;
        this.tbuf = new float[this.xfer * this.wmode];
        if (this.lut) {
            this.preplut();
        }
        this.stats = this.MA.getState("/STATS");
        this.timer = Time.current();
        return 0;
    }

    public int process() {
        int ndo;
        double p1 = 0.0;
        double dp1 = 0.0;
        double p2 = 0.0;
        double dp2 = 0.0;
        if (this.throttle > 0) {
            if (this.throttle == 1) {
                if (this.tstart == 0.0) {
                    this.tstart = Time.current() - this.ho.seek() * this.delta;
                }
                if (Time.current() < this.tstart + this.ho.seek() * this.delta) {
                    return -1;
                }
            } else {
                this.tstart = 0.0;
            }
            if (this.throttle == 3) {
                return -1;
            }
        }
        if ((ndo = this.todo()) == 0) {
            return 9;
        }
        if (this.fram) {
            int[] lbuf = Native.castL((byte[])this.bbuf);
            this.cur = this.fastramp(lbuf, this.type, ndo, this.mode, this.cur);
            Native.uncastL((Object)lbuf);
            this.ho.write(this.bbuf, 0, (int)((double)ndo * this.ho.dbpe));
            if (this.fb == 2) {
                this.fb = 3;
            }
            return 0;
        }
        if (this.fb > 2) {
            this.ho.write(this.bbuf, 0, (int)((double)ndo * this.ho.dbpe));
            return 0;
        }
        if (this.fb == 2) {
            this.fb = 3;
        }
        double p = this.phase + this.poff;
        double dp = this.freq * this.delta;
        if (this.mode == 1 && this.wmode == 2) {
            dp += 0.25;
        }
        if (this.poff != 0.0) {
            p -= Math.floor(p);
        }
        if (dp < 0.0 && this.shape != 1 && this.shape != 2 && this.shape != 19 && !this.lut) {
            dp = -dp;
        }
        if (this.shape == 19) {
            dp += this.sweep * this.baud * this.delta;
            this.sweep += (double)((float)ndo * this.midx) * this.delta;
            if (this.sweep > 0.5) {
                this.sweep -= 1.0;
            }
        }
        if (this.dfs || this.lut) {
            p1 = this.phase1 + this.poff;
            dp1 = this.freq1 * this.delta;
            p2 = this.phase2 + this.poff;
            dp2 = this.freq2 * this.delta;
        }
        float[] fbuf = Native.castF((byte[])this.bbuf);
        if (this.shape == 16 && this.mode == 1) {
            this.shape = 15;
        }
        switch (this.shape) {
            case 0: {
                break;
            }
            case 1: 
            case 19: {
                Waveform.sincos((float[])fbuf, (double)this.amp, (double)p, (double)dp, (int)ndo, (int)this.mode);
                break;
            }
            case 2: {
                Waveform.sincos((float[])fbuf, (double)this.amp, (double)(p + 0.25), (double)dp, (int)ndo, (int)this.mode);
                break;
            }
            case 3: {
                Waveform.square((float[])fbuf, (double)this.amp, (double)p, (double)dp, (int)ndo, (int)this.mode);
                break;
            }
            case 4: {
                Waveform.triangle((float[])fbuf, (double)this.amp, (double)p, (double)dp, (int)ndo, (int)this.mode);
                break;
            }
            case 5: {
                Waveform.sawtooth((float[])fbuf, (double)this.amp, (double)p, (double)dp, (int)ndo, (int)this.mode);
                break;
            }
            case 6: {
                Waveform.pulse((float[])fbuf, (double)this.amp, (double)p, (double)dp, (int)ndo, (int)this.mode);
                break;
            }
            case 7: {
                Waveform.constant((float[])fbuf, (double)this.amp, (int)ndo, (int)this.mode);
                break;
            }
            case 8: {
                Waveform.constant((float[])fbuf, (double)0.0, (int)ndo, (int)this.mode);
                break;
            }
            case 9: {
                Waveform.whitenoise((float[])fbuf, (double)this.sdev, (int)ndo, (int)this.mode);
                break;
            }
            case 10: {
                this.lrs = Waveform.lrs((float[])fbuf, (double)this.amp, (int)ndo, (int)this.mode, (int)this.lrs);
                break;
            }
            case 11: {
                this.cur = Waveform.ramp((float[])fbuf, (double)this.amp, (int)ndo, (int)this.mode, (int)this.cur);
                break;
            }
            case 12: {
                this.tcur = this.testramp(fbuf, this.type, ndo, this.mode, this.tcur);
                break;
            }
            case 18: {
                this.lrs(fbuf, this.amp, ndo, this.mode);
                this.rotate(fbuf, ndo, this.mode);
                break;
            }
            case 13: {
                this.lrs = Waveform.lrs((float[])fbuf, (double)this.amp, (int)ndo, (int)this.mode, (int)this.lrs);
                this.rotate(fbuf, ndo, this.mode);
                this.filter(fbuf, ndo, this.mode);
                break;
            }
            case 14: {
                Waveform.sincos((float[])fbuf, (double)(this.amp / 2.0), (double)p1, (double)dp1, (int)ndo, (int)this.mode);
                Waveform.sincos((float[])this.tbuf, (double)(this.amp / 2.0), (double)p2, (double)dp2, (int)ndo, (int)this.mode);
                Add.SSS((float[])fbuf, (float[])this.tbuf, (float[])fbuf, (int)(ndo * this.mode));
                break;
            }
            case 15: {
                this.lrs = Waveform.lrs((float[])fbuf, (double)(this.amp / 2.0), (int)ndo, (int)this.mode, (int)this.lrs);
                this.rotate(fbuf, ndo, this.mode);
                Waveform.sincos((float[])this.tbuf, (double)(this.amp / 2.0), (double)p, (double)dp, (int)ndo, (int)this.mode);
                Add.SSS((float[])fbuf, (float[])this.tbuf, (float[])fbuf, (int)(ndo * this.mode));
                break;
            }
            case 16: {
                this.lrs = Waveform.lrs((float[])fbuf, (double)this.amp, (int)ndo, (int)1, (int)this.lrs);
                Waveform.sincos((float[])this.tbuf, (double)this.amp, (double)p, (double)dp, (int)ndo, (int)1);
                this.mux(fbuf, this.tbuf, ndo);
                this.rotate(fbuf, ndo, this.mode);
                break;
            }
            case 17: {
                this.lrs = Waveform.lrs((float[])fbuf, (double)(this.amp * 15.0 / 16.0), (int)ndo, (int)this.mode, (int)this.lrs);
                this.rotate(fbuf, ndo, this.mode);
                this.filter(fbuf, ndo, this.mode);
                Waveform.sincos((float[])this.tbuf, (double)(this.amp * 1.0 / 16.0), (double)p, (double)dp, (int)ndo, (int)this.mode);
                Add.SSS((float[])fbuf, (float[])this.tbuf, (float[])fbuf, (int)(ndo * this.mode));
                break;
            }
            default: {
                if (this.fsk) {
                    this.resfsk(fbuf, p1, dp1, ndo);
                } else {
                    this.reslut(fbuf, p1, dp1, ndo);
                }
                if (this.fsk) {
                    this.filter(fbuf, ndo, this.wmode);
                }
                if (dp != 0.0) {
                    this.rotlut(fbuf, p, dp, ndo);
                }
                if (this.mode != 1) break;
                this.cx2r(fbuf, ndo);
            }
        }
        if ((double)this.stag >= 0.0) {
            for (int i = this.itag * this.mode; i < ndo * this.mode; ++i) {
                fbuf[i] = fbuf[i] * this.stag;
            }
            this.stag = -1.0f;
        }
        Native.uncastF((Object)fbuf);
        if (this.type != 70) {
            Convert.type((byte[])this.bbuf, (int)0, (byte)70, (byte[])this.bbuf, (int)0, (byte)this.type, (int)(ndo * this.mode));
        }
        this.ho.write(this.bbuf, 0, (int)((double)ndo * this.ho.dbpe));
        this.phase += dp * (double)ndo;
        this.ndone = (int)this.phase;
        this.phase -= (double)this.ndone;
        if (this.chirp != 0.0) {
            this.freq += this.chirp * this.delta * (double)ndo;
        }
        if (this.dfs || this.lut) {
            this.phase1 += dp1 * (double)ndo;
            this.ndone = (int)this.phase1;
            this.phase1 -= (double)this.ndone;
            if (this.lut) {
                this.genlut(this.ndone, this.mper);
            }
            this.phase2 += dp2 * (double)ndo;
            this.ndone = (int)this.phase2;
            this.phase2 -= (double)this.ndone;
        }
        return 0;
    }

    public int close() {
        if (this.stats) {
            float elapse = (float)(Time.current() - this.timer);
            float size = (float)(this.ho.getDataSize() / 1048576.0);
            float rate = size / (float)Math.max(0.001, (double)elapse);
            this.M.info((CharSequence)("Size=" + size + " Mby, Time=" + elapse + " sec, Rate=" + rate + " Mby/s"));
        }
        if (this.fb > 0) {
            FileIO.freeBuffer(this.bbuf);
        }
        this.ho.close();
        return 0;
    }

    public int restart() {
        this.ho.close();
        this.ho = this.MA.getDataFile("OUT", this.ho, 0);
        this.ho.setFormat(this.form);
        this.ho.setSize(this.todo);
        this.ho.open();
        this.tstart = 0.0;
        return 0;
    }

    public int processReady() {
        if (this.state != 2) {
            return 0;
        }
        return this.ho.processReady(this.xfer);
    }

    public void setShape(String value) {
        this.shape = Parser.find((String)shapeList, (String)value, (int)this.shape, (int)0, (int)1);
    }

    public void setGain(double value) {
        this.gain = value;
    }

    public void setFrequency(double value) {
        this.freq = value;
    }

    public void setChirp(double value) {
        this.chirp = value;
    }

    public void setPhase(double value) {
        this.phase = value;
    }

    public void setThrottle(String value) {
        this.throttle = Parser.find((String)throttleList, (String)value, (int)this.throttle, (int)0, (int)1);
    }

    public void setFormat(String format) {
        if (this.form.equals(format)) {
            return;
        }
        this.form = format;
        this.setState(7);
    }

    public String getShape() {
        return Parser.get((String)shapeList, (int)this.shape);
    }

    public double getGain() {
        return this.gain;
    }

    public double getAmplitude() {
        return this.amp;
    }

    public double getFrequency() {
        return this.freq;
    }

    public double getChirp() {
        return this.chirp;
    }

    public double getPhase() {
        return this.phase;
    }

    public String getThrottle() {
        return Parser.get((String)throttleList, (int)this.throttle);
    }

    public String getFormat() {
        return this.form;
    }

    private float[] getNotchFilter() {
        double fnyq = this.rate / 2.0;
        double afreq = Math.max(Math.min(this.freq, fnyq - this.dfreq), this.dfreq);
        FilterFIR f = new FilterFIR(this.M, FilterFIR.FilterType.StopBand, this.ntap, afreq - this.dfreq, afreq + this.dfreq, fnyq, false, false, "BH92", 1.0);
        return f.makeFilter(this.ntap);
    }

    private void filterPrep(float[] ftap) {
        int i;
        int flags = this.wmode == 2 ? 2 : 65;
        this.fft = new Fft(this.nfft, flags | 8);
        this.ifft = new Fft(this.nfft, flags | 0x10);
        this.nbins = this.wmode == 2 ? this.nfft : this.nfft / 2 + 1;
        int nbin2 = this.nbins * 2;
        float scale = (float)(1.0 / (double)(this.wmode == 2 ? this.nfft : this.nfft * 4));
        this.filt = new float[nbin2];
        for (i = 0; i < nbin2; ++i) {
            this.filt[i] = 0.0f;
        }
        for (i = 0; i < this.ntap; ++i) {
            this.filt[(i + this.xfer) * this.wmode] = ftap[i] * scale;
        }
        this.fft.work((Object)this.filt);
        this.save = new float[this.ntap * this.wmode];
        this.lrs = Waveform.lrs((float[])this.save, (double)this.amp, (int)this.ntap, (int)this.wmode, (int)this.lrs);
        this.loop = new float[this.ntap * this.wmode];
        System.arraycopy(this.save, 0, this.loop, 0, this.ntap * this.wmode);
        this.iloop = -((long)(this.size - (double)this.ntap));
        this.work = new float[nbin2];
    }

    private void filter(float[] buf, int ndo, int mode) {
        System.arraycopy(this.save, 0, this.work, 0, this.ntap * mode);
        System.arraycopy(buf, 0, this.work, this.ntap * mode, ndo * mode);
        if (this.wrap) {
            this.iloop += (long)this.xfer;
            if (this.iloop > 0L) {
                System.arraycopy(this.loop, 0, this.work, (this.nfft - (int)this.iloop) * mode, Math.min(this.ntap, (int)this.iloop) * mode);
            }
        }
        System.arraycopy(buf, (this.xfer - this.ntap) * mode, this.save, 0, this.ntap * mode);
        this.fft.work((Object)this.work);
        Multiply.CCC((float[])this.work, (float[])this.filt, (float[])buf, (int)this.nbins);
        this.ifft.work((Object)buf);
    }

    private void preplut() {
        this.ilut = new float[1024];
        this.qlut = new float[1024];
        float scl = (float)this.amp;
        int k = 0;
        int is = 1;
        boolean js = true;
        boolean map = this.MA.getState("/MAP");
        if (this.shape == 22) {
            this.olut = 1;
            float r1 = scl * 1.414f / 2.0f;
            for (int i = 0; i < 2; ++i) {
                this.ilut[k] = (float)is * r1;
                this.qlut[k] = 0.0f;
                ++k;
                is = -is;
            }
        } else if (this.shape == 20) {
            this.olut = 1;
            for (int i = 0; i < 2; ++i) {
                this.ilut[k] = (float)is * 0.5f * this.midx;
                this.qlut[k] = 0.0f;
                ++k;
                is = -is;
            }
        } else if (this.shape == 21) {
            int i;
            this.olut = 2;
            for (i = 0; i < 2; ++i) {
                this.ilut[k] = (float)is * 0.5f * this.midx;
                this.qlut[k] = 0.0f;
                ++k;
                is = -is;
            }
            for (i = 2; i < 4; ++i) {
                this.ilut[k] = (float)is * 1.5f * this.midx;
                this.qlut[k] = 0.0f;
                ++k;
                is = -is;
            }
        } else if (this.shape == 27) {
            this.olut = 3;
            float r1 = scl * 1.414f / 2.0f;
            for (int i = 0; i < 8; ++i) {
                double p = Math.PI * 2 * ((double)i + 0.5) / 8.0;
                this.ilut[i] = r1 * (float)Math.sin(p);
                this.qlut[i] = r1 * (float)Math.cos(p);
            }
        } else if (this.shape == 28) {
            this.olut = 4;
            float r1 = scl * 1.414f / 2.0f;
            for (int i = 0; i < 16; ++i) {
                double p = Math.PI * 2 * ((double)i + 0.5) / 16.0;
                this.ilut[i] = r1 * (float)Math.sin(p);
                this.qlut[i] = r1 * (float)Math.cos(p);
            }
        } else if (this.shape == 29) {
            double p;
            int i;
            this.olut = 4;
            float r1 = scl * 0.38910508f;
            float r2 = scl;
            for (i = 0; i < 4; ++i) {
                p = Math.PI * 2 * ((double)i + 0.5) / 4.0;
                this.ilut[i + 0] = r1 * (float)Math.sin(p);
                this.qlut[i + 0] = r1 * (float)Math.cos(p);
            }
            for (i = 0; i < 12; ++i) {
                p = Math.PI * 2 * ((double)i + 0.5) / 12.0;
                this.ilut[i + 4] = r2 * (float)Math.sin(p);
                this.qlut[i + 4] = r2 * (float)Math.cos(p);
            }
        } else if (this.shape == 30) {
            double p;
            int i;
            this.olut = 5;
            float r1 = scl * 0.23255813f;
            float r2 = scl * 0.58837205f;
            float r3 = scl;
            for (i = 0; i < 4; ++i) {
                p = Math.PI * 2 * ((double)i + 0.5) / 4.0;
                this.ilut[i + 0] = r1 * (float)Math.sin(p);
                this.qlut[i + 0] = r1 * (float)Math.cos(p);
            }
            for (i = 0; i < 12; ++i) {
                p = Math.PI * 2 * ((double)i + 0.5) / 12.0;
                this.ilut[i + 4] = r2 * (float)Math.sin(p);
                this.qlut[i + 4] = r2 * (float)Math.cos(p);
            }
            for (i = 0; i < 16; ++i) {
                p = Math.PI * 2 * ((double)i + 0.0) / 16.0;
                this.ilut[i + 16] = r3 * (float)Math.sin(p);
                this.qlut[i + 16] = r3 * (float)Math.cos(p);
            }
        } else if (this.shape == 31) {
            double p;
            int i;
            this.olut = 6;
            float r1 = scl * 0.18867923f;
            float r2 = scl * 0.47735846f;
            float r3 = scl * 0.75471693f;
            float r4 = scl;
            for (i = 0; i < 4; ++i) {
                p = Math.PI * 2 * ((double)i + 0.5) / 4.0;
                this.ilut[i + 0] = r1 * (float)Math.sin(p);
                this.qlut[i + 0] = r1 * (float)Math.cos(p);
            }
            for (i = 0; i < 12; ++i) {
                p = Math.PI * 2 * ((double)i + 0.5) / 12.0;
                this.ilut[i + 4] = r2 * (float)Math.sin(p);
                this.qlut[i + 4] = r2 * (float)Math.cos(p);
            }
            for (i = 0; i < 20; ++i) {
                p = Math.PI * 2 * ((double)i + 0.5) / 20.0;
                this.ilut[i + 16] = r3 * (float)Math.sin(p);
                this.qlut[i + 16] = r3 * (float)Math.cos(p);
            }
            for (i = 0; i < 28; ++i) {
                p = Math.PI * 2 * ((double)i + 0.5) / 28.0;
                this.ilut[i + 36] = r4 * (float)Math.sin(p);
                this.qlut[i + 36] = r4 * (float)Math.cos(p);
            }
        } else if (this.shape == 32) {
            double p;
            int i;
            this.olut = 3;
            float r1 = scl * 0.41558442f;
            float r2 = scl;
            for (i = 0; i < 4; ++i) {
                p = Math.PI * 2 * ((double)i + 0.5) / 4.0;
                this.ilut[i + 0] = r1 * (float)Math.sin(p);
                this.qlut[i + 0] = r1 * (float)Math.cos(p);
            }
            for (i = 0; i < 4; ++i) {
                p = Math.PI * 2 * ((double)i + 0.5) / 4.0;
                this.ilut[i + 4] = r2 * (float)Math.sin(p);
                this.qlut[i + 4] = r2 * (float)Math.cos(p);
            }
        } else {
            switch (this.shape) {
                case 23: {
                    this.olut = 2;
                    this.hlut = 2;
                    break;
                }
                case 24: {
                    this.olut = 2;
                    this.hlut = 2;
                    break;
                }
                case 33: {
                    this.olut = 4;
                    this.hlut = 4;
                    break;
                }
                case 34: {
                    this.olut = 5;
                    this.hlut = 6;
                    break;
                }
                case 35: {
                    this.olut = 6;
                    this.hlut = 8;
                    break;
                }
                case 36: {
                    this.olut = 7;
                    this.hlut = 12;
                    break;
                }
                case 37: {
                    this.olut = 8;
                    this.hlut = 16;
                    break;
                }
                case 38: {
                    this.olut = 9;
                    this.hlut = 24;
                    break;
                }
                case 39: {
                    this.olut = 10;
                    this.hlut = 32;
                }
            }
            if (map) {
                scl = (float)this.hlut / (float)(this.hlut - 1);
            }
            float ampd = 2.0f * scl / (float)this.hlut;
            float amp0 = -scl + ampd / 2.0f;
            for (int i = 0; i < this.hlut; ++i) {
                for (int j = 0; j < this.hlut; ++j) {
                    if (!((this.shape != 34 || i >= 1 && i <= 4 || j >= 1 && j <= 4) && (this.shape != 36 || i >= 2 && i <= 9 || j >= 2 && j <= 9) && (this.shape != 38 || i >= 4 && i <= 19 || j >= 4 && j <= 19))) continue;
                    this.ilut[k] = amp0 + (float)i * ampd;
                    this.qlut[k] = amp0 + (float)j * ampd;
                    if (map) {
                        this.addRing(this.ilut[k], this.qlut[k]);
                    }
                    ++k;
                }
            }
        }
        this.nlut = 1 << this.olut;
        this.nper = (int)((double)this.xfer * this.freq1 * this.delta + 1.0);
        this.mper = this.ntap + this.nper;
        this.idat = new float[this.mper + 1];
        this.idat0 = new float[this.mper];
        this.qdat = new float[this.mper + 1];
        this.qdat0 = new float[this.mper];
        this.lrsbuf = new int[this.mper];
        this.qloop = this.mper;
        this.genscram();
        this.genlut(this.mper, this.mper);
        System.arraycopy(this.idat, 0, this.idat0, 0, this.mper);
        System.arraycopy(this.qdat, 0, this.qdat0, 0, this.mper);
        this.qloop = -Math.round(this.size * this.delta * this.freq1);
        if (map) {
            this.printRings();
        }
    }

    private void addRing(float x, float y) {
        int i;
        float r = (float)Math.sqrt(x * x + y * y);
        this.sar += r;
        if (this.rings == null) {
            this.rings = new float[1024];
        }
        for (i = 0; i < this.nr; ++i) {
            if ((double)Math.abs(r - this.rings[i]) < 1.0E-4) {
                return;
            }
            if (r < this.rings[i]) break;
        }
        for (int j = this.nr; j > i; --j) {
            this.rings[j] = this.rings[j - 1];
        }
        this.rings[i] = r;
        ++this.nr;
    }

    private void printRings() {
        float scl = (float)(this.hlut - 1) / (float)this.hlut;
        for (int i = 0; i < this.nr; ++i) {
            System.out.println("Ring i=" + i + " r=" + this.rings[i] + " rs=" + scl * this.rings[i]);
        }
        float ar = scl * this.sar / (float)this.nlut;
        System.out.println("Average = " + ar);
    }

    private void genscram() {
        this.scram = new int[1024];
        int lrs = ~this.seed;
        for (int i = 0; i < 8192; ++i) {
            int bit0 = ~(lrs ^ lrs >> 1 ^ lrs >> 5 ^ lrs >> 25) & 1;
            lrs = lrs << 1 | bit0;
            this.scram[i >> 3] = lrs & 0x3FF;
        }
        this.iscram = 0;
    }

    private int onesN(int mask) {
        int ones = 1;
        for (int i = 0; i < 32; ++i) {
            ones += mask & 1;
            mask >>= 1;
        }
        return ones;
    }

    private int genlrs(int[] buf, int n, int lrs) {
        float factor = 5.5879354E-8f;
        if (this.lrsp != 0) {
            for (int i = 0; i < n; ++i) {
                lrs = lrs << 1 | this.onesN(lrs & this.lrsp) & 1;
                buf[i] = lrs * 1023;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int bit0 = ~(lrs ^ lrs >> 1 ^ lrs >> 5 ^ lrs >> 25) & 1;
                lrs = lrs << 1 | bit0;
                int lrsb = (int)(factor * (float)lrs);
                buf[i] = lrsb ^ this.scram[this.iscram++];
                this.iscram &= 0x3FF;
            }
        }
        return lrs;
    }

    private void genlut(int ndone, int ndo) {
        int k;
        int j;
        int i;
        int mlut = this.nlut - 1;
        int ndif = ndo - ndone;
        for (i = 0; i < ndif; ++i) {
            this.idat[i] = this.idat[i + ndone];
            this.qdat[i] = this.qdat[i + ndone];
        }
        this.lrs = this.genlrs(this.lrsbuf, ndone, this.lrs);
        if (this.shape == 20 || this.shape == 21) {
            i = ndif;
            j = 0;
            while (i < ndo) {
                float fskdp;
                k = this.lrsbuf[j] & mlut;
                this.idat[i] = fskdp = this.ilut[k];
                this.qdat[i] = this.fskp;
                this.fskp += fskdp;
                this.fskp -= (float)((int)this.fskp);
                ++i;
                ++j;
            }
        } else {
            i = ndif;
            j = 0;
            while (i < ndo) {
                k = this.lrsbuf[j] & mlut;
                this.idat[i] = this.ilut[k];
                this.qdat[i] = this.qlut[k];
                ++i;
                ++j;
            }
        }
        if (this.wrap && this.qloop != (long)ndo) {
            this.qloop += (long)ndone;
            if (this.qloop + (long)ndo >= 0L) {
                int ioff = -((int)this.qloop);
                int i0off = 0;
                if (ioff < 0) {
                    i0off = -ioff;
                    ioff = 0;
                }
                int icpy = ndo - ioff;
                System.arraycopy(this.idat0, i0off, this.idat, ioff, icpy);
                System.arraycopy(this.qdat0, i0off, this.qdat, ioff, icpy);
            }
        }
    }

    private void resfsk(float[] buf, double p, double dp, int ndo) {
        float scl = (float)this.amp;
        int j = 0;
        for (int i = 0; i < ndo; ++i) {
            float di = 0.0f;
            float dq = 0.0f;
            int k = (int)p;
            double r = ((p - (double)k) * (double)this.idat[k] + (double)this.qdat[k]) * (Math.PI * 2);
            di = scl * (float)Math.sin(r);
            dq = scl * (float)Math.cos(r);
            buf[j++] = di;
            buf[j++] = dq;
            p += dp;
        }
    }

    private void reslut(float[] buf, double p, double dp, int ndo) {
        int j = 0;
        for (int i = 0; i < ndo; ++i) {
            int k;
            float di = 0.0f;
            float dq = 0.0f;
            int k2 = (int)p;
            int k1 = (int)((1.0 - (p - (double)k2)) * (double)this.nrpt);
            if (this.ntap == 1) {
                di = this.idat[k2];
                dq = this.qdat[k2];
            } else if (this.iqoff) {
                double pq = p + 0.5;
                int k2q = (int)pq;
                int k1q = (int)((1.0 - (pq - (double)k2q)) * (double)this.nrpt);
                k = 0;
                while (k < this.ntap) {
                    di += this.rtap[k1] * this.idat[k2];
                    dq += this.rtap[k1q] * this.qdat[k2q];
                    ++k;
                    k1 += this.nrpt;
                    ++k2;
                    k1q += this.nrpt;
                    ++k2q;
                }
            } else {
                k = 0;
                while (k < this.ntap) {
                    di += this.rtap[k1] * this.idat[k2];
                    dq += this.rtap[k1] * this.qdat[k2];
                    ++k;
                    k1 += this.nrpt;
                    ++k2;
                }
            }
            buf[j++] = di;
            buf[j++] = dq;
            p += dp;
        }
    }

    private void rotlut(float[] buf, double p, double dp, int ndo) {
        float sa = (float)Math.sin(p * (Math.PI * 2));
        float ca = (float)Math.cos(p * (Math.PI * 2));
        float dsa = (float)Math.sin(dp * (Math.PI * 2));
        float dca = (float)Math.cos(dp * (Math.PI * 2));
        for (int i = 0; i < ndo * 2; i += 2) {
            float di = buf[i + 0];
            float dq = buf[i + 1];
            buf[i + 0] = di * ca - dq * sa;
            buf[i + 1] = di * sa + dq * ca;
            float cb = dca * ca - dsa * sa;
            sa = dca * sa + dsa * ca;
            ca = cb;
        }
    }

    private int fastramp(int[] buf, int type, int ndo, int mode, int cur) {
        if (type == 73 && mode == 2) {
            int inc = 1;
            int i = 0;
            while (i < ndo) {
                buf[i] = cur;
                ++i;
                cur += inc;
            }
        } else {
            this.M.error("FastRamp for type=" + type + " and spa=" + mode + " not supported");
        }
        return cur;
    }

    private int testramp(float[] buf, int type, int ndo, int mode, int cur) {
        int range = type == 66 ? 256 : 65536;
        int max = range >> 1;
        int inc = type == 76 ? 50398210 : (type == 66 ? 3 : 256);
        int j = 0;
        for (int i = 0; i < ndo; ++i) {
            if (type != 76 && (cur += inc) >= max) {
                cur -= range;
            }
            if (type == 73 && (cur & 0xFF00) == 65280) {
                ++cur;
            }
            buf[j++] = cur;
            if (mode <= 1) continue;
            buf[j++] = cur;
        }
        return cur;
    }

    private void mux(float[] fbuf, float[] tbuf, int ndo) {
        int j = ndo * 2;
        for (int i = ndo - 1; i >= 0; --i) {
            fbuf[--j] = fbuf[i];
            fbuf[--j] = tbuf[i];
        }
    }

    private void rotate(float[] buf, int ndo, int spa) {
        if (spa == 1) {
            for (int i = 0; i < ndo; i += 2) {
                buf[i + 0] = -buf[i + 0];
            }
        } else {
            for (int i = 0; i < ndo * 2; i += 4) {
                buf[i + 0] = -buf[i + 0];
                buf[i + 1] = -buf[i + 1];
            }
        }
    }

    private void cx2r(float[] buf, int ndo) {
        int i = 0;
        int j = 0;
        while (i < ndo) {
            buf[i] = buf[j];
            ++i;
            j += 2;
        }
    }

    public void lrs(float[] fbuf, double amp, int n, int spa) {
        float factor = (float)(amp / 2.0 / 1.073741824E9);
        for (int i = 0; i < n * spa; ++i) {
            fbuf[i] = factor * (float)this.lrsx;
            int bit0 = ~(this.lrsx ^ this.lrsx >> 1 ^ this.lrsx >> 5 ^ this.lrsx >> 25) & 1;
            this.lrsx <<= 1;
            this.lrsx |= bit0;
            if (spa == 1) continue;
            fbuf[++i] = factor * (float)this.lrsy;
            bit0 = ~(this.lrsy ^ this.lrsy >> 1 ^ this.lrsy >> 5 ^ this.lrsy >> 25) & 1;
            this.lrsy <<= 1;
            this.lrsy |= bit0;
        }
    }
}

