/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import nxm.ice.lib.FileIO;
import nxm.ice.lib.MDevIce;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.WidgetPanel;
import nxm.sys.lib.Args;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.KeyVector;
import nxm.sys.lib.Logger;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MJBrowser;
import nxm.sys.libg.MJFrame;
import nxm.sys.libg.MWindow;

public class iceutil
extends Primitive {
    public static Logger logger;
    private static String[] rowlabel;
    String outline = "";
    static double e2m;
    static String form;
    int evalcrc;

    public int open() {
        String func = this.MA.getU("FUNC");
        if (this.verbose) {
            this.M.info((CharSequence)("IceUtil f=" + func + " p1=" + this.MA.getCS("P1") + " p2=" + this.MA.getCS("P2")));
        }
        if (func.equals("GC")) {
            System.gc();
        } else if (func.equals("TTF2M")) {
            this.ttf2m();
        } else if (func.equals("BIT2M")) {
            this.bit2m();
        } else if (func.equals("FSTATS")) {
            this.fstats();
        } else if (func.equals("TSTATS")) {
            this.tstats();
        } else if (func.equals("DSTATS")) {
            this.dstats();
        } else if (func.equals("RBF2M")) {
            this.rbf2m();
        } else if (func.equals("ELF2M")) {
            this.elf2m();
        } else if (func.equals("STR2IP")) {
            this.str2ip();
        } else if (func.equals("IPX2IP")) {
            this.ipx2ip();
        } else if (func.equals("SETKEYS")) {
            this.setkeys();
        } else if (func.equals("MASK")) {
            this.mask();
        } else if (func.equals("CARETS")) {
            this.carets();
        } else if (func.equals("BUTTON")) {
            this.button();
        } else if (func.equals("RUN")) {
            this.runit();
        } else if (func.equals("JVM2XBR")) {
            this.jvm2xbr();
        } else if (func.equals("M2XBR")) {
            this.m2xbr();
        } else if (func.equals("M2VBR")) {
            this.m2vbr();
        } else if (func.equals("M2MIF")) {
            this.m2mif();
        } else if (func.equals("MBTST")) {
            this.mbtst();
        } else if (func.equals("JTAG2M")) {
            this.jtag2m();
        } else if (func.equals("LST2CSP")) {
            this.lst2csp();
        } else if (func.equals("SYM2PART")) {
            this.sym2part();
        } else if (func.equals("NET2UCF")) {
            this.net2ucf();
        } else if (func.equals("ENET2UCF")) {
            this.enet2ucf();
        } else if (func.equals("QNET2UCF")) {
            this.qnet2ucf();
        } else if (func.equals("VPP")) {
            this.vppflow();
        } else if (func.equals("TPP")) {
            this.tppflow();
        } else if (func.equals("UCF2XDC")) {
            this.ucf2xdc();
        } else if (func.equals("GERBER")) {
            this.gerber();
        } else if (func.equals("CRCGEN")) {
            this.crcgen();
        } else if (func.equals("MODARGS")) {
            this.modargs();
        } else if (func.equals("COMPRESS")) {
            this.compress(1);
        } else if (func.equals("UNCOMPRESS")) {
            this.compress(-1);
        } else if (func.equals("BROWSE")) {
            this.browse();
        } else if (func.equals("GETID")) {
            this.getid();
        } else if (func.equals("GREP")) {
            this.grep();
        } else if (func.equals("REPTBL")) {
            this.reptbl();
        } else if (func.equals("LOGGER")) {
            this.logger();
        } else if (func.equals("GETFILE")) {
            this.getfile();
        } else if (func.equals("DBGFILE")) {
            this.dbgfile();
        } else if (func.equals("TPUT")) {
            this.tput();
        } else if (func.equals("SCANUP")) {
            this.scanup();
        } else if (func.equals("GREPLOG")) {
            this.greplog();
        } else if (func.equals("KVI")) {
            this.kvi();
        } else {
            this.M.error("Unsupported function: " + func);
        }
        return 9;
    }

    private void getfile() {
        String path = this.MA.getCS("P1");
        File file = new File(path);
        if (file.exists()) {
            System.out.println("Exists " + new File(path).exists());
        } else {
            System.out.println("NExists " + path);
        }
    }

    private void logger() {
        String str = this.MA.getS("P1");
        if (str.equals("PAUSE")) {
            logger = this.M.setLogger(null);
        }
        if (str.equals("RESUME")) {
            this.M.setLogger(logger);
        }
    }

    private void mask() {
        String str = this.MA.getS("P1");
        String mat = this.MA.getS("P2");
        String lab = this.MA.getU("P3");
        this.MR.put(lab, Parser.mask((String)str, (String)mat, (int)0));
    }

    private void carets() {
        String str = this.MA.getS("P1");
        String lab = this.MA.getU("P2");
        this.MR.put(lab, (Object)this.MA.evaluateCarets(str));
    }

    private void reptbl() {
        Table t = this.MA.getTable("P1");
        String rep = this.MA.getS("P2");
        t.clear();
        t.append(rep);
    }

    private void button() {
        String label = this.MA.getCS("P1");
        String list = this.MA.getCS("P2");
        int flags = 2294273;
        GMenu menu = new GMenu(null, "", list, 0, flags, (MessageHandler)this.M.macro);
        menu.setMidas(this.M);
        menu.setLabel(label);
        WidgetPanel parent = (WidgetPanel)this.M.registry.get("PANEL");
        parent.addWidget((GWidget)menu);
    }

    private void runit() {
        String cmd = this.MA.getRawArgs().trim().substring(4);
        Shell.runCommand((Midas)this.M, (String)cmd);
    }

    private void setkeys() {
        Object obj = this.MA.getO("P1");
        Table tbl = this.MA.getTable("P2");
        KeyObject.setKeys((Object)obj, (Table)tbl);
    }

    private void dbgfile() {
        DataFile df = this.MA.getDataFile("P1", "1000", "SL", 0);
        df.open(1);
        Data db = df.getDataBuffer(4);
        int trig = this.MA.getL("/TRIG", 20);
        int wind = this.MA.getL("/WIND", 10);
        boolean totals = this.MA.getState("/TOTALS");
        boolean comps = this.MA.getState("/COMPS");
        int xind = wind;
        int wtot = 0;
        int rtot = 0;
        int ttot = 0;
        int pass = 0;
        int i3l = 0;
        int i = 0;
        while ((double)i < df.getSize()) {
            int len;
            df.read(db);
            int i0 = db.getL(0);
            int i1 = db.getL(1);
            int i2 = db.getL(2);
            int i3 = db.getL(3);
            if (i3l == 0) {
                i3l = i3;
            }
            int tdif = i3 - i3l >> 4 & 0xFFFFFFF;
            ttot += tdif;
            if (tdif > trig && !comps) {
                if (xind < 0) {
                    System.out.printf("... wtot %d    rtot %d    ttot %d   pass %d ...\n", wtot, rtot, ttot, pass);
                }
                if (xind < 0) {
                    ttot = 0;
                    wtot = 0;
                    rtot = 0;
                    ++pass;
                }
                xind = wind;
            }
            int rt = -1;
            String op = null;
            String adr = "     ";
            if ((i3 & 1) != 0) {
                rt = i2 >> 11 & 0x1F;
                op = rt == 0 ? "mrd" : (rt == 1 ? "mwr" : (rt == 12 ? "msg" : null));
                len = (i2 & 0x7FF) * 4;
                if (i1 == 2048) {
                    adr = "cque0";
                }
                if (i1 == 2304) {
                    adr = "cque1";
                }
                if (i1 == 2560) {
                    adr = "sque0";
                }
                if (i1 == 3072) {
                    adr = "sque1";
                }
                if (i1 == 4096) {
                    adr = "bram ";
                }
                if (i1 == 8192) {
                    adr = "xmem ";
                }
                if (i1 == 8192 && rt == 1) {
                    wtot += len;
                }
                if (i1 == 8192 && rt == 0) {
                    rtot += len;
                }
                if (i1 == 2304 && comps) {
                    System.out.printf("Comp ... wtot %d    rtot %d    ttot %d   pass %d ...\n", wtot, rtot, ttot, pass);
                    ttot = 0;
                    wtot = 0;
                    rtot = 0;
                    ++pass;
                }
            } else {
                op = "cpl";
                len = (i1 & 0x3FF) * 4;
            }
            if (op == null) {
                System.out.printf("Dbg [ %08x %08x %08x %08x ]   unknown Op\n", i0, i1, i2, i3);
            }
            if (xind > 0 && !totals) {
                System.out.printf("Dbg [ %08x %08x %08x %08x ]    %s   %s   %4d   %d\n", i0, i1, i2, i3, op, adr, len, tdif);
            }
            --xind;
            i3l = i3;
            i += 4;
        }
        df.close();
    }

    private void ttf2m() {
        String line;
        TextFile tf = this.MA.getTextFile("P1");
        tf.setExt("ttf");
        tf.open(1);
        DataFile df = this.MA.getDataFile("P2", "1000", "SB", 0);
        df.setComment("ICEPIC IOC Load Program");
        df.open(2);
        byte[] buffer = new byte[128];
        while ((line = tf.read()) != null) {
            int n = (line.length() + 1) / 4;
            if (n > 128) {
                this.M.error("Bad TTF line length");
            }
            for (int i = 0; i < n; ++i) {
                int k = Convert.s2l((String)line.substring(i * 4, i * 4 + 3));
                buffer[i] = k > 127 ? (byte)(k - 256) : (byte)k;
            }
            df.write(buffer, 0, n);
        }
        tf.close();
        df.close();
    }

    private boolean chk(byte[] a, byte[] b, int n) {
        for (int i = 0; i < n; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private void dstats() {
        String aux = this.MA.getS("P1");
        String out = this.MA.getU("P2");
        String path = this.M.io.getAuxPath(aux);
        try {
            IOResource res = IOResource.getInstance((Midas)this.M, (int)0, (String)path, (int)0, null);
            Table stats = res.getStatFS();
            this.MR.put(out, (Object)stats);
        }
        catch (Exception ex) {
            this.M.warning((CharSequence)("Unable to get disk statistics for AUX=" + aux + " at path=" + path + " cause=" + ex.getMessage()));
        }
    }

    private void fstats() {
        DataFile bf = this.MA.getDataFile("P1");
        bf.setExt("mlog");
        bf.open(1);
        int size = (int)bf.getSize();
        DataFile df = this.MA.getDataFile("P2", "3000", "NH", 0, 0.0, null);
        df.setSubRecords("FAVG|SL,FMIN|SL,FMAX|SL");
        Data dfb = df.getDataBuffer(1);
        df.open(2);
        String id = this.MA.getS("P3");
        for (int i = 0; i < size; ++i) {
            int ti;
            Table t = bf.getDataTable((double)i);
            if (t == null) continue;
            String from = t.getS("FROM");
            String type = t.getS("TYPE");
            String line = t.getS("TEXT");
            if (from == null || !from.equals(id) || !type.equals("INFO") || (ti = line.indexOf("STATS=")) <= 0) continue;
            boolean hasM = line.indexOf("FMIN=") > 0;
            Table to = new Table(line.substring(ti + 6));
            int favg = to.getL("FAVG");
            int fmin = hasM ? to.getL("FMIN") : favg;
            int fmax = hasM ? to.getL("FMAX") : favg;
            dfb.packL(0, favg);
            dfb.packL(4, fmin);
            dfb.packL(8, fmax);
            df.write(dfb);
        }
        bf.close();
        df.close();
    }

    private byte getTemp(String line, String item) {
        int i = line.indexOf(item + "=");
        if (i < 0) {
            return -1;
        }
        int j = (line = line.substring(i + item.length() + 1)).indexOf(" ");
        if (j > 0) {
            line = line.substring(0, j);
        }
        return (byte)Convert.s2l((String)line);
    }

    private void tstats() {
        DataFile bf = this.MA.getDataFile("P1");
        bf.setExt("mlog");
        bf.open(1);
        int size = (int)bf.getSize();
        DataFile df = this.MA.getDataFile("P2", "3000", "NH", 0, 0.0, null);
        df.setSubRecords("XBAR|SB,IOM1|SB,PM1|SB,PM2|SB,ARX|SB");
        Data dfb = df.getDataBuffer(1);
        df.open(2);
        String id = this.MA.getS("P3");
        double tstart = 0.0;
        double tdelta = 60.0;
        for (int i = 0; i < size; ++i) {
            Table t = bf.getDataTable((double)i);
            if (t == null) continue;
            if (tstart == 0.0) {
                tstart = t.getD("TIME");
            }
            String from = t.getS("FROM");
            String type = t.getS("TYPE");
            String line = t.getS("TEXT");
            if (!type.equals("INFO")) continue;
            int ti = line.indexOf("Temps:");
            if (ti > 0) {
                dfb.buf[0] = this.getTemp(line, "XBar");
                dfb.buf[1] = this.getTemp(line, "IOM1");
                dfb.buf[2] = this.getTemp(line, "PM1");
                dfb.buf[3] = this.getTemp(line, "PM2");
            }
            if ((ti = line.indexOf("AR26=")) <= 0) continue;
            dfb.buf[4] = this.getTemp(line, "Temp1");
            df.write(dfb);
        }
        df.setXStart(tstart);
        df.setXDelta(tdelta);
        df.setXUnits(1);
        bf.close();
        df.close();
    }

    private void bit2m() {
        int i;
        BaseFile bf = this.MA.getBaseFile("P1");
        bf.setExt("bit");
        bf.open(1);
        int bytes = (int)bf.getSize();
        int flash = this.MA.getL("/FLASH");
        int nosync = this.MA.getL("/NOSYNC");
        byte[] buf = new byte[bytes + 16];
        byte[] syncpattern = new byte[]{-1, -1, -1, -1, -86, -103, 85, 102};
        if (nosync >= 0) {
            bf.read(buf, 0, bytes);
            bf.close();
        } else {
            int t = 0;
            while (true) {
                for (int i2 = 0; i2 < 7; ++i2) {
                    buf[i2] = buf[i2 + 1];
                }
                buf[7] = bf.readByte();
                --bytes;
                if (this.chk(buf, syncpattern, 8)) break;
                if (t > 256) {
                    this.M.error("No sync found");
                }
                ++t;
            }
            bf.read(buf, 8, bytes -= 4);
            bytes += 8;
            bf.close();
        }
        int quads = bytes / 4;
        if (nosync < 0) {
            Convert.swap4((byte[])buf, (int)0, (int)quads);
        }
        while (quads % 4 != 0) {
            System.arraycopy(buf, bytes - 4, buf, bytes, 4);
            ++quads;
            bytes += 4;
        }
        int crc = 0;
        for (i = 0; i < bytes; i += 4) {
            crc = this.crc32(crc, Convert.unpackL((byte[])buf, (int)i), 32);
        }
        for (i = bytes; i < flash; i += 4) {
            crc = this.crc32(crc, -1, 32);
        }
        DataFile df = this.MA.getDataFile("P2", "1000", "SL", 0, (double)quads, null);
        df.setComment("ICE XILINX FPGA Load Program");
        df.keywords.putMain("CRC", Convert.l2x((int)crc), false);
        df.open(2);
        df.write(buf, 0, bytes);
        df.close();
    }

    private void compress(int dir) {
        int olen;
        byte[] dbo;
        MDevIce p = new MDevIce();
        p.load();
        DataFile dfi = this.MA.getDataFile("P1", "1000", "SB,SL", 0);
        dfi.open();
        DataFile dfo = this.MA.getDataFile("P2", dfi, 0);
        dfo.open();
        int ilen = (int)(dfi.size * dfi.getBPE());
        byte[] dbi = new byte[ilen];
        dfi.read(dbi, 0, ilen);
        dfi.close();
        if (dir > 0) {
            int blen = ilen + 512;
            byte[] dbm = new byte[blen];
            dbo = dbi;
            int mlen = p.compress(dbi, ilen, dbm, blen, 1);
            olen = p.compress(dbm, mlen, dbo, blen, 1);
            dfo.keywords.putMain("ICSZ", "" + ilen, false);
            dfo.keywords.putMain("ICSZM", "" + mlen, false);
            String scrc = dfo.keywords.getMain("CRC");
            int crc = dfo.keywords.getL("CRC", 0);
            if (scrc == null && crc != 0) {
                dfo.keywords.delete("CRC");
                dfo.keywords.putMain("CRC", Convert.l2x((int)crc), false);
            }
            dfo.setFormat("SB");
        } else {
            olen = dfo.keywords.getL("ICSZ", 0);
            int mlen = dfo.keywords.getL("ICSZM", 0);
            int blen = olen + 512;
            byte[] dbm = new byte[blen];
            dbo = new byte[blen];
            p.compress(dbi, ilen, dbm, mlen, -1);
            p.compress(dbm, mlen, dbo, olen, -1);
            dfo.keywords.deleteMain("ICSZ");
            dfo.keywords.deleteMain("ICSZM");
            String comment = dfo.getComment();
            if (comment.indexOf("XILINX") > 0) {
                dfo.setFormat("SL");
            }
        }
        dfo.write(dbo, 0, olen);
        dfo.close();
    }

    private int crc32(int crc, int data, int bits) {
        for (int i = 0; i < bits; ++i) {
            int val = (data >> i ^ crc >> 31) & 1;
            crc = crc << 1 & 0xFFFFFFFE | val;
            if (val == 0) continue;
            crc ^= 0xEDB88320;
        }
        return crc;
    }

    private int crc32r(int crc, int data, int bits) {
        for (int i = bits; i >= 0; --i) {
            int val = (data >> i ^ crc >> 31) & 1;
            crc = crc << 1 & 0xFFFFFFFE | val;
            if (val == 0) continue;
            crc ^= 0xEDB88320;
        }
        return crc;
    }

    private void rbf2m() {
        int fp;
        int wp;
        BaseFile bf = this.MA.getBaseFile("P1");
        int maxpad = 64448;
        int st = this.MA.getL("P3");
        bf.setExt("rbf");
        bf.open(1);
        byte[] pad = new byte[maxpad];
        for (int i = 0; i < maxpad; ++i) {
            pad[i] = -1;
        }
        int n = wp = st == 1 ? 22 : 0;
        int n2 = st == 2 ? 1048 : (st == 4 ? 396 : (fp = st == 5 ? 32768 : 0));
        int bp = st == 2 ? 4 : (st == 3 ? 1094 : (st == 4 ? 16 : 0));
        System.out.println("Padding for Stratix type=" + st + " word=" + wp + " front=" + fp + " back=" + bp);
        int ibytes = (int)bf.getSize();
        int obytes = ibytes + 3 & 0xFFFFFFFC;
        int off = obytes - ibytes;
        byte[] buf = new byte[ibytes];
        bf.read(buf, 0, ibytes);
        bf.close();
        DataFile df = this.MA.getDataFile("P2", "1000", "SB", 0, (double)obytes, null);
        df.setComment("ALTERA FPGA Load Program");
        df.keywords.putMain("CRC", Convert.l2x((int)0), false);
        df.open(2);
        df.write(pad, 0, fp);
        df.write(pad, 0, off + wp);
        df.write(buf, 0, ibytes);
        if (st == 2) {
            pad[3] = 0;
            pad[2] = 0;
            pad[0] = 0;
            pad[1] = 4;
        }
        df.write(pad, 0, bp);
        df.close();
    }

    private void elf2m() {
        BaseFile bf = this.MA.getBaseFile("P1");
        bf.setExt("elf");
        bf.open(1);
        int bytes = (int)bf.getSize();
        byte[] buf = new byte[bytes];
        bf.read(buf, 0, bytes);
        bf.close();
        DataFile df = this.MA.getDataFile("P2", "1000", "SB", 0, (double)bytes, null);
        df.setComment("ICE XILINX PPC Load Program");
        df.open(2);
        df.write(buf, 0, bytes);
        df.close();
        byte[] dsram = new byte[4096];
        for (int i = 0; i < 4096; ++i) {
            dsram[i] = 0;
        }
        byte[] isram = new byte[4096];
        for (int i = 0; i < 4096; ++i) {
            isram[i] = 0;
        }
        Convert.swap4((byte[])buf, (int)20, (int)5);
        Convert.swap2((byte[])buf, (int)40, (int)6);
        String ident = Convert.unpackS((byte[])buf, (int)0, (int)16);
        int psecs = Convert.unpackI((byte[])buf, (int)44);
        int hoffs = Convert.unpackL((byte[])buf, (int)28);
        short hsize = Convert.unpackI((byte[])buf, (int)42);
        this.M.info((CharSequence)("Ident=" + ident + " PSECs=" + psecs + " Off=" + hoffs + " Size=" + hsize));
        for (int i = 0; i < psecs; ++i) {
            int soff = hoffs + i * hsize;
            Convert.swap4((byte[])buf, (int)soff, (int)8);
            int vaddr = Convert.unpackL((byte[])buf, (int)(soff + 8));
            int filsz = Convert.unpackL((byte[])buf, (int)(soff + 16));
            int memsz = Convert.unpackL((byte[])buf, (int)(soff + 20));
            int poffs = Convert.unpackL((byte[])buf, (int)(soff + 4));
            this.M.info((CharSequence)("Sec=" + i + " Vaddr=" + Convert.l2x((int)vaddr) + " Offst=" + Convert.l2x((int)poffs) + " FilSz=" + Convert.l2x((int)filsz) + " MemSz=" + Convert.l2x((int)memsz)));
            if ((vaddr & 0xFFFF0000) == -65536) {
                System.arraycopy(buf, poffs, isram, vaddr & 0xFFF, filsz);
            }
            if ((vaddr & 0xFFFF0000) != -50331648) continue;
            System.arraycopy(buf, poffs, dsram, vaddr & 0xFFF, filsz);
        }
        this.writeRamInit("nxm.ice.xfer.ppccode.h", isram, 0, 4096, 3, 2, 4);
        this.writeRamInit("nxm.ice.xfer.ppcdata.h", dsram, 0, 4096, 1, 2, 2);
        this.writeMemInit("nxm.ice.xfer.ppccode.mem", isram, 0, 4096, -4096);
        this.writeMemInit("nxm.ice.xfer.ppcdata.mem", dsram, 0, 4096, -50331648);
    }

    private void mbtst() {
        int i;
        DataFile df = this.MA.getDataFile("P1", "1000", "SB,SI,SL", 0);
        df.open();
        int nd = (int)df.getSize();
        Data db = df.getDataBuffer(nd);
        df.read(db);
        df.close();
        int bits = df.getBPA() * 8;
        int[] tally = new int[32];
        int data = 0;
        for (i = 0; i < nd; ++i) {
            if (bits == 8) {
                data = db.getB(i);
            }
            if (bits == 16) {
                data = db.getI(i);
            }
            if (bits == 32) {
                data = db.getL(i);
            }
            int b = 0;
            int m = 1;
            while (b < 16) {
                if ((data & m) != 0) {
                    int n = b;
                    tally[n] = tally[n] + 1;
                }
                ++b;
                m <<= 1;
            }
        }
        this.MT.writeln((CharSequence)("Analysis of " + nd + " samples from URL=" + df.getURL()));
        for (i = 0; i < bits; ++i) {
            float avg = (float)tally[i] / (float)nd;
            this.MT.writeln((CharSequence)("Bit Number=" + i + " Average=" + avg));
        }
    }

    private void str2ip() {
        String str = this.MA.getS("P1");
        String label = this.MA.getU("P2");
        String hwlab = this.MA.getU("P3");
        String ip = "";
        int ic = str.indexOf(":");
        if (ic > 0) {
            str = str.substring(0, ic);
        }
        int i = str.indexOf(".");
        ip = ip + Convert.l2x((int)Convert.s2l((String)str.substring(0, i))).substring(8);
        str = str.substring(i + 1);
        i = str.indexOf(".");
        ip = ip + Convert.l2x((int)Convert.s2l((String)str.substring(0, i))).substring(8);
        str = str.substring(i + 1);
        i = str.indexOf(".");
        ip = ip + Convert.l2x((int)Convert.s2l((String)str.substring(0, i))).substring(8);
        str = str.substring(i + 1);
        ip = ip + Convert.l2x((int)Convert.s2l((String)str)).substring(8);
        this.MR.put(label, (Object)ip);
        this.MR.put(hwlab, (Object)("1c:e0:" + ip.substring(0, 2) + ":" + ip.substring(2, 4) + ":" + ip.substring(4, 6) + ":" + ip.substring(6, 8)));
    }

    private void ipx2ip() {
        int c;
        String str = this.MA.getS("P1");
        int ix = this.MA.getL("P2");
        String iplab = this.MA.getU("P3");
        String ip = str;
        int ic = str.indexOf("X");
        int n = c = ic > 0 ? (int)str.charAt(ic - 1) : 46;
        if (ic >= 0) {
            if (c == 43 || c == 124) {
                int ib;
                for (ib = ic - 2; ib >= 0 && str.charAt(ib) != '.'; --ib) {
                }
                int num = Convert.s2l((String)str.substring(ib + 1, ic - 1));
                if (c == 43) {
                    num += ix;
                }
                if (c == 124) {
                    num |= ix;
                }
                ip = str.substring(0, ib + 1) + num + str.substring(ic + 1);
            } else {
                ip = str.replaceAll("X", "" + ix);
            }
        }
        this.MR.put(iplab, (Object)ip);
    }

    private void m2xbr() {
        DataFile df = this.MA.getDataFile("P1", "1000", "S#,C#", 0);
        df.open();
        int bytes = (int)df.getDataSize();
        byte[] buf = new byte[bytes];
        df.read(buf, 0, bytes);
        df.close();
        boolean auto = this.MA.getState("/ENUM");
        boolean auto2 = this.MA.getState("/ENUM2");
        boolean special = this.MA.getState("/SPECIAL");
        String pre = this.MA.getCS("/PREFIX");
        pre = StringUtil.isNullOrEmpty((Object)pre) ? "" : pre + ".";
        TextFile tf = this.MA.getTextFile("P2");
        tf.open(2);
        int banks = this.MA.getL("/BANKS", 1);
        int bpe = this.MA.getL("/BPA", df.bpa);
        int npb = bpe * 2 / banks;
        int bper = banks * 256 / 8;
        int i = 0;
        int l = 0;
        while (i < bytes) {
            String id = Convert.l2x((int)l).substring(8);
            String hdata = Convert.bb2hex((byte[])buf, (int)i, (int)bper);
            for (int j = 0; j < banks; ++j) {
                String data = "";
                int u = 0;
                for (int k = j * npb; k < bper * 2; k += banks * npb) {
                    int o = 2 + bper * 2 - k - npb;
                    if (u > 0 && u % 8 == 0) {
                        data = "_" + data;
                    }
                    data = hdata.substring(o, o + npb) + data;
                    u += npb;
                }
                if (auto) {
                    tf.writeln("defparam " + pre + "dpw[" + j + "].sdr.inst.ram.INIT_" + id + " = 256'h" + data + ";");
                    continue;
                }
                if (auto2) {
                    tf.writeln("defparam " + pre + "ram" + j + ".INIT_" + id + " = 256'h" + data + ";");
                    continue;
                }
                if (special) {
                    tf.writeln("defparam " + pre + "INIT_" + id + " = 256'h" + data + ";");
                    continue;
                }
                tf.writeln("defparam " + pre + "ram" + j + ".INIT_" + id + " = 256'h" + data + ";");
            }
            i += bper;
            ++l;
        }
        tf.close();
    }

    private void m2vbr() {
        DataFile df = this.MA.getDataFile("P1", "1000", "S#,C#", 0);
        df.open();
        int bytes = (int)df.getDataSize();
        byte[] buf = new byte[bytes];
        df.read(buf, 0, bytes);
        df.close();
        String ram = this.MA.getCS("/RAM", "ram");
        TextFile tf = this.MA.getTextFile("P2");
        tf.open(2);
        int bpa = this.MA.getL("/BPA", df.bpa);
        int bitpa = bpa * 8;
        int i = 0;
        int l = 0;
        while (i < bytes) {
            String data = "  assign " + ram + "[" + l + "] = " + bitpa + "'h";
            data = data + Convert.bb2hex((byte[])buf, (int)i, (int)bpa).substring(2);
            tf.writeln(data + ";");
            i += bpa;
            ++l;
        }
        tf.close();
    }

    private void m2mif() {
        DataFile df = this.MA.getDataFile("P1", "1000", "S#,C#", 0);
        df.open();
        int bytes = (int)df.getDataSize();
        byte[] buf = new byte[bytes];
        df.read(buf, 0, bytes);
        int bpa = this.MA.getL("/BPA", df.bpa);
        int depth = bytes / bpa;
        int bitpa = bpa * 8;
        df.close();
        TextFile tf = this.MA.getTextFile("P2");
        tf.open(2);
        tf.writeln("WIDTH=" + bitpa + ";");
        tf.writeln("DEPTH=" + depth + ";");
        tf.writeln("ADDRESS_RADIX=UNS;");
        tf.writeln("DATA_RADIX=HEX;");
        tf.writeln("CONTENT BEGIN");
        int i = 0;
        int l = 0;
        while (i < bytes) {
            tf.writeln("  " + l + " : " + Convert.bb2hex((byte[])buf, (int)i, (int)bpa).substring(2) + ";");
            i += bpa;
            ++l;
        }
        tf.writeln("END;");
        tf.close();
    }

    private void jvm2xbr() {
        DataFile df = this.MA.getDataFile("P1", "1000", "SI", 0);
        df.open();
        int bytes = (int)df.getDataSize();
        int bper = 32;
        byte[] buf = new byte[bytes];
        byte[] xbuf = new byte[bper];
        df.read(buf, 0, bytes);
        df.close();
        String pre = this.MA.getCS("/PREFIX", "inst") + ".";
        int size = this.MA.getL("/SIZE");
        TextFile tf = this.MA.getTextFile("P2");
        tf.open(2);
        int i = 0;
        int l = 0;
        int ir = 0;
        while (i < size) {
            int ii = 0;
            while (ii < bper) {
                xbuf[ii] = l < bytes ? buf[l] : (byte)0;
                ++ii;
                l += 2;
            }
            String hdata = Convert.bb2hex((byte[])xbuf, (int)0, (int)bper);
            String id = Convert.l2x((int)ir).substring(8);
            tf.writeln("defparam " + pre + "INIT_" + id + " = 256'h" + hdata.substring(2) + ";");
            i += bper;
            ++ir;
        }
        int pbper = 256;
        int i2 = 0;
        int l2 = 1;
        int ir2 = 0;
        while (i2 < size) {
            int ii;
            for (ii = 0; ii < bper; ++ii) {
                xbuf[ii] = 0;
            }
            ii = 0;
            while (ii < pbper) {
                if (l2 < bytes && buf[l2] == 1) {
                    int n = ii >> 3;
                    xbuf[n] = (byte)(xbuf[n] | 1 << (ii & 7));
                }
                ++ii;
                l2 += 2;
            }
            String hdata = Convert.bb2hex((byte[])xbuf, (int)0, (int)bper);
            String id = Convert.l2x((int)ir2).substring(8);
            tf.writeln("defparam " + pre + "INITP_" + id + " = 256'h" + hdata.substring(2) + ";");
            i2 += pbper;
            ++ir2;
        }
        tf.close();
    }

    private void getid() {
        String dev = this.MA.getCS("P1");
        int fd = FileIO.fopen(dev, -1, 0);
        long fid = 0L;
        if (fd > 0) {
            fid = FileIO.fid(fd);
            FileIO.fclose(fd);
        }
        System.out.printf("GetFileId file=%s fd=%d fid=%x\n", dev, fd, fid);
    }

    private void grep() {
        String line;
        String value = "NULL";
        String name = this.MA.getCS("P1");
        TextFile tf = this.MA.getTextFile("P2");
        tf.open(1);
        while (value.equals("NULL") && (line = tf.read()) != null) {
            if (line.indexOf(name) < 0) continue;
            value = line;
        }
        tf.close();
        this.MR.put(this.MA.getU("P3"), (Object)value);
    }

    private void writeRamInit(String name, byte[] buf, int off, int size, int bank, int banks, int banksz) {
        TextFile tf = new TextFile(name);
        tf.open(2);
        int bper = 32;
        Convert.swap4((byte[])buf, (int)off, (int)(size / 4));
        int i = 0;
        int l = 0;
        while (i < size) {
            String id = Convert.l2x((int)l).substring(8);
            for (int j = bank; j < bank + banks; ++j) {
                String data = "";
                for (int k = j - bank; k < 2 * bper / banksz; k += 2) {
                    data = Convert.bb2hex((byte[])buf, (int)(off + i + k * banksz), (int)banksz).substring(2) + data;
                    data = "_" + data;
                }
                data = data.substring(1);
                tf.writeln("defparam ppe.ram" + j + ".INIT_" + id + " = 256'h" + data + ";");
            }
            i += 2 * bper;
            ++l;
        }
        Convert.swap4((byte[])buf, (int)off, (int)(size / 4));
        tf.close();
    }

    private void writeMemInit(String name, byte[] buf, int off, int size, int addr) {
        TextFile tf = new TextFile(name);
        tf.open(2);
        int bper = 8;
        Convert.swap4((byte[])buf, (int)off, (int)(size / 4));
        tf.writeln("@" + Convert.l2x((int)addr).substring(2));
        for (int i = 0; i < size; i += bper * 4) {
            String data = "";
            for (int j = i; j < i + bper * 4; j += 4) {
                data = data + Convert.bb2hex((byte[])buf, (int)(off + j), (int)4).substring(2);
                data = data + " ";
            }
            tf.writeln(data);
        }
        Convert.swap4((byte[])buf, (int)off, (int)(size / 4));
        tf.close();
    }

    private void lst2csp() {
        String line;
        int nrow = this.MA.getL("/ROWS");
        int ncol = this.MA.getL("/COLS", nrow);
        int npin = this.MA.getL("/PINS", ncol * nrow);
        boolean reorder = this.MA.getState("/REORDER");
        if (npin < 0 || nrow < 0) {
            this.M.error("Must specify /ROWS= and /PINS=");
        }
        TextFile tf = this.MA.getTextFile("P1");
        tf.setExt("lst");
        if (!tf.open(1)) {
            this.M.error("Couldnt open " + tf.getURL());
        }
        TextFile xf = this.MA.getTextFile("P1");
        xf.fn.setRoot("symbolpre");
        xf.setExt("csa");
        if (!xf.open(1)) {
            this.M.error("Couldnt open " + xf.getURL());
        }
        TextFile sf = this.MA.getTextFile("P1");
        sf.setExt("csa");
        if (!sf.open(2)) {
            this.M.error("Couldnt open " + sf.getURL());
        }
        TextFile pf = this.MA.getTextFile("P1");
        pf.setExt("lib");
        if (!pf.open(2)) {
            this.M.error("Couldnt open " + pf.getURL());
        }
        String name = tf.fn.getRoot().toUpperCase();
        String[] spin = new String[npin + 1];
        String[] stext = new String[npin + 1];
        int ip = 0;
        while ((line = tf.read()) != null) {
            int ie = line.indexOf(61);
            int i = reorder ? Convert.s2l((String)line.substring(0, ie)) - 1 : ip;
            spin[i] = line.substring(0, ie);
            stext[i] = line.substring(ie + 1);
            ++ip;
        }
        if (ip != npin) {
            this.M.warning((CharSequence)("Number lines=" + ip + " != mnumber pins=" + npin));
            npin = ip;
        }
        int grid = 254000;
        int hgrid = grid / 2;
        int hpin = npin / 2;
        int ix1 = 10;
        int ix2 = ix1 + 40;
        int ixs = ix1 + 2;
        int iy1 = 10;
        int iy2 = iy1 + hpin + 4;
        pf.writeln(name);
        while ((line = xf.read()) != null && !line.equals("XXXX")) {
            sf.writeln(line);
        }
        sf.writeln("  (SYMDEF L0 \"" + name + "\" \"\" (PT " + ixs * grid + " " + (iy2 - 1) * grid + ")");
        sf.writeln("   (FIGURE FIG0 LC25 NO_SHEET (OPENSHAPE");
        sf.writeln("    (PT " + ix1 * grid + " " + iy2 * grid + ")");
        sf.writeln("    (PT " + ix2 * grid + " " + iy2 * grid + ")");
        sf.writeln("    (PT " + ix2 * grid + " " + iy1 * grid + ")");
        sf.writeln("    (PT " + ix1 * grid + " " + iy1 * grid + ")");
        sf.writeln("    (PT " + ix1 * grid + " " + iy2 * grid + ")");
        sf.writeln("   ))");
        sf.writeln("   (TEXTLOC SYMBOL_NAME TC2 (PT " + ixs * grid + " " + (iy2 - 2) * grid + "))");
        sf.writeln("   (TEXTLOC PART_NAME TC2 (PT " + ixs * grid + " " + (iy2 - 3) * grid + "))");
        for (int i = 0; i < npin; ++i) {
            int j = i + 1;
            int ix = i < hpin ? ix1 : ix2;
            int ixt = i < hpin ? ix + 1 : ix - 12;
            int iy = i < hpin ? iy1 + (hpin - i) : iy1 + 1 + (i - hpin);
            sf.writeln("   (TERMINAL " + j + " TC0 (PT " + ix * grid + " " + iy * grid + "))");
            sf.writeln("   (TEXT TX" + j + " \"" + stext[i] + "\" TC2 NO_SHEET (PT " + ixt * grid + " " + (iy * grid - hgrid) + "))");
            int pn = ncol == 1 ? i : this.getPinNumber(spin[i], nrow, ncol);
            this.addLine(pf, "" + pn + ".0");
        }
        sf.writeln("  )");
        while ((line = xf.read()) != null) {
            sf.writeln(line);
        }
        this.flushLine(pf);
        tf.close();
        xf.close();
        sf.close();
        pf.close();
    }

    private void sym2part() {
        Parser p;
        String line;
        int nrow;
        boolean v4 = this.MA.getState("/V4");
        boolean v5 = this.MA.getState("/V5");
        TextFile tf = this.MA.getTextFile("P1");
        tf.setExt(v5 ? "pkg" : (v4 ? "txt" : "pins"));
        if (!tf.open(1)) {
            this.M.error("Couldnt open " + tf.getURL());
        }
        if ((nrow = this.MA.getL("/ROWS")) <= 0) {
            this.M.error("You must specify /ROWS=n for this part up to " + rowlabel.length);
        }
        this.M.info((CharSequence)("Part Rows=" + nrow));
        int npin = nrow * nrow;
        String[] rows = new String[npin + 1];
        while ((line = tf.read()) != null) {
            p = new Parser(line);
            String text = p.get(v5 ? 3 : (v4 ? 6 : 2));
            String spin = p.get(v5 ? 1 : (v4 ? 4 : 3));
            int pin = this.getPinNumber(spin, nrow, nrow);
            if (rows[pin] != null) {
                this.M.error("Got Lpin=" + pin + " Pin=" + spin + " Label=" + text);
            }
            rows[pin] = text;
        }
        tf.close();
        TextFile sf = this.MA.getTextFile("P1");
        sf.setExt("sym");
        if (!sf.open(1)) {
            this.M.error("Couldnt open " + sf.getURL());
        }
        tf = this.MA.getTextFile("P1");
        tf.setExt("lib");
        if (!tf.open(2)) {
            this.M.error("Couldnt open " + tf.getURL());
        }
        while ((line = sf.read()) != null) {
            int i;
            p = new Parser(line);
            if (p.elements() <= 0) continue;
            this.M.info((CharSequence)("Process " + line));
            String text = p.get(1);
            if (text.equals("GLOBAL")) {
                String signal = p.get(2);
                this.flushLine(tf);
                this.addLine(tf, p.get(3));
                for (i = 0; i <= npin; ++i) {
                    if (!signal.equals(rows[i])) continue;
                    this.addLine(tf, "" + i + ".0");
                }
                this.flushLine(tf);
                continue;
            }
            if (text.startsWith("PINS")) {
                for (int i2 = 2; i2 <= p.elements(); ++i2) {
                    String signal = p.get(i2);
                    int pin = this.findPin(signal, rows);
                    if (pin <= 0) {
                        this.M.error("Signal " + signal + " not found");
                    }
                    this.addLine(tf, "" + pin + ".0");
                }
                continue;
            }
            if (!text.startsWith("IOBANK")) continue;
            String bank = p.get(2);
            for (i = 3; i <= p.elements(); ++i) {
                String pin = p.get(i);
                int in = this.findPin("IO_L" + pin + "N_" + bank, rows);
                int ip = this.findPin("IO_L" + pin + "P_" + bank, rows);
                int is = this.findPin("IO_L" + pin + "_" + bank, rows);
                if (is > 0) {
                    this.addLine(tf, "" + is + ".0");
                }
                if (in > 0) {
                    this.addLine(tf, "" + in + ".0");
                }
                if (ip > 0) {
                    this.addLine(tf, "" + ip + ".0");
                }
                if (is < 0 && in < 0) {
                    this.M.error("No pin " + pin + " in bank " + bank);
                }
                if (is > 0 && in > 0) {
                    this.M.error("Bad pin " + pin + " in bank " + bank);
                }
                if (in <= 0 || ip >= 0) continue;
                this.M.error("Mismatch pin " + pin + " in bank " + bank);
            }
        }
        tf.close();
        sf.close();
    }

    private int getPinNumber(String spin, int nrow, int ncol) {
        int irow = nrow;
        for (irow = nrow - 1; irow >= 0 && !spin.startsWith(rowlabel[irow]); --irow) {
        }
        if (irow < 0) {
            return -1;
        }
        int pin = 0;
        for (int i = rowlabel[irow].length(); i < spin.length(); ++i) {
            pin = 10 * pin + (spin.charAt(i) - 48);
        }
        return pin += irow * ncol;
    }

    private String getSPinNumber(int pin, int nrow) {
        int irow = (pin - 1) / nrow;
        int icol = pin - irow * nrow;
        return rowlabel[irow] + icol;
    }

    private void addLine(TextFile tf, String text) {
        if (this.outline.length() > 73) {
            tf.writeln(this.outline + "&");
            this.outline = "";
        }
        this.outline = this.outline + text + " ";
    }

    private void flushLine(TextFile tf) {
        if (this.outline.length() > 0) {
            tf.writeln(this.outline);
        }
        this.outline = "";
    }

    private void net2ucf() {
        String line;
        int nrow;
        String part;
        TextFile tf = this.MA.getTextFile("P1");
        tf.setExt("frs");
        if (!tf.open(1)) {
            this.M.error("Couldnt open " + tf.getURL());
        }
        TextFile sf = this.MA.getTextFile("P1");
        sf.setExt("ucfx");
        if (!sf.open(2)) {
            this.M.error("Couldnt open " + sf.getURL());
        }
        if ((part = this.MA.getS("/PART")).length() <= 0) {
            this.M.error("You must specify /PART=name for this design");
        }
        if ((nrow = this.MA.getL("/ROWS")) <= 0) {
            this.M.error("You must specify /ROWS=n for this part up to " + rowlabel.length);
        }
        this.M.info((CharSequence)("Part=" + part + "  Rows=" + nrow));
        int npin = nrow * nrow;
        String label = null;
        while ((line = tf.read()) != null) {
            String cpart;
            if (line.length() == 0) continue;
            if (line.charAt(0) != '.') {
                line = ".TER " + line;
            }
            Parser p = new Parser(line);
            p.clean();
            String cmd = p.get(1);
            if (cmd.equals(".ADD_TER")) {
                label = p.get(4);
                label = label.substring(1, label.length() - 1);
                int bus = 0;
                int ll = label.length();
                char c = label.charAt(label.length() - 2);
                if (ll > 1 && label.charAt(ll - 1) >= '0' && label.charAt(ll - 1) <= '9') {
                    bus = 1;
                }
                if (bus > 0 && ll > 2 && label.charAt(ll - 2) >= '0' && label.charAt(ll - 2) <= '9') {
                    bus = 2;
                }
                if (bus != 0) {
                    label = label.substring(0, ll - bus) + "<" + label.substring(ll - bus, ll) + ">";
                }
                int i = label.indexOf("<0");
                if (bus == 2 && i > 0) {
                    label = label.substring(0, i + 1) + label.substring(i + 2);
                }
                cmd = ".TER";
            }
            if (!cmd.equals(".TER") || !(cpart = p.get(2)).equals(part)) continue;
            String cpin = p.get(3);
            String spin = this.getSPinNumber(Convert.s2l((String)cpin), nrow);
            this.M.info((CharSequence)("Terminal " + cpart + " " + cpin + " " + label));
            sf.writeln("NET \"" + label.toLowerCase() + "\" LOC = \"" + spin.toLowerCase() + "\" ;");
        }
        tf.close();
        sf.close();
    }

    private int findPin(String text, String[] rows) {
        for (int i = 1; i < rows.length; ++i) {
            if (!this.matchPin(text, rows[i])) continue;
            return i;
        }
        return -1;
    }

    private boolean matchPin(String text, String label) {
        if (label == null) {
            return false;
        }
        return label.indexOf(text) >= 0;
    }

    private void qnet2ucf() {
        String line;
        String part;
        TextFile tf = this.MA.getTextFile("P1");
        tf.setExt("qnet");
        if (!tf.open(1)) {
            this.M.error("Couldnt open " + tf.getURL());
        }
        TextFile sf = this.MA.getTextFile("P1");
        sf.setExt("ucfx");
        if (!sf.open(2)) {
            this.M.error("Couldnt open " + sf.getURL());
        }
        if ((part = this.MA.getS("/PART")).length() <= 0) {
            this.M.error("You must specify /PART=name for this design");
        }
        this.M.info((CharSequence)("Part=" + part));
        String label = null;
        while ((line = tf.read()) != null) {
            String cpart;
            if (line.length() == 0) continue;
            Parser p = new Parser(line);
            p.clean();
            String cmd = p.get(1);
            if (cmd.equals("NET_NAME")) {
                label = null;
                String net = line = tf.read();
                if ((net = net.substring(1, net.length() - 1)).indexOf(".") > 0 || net.startsWith("VCC") || net.startsWith("GND") || net.equals("NC")) continue;
                label = this.convertNet(net);
            }
            if (label == null || !cmd.equals("NODE_NAME") || !(cpart = p.get(2)).equals(part)) continue;
            String cpin = p.get(3);
            this.M.info((CharSequence)("Terminal " + cpart + " " + cpin + " " + label));
            sf.writeln("NET \"" + label.toLowerCase() + "\" LOC = \"" + cpin.toLowerCase() + "\" ;");
        }
        tf.close();
        sf.close();
    }

    private void enet2ucf() {
        String line;
        String part;
        TextFile tf = this.MA.getTextFile("P1");
        tf.setExt("enet");
        if (!tf.open(1)) {
            this.M.error("Couldnt open " + tf.getURL());
        }
        TextFile sf = this.MA.getTextFile("P1");
        sf.setExt("ucfx");
        if (!sf.open(2)) {
            this.M.error("Couldnt open " + sf.getURL());
        }
        if ((part = this.MA.getS("/PART")).length() <= 0) {
            this.M.error("You must specify /PART=name for this design");
        }
        this.M.info((CharSequence)("Part=" + part));
        String lnet = null;
        for (int i = 0; i < 8; ++i) {
            tf.read();
        }
        while ((line = tf.read()) != null) {
            int li;
            if (line.length() < 43) {
                lnet = null;
                continue;
            }
            String net = line.substring(0, 16).trim();
            String prt = line.substring(16, 25).trim();
            String pad = line.substring(25, 34).trim();
            String pin = line.substring(34, 43).trim();
            if (net.length() == 0) {
                net = lnet;
            }
            lnet = net;
            if (!prt.equals(part) || net.indexOf(".") >= 0 || pin.indexOf("VCC") >= 0 || pin.indexOf("VOUT") >= 0 || pin.indexOf("GND") >= 0) continue;
            boolean hasPol = (net = net.toLowerCase()).endsWith("_n") || net.endsWith("_p");
            int ln = hasPol ? net.length() - 2 : net.length();
            boolean hasBus = net.charAt(ln - 1) >= '0' && net.charAt(ln - 1) <= '9';
            boolean hasBut = net.charAt(ln - 2) >= '0' && net.charAt(ln - 2) <= '9';
            int n = li = hasBus ? ln - 1 : ln;
            if (hasBut) {
                --li;
            }
            if (hasPol) {
                net = net.substring(0, li) + net.charAt(ln + 1) + net.substring(li, ln);
            }
            if (hasPol) {
                ++li;
                ++ln;
            }
            if (hasBus) {
                net = net.substring(0, li) + '<' + net.substring(li, ln) + '>';
            }
            this.M.info((CharSequence)("Terminal " + part + " " + pad + " " + net));
            sf.writeln("NET \"" + net.toLowerCase() + "\" LOC = \"" + pad.toLowerCase() + "\" ;");
        }
        tf.close();
        sf.close();
    }

    private String[] getSA(Parser p) {
        int size = p.elements();
        String[] sa = new String[size];
        for (int i = 0; i < size; ++i) {
            String s = p.get(i + 1);
            if (s.length() > 0 && s.charAt(0) == '\"') {
                s = s.substring(1, s.length() - 1);
            }
            sa[i] = s;
        }
        return sa;
    }

    private String subS(String line, String sub) {
        return StringUtil.replaceFirst((String)line, (String)"^", (String)sub);
    }

    private String subS(String line, String sub1, String sub2) {
        return this.subS(this.subS(line, sub1), sub2);
    }

    private String subS(String line, String sub1, String sub2, String sub3) {
        return this.subS(this.subS(this.subS(line, sub1), sub2), sub3);
    }

    private void ucf2xdc() {
        String line;
        String[] san = null;
        TextFile tf = this.MA.getTextFile("P1");
        tf.setExt("ucf");
        if (!tf.open(1)) {
            this.M.error("Couldnt open " + tf.getURL());
        }
        TextFile sf = this.MA.getTextFile("P1");
        sf.setExt("xdc");
        if (!sf.open(2)) {
            this.M.error("Couldnt open " + sf.getURL());
        }
        Object label = null;
        boolean xdcmode = false;
        Table nets = new Table();
        block0: while ((line = tf.read()) != null) {
            if ((line = line.trim()).length() == 0) continue;
            int ic = line.indexOf(59);
            if (ic > 0) {
                line = line.substring(0, ic);
            }
            while (line.indexOf("  ") >= 0) {
                line = StringUtil.replaceAll((String)line, (String)"  ", (String)" ");
            }
            line = StringUtil.replaceAll((String)line, (String)"<", (String)"[");
            line = StringUtil.replaceAll((String)line, (String)">", (String)"]");
            Parser p = new Parser(line);
            String[] sa = this.getSA(p);
            int na = sa.length;
            if (!(san == null || sa[0].equals("TIMESPEC") && sa[3].equals("PERIOD"))) {
                sf.writeln(this.subS("create_generated_clock -name ^ [get_nets ^]", (String)san[4], (String)san[1]));
            }
            san = null;
            if (sa[0].equals("##XDC##")) {
                sf.writeln(line.substring(8));
                continue;
            }
            if (sa[0].equals("##XDCON##")) {
                xdcmode = true;
                continue;
            }
            if (sa[0].equals("##XDCOFF##")) {
                xdcmode = false;
                continue;
            }
            if (xdcmode) {
                sf.writeln(line);
                continue;
            }
            if (sa[0].startsWith("##")) {
                sf.writeln(line.substring(1));
                continue;
            }
            if (sa[1].equals("DCI_CASCADE")) {
                String s = sa[3];
                int i = s.indexOf(" ");
                sf.writeln(this.subS("set_property DCI_CASCADE {^} [get_iobanks ^]", s.substring(0, i), s.substring(i + 1)));
                continue;
            }
            if (sa[2].equals("TNM_NET")) {
                nets.put(sa[4], (Object)sa[1]);
                san = sa;
                continue;
            }
            if (sa[0].equals("TIMESPEC") && sa[3].equals("PERIOD")) {
                double freq = Convert.s2d((String)sa[5], (Object)this.M);
                String nsec = Convert.d2s((double)(1000.0 / freq), (int)0, (String)"##.###");
                String net = nets.getS(sa[4]);
                sf.writeln(this.subS("create_clock -name ^ -period ^ [get_nets ^]", sa[4], nsec, net));
                this.MR.put(sa[1], freq);
                continue;
            }
            if (sa[0].equals("TIMESPEC") && sa[3].equals("FROM") && sa[5].equals("TO") && sa[7].equals("TIG")) {
                sf.writeln(this.subS("set_false_path -from [get_clocks ^] -to [get_clocks ^]", sa[4], sa[6]));
                continue;
            }
            if (sa[0].equals("TIMESPECS") && sa[3].equals("FROM") && sa[5].startsWith("TO")) {
                boolean tof = sa[5].equals("TOFR");
                boolean max = sa[7].equals("MAX");
                boolean tig = sa[7].equals("TIG");
                Parser cq = new Parser(sa[4]);
                Parser cp = new Parser(sa[6]);
                for (int j = 1; j <= cq.elements(); ++j) {
                    String from = cq.get(j);
                    for (int i = 1; i <= cp.elements(); ++i) {
                        String to = cp.get(i);
                        if (to.equals(from)) continue;
                        if (tig) {
                            sf.writeln(this.subS("set_false_path -from [get_clocks ^] -to [get_clocks ^]", from, to));
                        }
                        if (max) {
                            sf.writeln(this.subS("set_max_delay -from [get_clocks ^] -to [get_clocks ^] ^", from, to, sa[8]));
                        }
                        if (!tof) continue;
                        if (tig) {
                            sf.writeln(this.subS("set_false_path -from [get_clocks ^] -to [get_clocks ^]", to, from));
                        }
                        if (!max) continue;
                        sf.writeln(this.subS("set_max_delay -from [get_clocks ^] -to [get_clocks ^] ^", to, from, sa[8]));
                    }
                }
                continue;
            }
            if (sa[0].equals("NET") && sa[2].equals("LOC")) {
                sf.writeln(this.subS("set_property PACKAGE_PIN ^ [get_ports ^]", sa[4].toUpperCase(), sa[1]));
                int i = 5;
                while (i < na) {
                    if (!sa[i].equals("|")) {
                        System.out.println("Bad NET format: " + line + "  //  " + i + " " + sa[i]);
                        continue block0;
                    }
                    int ie = sa[i + 1].indexOf(61);
                    if (ie > 0) {
                        sf.writeln(this.subS("set_property ^ ^ [get_ports ^]", sa[i + 1].substring(0, ie), sa[i + 1].substring(ie + 1), sa[1]));
                        i += 2;
                        continue;
                    }
                    if (i + 2 < na && sa[i + 2].equals("=")) {
                        sf.writeln(this.subS("set_property ^ ^ [get_ports ^]", sa[i + 1], sa[i + 3], sa[1]));
                        i += 4;
                        continue;
                    }
                    sf.writeln(this.subS("set_property ^ TRUE [get_ports ^]", sa[i + 1], sa[1]));
                    i += 2;
                }
                continue;
            }
            if (sa[0].equals("NET") && sa[2].equals("TIG")) {
                if (sa[1].indexOf(42) < 0) {
                    sf.writeln(this.subS("set_false_path -through [get_nets -match_style ucf ^]", sa[1]));
                    continue;
                }
                sf.writeln(this.subS("set_false_path -through [get_nets -match_style ucf ^]", sa[1]));
                continue;
            }
            if (sa[0].equals("NET") && sa[2].equals("USELOWSKEWLINES")) {
                sf.writeln("##UCF? " + line);
                continue;
            }
            if (sa[0].equals("NET")) {
                int ie = sa[2].indexOf(61);
                if (ie > 0) {
                    sf.writeln(this.subS("set_property ^ ^ [get_nets ^]", sa[2].substring(0, ie), sa[2].substring(ie + 1), sa[1]));
                    continue;
                }
                sf.writeln(this.subS("set_property ^ ^ [get_nets ^]", sa[2], sa[3], sa[1]));
                continue;
            }
            if (sa[0].equals("INST") && sa[2].equals("LOC")) {
                sf.writeln(this.subS("set_property LOC ^ [get_cells ^]", sa[4], sa[1]));
                continue;
            }
            if (sa[0].equals("INST") && sa[2].equals("AREA_GROUP")) {
                sf.writeln(this.subS("create_pblock ^", sa[4]));
                sf.writeln(this.subS("add_cells_to_pblock [get_pblocks ^] [get_cells -quiet [list ^]]", sa[4], sa[1]));
                continue;
            }
            if (sa[0].equals("AREA_GROUP") && sa[2].equals("RANGE")) {
                sf.writeln(this.subS("resize_pblock [get_pblocks ^] -add {^}", sa[1], sa[4]));
                continue;
            }
            if (sa[0].equals("INST") && sa[2].equals("RANGE")) {
                sf.writeln(this.subS("set_property RANGE ^ [get_cells ^]", sa[4], sa[1]));
                continue;
            }
            System.out.print("SA [ ");
            for (int i = 0; i < na; ++i) {
                System.out.print(sa[i] + " ");
            }
            System.out.println("]");
            sf.writeln("##UCF? " + line);
        }
        tf.close();
        sf.close();
    }

    private String convertNet(String net) {
        char c;
        int i;
        boolean tnum;
        int len = net.length();
        boolean bl = tnum = net.charAt(len - 2) >= '0' && net.charAt(len - 2) <= '9';
        if (net.endsWith("+") || net.endsWith("P") && tnum) {
            net = net.substring(0, len - 2) + "P" + net.charAt(len - 2);
        }
        if (net.endsWith("-") || net.endsWith("N") && tnum) {
            net = net.substring(0, len - 2) + "N" + net.charAt(len - 2);
        }
        for (i = len; i > 0 && (c = net.charAt(i - 1)) >= '0' && c <= '9'; --i) {
        }
        if (i != len && len - i < 4) {
            net = net.substring(0, i) + "<" + net.substring(i) + ">";
        }
        if (net.startsWith("DDR2_")) {
            net = "M" + net.substring(5);
        }
        return net;
    }

    boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    boolean isAlphaP(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '!';
    }

    boolean isAlphaN(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '!' || c >= '0' && c <= '9';
    }

    boolean compare(KeyVector kv, String key1, String test, String key2) {
        Object key2o;
        Object key1o = kv.get(key1);
        if (key1o != null) {
            key1 = key1o.toString();
        }
        if ((key2o = kv.get(key2)) != null) {
            key2 = key2o.toString();
        }
        if (test.equals("==")) {
            return key1.equals(key2);
        }
        if (test.equals("!=")) {
            return !key1.equals(key2);
        }
        if (test.equals(">=")) {
            return Convert.s2d((String)key1) >= Convert.s2d((String)key2);
        }
        if (test.equals("<=")) {
            return Convert.s2d((String)key1) <= Convert.s2d((String)key2);
        }
        if (test.equals(">")) {
            return Convert.s2d((String)key1) > Convert.s2d((String)key2);
        }
        if (test.equals("<")) {
            return Convert.s2d((String)key1) < Convert.s2d((String)key2);
        }
        this.M.warning((CharSequence)("Illegal test in VPP define: " + key1 + " " + test + " " + key2));
        return false;
    }

    boolean isDefine(KeyVector kv, String key, String rest) {
        Parser p = null;
        int elem = 1;
        if (rest != null) {
            p = new Parser(key + " " + rest, true, false);
            elem = p.elements();
        }
        boolean state = false;
        for (int i = 1; i <= elem; ++i) {
            boolean isA;
            boolean togglen;
            String keyn = p == null ? key : p.get(i);
            boolean bl = togglen = keyn.startsWith("!") && !keyn.equals("!=");
            if (togglen) {
                keyn = keyn.substring(1);
            }
            if (isA = this.isAlpha(keyn.charAt(0))) {
                state = kv.findKey(keyn) >= 0 ^ togglen;
                continue;
            }
            if (keyn.equals("||") || keyn.equals("|")) {
                if (!state) continue;
                break;
            }
            if (keyn.equals("&&") || keyn.equals("&")) {
                if (state) continue;
                break;
            }
            state = this.compare(kv, p.get(i - 1), keyn, p.get(i + 1));
            ++i;
        }
        return state;
    }

    private void vppfile(KeyVector kv, TextFile tf, TextFile tfo) {
        boolean isOut = tfo != null;
        FileName fn = tf.getFileName();
        boolean isV = fn.getExt().equals("v");
        if (!tf.open(1)) {
            this.M.error("Couldnt open " + tf.getURL());
        }
        if (isOut) {
            if (!tfo.open(2)) {
                this.M.error("Couldnt open " + tfo.getURL());
            }
        }
        String line = null;
        int iflev = 0;
        int[] ifdef = new int[16];
        ifdef[0] = 1;
        while ((line = tf.read()) != null) {
            int cl = 32;
            int il = line.length();
            int ic = line.indexOf("//");
            boolean isPP = false;
            for (int i = 0; i < il; ++i) {
                char c = line.charAt(i);
                if (ic >= 0 && i >= ic) break;
                if (this.isAlpha(c)) {
                    int ib = i++;
                    while (i < il && this.isAlphaN(line.charAt(i))) {
                        ++i;
                    }
                    String token = line.substring(ib, i);
                    if (cl == 96 || cl == 35) {
                        String rest;
                        int i2;
                        int i1;
                        isPP = true;
                        for (i1 = i; i1 < il && !this.isAlphaP(line.charAt(i1)); ++i1) {
                        }
                        for (i2 = i1; i2 < il && this.isAlphaN(line.charAt(i2)); ++i2) {
                        }
                        String key = i2 > i1 ? line.substring(i1, i2) : "";
                        String string = rest = i2 < il ? line.substring(i2).trim() : null;
                        if (token.equals("define") && rest == null && cl == 35) {
                            rest = "NULL";
                        }
                        int cid = ifdef[iflev];
                        if (token.equals("define")) {
                            if (ifdef[iflev] == 1 && rest != null) {
                                kv.put(key, (Object)(rest.equals("NULL") ? "" : rest));
                            }
                        } else if (token.equals("undef")) {
                            if (ifdef[iflev] == 1) {
                                kv.remove(key);
                            }
                        } else if (token.equals("if")) {
                            ifdef[++iflev] = cid <= 0 ? -1 : (this.isDefine(kv, key, rest) ? 1 : 0);
                        } else if (token.equals("ifdef")) {
                            ifdef[++iflev] = cid <= 0 ? -1 : (this.isDefine(kv, key, rest) ? 1 : 0);
                        } else if (token.equals("ifndef")) {
                            ifdef[++iflev] = cid <= 0 ? -1 : (!this.isDefine(kv, key, rest) ? 1 : 0);
                        } else if (token.equals("else")) {
                            ifdef[iflev] = ifdef[iflev] == 0 ? 1 : 0;
                        } else if (token.equals("elif")) {
                            ifdef[iflev] = ifdef[iflev] != 0 ? -1 : (this.isDefine(kv, key, rest) ? 1 : 0);
                        } else if (token.equals("elsif")) {
                            ifdef[iflev] = ifdef[iflev] != 0 ? -1 : (this.isDefine(kv, key, rest) ? 1 : 0);
                        } else if (token.equals("endif")) {
                            --iflev;
                        } else {
                            isPP = false;
                        }
                        if (token.equals("include") && ifdef[iflev] > 0 && line.indexOf("mdefs_user") > 0) {
                            String ufn = fn.getFullName().replace("mdefs", "mdefs_user");
                            this.vppfile(kv, new TextFile(ufn), null);
                        }
                    } else {
                        Object val2;
                        Object val = kv.get(token);
                        Object object = val2 = val == null ? null : kv.get(val.toString());
                        if (val != null && val2 == null && (!isPP || token.endsWith("_CPP"))) {
                            line = line.substring(0, ib) + val + line.substring(i);
                            il = line.length();
                            i = ib + val.toString().length();
                        }
                        if (token.equals("CARD_CPP") && val2 == null) {
                            line = line + "\n`define " + token.replace("CARD_CPP", "ICE_CARD") + " \"" + val + "\"";
                        }
                    }
                    cl = 32;
                    continue;
                }
                if (c == ' ') continue;
                cl = c;
            }
            if (!isOut || !isV && (isPP || ifdef[iflev] != 1)) continue;
            tfo.writeln(line);
        }
        if (tf != null) {
            tf.close();
        }
        if (tfo != null) {
            tfo.close();
        }
    }

    private void vppflow() {
        KeyVector kv = KeyVector.fromString((String)this.MA.getCS("/PREDEFS"));
        if (this.MA.isPresent("/MDEFS")) {
            this.vppfile(kv, this.MA.getTextFile("/MDEFS"), null);
        }
        this.vppfile(kv, this.MA.getTextFile("P1"), this.MA.getTextFile("P2"));
    }

    private void tppflow() {
        KeyVector kv = KeyVector.fromString((String)this.MA.getCS("/DEFINES"));
        kv.add("NMVERSION", (Object)this.MR.getS("ENV.NMVERSION"));
        kv.add("HOSTNAME", (Object)this.MR.getS("ENV.HOSTNAME"));
        kv.add("USER", (Object)this.MR.getS("ENV.USER"));
        boolean dbg = this.MA.getState("/DEBUG");
        TextFile tfx = new TextFile(dbg ? "/tmp/snapapp_pp" : "ram:snapapp_pp");
        this.vppfile(kv, this.MA.getTextFile("P1"), tfx);
        this.MR.put(this.MA.getU("P2"), (Object)new Table(tfx));
        if (!dbg) {
            this.M.pipes.remove("snapapp_pp");
        }
    }

    private void jtag2m() {
        int nbuf;
        int lbuf = 32768;
        int offset = 0;
        int ibits = 0;
        int obits = 0;
        int iwords = 0;
        int owords = 0;
        int tdiw = 0;
        int tdow = 0;
        int state = 21;
        boolean oot = this.MA.getState("/OOT");
        boolean tot = this.MA.getState("/TOT");
        BaseFile bf = this.MA.getBaseFile("P1");
        bf.open(1);
        byte[] buf = new byte[lbuf];
        DataFile dfc = this.MA.getDataFile("P2", "1000", "5L", 0);
        dfc.open(2);
        Data dfcb = dfc.getDataBuffer(1);
        DataFile dfi = this.MA.getDataFile("P3", "1000", "SL", 0);
        dfi.open(2);
        Data dfib = dfi.getDataBuffer(lbuf);
        DataFile dfo = this.MA.getDataFile("P4", "1000", "SL", 0);
        dfo.open(2);
        Data dfob = dfo.getDataBuffer(lbuf);
        for (int size = (int)bf.getSize(); size > 0; size -= nbuf) {
            nbuf = Math.min(lbuf, size);
            bf.read(buf, 0, nbuf);
            for (int i = 0; i < nbuf; ++i) {
                byte data = buf[i];
                boolean tdi = (data & 1) != 0;
                boolean tdo = (data & 2) != 0;
                boolean tms = (data & 4) != 0;
                tdiw >>>= 1;
                if (tdi) {
                    tdiw |= Integer.MIN_VALUE;
                }
                tdow >>>= 1;
                if (tdo) {
                    tdow |= Integer.MIN_VALUE;
                }
                if (++ibits == 32) {
                    dfib.setL(iwords, tdiw);
                    ++iwords;
                    ibits = 0;
                }
                if (++obits == 32) {
                    dfob.setL(owords, tdow);
                    ++owords;
                    obits = 0;
                }
                switch (state) {
                    case 0: {
                        if (!tms) break;
                        ++state;
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (tms) {
                            ++state;
                            break;
                        }
                        state += 10;
                        break;
                    }
                    case 3: {
                        if (tms) break;
                        state = 0;
                        break;
                    }
                    case 11: 
                    case 12: {
                        owords = 0;
                        iwords = 0;
                        obits = 0;
                        ibits = 0;
                        tdow = 0;
                        tdiw = 0;
                        if (oot) {
                            obits = -1;
                        }
                        if (tot) {
                            ibits = -1;
                        }
                        state += 10;
                        break;
                    }
                    case 21: 
                    case 22: {
                        int shift;
                        if (!tms) break;
                        if (ibits != 0) {
                            shift = 32 - ibits;
                            tdiw >>>= shift;
                        }
                        if (obits != 0) {
                            shift = 32 - obits;
                            tdow >>>= shift;
                        }
                        dfcb.setL(0, state - 20);
                        dfcb.setL(1, ibits);
                        dfcb.setL(2, iwords);
                        dfcb.setL(3, tdiw);
                        dfcb.setL(4, tdow);
                        dfc.write(dfcb);
                        if (iwords > 0) {
                            dfi.write(dfib, iwords);
                        }
                        if (owords > 0) {
                            dfo.write(dfob, owords);
                        }
                        state = -3;
                        break;
                    }
                    case -3: {
                        state = 0;
                        break;
                    }
                    default: {
                        this.M.error("Illegal State " + state + " at " + offset);
                    }
                }
                ++offset;
            }
        }
        bf.close();
        dfc.close();
        dfi.close();
        dfo.close();
    }

    public void gerber() {
        String line;
        TextFile tfi = this.MA.getTextFile("P1");
        if (!tfi.open(1)) {
            this.M.error("Opening input URL=" + tfi.getURL());
        }
        this.M.info((CharSequence)("Opened gerber input URL=" + tfi.getURL()));
        TextFile tfo = this.MA.getTextFile("P2");
        if (!tfo.open(2)) {
            this.M.error("Opening output URL=" + tfo.getURL());
        }
        tfo.writeln("! GAPFile Version 1.0");
        tfo.writeln("! Created by: NeXtMidas 4.1.4");
        tfo.writeln("GAPFile    Version 1.0    (c) 1991 CAD Solutions, Inc.");
        tfo.writeln("!     Type            Width          Length     Rotate   Offset      Swap  Tool      Size      Legend");
        tfo.writeln("!                English  Metric English  Metric     English  Metric Code  No. English  Metric");
        tfo.writeln("|-----------------------+---------------+-------------------+-------------------------+--------------");
        while ((line = tfi.read()) != null) {
            char c;
            Parser p = new Parser(line, true);
            String pos = p.get(1);
            if (pos == null || pos.length() == 0 || (c = pos.charAt(0)) < '0' || c > '9') continue;
            String shape = p.get(2);
            String usage = p.get(3);
            double size = Convert.s2d((String)p.get(4));
            int orient = Convert.s2l((String)p.get(5));
            double length = Convert.s2d((String)p.get(6));
            if (shape.equals("CIRCLE")) {
                shape = "ROUND";
            }
            if (shape.equals("ANNULUS")) {
                shape = "DONUT";
                length = orient;
                orient = 0;
            }
            if (shape.equals("FINGER")) {
                shape = "OBLONG";
            }
            if (shape.equals("BULLET")) {
                shape = "OBLONG";
            }
            if (shape.equals("DIAMOND")) {
                shape = "SQUARE";
            }
            if (shape.equals("RECTANGLE") || shape.equals("OBLONG")) {
                length += size;
                if (orient == 0 || orient == 180) {
                    double t = size;
                    size = length;
                    length = t;
                }
            }
            String dcode = "D" + pos;
            Double dsize = new Double(size);
            Double esize = new Double(size * e2m);
            Double dlength = new Double(length);
            Double elength = new Double(length * e2m);
            Integer iorient = new Integer(0);
            Integer izero = new Integer(0);
            Double dzero = new Double(0.0);
            Object[] args = new Object[]{dcode, shape, dsize, esize, dlength, elength, iorient, dzero, dzero, dcode, izero, dzero, dzero, izero};
            String s = String.format(form, args);
            System.out.println(s);
            tfo.writeln(s);
        }
        tfi.close();
        tfo.close();
        this.M.info((CharSequence)("Closed GAP output URL=" + tfo.getURL()));
    }

    private void crcgen() {
        int b;
        int size = this.MA.getL("P1", 32);
        int poly = this.MA.getL("P2", 79764919);
        int seed = this.MA.getL("P3", -1);
        int bits = this.MA.getL("P4", 32);
        int data = this.MA.getL("P5", 0);
        String label = this.MA.getU("P6");
        boolean flip = this.MA.getState("/FLIP");
        boolean comp = this.MA.getState("/COMP");
        boolean eqn = this.MA.getState("/EQN");
        boolean red = this.MA.getState("/RED");
        String[] eqs = new String[size];
        int crc = seed;
        int sizem = size - 1;
        int mask = size == 32 ? -1 : (1 << size) - 1;
        int maskm = mask & 0xFFFFFFFE;
        int polym = poly & 0xFFFFFFFE;
        if (eqn) {
            for (b = 0; b < size; ++b) {
                eqs[b] = "C" + b;
            }
        }
        for (int i = 0; i < bits; ++i) {
            int val = (data >> i ^ crc >> sizem) & 1;
            crc = crc << 1 & maskm | val;
            if (val != 0) {
                crc ^= polym;
            }
            if (!eqn) continue;
            String a = eqs[sizem] + "^D" + i;
            for (int b2 = sizem; b2 > 0; --b2) {
                eqs[b2] = eqs[b2 - 1];
                if ((poly >> b2 & 1) == 0) continue;
                int n = b2;
                eqs[n] = eqs[n] + "^" + a;
            }
            eqs[0] = a;
        }
        if (flip) {
            int crcf = 0;
            for (int i = 0; i < size; ++i) {
                if ((crc >> i & 1) == 0) continue;
                crcf |= 1 << (i ^ 7);
            }
            crc = crcf;
        }
        if (comp) {
            crc ^= mask;
        }
        this.MT.writeln((CharSequence)("CRC size=" + size + " mask=" + Convert.l2x((int)maskm) + " polym=" + Convert.l2x((int)polym)));
        this.MT.writeln((CharSequence)("CRC in=" + Convert.l2x((int)seed) + " data=" + Convert.l2x((int)data) + " out=" + Convert.l2x((int)crc)));
        this.MR.put(label, crc);
        this.evalcrc = 0;
        if (red) {
            for (b = 0; b < size; ++b) {
                eqs[b] = this.reduceEqs(bits, data, eqs[b], b);
            }
        }
        if (eqn) {
            for (b = 0; b < size; ++b) {
                this.MT.writeln((CharSequence)("crc[" + b + "]<=" + eqs[b]));
            }
        }
        if (red) {
            this.MT.writeln((CharSequence)("CRC eval=" + Convert.l2x((int)this.evalcrc)));
        }
    }

    private String reduceEqs(int bits, int data, String eqs, int b) {
        int c;
        eqs = eqs + "^";
        int n = 0;
        for (c = 0; c < eqs.length(); ++c) {
            if (eqs.charAt(c) != 'C') continue;
            ++n;
        }
        String out = "C" + n % 2;
        int ones = n;
        for (int i = 0; i < bits; ++i) {
            String patt = "D" + i + "^";
            int plen = patt.length();
            n = 0;
            for (c = 0; c < eqs.length(); ++c) {
                if (!eqs.regionMatches(c, patt, 0, plen)) continue;
                ++n;
            }
            if (n % 2 == 1) {
                out = out + "^d[" + i + "]";
            }
            if (n % 2 != 1 || (data >> i & 1) != 1) continue;
            ++ones;
        }
        if (ones % 2 == 1) {
            this.evalcrc |= 1 << b;
        }
        return out + ";";
    }

    private void modargs() {
        Args args1 = Args.parseCommand((Midas)this.M, (String)this.MA.getS(2));
        Args args2 = (Args)this.MA.getO(3);
        args2.getKV().clear();
        args2.getKV().merge((Keyable)args1.getKV());
        args2.nargs = args1.nargs;
        args2.nargsx = args1.nargsx;
    }

    private void browse() {
        FileName fn = this.MA.getFileName(2);
        try {
            URL url = new URL("file:" + fn.getFullName());
            MJFrame mjf = new MJFrame("ICE Documentation Browser", new MBox(100, 100, 800, 800));
            MWB mw = new MWB(mjf);
            mjf.setMWindow((MWindow)mw);
            MJBrowser mjb = new MJBrowser();
            mjf.add((Component)mjb);
            mjb.showDocument(url);
            mjf.display(1);
        }
        catch (Exception e) {
            System.out.println("Browser: " + e);
        }
    }

    private void tput() {
        Table tbl = this.MA.getTable("P1");
        DataFile hcb = this.MA.getDataFile("P2");
        hcb.open(1027);
        Table.Iterator ti = tbl.iterator();
        while (ti.getNext()) {
            hcb.keywords.put(ti.key, ti.value);
        }
        hcb.close();
    }

    private void scanup() {
        DataFile hi = this.MA.getDataFile("P1");
        DataFile ho = this.MA.getDataFile("P2");
        hi.open(1);
        ho.open(3);
        int nhi = (int)hi.getSize();
        int bpei = (int)hi.getBPE();
        int nho = (int)ho.getSize();
        int bpeo = (int)ho.getBPE();
        double scf = hi.keywords.getD("RFCF", -1.0);
        double sbw = hi.keywords.getD("RFBW", -1.0);
        double sbwh = sbw * 0.4;
        Data dbi = hi.getDataBuffer(nhi);
        Data dbo = ho.getDataBuffer(nho);
        hi.read(dbi);
        ho.read(dbo);
        for (int o = 0; o < nho; ++o) {
            boolean inband;
            int offo = o * bpeo;
            float cfo = Convert.unpackF((byte[])dbo.buf, (int)(offo + 4));
            float bwo = Convert.unpackF((byte[])dbo.buf, (int)(offo + 8));
            float bwoh = bwo * 0.4f;
            boolean bl = inband = (double)cfo > scf - sbwh && (double)cfo < scf + sbwh;
            if (!inband) continue;
            int lhit = Convert.unpackL((byte[])dbo.buf, (int)(offo + 0));
            int hit = 0;
            float snr = 0.0f;
            float cfi = 0.0f;
            float bwi = 0.0f;
            for (int i = 0; i < nhi && hit == 0; ++i) {
                int offi = i * bpei;
                cfi = Convert.unpackF((byte[])dbi.buf, (int)(offi + 4));
                bwi = Convert.unpackF((byte[])dbi.buf, (int)(offi + 8));
                snr = Convert.unpackF((byte[])dbi.buf, (int)(offi + 12));
                if (!(cfi > cfo - bwoh) || !(cfi < cfo + bwoh)) continue;
                hit = 1;
            }
            Convert.packL((byte[])dbo.buf, (int)(offo + 0), (int)hit);
            if (hit > 0) {
                Convert.packF((byte[])dbo.buf, (int)(offo + 12), (float)snr);
            }
            if (hit == lhit) continue;
            this.M.info((CharSequence)("Track INDX=" + o + " FREQ=" + cfo + " BW=" + bwo + " SNR=" + snr + " UP=" + hit));
        }
        ho.seek(0.0);
        ho.write(dbo);
        ho.close();
        hi.close();
    }

    private void greplog() {
        DataFile hi = this.MA.getDataFile("P1");
        hi.open();
        DataFile ho = this.MA.getDataFile("P2", hi, 0);
        ho.open();
        String ptype = this.MA.getS("P3");
        Data db = hi.getDataBuffer(1);
        int size = (int)hi.getSize();
        for (int i = 0; i < size; ++i) {
            hi.read(db);
            String stype = Convert.unpackS((byte[])db.buf, (int)24, (int)8);
            if (ptype.indexOf(stype) < 0) continue;
            ho.write(db);
        }
        ho.close();
        hi.close();
    }

    private void kvi() {
        KeyVector kv = (KeyVector)this.MA.getTable("P1").getCore();
        int index = this.MA.getL("P2");
        String resname = this.MA.getU("P3");
        this.MR.put(resname, kv.getIndex(index));
    }

    static {
        rowlabel = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "L", "M", "N", "P", "R", "T", "U", "V", "W", "Y", "AA", "AB", "AC", "AD", "AE", "AF", "AG", "AH", "AJ", "AK", "AL", "AM", "AN", "AP", "AR", "AT", "AU", "AV", "AW", "AY", "BA", "BB"};
        e2m = 0.0254;
        form = "%-6s%-10s%8.2f%8.3f%8.2f%8.3f%4d%8.2f%8.3f  %-6s%2d%8.2f%8.3f  D%1d";
    }

    private class MWB
    extends MWindow {
        MJFrame mjf;

        public MWB(MJFrame mjf) {
            this.mjf = mjf;
        }

        public int process(String name, int info, Object data) {
            if (name.equals("WINDOW") && info == 0) {
                this.mjf.display(-3);
            }
            return 0;
        }
    }
}

