/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.ICEPacket;
import nxm.ice.lib.TimeCode;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.SDDSPacket;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class icetc
extends Primitive {
    private final String funcList = "Top,Extract,Insert,Select";
    private final int TOP = 1;
    private final int EXTRACT = 2;
    private final int INSERT = 3;
    private final int SELECT = 4;
    private DataFile hi;
    private DataFile ho;
    private ICEPacket pkt;
    private ICEPacket hpkt;
    private SDDSPacket spkt;
    private Data dbi;
    private Data dbo;
    private int func;
    private int nchn;
    private int ichn;
    private TimeCode tc = new TimeCode();
    private Time time = new Time();
    private Time timeTop = new Time();
    private Time timeZero;
    private int ndo;
    private int hack;
    private int xper;
    private int tag;
    private int ltag;
    private int seq;
    private int nseq = -1;
    private int seqerr = 0;
    private double delta;
    private double tolr;
    private boolean test;
    private boolean nopkt;
    private boolean gap;
    private boolean tic;
    private double exprate = 1.0;
    private double drift = 0.0;
    private double driftOffset = 0.0;
    private static final double tag2time = 1.4992503748125937E-8;
    private final String selList = "MinMax,NearLE,NearGE";
    private final int MINMAX = 1;
    private final int NEARLE = 2;
    private final int NEARGE = 3;
    private int selMode;
    private static final int TCS = 11;
    private static final int TCO = 12;
    private static final int TCWS = 13;

    public int open() {
        this.func = this.MA.getSelectionIndex("FUNC", "Top,Extract,Insert,Select", 0);
        this.nchn = this.MA.getL("/NCHN", 1);
        this.ichn = this.MA.getL("/ICHN");
        this.test = this.MA.getState("/TEST");
        this.gap = this.MA.getState("/GAP");
        this.tic = this.MA.getState("/TIC");
        this.verbose = this.MA.getState("/VERBOSE");
        this.selMode = this.MA.getSelectionIndex("/SELMODE", "MinMax,NearLE,NearGE", 0);
        this.hi = this.MA.getDataFile("IN", "1000,3000", "SB,SI,CI,NH", 0);
        this.hi.open(1);
        String mode = this.MA.getS("MODE");
        if (mode.equals("SDDS")) {
            this.spkt = (SDDSPacket)this.hi.getPacketHandler();
        } else if (!mode.equals("ICE")) {
            this.tc.setMode(mode);
        } else if (this.hi.typeClass == 3) {
            this.hpkt = new ICEPacket();
        } else {
            this.pkt = (ICEPacket)this.hi.getPacketHandler();
        }
        this.nopkt = this.pkt == null && this.hpkt == null && this.spkt == null;
        this.xfer = 8192;
        if (this.hpkt != null) {
            this.xfer = 1;
        }
        if (this.pkt != null) {
            this.xfer = this.pkt.getFixedSize();
        }
        if (this.spkt != null) {
            this.xfer = 1024 / this.hi.getBPS();
        }
        this.xper = this.xfer = this.MA.getL("/TL", this.xfer);
        this.delta = this.hi.getDelta();
        if (this.hpkt != null) {
            String fs = this.hi.keywords.getMain("FS");
            if (fs != null) {
                this.xper = Convert.s2l((String)fs);
            }
            this.delta /= (double)this.xper;
        }
        this.delta = this.MA.getD("/DELTA", this.delta);
        this.dbi = this.hi.getDataBuffer(this.xfer);
        this.hack = this.tc.getHack(this.delta);
        this.tolr = this.MA.getD("/TOLR", 1.0E-7);
        if (this.func == 3) {
            this.ho = this.MA.getDataFile("OUT", this.hi, 0);
            this.ho.open(2);
            this.time = this.MA.getTime("TIME", this.hi.getTime());
            this.tc.setTime(this.time);
            this.ho.setTime(this.time);
            this.ndo = this.tc.nextHack(this.delta);
        } else if (this.func == 4) {
            this.ho = this.MA.getDataFile("OUT", this.hi, 0);
            this.ho.open(2);
            this.time = this.MA.getTime("TIME");
            this.tc.setTime(this.time);
            this.ho.setTime(this.time);
        } else {
            this.ho = this.MA.getDataFile("OUT", "3000", "NH", 0);
            this.ho.setSubRecords("OFF|SD,WSEC|SD,FSEC|SD,DIFF|SD");
            if (this.gap) {
                this.ho.setSubRecords("+GAP|SD");
            }
            this.ho.setXDelta(this.delta * (double)this.xper);
            this.ho.open(2 | 0x40);
            this.MR.put(this.MA.getU("TIME"), (Object)this.time);
            this.dbo = this.ho.getDataBuffer(1);
            this.ndo = this.xfer;
        }
        return 0;
    }

    public int process() {
        int n = 0;
        if (this.func == 3) {
            if (this.ndo == 0) {
                n = this.hi.read(this.dbi, 128);
                if (n < 0) {
                    return 9;
                }
                this.tc.setTimeCodeWords(this.dbi.buf, 0, n);
                this.ndo = this.tc.nextHack(this.delta) - n;
                this.ho.write(this.dbi, n);
            }
            if ((n = this.hi.read(this.dbi, Math.min(this.ndo, this.xfer))) < 0) {
                return 9;
            }
            this.tc.setFillWords(this.dbi.buf, 0, n);
            this.ho.write(this.dbi, n);
            this.ndo -= n;
        } else {
            if (this.func == 4) {
                double timeSearch = this.time.toJ1950();
                int numRows = (int)this.hi.getNumberOfRows();
                int indBeg = this.determineFileMin(0, numRows - 1);
                if (indBeg < 0) {
                    throw new MidasException("Error! The input file has no valid times");
                }
                int indEnd = this.determineFileMax(indBeg, numRows - 1);
                double timeMin = this.getTimeFile(indBeg);
                double timeMax = this.getTimeFile(indEnd);
                boolean timeValid = timeSearch > timeMin && timeSearch < timeMax;
                int currInd = -1;
                switch (this.selMode) {
                    case 2: {
                        if (!timeValid) {
                            this.M.warning((CharSequence)"****************************************************************");
                            this.M.warning((CharSequence)"** Start time is not inside the file boundaries!");
                            this.M.warning((CharSequence)("** File range: " + this.timeString(timeMin) + " -> " + this.timeString(timeMax)));
                            this.M.warning((CharSequence)"** Defaulting to the first valid index! ");
                            this.M.warning((CharSequence)"** Use /SELMODE=MINMAX  with icetc to determine valid times!");
                            this.M.warning((CharSequence)"****************************************************************");
                            currInd = indBeg;
                        } else {
                            currInd = this.searchRec(timeSearch, indBeg, indEnd);
                        }
                        Table tabInsert = this.hi.getDataTable((double)currInd);
                        this.ho.setData(0.0, tabInsert);
                        break;
                    }
                    case 3: {
                        if (!timeValid) {
                            this.M.warning((CharSequence)"****************************************************************");
                            this.M.warning((CharSequence)"** End time is not inside the file boundaries!");
                            this.M.warning((CharSequence)("** File range: " + this.timeString(timeMin) + " -> " + this.timeString(timeMax)));
                            this.M.warning((CharSequence)"** Defaulting to the last valid index! ");
                            this.M.warning((CharSequence)"** Use /SELMODE=MINMAX  with icetc to determine valid times!");
                            this.M.warning((CharSequence)"****************************************************************");
                            currInd = indEnd;
                        } else {
                            currInd = this.searchRec(timeSearch, indBeg, indEnd) + 1;
                        }
                        Table tabInsert = this.hi.getDataTable((double)currInd);
                        this.ho.setData(0.0, tabInsert);
                        break;
                    }
                    default: {
                        Table tabInsert = this.hi.getDataTable((double)indBeg);
                        this.ho.setData(0.0, tabInsert);
                        tabInsert = this.hi.getDataTable((double)indEnd);
                        this.ho.setData(1.0, tabInsert);
                    }
                }
                return 9;
            }
            double offset = this.hi.getOffset();
            n = this.hi.read(this.dbi, this.xfer);
            if (n < 0) {
                return 9;
            }
            if (this.nchn > 0) {
                offset /= (double)this.nchn;
            }
            if (this.hpkt != null) {
                System.arraycopy(this.dbi.buf, 0, this.hpkt.buf, 0, 64);
                int tcstat = this.hpkt.getTC(this.tc.time, offset, 0.0);
                int count = this.hpkt.getCount();
                int elem = this.hpkt.getSize();
                int chan = this.hpkt.getChannel();
                if (this.ichn >= 0 && chan != this.ichn) {
                    return 0;
                }
                if (this.verbose) {
                    this.MT.writeln((CharSequence)this.hpkt.listHeader());
                }
                if (tcstat <= 0) {
                    return 0;
                }
                if (this.xper == 1) {
                    this.xper = elem;
                }
                if (elem != this.xper) {
                    this.M.info((CharSequence)("Packet size=" + this.xper + " change to " + elem));
                    this.xper = elem;
                }
                if (count == 0 && offset != 0.0) {
                    this.M.info((CharSequence)("Packet count restart at " + offset));
                    this.drift = 0.0;
                    this.driftOffset = this.ho.getOffset();
                    this.timeZero = null;
                }
                offset = this.hpkt.getTCO() + (double)count * (double)elem;
            } else if (this.pkt != null) {
                int tcstat = this.pkt.getTC(this.tc.time, offset, 0.0);
                int chan = this.pkt.getChannel();
                if (this.ichn >= 0 && chan != this.ichn) {
                    return 0;
                }
                if (this.verbose) {
                    this.MT.writeln((CharSequence)this.pkt.listHeader());
                }
                if (tcstat <= 0) {
                    return 0;
                }
                offset += this.pkt.getTCO();
            } else if (this.spkt != null) {
                Time t = this.spkt.getTC();
                if (t != null) {
                    this.tc.time = t;
                } else {
                    this.tc.time.addSec((double)this.xfer * this.delta);
                }
                if (this.verbose) {
                    this.MT.writeln((CharSequence)this.spkt.listHeader());
                }
                this.seq = this.spkt.getCount();
                if (this.test && this.seq != this.nseq && this.nseq >= 0) {
                    ++this.seqerr;
                    this.MT.writeln((CharSequence)("Sequence Error expect=" + this.nseq + "  got=" + this.seq + "  at=" + offset));
                }
                this.nseq = this.seq + 1;
                if ((this.nseq & 0x1F) == 31) {
                    ++this.nseq;
                }
                this.nseq &= 0xFFFF;
            } else {
                this.ndo = this.xfer;
                int off = this.tc.findTimeCodeWords(this.dbi.buf, 0, n);
                if (off < 0) {
                    this.ndo = this.xfer;
                    return 0;
                }
                offset += (double)off;
            }
            this.timeTop.fromTime(this.tc.time);
            this.timeTop.addSec(-this.delta * offset);
            if (this.timeZero == null) {
                this.timeZero = new Time();
                this.timeZero.fromTime(this.timeTop);
            }
            double diff = this.timeTop.diff(this.timeZero);
            if (this.ho.isOpen) {
                this.dbo.setD(0, offset);
                this.dbo.setD(1, this.tc.time.getWSec());
                this.dbo.setD(2, this.tc.time.getFSec());
                this.dbo.setD(3, diff);
                if (this.gap) {
                    byte[] buf = new byte[64];
                    this.spkt.getBuffer(buf, 0);
                    this.tag = Convert.unpackL((byte[])buf, (int)4);
                    double tgap = this.ltag == 0 ? (double)this.spkt.getSize() * this.delta : (double)(this.tag - this.ltag) * 1.4992503748125937E-8;
                    this.dbo.setD(4, tgap);
                    this.ltag = this.tag;
                }
                this.ho.write(this.dbo, 1);
            }
            double adiff = Math.abs(diff);
            double aerr = adiff - this.drift;
            if (this.test && aerr > this.tolr) {
                this.M.warning((CharSequence)("TC=" + this.tc.time + " at index=" + offset + " err=" + diff + " tolr=" + this.tolr));
            }
            this.drift = this.exprate * adiff + (1.0 - this.exprate) * this.drift;
            if (this.func == 1) {
                this.time.fromTime(this.timeTop);
                if (!this.tic || !(offset < 0.0)) {
                    return 9;
                }
            }
            if (this.nopkt) {
                this.hi.seek(offset + (double)this.hack - 4.0);
            }
            this.ndo = 256;
            this.time.fromTime(this.tc.time);
        }
        return 0;
    }

    public int close() {
        this.hi.close();
        this.ho.close();
        double driftrate = this.drift / ((this.ho.getOffset() - this.driftOffset) * this.delta * (double)this.xper);
        if (this.test) {
            this.M.info((CharSequence)("TC drift total= " + this.drift + " sec  Rate=" + driftrate + " sec/sec"));
        }
        if (this.test && this.seqerr > 0) {
            this.M.info((CharSequence)("SDDS seq err total= " + this.seqerr));
        }
        if (this.func == 1 && !this.MA.isPresent("TIME")) {
            this.MT.writeln((CharSequence)("TopTime=" + this.time.toString(9)));
        }
        return 0;
    }

    private String timeString(double currTime) {
        Time t = new Time();
        t.fromJ1950(currTime);
        return t.toString();
    }

    private double getTimeFile(int currInd) {
        return this.hi.getData((double)currInd, 13).getD(0) - this.hi.getData((double)currInd, 12).getD(0) * this.delta;
    }

    private boolean getValidFile(int currInd) {
        return this.hi.getData((double)currInd, 11).getP(0) > 0;
    }

    private int determineFileMin(int currBeg, int currEnd) {
        boolean valBeg = this.getValidFile(currBeg);
        boolean valEnd = this.getValidFile(currEnd);
        if (!valBeg && !valEnd) {
            return this.determineFileMinLinear(currEnd);
        }
        if (valBeg) {
            return currBeg;
        }
        if (currEnd - currBeg <= 1) {
            if (valEnd) {
                return currEnd;
            }
            return -1;
        }
        int currMid = currBeg + (currEnd - currBeg) / 2;
        if (this.getValidFile(currMid)) {
            return this.determineFileMin(currBeg, currMid);
        }
        return this.determineFileMin(currMid, currEnd);
    }

    private int determineFileMinLinear(int currMax) {
        for (int x = 0; x <= currMax; ++x) {
            if (!this.getValidFile(x)) continue;
            return x;
        }
        return -1;
    }

    private int determineFileMax(int currBeg, int currEnd) {
        boolean valBeg = this.getValidFile(currBeg);
        boolean valEnd = this.getValidFile(currEnd);
        if (!valBeg && !valEnd) {
            return this.determineFileMaxLinear(currBeg, currEnd);
        }
        if (valEnd) {
            return currEnd;
        }
        if (currEnd - currBeg <= 1) {
            if (valBeg) {
                return currBeg;
            }
            return -1;
        }
        int currMid = currBeg + (currEnd - currBeg) / 2;
        if (this.getValidFile(currMid)) {
            return this.determineFileMax(currMid, currEnd);
        }
        return this.determineFileMax(currBeg, currMid);
    }

    private int determineFileMaxLinear(int currBeg, int currEnd) {
        for (int x = currEnd; x > currBeg; --x) {
            if (!this.getValidFile(x)) continue;
            return x;
        }
        return currBeg;
    }

    private int searchRec(double time, int indBeg, int indEnd) {
        if (indEnd - indBeg <= 1) {
            return indBeg;
        }
        int indMid = indBeg + (indEnd - indBeg) / 2;
        double currTime = this.getTimeFile(indMid);
        if (currTime < time) {
            return this.searchRec(time, indMid, indEnd);
        }
        return this.searchRec(time, indBeg, indMid);
    }
}

