/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.DevIce;
import nxm.ice.lib.RamDiskResource;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;

public class icertmon
extends Primitive {
    private DataFile hr;
    private DevIce.DmaMap map;
    private long iPtr;
    private long oPtr;
    private long vaddr;
    private long vsize;
    private int xfer = 0x100000;

    public int open() {
        this.hr = this.MA.getDataFile("IN", "1000,2000", "S#,C#", 0);
        this.hr.open();
        if (this.hr.io instanceof RamDiskResource) {
            this.map = ((RamDiskResource)this.hr.io).map;
        } else {
            this.M.error("Input file must exist on an ICE RamDisk mount point");
        }
        this.map.setPaged(false);
        this.vsize = this.map.bytes;
        this.vaddr = this.map.getVirtualAddress(0L, (int)this.vsize);
        this.xfer = this.MA.getL("/TL", this.xfer);
        if (this.vsize % (long)this.xfer != 0L) {
            this.M.error("Input file length must be a multiple of the transfer length");
        }
        this.updateRTF();
        this.oPtr = this.iPtr;
        return 0;
    }

    public int process() {
        if (this.iPtr - this.oPtr < (long)this.xfer) {
            this.updateRTF();
            if (this.iPtr - this.oPtr < (long)this.xfer) {
                return -1;
            }
        }
        long voff = this.oPtr % this.vsize;
        System.out.printf("Processing data at voff=%x optr=%x iptr=%x off=%x\n", voff, this.oPtr, this.iPtr);
        this.oPtr += (long)this.xfer;
        return 0;
    }

    public int close() {
        this.hr.close();
        return 0;
    }

    private void updateRTF() {
        this.hr.ioh.read(this.hr.hb, 0, 512, 0L);
        this.iPtr = (long)this.hr.getInByte();
    }
}

