/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;

public class icepa
extends Primitive {
    private DataFile hi;
    private DataFile ho;
    private Data dati;
    private Data dato;
    private int mode = 1;
    private int spb;
    private int hspb;
    private int spms;
    private int bufSize = 65536;
    private double xs;
    private double xd;
    private long offset;
    private byte[][] cmda = new byte[32][8];
    public static String protocolList = "USB2LS,USB2FS,USB2HS,USB3,DP,PCIe,AUX,TGbE";
    public static String usb2cmdList = "OUT,ACK,DATA0,PING,SOF,NYET,DATA2,SPLIT,IN,NAK,DATA1,PRE,SETUP,STALL,MDATA,SE0,RESET";
    public static String usb2smBits = "rsv,rx_recv,rx_dm,rx_dp,intr,tx_se0,tx_data,tx_en";
    public static int U2_IDLE = 0;
    public static int U2_SE0 = 16;
    public static int U2_RESET = 17;
    public static int U2_LAST = 18;
    int lbdr = 32;
    int state = 0;
    long start = 0L;
    int length = 0;
    int lcmd;
    byte[] bcmd = new byte[4096];
    byte[] bdata = new byte[256];

    public int open() {
        this.hi = this.MA.getDataFile("IN");
        this.hi.open();
        this.ho = this.MA.getDataFile("OUT", "3000", "NH", 0);
        this.ho.setSubRecords("TIME|SD,RPT|SL,LEN|SL,TYPE|1A,DATA|1A");
        this.ho.open(2);
        this.mode = this.MA.getSelectionIndex("MODE", protocolList, this.mode);
        this.spb = this.mode == 2 ? 5 : 40;
        this.hspb = this.spb / 2;
        this.spms = 60000;
        this.setProgressFeed(this.hi, "IcePA " + this.hi.getURL() + " to " + this.ho.getURL());
        this.xfer = Math.max(1, (int)((double)this.bufSize / this.hi.dbpe));
        this.xfer = this.MA.getL("/TL", this.xfer);
        this.dati = this.hi.getDataBuffer(this.xfer);
        this.dato = this.ho.getDataBuffer(1);
        this.xs = 0.0;
        this.xd = this.hi.getXDelta();
        this.offset = 0L;
        Parser p = new Parser(usb2cmdList);
        for (int i = 0; i < U2_LAST; ++i) {
            String cmd;
            String string = cmd = i == 0 ? "IDLE" : p.get(i);
            while (cmd.length() < 8) {
                cmd = cmd + " ";
            }
            this.cmda[i] = cmd.getBytes();
        }
        return 0;
    }

    public int process() {
        int n = this.hi.read(this.dati);
        if (n <= 0) {
            return 9;
        }
        this.processUSB(this.dati.buf, n);
        this.offset += (long)n;
        return 0;
    }

    public int close() {
        this.hi.close();
        this.ho.close();
        return 0;
    }

    void writeOut(long start, int rpt, int len, int cmd, byte[] data, int dlen) {
        Convert.packD((byte[])this.dato.buf, (int)0, (double)(this.xs + this.xd * (double)start));
        Convert.packL((byte[])this.dato.buf, (int)8, (int)rpt);
        Convert.packL((byte[])this.dato.buf, (int)12, (int)len);
        Convert.packA((byte[])this.dato.buf, (int)16, (int)8, (byte[])this.cmda[cmd]);
        Convert.packA((byte[])this.dato.buf, (int)24, (int)dlen, (byte[])data);
        this.ho.write(this.dato, 1);
    }

    void processUSBcmd() {
        int cmd = 0;
        int dlen = 0;
        int k = 1;
        int i = 1;
        int s = 0;
        while (i < this.lcmd) {
            boolean nbit = this.bcmd[i] == 0 ^ this.bcmd[i - 1] == 0;
            if (nbit) {
                s = 0;
            } else if (++s == 6) {
                s = 0;
                nbit = this.bcmd[++i] == 0 ^ this.bcmd[i - 1] == 0;
            }
            int j = k & 7;
            if (j == 0) {
                this.bdata[dlen] = 0;
            }
            if (!nbit) {
                int n = dlen;
                this.bdata[n] = (byte)(this.bdata[n] | 1 << j);
            }
            if (j == 7) {
                ++dlen;
            }
            if (k == 15) {
                cmd = this.bdata[1] & 0xF;
                dlen = 0;
            }
            ++i;
            ++k;
        }
        if (dlen > 4) {
            dlen = 4;
        }
        String sdata = Convert.bb2hex((byte[])this.bdata, (int)0, (int)dlen).substring(2);
        while (sdata.length() < 8) {
            sdata = sdata + " ";
        }
        byte[] edata = sdata.getBytes();
        int rpt = 1;
        this.writeOut(this.start, rpt, k, cmd, edata, 8);
    }

    void processUSB(byte[] buf, int len) {
        for (int i = 0; i < len; ++i) {
            byte bus = buf[i];
            int bdr = bus & 0x30;
            if (bus < 0) continue;
            if (bdr != this.lbdr) {
                if (bdr == 0) {
                    if (this.state > 0 && this.lcmd > 0) {
                        this.processUSBcmd();
                    }
                    this.state = -1;
                    this.start = this.offset + (long)i;
                    this.length = 0;
                } else if (this.state < 0 && bdr != 0) {
                    int reset = this.length / this.spms;
                    if (reset > 0) {
                        this.writeOut(this.start, 1, reset, U2_RESET, buf, 0);
                    }
                    this.state = 0;
                } else if (this.state == 0 && bdr == 16) {
                    this.state = 1;
                    this.start = this.offset + (long)i;
                    this.length = 0;
                    this.lcmd = 0;
                }
            }
            if (this.state > 0 && this.length % this.spb == this.hspb && this.lcmd < 4096) {
                if (bdr == 48) {
                    bdr = this.lbdr;
                    System.out.println("Bad BDR at " + this.offset + " " + i);
                }
                this.bcmd[this.lcmd++] = bdr == 16 ? (byte)1 : 0;
            }
            ++this.length;
            this.lbdr = bdr;
        }
    }
}

