/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.MDevIce;
import nxm.ice.lib.NetIO;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;

public class icenet
extends Primitive {
    private int tl = 4096;
    private DataFile hi;
    private DataFile ho;
    private Data dbi;
    private Data dbo;
    private Table keys;
    private String func;
    private String fname;
    private String aname;
    private NetIO nio = new NetIO(true);
    private boolean isSet;
    private boolean isGet;
    private boolean isAcq;
    private boolean isPly;
    private boolean isMsg;
    private boolean isMsgR;
    private boolean isFile;
    private boolean isImport;
    private boolean isExport;
    private boolean needHeader;
    private double size;

    public int open() {
        String func = this.MA.getS("FUNC");
        String addr = this.MA.getCS("ADDR");
        String label = this.MA.getU("/LABEL");
        String table = this.MA.getU("/TABLE");
        String result = this.MA.getU("/RESULT");
        this.size = this.MA.getD("SIZE");
        this.isSet = func.equals("SET");
        this.isGet = func.equals("GET");
        this.isAcq = func.equals("ACQ");
        this.isPly = func.equals("PLY");
        this.isMsg = func.equals("MSG");
        this.isMsgR = func.equals("MSGR");
        this.isFile = func.equals("FILE");
        this.isImport = func.equals("IMPORT");
        this.isExport = func.equals("EXPORT");
        this.tl = this.isAcq ? 8192 : 4096;
        this.tl = this.MA.getL("/TL", this.tl);
        if (func.length() == 0 || addr.length() == 0) {
            this.M.error("Need to specify all arguments");
        }
        if (addr.indexOf(58) < 0 && addr.indexOf(47) < 0) {
            String config = MDevIce.getConfig(this.MA, addr.toUpperCase());
            if (config == null) {
                this.M.error("Alias " + addr + " not found in HW config file");
            }
            if ((addr = MDevIce.getConfigEntry(config, "IPADDR")) == null) {
                this.M.error("No IPADDR field in HW config " + config);
            }
        }
        if (this.isSet || this.isGet || this.isMsg || this.isMsgR) {
            Table t;
            int type = this.isMsgR ? NetIO.MSGR : (this.isMsg ? NetIO.MSG : (this.isSet ? NetIO.SET : NetIO.GET));
            int flags = this.MA.getOptionMask("FLAGS", NetIO.flagsList, 0);
            if ((flags & NetIO.RMIF) == 0) {
                flags |= NetIO.HTTP;
            }
            byte[] fb = (t = this.MA.getTable("FILE", null, 32)) != null ? t.toBytes() : this.MA.getCS("FILE").getBytes();
            int len = fb.length;
            if (flags == 0) {
                flags = NetIO.RMIF;
            }
            byte[] buf = new byte[this.tl];
            System.arraycopy(fb, 0, buf, 0, len);
            int stat = this.nio.open(addr, 0, flags);
            if (stat < 0) {
                this.M.error("Opening socket");
            }
            String str = (len = this.nio.msg(0, type, buf, len, flags)) > 0 ? new String(buf, 0, len) : "NULL";
            int iq = str.indexOf(123);
            int ie = str.indexOf(61);
            if (label.length() > 0) {
                this.MR.put(label, (Object)str);
            }
            if (table.length() > 0) {
                this.MR.put(table, (Object)new Table(str.substring(iq)));
            }
            if (result.length() > 0) {
                this.MR.put(result, (Object)str.substring(ie + 1, str.length() - 1));
            }
            if (this.verbose && label.length() <= 0 && table.length() <= 0 && result.length() <= 0) {
                this.MT.writeln((CharSequence)str);
            }
            return 9;
        }
        if (this.isAcq) {
            this.ho = this.MA.getDataFile("FILE", "1000", "SB", 0, this.size, null);
            this.ho.open();
            this.xfer = this.tl + 64;
            this.dbo = this.ho.getDataBuffer(this.xfer);
            this.nio.open(addr, 0, NetIO.INPUT);
            this.needHeader = true;
        } else if (this.isPly) {
            this.hi = this.MA.getDataFile("FILE", "1000,2000", "S#,C#", 0);
            this.hi.open(64);
            this.dbi = this.hi.getDataBuffer(this.tl);
            this.M.error("Function " + func + " not coded yet");
        } else if (this.isFile || this.isImport || this.isExport) {
            int stat = this.nio.open(addr, 0, NetIO.HTTP);
            if (stat < 0) {
                this.M.error("Opening socket");
            }
            BaseFile bf = this.MA.getFile("FILE");
            bf.find(2);
            this.fname = bf.getURL().substring(5);
            this.aname = this.MA.getCS("FLAGS");
        } else {
            this.M.error("Function " + func + " not supported");
        }
        return 0;
    }

    public int process() {
        if (this.isAcq) {
            int n = this.nio.recv(0, this.dbo.buf, 0, this.xfer, 0);
            if (n > 0) {
                this.ho.write(this.dbo, n);
            }
            if (this.ho.seek() > this.size) {
                return 9;
            }
        } else if (!this.isPly) {
            if (this.isFile || this.isImport || this.isExport) {
                this.nio.file(this.fname, this.aname, this.isImport ? 1 : (this.isExport ? -1 : 0));
                return 9;
            }
            return 9;
        }
        return 0;
    }

    public int close() {
        if (this.nio != null) {
            this.nio.close();
        }
        if (this.hi != null) {
            this.hi.close();
        }
        if (this.ho != null) {
            this.ho.keywords.putMain("PACKET", "ICE/FS=" + this.dbo.unpackL(8));
            this.ho.setFormatMode(this.dbo.buf[20]);
            this.ho.setFormatType(this.dbo.buf[21]);
            this.ho.close();
        }
        return 0;
    }
}

