/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;

public class icemux
extends Primitive {
    private DataFile ho;
    private DataFile hi;
    private DataFile[] his;
    private double[] tis;
    private double[] tid;
    private boolean ctag;
    private boolean strip;
    private int nc;
    private int icm;
    private int bpe;
    private Data db;

    public int open() {
        this.nc = this.MA.getL("NCHAN");
        this.xfer = this.MA.getL("/TL", 256);
        this.ctag = this.MA.getState("/CTAG");
        this.strip = this.MA.getState("/STRIP");
        String root = this.MA.getCS("IN");
        this.his = new DataFile[this.nc];
        this.tis = new double[this.nc];
        this.tid = new double[this.nc];
        this.icm = -1;
        for (int ic = 0; ic < this.nc; ++ic) {
            this.hi = new DataFile();
            this.hi.init((MidasReference)this, (Object)(root + (ic + 1)), "1000", "S#,C#", 0);
            if (this.hi.exists()) {
                this.hi.open();
            }
            if (this.hi.isOpen && this.icm < 0) {
                this.icm = ic;
            }
            this.his[ic] = this.hi;
            this.tis[ic] = this.hi.getXStart();
            this.tid[ic] = this.hi.getXDelta() * (double)this.xfer;
        }
        this.ho = this.MA.getDataFile("OUT", this.his[this.icm], 0);
        if (this.strip) {
            this.ho.setPacketHandler(null);
        }
        this.ho.open(2);
        this.db = this.ho.getDataBuffer(this.xfer);
        this.bpe = (int)this.ho.getBPE();
        return 0;
    }

    public int process() {
        double tiMin = 0.0;
        this.icm = -1;
        for (int ic = 0; ic < this.nc; ++ic) {
            this.hi = this.his[ic];
            if (!this.hi.isOpen || this.icm >= 0 && !(this.tis[ic] < tiMin)) continue;
            tiMin = this.tis[ic];
            this.icm = ic;
        }
        if (this.icm < 0) {
            return 9;
        }
        this.hi = this.his[this.icm];
        int n = this.hi.read(this.db);
        if (n < 0) {
            this.hi.close();
        }
        if (this.ctag && n > 0) {
            this.ctag(this.db.buf, this.icm, n);
        }
        if (n == this.xfer) {
            this.ho.write(this.db);
            int n2 = this.icm;
            this.tis[n2] = this.tis[n2] + this.tid[this.icm];
        }
        return 0;
    }

    public int close() {
        for (int ic = 0; ic < this.nc; ++ic) {
            this.his[ic].close();
        }
        this.ho.close();
        return 0;
    }

    private void ctagx(byte[] buf, int ic, int n) {
        int nb = n * this.bpe >> 1;
        for (int i = 0; i < nb; ++i) {
            buf[i + i] = (byte)(buf[i + i] & 0xFE | ic >> (i & 3) & 1);
        }
    }

    private void ctag(byte[] buf, int ic, int n) {
        int nb = n * this.bpe;
        for (int i = 0; i < nb; i += 1024) {
            buf[i + 0] = (byte)(buf[i + 0] & 0xFE | ic >> 0 & 1);
            buf[i + 2] = (byte)(buf[i + 2] & 0xFE | ic >> 1 & 1);
            buf[i + 4] = (byte)(buf[i + 4] & 0xFE | ic >> 2 & 1);
            buf[i + 6] = (byte)(buf[i + 6] & 0xFE | ic >> 3 & 1);
        }
    }
}

