/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import java.security.MessageDigest;
import java.util.ArrayList;
import nxm.ice.lib.MDevIce;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;

public class icemeasure
extends Primitive {
    private static final String funcList = "Bandwidth,Characterize,Flash,Harmonics,Histogram,Mse,NoiseFloor,Notch,Npr,Sonet,Udp";
    private static final int BAND = 1;
    private static final int CHAR = 2;
    private static final int FLASH = 3;
    private static final int HARM = 4;
    private static final int HIST = 5;
    private static final int MSE = 6;
    private static final int NOISE = 7;
    private static final int NOTCH = 8;
    private static final int NPR = 9;
    private static final int SONET = 10;
    private static final int UDP = 11;
    private static final int FLASHSIZE = 65536;
    private static final int MATCH = 24;
    private static final int BER = 25;
    private int func;
    private DataFile hi1;
    private DataFile hi2;
    private DataFile ho;
    private Data dbi1;
    private Data dbi2;
    private double freq1;
    private double freq2;
    private double fbw;
    private int dcend;
    private double[] data1;
    private int[] inds1;
    private int len1 = 0;
    private double[] data2;
    private int[] inds2;
    private int len2;
    private double[] datan;
    private int[] indsn;
    private int lenn;
    private double adj_val;
    private double fpb;
    private double fs;
    private double thresh;
    private QuickSort qsort;
    private ArrayList<IceSpur> spurs;
    private boolean complex;
    private int medind;
    private int mode;
    private int seek_ind;
    private int frames;
    private int matched;
    private long skip;
    private String str;
    private long[] bit_accumr;
    private long[] bit_accumi;

    public int open() {
        this.hi1 = this.MA.getDataFile("IN1");
        this.hi1.open();
        this.hi1.setDFS(0);
        this.xfer = this.hi1.getFrameSize();
        this.complex = this.hi1.getXStart() < 0.0;
        this.hi2 = null;
        this.ho = this.MA.getDataFile("OUT", "3000", "NH", 0);
        this.func = this.MA.getSelectionIndex("FUNC", funcList, 0);
        int nargs = this.MA.getNArgs();
        this.str = null;
        switch (this.func) {
            case 1: {
                int m;
                double THRESH1;
                if (nargs != 6) {
                    this.M.error("Error! Incorrect number of arguments for function: Bandwidth! i.e. icemeasure band <out> <in1> <fs> <fbw> <thresh>");
                }
                this.ho.setSubRecords("MEDIAN|SD,IN|SD,OUT|SD");
                double d = this.fs = this.MA.get("FS") == null ? this.MA.getD(4) : this.MA.getD("FS");
                if (this.fs <= 0.0) {
                    this.M.error("You must supply a valid sampling rate!");
                }
                double d2 = this.fbw = this.MA.get("FBW") == null ? this.MA.getD(5) : this.MA.getD("FBW");
                if (this.fbw < 0.0 || this.fbw > 1.0) {
                    this.M.error("Fractional bandwidth (FBW) must be between 0.0 and 1.0!");
                }
                double d3 = THRESH1 = this.MA.get("THRESH") == null ? (double)this.MA.getL(6) : (double)this.MA.getL("THRESH");
                if (THRESH1 < 0.0) {
                    this.M.error("Threshold must be a logarithmic value!");
                }
                this.thresh = Math.pow(10.0, THRESH1 / 10.0);
                this.dcend = this.detDcInds(this.xfer);
                double npoints = this.fbw * (double)this.xfer - (double)(2 * this.dcend);
                int tmpbeg = (int)Math.floor(0.5 * ((double)this.xfer - npoints));
                int tmpend = tmpbeg + (int)Math.ceil(npoints);
                this.len1 = tmpend - tmpbeg;
                this.data1 = new double[this.len1];
                this.inds1 = new int[this.len1];
                this.len2 = this.xfer - this.len1;
                this.data2 = new double[this.len2];
                this.inds2 = new int[this.len2];
                for (m = 0; m < this.len1; ++m) {
                    this.inds1[m] = m + tmpbeg;
                }
                for (m = 0; m < tmpbeg; ++m) {
                    this.inds2[m] = m;
                }
                m = tmpend;
                int n = tmpbeg;
                while (m < this.xfer) {
                    this.inds2[n] = m++;
                    ++n;
                }
                this.medind = this.len1 / 2;
                this.qsort = new QuickSort();
                break;
            }
            case 2: {
                double THRESH1;
                if (nargs != 7) {
                    this.M.error("Error! Error! Incorrect number of arguments for function: Characterize! i.e. icemeasure char <out> <in1> <fs> <fbw> <thresh> <freq1>");
                }
                this.ho.setSubRecords("SNR|SD,SFDR|SD,NF|SD,THRESH|SD,SIG|SD,MAXSPUR|SD,MAXSPURFREQ|SD");
                double d = this.fs = this.MA.get("FS") == null ? this.MA.getD(4) : this.MA.getD("FS");
                if (this.fs <= 0.0) {
                    this.M.error("You must supply a valid sampling rate!");
                }
                double d4 = this.fbw = this.MA.get("FBW") == null ? this.MA.getD(5) : this.MA.getD("FBW");
                if (this.fbw < 0.0 || this.fbw > 1.0) {
                    this.M.error("Fractional bandwidth (FBW) must be between 0.0 and 1.0!");
                }
                double d5 = THRESH1 = this.MA.get("THRESH") == null ? (double)this.MA.getL(6) : (double)this.MA.getL("THRESH");
                if (THRESH1 < 0.0) {
                    this.M.error("Threshold must be a logarithmic value!");
                }
                this.thresh = Math.pow(10.0, THRESH1 / 10.0);
                this.freq1 = this.MA.get("FREQ1") == null ? this.MA.getD(7) : this.MA.getD("FREQ1");
                double mfreq1 = this.mapFreq(this.freq1);
                if (mfreq1 > this.fs || mfreq1 < 0.0) {
                    this.M.error("Specified frequency is outside of sampling rate!");
                }
                this.fpb = this.complex ? this.fs / (double)this.xfer : 0.5 * this.fs / (double)this.xfer;
                this.adj_val = 10.0 * Math.log10(this.fpb);
                this.dcend = this.detDcInds(this.xfer);
                double npoints = this.fbw * (double)this.xfer - (double)(2 * this.dcend);
                int tmpbeg = (int)Math.floor(0.5 * ((double)this.xfer - npoints));
                int tmpend = tmpbeg + (int)Math.ceil(npoints);
                this.len1 = tmpend - tmpbeg;
                this.data1 = new double[this.len1];
                this.inds1 = new int[this.len1];
                int n = tmpbeg;
                for (int m = 0; m < this.len1; ++m) {
                    this.inds1[m] = n++;
                }
                this.medind = this.len1 / 2;
                this.inds2 = this.fillIndices(mfreq1, this.dcend, 0);
                this.len2 = this.inds2.length;
                this.qsort = new QuickSort();
                break;
            }
            case 3: {
                if (nargs != 5) {
                    this.M.error("Error! Incorrect number of arguments for function: Bandwidth! i.e. icemeasure flash <out> <in1> <alias> <cardnum>");
                }
                this.xfer = (int)this.hi1.getSize();
                if (this.xfer != 65536) {
                    this.M.error("File size (" + this.xfer + ") not equal to " + 65536);
                    return 9;
                }
                if (!this.hi1.getFormat().equals("SB")) {
                    this.M.error("Input type must be SB");
                    return 9;
                }
                this.ho.setSubRecords("ERROR|SB,SHA1|8A,SHA2|8A");
                this.str = this.MA.get("ALIAS") == null ? this.MA.getCS(4) : this.MA.getCS("ALIAS");
                int m = this.MA.get("CARDNUM") == null ? this.MA.getL(5) : this.MA.getL("CARDNUM");
                this.str = String.format(this.str, m - 1);
                break;
            }
            case 4: {
                int m;
                double THRESH1;
                if (nargs != 8) {
                    this.M.error("Error!  Error! Incorrect number of arguments for function: Harmonics! i.e. icemeasure harm <out> <in1> <fs> <thresh> <freq1> <freq2> <order>");
                }
                this.ho.setSubRecords("SNR|SD,S1S2|SD,SFDR|SD,NF|SD,THRESH|SD,MAXSPURFREQ|SL,MAXSPUR|SD");
                double d = this.fs = this.MA.get("FS") == null ? this.MA.getD(4) : this.MA.getD("FS");
                if (this.fs <= 0.0) {
                    this.M.error("You must supply a valid sampling rate!");
                }
                double d6 = THRESH1 = this.MA.get("THRESH") == null ? (double)this.MA.getL(5) : (double)this.MA.getL("THRESH");
                if (THRESH1 < 0.0) {
                    this.M.error("Threshold must be a logarithmic value!");
                }
                this.thresh = Math.pow(10.0, THRESH1 / 10.0);
                this.freq1 = this.MA.get("FREQ1") == null ? this.MA.getD(6) : this.MA.getD("FREQ1");
                double mfreq1 = this.mapFreq(this.freq1);
                if (mfreq1 < 0.0 || mfreq1 > this.fs) {
                    this.M.error("First frequency is outside of sampling rate!");
                }
                this.freq2 = this.MA.get("FREQ2") == null ? this.MA.getD(7) : this.MA.getD("FREQ2");
                double mfreq2 = this.mapFreq(this.freq2);
                if (mfreq2 < 0.0 || mfreq2 > this.fs) {
                    this.M.error("Second frequency is outside of sampling rate!");
                }
                int order = this.MA.get("ORDER") == null ? this.MA.getL(8) : this.MA.getL("ORDER");
                this.dcend = this.detDcInds(this.xfer);
                this.lenn = this.xfer - 2 * this.dcend;
                this.datan = new double[this.lenn];
                this.indsn = new int[this.lenn];
                int n = this.dcend;
                for (m = 0; m < this.lenn; ++m) {
                    this.indsn[m] = n++;
                }
                this.fpb = this.complex ? this.fs / (double)this.xfer : 0.5 * this.fs / (double)this.xfer;
                this.adj_val = 10.0 * Math.log10(this.fpb);
                this.inds1 = this.fillIndices(mfreq1, this.dcend, 0);
                this.len1 = this.inds1.length;
                this.inds2 = this.fillIndices(mfreq2, this.dcend, 0);
                this.len2 = this.inds2.length;
                this.spurs = new ArrayList();
                for (m = 2; m <= order; ++m) {
                    double fh4;
                    double fh3;
                    double mult;
                    IceSpur spur;
                    double fh1 = this.mapFreq((double)m * this.freq1);
                    double fh2 = this.mapFreq((double)m * this.freq2);
                    if (fh1 <= this.fs && fh1 > 0.0) {
                        spur = new IceSpur();
                        spur.setIndices(this.fillIndices(fh1, this.dcend, this.dcend));
                        spur.setColumn("H" + m + "F1");
                        spur.setFreq(this.unmapFreq(fh1));
                        this.spurs.add(spur);
                        this.ho.addSubRec(spur.getColumn() + "FREQ", "SL");
                        this.ho.addSubRec(spur.getColumn() + "POW", "SD");
                        this.ho.addSubRec(spur.getColumn() + "DBC", "SD");
                    }
                    if (fh2 <= this.fs && fh2 > 0.0) {
                        spur = new IceSpur();
                        spur.setIndices(this.fillIndices(fh2, this.dcend, this.dcend));
                        spur.setColumn("H" + m + "F2");
                        spur.setFreq(this.unmapFreq(fh2));
                        this.spurs.add(spur);
                        this.ho.addSubRec(spur.getColumn() + "FREQ", "SL");
                        this.ho.addSubRec(spur.getColumn() + "POW", "SD");
                        this.ho.addSubRec(spur.getColumn() + "DBC", "SD");
                    }
                    if (m % 2 == 0) {
                        mult = m / 2;
                        fh1 = this.mapFreq(Math.abs(mult * this.freq1 - mult * this.freq2));
                        fh2 = this.mapFreq(mult * this.freq1 + mult * this.freq2);
                        fh3 = this.fs + 1.0;
                        fh4 = this.fs + 1.0;
                    } else {
                        mult = (m - 1) / 2;
                        fh1 = this.mapFreq((mult + 1.0) * this.freq1 - mult * this.freq2);
                        fh2 = this.mapFreq((mult + 1.0) * this.freq2 - mult * this.freq1);
                        fh3 = this.mapFreq((mult + 1.0) * this.freq1 + mult * this.freq2);
                        fh4 = this.mapFreq((mult + 1.0) * this.freq2 + mult * this.freq1);
                    }
                    if (fh1 <= this.fs && fh1 > 0.0) {
                        spur = new IceSpur();
                        spur.setIndices(this.fillIndices(fh1, this.dcend, this.dcend));
                        spur.setColumn("I" + m + "A");
                        spur.setFreq(this.unmapFreq(fh1));
                        this.spurs.add(spur);
                        this.ho.addSubRec(spur.getColumn() + "FREQ", "SL");
                        this.ho.addSubRec(spur.getColumn() + "POW", "SD");
                        this.ho.addSubRec(spur.getColumn() + "DBC", "SD");
                    }
                    if (fh2 <= this.fs && fh2 > 0.0) {
                        spur = new IceSpur();
                        spur.setIndices(this.fillIndices(fh2, this.dcend, this.dcend));
                        spur.setColumn("I" + m + "B");
                        spur.setFreq(this.unmapFreq(fh2));
                        this.spurs.add(spur);
                        this.ho.addSubRec(spur.getColumn() + "FREQ", "SL");
                        this.ho.addSubRec(spur.getColumn() + "POW", "SD");
                        this.ho.addSubRec(spur.getColumn() + "DBC", "SD");
                    }
                    if (fh3 <= this.fs && fh3 > 0.0) {
                        spur = new IceSpur();
                        spur.setIndices(this.fillIndices(fh3, this.dcend, this.dcend));
                        spur.setColumn("I" + m + "C");
                        spur.setFreq(this.unmapFreq(fh3));
                        this.spurs.add(spur);
                        this.ho.addSubRec(spur.getColumn() + "FREQ", "SL");
                        this.ho.addSubRec(spur.getColumn() + "POW", "SD");
                        this.ho.addSubRec(spur.getColumn() + "DBC", "SD");
                    }
                    if (!(fh4 <= this.fs) || !(fh4 > 0.0)) continue;
                    spur = new IceSpur();
                    spur.setIndices(this.fillIndices(fh4, this.dcend, this.dcend));
                    spur.setColumn("I" + m + "D");
                    spur.setFreq(this.unmapFreq(fh4));
                    this.spurs.add(spur);
                    this.ho.addSubRec(spur.getColumn() + "FREQ", "SL");
                    this.ho.addSubRec(spur.getColumn() + "POW", "SD");
                    this.ho.addSubRec(spur.getColumn() + "DBC", "SD");
                }
                this.medind = this.xfer / 2;
                this.qsort = new QuickSort();
                break;
            }
            case 5: {
                int m;
                if (nargs != 5) {
                    this.M.error("Error! Incorrect number of arguments for function: Bandwidth! i.e. icemeasure stuck <out> <in1> <bits> <bitsoff>");
                }
                int nbits = this.MA.get("BITS") == null ? this.MA.getL(4) : this.MA.getL("BITS");
                int bitsoff = this.MA.get("BITSOFF") == null ? this.MA.getL(5) : this.MA.getL("BITSOFF");
                int bitpow = nbits + bitsoff - 1;
                this.adj_val = (int)Math.pow(2.0, bitpow + 1);
                this.bit_accumr = new long[nbits];
                this.bit_accumi = new long[nbits];
                this.indsn = new int[nbits];
                this.ho.addSubRec("REMSB", "SL");
                this.indsn[0] = (int)Math.pow(2.0, bitpow);
                for (m = 1; m < nbits; ++m) {
                    this.indsn[m] = (int)Math.pow(2.0, bitpow - m);
                    this.ho.addSubRec("RE" + m, "SL");
                }
                this.ho.addSubRec("IMMSB", "SL");
                for (m = 1; m < nbits; ++m) {
                    this.ho.addSubRec("IM" + m, "SL");
                }
                this.xfer = this.MA.getL("/TL", 16384);
                break;
            }
            case 6: {
                int m;
                if (nargs != 5) {
                    this.M.error("Error! Error! Incorrect number of arguments for function: Mean Square Error! i.e. icemeasure mse <out> <in1> <in2> <segments>");
                }
                this.ho.setSubRecords("AVERAGE|SD,WORST|SD");
                this.hi2 = this.MA.get("IN2") == null ? this.MA.getDataFile(4) : this.MA.getDataFile("IN2");
                this.hi2.open();
                this.hi2.setDFS(0);
                this.dbi2 = this.hi2.getDataBuffer(this.xfer);
                int nsegs = this.MA.get("SEGMENTS") == null ? this.MA.getL(5) : this.MA.getL("SEGMENTS");
                nsegs = nsegs < 0 ? 1 : nsegs;
                this.dcend = this.detDcInds(this.xfer);
                this.len1 = this.len2 = this.xfer - 2 * this.dcend;
                this.data1 = new double[this.len1];
                this.data2 = new double[this.len1];
                this.inds1 = new int[this.len1];
                int n = this.dcend;
                for (m = 0; m < this.len1; ++m) {
                    this.inds1[m] = n++;
                }
                this.indsn = new int[nsegs];
                if (nsegs > 1) {
                    int pps = (int)Math.floor(1.0 * (double)this.len1 / (double)nsegs);
                    for (m = 0; m < nsegs - 1; ++m) {
                        this.indsn[m] = pps * (m + 1) + this.dcend;
                    }
                }
                this.indsn[nsegs - 1] = this.len1 + this.dcend;
                this.qsort = new QuickSort();
                break;
            }
            case 7: {
                double THRESH1;
                if (nargs != 6) {
                    this.M.error("Error! Incorrect number of arguments for function: Noise Floor! i.e. icemeasure noise <out> <in1> <fs> <fbw> <thresh>");
                }
                this.ho.setSubRecords("NF|SD,THRESH|SD,MAXSPUR|SD,MAXSPURFREQ|SD");
                double d = this.fs = this.MA.get("FS") == null ? this.MA.getD(4) : this.MA.getD("FS");
                if (this.fs <= 0.0) {
                    this.M.error("You must supply a valid sampling rate!");
                }
                double d7 = this.fbw = this.MA.get("FBW") == null ? this.MA.getD(5) : this.MA.getD("FBW");
                if (this.fbw < 0.0 || this.fbw > 1.0) {
                    this.M.error("Fractional bandwidth (FBW) must be between 0.0 and 1.0!");
                }
                double d8 = THRESH1 = this.MA.get("THRESH") == null ? (double)this.MA.getL(6) : (double)this.MA.getL("THRESH");
                if (THRESH1 < 0.0) {
                    this.M.error("Threshold must be a logarithmic value!");
                }
                this.thresh = Math.pow(10.0, THRESH1 / 10.0);
                this.fpb = this.complex ? this.fs / (double)this.xfer : 0.5 * this.fs / (double)this.xfer;
                this.adj_val = 10.0 * Math.log10(this.fpb);
                this.dcend = this.detDcInds(this.xfer);
                this.fbw = this.fbw > 1.0 ? 1.0 : (this.fbw < 0.0 ? 0.0 : this.fbw);
                double npoints = this.fbw * (double)this.xfer - (double)(2 * this.dcend);
                int tmpbeg = (int)Math.floor(0.5 * ((double)this.xfer - npoints));
                int tmpend = tmpbeg + (int)Math.ceil(npoints);
                this.len1 = tmpend - tmpbeg;
                this.data1 = new double[this.len1];
                this.inds1 = new int[this.len1];
                int n = tmpbeg;
                for (int m = 0; m < this.len1; ++m) {
                    this.inds1[m] = n++;
                }
                this.medind = this.len1 / 2;
                this.qsort = new QuickSort();
                break;
            }
            case 8: {
                double nbw;
                if (nargs != 6) {
                    this.M.error("Error! Error! Incorrect number of arguments for function: Notch! i.e. icemeasure notch <out> <in1> <fs> <nbw> <fbw>");
                }
                this.ho.setSubRecords("MEDIAN|SD,NOTCH|SD,TONE|SD");
                double d = this.fs = this.MA.get("FS") == null ? this.MA.getD(4) : this.MA.getD("FS");
                if (this.fs <= 0.0) {
                    this.M.error("You must supply a valid sampling rate!");
                }
                double d9 = nbw = this.MA.get("NBW") == null ? this.MA.getD(5) : this.MA.getD("NBW");
                if (nbw > this.fs || nbw < 0.0) {
                    this.M.error("Notch bandwidth must be less than the sampling rate and greater than zero!");
                }
                double d10 = this.fbw = this.MA.get("FBW") == null ? this.MA.getD(6) : this.MA.getD("FBW");
                if (this.fbw < 0.0 || this.fbw > 1.0) {
                    this.M.error("Fractional bandwidth (FBW) must be between 0.0 and 1.0!");
                }
                this.fpb = this.complex ? this.fs / (double)this.xfer : 0.5 * this.fs / (double)this.xfer;
                double npoints = 500.0 / this.fpb;
                int tmpbeg = (int)Math.floor(0.5 * ((double)this.xfer - npoints));
                int tmpend = (int)Math.ceil(0.5 * ((double)this.xfer + npoints));
                int tlen = tmpend - tmpbeg;
                npoints = nbw / this.fpb;
                int pbeg = (int)Math.floor(0.5 * ((double)this.xfer - npoints));
                int pend = (int)Math.ceil(0.5 * ((double)this.xfer + npoints));
                this.len1 = pend - pbeg - tlen;
                this.inds1 = new int[this.len1];
                this.data1 = new double[this.len1];
                int m = 0;
                int n = pbeg;
                while (n < tmpbeg) {
                    this.inds1[m] = n++;
                    ++m;
                }
                n = tmpend;
                while (n < pend) {
                    this.inds1[m] = n++;
                    ++m;
                }
                npoints = (this.fbw > 1.0 ? 1.0 : (this.fbw < 0.0 ? 0.0 : this.fbw)) * (double)this.xfer;
                pbeg = (int)Math.floor(0.5 * ((double)this.xfer - npoints));
                pend = (int)Math.ceil(0.5 * ((double)this.xfer + npoints));
                this.len2 = pend - pbeg - (tlen + this.len1) + 1;
                if (this.len2 < 0) {
                    this.M.error("FBW (" + this.fbw + ")value is too small! Please increase!");
                }
                this.inds2 = new int[this.len2];
                this.data2 = new double[this.len2];
                m = 0;
                n = pbeg;
                while (n < this.inds1[0]) {
                    this.inds2[m] = n++;
                    ++m;
                }
                n = this.inds1[this.len1 - 1];
                while (n < pend) {
                    this.inds2[m] = n++;
                    ++m;
                }
                this.qsort = new QuickSort();
                break;
            }
            case 9: {
                double bwn;
                double freqn;
                double bw2;
                double bw1;
                if (nargs != 9) {
                    this.M.error("Error! Error! Incorrect number of arguments for function: Noise Power Ratio! i.e. icemeasure npr <out> <in1> <freq1> <bw1> <freq2> <bw2> <freqn> <bwn>");
                }
                this.ho.setSubRecords("SIGNAL|SD,NOTCH|SD");
                double d = this.freq1 = this.MA.get("FREQ1") == null ? this.MA.getD(4) : this.MA.getD("FREQ1");
                if (this.freq1 < 0.0 || this.freq1 > 1.0) {
                    this.M.error("Please specify passband as a percentage into the signal (i.e. 0 < freq1 < 1.0)!");
                }
                double d11 = bw1 = this.MA.get("BW1") == null ? this.MA.getD(5) : this.MA.getD("BW1");
                if (bw1 < 0.0 || bw1 > 1.0) {
                    this.M.error("Please specify passband width as a percentage into the signal (i.e. 0 < bw1 < 1.0)!");
                }
                double d12 = this.freq2 = this.MA.get("FREQ2") == null ? this.MA.getD(6) : this.MA.getD("FREQ2");
                if (this.freq2 < 0.0 || this.freq2 > 1.0) {
                    this.M.error("Please specify passband as a percentage into the signal (i.e. 0 < freq2 < 1.0)!");
                }
                double d13 = bw2 = this.MA.get("BW2") == null ? this.MA.getD(7) : this.MA.getD("BW2");
                if (bw2 < 0.0 || bw2 > 1.0) {
                    this.M.error("Please specify passband width as a percentage into the signal (i.e. 0 < bw2 < 1.0)!");
                }
                double d14 = freqn = this.MA.get("FREQN") == null ? this.MA.getD(8) : this.MA.getD("FREQN");
                if (freqn < 0.0 || freqn > 1.0) {
                    this.M.error("Please specify passband as a percentage into the signal (i.e. 0 < freqn < 1.0)!");
                }
                double d15 = bwn = this.MA.get("BWN") == null ? this.MA.getD(9) : this.MA.getD("BWN");
                if (bwn < 0.0 || bwn > 1.0) {
                    this.M.error("Please specify passband width as a percentage into the signal (i.e. 0 < bwn < 1.0)!");
                }
                this.inds1 = this.detInds(this.freq1, bw1);
                this.inds2 = this.detInds(this.freq2, bw2);
                this.indsn = this.detInds(freqn, bwn);
                break;
            }
            case 10: {
                if (nargs != 8) {
                    this.M.error("Error! Error! Incorrect number of arguments for function: SONET! i.e. icemeasure sonet <out> <in1> <in2> <skip2> <frame> <cor> <off>");
                }
                this.ho.setSubRecords("ERRORS|SD,PROC|SD,BER|SD");
                this.xfer = this.MA.getL("/TL", 4096);
                this.hi2 = this.MA.get("IN2") == null ? this.MA.getDataFile(4) : this.MA.getDataFile("IN2");
                this.hi2.open();
                this.hi2.setDFS(0);
                int tmp_skip = this.MA.get("SKIP2") == null ? this.MA.getL(5) : this.MA.getL("SKIP2");
                this.xfer = this.MA.get("FRAME") == null ? this.MA.getL(6) : this.MA.getL("FRAME");
                this.frames = this.MA.get("COR") == null ? this.MA.getL(7) : this.MA.getL("COR");
                this.str = this.MA.get("OFF") == null ? this.MA.getS(8) : this.MA.getS("OFF");
                this.MR.put(this.str, -1);
                this.skip = tmp_skip * this.xfer;
                this.dbi2 = this.hi2.getDataBuffer(this.xfer);
                this.hi2.seek((double)this.skip);
                this.mode = 24;
                this.matched = 0;
                this.seek_ind = 0;
                break;
            }
            case 11: {
                if (nargs != 4) {
                    this.M.error("Error! Error! Incorrect number of arguments for function: UDP! i.e. icemeasure udp <out> <in1> <levels>");
                }
                this.ho.setSubRecords("MAXDELTA|SD,ERRORS|SI");
                int levels = this.MA.get("LEVELS") == null ? this.MA.getL(4) : this.MA.getL("LEVELS");
                this.thresh = Math.pow(2.0, levels);
                this.xfer = (int)this.thresh;
                break;
            }
            default: {
                this.M.error("Error! Function TBD does not exist! Valid functions are Bandwidth,Characterize,Flash,Harmonics,Histogram,Mse,NoiseFloor,Notch,Npr,Sonet,Udp");
            }
        }
        this.ho.open(2);
        this.dbi1 = this.hi1.getDataBuffer(this.xfer);
        return 0;
    }

    public int process() {
        int n1 = this.hi1.read(this.dbi1);
        if (n1 < 0) {
            return 9;
        }
        double[] in1 = this.dbi1.castD(true);
        switch (this.func) {
            case 1: {
                int m;
                int tmpbeg = this.inds1[0];
                int tmpend = this.inds1[this.len1 - 1] + 1;
                System.arraycopy(in1, tmpbeg, this.data1, 0, this.len1);
                int[] sinds1 = (int[])this.inds1.clone();
                this.qsort.sort(this.data1, sinds1, this.len1);
                double median = this.data1[this.medind];
                double cur_thresh = median * this.thresh;
                for (m = 0; m < this.medind && !(this.data1[m] < cur_thresh); ++m) {
                }
                double pin = 100.0 * (double)m / (double)this.len1;
                double pout = 0.0;
                if (this.len2 > 0) {
                    System.arraycopy(in1, 0, this.data2, 0, tmpbeg);
                    System.arraycopy(in1, tmpend, this.data2, tmpbeg, this.xfer - tmpend);
                    int[] sinds2 = (int[])this.inds2.clone();
                    this.qsort.sort(this.data2, sinds2, this.len2);
                    for (m = 0; m < this.len2 && !(this.data2[m] < cur_thresh); ++m) {
                        pout = 100.0 * (double)(m + 1) / (double)this.xfer;
                    }
                }
                this.str = String.format("{MEDIAN=%f,IN=%f,OUT=%f}", 10.0 * Math.log10(median), pin, pout);
                break;
            }
            case 2: {
                int m;
                double peak = Double.MIN_VALUE;
                for (m = 0; m < this.len2; ++m) {
                    if (!(peak < in1[this.inds2[m]])) continue;
                    peak = in1[this.inds2[m]];
                }
                System.arraycopy(in1, this.inds1[0], this.data1, 0, this.len1);
                int[] sinds1 = (int[])this.inds1.clone();
                this.qsort.sort(this.data1, sinds1, this.len1);
                int ib = this.inds2[0];
                int ie = this.inds2[this.len2 - 1];
                double max_spur = Double.MIN_VALUE;
                int max_ind = -1;
                for (m = 0; m < this.len1; ++m) {
                    if (sinds1[m] >= ib && sinds1[m] <= ie) continue;
                    max_spur = this.data1[m];
                    max_ind = sinds1[m];
                    break;
                }
                double median = this.data1[this.medind];
                double cur_thresh = median * this.thresh;
                int ni = 0;
                for (m = 0; m < this.medind && !(this.data1[m] < cur_thresh); ++m) {
                    if (sinds1[m] >= ib && sinds1[m] <= ie) continue;
                    ++ni;
                }
                double cpow = 10.0 * Math.log10(peak);
                double spow = 10.0 * Math.log10(max_spur);
                double npow = 10.0 * Math.log10(median) - this.adj_val;
                this.str = String.format("{SNR=%s,SFDR=%s,NF=%s,THRESH=%s,SIG=%s,MAXSPUR=%s,MAXSPURFREQ=%s}", cpow - npow, cpow - spow, npow, 100.0 * (double)ni / (double)this.len1, cpow, spow, this.freqFromInd(max_ind));
                break;
            }
            case 3: {
                MDevIce pic = new MDevIce(this.MA, this.str);
                if (pic.open() <= 0) {
                    this.M.error("Cannot open alias: " + this.str);
                    return 9;
                }
                if (pic.reset(0) <= 0) {
                    this.M.error("Cannot reset card");
                    return 9;
                }
                if (pic.setKey(0, 32768, this.dbi1.buf, 65536) <= 0) {
                    this.M.error("Cannot set flash");
                    return 9;
                }
                byte[] buf = new byte[65536];
                if (pic.getKey(0, 32768, buf, 65536) <= 0) {
                    this.M.error("Cannot get flash");
                    return 9;
                }
                pic.close();
                int m = new String(this.dbi1.buf).equals(new String(buf)) ? 0 : 1;
                this.str = String.format("{ERROR=%s,SHA1=%s,SHA2=%s}", m, this.checkSum(this.dbi1.buf, 65536), this.checkSum(buf, 65536));
                break;
            }
            case 4: {
                int m;
                double peak1 = Double.MIN_VALUE;
                for (m = 0; m < this.len1; ++m) {
                    if (!(peak1 < in1[this.inds1[m]])) continue;
                    peak1 = in1[this.inds1[m]];
                }
                double peak2 = Double.MIN_VALUE;
                for (m = 0; m < this.len2; ++m) {
                    if (!(peak2 < in1[this.inds2[m]])) continue;
                    peak2 = in1[this.inds2[m]];
                }
                String harmstr = "";
                for (m = 0; m < this.spurs.size(); ++m) {
                    double cp = Double.MIN_VALUE;
                    int[] tmpinds = this.spurs.get(m).getIndices();
                    for (int n = 0; n < tmpinds.length; ++n) {
                        if (!(cp < in1[tmpinds[n]])) continue;
                        cp = in1[tmpinds[n]];
                    }
                    this.spurs.get(m).setMaxPower(cp, -1);
                    harmstr = String.format("%s,%sFREQ=%d", harmstr, this.spurs.get(m).getColumn(), (int)this.spurs.get(m).getFreq());
                    harmstr = String.format("%s,%sPOW=%.02f", harmstr, this.spurs.get(m).getColumn(), 10.0 * Math.log10(this.spurs.get(m).getMaxPower()));
                    harmstr = String.format("%s,%sDBC=%.02f", harmstr, this.spurs.get(m).getColumn(), -10.0 * Math.log10(peak1 / this.spurs.get(m).getMaxPower()));
                }
                System.arraycopy(in1, this.indsn[0], this.datan, 0, this.lenn);
                int[] sindsn = (int[])this.indsn.clone();
                this.qsort.sort(this.datan, sindsn, this.lenn);
                int i1b = this.inds1[0];
                int i1e = this.inds1[this.len1 - 1];
                int i2b = this.inds2[0];
                int i2e = this.inds2[this.len2 - 1];
                double maxHarm = Double.MIN_VALUE;
                int maxInd = -1;
                for (m = 0; m < this.lenn; ++m) {
                    if (sindsn[m] >= i1b && sindsn[m] <= i1e || sindsn[m] >= i2b && sindsn[m] <= i2e) continue;
                    maxHarm = this.datan[m];
                    maxInd = sindsn[m];
                    break;
                }
                int np = 0;
                double median = this.datan[this.medind];
                double cur_thresh = median * this.thresh;
                for (m = 0; m < this.medind && !(this.datan[m] < cur_thresh); ++m) {
                    if (sindsn[m] >= i1b && sindsn[m] <= i1e || sindsn[m] >= i2b && sindsn[m] <= i2e) continue;
                    ++np;
                }
                this.str = String.format("{SNR=%.02f,S1S2=%.02f,SFDR=%.02f,NF=%02f,THRESH=%.02f,MAXSPURFREQ=%d,MAXSPUR=%.02f%s}", 10.0 * Math.log10(peak1 / median) + this.adj_val, 10.0 * Math.log10(peak1 / peak2), 10.0 * Math.log10(peak1 / maxHarm), 10.0 * Math.log10(median) - this.adj_val, 100.0 * (double)np / (double)this.lenn, (int)this.unmapFreq(this.freqFromInd(maxInd)), 10.0 * Math.log10(maxHarm), harmstr);
                break;
            }
            case 5: {
                int m;
                int bits = this.bit_accumr.length;
                for (m = 0; m < bits; ++m) {
                    this.bit_accumi[m] = 0L;
                    this.bit_accumr[m] = 0L;
                }
                for (m = 0; m < 2 * n1; m += 2) {
                    int valr = (int)(in1[m] >= 0.0 ? in1[m] : 0.0);
                    int vali = (int)(in1[m + 1] >= 0.0 ? in1[m + 1] : 0.0);
                    for (int n = 0; n < bits; ++n) {
                        if (valr >= this.indsn[n]) {
                            int n2 = n;
                            this.bit_accumr[n2] = this.bit_accumr[n2] + 1L;
                            valr %= this.indsn[n];
                        }
                        if (vali < this.indsn[n]) continue;
                        int n3 = n;
                        this.bit_accumi[n3] = this.bit_accumi[n3] + 1L;
                        vali %= this.indsn[n];
                    }
                }
                this.str = "{REMSB=" + this.bit_accumr[0] + ",IMMSB=" + this.bit_accumi[0];
                for (m = 1; m < bits; ++m) {
                    this.str = this.str + ",RE" + m + "=" + this.bit_accumr[m] + ",IM" + m + "=" + this.bit_accumi[m];
                }
                this.str = this.str + "}";
                break;
            }
            case 6: {
                int m;
                int n2 = this.hi2.read(this.dbi2);
                if (n2 < 0) {
                    return 9;
                }
                double[] in2 = this.dbi2.castD(true);
                double accum2 = 0.0;
                double accum1 = 0.0;
                for (m = 0; m < this.len1; ++m) {
                    this.data1[m] = Math.sqrt(in1[this.inds1[m]]);
                    this.data2[m] = Math.sqrt(in2[this.inds1[m]]);
                    accum1 += this.data1[m] / (double)this.len1;
                    accum2 += this.data2[m] / (double)this.len1;
                }
                this.dbi2.uncast(in2, false);
                double delta = accum1 / accum2;
                double worst = -1.0;
                double accum = 0.0;
                double invdenom = 1.0 / (accum1 * accum1 * (double)this.len1 / (double)this.indsn.length);
                int n = this.inds1[0];
                int z = 0;
                for (m = 0; m < this.indsn.length; ++m) {
                    double acc2 = 0.0;
                    double acc1 = 0.0;
                    while (n < this.indsn[m]) {
                        acc1 += this.data1[z];
                        acc2 += this.data2[z];
                        ++n;
                        ++z;
                    }
                    double cur = Math.pow(acc1 - delta * acc2, 2.0) * invdenom;
                    if (worst < cur) {
                        worst = cur;
                    }
                    accum += cur;
                }
                this.str = String.format("{AVERAGE=%f,WORST=%f}", accum / (double)this.indsn.length, worst);
                break;
            }
            case 7: {
                int m;
                System.arraycopy(in1, this.inds1[0], this.data1, 0, this.len1);
                int[] sinds1 = (int[])this.inds1.clone();
                this.qsort.sort(this.data1, sinds1, this.len1);
                double median = this.data1[this.medind];
                double cur_thresh = this.thresh * median;
                for (m = 0; m < this.medind && !(this.data1[m] < cur_thresh); ++m) {
                }
                this.str = String.format("{NF=%f,THRESH=%f,MAXSPUR=%f,MAXSPURFREQ=%f}", 10.0 * Math.log10(median) - this.adj_val, 100.0 * (double)(m + 1) / (double)this.len1, 10.0 * Math.log10(this.data1[0]), this.freqFromInd(sinds1[0]));
                break;
            }
            case 8: {
                System.arraycopy(in1, this.inds1[0], this.data1, 0, this.len1);
                System.arraycopy(in1, this.inds2[0], this.data2, 0, this.len2);
                int[] sinds1 = (int[])this.inds1.clone();
                this.qsort.sort(this.data1, sinds1, this.len1);
                int[] sinds2 = (int[])this.inds2.clone();
                this.qsort.sort(this.data2, sinds2, this.len2);
                double peak = Double.MIN_VALUE;
                for (int m = this.inds1[0]; m < this.inds1[this.len1 - 1]; ++m) {
                    if (!(peak < in1[m])) continue;
                    peak = in1[m];
                }
                this.str = String.format("{MEDIAN=%f,NOTCH=%f,TONE=%f}", 10.0 * Math.log10(this.data2[this.len2 / 2]), 10.0 * Math.log10(this.data1[this.len1 / 2]), 10.0 * Math.log10(peak));
                break;
            }
            case 9: {
                int m;
                double accum1 = 0.0;
                for (m = 0; m < this.inds1.length; ++m) {
                    accum1 += in1[this.inds1[m]];
                }
                accum1 /= (double)this.inds1.length;
                double accum2 = 0.0;
                for (m = 0; m < this.inds2.length; ++m) {
                    accum2 += in1[this.inds2[m]];
                }
                accum2 /= (double)this.inds2.length;
                double accumn = 0.0;
                for (m = 0; m < this.indsn.length; ++m) {
                    accumn += in1[this.indsn[m]];
                }
                this.str = String.format("{SIGNAL=%f,NOTCH=%f}", 10.0 * Math.log10(accum1 / accum2), 10.0 * Math.log10(accum1 / (accumn /= (double)this.indsn.length)));
                break;
            }
            case 10: {
                int n2 = this.hi2.read(this.dbi2);
                int n = this.len1 = n2 > n1 ? n1 : n2;
                if (this.len1 <= 0) {
                    return 9;
                }
                double[] in2 = this.dbi2.castD(true);
                switch (this.mode) {
                    case 24: {
                        for (int m = 0; m < this.len1; ++m) {
                            if (in1[m] == in2[m]) continue;
                            this.matched = 0;
                            ++this.seek_ind;
                            this.hi1.seek((double)(this.seek_ind * this.xfer));
                            this.hi2.seek((double)this.skip);
                            this.dbi1.uncast(in1, false);
                            this.dbi2.uncast(in2, false);
                            return 0;
                        }
                        this.dbi1.uncast(in1, false);
                        this.dbi2.uncast(in2, false);
                        ++this.matched;
                        if (this.matched >= this.frames) {
                            this.mode = 25;
                            this.hi1.seek((double)(this.seek_ind * this.xfer));
                            this.hi2.seek((double)this.skip);
                            this.MR.put(this.str, this.seek_ind * this.xfer);
                        }
                        return 0;
                    }
                    case 25: {
                        double accum2 = 0.0;
                        double accum1 = 0.0;
                        for (int m = 0; m < this.len1; ++m) {
                            if (in1[m] == in2[m]) continue;
                            accum1 += 1.0;
                        }
                        this.dbi2.uncast(in2, false);
                        this.str = String.format("{ERRORS=%s,PROC=%s,BER=%.02f}", accum1, accum2 += (double)this.len1, 100.0 * (accum1 / accum2));
                    }
                }
                break;
            }
            case 11: {
                double max_delta = 0.0;
                int errs = 0;
                for (int m = 1; m < in1.length; ++m) {
                    double cur = Math.abs(in1[m] - in1[m - 1]);
                    if (cur == 2.0 * this.thresh - 1.0) continue;
                    if (cur > max_delta) {
                        max_delta = cur;
                    }
                    if (!(cur > 1.0)) continue;
                    ++errs;
                }
                this.str = String.format("{MAXDELTA=%f,ERRORS=%s}", max_delta, errs);
                break;
            }
            default: {
                this.str = null;
                this.M.error("Got through to default case!!");
            }
        }
        this.ho.insertData(-1.0, (Object)new Table(this.str));
        this.dbi1.uncast(in1, false);
        return 0;
    }

    public int close() {
        this.hi1.close();
        this.ho.close();
        if (this.hi2 != null) {
            this.hi2.close();
        }
        return 9;
    }

    private double mapFreq(double freq) {
        return this.complex ? freq + 0.5 * this.fs : freq;
    }

    private double unmapFreq(double freq) {
        return this.complex ? freq - 0.5 * this.fs : freq;
    }

    private double freqFromInd(int ind) {
        return this.complex ? (double)ind * this.fpb - 0.5 * this.fs : (double)ind * this.fpb;
    }

    private int[] fillIndices(double freq, int np, int dcinds) {
        if (freq < 0.0 || freq >= this.fs) {
            int[] out = new int[]{0};
            return out;
        }
        double cb1 = freq / this.fpb;
        int ib = (int)Math.floor(cb1 - 0.5 * (double)np);
        int ie = (int)Math.ceil(cb1 + 0.5 * (double)np);
        ib = ib < dcinds ? dcinds : ib;
        int n = ie = ie >= this.xfer - (dcinds + 1) ? this.xfer - (dcinds + 1) : ie;
        if (ib >= this.xfer || ie <= 0 || ie < ib) {
            this.M.warning((CharSequence)"Signal falls outside of sampling rate!!!");
            int[] out = new int[]{0};
            return out;
        }
        int[] out = new int[ie - ib + 1];
        int m = 0;
        int n2 = ib;
        while (n2 <= ie) {
            out[m] = n2++;
            ++m;
        }
        return out;
    }

    private int[] detInds(double strt, double wid) {
        int beg = (int)Math.ceil((double)this.xfer * strt);
        int np = (int)Math.floor((double)this.xfer * wid);
        int[] points = new int[np];
        for (int m = 0; m < np; ++m) {
            points[m] = m + beg;
        }
        return points;
    }

    private int detDcInds(int nfft) {
        return (int)Math.floor(0.01 * (double)nfft);
    }

    private String checkSum(byte[] in, int len) {
        try {
            MessageDigest hash = MessageDigest.getInstance("SHA-256");
            hash.update(in, 0, len);
            byte[] dig = hash.digest();
            StringBuffer sb = new StringBuffer();
            for (int m = 0; m < dig.length; ++m) {
                sb.append(String.format("%02x", dig[m] & 0xFF));
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private class QuickSort {
        private double[] out;
        private int[] ind;

        private QuickSort() {
        }

        public void sort(double[] vals, int[] inds, int len) {
            this.out = vals;
            this.ind = inds;
            this.quicksortInds(0, len - 1);
        }

        public void sort(double[] vals, int len) {
            this.out = vals;
            this.quicksort(0, len - 1);
        }

        private void quicksortInds(int low, int high) {
            int i = low;
            int j = high;
            double pivot = this.out[low + (high - low) / 2];
            while (i <= j) {
                while (this.out[i] > pivot) {
                    ++i;
                }
                while (this.out[j] < pivot) {
                    --j;
                }
                if (i > j) continue;
                this.swapInds(i, j);
                ++i;
                --j;
            }
            if (low < j) {
                this.quicksortInds(low, j);
            }
            if (i < high) {
                this.quicksortInds(i, high);
            }
        }

        private void quicksort(int low, int high) {
            int i = low;
            int j = high;
            double pivot = this.out[low + (high - low) / 2];
            while (i <= j) {
                while (this.out[i] > pivot) {
                    ++i;
                }
                while (this.out[j] < pivot) {
                    --j;
                }
                if (i > j) continue;
                this.swap(i, j);
                ++i;
                --j;
            }
            if (low < j) {
                this.quicksort(low, j);
            }
            if (i < high) {
                this.quicksort(i, high);
            }
        }

        private void swapInds(int i, int j) {
            double tval = this.out[i];
            int tind = this.ind[i];
            this.out[i] = this.out[j];
            this.out[j] = tval;
            this.ind[i] = this.ind[j];
            this.ind[j] = tind;
        }

        private void swap(int i, int j) {
            double tval = this.out[i];
            this.out[i] = this.out[j];
            this.out[j] = tval;
        }
    }

    private class IceSpur {
        private int[] inds = null;
        private double freq = 0.0;
        private double maxpow = 0.0;
        private int maxind = -1;
        private String col = null;

        public void setIndices(int[] in) {
            this.inds = in;
        }

        public void setMaxPower(double f, int d) {
            this.maxpow = f;
            this.maxind = d;
        }

        public void setColumn(String s) {
            this.col = s;
        }

        public void setFreq(double f) {
            this.freq = f;
        }

        public int[] getIndices() {
            return this.inds;
        }

        public double getMaxPower() {
            return this.maxpow;
        }

        public int getMaxInd() {
            return this.maxind;
        }

        public String getColumn() {
            return this.col;
        }

        public double getFreq() {
            return this.freq;
        }
    }
}

