/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.Core;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;

public class icejvm
extends Primitive {
    Table refTab;
    Table lnTab;
    Table bcTab;
    Table foTab;
    ConstantPool[] jcp;
    OpCode[] joc;
    byte rep = (byte)73;
    int classPtr = 0;
    int memMode = 0;
    int cSlots = 1;
    int vSlots = 0;
    int rSlot = 0;
    int codeBase;
    int cpLen;
    int codeLen;
    int maxBytes;
    int maxPool;
    byte[] dbuf;
    byte[] mbuf;
    byte[] tbuf;
    boolean v1;
    boolean v2;
    boolean pre;
    boolean boot;
    Core core;
    private static final int A_PUBLIC = 1;
    private static final int A_PRIVATE = 2;
    private static final int A_PROTECTED = 4;
    private static final int A_STATIC = 8;
    private static final int A_FINAL = 16;
    private static final int A_VOLATILE = 32;
    private static final int A_TRANSIENT = 64;
    private static final int A_NATIVE = 128;
    private int methodStack;
    private int methodLocals;
    private int methodLength;
    private static int PSEUDO = 0x800010;

    public int open() {
        int i;
        String line;
        this.pre = this.MA.getState("/PRE");
        this.boot = this.MA.getState("/BOOT");
        int v = this.MA.getL("/VERBOSE");
        this.v1 = v >= 1;
        boolean bl = this.v2 = v >= 2;
        if (this.MA.isPresent("/CORE")) {
            return this.runjvmcore();
        }
        this.foTab = Convert.o2t((Object)"nxm.ice.dat.jvmfields.tbl", (Object)this.M);
        TextFile bc = new TextFile((MidasReference)this.M, (Object)"nxm.ice.dat.jvmcodes.lst");
        bc.open(1);
        this.bcTab = new Table();
        this.joc = new OpCode[256];
        while ((line = bc.readProper()) != null) {
            new OpCode(line);
        }
        bc.close();
        DataFile bf = new DataFile((MidasReference)this.M, (Object)"nxm.ice.dat.jvmcodes.prm", "1000", "SL", 0);
        bf.open(2);
        Data bfd = bf.getDataBuffer(512);
        for (int i2 = 0; i2 < 256; ++i2) {
            if (this.joc[i2] == null) continue;
            if (this.joc[i2].code < 0 || this.joc[i2].code > 255) {
                this.M.error("Bad Byte Code definition: " + this.joc[i2]);
            }
            int c = this.joc[i2].code & 0xFF;
            bfd.setL(0 | c, this.joc[i2].inst1);
            bfd.setL(0x100 | c, this.joc[i2].inst2);
        }
        bf.write(bfd);
        bf.close();
        this.maxBytes = this.MA.getL("/MAXCODE", 16384);
        this.dbuf = new byte[this.maxBytes];
        this.mbuf = new byte[this.maxBytes];
        this.tbuf = new byte[2];
        this.tbuf[1] = 2;
        this.tbuf[0] = 0;
        this.codeBase = this.classPtr = 0;
        this.lnTab = new Table();
        this.refTab = new Table();
        this.maxPool = this.MA.getL("/MAXPOOL", 1024);
        this.jcf2m(this.MA.getCS("JCF"));
        DataFile df = this.MA.getDataFile("JLF", "1000", "SI", 0, (double)this.codeLen, null);
        df.setComment("ICE JVM Load File");
        df.keywords.put("CODELEN", (Object)new Data(this.codeLen));
        df.setExt("prm");
        df.open(2);
        if (this.boot) {
            for (i = 0; i < 2048; ++i) {
                df.write(bfd.buf, i, 1);
                df.write(this.tbuf, 1, 1);
            }
        }
        for (i = 0; i < this.codeLen; ++i) {
            df.write(this.dbuf, i, 1);
            df.write(this.mbuf, i, 1);
        }
        df.close();
        return 9;
    }

    private void print(String s) {
        if (this.v1) {
            System.out.print(s);
        }
    }

    private void println(String s) {
        if (this.v1) {
            System.out.println(s);
        }
    }

    private void vprint(String s) {
        if (this.v2) {
            System.out.print(s);
        }
    }

    private void vprintln(String s) {
        if (this.v2) {
            System.out.println(s);
        }
    }

    private void jcf2m(String jcf) {
        this.println("Open classfile=" + jcf);
        BaseFile bf = new BaseFile((MidasReference)this.M, (Object)jcf);
        bf.setExt("class");
        bf.open(1);
        int bytes = (int)bf.getSize();
        byte[] buf = new byte[bytes + 16];
        bf.read(buf, 0, bytes);
        bf.close();
        this.jcp = new ConstantPool[this.maxPool];
        int i = 0;
        int j = 0;
        int k = 0;
        int magic = Convert.unpackL((byte[])buf, (int)i, (byte)this.rep);
        short minor = Convert.unpackI((byte[])buf, (int)(i += 4), (byte)this.rep);
        short major = Convert.unpackI((byte[])buf, (int)(i += 2), (byte)this.rep);
        this.println("Magic=" + Convert.l2x((int)magic) + " Minor=" + minor + " Major=" + major);
        int cpcnt = Convert.unpackI((byte[])buf, (int)(i += 2), (byte)this.rep);
        i += 2;
        this.println("Constant Count=" + cpcnt);
        for (j = 1; j < cpcnt; j += this.jcp[j].slots) {
            i = this.getConstant(j, buf, i);
        }
        for (j = 1; j < cpcnt; j += this.jcp[j].slots) {
            this.setConstant(j);
        }
        short access = Convert.unpackI((byte[])buf, (int)i, (byte)this.rep);
        short cthis = Convert.unpackI((byte[])buf, (int)(i += 2), (byte)this.rep);
        short csuper = Convert.unpackI((byte[])buf, (int)(i += 2), (byte)this.rep);
        String cnthis = this.getC(this.getI(cthis));
        String cnsuper = this.getC(this.getI(csuper));
        this.println("Access=" + this.getAcc(access) + " this=" + cnthis + " super=" + cnsuper);
        int ifcnt = Convert.unpackI((byte[])buf, (int)(i += 2), (byte)this.rep);
        i += 2;
        this.println("Interfaces count=" + ifcnt);
        for (j = 0; j < ifcnt; ++j) {
            i = this.getInterface(j, buf, i);
        }
        int fcnt = Convert.unpackI((byte[])buf, (int)i, (byte)this.rep);
        i += 2;
        this.println("Field count=" + fcnt);
        for (j = 0; j < fcnt; ++j) {
            i = this.getField(j, buf, i);
        }
        this.codeLen = this.codeBase + this.cSlots * 4;
        if (!cnsuper.equals("java/lang/Object")) {
            String sname = StringUtil.replaceAll((String)cnsuper, (String)"/", (String)".");
            ConstantPool[] jcpi = this.jcp;
            this.jcf2m(sname);
            this.jcp = jcpi;
        }
        this.cpLen = this.codeLen;
        int mcnt = Convert.unpackI((byte[])buf, (int)i, (byte)this.rep);
        i += 2;
        this.println("Method count=" + mcnt);
        for (j = 0; j < mcnt; ++j) {
            i = this.getMethod(j, buf, i);
        }
        int acnt = Convert.unpackI((byte[])buf, (int)i, (byte)this.rep);
        i += 2;
        this.println("Attributes count=" + acnt);
        for (j = 0; j < acnt; ++j) {
            i = this.getAttribute(j, buf, i, false);
        }
        if (i != bytes) {
            this.println("Extra bytes=" + (bytes - i));
        }
        this.println("Total Load cSlots=" + this.cSlots + " vSlots=" + this.vSlots + " bytes=" + this.codeLen);
        for (k = 0; k < this.classPtr + 4; ++k) {
            this.dbuf[k] = 0;
            this.mbuf[k] = 0;
        }
        k = this.classPtr + 1;
        this.mbuf[k] = 1;
        this.dbuf[k] = -72;
        this.dbuf[k + 1] = (byte)this.rSlot;
        if (this.v2) {
            this.refTab.dump();
        }
        if (!this.pre) {
            this.getCode(this.dbuf, this.cpLen, this.codeLen - this.cpLen, this.mbuf);
        }
        this.println("Close classfile=" + jcf);
    }

    private int getConstant(int id, byte[] buf, int i) {
        ConstantPool cp;
        this.jcp[id] = cp = new ConstantPool(buf, i);
        return i + cp.size;
    }

    private void setConstant(int id) {
        ConstantPool cp = this.jcp[id];
        switch (cp.tag) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                cp.slot = this.cSlots;
                this.cSlots += cp.slots;
                int len = cp.slots * 4;
                cp.offset = this.codeBase + cp.slot * 4;
                System.arraycopy(((Data)cp.value).buf, 0, this.dbuf, cp.offset, len);
                break;
            }
            case 9: 
            case 10: {
                if (cp.tag == 10) {
                    cp.slot = this.cSlots++;
                }
                int cid = cp.getI(0);
                int nid = cp.getI(1);
                int cidn = this.jcp[cid].getI(0);
                int nidn = this.jcp[nid].getI(0);
                int nidt = this.jcp[nid].getI(1);
                String cname = this.jcp[cidn].getS();
                String fname = this.jcp[nidn].getS();
                String ftype = this.jcp[nidt].getS();
                cp.name = cname + "." + fname + "<" + ftype + ">";
                if (cp.tag == 10) {
                    this.refTab.put(fname, cp.slot);
                }
                if (cp.tag != 10 || !fname.equals("run")) break;
                this.rSlot = cp.slot;
            }
        }
        this.println("Const#" + id + " " + cp);
    }

    private String getC(int id) {
        return this.jcp[id].value.toString();
    }

    private int getI(int id) {
        return Convert.o2l((Object)this.jcp[id].value);
    }

    private int getInterface(int id, byte[] buf, int i) {
        return i + 2;
    }

    private String getAcc(int access) {
        return Parser.mask2s((String)"Public,Priv,Prot,Static,Final,Volatile,Transient,X,Native", (int)access);
    }

    private int getField(int id, byte[] buf, int i) {
        short access = Convert.unpackI((byte[])buf, (int)i, (byte)this.rep);
        short name = Convert.unpackI((byte[])buf, (int)(i += 2), (byte)this.rep);
        short descr = Convert.unpackI((byte[])buf, (int)(i += 2), (byte)this.rep);
        int attr = Convert.unpackI((byte[])buf, (int)(i += 2), (byte)this.rep);
        i += 2;
        String fname = this.getC(name);
        int slot = 0;
        String tostr = "Field#" + id + " access=" + this.getAcc(access) + " attr=" + attr + " desc=" + this.getC(descr) + " name=" + fname;
        if ((access & 8) != 0) {
            if ((access & 0x10) == 0 && this.specialStatic(fname) == 0) {
                slot = this.cSlots++;
                this.refTab.put(fname, slot);
            }
        } else {
            slot = this.vSlots++;
        }
        this.println(tostr + " slot=" + slot);
        for (int j = 0; j < attr; ++j) {
            i = this.getAttribute(j, buf, i, false);
        }
        return i;
    }

    private int getMethod(int id, byte[] buf, int i) {
        short access = Convert.unpackI((byte[])buf, (int)i, (byte)this.rep);
        short name = Convert.unpackI((byte[])buf, (int)(i += 2), (byte)this.rep);
        String sname = this.getC(name);
        short descr = Convert.unpackI((byte[])buf, (int)(i += 2), (byte)this.rep);
        int attr = Convert.unpackI((byte[])buf, (int)(i += 2), (byte)this.rep);
        i += 2;
        int cptr = this.classPtr >> 2 & 0xFFF;
        int tag = this.codeLen & 0x3FFF;
        int nargs = this.getNArgs(this.getC(descr));
        int slot = Convert.o2l((Object)this.refTab.get(sname));
        if (this.classPtr > this.maxBytes) {
            this.M.error("Class pointer" + this.classPtr + " exceeded max=" + this.maxBytes);
        }
        if (this.codeLen > this.maxBytes) {
            this.M.error("Code length=" + this.codeLen + " exceeded max=" + this.maxBytes);
        }
        String tostr = "Method#" + id + " access=" + this.getAcc(access) + " attr=" + attr + " desc=" + this.getC(descr) + " name=" + sname + " slot=" + slot;
        this.lnTab.put("" + this.codeLen, (Object)tostr);
        for (int j = 0; j < attr; ++j) {
            i = this.getAttribute(j, buf, i, true);
        }
        int gap = this.methodLocals - nargs + 1;
        if (nargs > 15) {
            this.M.error("Too many args=" + nargs);
        }
        if (gap > 32) {
            this.M.error("Too many args+locals=" + gap);
        }
        int mgap = gap > 12 ? 3 : (gap > 4 ? 2 : (gap > 1 ? 1 : 0));
        this.println(tostr + " Args=" + nargs + " Locals=" + this.methodLocals + " Stack=" + this.methodStack + " slot=" + slot);
        if (slot > 0) {
            Convert.packL((byte[])this.dbuf, (int)(this.codeBase + slot * 4), (int)(tag << 0 | mgap << 14 | cptr << 16 | nargs << 28));
        }
        while ((this.codeLen & 3) != 0) {
            ++this.codeLen;
        }
        return i;
    }

    private int getAttribute(int id, byte[] buf, int i, boolean code) {
        short name = Convert.unpackI((byte[])buf, (int)i, (byte)this.rep);
        int len = Convert.unpackL((byte[])buf, (int)(i += 2), (byte)this.rep);
        int inext = (i += 4) + len;
        this.vprint("Attribute#" + id + " name=" + this.getC(name) + " off=" + this.codeLen + " len=" + len);
        if (code) {
            this.methodStack = Convert.unpackI((byte[])buf, (int)i, (byte)this.rep);
            this.methodLocals = Convert.unpackI((byte[])buf, (int)(i += 2), (byte)this.rep);
            int length = Convert.unpackL((byte[])buf, (int)(i += 2), (byte)this.rep);
            int itop = i += 4;
            int codeLenX = this.codeLen + length;
            this.vprint(" codeLen=" + length);
            if (codeLenX > this.maxBytes) {
                this.M.error("Too large of code section=" + codeLenX + ", max=" + this.maxBytes);
            }
            System.arraycopy(buf, itop, this.dbuf, this.codeLen, length);
            this.codeLen = codeLenX;
        }
        this.vprintln("");
        return inext;
    }

    private int getNArgs(String desc) {
        char c;
        int nargs = 0;
        for (int i = 0; i < desc.length() && (c = desc.charAt(i)) != ')'; ++i) {
            ++nargs;
            if (c == '(') {
                nargs = 0;
            }
            if (c != 'L') continue;
            i = desc.indexOf(59, i);
        }
        return nargs;
    }

    private void getCode(byte[] buf, int itop, int length, byte[] mbuf) {
        OpCode bclast = null;
        int i = itop;
        while (i < itop + length) {
            int ic = buf[i] & 0xFF;
            OpCode bc = this.joc[ic];
            if (bc == null) {
                this.M.error("Unhandled Java Byte Code = " + ic);
            }
            if (bc.niy) {
                this.M.warning((CharSequence)("Uses unimplemented Java Byte Code " + ic + " = " + bc.name));
            } else if (mbuf != null && !bc.name.equals("nop")) {
                mbuf[i] = 1;
            }
            OpCode bcq = (OpCode)this.bcTab.get(bc.name + "_quick");
            Object lns = this.lnTab.get("" + i);
            if (lns != null) {
                this.vprintln(lns.toString());
            }
            int lni = i;
            int ln = i - itop;
            String pc = Convert.l2x((int)i).substring(6);
            String bcx = Convert.l2x((int)ic).substring(8);
            this.vprint(" " + pc + " " + ln + " " + bcx + " " + bc.name);
            short iarg = Convert.unpackI((byte[])buf, (int)(++i), (byte)this.rep);
            if (bc.args == 2) {
                Convert.swap2((byte[])buf, (int)i, (int)1);
            }
            if (bc.args == 4) {
                Convert.swap4((byte[])buf, (int)i, (int)1);
            }
            if (bc.args > 0) {
                this.vprint(" " + Convert.bb2hex((byte[])buf, (int)i, (int)bc.args));
                i += bc.args;
            }
            if (bc.name.startsWith("goto") || bc.name.startsWith("if")) {
                this.vprint(" (line=" + (ln + iarg) + ")");
                Convert.packI((byte[])buf, (int)(i - 2), (short)((short)(itop + ln + iarg)));
            } else if (bc.name.startsWith("new")) {
                Data d = (Data)this.jcp[iarg].value;
                this.vprint(" (" + this.getC(d.getI(0)) + ")");
            } else if ((bc.inst1 & PSEUDO) == PSEUDO) {
                String mname = "_" + bc.name;
                int slot = this.refTab.getL(mname);
                if (slot == 0) {
                    this.M.warning((CharSequence)(" (Pseudo Method not found for " + mname + " slot)"));
                }
                int n = lni;
                mbuf[n] = (byte)(mbuf[n] | 4);
                this.dbuf[lni] = (byte)slot;
            } else if (bc.name.startsWith("invoke") && iarg == 0) {
                this.vprint(" (Method not found at line=" + i + ")");
            } else if (bc.name.startsWith("invoke")) {
                Data d = (Data)this.jcp[iarg].value;
                Data e = (Data)this.jcp[d.getI((int)1)].value;
                String mname = this.getC(e.getI(0));
                String mtype = this.getC(e.getI(1));
                int slot = this.refTab.getL(mname);
                this.vprint(" (" + mtype + " " + mname + ") S:" + slot);
                if (mname.equals("getObjectAt") && mtype.equals("(I)Ljava/lang/Object;")) {
                    buf[i - 1] = 0;
                    buf[i - 2] = 0;
                    buf[i - 3] = 0;
                } else if (slot <= 0) {
                    this.M.warning((CharSequence)("No Constant Pool entry for method=" + mname));
                } else if (iarg > 255) {
                    this.M.warning((CharSequence)("Method offset=" + iarg + " too large for method=" + mname));
                } else {
                    buf[i - 2] = (byte)slot;
                }
            } else if (bc.name.startsWith("iinc")) {
                Convert.swap2((byte[])buf, (int)(i - 2), (int)1);
            } else if (bc.name.startsWith("ldc")) {
                int cp = this.b2l(buf[i - 1]);
                if (cp <= 0) {
                    this.M.error("No Constant Pool entry for constant=" + cp);
                }
                this.vprint(" (" + Convert.l2x((int)Convert.o2l((Object)this.jcp[cp].value)) + ")");
                buf[i - 1] = (byte)this.jcp[cp].slot;
                buf[i - 2] = bcq.bc;
            } else if (bc.name.endsWith("load") || bc.name.endsWith("store")) {
                int off = this.b2l(buf[i - 1]);
                if (off > 63) {
                    System.out.println(" ERR: load/store offset " + off + " out of range");
                }
            } else if (bc.name.startsWith("get") || bc.name.startsWith("put")) {
                Data d = (Data)this.jcp[iarg].value;
                Data e = (Data)this.jcp[d.getI((int)1)].value;
                Data f = (Data)this.jcp[d.getI((int)0)].value;
                String fclas = this.getC(f.toL());
                String fname = this.getC(e.getI(0));
                String ftype = this.getC(e.getI(1));
                int ip = fclas.lastIndexOf("/");
                String foname = fclas.substring(ip + 1) + "." + fname;
                boolean get = bc.name.startsWith("get");
                int xcmd = bcq.bc;
                int xact = 0;
                byte xoff = 0;
                if (bc.name.indexOf("static") > 0) {
                    int xsc;
                    int n = xsc = get ? -2 : -1;
                    if (this.specialStatic(fname) > 0) {
                        if (fname.equals("ioadr")) {
                            xcmd = xsc;
                            xact = 2;
                        }
                        if (fname.equals("saddr")) {
                            xcmd = xsc;
                            xact = 2;
                        }
                        if (fname.equals("sdata")) {
                            xcmd = xsc;
                            int n2 = xact = get ? 8 : 4;
                        }
                        if (fname.equals("ioctl")) {
                            xcmd = xsc;
                            xact = 16;
                        }
                        if (fname.equals("maddr")) {
                            xcmd = xsc;
                            xact = 32;
                            this.memMode = 1;
                        }
                        if (fname.equals("mdata")) {
                            xcmd = xsc;
                            int n3 = xact = get ? -128 : 64;
                            if (this.memMode != 1) {
                                this.M.error("Cannot mix maddr access modes. Check mdata = class.field combo.");
                            }
                        }
                        this.vprint(" (" + ftype + " " + foname + ")");
                    } else {
                        int slot = this.refTab.getL(fname);
                        if (slot > 0) {
                            xact = (byte)slot;
                        } else {
                            this.M.warning((CharSequence)("No Constant Pool entry for static field=" + fname));
                        }
                        if (slot > 255) {
                            this.M.error("Too many static variables=" + slot + ". Max=256.");
                        }
                        this.vprint(" (" + ftype + " " + foname + " off=" + xact + ")");
                    }
                } else {
                    int n = xact = get ? -96 : 97;
                    if (this.foTab.get(foname.toUpperCase()) == null) {
                        this.M.warning((CharSequence)("Field=" + foname + " not defined in jvmfields"));
                    }
                    int foff = this.foTab.getL(foname.toUpperCase());
                    this.vprint(" (" + ftype + " " + foname + " off=" + foff + ")");
                    xoff = (byte)(foff >= 128 ? foff - 256 : foff);
                    this.memMode = 0;
                }
                buf[i - 3] = xcmd;
                buf[i - 2] = xact;
                buf[i - 1] = xoff;
            } else if (bc.name.startsWith("tableswitch")) {
                int j;
                while ((i - itop & 3) != 0) {
                    ++i;
                }
                Convert.swap4((byte[])buf, (int)i, (int)3);
                int vdf = Convert.unpackL((byte[])buf, (int)i);
                int vlo = Convert.unpackL((byte[])buf, (int)(i += 4));
                int vhi = Convert.unpackL((byte[])buf, (int)(i += 4));
                int vcnt = vhi - vlo + 1;
                Convert.swap4((byte[])buf, (int)(i += 4), (int)vcnt);
                for (j = lni + 1; j < i; ++j) {
                    buf[j] = 0;
                }
                buf[lni + 1] = (byte)(vlo - 1);
                buf[lni + 2] = (byte)vcnt;
                Convert.packI((byte[])buf, (int)(lni + 3), (short)((short)(i - 4)));
                i -= 4;
                this.vprint(" (" + vdf + "," + vlo + "," + vhi + ")");
                if (vlo < 0 || vlo > 127) {
                    this.M.warning((CharSequence)("Table switch low index=" + vlo + " out of range (0<=N<128)"));
                }
                if (vhi < 0 || vhi > 127) {
                    this.M.warning((CharSequence)("Table switch high index=" + vhi + " out of range (0<=N<128)"));
                }
                for (j = -1; j < vcnt; ++j) {
                    int vjmp;
                    int vjo = j < 0 ? vdf : Convert.unpackL((byte[])buf, (int)i);
                    int vjmpr = vjmp = lni + vjo;
                    this.vprint("\n      " + (i - itop) + "  " + j + ": " + vjo + " (line=" + Convert.l2x((int)vjmpr) + " @ " + Convert.l2x((int)i));
                    Convert.packL((byte[])buf, (int)i, (int)vjmpr);
                    i += 4;
                }
            } else if (bc.name.startsWith("lookupswitch")) {
                while ((i - itop & 3) != 0) {
                    ++i;
                }
                Convert.swap4((byte[])buf, (int)i, (int)2);
                int vdf = Convert.unpackL((byte[])buf, (int)i);
                int vnp = Convert.unpackL((byte[])buf, (int)(i += 4));
                this.vprint(" (" + vdf + "," + vnp + ")");
                Convert.swap4((byte[])buf, (int)(i += 4), (int)(vnp * 2));
                for (int j = 0; j < vnp; ++j) {
                    int vmv = Convert.unpackL((byte[])buf, (int)i);
                    int vjo = Convert.unpackL((byte[])buf, (int)(i + 4));
                    this.vprint("\n      " + (i - itop) + "  " + vmv + ": " + vjo + " (line=" + (ln + vjo) + ")");
                    i += 8;
                }
            }
            bclast = bc;
            if (!this.v2) continue;
            this.vprintln("");
        }
    }

    private int specialStatic(String name) {
        if (name.equals("saddr") || name.equals("sdata")) {
            return 1;
        }
        if (name.equals("ioadr") || name.equals("ioctl")) {
            return 2;
        }
        if (name.equals("maddr") || name.equals("mdata")) {
            return 3;
        }
        return 0;
    }

    private int b2l(byte b) {
        int l = b;
        if (l < 0) {
            l += 256;
        }
        return l;
    }

    private int runjvmcore() {
        DataFile df = this.MA.getDataFile("JLF", "1000", "SI", 0);
        df.open(1);
        int clen = (int)df.getSize();
        Data dfd = df.getDataBuffer(clen);
        df.read(dfd);
        df.close();
        int flags = this.MA.getL("/FLAGS");
        this.core = Core.forName("JVM", this.MA);
        this.core.set("FLAGS", flags);
        this.core.set("CODE", dfd);
        this.core.open();
        this.testop(1, "+", 456, 123, 579);
        this.testop(2, "-", 456, 123, 333);
        this.testop(3, "*", 456, 123, 56088);
        this.testop(4, "/", 45600, 123, 370);
        this.testop(5, "<<", 42405, 4, 678480);
        this.testop(6, ">>", 42405, 4, 2650);
        this.testop(7, "&", 42405, -252645376, 40960);
        this.testop(8, "|", 42405, -252645376, -252643931);
        this.testop(9, "^", 42405, -252645376, -252684891);
        this.testop(10, "++", 123, 456, 579);
        this.testop(11, "LS+", 123, 234, 357);
        this.testop(100, "?", 456, 123, 999);
        this.testop(512, "?", 456, 123, 999);
        if (this.MA.getState("/IO")) {
            this.testop(12, "IOr", 64, 256, 64);
            this.testop(12, "IOr", 32, 320, 32);
            this.testop(12, "IOr", 16, 384, 16);
            this.testop(12, "IOr", 4, 448, 4);
            this.testop(13, "IOw", 64, 256, 64);
            this.testop(13, "IOw", 32, 320, 32);
            this.testop(13, "IOw", 16, 384, 16);
            this.testop(13, "IOw", 4, 448, 4);
        }
        this.core.close();
        return 9;
    }

    private void testop(int opcode, String op, int data1, int data2, int data3) {
        boolean hex;
        this.core.set("DATA1", data1);
        this.core.set("DATA2", data2);
        this.core.set("OPCODE", opcode);
        while (this.core.getL("OPCODE") > 0) {
        }
        int data3r = this.core.getL("DATA3");
        boolean bl = hex = opcode >= 5 && opcode <= 9;
        if (hex) {
            this.MT.write((CharSequence)("Op " + opcode + " :  " + Convert.l2x((int)data1) + " " + op + " " + Convert.l2x((int)data2) + " = " + Convert.l2x((int)data3r)));
        } else {
            this.MT.write((CharSequence)("Op " + opcode + " :  " + data1 + " " + op + " " + data2 + " = " + data3r));
        }
        if (data3r == data3) {
            this.MT.writeln((CharSequence)"");
        } else if (hex) {
            this.MT.writeln((CharSequence)("   expect=" + Convert.l2x((int)data3)));
        } else {
            this.MT.writeln((CharSequence)("   expect=" + data3));
        }
    }

    private class OpCode {
        String name;
        int code;
        int args;
        int inst1;
        int inst2;
        boolean niy;
        byte bc;

        public OpCode(String line) {
            OpCode ocnq;
            Parser p = new Parser(line, true, false);
            this.code = Convert.s2l((String)p.get(1)) & 0xFF;
            this.args = Convert.s2l((String)p.get(3));
            this.name = p.get(4);
            this.inst1 = this.parse(p.get(5));
            this.inst2 = this.parse(p.get(6));
            boolean bl = this.niy = p.get(5).length() + p.get(6).length() == 0;
            if (this.name.endsWith("_quick") && (ocnq = (OpCode)icejvm.this.bcTab.get(this.name.substring(0, this.name.length() - 6))) != null) {
                this.inst1 = ocnq.inst1;
                this.inst2 = ocnq.inst2;
                this.bc = ocnq.bc;
            }
            this.bc = (byte)(this.code >= 128 ? this.code - 256 : this.code);
            if (icejvm.this.joc[this.code] != null) {
                icejvm.this.M.error("Overwriting " + icejvm.this.joc[this.code] + " with " + this);
            }
            icejvm.this.joc[this.code] = this;
            icejvm.this.bcTab.put(this.name, (Object)this);
        }

        public String toString() {
            return "OpCode=" + this.code + " Name=" + this.name + " Args=" + this.args + " Inst=" + Convert.l2x((int)this.inst1);
        }

        private int parse(String s) {
            int inst = 0;
            if (s == null) {
                return 0;
            }
            s = "|" + s + "|";
            int i = this.find(s, "PSET", 0);
            if (i > 0) {
                inst |= 1;
            }
            if ((i = this.find(s, "SELX", 0)) > 0) {
                inst |= 2;
            }
            if ((i = this.find(s, "DUAL", 0)) > 0) {
                inst |= 4;
            }
            if ((i = this.find(s, "HOLD", 0)) > 0) {
                inst |= 8;
            }
            if ((i = this.find(s, "MINV", 0)) > 0) {
                inst |= 0x10;
            }
            if ((i = this.find(s, "MRET", 0)) > 0) {
                inst |= 0x20;
            }
            if ((i = this.find(s, "TBSW", 0)) > 0) {
                inst |= 0x40;
            }
            if ((i = this.find(s, "FRMAX", 0)) > 0) {
                inst |= 0x700;
            } else {
                i = this.find(s, "FRMA", 9);
                if (i != 9) {
                    inst |= (i & 0xF) << 8;
                } else {
                    i = this.find(s, "STKA", 1);
                    if (i != 0) {
                        inst |= (-i & 0xF) << 8;
                    }
                }
            }
            i = this.find(s, "FRMBX", 0);
            if (i > 0) {
                inst |= 0x7000;
            } else {
                i = this.find(s, "FRMB", 9);
                if (i != 9) {
                    inst |= (i & 0xF) << 12;
                } else {
                    i = this.find(s, "STKB", 3);
                    if (i != 0) {
                        inst |= (-i & 0xF) << 12;
                    }
                }
            }
            i = this.find(s, "STKI", 0);
            if (i != 0) {
                inst |= (i & 3) << 16;
            }
            if ((i = this.find(s, "STKI", 0)) == 1) {
                inst |= 0x1C0080;
            }
            if ((i = this.find(s, "STKU", 0)) == 1) {
                inst |= 0x10000;
            }
            if ((i = this.find(s, "STKD", 0)) != 0) {
                inst |= (-i & 3) << 16;
            }
            if ((i = this.find(s, "STKD", 0)) == 1) {
                inst |= 0xC0000;
            }
            if ((i = this.find(s, "WSTKA", 0)) > 0) {
                inst |= 0x40000;
            }
            if ((i = this.find(s, "WSTKB", 0)) > 0) {
                inst |= 0x80000;
            }
            if ((i = this.find(s, "WRAMA", 0)) > 0) {
                inst |= 0x100000;
            }
            if ((i = this.find(s, "WRAMB", 0)) > 0) {
                inst |= 0x200000;
            }
            if ((i = this.find(s, "WRAMC", 0)) > 0) {
                inst |= 0x400000;
            }
            if ((i = this.find(s, "ALT", 0)) > 0) {
                inst |= 0x800000;
            }
            if ((i = this.find(s, "SELB", "RAMB,STKA")) == 1) {
                inst |= 0x80;
            }
            if ((i = this.find(s, "SELA", "RAMA,RAMB,RAMC,RAMX,STKB,PUSH,RSHF,LSHF,TBD,AND,ROR,XOR,NEG,SUB,ADD,MUL")) >= 0) {
                inst |= i << 24;
            }
            if ((i = this.find(s, "OPTS", 0)) > 0) {
                inst |= i << 28;
            }
            if ((i = this.find(s, "COND", "H,L,EQ,EQZ,LT,LTZ,GT,GTZ,NH,NL,NE,NEZ,GE,GEZ,LE,LEZ")) >= 0) {
                inst |= i << 28;
            }
            if ((i = this.find(s, "CVT", "I2L,I2F,I2D,L2I,L2F,L2D,F2I,F2L,F2D,D2I,D2L,D2F,I2B,I2C,I2S")) >= 0) {
                inst |= i << 28;
            }
            return inst;
        }

        private int find(String s, String key, int def) {
            key = "|" + key;
            int kl = key.length();
            int i = s.indexOf(key);
            if (i < 0) {
                return def;
            }
            int j = s.indexOf("|", i + 1);
            if (i + kl + 1 >= j) {
                return 1;
            }
            return Convert.s2l((String)s.substring(i + kl + 1, j));
        }

        private int find(String s, String key, String list) {
            key = "|" + key;
            int kl = key.length();
            int i = s.indexOf(key);
            if (i < 0) {
                return -1;
            }
            int j = s.indexOf("|", i + 1);
            if (i + kl + 1 == j) {
                return -1;
            }
            return Parser.find((String)list, (String)s.substring(i + kl + 1, j), (int)0, (int)-1);
        }
    }

    private class ConstantPool {
        byte tag;
        int len;
        int size;
        int slot = 0;
        int slots = 1;
        int offset;
        String type;
        Object value;
        String name;

        public ConstantPool(byte[] buf, int i) {
            int itop = i;
            this.tag = buf[i++];
            switch (this.tag) {
                case 1: {
                    this.type = "Utf8  ";
                    this.len = Convert.unpackI((byte[])buf, (int)i, (byte)icejvm.this.rep);
                    this.value = new String(buf, i += 2, this.len);
                    break;
                }
                case 3: {
                    this.type = "Int   ";
                    this.len = 4;
                    this.value = Data.fromBuffer((byte[])buf, (byte)icejvm.this.rep, (int)i, (int)1, (String)"SL");
                    break;
                }
                case 4: {
                    this.type = "Float ";
                    this.len = 4;
                    this.value = Data.fromBuffer((byte[])buf, (byte)icejvm.this.rep, (int)i, (int)1, (String)"SF");
                    break;
                }
                case 5: {
                    this.type = "Long  ";
                    this.len = 8;
                    this.value = Data.fromBuffer((byte[])buf, (byte)icejvm.this.rep, (int)i, (int)1, (String)"SX");
                    this.slots = 2;
                    break;
                }
                case 6: {
                    this.type = "Double";
                    this.len = 8;
                    this.value = Data.fromBuffer((byte[])buf, (byte)icejvm.this.rep, (int)i, (int)1, (String)"SD");
                    this.slots = 2;
                    break;
                }
                case 7: {
                    this.type = "Class ";
                    this.len = 2;
                    this.value = Data.fromBuffer((byte[])buf, (byte)icejvm.this.rep, (int)i, (int)1, (String)"SI");
                    break;
                }
                case 8: {
                    this.type = "String";
                    this.len = 2;
                    this.value = Data.fromBuffer((byte[])buf, (byte)icejvm.this.rep, (int)i, (int)1, (String)"SI");
                    break;
                }
                case 9: {
                    this.type = "Field ";
                    this.len = 4;
                    this.value = Data.fromBuffer((byte[])buf, (byte)icejvm.this.rep, (int)i, (int)2, (String)"SI");
                    break;
                }
                case 10: {
                    this.type = "Method";
                    this.len = 4;
                    this.value = Data.fromBuffer((byte[])buf, (byte)icejvm.this.rep, (int)i, (int)2, (String)"SI");
                    break;
                }
                case 11: {
                    this.type = "InterF";
                    this.len = 4;
                    this.value = Data.fromBuffer((byte[])buf, (byte)icejvm.this.rep, (int)i, (int)2, (String)"SI");
                    break;
                }
                case 12: {
                    this.type = "NaType";
                    this.len = 4;
                    this.value = Data.fromBuffer((byte[])buf, (byte)icejvm.this.rep, (int)i, (int)2, (String)"SI");
                    break;
                }
                default: {
                    System.out.println("Unknown tag=" + this.tag);
                    this.len = -1;
                }
            }
            this.size = i + this.len - itop;
        }

        public int getI(int index) {
            return ((Data)this.value).getI(index);
        }

        public String getS() {
            return this.value.toString();
        }

        public String toString() {
            String s = " type=" + this.type + " value=" + this.value;
            if (this.name != null) {
                s = s + " name=" + this.name;
            }
            if (this.slot != 0) {
                s = s + " slot=" + this.slot;
            }
            return s;
        }
    }
}

