/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Time;

public class icediff
extends Primitive {
    private DataFile hd;
    private DataFile h1;
    private DataFile h2;
    private Data dd;
    private Data d1;
    private Data d2;
    private boolean all;
    private boolean sync;
    private int diffs;
    private int maxSeek;
    private int maxShow;
    private int maxChk;
    private int find;
    private int mask;
    private double offset = 0.0;
    private double total = 0.0;

    public int open() {
        this.h1 = this.MA.getDataFile("IN1", "1000,2000", "S#,C#", 0);
        this.h1.open();
        this.h2 = this.MA.getDataFile("IN2", "1000,2000", "S#,C#", 0);
        this.h2.open();
        this.maxChk = this.MA.getL("/MAXCHK", -1);
        this.maxSeek = this.MA.getL("/SEEK", 64);
        this.maxShow = this.MA.getL("/SHOW", 16);
        this.find = this.MA.getL("/FIND", -1);
        this.mask = this.MA.getL("/MASK", -1);
        this.sync = this.all = this.MA.getState("/ALL");
        byte dtype = this.h1.getFormatType();
        if (this.h1.getXDelta() != this.h2.getXDelta()) {
            this.M.warning((CharSequence)"File xdeltas do not match");
        }
        if (this.h1.getXUnits() != this.h2.getXUnits()) {
            this.M.warning((CharSequence)"File xunits do not match");
        }
        dtype = Data.promoteType((byte)this.h1.getFormatType(), (byte)this.h2.getFormatType());
        this.hd = this.MA.getDataFile("OUT", this.h1, 0);
        this.hd.setFormatType(dtype);
        this.hd.open(2 | 0x40);
        if (this.h1.typeClass == 2) {
            this.h1.setDFS(0);
            this.h2.setDFS(0);
            this.hd.setDFS(0);
        }
        this.xfer = Math.max(1, (int)((double)this.bufSize / this.hd.dbpe));
        if (this.maxChk > 0 && this.maxChk < this.xfer) {
            this.xfer = this.maxChk;
        }
        this.xfer = this.MA.getL("/TL", this.xfer);
        this.d1 = this.h1.getDataBuffer(this.xfer, dtype);
        this.d2 = this.h2.getDataBuffer(this.xfer, dtype);
        this.dd = this.hd.getDataBuffer(this.xfer, dtype);
        return 0;
    }

    public int process() {
        this.offset = this.h1.seek();
        if (this.maxChk > 0 && this.offset >= (double)this.maxChk) {
            return 9;
        }
        int n1 = this.h1.read(this.d1);
        if (n1 <= 0) {
            return 9;
        }
        int n2 = this.h2.read(this.d2);
        if (n2 <= 0) {
            return 9;
        }
        int n = Math.min(n1, n2);
        if (this.sync) {
            this.total += (double)n;
        }
        if (this.find > 0) {
            for (int i = 0; i < n - this.find; ++i) {
                this.diffs = 0;
                this.checkBytes(this.d1, this.d2, 0, i, this.hd.bpa, this.find, false);
                if (this.diffs != 0) continue;
                this.M.info((CharSequence)("Found pattern match at offset=" + ((long)this.h2.seek() - (long)n + (long)i)));
            }
            this.h1.seek(0.0);
        } else if (this.sync) {
            this.checkBytes(this.d1, this.d2, 0, 0, this.hd.bpa, n, true);
        } else {
            int seek = this.maxSeek;
            for (int i = 0; i < this.maxSeek; ++i) {
                this.checkBytes(this.d1, this.d2, this.maxSeek, this.maxSeek + i, this.hd.bpa, this.maxSeek, false);
                if (this.diffs == 0) {
                    seek = i;
                    break;
                }
                this.diffs = 0;
                this.checkBytes(this.d1, this.d2, this.maxSeek, this.maxSeek - i, this.hd.bpa, this.maxSeek, false);
                if (this.diffs == 0) {
                    seek = -i;
                    break;
                }
                this.diffs = 0;
            }
            if (seek == this.maxSeek) {
                this.M.warning((CharSequence)"No correlation found");
                seek = 0;
            } else if (seek != 0) {
                this.M.warning((CharSequence)("Files appear to be offset by " + seek + " samples"));
            }
            if (seek == 0) {
                this.h1.seek(0.0);
                this.h2.seek(0.0);
            } else {
                this.h1.seek((double)this.maxSeek);
                this.h2.seek((double)(this.maxSeek + seek));
            }
            this.sync = true;
        }
        return 0;
    }

    public int close() {
        this.MR.put(this.MA.getU("/STAT"), this.diffs);
        this.M.info((CharSequence)("Total of " + this.diffs + " differences found in " + this.total + " samples at " + Time.toString((double)Time.current())));
        this.h1.close();
        this.h2.close();
        this.hd.close();
        return 0;
    }

    private String l2x(int i4) {
        return Convert.l2x((int)i4);
    }

    private String x2x(long i8) {
        byte[] buf = new byte[8];
        Convert.packX((byte[])buf, (int)0, (long)i8);
        return Convert.bb2hex((byte[])buf, (int)0, (int)8);
    }

    private void checkBytes(Data d1, Data d2, int i1, int i2, int bpa, int n, boolean show) {
        byte[] b1 = d1.buf;
        byte[] b2 = d2.buf;
        if (bpa < 0) {
            n = n * -bpa / 8;
            bpa = 1;
        }
        i1 *= bpa;
        i2 *= bpa;
        n *= bpa;
        int bps = bpa > 4 ? 8 : 4;
        int i = 0;
        while (i < n) {
            block11: {
                block9: {
                    int m2;
                    block10: {
                        if (this.all) break block9;
                        if (this.mask != -1) break block10;
                        boolean ok = true;
                        for (int j = 0; j < bps; ++j) {
                            if (b1[i1 + j] == b2[i2 + j]) continue;
                            ok = false;
                        }
                        if (!ok) break block9;
                        break block11;
                    }
                    int m1 = this.mask & Convert.unpackL((byte[])b1, (int)i1);
                    if (m1 == (m2 = this.mask & Convert.unpackL((byte[])b2, (int)i2))) break block11;
                }
                ++this.diffs;
                if (this.all || show && this.diffs <= this.maxShow) {
                    long off = (long)(this.offset + (double)(i / bpa));
                    if (bps == 8) {
                        long m1 = Convert.unpackX((byte[])b1, (int)i1);
                        long m2 = Convert.unpackX((byte[])b2, (int)i2);
                        this.M.info((CharSequence)(" b1=" + this.x2x(m1) + " b2=" + this.x2x(m2) + " xor=" + this.x2x(m1 ^ m2) + " at " + this.l2x((int)off) + " or " + off));
                    } else {
                        int m1 = Convert.unpackL((byte[])b1, (int)i1);
                        int m2 = Convert.unpackL((byte[])b2, (int)i2);
                        this.M.info((CharSequence)(" b1=" + this.l2x(m1) + " b2=" + this.l2x(m2) + " xor=" + this.l2x(m1 ^ m2) + " at " + this.l2x((int)off) + " or " + off));
                    }
                }
            }
            i += bps;
            i1 += bps;
            i2 += bps;
        }
    }
}

