/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import nxm.ice.lib.Core;
import nxm.ice.lib.CoreComponent;
import nxm.sys.inc.Chainable;
import nxm.sys.inc.DataTypes;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libg.GValue;

public class icecore
extends Primitive
implements Chainable,
Keyable,
DataTypes {
    private int dump;
    private int tmode;
    private int tl = 4096;
    private int itl;
    private int otl;
    private int ilen;
    private int olen;
    private int iptl;
    private int optl;
    private int icvt = 0;
    private int ocvt = 0;
    private int flow;
    private int tagcnt = -1;
    private DataFile hi;
    private DataFile ho;
    private DataFile hip;
    private DataFile hop;
    private DataFile hcsf;
    private DataFile ht;
    private Data dcsf;
    private Data dt;
    private Data d;
    private Core core;
    private Table keys;
    private String csfkeys;
    private double csfdt = 1.0;
    private double csft = 0.0;
    private double csfdi;
    private double csfi;
    private double startOffset;
    private double tcs;
    private CoreComponent.Buffer bi;
    private CoreComponent.Buffer bo;
    private CoreComponent.Buffer bip;
    private CoreComponent.Buffer bop;
    private boolean isThreaded;
    private boolean isPacket;
    private boolean isICEX;
    private boolean mimicRT;
    private GValue gpw;

    public int open() {
        Table t;
        this.hi = this.MA.getDataFile("IN", "1000,2000", "S#,C#", 0);
        this.hi.open(64);
        this.startOffset = this.hi.getOffset();
        String iform = this.hi.getFormat();
        String ifmt = this.MA.getS("/IFMT", iform);
        this.ilen = this.MA.getL("/ILEN");
        String ofmt = this.MA.getS("/OFMT", ifmt);
        this.olen = this.MA.getL("/OLEN");
        this.tmode = this.MA.getL("/TRACE", 0);
        this.csfdt = this.MA.getD("/CPOLL", this.csfdt);
        Object gpwo = this.MA.getO("/GPWR");
        if (gpwo instanceof GValue) {
            this.gpw = (GValue)gpwo;
        }
        String func = this.MA.getCS("FUNC", "Bogus");
        this.core = (Core)this.MA.getO("/CIN");
        if (this.core == null) {
            this.core = Core.forName(func, this.MA);
        }
        if (this.core == null) {
            this.M.error("Opening core name=" + func);
            return 9;
        }
        this.core.setFormats(ifmt, ofmt);
        this.core.setTraceMode(this.tmode);
        this.flow = this.core.halo.flow;
        this.isThreaded = this.core.halo.impl > 1;
        this.keys = this.MA.getTable("/CFG");
        if (this.keys == null) {
            this.keys = new Table();
        }
        this.keys.setMode("KV");
        for (int n = 4; n <= this.MA.numberOf(); ++n) {
            String key = this.MA.getKey(n);
            Data value = this.MA.getData(key);
            if (key.length() > 2 && key.charAt(1) == ':') {
                key = key.substring(2);
            }
            this.keys.put(key, (Object)value);
        }
        this.verbose = this.MA.getState("/VERBOSE");
        this.core.setKeyTable(null, this.keys, this.verbose);
        this.core.open();
        double oxd = this.hi.getXDelta();
        double oxs = this.hi.getXStart();
        this.d = this.core.get("XDIO?", (byte)68);
        if (this.d != null) {
            oxd *= this.d.toD();
        }
        this.d = this.core.get("XDO?", (byte)68);
        if (this.d != null) {
            oxd = this.d.toD();
        }
        this.d = this.core.get("XSIO?", (byte)68);
        if (this.d != null) {
            oxs += this.d.toD();
        }
        oxd = this.MA.getD("/OXD", oxd);
        oxs = this.MA.getD("/OXS", oxs);
        this.ho = this.MA.getDataFile("OUT", this.hi, 0);
        this.ho.setXDelta(oxd);
        this.ho.setXStart(oxs);
        this.ho.setFormat(ofmt);
        this.ho.open(64);
        String oform = this.ho.getFormat();
        if (this.hi.typeClass == 2) {
            this.tl = this.hi.getSubsize();
        }
        this.tl = this.MA.getL("/TL", this.tl);
        this.itl = this.MA.getL("/ITL", this.tl);
        this.otl = this.MA.getL("/OTL", this.itl);
        this.hip = this.MA.getDataFile("/PIN", "1000", "SL", 0);
        this.hip.open(64);
        if (this.hip.isOpen) {
            this.iptl = this.MA.getL("/IPTL", this.itl);
        }
        if (this.flow == 4) {
            this.bip = this.core.getBuffer(128, 4, 4);
        }
        this.hop = this.MA.getDataFile("/POUT", this.hip, 0);
        this.hop.open(64);
        if (this.hop.isOpen) {
            this.optl = this.MA.getL("/OPTL", this.otl);
        }
        if (this.flow == 4) {
            this.bop = this.core.getBuffer(1024, 8, 4);
        }
        if ((t = this.MA.getTable("/CSF")) != null) {
            this.hcsf = new DataFile((MidasReference)this.M, (Object)t.getS("FN"), "3000", "NH", 0);
            this.hcsf.setSubRecords(t.getS("FMT"));
            this.csfdt = t.getD("DT");
            this.hcsf.setXDelta(this.csfdt);
            this.csfkeys = t.getS("KEYS");
            this.hcsf.open(2);
            this.dcsf = this.hcsf.getDataBuffer(1);
        }
        if (this.hi.isOpen) {
            this.csfdi = this.hi.dbpe * this.csfdt / this.hi.getDelta();
        }
        this.mimicRT = this.MA.getState("/MRT");
        this.isICEX = this.MA.getS("/CORE").equals("ICEX");
        if (this.gpw != null) {
            this.gpw.setValue(0.0);
        }
        this.tcs = this.MA.getD("/TCS");
        this.d = this.core.get("D:STARTUP?", (byte)68);
        if (this.d != null && this.tcs > 0.0) {
            this.core.set("D:STARTUP", this.tcs + -6.31152E8);
        }
        this.dump = this.MA.getL("/DUMP", 0);
        if ((this.dump & 1) != 0) {
            this.dumpKeys();
        }
        this.bi = this.core.getBuffer(this.itl, iform, ifmt);
        this.bo = this.core.getBuffer(this.otl, ofmt, oform);
        return 0;
    }

    public int process() {
        boolean poll;
        int ni = 0;
        int no = 0;
        int nip = 0;
        int nop = 0;
        boolean bl = this.mimicRT ? this.csfi > this.csfdi : (poll = Time.current() - this.csft > this.csfdt);
        if (poll) {
            this.core.poll();
            if (this.hcsf != null) {
                this.core.getList(this.csfkeys, this.dcsf);
                this.hcsf.write(this.dcsf);
            }
            this.csft = Time.current();
            this.csfi = 0.0;
        }
        if (this.isICEX) {
            return -1;
        }
        if (this.hi.isOpen && this.ilen != 0) {
            ni = this.core.load(this.bi, this.hi);
        }
        if (this.hip.isOpen) {
            nip = this.core.load(this.bip, this.hip);
        } else if (this.flow == 4) {
            nip = this.gentags(this.bi, ni, this.bip);
        }
        if (this.flow == 1) {
            this.core.process((CoreComponent.Stream)this.bi, (CoreComponent.Stream)this.bo);
        } else if (this.flow == 2) {
            this.core.process(this.bi, this.bo);
        } else if (this.flow == 3) {
            this.core.process(this.bi, (CoreComponent.Stream)this.bo);
        } else if (this.flow == 4) {
            this.core.process(this.bi, this.bip, this.bo, this.bop);
        } else {
            return -1;
        }
        if (this.ho.isOpen) {
            no = this.core.unload(this.bo, this.ho);
        }
        if (this.hop.isOpen) {
            nop = this.core.unload(this.bop, this.hop);
        } else if (this.flow == 4) {
            nop = this.flush(this.bop);
        }
        int ntot = ni + no + nip + nop;
        if (ntot == 0) {
            return -1;
        }
        if (ntot < 0) {
            return 9;
        }
        if (this.olen > 0 && this.ho.getOffset() >= (double)this.olen) {
            return 9;
        }
        if (this.ilen > 0 && this.hi.getOffset() >= (double)this.ilen) {
            return 9;
        }
        if (this.ilen == -2 && this.hi.getOffset() >= this.hi.getSize()) {
            this.hi.seek(0.0);
        }
        this.csfdi += (double)ni;
        if (this.gpw != null) {
            this.gpw.setValue(this.getProgress());
        }
        return 0;
    }

    public int close() {
        String cout;
        this.updateStatusKeys();
        if (this.gpw != null) {
            this.gpw.setValue(1.0);
        }
        if (this.tmode != 0) {
            this.dumpTrace();
        }
        if ((this.dump & 2) != 0) {
            this.dumpKeys();
        }
        if (!StringUtil.isNullOrEmpty((Object)(cout = this.MA.getU("/COUT")))) {
            this.MR.put(cout, (Object)this.core);
        } else {
            this.core.close();
        }
        this.hi.close();
        this.ho.close();
        this.hip.close();
        this.hop.close();
        if (this.hcsf != null) {
            this.hcsf.close();
        }
        return 0;
    }

    public double getProgress() {
        return this.hi.seek() / this.hi.getSize();
    }

    public int gentags(CoreComponent.Buffer bi, int n, CoreComponent.Buffer bip) {
        int stat = 0;
        for (int i = -n; i < 0; i += 4) {
            if (bi.xgetL(i) == 0x55555555 && (bi.xgetL(i + 4) & 0xFFFF) == 54613) {
                if (!this.isThreaded) {
                    if (this.tagcnt > 0) {
                        bip.xwrL(65536);
                        bip.xwrL(0x20000 | this.tagcnt);
                        stat += 8;
                    }
                    this.tagcnt = 0;
                } else {
                    if (this.tagcnt > 0) {
                        bip.xwrL(0x20000 | this.tagcnt);
                        stat += 4;
                    }
                    this.tagcnt = 0;
                    bip.xwrL(0x10000 | this.tagcnt);
                    stat += 4;
                }
            }
            if (this.tagcnt < 0) continue;
            this.tagcnt += 4;
        }
        if (n < 0 && this.tagcnt >= 0) {
            if (!this.isThreaded) {
                bip.xwrL(65536);
            }
            bip.xwrL(0x20000 | this.tagcnt);
        }
        return stat;
    }

    public int flush(CoreComponent.Buffer bop) {
        int stat = bop.bib;
        bop.rnxt(stat);
        return stat;
    }

    public void updateStatusKeys() {
        String[] list = this.keys.getKeys();
        for (int i = 0; i < list.length; ++i) {
            String key = list[i];
            Object value = this.keys.get(key);
            if (value != null && !value.equals("NULL") && !value.equals("")) continue;
            this.keys.put(key, (Object)this.core.get(key));
        }
    }

    public void dumpTrace() {
        int size = this.MA.getL("/TRACESZ", 4096);
        this.ht = this.MA.getDataFile("/TRACEFN", "1000", "SL", 0);
        this.ht.setSize((double)size);
        this.ht.open(2);
        this.dt = this.ht.getDataBuffer(1);
        boolean compress = (this.tmode & 3) != 3;
        for (int i = 0; i < size; ++i) {
            int count;
            int data = this.core.getTraceData(i);
            this.dt.setL(0, data);
            int n = count = compress ? data >> 28 & 0xF : 1;
            while (count > 0) {
                this.ht.write(this.dt);
                --count;
            }
        }
        this.ht.close();
    }

    public void dumpKeys() {
        String[] list = this.keys.getKeys();
        for (int i = 0; i < list.length; ++i) {
            String key = list[i];
            byte type = 76;
            if (key.charAt(1) == ':') {
                type = (byte)key.charAt(0);
            }
            Data value = this.core.get(key, type);
            this.MT.writeln((CharSequence)("Key=" + key + " Value=" + value + " Hex=" + Convert.l2x((int)Convert.o2l((Object)value))));
        }
    }

    public Object getNextLink() {
        return this.core;
    }

    public Object getPrevLink() {
        return null;
    }

    public String[] getKeys() {
        return this.keys.getKeys();
    }

    public Object setKey(String key, Object value) {
        Data data;
        Data data2 = data = value instanceof Data ? (Data)value : new Data(value);
        if (key.equals("STATE")) {
            this.setState((String)value);
        } else if (key.equals("MCID")) {
            this.core.setMCID(Convert.o2l((Object)value));
        } else {
            this.core.set(key, data);
        }
        return value;
    }

    public Object getKey(String key) {
        if (key.equals("STATE")) {
            return this.getState();
        }
        if (key.equals("PROGRESS")) {
            return this.getProgress();
        }
        Data value = this.core.get(key);
        if (this.verbose) {
            this.MT.writeln((CharSequence)("Get Key=" + key + " Value=" + value));
        }
        return value;
    }
}

