/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.prim;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URI;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import nxm.sys.inc.MessageHandler;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Foreign;
import nxm.sys.lib.GPrimitive;
import nxm.sys.lib.Message;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Shell;
import nxm.sys.lib.TextFile;
import nxm.sys.libg.GAlert;
import nxm.sys.libg.GFiles;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.MWindow;

public class browse
extends GPrimitive
implements MouseListener,
MouseMotionListener,
HyperlinkListener {
    private int level = 0;
    private int status = 0;
    private boolean exiting;
    private JScrollPane jsp;
    private JEditorPane jep;
    private URL[] urls = new URL[10];
    private int[] scrolls = new int[10];
    private static Desktop desktop;

    public int open() {
        URL url;
        String sfn = this.MA.getCS("URL");
        this.urls[this.level] = url = this.formURL(sfn);
        this.MW = new MWindow("Text/HTML Browser", (MessageHandler)this);
        this.MW.open();
        this.MW.addTo((Object)this);
        this.jep = new JEditorPane();
        this.jep.setContentType("text/html");
        this.jep.setEditable(false);
        this.jep.addHyperlinkListener(this);
        this.jep.addMouseMotionListener(this);
        this.jep.addMouseListener(this);
        this.showDoc(url);
        this.jsp = new JScrollPane();
        this.jsp.setViewportView(this.jep);
        Container panel2 = this.MW.getPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add(this.jsp);
        panel2.invalidate();
        panel2.validate();
        return 0;
    }

    private void revalidate() {
        Container panel2 = this.MW.getPanel();
        if (panel2 == null || !panel2.isShowing()) {
            return;
        }
        Container parent = panel2.getParent();
        if (parent == null || !parent.isShowing()) {
            return;
        }
        parent.invalidate();
        parent.validate();
        panel2.revalidate();
    }

    private URL formURL(String sfn) {
        if (!sfn.startsWith("\"")) {
            sfn = "\"" + sfn + "\"";
        }
        FileName fn = BaseFile.getFileNameFor((MidasReference)this, (String)sfn);
        sfn = fn.getFullName();
        URL url = null;
        if (sfn.indexOf(":") != 4) {
            sfn = "file:" + sfn;
        }
        try {
            url = new URL(sfn);
        }
        catch (Exception e) {
            System.out.println("Bad URL: " + e);
        }
        return url;
    }

    private void showDoc(URL url) {
        try {
            Document doc = this.jep.getDocument();
            if (doc != null) {
                doc.putProperty("stream", null);
            }
            this.jep.setPage(url);
        }
        catch (Exception e) {
            System.out.println("Bad Document: " + e);
        }
    }

    public int process() {
        if (this.exiting) {
            return 9;
        }
        return -1;
    }

    public int close() {
        this.MW.close();
        return 0;
    }

    public int processMessage(Message msg) {
        block11 : switch (msg.name) {
            case "PAINT": {
                break;
            }
            case "REFRESH": {
                this.MW.refresh();
                break;
            }
            case "RESIZE": {
                this.MW.resize(1);
                this.revalidate();
                break;
            }
            case "WINDOW": {
                if (msg.info != 0) break;
                this.exiting = true;
                break;
            }
            case "SAVEFILE": {
                this.saveCurrent();
                break;
            }
            case "SAVEFILEAS": {
                this.saveCurrent(msg.data.toString());
                break;
            }
            case "BUTTON": {
                if (msg.info != 2) break;
                new GMenu((Object)this.MW, "Browse", "Back,Forward,---,Edit,Sync,Save,SaveAs,OpenBrowser,OpenEditor,---,Exit", 0, 0, (MessageHandler)this);
                break;
            }
            case "OPENFILE": {
                URL url = this.formURL(msg.data.toString());
                this.level = msg.info < 0 ? ++this.level : msg.info;
                this.urls[this.level] = url;
                this.showDoc(url);
                break;
            }
            case "BROWSE": {
                switch (msg.data.toString()) {
                    case "BACK": {
                        if (this.level <= 0) break block11;
                        if (this.jep.isEditable()) {
                            this.verifyCurrent();
                            break block11;
                        }
                        this.showDoc(this.urls[--this.level]);
                        break block11;
                    }
                    case "FORWARD": {
                        if (this.urls[this.level + 1] == null) break block11;
                        if (this.jep.isEditable()) {
                            this.verifyCurrent();
                            break block11;
                        }
                        this.showDoc(this.urls[++this.level]);
                        break block11;
                    }
                    case "OPENBROWSER": {
                        this.openBrowser(this.urls[this.level]);
                        break block11;
                    }
                    case "OPENEDITOR": {
                        this.openEditor(this.urls[this.level]);
                        break block11;
                    }
                    case "SYNC": {
                        if (!this.jep.isEditable()) break block11;
                        this.saveCurrent();
                        break block11;
                    }
                    case "EDIT": {
                        this.jep.setEditable(true);
                        break block11;
                    }
                    case "SAVE": {
                        this.saveCurrent();
                        break block11;
                    }
                    case "SAVEAS": {
                        this.jep.setEditable(false);
                        new GFiles((Object)this.MW, "SaveFileAs", this.urls[this.level].toString(), "*.txt|java|jv|c|sv|v", null, this.M, 0, 0, 0, (MessageHandler)this);
                        break block11;
                    }
                    case "EXIT": {
                        this.exiting = true;
                        break block11;
                    }
                    default: {
                        this.M.warning((CharSequence)("Browse menu item=" + msg.data + " not coded yet"));
                    }
                }
            }
        }
        return 0;
    }

    private void verifyCurrent() {
        new GAlert((Object)this.MW, "SaveFile", "Save current modifications? ", "Yes,No", 1, 0, (MessageHandler)this);
    }

    private void saveCurrent() {
        String fn = this.urls[this.level].toString();
        this.saveCurrent(fn);
    }

    private void saveCurrent(String fn) {
        this.jep.setEditable(false);
        String s = this.jep.getText();
        TextFile tf = new TextFile(fn);
        this.M.info((CharSequence)("Saving file as: " + fn));
        tf.open(2);
        tf.write(s);
        tf.close();
    }

    public boolean openBrowser(URL url) {
        boolean result = false;
        if (desktop != null && url != null) {
            try {
                desktop.browse(new URI(url.toString()));
                result = true;
            }
            catch (Exception e) {
                Shell.printStackTrace((Throwable)e);
            }
        }
        return result;
    }

    public boolean openEditor(URL url) {
        String editor = this.MR.getString("ENV.EDITOR");
        String sfn = url.toString();
        if (sfn.startsWith("file:")) {
            sfn = sfn.substring(5);
        }
        Foreign.runInternal((Midas)this.M, (String)(editor + " " + sfn));
        return true;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int modifiers = e.getModifiers();
        if ((modifiers & 4) != 0 && this.level > 0) {
            this.showDoc(this.urls[--this.level]);
        }
        if ((modifiers & 8) != 0) {
            new GMenu((Object)this.MW, "Browse", "Back,Forward,---,Edit,Sync,Save,SaveAs,OpenBrowser,OpenEditor,---,Exit", 0, 0, (MessageHandler)this);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.MW.px = e.getX();
        this.MW.py = e.getY();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (evt instanceof HTMLFrameHyperlinkEvent) {
                this.M.warning((CharSequence)"Frame hyperlink event");
            } else if (this.level >= this.urls.length - 1) {
                this.M.warning((CharSequence)"Too many hyperlinkevt.getURL() levels");
            } else {
                URL url = evt.getURL();
                String surl = url.toString();
                int iq = surl.indexOf(63);
                if (iq < 0) {
                    this.urls[++this.level] = url;
                } else if (surl.charAt(iq - 1) == '/') {
                    surl = this.urls[this.level].toString() + surl.substring(iq);
                    try {
                        url = new URL(surl);
                    }
                    catch (Exception e) {
                        System.out.println("Browse: " + e);
                    }
                }
                this.showDoc(url);
            }
        }
    }

    static {
        try {
            desktop = Desktop.getDesktop();
        }
        catch (Exception e) {
            Shell.warning((CharSequence)("Unable to get java.awt.Desktop instance for using browse(URI) method: " + e));
        }
    }
}

