/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.net;

import nxm.ice.lib.IceSys;
import nxm.ice.net.HPage;
import nxm.ice.net.HSource;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Midas;
import nxm.sys.lib.OS;
import nxm.sys.lib.Parser;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;

public class HSystem
extends HSource {
    private Midas M;

    public HSystem(String name, Midas M) {
        this.M = M;
        this.name = name + "/";
    }

    @Override
    public void handleRequest(String uri, HPage hp) {
        String option = uri.substring(this.name.length() + 1);
        if (option.startsWith("Get?")) {
            this.getPage(option.substring(4), hp);
        } else if (option.startsWith("Set?")) {
            this.setPage(option.substring(4), hp);
        } else if (option.startsWith("Cmd?")) {
            this.cmdPage("Cmd", option.substring(4), hp);
        } else if (option.startsWith("Top")) {
            this.cmdPage("Top", "top -n 1 -b", hp);
        } else if (option.startsWith("Log")) {
            int len = option.endsWith("Tail") ? 512 : 8100;
            this.cmdPage("Log", "dmesg -s " + len, hp);
        } else if (option.startsWith("Disks")) {
            this.diskPage("ALL", hp);
        } else if (option.startsWith("DiskStats/")) {
            String aux = option.substring(10);
            this.diskPage(aux, hp);
        } else if (option.startsWith("Ice-Driver")) {
            this.cmdPage(option, "cat /proc/driver/icepic", hp);
        } else if (option.startsWith("Ice-Version")) {
            this.cmdPage(option, "/opt/ice/pkg/icexxx/jre/ice version", hp);
        } else if (option.startsWith("Ice-Health")) {
            this.cmdPage(option, "cat /var/log/icehealth.log", hp);
        } else if (option.startsWith("Ice-PICs")) {
            this.tablePage(option, IceSys.getPICs(), hp);
        } else if (option.startsWith("Ice-NICs")) {
            this.tablePage(option, IceSys.getNICs(), hp);
        } else if (option.startsWith("Ice-Disks")) {
            this.tablePage(option, IceSys.getDisks(), hp);
        } else {
            this.optPage(hp);
        }
    }

    public void getPage(String key, HPage hp) {
        Object value = this.M.results.get(key);
        hp.open();
        hp.writeln(key + "=" + value);
        hp.close();
    }

    public void setPage(String key, HPage hp) {
        int ie = key.indexOf("=");
        if (ie > 0) {
            String value = key.substring(ie + 1);
            key = key.substring(0, ie);
            this.M.results.setKey(key, (Object)value);
        }
        this.getPage(key, hp);
    }

    public void cmdPage(String name, String cmd, HPage hp) {
        byte[] buf = new byte[8192];
        cmd = StringUtil.replaceAll((String)cmd, (String)"%20", (String)" ");
        cmd = StringUtil.replaceAll((String)cmd, (String)"%22", (String)"\"");
        cmd = StringUtil.replaceAll((String)cmd, (String)"%27", (String)"'");
        int bytes = IceSys.runCommand(cmd, 0, buf);
        boolean tbl = name.endsWith(".tbl");
        if (tbl) {
            hp.open();
            Table t = this.textToTable(buf, bytes);
            hp.write(t.toString());
            hp.close();
        } else {
            hp.openToBody("HSystem Cmd Page");
            hp.writeln("<h3><a href='' onClick=\"location.reload(); return false;\">System Cmd=" + name + "</a></h3>");
            hp.writeln("<br><pre>");
            hp.write(buf, 0, bytes);
            hp.writeln("</pre>");
            hp.closeFromBody();
        }
    }

    private String trim(String s) {
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    private Table textToTable(byte[] buf, int len) {
        Table t = new Table();
        String s = new String(buf, 0, len);
        int i = 0;
        while (i < len) {
            Object obj;
            String val;
            String key;
            int il = s.indexOf("\n", i);
            if (il < 0) {
                il = len;
            }
            String line = s.substring(i, il);
            int ile = line.indexOf("=");
            Parser p = new Parser(line, ',', true);
            String p1 = p.get(1);
            String p2 = p.get(2);
            if (p2.equals(":")) {
                key = this.trim(p.get(1));
                val = this.trim(p.get(3));
                obj = null;
                if (val.indexOf(61) < 0) {
                    obj = Convert.s2o((String)val, (String)"_", (Object)this.M);
                } else {
                    String st = val;
                    for (int ip = 4; ip <= p.elements(); ++ip) {
                        val = p.get(ip);
                        int ie = val.indexOf(61);
                        if (ie <= 0) continue;
                        st = st + "," + val;
                    }
                    obj = new Table("{" + st + "}");
                }
                t.put(key, obj);
            } else if (p1.endsWith(":")) {
                p1 = p1.substring(0, p1.length() - 1);
                key = this.trim(p1);
                val = this.trim(p2);
                obj = Convert.s2o((String)val, (String)"_", (Object)this.M);
                t.put(key, obj);
            } else if (ile > 0) {
                key = this.trim(line.substring(0, ile));
                val = this.trim(line.substring(ile + 1));
                t.put(key, (Object)val);
            }
            i = il + 1;
        }
        return t;
    }

    public void tablePage(String name, Table t, HPage hp) {
        boolean tbl = name.endsWith(".tbl");
        if (tbl) {
            hp.open();
            hp.write(t.toString());
            hp.close();
        } else {
            hp.openToBody("HSystem " + name + " Page");
            hp.writeln("<h3><a href='' onClick=\"location.reload(); return false;\">" + name + "</a></h3>");
            hp.writeln("<br><pre>");
            for (String key : t) {
                Object value = t.get(key);
                hp.writeln(key + "=" + value);
            }
            hp.writeln("</pre>");
            hp.closeFromBody();
        }
    }

    public void diskPage(String aux, HPage hp) {
        hp.openToBody("HSystem Disk Page");
        hp.writeln("<h3><a href='' onClick=\"location.reload(); return false;\">Aux=" + aux + " Disk Stats</a></h3>");
        String list = aux;
        if (aux.equals("ALL")) {
            list = this.M.results.getS("AUX.READ");
        }
        String[] auxes = StringUtil.cleanSplit((String)list, (String)"|");
        hp.writeln("<table border='1' cellpadding='2' cellspacing='2' align='left'>");
        for (int i = 0; i < auxes.length; ++i) {
            aux = auxes[i];
            String path = this.M.io.getAuxPath(aux);
            Table tab = OS.getStatFS((String)path);
            hp.writeln("<tr>");
            hp.writeln("<td>Aux   = " + aux + "</td>");
            hp.writeln("<td>Path  = " + path + "</td>");
            if (tab != null) {
                hp.writeln("<td>Files = " + tab.getL("FILES") + "</td>");
                hp.writeln("<td>Total = " + tab.getL("TMBY") + " Mby</td>");
                hp.writeln("<td>Free  = " + tab.getL("FMBY") + " Mby</td>");
                hp.writeln("<td>Used  = " + tab.getL("USED") + "%</td>");
            }
            hp.writeln("</tr>");
        }
        hp.closeFromBody();
    }

    public void optPage(HPage hp) {
        hp.openToBody("HSystem Options Page");
        hp.writeln("<center><h2>NeXtMidas System Information</h2></center>");
        hp.writeln("<ul>");
        hp.writeln("<li><a href='/nmroot/index.html'>JavaDocs</a> - System tree documentation</li>");
        hp.writeln("<li><a href='LogTop'>System Log</a> - Top of System Log File</li>");
        hp.writeln("<li><a href='LogTail'>System Log</a> - Tail of System Log File</li>");
        hp.writeln("<li><a href='LogAll'>System Log</a> - All of System Log File</li>");
        hp.writeln("<li><a href='TopCPU'>Top CPU/Mem</a> - List of Top CPU/Memory Processes on Server</li>");
        hp.writeln("<li><a href='Disks'>Disk Aux=ALL</a> - All Disks Statistics</li>");
        hp.writeln("<li><a href='Ice-Version'>Ice-Version</a> - ICE Software Version</li>");
        hp.writeln("<li><a href='Ice-Driver'>Ice-Driver</a> - ICE Driver Statistics</li>");
        hp.writeln("<li><a href='Ice-Health'>Ice-Health</a> - ICE Block Health and Status</li>");
        hp.writeln("<li><a href='Ice-Disks'>Ice-Disks</a> - ICE Disk Statistics</li>");
        hp.writeln("<li><a href='Ice-PICs'>Ice-PICs</a> - ICE PIC Card Statistics</li>");
        hp.writeln("<li><a href='Ice-NICs'>Ice-NICs</a> - ICE Network Card Statistics</li>");
        hp.writeln("</ul>");
        hp.closeFromBody();
    }
}

