/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import nxm.ice.net.HFiles;
import nxm.ice.net.HPage;
import nxm.ice.net.HQuery;
import nxm.ice.net.HSource;
import nxm.ice.net.HSystem;
import nxm.sys.lib.Command;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Macro;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.prim.rmif;

public class HServer
implements Runnable {
    public static final int DEFAULT_PORT = 8080;
    public static final int DEFAULT_NUM_WORKERS = 5;
    public static final int BUF_SIZE = 2048;
    private static boolean debug = false;
    private static boolean debug2 = false;
    private static final int TIMEOUT = 1000;
    private Midas M = null;
    private LinkedList<HSource> sources = new LinkedList();
    private ServerSocket serverSocket;
    private String host;
    private int port;
    private int prange = 1;
    private String dsTitle = "nxm.ice.net.HServer";
    private String homePage;
    private String homeDir;
    private String appName;
    Command parent;
    private static boolean isHttps;
    private static boolean oneWay;
    static InetAddress hostip;

    public static HServer launch(Midas midas, String title, int port, int prange) {
        HServer ws = new HServer(midas, port, prange);
        ws.dsTitle = title;
        ws.open();
        Thread thread = new Thread(ws);
        thread.start();
        return ws;
    }

    public static HServer launch(String title, int port) {
        return HServer.launch(null, title, port, 1);
    }

    public static HServer launch(Object ref, String title, int port, int prange, String homepage, String auxlist) {
        Midas M = Convert.ref2Midas((Object)ref);
        if (M == null) {
            M = Shell.getSharedMidasContext();
        }
        HServer ws = HServer.launch(M, title, port, prange);
        if (ref instanceof Command) {
            ws.setParent((Command)ref);
        }
        if (homepage != null) {
            ws.setHomePage(homepage);
        }
        if (M.macro != null) {
            ws.addSource(new HQuery("Controls", M.macro.controls, null, 128));
        }
        if (M.macro != null) {
            ws.addSource(new HQuery("Registry", M.macro.getRegistry(), null, 128));
        }
        if (M.macro != null) {
            ws.addSource(new HQuery("Results", M.macro.getResults(), null, 128));
        }
        if (!StringUtil.isNull((String)auxlist)) {
            ws.addSource(new HFiles("Files", M, auxlist));
        }
        ws.addSource(new HSystem("System", M));
        return ws;
    }

    public static HServer launch(Object ref, String title, int port, String homepage, String auxlist) {
        return HServer.launch(ref, title, port, 1, homepage, auxlist);
    }

    public HServer() {
        this(null, 8080, 1);
    }

    public HServer(int port) {
        this(null, port, 1);
    }

    public HServer(Midas midas, int port, int prange) {
        this.M = midas;
        this.port = port;
        this.prange = prange;
        HServer.log("Creating new server starting on port " + port + " with range of " + prange);
        this.addSource(new ServerIndex());
        this.addSource(new HFiles("nmroot", Shell.getNmRoot()));
    }

    public void setTitle(String title) {
        this.dsTitle = title;
    }

    public Midas getMidas() {
        return this.M;
    }

    public Object getResult(String name) {
        return this.M.results.getO(name);
    }

    public Table getResults() {
        return this.M.results;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        if (this.host == null) {
            this.host = this.M.results.getS("ENV.HOSTNAME");
        }
        if (this.host == null) {
            InetAddress ia = HServer.getHostIA();
            this.host = ia == null ? "unknown" : ia.getHostAddress();
        }
        return this.host;
    }

    public String getHostAddr() {
        return this.M.results.getS("ENV.HOSTADDR");
    }

    public String getHostPort() {
        return this.getHost() + ":" + this.getPort();
    }

    public void setAppName(String name) {
        int i;
        int k = name.length();
        int m = 80;
        int j = 0;
        for (i = 0; i < k && i < m; ++i) {
            if (name.charAt(i) != ',') continue;
            j = i;
        }
        this.appName = i == k ? name : name.substring(0, j) + ", ...";
    }

    public void setParent(Command parent) {
        this.parent = parent;
        Macro macro = parent.M.macro;
        if (macro == null) {
            return;
        }
        String tmp = "/nmroot/nxm/" + macro.args.option + "/mcr/" + macro.args.name + ".html";
        this.setHomePage(tmp.toLowerCase());
        tmp = macro.toString();
        int i1 = tmp.indexOf(":");
        int i2 = tmp.indexOf(",/");
        if (i2 < 0) {
            i2 = tmp.length();
        }
        this.setAppName(tmp.substring(i1 + 1, i2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSource(String name, HSource source, boolean override) {
        if (name == null || source == null) {
            return;
        }
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        HServer.log("Adding " + name);
        LinkedList<HSource> linkedList = this.sources;
        synchronized (linkedList) {
            this.removeSource(name);
            if (override) {
                this.sources.add(0, source);
            } else {
                this.sources.add(source);
            }
        }
        source.setServer(this);
    }

    public void addSource(String name, HSource source) {
        this.addSource(name, source, false);
    }

    public void addSource(HSource source) {
        String name = source == null ? null : source.getName();
        this.addSource(name, source, false);
    }

    public void addSource(HSource source, boolean override) {
        String name = source == null ? null : source.getName();
        this.addSource(name, source, override);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSource(String name) {
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        LinkedList<HSource> linkedList = this.sources;
        synchronized (linkedList) {
            for (HSource source : this.sources) {
                if (!source.getName().equals(name)) continue;
                this.removeSource(source);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSource(HSource source) {
        if (source == null) {
            return;
        }
        LinkedList<HSource> linkedList = this.sources;
        synchronized (linkedList) {
            this.sources.remove(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HSource getSource(String req) {
        LinkedList<HSource> linkedList = this.sources;
        synchronized (linkedList) {
            for (HSource source : this.sources) {
                if (!source.canHandleRequest(req)) continue;
                return source;
            }
        }
        return null;
    }

    private void createHttpsServer() throws IOException {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return;
        }
        this.serverSocket = sslContext.getServerSocketFactory().createServerSocket(this.port);
        this.info("Starting HTTP Web Server at URL=https://" + this.getHost() + ":" + this.port + "/");
        if (!oneWay) {
            ((SSLServerSocket)this.serverSocket).setWantClientAuth(true);
            ((SSLServerSocket)this.serverSocket).setNeedClientAuth(true);
        } else {
            ((SSLServerSocket)this.serverSocket).setWantClientAuth(false);
            ((SSLServerSocket)this.serverSocket).setNeedClientAuth(false);
        }
    }

    private void createHttpServer() {
        while (this.serverSocket == null) {
            try {
                this.serverSocket = new ServerSocket(this.port);
                this.serverSocket.setSoTimeout(1000);
                this.port = this.serverSocket.getLocalPort();
                this.info("Starting HTTP Web Server at URL=http://" + this.getHost() + ":" + this.port + "/");
            }
            catch (BindException be) {
                HServer.log("Port " + this.port + " not available");
                if (--this.prange <= 0) {
                    this.printStackTrace("HServer.open(): Error opening server socket, no port(s) available (" + this.port + ")", be);
                    break;
                }
                ++this.port;
            }
            catch (IOException e) {
                this.printStackTrace("HServer.open(): Error opening server socket on port " + this.port, e);
                this.stopThread();
            }
        }
    }

    public static void setHTTPS(String mode) {
        if (!(mode = mode.toUpperCase()).equals("OFF")) {
            HServer.setHttps(true);
        }
        if (mode.startsWith("ONE")) {
            HServer.setOneWay(true);
        }
    }

    public int open() {
        if (isHttps) {
            System.out.println("HServer: HTTPS open OneWayAuth=" + oneWay + " at port=" + this.port);
            try {
                this.createHttpsServer();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.createHttpServer();
        }
        return 0;
    }

    public int process() {
        int status = -1;
        if (this.serverSocket != null) {
            try {
                Socket sock = this.serverSocket.accept();
                sock.setSoTimeout(0);
                sock.setTcpNoDelay(true);
                HPage hp = new HPage(this, sock);
                Thread thread = new Thread(hp);
                thread.start();
            }
            catch (SocketTimeoutException e) {
                if (debug2) {
                    HServer.log("Socket timeout after 1000 millisecs on port " + this.port);
                }
            }
            catch (InterruptedIOException e) {
                this.printStackTrace("HServer: Got InterruptedIOException on port " + this.port, e);
            }
            catch (SocketException e) {
                if (this.serverSocket != null) {
                    if ("socket closed".equalsIgnoreCase(e.getMessage())) {
                        HServer.log("Server Socket closed. exiting HTTP server on port " + this.port);
                    } else {
                        this.printStackTrace("HServer: Got SocketException while closing server socket on port " + this.port, e);
                    }
                    status = 9;
                }
            }
            catch (Exception e) {
                this.printStackTrace("HServer: Got exception on port " + this.port, e);
            }
        } else {
            status = 9;
        }
        return status;
    }

    public int close() {
        this.stopThread();
        return 0;
    }

    @Override
    public void run() {
        int status = 0;
        while (status != 9) {
            status = this.process();
        }
        this.close();
    }

    public synchronized void stopThread() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception e) {
                this.printStackTrace("Error closing socket on port " + this.port, e);
            }
        }
        this.serverSocket = null;
    }

    public boolean isRunning() {
        return this.serverSocket != null;
    }

    private void framesPage(HPage hp) {
        String tmp = this.homePage != null ? this.homePage : "/nmroot/";
        boolean hponly = this.dsTitle != null && this.dsTitle.equals("homepageonly");
        hp.open();
        hp.writeln("<html>");
        hp.writeln("<head>");
        hp.writeln("<title>HServer Frame</title>");
        hp.writeln("</head>");
        if (hponly) {
            hp.writeln("<frameset rows='0,*'>");
        } else {
            hp.writeln("<frameset rows='65,*'>");
        }
        hp.writeln("<frame src='/header' name='headerFrame'>");
        hp.writeln("<frame src='" + tmp + "' name='dataFrame'>");
        hp.writeln("</frameset>");
        hp.writeln("</html>");
        hp.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void headerPage(HPage hp) {
        String hostname = "unknown";
        String hostaddr = "unknown";
        try {
            InetAddress inet = HServer.getHostIA();
            hostname = inet.getHostName();
            hostaddr = inet.getHostAddress();
        }
        catch (Exception e) {
            Shell.warning((CharSequence)("Error in host lookup: " + e));
        }
        int hostport = this.serverSocket.getLocalPort();
        int rootport = hostport / 10 * 10;
        int np = this.getPartners();
        String parts = "&nbsp;&nbsp;";
        if (np > 0) {
            for (int i = 0; i <= np; ++i) {
                parts = parts + "-<a href='http://" + hostaddr + ":" + (rootport + i) + "' target='_top'>" + i + "</a>";
            }
        }
        String hname = hostname.equals(hostaddr.toString()) ? "" : "Name=" + hostname;
        hp.openToBody("HServer Header");
        if (this.dsTitle != null) {
            hp.writeln("<center><b>" + this.dsTitle + "</b></center>");
        }
        hp.writeln("<center><b>HOST " + hname + " Address=" + hostaddr + " Port=" + hostport + "</b>" + parts + "</center>");
        if (this.appName != null) {
            hp.writeln("<center><b>" + this.appName + "</b></center>");
        }
        hp.writeln("<center>");
        if (this.homePage != null) {
            hp.writeln("<a href='" + this.homePage + "' target='dataFrame'>Home</a>");
        }
        if (this.homePage != null) {
            hp.writeln("<b>-</b>");
        }
        LinkedList<HSource> linkedList = this.sources;
        synchronized (linkedList) {
            for (HSource source : this.sources) {
                String name = source.getName();
                if (name.length() <= 0 || name.equals("/nmroot/")) continue;
                String rname = name;
                if (rname.startsWith("/")) {
                    rname = rname.substring(1);
                }
                if (rname.endsWith("/")) {
                    rname = rname.substring(0, rname.length() - 1);
                }
                hp.writeln("<a href='" + name + "' target='dataFrame'>" + rname + "</a>");
                hp.writeln("<b>-</b>");
            }
        }
        hp.writeln("<a href='/nmroot/htdocs/help/index.html' target='dataFrame'>Help</a>");
        hp.writeln("</center>");
        hp.closeFromBody();
    }

    public void setHomePage(String page) {
        if (page == null || page.length() == 0) {
            return;
        }
        this.homePage = page;
        int i = this.homePage.lastIndexOf(47);
        if (i > 0) {
            this.homeDir = this.homePage.substring(0, i);
        }
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    private int getPartners() {
        if (this.parent instanceof rmif) {
            return ((rmif)this.parent).getPartners();
        }
        return 0;
    }

    public static void setDebug(boolean val) {
        debug = val;
    }

    @Deprecated
    public static void setDebug(int val) {
        HServer.setDebug(val != 0);
    }

    protected static void log(String s) {
        if (debug) {
            Shell.writeln((CharSequence)("HServer : " + s));
        }
    }

    protected void info(CharSequence seq) {
        if (this.M != null) {
            this.M.info(seq);
        } else {
            Shell.info((CharSequence)seq);
        }
    }

    protected void printStackTrace(CharSequence msg, Throwable t) {
        if (this.M != null) {
            this.M.printStackTrace(msg, t);
        } else {
            Shell.printStackTrace((CharSequence)msg, (Throwable)t);
        }
    }

    public static InetAddress getHostIA() {
        if (hostip != null) {
            return hostip;
        }
        try {
            InetAddress ip = InetAddress.getLocalHost();
            if (!ip.isLoopbackAddress()) {
                return ip;
            }
            ip = null;
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                String niname = ni.getName();
                Enumeration<InetAddress> ias = ni.getInetAddresses();
                while (ias.hasMoreElements()) {
                    InetAddress ia = ias.nextElement();
                    if (!ia.isSiteLocalAddress() || ia.isLoopbackAddress() || ip != null && !niname.endsWith("0")) continue;
                    ip = ia;
                }
            }
            hostip = ip;
            return ip;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setHttps(boolean isHttps) {
        HServer.isHttps = isHttps;
    }

    public static void setOneWay(boolean oneWay) {
        HServer.oneWay = oneWay;
    }

    protected class ServerIndex
    extends HSource {
        protected ServerIndex() {
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public boolean canHandleRequest(String uri) {
            return uri.equals("/") || uri.equals("/header");
        }

        @Override
        public void handleRequest(String uri, HPage hp) {
            if (uri.equals("/")) {
                HServer.this.framesPage(hp);
            } else if (uri.equals("/header")) {
                HServer.this.headerPage(hp);
            }
        }

        public String toString() {
            return "Source List";
        }
    }
}

