/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.net;

import nxm.ice.net.HPage;
import nxm.ice.net.HSource;
import nxm.sys.lib.Convert;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.Macro;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Query;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libg.GLabel;
import nxm.sys.libg.GPrompt;
import nxm.sys.libg.GValue;
import nxm.sys.libg.GWidget;

public class HQuery
extends HSource {
    private String list;
    private Object object;
    private Query query;
    private int maxitems;

    public HQuery(String name, Object object, String list, int maxitems) {
        this.name = name;
        this.object = object;
        this.maxitems = maxitems;
        this.list = list;
        this.query = new Query(object, list, maxitems);
        this.query.parse();
    }

    @Override
    public synchronized void handleRequest(String uri, HPage hp) {
        int k;
        Query q = this.query;
        Object obj = this.object;
        int lu = uri.length();
        if (uri.charAt(lu - 1) == '/') {
            uri = uri.substring(0, lu - 1);
        }
        String command = null;
        int qm = uri.indexOf(63);
        if (qm > 0) {
            command = uri.substring(qm + 1);
            uri = uri.substring(0, qm);
        }
        int j = 1;
        while ((k = uri.indexOf("/", j)) > j) {
            int i;
            if ((i = uri.indexOf("/", ++k)) < 0) {
                i = uri.length();
            }
            String key = uri.substring(k, i);
            q.parse();
            if (key.equals("Set")) {
                this.doCommand("Ack", uri.substring(0, k), command, obj, q, hp);
                return;
            }
            if (key.equals("Get")) {
                this.doCommand("Ret", uri.substring(0, k), command, obj, q, hp);
                return;
            }
            obj = q.getObject(key);
            q = new Query(obj, this.list, this.maxitems);
            j = k;
        }
        if (obj instanceof GWidget) {
            int qs = uri.lastIndexOf(47);
            String name = uri.substring(qs + 1);
            uri = uri.substring(0, qs);
            Table t = new Table();
            t.put(name, obj);
            q = new Query((Object)t, this.list, this.maxitems);
        }
        q.parse();
        if (command != null) {
            this.doCommand("Set", uri, command, obj, q, hp);
        }
        q.evaluate();
        HQuery.queryPage(uri, q, hp);
    }

    private void waitForSync() {
        Midas M = this.server.getMidas();
        Macro cmd = M.macro;
        cmd.queue.put("NULL", 0, null, (Object)cmd, (Object)cmd);
        while (cmd.queue.avail() > 0) {
            Time.sleep((double)0.01);
        }
    }

    private void doCommand(String mode, String uri, String command, Object obj, Query q, HPage hp) {
        String key;
        int ie;
        String entry;
        boolean cTable;
        if (command.startsWith("{")) {
            command = command.substring(1, command.length() - 1);
        }
        Parser p = new Parser(command);
        String string = "";
        boolean bl = cTable = uri.indexOf("/Controls/") >= 0;
        if (mode.equals("Set") || mode.equals("Ack")) {
            while (p.more()) {
                entry = p.next();
                ie = entry.indexOf(61);
                key = ie < 0 ? entry : entry.substring(0, ie);
                Object value = ie < 0 ? null : entry.substring(ie + 1);
                Object o = q.getObject(key);
                if (key.equals("/WAIT")) {
                    Time.sleep((double)Convert.o2d((Object)value));
                } else if (key.equals("/SYNC")) {
                    this.waitForSync();
                } else if (ie == entry.length() - 1) {
                    value = o instanceof GWidget ? ((GWidget)o).getValueString() : KeyObject.getKey((Object)obj, (String)key);
                } else if (o instanceof GWidget) {
                    ((GWidget)o).setAction(value.toString());
                } else if (cTable) {
                    value = null;
                    System.out.println("HQuery: Cannot set non-existent control=" + key);
                } else {
                    KeyObject.setKey((Object)obj, (String)key, (Object)value);
                }
                if (string.length() > 0) {
                    string = string + ",";
                }
                string = string + key + "=" + value;
            }
        }
        if (mode.equals("Ret") || mode.equals("Ack")) {
            p.reset();
            string = "";
            while (p.more()) {
                String value;
                entry = p.next();
                ie = entry.indexOf(61);
                key = ie < 0 ? entry : entry.substring(0, ie);
                Object o = q.getObject(key);
                String string2 = o instanceof GWidget ? ((GWidget)o).getValueString() : (value = cTable ? null : KeyObject.getKey((Object)obj, (String)key));
                if (string.length() > 0) {
                    string = string + ",";
                }
                string = string + key + "=" + value;
            }
            hp.setContentType("text/plain");
            hp.open();
            hp.write(uri + mode + "?{" + string + "}");
            hp.close();
        }
    }

    public static String valueFix(GValue gv) {
        String sval = gv.getValueString();
        return gv.toList(sval, "" + gv.getMin() + "," + gv.getDelta() + "<," + sval + ",>" + gv.getDelta() + "," + gv.getMax());
    }

    public static void queryPage(String uri, Query q, HPage hp) {
        boolean view2 = true;
        boolean cTable = uri.endsWith("/Controls");
        hp.openToBody("HQuery Page");
        hp.writeln("<h3><a href='' onClick=\"location.reload(); return false;\">Query</a> = " + uri + "</h3>");
        hp.writeln("<table>");
        for (int i = 0; i < q.getItems(); ++i) {
            boolean edit;
            boolean show;
            String name = q.getName(i);
            Object o = q.getObject(i);
            String value = q.getValue(i).toString();
            while (value.indexOf(" =") > 0) {
                value = value.replace(" =", "=");
            }
            boolean isCntrl = cTable && o instanceof GWidget;
            boolean isLabel = cTable && o instanceof GLabel;
            boolean isValue = cTable && o instanceof GValue;
            boolean isPrompt = cTable && o instanceof GPrompt;
            boolean isFiles = cTable && isPrompt && ((GPrompt)o).isFileChooser();
            GWidget gw = isCntrl ? (GWidget)o : null;
            boolean bl = show = isCntrl ? gw.isShow() : true;
            boolean bl2 = isCntrl ? !gw.getFlag(8) : (edit = true);
            if (isValue) {
                value = HQuery.valueFix((GValue)o);
            }
            value = value.replace("=[", " = [");
            value = value.replace("<>,", "");
            value = isCntrl ? HQuery.lookForChoices(name, value, isLabel, edit) : HQuery.lookForBraces(value);
            if (isLabel || view2 && show) {
                hp.writeln("<tr>");
                if (isLabel) {
                    hp.writeln("<td nowrap><a href =\"" + uri + "?" + name + "=Toggle\">" + name + "</a></td>");
                } else if (isCntrl) {
                    hp.writeln("<td nowrap>" + name + "</td>");
                } else {
                    hp.writeln("<td nowrap><a href =\"" + uri + "/" + name + "\">" + name + "</a></td>");
                }
                hp.writeln("<td nowrap>" + value + "</td>");
                hp.writeln("</tr>");
            }
            if (!isLabel) continue;
            view2 = ((GLabel)o).getActive() > 0;
        }
        hp.writeln("</table>");
        hp.closeFromBody();
    }

    public static String lookForChoices(String name, String value, boolean isLabel, boolean isEdit) {
        if (value == null) {
            return value;
        }
        int fb = value.indexOf(91);
        int rb = value.indexOf(93);
        if (fb < 0 || rb < 0) {
            return value;
        }
        String selects = "";
        int la = value.indexOf(",<");
        int ra = value.indexOf(">,");
        String ditem = la >= 0 && ra > la ? value.substring(la + 2, ra) : "";
        int i = fb;
        while (i < rb) {
            int j;
            block12: {
                block9: {
                    String item;
                    block11: {
                        String sitem;
                        int il;
                        block10: {
                            block8: {
                                j = value.indexOf(44, i + 1);
                                if (j < 0) {
                                    j = rb;
                                }
                                if ((il = (item = value.substring(i + 1, j)).length() - 1) <= 0 || item.charAt(0) != '<' || item.charAt(il) != '>') break block8;
                                item = item.substring(1, il);
                                selects = selects + (isEdit ? " <a href =\"?" + name + "=" + item + "\"><b>" + item + "</b></a> " : "<b>" + item + "</b>");
                                break block9;
                            }
                            if (il <= 0 || item.charAt(0) != '>') break block10;
                            sitem = ditem + "+" + item.substring(1);
                            selects = selects + (isEdit ? " <a href =\"?" + name + "=" + sitem + "\">" + item + "</a> " : "");
                            break block9;
                        }
                        if (il <= 0 || item.charAt(il) != '<') break block11;
                        sitem = ditem + "-" + item.substring(0, il);
                        selects = selects + (isEdit ? " <a href =\"?" + name + "=" + sitem + "\">" + item + "</a> " : "");
                        break block9;
                    }
                    if (isLabel && !item.equals("Open") && !item.equals("Closed") && !item.equals("Toggle")) break block12;
                    selects = selects + (isEdit ? " <a href =\"?" + name + "=" + item + "\">" + item + "</a> " : item);
                }
                if (j != rb) {
                    selects = selects + ',';
                }
            }
            i = j;
        }
        return value.substring(0, fb + 1) + selects + value.substring(rb);
    }

    private static String lookForBraces(String value) {
        for (int i = value.length() - 1; i >= 0; --i) {
            char c = value.charAt(i);
            if (c == '<') {
                value = value.substring(0, i) + "&lt" + value.substring(i + 1);
            }
            if (c != '>') continue;
            value = value.substring(0, i) + "&gt" + value.substring(i + 1);
        }
        return value;
    }
}

