/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.net;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.zip.ZipEntry;
import nxm.ice.net.HFile;
import nxm.ice.net.HPage;
import nxm.ice.net.HSource;
import nxm.sys.inc.MidasReference;
import nxm.sys.inc.PacketHandler;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.HttpResource;
import nxm.sys.lib.IOResource;
import nxm.sys.lib.MFormat;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TarFile;
import nxm.sys.lib.Time;
import nxm.sys.lib.ZipFile;

public class HFiles
extends HSource {
    private String dirpath;
    private Midas M;
    private Parser auxes;
    private Date startDate;
    private static boolean debug = false;

    public HFiles(String name, String dirpath) {
        if (!name.endsWith("/")) {
            name = name + '/';
        }
        if (!dirpath.endsWith("/")) {
            dirpath = dirpath + '/';
        }
        this.name = name;
        this.dirpath = dirpath;
        this.startDate = new Date();
        if (debug) {
            Shell.writeln((CharSequence)("HFiles() name=" + name + " dirpath=" + dirpath + " startDate=" + this.startDate));
        }
    }

    public HFiles(String name, Midas M, String auxList) {
        if (!name.endsWith("/")) {
            name = name + '/';
        }
        this.name = name;
        this.M = M;
        this.startDate = new Date();
        if (auxList == null || auxList.length() == 0 || auxList.equals("*")) {
            auxList = M.results.getString("AUX.READ");
        }
        this.auxes = new Parser(auxList, '|');
    }

    public static void setDebug(boolean val) {
        debug = val;
    }

    public static boolean isDebug() {
        return debug;
    }

    @Override
    public boolean handleHeadRequest() {
        return true;
    }

    @Override
    public void handleRequest(String uri, HPage hp) {
        String name = this.getName();
        String path = uri.substring(name.length());
        File listDir = null;
        if (debug) {
            Shell.writeln((CharSequence)("HFiles.handleRequest() " + hp.getMethod() + " uri=" + uri + " path=" + path));
        }
        String args = null;
        int i = path.indexOf(63);
        if (i > 0) {
            args = path.substring(i + 1);
            path = path.substring(0, i);
        }
        if (this.dirpath != null) {
            File index;
            if (path.equals("") || path.endsWith("/")) {
                path = path + "index.html";
            }
            if (!(index = new File(path = this.dirpath + path)).exists()) {
                listDir = index.getParentFile();
            }
        } else {
            if (path.equals("")) {
                this.framesPage(hp);
                return;
            }
            if (path.startsWith("auxesPage.html")) {
                this.auxesPage(hp);
                return;
            }
            if (path.startsWith("filesPage.html")) {
                if (args == null) {
                    this.dummyPage(hp);
                } else {
                    this.filesPage(hp, args);
                }
                return;
            }
            if (path.startsWith("fdataPage.html")) {
                if (args == null) {
                    this.dummyPage(hp);
                } else {
                    this.fdataPage(hp, args);
                }
                return;
            }
            i = path.indexOf(47);
            name = path.substring(i + 1);
            if (i > 0) {
                String aux = path.substring(0, i).toUpperCase();
                path = this.M.io.getAuxPath(aux) + name;
                if (aux.equals("*")) {
                    path = name;
                }
            } else {
                path = name;
            }
            if (path.endsWith("/")) {
                listDir = new File(path);
            }
        }
        if (listDir != null) {
            String auxType = path.substring(0, path.indexOf(58) + 1).toLowerCase();
            if (auxType.equals("jar:") || auxType.equals("tar:") || auxType.equals("zip:")) {
                this.containerIndexPage(hp, path, uri);
            } else if (auxType.equals("http:")) {
                this.webIndexPage(hp, path, uri);
            } else {
                this.indexPage(hp, listDir, uri);
            }
        } else if (path.startsWith("ram:_")) {
            int ip = path.indexOf(46);
            if (ip > 0) {
                path = path.substring(0, ip);
            }
            DataFile df = new DataFile((MidasReference)this.M, (Object)path);
            HFile.handlePipe(df, hp);
        } else {
            int ip;
            if (path.startsWith("ram:") && (ip = path.indexOf(46)) > 0) {
                path = path.substring(0, ip);
            }
            if (args != null) {
                this.execArgs(args);
            }
            BaseFile bf = new BaseFile((MidasReference)this.M, (Object)path);
            HFile.handle(bf, hp, args);
        }
    }

    private void execArgs(String args) {
        if (this.server == null) {
            return;
        }
        Midas M = this.server.getMidas();
        if (M == null) {
            return;
        }
        int ie = args.indexOf(61);
        if (ie < 0) {
            return;
        }
        String key = args.substring(0, ie);
        String value = args.substring(ie + 1);
        int ip = key.indexOf(46);
        if (ip < 0 && M.macro != null && M.macro.controls.get(key) != null) {
            M.macro.controls.put(key + ".ACTION", (Object)value);
        } else {
            M.results.put(key, (Object)value);
        }
    }

    private void containerIndexPage(HPage hp, String path, String uri) {
        if (hp.getMethod().equals("HEAD")) {
            return;
        }
        String root = "";
        int rootStart = path.indexOf(58) + 1;
        String prefix = path.substring(0, rootStart).toLowerCase();
        int rootEnd = path.indexOf(33);
        root = rootEnd > 0 ? path.substring(rootStart, rootEnd) : path.substring(rootStart);
        ArrayList<String> subEntries = new ArrayList<String>();
        boolean isTar = prefix.equals("tar:");
        String subDir = path.substring(path.indexOf(33) + 1);
        if (subDir == null) {
            subDir = "";
        }
        while (subDir.length() > 0 && subDir.charAt(0) == '/') {
            subDir = subDir.substring(1);
        }
        TarFile bf = isTar ? new TarFile((MidasReference)this.M, (Object)root) : new ZipFile((MidasReference)this.M, (Object)root);
        bf.open();
        Object[] entries = bf.getEntries();
        bf.close();
        if (entries != null) {
            Date modDate = new Date();
            SimpleDateFormat f = new SimpleDateFormat("dd-MMM-yyyy HH:mm");
            String entryName = "";
            String size = "0";
            MFormat sizeFormat = MFormat.getByteFormat();
            for (Object o : entries) {
                if (o instanceof ZipEntry) {
                    ZipEntry z = (ZipEntry)o;
                    entryName = this.scrubEntryName(z.getName(), subDir);
                    if (entryName.equals("")) continue;
                    size = sizeFormat.format((Object)z.getSize());
                    modDate.setTime(z.getTime());
                } else {
                    TarFile.TarEntry t;
                    if (!(o instanceof TarFile.TarEntry) || (entryName = this.scrubEntryName((t = (TarFile.TarEntry)o).getName(), subDir)).equals("")) continue;
                    size = sizeFormat.format((Object)t.getSize());
                    modDate.setTime(t.getTime1970() * 1000L);
                }
                subEntries.add("<a href='" + entryName + "'>" + entryName + "</a>" + StringUtil.padRight((String)"", (int)(30 - entryName.length())) + " " + f.format(modDate) + StringUtil.padLeft((String)size, (int)4));
            }
        }
        this.writeIndexPage(hp, subEntries, uri);
    }

    private void webIndexPage(HPage hp, String path, String uri) {
        if (hp.getMethod().equals("HEAD")) {
            return;
        }
        ArrayList<String> subEntries = new ArrayList<String>();
        String[] files = this.M.io.listFiles((Object)path, null);
        HttpResource hr = (HttpResource)this.M.io.findResource((Object)path, -1);
        if (files != null && hr != null) {
            String size = "0";
            MFormat sizeFormat = MFormat.getByteFormat();
            Date modDate = new Date();
            SimpleDateFormat form = new SimpleDateFormat("dd-MMM-yyyy HH:mm");
            for (String entryName : files) {
                IOResource ior = this.M.io.findResource((Object)(path + entryName), -1);
                if (ior == null) continue;
                ior.open();
                modDate.setTime(ior.lastModified());
                size = sizeFormat.format((Object)ior.getLength());
                subEntries.add("<a href='" + entryName + "'>" + entryName + "</a>" + StringUtil.padRight((String)"", (int)(30 - entryName.length())) + " " + form.format(modDate) + StringUtil.padLeft((String)size, (int)4));
                ior.close();
            }
        }
        this.writeIndexPage(hp, subEntries, uri);
    }

    private String scrubEntryName(String entryName, String subDir) {
        if (entryName.startsWith(subDir)) {
            if ((entryName = entryName.substring(subDir.length())).length() == 0 || entryName.equals("")) {
                return "";
            }
            if (entryName.indexOf(47) != -1 && entryName.indexOf(47) != entryName.length() - 1) {
                return "";
            }
            return entryName;
        }
        return "";
    }

    private void writeIndexPage(HPage hp, ArrayList<String> data, String uri) {
        if (data.size() == 0) {
            hp.openToBody("File Not Found");
            hp.writeln("  <h1>File Not Found: " + uri + "</h1>");
            hp.closeFromBody();
            return;
        }
        Collections.sort(data);
        hp.openToBody("Index of " + uri);
        hp.writeln("  <h1>Index of " + uri + "</h1>");
        hp.writeln("  <pre>");
        for (int i = 0; i < data.size(); ++i) {
            hp.writeln(data.get(i));
        }
        hp.writeln("  </pre>");
        hp.closeFromBody();
    }

    public void framesPage(HPage hp) {
        hp.setLastModified(this.startDate);
        if (hp.getMethod().equals("HEAD")) {
            return;
        }
        hp.open();
        hp.writeln("<html>");
        hp.writeln("<head>");
        hp.writeln("<title>HFiles Frame</title>");
        hp.writeln("</head>");
        hp.writeln("<frameset cols='25%,75%'>");
        hp.writeln("<frameset rows='30%,70%'>");
        hp.writeln("<frame src='auxesPage.html' name='auxesFrame'>");
        hp.writeln("<frame src='filesPage.html' name='filesFrame'>");
        hp.writeln("</frameset>");
        hp.writeln("<frame src='fdataPage.html' name='fdataFrame'>");
        hp.writeln("</frameset>");
        hp.writeln("</html>");
        hp.close();
    }

    public void auxesPage(HPage hp) {
        if (hp.getMethod().equals("HEAD")) {
            return;
        }
        hp.openToBody("HFiles Aux List");
        hp.writeln("<center><h3>Midas Aux List</h3></center>");
        hp.writeln("<table border='0' width='100%'>");
        this.auxes.reset();
        while (this.auxes.more()) {
            String aux = this.auxes.next();
            String path = this.M.io.getAuxPath(aux);
            hp.writeln("<tr><td nowrap><a href='filesPage.html?Aux" + aux + "' target='filesFrame'>" + aux + "</a></td>");
            hp.writeln("<td nowrap>" + path + "</td></tr>");
        }
        hp.writeln("</table>");
        hp.closeFromBody();
    }

    public void filesPage(HPage hp, String args) {
        if (hp.getMethod().equals("HEAD")) {
            return;
        }
        String aux = args.substring(3);
        String path = this.M.io.getAuxPath(aux);
        String[] files = this.M.io.listFiles((Object)path, "*", "*");
        int numFiles = files != null ? files.length : 0;
        hp.openToBody("HFiles Aux File List");
        hp.writeln("<center><b>Aux = " + aux + "</b></center><br>");
        hp.writeln("<table border='0' width='100%'><tr><td nowrap>");
        for (int i = 0; i < numFiles; ++i) {
            String fn = files[i];
            hp.writeln("<a href='fdataPage.html?" + aux + "/" + fn + "&Text' target='fdataFrame'>" + fn + "</a><br>");
        }
        hp.writeln("</td></tr></table>");
        hp.closeFromBody();
    }

    private void indexPage(HPage hp, File dir, String name) {
        if (hp.getMethod().equals("HEAD")) {
            return;
        }
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            MFormat sizeFormat = MFormat.getByteFormat();
            Time time = new Time();
            hp.openToBody("Index of " + name);
            hp.writeln("  <h1>Index of " + name + "</h1>");
            hp.writeln("  <pre>");
            for (int i = 0; i < files.length; ++i) {
                time.fromJ1970((double)files[i].lastModified() / 1000.0);
                String fname = files[i].getName();
                String size = sizeFormat.format((Object)files[i].length());
                String date = time.toString("VAX", 0);
                String url = name + fname;
                if (files[i].isDirectory()) {
                    fname = fname + "/";
                    url = url + "/";
                }
                if (files[i].isHidden()) continue;
                hp.writeln("<a href='" + url + "'>" + fname + "</a>" + StringUtil.padRight((String)"", (int)(30 - fname.length())) + " " + date + " " + StringUtil.padLeft((String)size, (int)4));
            }
            hp.writeln("  </pre>");
            hp.closeFromBody();
        } else {
            hp.openToBody("File Not Found");
            hp.writeln("  <h1>File Not Found: " + name + "</h1>");
            hp.closeFromBody();
        }
    }

    public void fdataPage(HPage hp, String args) {
        String name;
        if (hp.getMethod().equals("HEAD")) {
            return;
        }
        int i = args.lastIndexOf(47);
        int j = args.indexOf(38, i + 1);
        String path = name = args.substring(i + 1, j);
        String aux = "*";
        if (args.charAt(0) == '/') {
            aux = args.substring(0, i);
            path = args.substring(0, j);
        } else if (i > 0) {
            aux = args.substring(0, i).toUpperCase();
            path = this.M.io.getAuxPath(aux) + name;
            if (aux.equals("*")) {
                path = name;
            }
        }
        String mode = args.substring(j + 1);
        FileName fn = BaseFile.getFileNameFor((MidasReference)this.M, (String)path);
        BaseFile bf = BaseFile.getInstanceFor((MidasReference)this.M, (Object)fn);
        DataFile df = null;
        bf.open();
        if (bf instanceof DataFile) {
            df = (DataFile)bf;
        }
        hp.openToBody("HFiles File Data Page");
        hp.writeln("Aux=<b>" + aux + "</b>&nbsp;&nbsp; File=<b>" + name + "</b>&nbsp;&nbsp; Display=");
        hp.writeln("<a href='fdataPage.html?" + aux + "/" + name + "&Text'>Text</a>");
        hp.writeln(" - <a href='fdataPage.html?" + aux + "/" + name + "&Tail'>Tail</a>");
        if (bf instanceof PlotFile) {
            hp.writeln(" - <a href='fdataPage.html?" + aux + "/" + name + "&Auto'>Plot</a>");
        }
        if (df != null && df.getType() / 1000 == 1 && df.getFormatType() != 65) {
            hp.writeln(" - <a href='fdataPage.html?" + aux + "/" + name + "&FFT'>FFT</a>");
        }
        if (df != null && df.getType() / 1000 == 2) {
            hp.writeln(" - <a href='fdataPage.html?" + aux + "/" + name + "&Line'>Line</a>");
            hp.writeln(" - <a href='fdataPage.html?" + aux + "/" + name + "&Last'>LastFrame</a>");
        }
        if (df != null && df.getType() / 1000 > 2) {
            hp.writeln(" - <a href='fdataPage.html?" + aux + "/" + name + "&Table'>Table</a>");
        }
        hp.writeln(" - <a href='" + aux + "/" + name + "'>DownLoad</a>");
        hp.writeln(" - <a href='fdataPage.html?" + aux + "/" + name + "&" + mode + "'>Refresh</a>");
        hp.writeln("<br>");
        if (!mode.equals("Load")) {
            if (mode.equals("Text") || mode.equals("Tail")) {
                String line;
                double start = 0.0;
                PacketHandler pkh = null;
                int ncols = 1;
                int lines = 50;
                int tw = 80;
                int flags = 0;
                hp.writeln("<pre>");
                hp.writeln(bf.listHeader());
                if (df != null) {
                    pkh = df.getPacketHandler();
                }
                if (df != null && df.typeClass >= 2) {
                    tw = 160;
                }
                if (df != null && mode.equals("Tail")) {
                    start = Math.max(0.0, df.getSize() - 20.0);
                }
                ncols = Math.max(1, bf.listElementsPerLine(tw, null, flags));
                int k = 0;
                while (k < lines && (line = bf.listElements(start, ncols, null, flags)) != null) {
                    if (pkh != null && pkh.hasHeader()) {
                        hp.writeln(pkh.listHeader());
                    }
                    hp.write(line);
                    ++k;
                    start += (double)ncols;
                }
                hp.writeln("</pre>");
            } else if (mode.equals("Table")) {
                hp.writeln("<center><table border='2' cellpadding='2' cellspacing='0'>");
                for (double offset = 0.0; offset < Math.min(100.0, df.size); offset += 1.0) {
                    Table t = df.getDataTable(offset);
                    Table.Iterator ti = t.iterator();
                    if (offset % 20.0 == 0.0) {
                        hp.writeln("<tr>");
                        for (i = 0; i < ti.size; ++i) {
                            hp.writeln("<td><b>" + ti.keys[i] + "</b></td>");
                        }
                        hp.writeln("</tr>");
                    }
                    if (!(offset >= 0.0)) continue;
                    hp.writeln("<tr>");
                    for (i = 0; i < ti.size; ++i) {
                        hp.writeln("<td>" + ti.values[i] + "</td>");
                    }
                    hp.writeln("</tr>");
                }
                hp.writeln("</table></center>");
            } else {
                hp.writeln("<applet codebase='/nmroot' code='nxm.sys.libg.MApplet.class' name='Plot' width='100%' height='96%'>");
                hp.writeln("<param name='WIN' value='HFILES'>");
                if (mode.equals("Auto")) {
                    hp.writeln("<param name='CMD' value='PLOT/WIN=HFILES,./" + aux + "/" + name + "'>");
                }
                if (mode.equals("Line")) {
                    hp.writeln("<param name='CMD' value='PLOT/WIN=HFILES,./" + aux + "/" + name + ",TYPE=LINE'>");
                }
                if (mode.equals("Last")) {
                    hp.writeln("<param name='CMD' value='PLOT/WIN=HFILES,./" + aux + "/" + name + "(-1:),TYPE=LINE'>");
                }
                if (mode.equals("FFT")) {
                    hp.writeln("<param name='CMD' value='PLOT/WIN=HFILES,./" + aux + "/" + name + ",/FFT=4K'>");
                }
                hp.writeln("</applet>");
            }
        }
        hp.closeFromBody();
        bf.close();
    }

    public void dummyPage(HPage hp) {
        hp.setLastModified(this.startDate);
        if (hp.getMethod().equals("HEAD")) {
            return;
        }
        hp.openToBody("HFiles Dummy Page<");
        hp.closeFromBody();
    }
}

