/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.net;

import nxm.ice.lib.Archiver;
import nxm.ice.net.HPage;
import nxm.ice.net.HSource;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Shell;

public class HArchive
extends HSource {
    private Midas M;
    private static boolean debug = false;
    static int OFF_DETACHED = 12;
    static int OFF_EXTSIZE = 28;
    static int OFF_DATASTART = 32;
    static int OFF_DATASIZE = 40;

    public HArchive(String name, Midas M) {
        if (!name.endsWith("/")) {
            name = name + '/';
        }
        this.name = name;
        this.M = M;
    }

    @Override
    public boolean handleHeadRequest() {
        return true;
    }

    @Override
    public void handleRequest(String uri, HPage hp) {
        boolean isOpen;
        boolean hasArgs;
        Archiver ha = null;
        BaseFile bf = null;
        DataFile df = null;
        String name = this.getName();
        String path = uri.substring(name.length());
        int i = path.indexOf(63);
        int j = path.indexOf(40);
        boolean bl = hasArgs = i > 0;
        if (hasArgs) {
            path = path.substring(0, i) + "{" + path.substring(i + 1).replaceAll("&", ",") + "}";
        }
        boolean isImport = path.startsWith("Import/");
        boolean isExport = path.startsWith("Export/");
        boolean isHeadRequest = hp.getMethod().equals("HEAD");
        long offset = (long)hp.getHeaderD("Range");
        long tbytes = 0L;
        if (offset < 0L) {
            offset = 0L;
        }
        if (debug) {
            Shell.writeln((CharSequence)("HArchive.handle() " + hp.getMethod() + " path=" + path));
        }
        byte[] hdr = new byte[512];
        if (isImport) {
            this.hp_read(hdr, 0, 512, hp);
        }
        if (isImport || isExport) {
            int dir = isImport ? 1 : (isExport ? -1 : 0);
            ha = Archiver.openForExport(this.M, path.substring(7), hdr, dir);
            isOpen = ha.isOpen;
            tbytes = ha.getExportSize();
        } else if (j > 0) {
            df = new DataFile((MidasReference)this.M, (Object)path);
            isOpen = df.open(33);
            tbytes = 512L + (long)(df.getSize() * df.dbpe);
        } else {
            bf = new BaseFile((MidasReference)this.M, (Object)path);
            isOpen = bf.open(33);
            tbytes = (long)bf.getSize();
            bf.seek((double)offset);
        }
        if (!isOpen) {
            hp.setStatus(404);
            hp.open();
            if (!isHeadRequest) {
                hp.writeNotFound();
            }
            hp.close();
            return;
        }
        if (debug) {
            Shell.writeln((CharSequence)("HArchive.handle() " + hp.getMethod() + " path=" + path + " off=" + offset + " size=" + tbytes));
        }
        if (offset > 0L) {
            hp.setContentRange(offset, tbytes - 1L, tbytes);
        }
        hp.setContentType("application/octet-stream");
        hp.setContentLength(tbytes - offset);
        if (isHeadRequest) {
            hp.open();
            hp.close();
        } else {
            int bytes = 0;
            int bufsize = 0x100000;
            byte[] buf = new byte[bufsize];
            hp.open();
            if (isImport) {
                hp.write(hdr, 0, 512);
                hp.flush();
                offset = 512L;
            }
            while (offset < tbytes) {
                bytes = (int)Math.min(tbytes - offset, (long)bufsize);
                bytes = isImport ? this.hp_read(buf, 0, bytes, hp) : (isExport ? ha.readExport(buf, offset, bytes) : (df != null ? this.df_read(df, buf, offset, bytes) : bf.read(buf, 0, bytes)));
                if (bytes < 0) break;
                if (isImport) {
                    ha.writeExport(buf, bytes);
                } else if (hp.write(buf, 0, bytes) < 0) break;
                offset += (long)bytes;
            }
            hp.close();
        }
        if (df != null) {
            df.close();
        }
        if (bf != null) {
            bf.close();
        }
        if (ha != null) {
            ha.close();
        }
    }

    public int hp_read(byte[] buf, int off, int bytes, HPage hp) {
        int total;
        block5: {
            total = 0;
            try {
                while (total < bytes) {
                    int status = hp.getInputStream().read(buf, total, bytes - total);
                    if (status > 0) {
                        total += status;
                        continue;
                    }
                    if (status == 0) {
                        Thread.sleep(1L, 0);
                        continue;
                    }
                    if (status >= 0) continue;
                    break;
                }
            }
            catch (Exception e) {
                if (total != 0) break block5;
                total = -1;
            }
        }
        return total;
    }

    public int df_read(DataFile df, byte[] buf, long off, int bytes) {
        if (off == 0L) {
            bytes = 512;
            System.arraycopy(df.hb, 0, buf, 0, bytes);
            Convert.packL((byte[])buf, (int)OFF_EXTSIZE, (int)0);
            Convert.packL((byte[])buf, (int)OFF_DETACHED, (int)0);
            Convert.packD((byte[])buf, (int)OFF_DATASTART, (double)512.0);
            Convert.packD((byte[])buf, (int)OFF_DATASIZE, (double)(df.getSize() * df.dbpe));
        } else {
            bytes = df.read(buf, 0, bytes);
        }
        return bytes;
    }
}

