/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.libg;

import java.awt.Color;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.Table;
import nxm.sys.libg.Layer;
import nxm.sys.libg.MColor;

public class LayerTV
extends Layer {
    private int nx;
    private int ny;
    private int nchan;
    private int nfs;
    private int bpe;
    private double factor;
    private double delx;
    private double xframe;
    private DataFile df;
    private int select = -1;
    private int selected = -1;
    private int single = -1;
    private int[] lbuf;
    private int[] bits;
    private int[] offs;
    private boolean clear;
    private String[] names;
    private Color cgrid = new Color(0x505050);
    private Color cselect = null;
    private static int MAXFRAME = 32768;

    public LayerTV() {
        super("TV");
    }

    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        this.setFile(pf);
        this.df = (DataFile)pf;
        this.nfs = (int)this.df.getSize();
        this.bpe = (int)this.df.getBPE();
        boolean bl = this.isPaged = this.nfs > MAXFRAME;
        if (this.isPaged) {
            this.nfs = MAXFRAME;
        }
        this.setXAxis(pf.getXStart(), pf.getXDelta());
        this.lbuf = new int[this.nfs];
        this.setNChan(this.bpe * 8);
        this.setup();
        return true;
    }

    public void setNChan(int n) {
        this.nchan = n;
        this.nx = 1;
        this.ny = this.nchan;
        this.bits = new int[n];
        this.offs = new int[n];
        this.names = new String[n];
        for (int i = 0; i < n; ++i) {
            this.offs[i] = i;
            this.bits[i] = 1;
            this.names[i] = "Bit" + i;
        }
        this.setYAxis(0.0, this.ny);
    }

    public int getNChan() {
        return this.nchan;
    }

    private void redo() {
        this.findRange();
        this.MP.findRange();
        this.MP.useRange();
        this.MP.setup();
        this.refresh();
    }

    private void setup() {
        this.delx = this.df.getXDelta();
        this.setFrame(this.nfs);
        this.setSize(1);
        this.setData(this.df.getDataBuffer(this.nfs));
        this.setColor(1);
        this.ndata = 0;
    }

    public int getData(int mode) {
        int stat = 0;
        if (this.df == null || !this.df.isOpen() || this.data == null || this.isDone) {
            return stat;
        }
        int ndo = (int)this.df.avail();
        if (ndo > 0) {
            if (ndo > this.nfs) {
                ndo = this.nfs;
            }
            this.fseek = this.pf.seek();
            if (this.isPaged) {
                double s = this.df.getStart();
                double d = this.df.getDelta();
                ndo = Math.min(ndo, (int)((this.MP.rx2 - s) / d - this.fseek + 2.0));
                this.setXStart(s + this.fseek * d);
                if (this.isReset) {
                    this.xframe = this.xstart;
                }
            }
        }
        if (ndo > 0) {
            ndo = this.df.read(this.data, ndo);
            if (this.bpe == 1) {
                for (int i = 0; i < ndo; ++i) {
                    this.lbuf[i] = this.data.getB(i);
                }
            }
            if (this.bpe == 2) {
                for (int i = 0; i < ndo; ++i) {
                    this.lbuf[i] = this.data.getI(i);
                }
            }
            if (this.bpe == 4) {
                for (int i = 0; i < ndo; ++i) {
                    this.lbuf[i] = this.data.getL(i);
                }
            }
            this.ndata = ndo;
            stat = this.isPaged ? 2 : 0;
            this.isReset = false;
        } else if (this.isPaged) {
            this.df.seek(this.df.getSize());
            this.setXStart(this.df.getStart());
            this.isDone = true;
            this.ndata = 0;
        } else if (!this.realtime) {
            stat = 0;
        } else if (this.df.isStream() && !this.df.isStreaming()) {
            stat = -1;
        }
        this.a1 = 0.0;
        this.a2 = this.ny;
        return stat;
    }

    public void findRange() {
        this.x1 = this.xstart;
        this.x2 = this.xstart + (double)(this.nfs - 2) * this.xdelta;
        this.y1 = 0.0;
        this.y2 = this.ny;
    }

    public void findFullRange() {
        this.findFullRange(this.pf);
    }

    public void findFullRange(PlotFile pf) {
        this.fx1 = this.x1;
        this.fx2 = this.x2;
        this.fy1 = this.y1;
        this.fy2 = this.y2;
        if (pf != null && !this.realtime) {
            this.fx1 = pf.getXStart();
            this.fx2 += pf.getXDelta() * pf.getSize();
        }
    }

    public void draw(int flag) {
        int ix;
        int j;
        int iy;
        int i;
        this.needRefresh = false;
        if (!this.MP.is2D) {
            return;
        }
        Color cfill = this.MP.getOption(8) ? Color.black : this.MP.theme.cbg;
        double dx = this.MP.mxx * this.xdelta;
        if (flag != 2 || this.clear) {
            this.MP.gc.setColor(cfill);
            this.MP.gc.fillRect(this.MP.ix1, this.MP.iy1, this.MP.ix21, this.MP.iy21);
            this.MP.setColor(this.cgrid);
            int ix1 = this.MP.ix1;
            int ix2 = this.MP.ix2;
            for (i = 0; i <= this.ny; ++i) {
                iy = (int)(this.MP.myy * (double)i + this.MP.myb);
                if (iy > this.MP.iy1 && iy < this.MP.iy2) {
                    this.MP.gc.drawLine(this.MP.ix1, iy, this.MP.ix2, iy);
                }
                if (!(dx > 5.0)) continue;
                for (j = 0; j < this.nfs; ++j) {
                    ix = (int)(this.MP.mxx * (this.xframe + this.xdelta * (double)j) + this.MP.mxb);
                    if (ix <= this.MP.ix1 || ix >= this.MP.ix2) continue;
                    this.MP.gc.drawLine(ix, iy + 2, ix, iy - 2);
                }
            }
            this.clear = false;
        }
        if (this.ndata <= 0) {
            return;
        }
        for (int ichan = 0; ichan < this.nchan; ++ichan) {
            int ibits = this.bits[ichan];
            int ioff = this.offs[ichan];
            int imask = (1 << ibits) - 1;
            ix = 0;
            iy = ichan;
            i = this.MP.myy > 0.0 ? iy : iy + 1;
            int iy1 = (int)(this.MP.myy * (double)i + this.MP.myb) + 3;
            i = this.MP.myy > 0.0 ? iy + 1 : iy;
            int iy2 = (int)(this.MP.myy * (double)i + this.MP.myb) - 3;
            if (iy1 > this.MP.iy2 || iy2 < this.MP.iy1) continue;
            double ry1 = 0.0;
            double ry2 = imask;
            double myy = (double)(iy1 - iy2) / (ry2 - ry1);
            double myb = (double)iy2 - ry1 * myy;
            int iymin = iy1 + 1;
            int iymax = iy2 - 1;
            int[] pax = this.MP.pix.x;
            int[] pay = this.MP.pix.y;
            int nmax = pax.length;
            j = 0;
            i = 0;
            while (i < this.ndata) {
                if (j == nmax) {
                    this.MP.drawPixels(pax, pay, nmax, this.line);
                    j = 0;
                }
                ix = (int)(this.MP.mxx * (this.xstart + this.xdelta * (double)i) + this.MP.mxb);
                int ud = this.lbuf[i] >> ioff & imask;
                iy = (int)((double)ud * myy + myb);
                if (iy < iymin) {
                    iy = iymin;
                } else if (iy > iymax) {
                    iy = iymax;
                }
                pax[j] = ix;
                pay[j] = iy;
                ++i;
                ++j;
            }
            this.MP.drawPixels(pax, pay, j, this.line);
        }
    }

    public void setTraceConfig(String cfg) {
        if (cfg.equals("NONE")) {
            return;
        }
        if (cfg.startsWith("{")) {
            cfg = cfg.substring(1, cfg.length() - 1);
        }
        Parser p = new Parser(cfg);
        this.setNChan(p.elements());
        int tbits = 0;
        for (int i = 0; i < this.nchan; ++i) {
            String name;
            this.names[i] = name = p.get(this.nchan - i);
            this.bits[i] = 1;
            this.offs[i] = tbits;
            if (name.endsWith("]")) {
                int ib = name.indexOf("[");
                int ic = name.indexOf(":");
                if (ib > 0 && ic > 0) {
                    this.bits[i] = Convert.s2l((String)name.substring(ib + 1, ic)) - Convert.s2l((String)name.substring(ic + 1, name.length() - 1)) + 1;
                }
            }
            tbits += this.bits[i];
        }
        System.out.println("TraceConfig {" + cfg + "} nchan=" + this.nchan + " Bits=" + tbits);
    }

    private int getChan(Position pos) {
        int iy = (int)pos.y;
        this.select = iy < 0 || iy >= this.ny ? -1 : iy;
        return this.select;
    }

    public void select(Position pos) {
        this.select = this.getChan(pos);
    }

    public int select() {
        return this.select;
    }

    public int getSelect() {
        return this.select;
    }

    public void setSelect(int chan) {
        this.selected = chan;
    }

    public void setSelectColor(String cstr) {
        this.cselect = MColor.getColor((Object)cstr);
    }

    public void single(int channel) {
        this.single = channel;
    }

    public int single() {
        return this.single;
    }

    public String getReadOut(Position mp) {
        int iy = (int)mp.y;
        int ix = (int)((mp.x - this.xframe) / this.xdelta);
        int ioff = iy;
        int ibits = 1;
        int imask = 1;
        String name = "Bit" + iy;
        int val = 0;
        if (iy >= 0 && iy < this.nchan && ix > 0 && ix < this.nfs) {
            name = this.names[iy];
            ibits = this.bits[iy];
            ioff = this.offs[iy];
            imask = (1 << ibits) - 1;
            val = this.lbuf[ix] >> ioff & imask;
        }
        String sval = "" + val;
        if (name.indexOf(91) > 0) {
            sval = Convert.l2x((int)val);
            while (sval.length() > 3 && sval.indexOf("0x0") == 0) {
                sval = sval.replace("0x0", "0x");
            }
        }
        String tmp = " TV (" + name + "=" + sval + ")";
        return tmp;
    }
}

