/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.libg;

import java.awt.Color;
import java.awt.image.ImageObserver;
import nxm.ice.lib.ICEPacket;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Native;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.Table;
import nxm.sys.libg.Layer;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MImage;
import nxm.sys.libg.MWindow;
import nxm.sys.libm.Fft;
import nxm.sys.libm.LogarithmBounded;
import nxm.sys.libm.MagSquared;
import nxm.sys.libm.Multiply;
import nxm.sys.libm.Window;

public class LayerMC
extends Layer {
    public float[] fbuf;
    public float[] wind;
    public float[] fbs;
    private ICEPacket pkth;
    private int nx;
    private int ny;
    private int nchan;
    private int ichan;
    private int nfft;
    private int navg;
    private int nout;
    private int nrot;
    private int spa;
    private int nfftx;
    private int navgx;
    private int nfs;
    private int iyrast;
    private int myrast;
    private int iexp;
    private double factor;
    private double delx;
    private double delf;
    private double dbRange = 120.0;
    private double fixMin;
    private double fixMax;
    private double minRange;
    private double maxRange;
    private DataFile df;
    private Fft fft;
    private int skip = 1;
    private int select = -1;
    private int selected = -1;
    private int single = -1;
    private int scaling = S_AUTOP;
    private String wname = "HANN";
    private int type = T_LINE;
    private int proc = P_FFT;
    private int keep = 0;
    private int[] ikeep;
    private boolean demux;
    private double a1s;
    private double a2s;
    private double asrat = 0.9;
    public MImage mimage;
    private byte[] buf;
    private boolean yx = false;
    private boolean clear;
    private boolean first;
    private double[] ca1s;
    private double[] ca2s;
    private Color cgrid = new Color(0x505050);
    private Color cselect = null;
    private int[] iyrasts;
    private int mcs = 0;
    public static String typeList = "Line,Raster,Point,XYPoint";
    public static String processList = "Raw,Magnitude,FFT,Histogram,Envelope";
    public static String windowList = Window.nameList;
    public static String scalingList = "FixMin,FixMax,AutoChan,AutoPage";
    private static int T_LINE = 1;
    private static int T_RASTER = 2;
    private static int T_POINT = 3;
    private static int T_XYPOINT = 4;
    private static int P_RAW = 1;
    private static int P_MAG = 2;
    private static int P_FFT = 3;
    private static int P_HIST = 4;
    private static int P_ENV = 5;
    private static int S_FIXMIN = 1;
    private static int S_FIXMAX = 2;
    private static int S_AUTOC = 4;
    private static int S_AUTOP = 8;

    public LayerMC() {
        this.name = "MC";
        this.zaxis = true;
    }

    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        this.setFile(pf);
        this.df = (DataFile)pf;
        this.pkth = (ICEPacket)this.df.getPacketHandler();
        if (this.pkth != null) {
            this.nfs = this.pkth.getFixedSize();
        } else if (this.mcs > 0) {
            this.nfs = 256;
        } else if (this.df.typeClass == 2) {
            this.nfs = this.df.getFrameSize();
        } else {
            throw new MidasException("LayerMC input must be framed as type2000 or ICE Packets");
        }
        this.df.setDFS(0);
        this.cmap = MA.getSelectionIndex("CMAP", "GrayScale,Ramp,XRamp,Wheel,Terrain,Multi,T5Layer,MapLine,Grid,Spectrum,XDatalist", 2);
        this.cmap = MA.getSelectionIndex("/CMAP", "GrayScale,Ramp,XRamp,Wheel,Terrain,Multi,T5Layer,MapLine,Grid,Spectrum,XDatalist", this.cmap);
        this.ncolors = MA.getL("NC", 32);
        this.colors = MColor.getColorMap((int)this.cmap, (int)this.ncolors);
        this.spa = this.df.getSPA();
        this.setNChan(0);
        this.setNFft(256);
        this.ichan = 0;
        this.first = true;
        return true;
    }

    public void setKeep(int ratio) {
        this.keep = ratio;
        this.ikeep = new int[this.nchan];
    }

    public void update() {
        if (this.ndata > 0) {
            this.process();
        }
    }

    public void setNChan(int n) {
        int nxy = 0;
        for (int i = 2; i <= 6; ++i) {
            if (i * i != n) continue;
            this.nx = this.ny = i;
            nxy = this.ny;
        }
        if (nxy == 0) {
            this.nx = 1;
            while (this.nx < 64) {
                this.ny = 1;
                while (this.ny < this.nx * 2 && this.nx * this.ny < n) {
                    ++this.ny;
                }
                if (this.nx * this.ny >= n) break;
                this.nx *= 2;
            }
        }
        this.nchan = n;
        this.setXAxis(0.0, this.nx);
        this.setYAxis(0.0, this.ny);
    }

    public int getNChan() {
        return this.nchan;
    }

    private void redo() {
        this.findRange();
        this.MP.findRange();
        this.MP.useRange();
        this.MP.setup();
        this.refresh();
    }

    public void setNX(int n) {
        this.nx = Math.max(1, n);
        this.setXAxis(0.0, this.nx);
        if (this.nchan > 0) {
            this.setNY((this.nchan - 1) / this.nx + 1);
        }
    }

    public int getNX() {
        return this.nx;
    }

    public void setNY(int n) {
        this.ny = Math.max(1, n);
        if (this.nchan <= 0) {
            this.nchan = this.nx * this.ny;
        }
        this.setYAxis(0.0, this.ny);
    }

    public int getNY() {
        return this.ny;
    }

    public void setWindow(String wname) {
        this.wname = wname;
        this.wind = Window.get((String)wname, (int)this.nfft, (double)this.factor);
    }

    public String getWindow() {
        return this.wname;
    }

    public void setProcess(String process) {
        this.proc = Parser.find((String)processList, (String)process, (int)0);
        this.nfftx = this.nfft;
        this.clear = true;
    }

    public String getProcess() {
        return Parser.get((String)processList, (int)this.proc);
    }

    public void setType(String typeName) {
        this.type = Parser.find((String)typeList, (String)typeName, (int)0);
        this.clear = true;
    }

    public String getType() {
        return Parser.get((String)typeList, (int)this.type);
    }

    public void setMCS(int nc) {
        this.mcs = nc;
        if (nc > 0) {
            this.nfs = 256;
        }
    }

    public void setNFft(int nfft) {
        this.nfftx = nfft;
    }

    public int getNFft() {
        return this.nfft;
    }

    public void setNAvg(int navg) {
        this.navgx = navg;
    }

    public int getNAvg() {
        return this.navg;
    }

    public void setMin(double value) {
        this.fixMin = value;
        this.scaling |= S_FIXMIN;
    }

    public double getMin() {
        return this.fixMin;
    }

    public void setMax(double value) {
        this.fixMax = value;
        this.scaling |= S_FIXMAX;
    }

    public double getMax() {
        return this.fixMax;
    }

    public void setMinRange(double value) {
        this.minRange = value;
    }

    public double getMinRange() {
        return this.minRange;
    }

    public void setMaxRange(double value) {
        this.maxRange = value;
    }

    public double getMaxRange() {
        return this.maxRange;
    }

    public void setDbRange(double db) {
        this.dbRange = db;
    }

    public double getDbRange() {
        return this.dbRange;
    }

    public void setAutoScaleRatio(double value) {
        this.asrat = value;
    }

    public double getAutoScaleRatio() {
        return this.asrat;
    }

    public void setScaling(String value) {
        this.scaling = Parser.mask((String)scalingList, (String)value, (int)this.scaling);
    }

    public String getScaling() {
        return Parser.mask2s((String)scalingList, (int)this.scaling);
    }

    private void setup() {
        this.delx = this.df.getXDelta();
        this.delf = 1.0 / ((double)this.nfft * this.delx);
        int flags = 40;
        if (this.proc == P_FFT) {
            if (this.spa == 2) {
                this.nout = this.nfft;
                this.nrot = this.nfft / 2 - 1;
                flags |= 2;
                this.factor = 1.0 / (double)this.nfft;
            } else {
                this.nout = this.nfft / 2;
                this.nrot = 0;
                flags |= 1;
                this.factor = 1.0 / (double)(2 * this.nfft);
            }
            this.fft = new Fft(this.nfft, flags);
            this.fbuf = new float[this.nout * 2];
        } else {
            this.nout = this.nfft;
            this.fbuf = new float[this.nout * this.spa];
            if (this.type == T_POINT || this.type == T_XYPOINT) {
                this.line.setType(2);
            }
        }
        this.setFrame(this.nout);
        this.setSize(1);
        this.setData(this.df.getDataBuffer(this.nfft));
        this.setColor(1);
        this.setWindow(this.wname);
        this.ndata = 0;
        this.iyrast = 0;
        this.iyrasts = new int[this.nchan];
        if (this.type != T_RASTER && this.nchan <= 16) {
            this.fbs = new float[this.nout * this.spa * this.nchan];
        }
    }

    public int getData(int mode) {
        int i = 0;
        if (this.df == null || !this.df.isOpen()) {
            return 0;
        }
        if (this.nfftx > 0) {
            this.nfft = this.nfftx;
            this.setup();
            this.nfftx = 0;
        }
        int stat = 0;
        int ndo = (int)this.df.avail();
        if (ndo > 0) {
            ndo = Math.min(this.nfft, this.nfs);
            this.myrast = (int)(this.MP.myy > 0.0 ? this.MP.myy : -this.MP.myy) - 4;
            if (this.pkth == null) {
                this.df.read(this.data, ndo);
                if (this.nfs > this.nfft) {
                    this.df.skip(this.nfs - this.nfft);
                }
                if (this.mcs > 0) {
                    this.ichan = this.getMCSchan(this.data.buf);
                } else {
                    this.ichan = this.ichan % this.nchan + 1;
                    if (this.ichan == this.nchan && this.skip > 1) {
                        this.df.skip(this.nfs * this.nchan * (this.skip - 1));
                    }
                }
                if (this.ichan <= 1 && ++this.iyrast > this.myrast) {
                    this.iyrast = 0;
                }
            } else {
                this.df.read(this.data, ndo);
                ndo = this.pkth.getSize();
                this.ichan = this.pkth.getChannel();
                if (ndo > this.nfft) {
                    this.df.skip(ndo - this.nfft);
                }
                if ((i = this.ichan - 1) < 0 || i >= this.nchan) {
                    i = 0;
                }
                this.iyrast = this.iyrasts[i];
                if (++this.iyrast > this.myrast) {
                    this.iyrast = 0;
                }
                this.iyrasts[i] = this.iyrast;
            }
            this.process();
            stat = 2;
        } else if (!this.realtime) {
            stat = 0;
        } else if (this.df.isStream() && !this.df.isStreaming()) {
            stat = -1;
        }
        return stat;
    }

    public void process() {
        boolean autoc;
        int iy;
        int ix;
        this.ndata = 0;
        if (this.data == null) {
            return;
        }
        this.navg = this.navgx;
        if (this.single >= 0 && this.ichan != this.single) {
            return;
        }
        int i = this.ichan - 1;
        if (this.yx) {
            ix = i / this.ny;
            iy = i - ix * this.ny;
        } else {
            iy = i / this.nx;
            ix = i - iy * this.nx;
        }
        if (this.MP.mxx > 0.0) {
            if ((int)(this.MP.mxx * (double)ix + this.MP.mxb) > this.MP.ix2) {
                return;
            }
            if ((int)(this.MP.mxx * (double)(ix + 1) + this.MP.mxb) < this.MP.ix1) {
                return;
            }
        }
        if (this.MP.myy > 0.0) {
            if ((int)(this.MP.myy * (double)iy + this.MP.myb) > this.MP.iy2) {
                return;
            }
            if ((int)(this.MP.myy * (double)(iy + 1) + this.MP.myb) < this.MP.iy1) {
                return;
            }
        }
        boolean bl = autoc = (this.scaling & S_AUTOC) != 0;
        if (this.proc == P_FFT) {
            this.processFFT();
        } else if (this.proc == P_RAW) {
            this.processRaw();
        } else if (this.proc == P_MAG) {
            this.processMag();
        } else if (this.proc == P_HIST) {
            this.processHist();
        } else if (this.proc == P_ENV) {
            this.processEnv();
        }
        if (autoc && (this.ca1s == null || this.ca1s.length < this.nchan)) {
            this.ca1s = new double[this.nchan];
            this.ca2s = new double[this.nchan];
            for (int j = 0; j < this.nchan; ++j) {
                this.ca2s[j] = 0.0;
                this.ca1s[j] = 0.0;
            }
        }
        if (autoc) {
            this.a1s = this.ca1s[i];
            this.a2s = this.ca2s[i];
        }
        this.a1s = this.a1 * this.asrat + this.a1s * (1.0 - this.asrat);
        this.a2s = this.a2 * this.asrat + this.a2s * (1.0 - this.asrat);
        if (this.first) {
            this.a1s = this.a1;
            this.a2s = this.a2;
            this.first = false;
        }
        double ads = (this.a2s - this.a1s) * 0.05;
        this.a1 = Math.min(this.a1, this.a1s - ads);
        this.a2 = Math.max(this.a2, this.a2s + ads);
        if ((this.scaling & S_FIXMIN) != 0) {
            this.a1 = this.fixMin;
        }
        if ((this.scaling & S_FIXMAX) != 0) {
            this.a2 = this.fixMax;
        }
        if (autoc) {
            this.ca1s[i] = this.a1s;
            this.ca2s[i] = this.a2s;
        }
    }

    public void processAvg(float[] fbuf, int n) {
        float scl0 = 1.0f / (float)this.navg;
        float scl1 = 1.0f - scl0;
        int j = (this.ichan - 1) * this.nout * this.spa;
        int i = 0;
        while (i < n) {
            this.fbs[j] = fbuf[i] = fbuf[i] * scl0 + this.fbs[j] * scl1;
            ++i;
            ++j;
        }
    }

    public void processFFT() {
        int i;
        Convert.bb2ja((byte[])this.data.buf, (int)0, (byte)this.data.type, (Object)this.fbuf, (int)0, (byte)70, (int)(this.nfft * this.spa));
        if (this.nfs < this.nfft) {
            for (i = this.nfs * this.spa; i < this.nfft * this.spa; ++i) {
                this.fbuf[i] = 0.0f;
            }
        }
        if (this.spa == 2) {
            Multiply.CSC((float[])this.fbuf, (float[])this.wind, (float[])this.fbuf, (int)this.nfft);
        } else {
            Multiply.SSS((float[])this.fbuf, (float[])this.wind, (float[])this.fbuf, (int)this.nfft);
        }
        this.fft.work((Object)this.fbuf);
        MagSquared.CS((float[])this.fbuf, (float[])this.fbuf, (int)this.nout);
        if (this.fbs != null && this.navg > 1) {
            this.processAvg(this.fbuf, this.nout);
        }
        if (this.data.type == 66 || this.data.type == 73) {
            Native.dbf((Object)this.fbuf, (int)this.nout, (int)0);
        } else {
            LogarithmBounded.SS((float[])this.fbuf, (float[])this.fbuf, (int)this.nout, (double)Math.log(10.0));
        }
        if (this.spa == 2) {
            this.fft.rotateSF(this.fbuf);
        }
        this.a2 = this.fbuf[0];
        for (i = 1; i < this.nout; ++i) {
            if (!((double)this.fbuf[i] > this.a2)) continue;
            this.a2 = this.fbuf[i];
        }
        this.a1 = this.a2 - this.dbRange;
        this.ndata = this.nout;
    }

    public void processRaw() {
        if (this.spa == 2 && this.type == T_RASTER) {
            this.processMag();
            return;
        }
        Convert.bb2ja((byte[])this.data.buf, (int)0, (byte)this.data.type, (Object)this.fbuf, (int)0, (byte)70, (int)(this.nout * this.spa));
        this.a1 = this.a2 = (double)this.fbuf[0];
        for (int i = 1; i < this.nout * this.spa; ++i) {
            if ((double)this.fbuf[i] < this.a1) {
                this.a1 = this.fbuf[i];
            }
            if (!((double)this.fbuf[i] > this.a2)) continue;
            this.a2 = this.fbuf[i];
        }
        this.ndata = this.nout;
    }

    public void processMag() {
        if (this.spa == 1) {
            this.processRaw();
            return;
        }
        Convert.bb2ja((byte[])this.data.buf, (int)0, (byte)this.data.type, (Object)this.fbuf, (int)0, (byte)70, (int)(this.nout * this.spa));
        this.fbuf[0] = this.fbuf[0] * this.fbuf[0] + this.fbuf[1] * this.fbuf[1];
        this.a1 = this.a2 = (double)this.fbuf[0];
        int i = 1;
        int j = 2;
        while (i < this.nout) {
            float f = this.fbuf[j] * this.fbuf[j] + this.fbuf[j + 1] * this.fbuf[j + 1];
            if ((double)f < this.a1) {
                this.a1 = f;
            }
            if ((double)f > this.a2) {
                this.a2 = f;
            }
            this.fbuf[i] = f;
            ++i;
            j += 2;
        }
        this.ndata = this.nout;
    }

    public void processHist() {
    }

    public void processEnv() {
    }

    public void findRange() {
        this.x1 = 0.0;
        this.x2 = this.nx;
        this.y1 = 0.0;
        this.y2 = this.ny;
    }

    public void draw(int flag) {
        int iy;
        int ix2;
        int ix1;
        int ix;
        int iy2;
        int iy1;
        int i;
        Color cfill;
        super.draw(flag);
        if (!this.MP.is2D) {
            return;
        }
        Color color = cfill = this.MP.getOption(8) ? Color.black : this.MP.theme.cbg;
        if (flag != 2 || this.clear) {
            this.MP.gc.setColor(cfill);
            this.MP.gc.fillRect(this.MP.ix1, this.MP.iy1, this.MP.ix21, this.MP.iy21);
            this.MP.setColor(this.cgrid);
            i = this.MP.myy > 0.0 ? 0 : this.ny;
            iy1 = Math.max(this.MP.iy1, (int)(this.MP.myy * (double)i + this.MP.myb));
            i = this.MP.myy > 0.0 ? this.ny : 0;
            iy2 = Math.min(this.MP.iy2, (int)(this.MP.myy * (double)i + this.MP.myb));
            for (i = 0; i <= this.nx; ++i) {
                ix = (int)(this.MP.mxx * (double)i + this.MP.mxb);
                if (ix <= this.MP.ix1 || ix >= this.MP.ix2) continue;
                this.MP.gc.drawLine(ix, iy1, ix, iy2);
            }
            i = this.MP.mxx > 0.0 ? 0 : this.nx;
            ix1 = Math.max(this.MP.ix1, (int)(this.MP.mxx * (double)i + this.MP.mxb));
            i = this.MP.mxx > 0.0 ? this.nx : 0;
            ix2 = Math.min(this.MP.ix2, (int)(this.MP.mxx * (double)i + this.MP.mxb));
            for (i = 0; i <= this.ny; ++i) {
                iy = (int)(this.MP.myy * (double)i + this.MP.myb);
                if (iy <= this.MP.iy1 || iy >= this.MP.iy2) continue;
                this.MP.gc.drawLine(ix1, iy, ix2, iy);
            }
            this.myrast = (int)(this.MP.myy > 0.0 ? this.MP.myy : -this.MP.myy) - 4;
            this.clear = false;
        }
        if (this.ndata <= 0) {
            return;
        }
        if (this.single >= 0 && this.ichan != this.single) {
            return;
        }
        i = this.ichan - 1;
        if (this.yx) {
            ix = i / this.ny;
            iy = i - ix * this.ny;
        } else {
            iy = i / this.nx;
            ix = i - iy * this.nx;
        }
        i = this.MP.mxx > 0.0 ? ix : ix + 1;
        ix1 = (int)(this.MP.mxx * (double)i + this.MP.mxb) + 2;
        i = this.MP.mxx > 0.0 ? ix + 1 : ix;
        ix2 = (int)(this.MP.mxx * (double)i + this.MP.mxb) - 2;
        i = this.MP.myy > 0.0 ? iy : iy + 1;
        iy1 = (int)(this.MP.myy * (double)i + this.MP.myb) + 2;
        i = this.MP.myy > 0.0 ? iy + 1 : iy;
        iy2 = (int)(this.MP.myy * (double)i + this.MP.myb) - 2;
        if (ix1 > this.MP.ix2 || ix2 < this.MP.ix1) {
            return;
        }
        if (iy1 > this.MP.iy2 || iy2 < this.MP.iy1) {
            return;
        }
        double ry2 = this.a2;
        double ry1 = this.a1;
        if (this.minRange != 0.0 && ry2 - ry1 < this.minRange) {
            ry2 = ry1 + this.minRange;
        }
        if (this.maxRange != 0.0 && ry2 - ry1 > this.maxRange) {
            ry1 = ry2 - this.maxRange;
        }
        if (this.type == T_RASTER) {
            if (this.buf == null || this.buf.length < this.nout) {
                this.buf = new byte[this.nout];
                this.mimage = new MImage((MWindow)this.MP, this.nout, 1, this.buf, this.colors);
            }
            int nc = this.ncolors;
            float scl0 = (float)ry1;
            float scl1 = (float)((double)this.ncolors / (ry2 - ry1));
            for (i = 0; i < this.nout; ++i) {
                int b = (int)((this.fbuf[i] - scl0) * scl1);
                if (b < 0) {
                    b = 0;
                }
                if (++b > nc) {
                    b = nc;
                }
                this.buf[i] = (byte)b;
            }
            this.mimage.source.newPixels(0, 0, this.nout, 1);
            this.MP.gc.drawImage(this.mimage.image, ix1, iy1 + this.iyrast, ix2, iy1 + this.iyrast + 1, 0, 0, this.nout, 1, (ImageObserver)this.mimage);
            int iyn = iy1 + this.iyrast + 1;
            int ix1n = Math.max(ix1, this.MP.ix1);
            int ix2n = Math.min(ix2, this.MP.ix2);
            int ixd = ix2n - ix1n >> 4;
            if (ixd < 1) {
                ixd = 1;
            }
            if (this.iyrast < this.myrast && iyn > this.MP.iy1 && iyn < this.MP.iy2) {
                this.MP.setColor(this.cgrid);
                this.MP.gc.drawLine(ix1n + 1, iyn, ix1n + ixd, iyn);
                this.MP.gc.drawLine(ix2n - ixd, iyn, ix2n - 1, iyn);
            }
            return;
        }
        boolean clearCell = true;
        i = this.ichan - 1;
        if (this.keep > 1 && this.ichan > 0 && this.ichan <= this.nchan) {
            int n = i = this.ichan - 1;
            this.ikeep[n] = this.ikeep[n] + 1;
            if (this.ikeep[n] >= this.keep) {
                this.ikeep[i] = 0;
            } else {
                clearCell = false;
            }
        }
        if (clearCell) {
            this.MP.gc.setColor(cfill);
            this.MP.gc.fillRect(ix1 - 1, iy1 - 1, ix2 - ix1 + 2, iy2 - iy1 + 2);
        }
        int[] pax = this.MP.pix.x;
        int[] pay = this.MP.pix.y;
        double myy = (double)(iy1 - iy2) / (ry2 - ry1);
        double myb = (double)iy2 - ry1 * myy;
        double mxx = (double)(ix2 - ix1) / (ry2 - ry1);
        double mxb = (double)ix1 - ry1 * mxx;
        double x = ix1;
        double dx = (double)(ix2 - ix1) / (double)this.nout;
        int iymin = iy1 + 1;
        int iymax = iy2 - 1;
        if (this.cselect != null) {
            if (this.selected == this.ichan) {
                this.setColor(this.cselect);
            } else {
                this.setColor(1);
            }
        }
        if (this.type == T_XYPOINT && this.spa == 2) {
            int j = 0;
            for (i = 0; i < this.nout; ++i) {
                ix = (int)((double)this.fbuf[j++] * mxx + mxb);
                iy = (int)((double)this.fbuf[j++] * myy + myb);
                if (ix < ix1) {
                    ix = 1;
                } else if (ix > ix2) {
                    ix = ix2;
                }
                pax[i] = ix;
                if (iy < iy1) {
                    iy = 1;
                } else if (iy > iy2) {
                    iy = iy2;
                }
                pay[i] = iy;
            }
            this.MP.drawPixels(pax, pay, this.nout, this.line);
        } else if (this.proc == P_RAW && this.spa == 2) {
            int y;
            i = 0;
            int j = 0;
            while (i < this.nout) {
                pax[i] = (int)x;
                y = (int)((double)this.fbuf[j] * myy + myb);
                if (y < iymin) {
                    y = iymin;
                } else if (y > iymax) {
                    y = iymax;
                }
                pay[i] = y;
                ++i;
                j += 2;
                x += dx;
            }
            this.MP.drawPixels(pax, pay, this.nout, this.line);
            i = 0;
            j = 1;
            while (i < this.nout) {
                y = (int)((double)this.fbuf[j] * myy + myb);
                if (y < iymin) {
                    y = iymin;
                } else if (y > iymax) {
                    y = iymax;
                }
                pay[i] = y;
                ++i;
                j += 2;
            }
            this.MP.drawPixels(pax, pay, this.nout, this.line);
        } else {
            i = 0;
            while (i < this.nout) {
                pax[i] = (int)x;
                int y = (int)((double)this.fbuf[i] * myy + myb);
                if (y < iymin) {
                    y = iymin;
                } else if (y > iymax) {
                    y = iymax;
                }
                pay[i] = y;
                ++i;
                x += dx;
            }
            this.MP.drawPixels(pax, pay, this.nout, this.line);
        }
    }

    private int getChan(Position pos) {
        int ix = (int)pos.x;
        int iy = (int)pos.y;
        this.select = ix < 0 || ix >= this.nx || iy < 0 || iy >= this.ny ? 0 : (this.yx ? ix * this.ny + iy + 1 : iy * this.nx + ix + 1);
        return this.select;
    }

    public void select(Position pos) {
        this.select = this.getChan(pos);
    }

    public int select() {
        return this.select;
    }

    public int getSelect() {
        return this.select;
    }

    public void setSelect(int chan) {
        this.selected = chan;
    }

    public void setSelectColor(String cstr) {
        this.cselect = MColor.getColor((Object)cstr);
    }

    public void single(int channel) {
        this.single = channel;
    }

    public int single() {
        return this.single;
    }

    public void skip(int frames) {
        this.skip = frames;
    }

    public int skip() {
        return this.skip;
    }

    public String getReadOut(Position mp) {
        int iexp;
        int chan = this.getChan(mp);
        double ax = mp.x % 1.0;
        double ay = mp.y % 1.0;
        int i = (int)(ax * (double)this.nout);
        ay = this.a1 + (1.0 - ay) * (this.a2 - this.a1);
        int jexp = this.getTicExp(0.0, this.a2 - this.a1);
        if (this.proc == P_FFT) {
            ax = (double)(i - this.nrot) * this.delf;
            iexp = this.getTicExp(0.0, this.delf * (double)this.nout);
        } else if (this.type == T_XYPOINT) {
            ax = this.a1 + ax * (this.a2 - this.a1);
            iexp = jexp;
        } else {
            ax = (double)i * this.delx;
            iexp = this.getTicExp(0.0, this.delx * (double)this.nout);
        }
        String tmp = " MC (Chan=" + chan + " x=" + this.MP.formNumber(ax, iexp, 0);
        if (this.type != T_RASTER) {
            tmp = tmp + " y=" + this.MP.formNumber(ay, jexp, 0);
        }
        if (this.type != T_RASTER && this.proc == P_FFT && chan > 0 && this.ca2s != null) {
            tmp = tmp + " dyPk=" + this.MP.formNumber(ay - this.ca2s[chan - 1], jexp, 0);
        }
        tmp = tmp + ")";
        return tmp;
    }

    private int getTicExp(double dmin, double dmax) {
        double absmax = Math.max(Math.abs(dmin), Math.abs(dmax));
        if (absmax == 0.0) {
            return 0;
        }
        int kengr = (int)(0.1447648 * Math.log(absmax / 2.0));
        if (absmax < 1.0) {
            --kengr;
        }
        return kengr * 3;
    }

    public void setYX(boolean state) {
        this.yx = state;
    }

    public int getMCSchan(byte[] buf) {
        int chan = (buf[0] & 1) << 0 | (buf[2] & 1) << 1 | (buf[4] & 1) << 2 | (buf[6] & 1) << 3;
        if (++chan >= this.mcs) {
            chan = this.mcs;
        }
        return chan;
    }
}

