/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.CoreCommon;
import nxm.ice.lib.NetIO;
import nxm.sys.inc.PacketHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Native;
import nxm.sys.lib.Time;

public class VRTPacket
implements PacketHandler,
Cloneable {
    private int O_HDR = 0;
    private int O_SID = 4;
    private int O_OUID = 8;
    private int O_CID = 12;
    private int O_TSIS = 16;
    private int O_TSFS = 20;
    private int O_TAIL = 28;
    public static int OUID_ICE = 1068407;
    public static int OUID_DIFI = 6971934;
    public static int TSI_NONE = 0;
    public static int TSI_UTC = 1;
    public static int TSI_GPS = 2;
    public static int TSI_POSIX = 3;
    public static int TSF_NONE = 0;
    public static int TSF_CNT = 1;
    public static int TSF_PSEC = 2;
    public static int TSF_FRC = 3;
    public static String flagsList = "TRIM,BIGE,NOID,CTX,NOSID,DIFI";
    public static int FLG_NONE = 0;
    public static int FLG_TRIM = 1;
    public static int FLG_BIGE = 2;
    public static int FLG_NOUID = 4;
    public static int FLG_CTX = 8;
    public static int FLG_NOSID = 16;
    public static int FLG_DIFI = 32;
    public byte[] buf = new byte[32];
    public byte[] cbuf;
    private int headerOffset = 0;
    private int headerLength = 32;
    private int trailerOffset = 28;
    private int trailerLength = 4;
    private int fixedBytes = 1440;
    private int hdr;
    private int sid;
    private int ouid;
    private int cid;
    private int ctx;
    private int chdr;
    private int size;
    private int bits;
    private int fbits;
    private int fb;
    private int tb;
    private int count;
    private int ipoff;
    private int rhdrs;
    private int whdrs;
    private int flags;
    private int dataLength;
    private int totalLength;
    private int fdataLength;
    private String format;
    byte hrep = (byte)73;
    byte drep = (byte)69;
    private boolean isInput = false;
    private boolean needsContext = false;
    private double npktoff;

    public VRTPacket() {
        this("SB", 0, null);
    }

    public VRTPacket(String format, String variant) {
        this(format, 0, variant);
    }

    public VRTPacket(String format, int flags) {
        this(format, flags, null);
    }

    public VRTPacket(String format, int flags, String variant) {
        if (variant != null) {
            if (variant.equals("VRT")) {
                flags |= 0;
            } else if (variant.equals("VRTL")) {
                flags |= FLG_NOSID | FLG_TRIM;
            } else if (variant.equals("VRTW")) {
                flags |= FLG_NOSID | FLG_TRIM | FLG_BIGE;
            } else if (variant.equals("VRTX")) {
                flags |= FLG_NOUID | FLG_CTX | FLG_BIGE;
            } else if (variant.equals("VRTD")) {
                flags |= FLG_DIFI | FLG_TRIM | FLG_BIGE;
            } else {
                System.out.println("Unknown VRT variant: " + variant);
            }
        }
        this.flags = flags;
        this.formHeaderBlock();
        this.setFormat(format);
        this.setCount(0);
        this.setSID(1);
        this.setOUID((flags & FLG_DIFI) != 0 ? OUID_DIFI : OUID_ICE);
        this.setTC(0.0, 0.0);
        this.setSize(1024);
    }

    private void packL(int off, int data) {
        if (off < 0) {
            return;
        }
        Convert.packL((byte[])this.buf, (int)off, (int)data, (byte)this.hrep);
    }

    private void packX(int off, long data) {
        if (off < 0) {
            return;
        }
        Convert.packX((byte[])this.buf, (int)off, (long)data, (byte)this.hrep);
    }

    private int unpackL(int off) {
        if (off < 0) {
            return 0;
        }
        return Convert.unpackL((byte[])this.buf, (int)off, (byte)this.hrep);
    }

    private long unpackX(int off) {
        if (off < 0) {
            return 0L;
        }
        return Convert.unpackX((byte[])this.buf, (int)off, (byte)this.hrep);
    }

    private void formHeaderBlock() {
        int n = 0;
        this.O_TAIL = -1;
        this.O_TSFS = -1;
        this.O_TSIS = -1;
        this.O_CID = -1;
        this.O_OUID = -1;
        this.O_SID = -1;
        this.hdr = 0x600000;
        this.O_HDR = n;
        n += 4;
        if ((this.flags & FLG_NOSID) == 0) {
            this.hdr |= 0x10000000;
            this.O_SID = n;
            n += 4;
        }
        if ((this.flags & FLG_NOUID) == 0) {
            this.hdr |= 0x8000000;
            this.O_OUID = n;
            this.O_CID = n += 4;
            n += 4;
        }
        this.O_TSIS = n;
        this.O_TSFS = n += 4;
        n += 8;
        if ((this.flags & FLG_TRIM) == 0) {
            this.hdr |= 0x4000000;
            this.O_TAIL = n;
            n += 4;
            this.trailerLength = 4;
            this.setTrailer(-469368832);
        } else {
            this.trailerLength = 0;
        }
        Convert.packL((byte[])this.buf, (int)0, (int)this.hdr, (byte)this.hrep);
        this.headerLength = n;
    }

    public VRTPacket(String format, int size, int flags) {
        this(format, flags);
        this.setSize(size);
    }

    private void initFrom(DataFile df) {
        this.setRep((byte)df.getDataRep().charAt(0));
        if (df.hp != null) {
            df.hp.seek((double)((long)df.getDataStart()));
            df.hp.read(this.buf, this.headerOffset, this.headerLength);
            df.hp.seek((double)((long)df.getDataStart()));
        } else {
            df.io.seek((long)df.getDataStart());
            df.io.read(this.buf, this.headerOffset, this.headerLength);
            df.io.seek((long)df.getDataStart());
        }
        this.setInternals();
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    private void setInternals() {
        this.hdr = Convert.unpackL((byte[])this.buf, (int)this.O_HDR, (byte)this.hrep);
        this.headerLength = 4;
        this.trailerLength = 0;
        this.O_TAIL = -1;
        this.O_TSFS = -1;
        this.O_TSIS = -1;
        this.O_CID = -1;
        this.O_OUID = -1;
        this.O_SID = -1;
        if ((this.hdr & 0x10000000) != 0) {
            this.O_SID = this.headerLength;
            this.headerLength += 4;
        }
        if ((this.hdr & 0x8000000) != 0) {
            this.O_OUID = this.headerLength;
            this.headerLength += 4;
            this.O_CID = this.headerLength;
            this.headerLength += 4;
            this.cid = Convert.unpackL((byte[])this.buf, (int)this.O_CID, (byte)this.hrep);
            this.bits = (this.cid & 0x3F) + 1;
            if ((this.cid & 0x2000) != 0) {
                this.bits *= 2;
            }
        }
        if ((this.hdr & 0xF00000) != 0) {
            this.O_TSIS = this.headerLength;
            this.headerLength += 4;
            this.O_TSFS = this.headerLength;
            this.headerLength += 8;
        }
        if ((this.hdr & 0x4000000) != 0) {
            this.O_TAIL = this.headerLength;
            this.headerLength += 4;
            this.trailerLength = 4;
        }
        this.trailerOffset = this.headerLength - this.trailerLength;
        this.totalLength = (this.hdr & 0xFFFF) << 2;
        this.dataLength = this.totalLength - this.headerLength;
        this.fdataLength = this.fbits * this.dataLength / this.bits;
        this.size = this.dataLength * 8 / this.bits;
    }

    public void createContextFor(int ctx, int rate, int freq, int gain) {
        int n = 0;
        this.cbuf = new byte[256];
        long lrate = (long)rate << 20;
        long lfreq = (long)freq << 20;
        int lgain = gain << 7;
        int lform = 536871887;
        if (ctx == 0) {
            return;
        }
        if (ctx == 1) {
            ctx = (this.flags & FLG_NOUID) != 0 ? 16844178 : 1299;
        }
        int lctx = CoreCommon.brev4(ctx & 0xFFFFC);
        this.chdr = 1096810502;
        Convert.packL((byte[])this.cbuf, (int)(n * 4), (int)this.chdr, (byte)this.hrep);
        Convert.packL((byte[])this.cbuf, (int)(++n * 4), (int)this.sid, (byte)this.hrep);
        ++n;
        if ((ctx >> 23 & 1) == 0) {
            this.chdr = 1231028232;
            Convert.packL((byte[])this.cbuf, (int)(n * 4), (int)this.ouid, (byte)this.hrep);
            Convert.packL((byte[])this.cbuf, (int)(++n * 4), (int)0, (byte)this.hrep);
            ++n;
        }
        Convert.packL((byte[])this.cbuf, (int)((n += 3) * 4), (int)lctx, (byte)this.hrep);
        ++n;
        if ((ctx >> 4 & 1) == 1) {
            Convert.packX((byte[])this.cbuf, (int)(n * 4), (long)lfreq, (byte)this.hrep);
            n += 2;
        }
        if ((ctx >> 8 & 1) == 1) {
            Convert.packL((byte[])this.cbuf, (int)(n * 4), (int)lgain, (byte)this.hrep);
            ++n;
        }
        if ((ctx >> 10 & 1) == 1) {
            Convert.packX((byte[])this.cbuf, (int)(n * 4), (long)lrate, (byte)this.hrep);
            n += 2;
        }
        if ((ctx >> 16 & 1) == 1) {
            Convert.packL((byte[])this.cbuf, (int)(n * 4), (int)lform, (byte)this.hrep);
            Convert.packL((byte[])this.cbuf, (int)(++n * 4), (int)0, (byte)this.hrep);
            ++n;
        }
        this.chdr = (this.chdr & 0xFFFFFF00) + n;
        Convert.packL((byte[])this.cbuf, (int)0, (int)this.chdr, (byte)this.hrep);
        this.ctx = ctx;
    }

    public int getNextContext() {
        int len = this.chdr & 0xFF;
        Convert.packL((byte[])this.cbuf, (int)0, (int)this.chdr, (byte)this.hrep);
        System.arraycopy(this.buf, this.O_TSIS, this.cbuf, (this.ctx >> 20 & 1) != 0 ? 8 : 16, 12);
        int cnt = this.chdr >> 16 & 0xF;
        this.chdr = this.chdr & 0xFFF0FFFF | (++cnt & 0xF) << 16;
        return len << 2;
    }

    public void setRep(byte rep) {
        this.drep = rep;
    }

    public byte getRep() {
        return this.drep;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int getTrailerLength() {
        return this.trailerLength;
    }

    public void setSize(int elem) {
        this.size = elem;
        this.setBytes(elem * this.bits / 8);
    }

    public int getSize() {
        return this.size;
    }

    public void setBytes(int bytes) {
        this.size = bytes * 8 / this.bits;
        this.dataLength = bytes;
        this.fdataLength = this.fbits * this.dataLength / this.bits;
        this.totalLength = this.headerLength + this.dataLength;
        int pktsize = this.totalLength + 3 >> 2;
        this.hdr = this.hdr & 0xFFFF0000 | pktsize;
        this.packL(this.O_HDR, this.hdr);
    }

    public int getBytes() {
        return this.dataLength;
    }

    public void setTrailer(int trailer) {
        this.packL(this.O_TAIL, trailer);
    }

    public void setSID(int sid) {
        if (this.O_SID > 0) {
            this.packL(this.O_SID, sid);
        } else if (this.O_CID > 0) {
            this.cid = this.cid & 0xFFFF | sid << 16;
            this.packL(this.O_CID, this.cid);
        }
        this.sid = sid;
    }

    public int getSID() {
        if (this.O_SID > 0) {
            return this.unpackL(this.O_SID);
        }
        if (this.O_CID > 0) {
            return this.unpackL(this.O_CID) >> 16;
        }
        return 0;
    }

    public void setOUID(int ouid) {
        this.packL(this.O_OUID, ouid);
        this.ouid = ouid;
    }

    public int getOUID() {
        return this.unpackL(this.O_OUID);
    }

    public void setICID(int icid) {
        this.setCID(this.cid & 0xFFFF | icid << 16);
    }

    public int getICID() {
        return this.cid >> 16 & 0xFFFF;
    }

    public void setCID(int cid) {
        this.cid = cid;
        this.packL(this.O_CID, cid);
    }

    public int getCID() {
        return this.cid;
    }

    public void setCount(int count) {
        this.count = count;
        this.hdr = this.hdr & 0xFFF0FFFF | (count & 0xF) << 16;
        this.packL(this.O_HDR, this.hdr);
    }

    public int getCount() {
        if (this.isInput) {
            int hdr = this.unpackL(this.O_HDR);
            this.count = hdr >> 16 & 0xF;
        }
        return this.count;
    }

    public void upCount() {
        ++this.count;
        this.setCount(this.count);
    }

    public void setFormat(String format) {
        if (format.equals(this.format)) {
            return;
        }
        this.format = format;
        if (!DataFile.checkFormat((String)format, (String)"S#,C#")) {
            System.out.println("Unallowed format=" + format);
        }
        char mode = format.charAt(0);
        char type = format.charAt(1);
        int bps = Data.getBPS((char)type);
        this.bits = bps < 0 ? -bps : bps * 8;
        this.fbits = this.bits;
        this.fb = this.bits - 1;
        this.tb = 128;
        this.tb |= mode == 'C' ? 16 : 0;
        this.tb = type == 'F' ? (this.tb |= 0xE) : (type == 'D' ? (this.tb |= 0xF) : (this.tb |= 0));
        if ((this.flags & FLG_BIGE) != 0) {
            this.tb |= 0x40;
        }
        this.cid = this.cid & 0xFFFF0000 | this.tb << 8 | this.fb;
        this.packL(this.O_CID, this.cid);
    }

    public String getFormat() {
        return this.format;
    }

    public void setBits(int bits) {
        this.bits = bits;
        int fb = bits - 1;
        this.cid = this.cid & 0xFFFFFF00 | fb & 0x3F;
        this.packL(this.O_CID, this.cid);
    }

    public int getBits() {
        return this.bits;
    }

    public void setTC(double wsec, double fsec) {
        int isec = (int)(wsec + -6.31152E8);
        long psec = (long)(fsec * 1.0E12 + 0.5);
        if (psec < 0L) {
            --isec;
            psec = (long)((double)psec + 1.0E12);
        }
        if (this.O_TSIS > 0) {
            this.packL(this.O_TSIS, isec);
        }
        if (this.O_TSFS > 0) {
            this.packX(this.O_TSFS, psec);
        }
        this.hdr = this.hdr & 0xFF0FFFFF | TSI_UTC << 22 | TSF_PSEC << 20;
        this.packL(this.O_HDR, this.hdr);
    }

    public Time getTC() {
        int isec = this.O_TSIS < 0 ? 0 : Convert.unpackL((byte[])this.buf, (int)this.O_TSIS, (byte)this.hrep);
        long psec = this.O_TSFS < 0 ? 0L : Convert.unpackX((byte[])this.buf, (int)this.O_TSFS, (byte)this.hrep);
        double wsec = isec;
        double fsec = (double)psec * 1.0E-12;
        return new Time(wsec += 6.31152E8, fsec);
    }

    private void pack(byte[] buf, int boff, int n, int ibits, int obits) {
        int iadr = 0;
        int oadr = 0;
        int diff = ibits - obits;
        if (this.drep == 73) {
            for (int i = 0; i < n; ++i) {
                int j = 0;
                iadr = i * ibits;
                oadr = i * obits;
                while (j < obits) {
                    int ibyt = iadr >> 3;
                    int ibit = ~iadr & 7;
                    int obyt = oadr >> 3;
                    int obit = ~oadr & 7;
                    if ((buf[ibyt] & 1 << ibit) == 0) {
                        int n2 = obyt;
                        buf[n2] = (byte)(buf[n2] & ~(1 << obit));
                    } else {
                        int n3 = obyt;
                        buf[n3] = (byte)(buf[n3] | 1 << obit);
                    }
                    ++j;
                    ++iadr;
                    ++oadr;
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int j = 0;
                iadr = i * ibits + diff;
                oadr = i * obits;
                while (j < obits) {
                    int ibyt = iadr >> 3;
                    int ibit = iadr & 7;
                    int obyt = oadr >> 3;
                    int obit = oadr & 7;
                    if ((buf[ibyt] & 1 << ibit) == 0) {
                        int n4 = obyt;
                        buf[n4] = (byte)(buf[n4] & ~(1 << obit));
                    } else {
                        int n5 = obyt;
                        buf[n5] = (byte)(buf[n5] | 1 << obit);
                    }
                    ++j;
                    ++iadr;
                    ++oadr;
                }
            }
        }
    }

    private void unpack(byte[] buf, int boff, int n, int ibits, int obits) {
        int diff = ibits - obits;
        if (this.drep == 73) {
            for (int i = n; i > 0; --i) {
                int j = 0;
                int iadr = i * ibits - 1 - diff;
                int oadr = i * obits - 1;
                while (j < obits) {
                    int ibyt = iadr >> 3;
                    int ibit = ~iadr & 7;
                    int obyt = oadr >> 3;
                    int obit = ~oadr & 7;
                    if (j + diff < 0 || (buf[ibyt] & 1 << ibit) == 0) {
                        int n2 = obyt;
                        buf[n2] = (byte)(buf[n2] & ~(1 << obit));
                    } else {
                        int n3 = obyt;
                        buf[n3] = (byte)(buf[n3] | 1 << obit);
                    }
                    ++j;
                    --iadr;
                    --oadr;
                }
            }
        } else {
            for (int i = n; i > 0; --i) {
                int j = obits - 1;
                int iadr = i * ibits - 1;
                int oadr = i * obits - 1;
                while (j >= 0) {
                    int ibyt = iadr >> 3;
                    int ibit = iadr & 7;
                    int obyt = oadr >> 3;
                    int obit = oadr & 7;
                    if (j + diff < 0 || (buf[ibyt] & 1 << ibit) == 0) {
                        int n4 = obyt;
                        buf[n4] = (byte)(buf[n4] & ~(1 << obit));
                    } else {
                        int n5 = obyt;
                        buf[n5] = (byte)(buf[n5] | 1 << obit);
                    }
                    --j;
                    --iadr;
                    --oadr;
                }
            }
        }
    }

    public int ctx2pkt(long pdata) {
        int len = this.getNextContext();
        Native.ja2p((Object)this.cbuf, (int)0, (long)pdata, (int)0, (int)len);
        return len;
    }

    public int buf2pkt(byte[] dbuf, int off, long pdata, int len) {
        int hlen = this.headerLength - this.trailerLength;
        Native.ja2p((Object)this.buf, (int)0, (long)pdata, (int)0, (int)hlen);
        Native.ja2p((Object)dbuf, (int)off, (long)pdata, (int)hlen, (int)len);
        if (this.bits == 16 && (this.flags & FLG_BIGE) != 0) {
            NetIO.swap2(pdata + (long)hlen, pdata + (long)hlen, len);
        }
        if (this.bits == 12) {
            NetIO.cvt16to12(pdata + (long)hlen, pdata + (long)hlen, len);
            len = len / 4 * 3;
        }
        Native.ja2p((Object)this.buf, (int)hlen, (long)pdata, (int)(hlen + len), (int)this.trailerLength);
        return this.headerLength + len;
    }

    public String getConfiguration(DataFile df) {
        String config = "VRT";
        if (df.hp != null) {
            config = config + "/DET";
            if (df.hp.aux != null && df.hp.aux.length() > 0) {
                config = config + "=" + df.hp.aux;
            }
        }
        return config;
    }

    public void setFileName(DataFile df, FileName filename) {
        DataFile hp = new DataFile();
        hp.init(null, (Object)filename, "3000", "NH", df.getPacketHandlerFlags());
        String srec = "HDR|SL,SID|SL,OUID|SL,PIC|SL,TCIS|SL,TCFS|SX,TLR|SL";
        hp.setSubRecords(srec);
        if (this.hrep == 73) {
            hp.setDataRep("IEEE");
        }
        if (this.hrep == 69) {
            hp.setDataRep("EEEI");
        }
        df.hp = hp;
    }

    public double naturalDataOffset(DataFile df, double boffset) {
        int bpp = this.fdataLength;
        double npkt = Math.floor(boffset / (double)bpp);
        return npkt * (double)bpp;
    }

    public double dataToPacketOffset(DataFile df, double boffset) {
        double npkt = Math.floor(boffset / (double)this.fdataLength);
        double bpkthdr = npkt * (double)this.headerLength;
        if (this.bits != this.fbits) {
            boffset = boffset * (double)this.bits / (double)this.fbits;
        }
        this.ipoff = (int)(boffset - npkt * (double)this.dataLength);
        if (df.hp == null) {
            boffset += bpkthdr;
            if (this.ipoff > 0) {
                boffset += (double)(this.headerLength - this.trailerLength);
            }
        } else {
            if (this.ipoff > 0) {
                npkt += 1.0;
            }
            this.npktoff = npkt;
        }
        return boffset;
    }

    public double packetToDataOffset(DataFile df, double boffset) {
        int bpp = this.dataLength;
        if (df.hp == null) {
            bpp += this.headerLength;
        }
        double npkt = Math.floor(boffset / (double)bpp);
        return npkt * (double)this.fdataLength;
    }

    public void open(DataFile df) {
        this.isInput = df.isInput;
        this.setFormat(df.getFormat());
        if (df.hp != null) {
            df.hp.open();
        }
        if (this.isInput) {
            this.initFrom(df);
        }
    }

    public void seek(DataFile df, double boffset) {
        boffset = this.dataToPacketOffset(df, boffset);
        if (df.hp != null) {
            df.hp.seek(this.npktoff);
        }
        if (df.io != null) {
            df.io.seek((long)(df.getDataStart() + boffset));
        }
    }

    public int read(DataFile df, byte[] buf, int boff, int bytes, long lbuf) {
        int nb;
        int nbp = this.getBytes();
        int fboff = boff;
        int nelem = bytes * 8 / this.fbits;
        this.rhdrs = 0;
        for (int ndo = this.bits != this.fbits ? bytes * this.bits / this.fbits : bytes; ndo > 0; ndo -= nb) {
            if (this.ipoff == 0) {
                if (df.hp != null) {
                    df.hp.read(this.buf, this.headerOffset, this.headerLength);
                } else {
                    df.io.read(this.buf, this.headerOffset, this.headerLength - this.trailerLength);
                }
                ++this.rhdrs;
            }
            nb = Math.min(ndo, nbp - this.ipoff);
            nb = buf != null ? df.io.read(buf, boff, nb) : df.io.read(lbuf, boff, nb);
            if (nb < 0) {
                return nb;
            }
            boff += nb;
            this.ipoff += nb;
            if (this.ipoff == nbp) {
                this.ipoff = 0;
            }
            if (this.ipoff != 0 || df.hp != null) continue;
            df.io.read(this.buf, this.trailerOffset, this.trailerLength);
        }
        if (this.bits != this.fbits) {
            this.unpack(buf, fboff, nelem, this.bits, this.fbits);
        }
        return bytes;
    }

    public int write(DataFile df, byte[] buf, int boff, int bytes, long lbuf) {
        int nbp = this.getBytes();
        int ndo = this.bits != this.fbits ? bytes * this.bits / this.fbits : bytes;
        int nelem = bytes * 8 / this.fbits;
        if (this.needsContext) {
            int nby = this.getNextContext();
            df.io.write(this.cbuf, 0, nby);
            this.needsContext = false;
        }
        if (this.bits != this.fbits) {
            this.pack(buf, boff, nelem, this.fbits, this.bits);
        }
        if (this.bits == 16 && (this.flags & FLG_BIGE) != 0) {
            Convert.swap2((byte[])buf, (int)boff, (int)(bytes >> 1));
        }
        this.whdrs = 0;
        while (ndo > 0) {
            if (this.ipoff == 0) {
                if (df.hp != null) {
                    df.hp.write(this.buf, this.headerOffset, this.headerLength);
                } else {
                    df.io.write(this.buf, this.headerOffset, this.headerLength - this.trailerLength);
                }
                ++this.whdrs;
            }
            int nb = Math.min(bytes, nbp - this.ipoff);
            nb = buf != null ? df.io.write(buf, boff, nb) : df.io.write(lbuf, boff, nb);
            if (nb < 0) {
                return nb;
            }
            boff += nb;
            this.ipoff += nb;
            if (this.ipoff == nbp) {
                this.ipoff = 0;
            }
            if (this.ipoff == 0 && df.hp == null) {
                df.io.write(this.buf, this.trailerOffset, this.trailerLength);
            }
            ndo -= nb;
        }
        return bytes;
    }

    public void close(DataFile df) {
        if (df.hp != null) {
            df.hp.close();
        }
    }

    public boolean hasHeader() {
        return this.rhdrs > 0;
    }

    public String listHeader() {
        Time t = this.getTC();
        String ts = t != null ? t.toString(12) : null;
        String list = "VRT-Packet OUID=" + Convert.l2x((int)this.getOUID()) + " Stream=" + this.getSID() + " Count=" + this.getCount() + " Size=" + this.getSize() + " Bits=" + this.getBits() + " TC=" + ts;
        return list;
    }

    public PacketHandler cloneOf() {
        PacketHandler ph = null;
        try {
            ph = (PacketHandler)this.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ph;
    }

    public void setBuffer(byte[] buffer, int boff) {
        System.arraycopy(buffer, boff, this.buf, this.headerOffset, this.headerLength);
    }

    public void getBuffer(byte[] buffer, int boff) {
        System.arraycopy(this.buf, this.headerOffset, buffer, boff, this.headerLength);
    }
}

