/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Time;

public class TimeCode {
    public static final int TCM_OFF = 0;
    public static final int TCM_CPU = 1;
    public static final int TCM_ZTC = 2;
    public static final int TCM_SDN = 3;
    public static final int TCM_SMS = 4;
    public static final int TCM_DTL = 5;
    public static final int TCM_IRB = 6;
    public static final int TCM_SDDS = 7;
    public static final String tcmodeList = "CPU,ZTC,SDN,SMS,DTL,IRB,SDDS";
    public Time time = new Time();
    private int tcmode;
    private int tcbit;
    private int tcbits;
    private int tcflags;
    private byte[] buffer = new byte[128];
    private byte fill;
    private byte mask;
    private final byte B1 = 1;
    private final byte B0 = 0;
    private double hack;
    private double yis;
    private int OPPS = 1;
    private int FILL = 2;
    private int VFT = 4;
    private int EXT = 8;
    private int TDC = 16;
    private int BARKER = 39;
    private boolean debug = false;

    public void setTime(Time time) {
        this.time.fromTime(time);
        this.yis = time.getYiS();
    }

    public void setMode(String tcmodestr) {
        int i;
        int len;
        this.tcbit = 0;
        this.tcmode = 0;
        this.tcflags = 0;
        for (len = tcmodestr.length(); len < 3; ++len) {
            tcmodestr = tcmodestr + ' ';
        }
        String s = tcmodestr.substring(0, 3);
        this.tcmode = Parser.find((String)tcmodeList, (String)s, (int)0);
        if (this.tcmode <= 0) {
            throw new MidasException("Mode string=" + tcmodestr + " not found in " + tcmodeList);
        }
        if (this.tcmode == 4) {
            this.tcbit = 1;
        }
        if (this.tcmode == 3) {
            this.tcbit = 4;
            this.tcflags |= this.VFT;
        }
        if (len < 4) {
            return;
        }
        char c = tcmodestr.charAt(3);
        if (c != 'X' && c != 'S') {
            if (c == '0') {
                this.tcbit = 0;
            } else if (c == '1') {
                this.tcbit = 1;
            } else if (c == '3') {
                this.tcbit = 3;
            } else if (c == '4') {
                this.tcbit = 4;
            } else {
                throw new MidasException("Bad tcmode string bit field: " + tcmodestr);
            }
        }
        this.fill = (byte)(1 << this.tcbit);
        this.mask = ~this.fill;
        for (i = 4; i < len; ++i) {
            c = tcmodestr.charAt(i);
            if (c == 'P') {
                this.tcflags |= this.OPPS;
                continue;
            }
            if (c == 'F') {
                this.tcflags |= this.FILL;
                continue;
            }
            if (c == 'X') {
                this.tcflags |= this.EXT;
                continue;
            }
            if (c == 'Y') {
                this.tcflags &= ~this.VFT;
                continue;
            }
            if (c == 'D') {
                this.tcflags |= this.TDC;
                continue;
            }
            throw new MidasException("Bad tcmode string flag field: " + tcmodestr);
        }
        this.hack = 0.001;
        if (this.tcmode == 3) {
            this.tcbits = 67;
        }
        if (this.tcmode == 5) {
            this.tcbits = 67;
        }
        if (this.tcmode == 4) {
            this.tcbits = 37;
            this.hack = 1.0;
        }
        if (this.tcmode == 6) {
            this.tcbits = 48;
            this.hack = 1.0;
        }
        if ((this.tcflags & this.EXT) == 0) {
            this.tcbits = Math.min(this.tcbits, 60);
        }
        for (i = 0; i < 128; i += 32) {
            this.setBits(this.buffer, i, 32, -1);
        }
        this.setBits(this.buffer, 1, 7, this.BARKER);
    }

    public void setMode(int mode) {
        this.tcmode = mode;
    }

    public void setBit(int bit) {
        this.tcbit = bit;
    }

    public void setFlags(int flags) {
        this.tcflags = flags;
    }

    private void getTC() {
        if (this.debug) {
            System.out.print("TcBits=[");
            for (int i = 0; i < this.tcbits; ++i) {
                System.out.print(this.buffer[i]);
            }
            System.out.println("]");
        }
        if (this.tcmode == 6) {
            this.getIRB(this.buffer, -1, this.tcbits);
        } else {
            this.getSDN(this.buffer, -1, this.tcbits);
        }
    }

    private void setTC() {
        if (this.tcmode == 6) {
            this.setIRB(this.buffer, 0, this.tcbits);
        } else {
            this.setSDN(this.buffer, 0, this.tcbits);
        }
    }

    public int nextHack(double delta) {
        int samples = (int)(this.hack / delta);
        this.time.addSec((double)samples * delta);
        this.setTC();
        return samples;
    }

    public int getHack(double delta) {
        int samples = (int)(this.hack / delta);
        return samples;
    }

    private void getIRB(byte[] buf, int bit, int nbits) {
        double tc = 0.0;
        double ftc = 0.0;
        int i = this.getbcd(buf, (bit += 8) + 1, 4, 9);
        tc += (double)i;
        i = this.getbcd(buf, bit + 6, 3, 5);
        tc += (double)(i * 10);
        i = this.getbcd(buf, bit + 10, 4, 9);
        tc += (double)(i * 60);
        i = this.getbcd(buf, bit + 15, 4, 5);
        tc += (double)(i * 600);
        i = this.getbcd(buf, bit + 20, 4, 9);
        tc += (double)(i * 3600);
        i = this.getbcd(buf, bit + 25, 4, 2);
        tc += (double)(i * 36000);
        i = this.getbcd(buf, bit + 30, 4, 9);
        tc += (double)((i - 1) * 86400);
        i = this.getbcd(buf, bit + 35, 4, 9);
        tc += (double)(i * 864000);
        i = this.getbcd(buf, bit + 40, 4, 3);
        tc += (double)(i * 8640000);
        tc += 1.0;
        if (this.is(this.OPPS)) {
            ftc = 0.011;
        }
        this.time.fromJ1950(tc, ftc);
    }

    private void setIRB(byte[] buf, int bit, int nbits) {
        double tc = this.time.getWSec();
        bit += 8;
        int day = (int)(tc / 86400.0);
        int hour = (int)((tc -= (double)(day * 86400)) / 3600.0);
        int min = (int)((tc -= (double)(hour * 3600)) / 60.0);
        int sec = (int)(tc -= (double)(min * 60));
        --day;
        this.setbcd(buf, bit + 1, 4, sec % 10);
        this.setbcd(buf, bit + 6, 3, sec / 10);
        this.setbcd(buf, bit + 10, 4, min % 10);
        this.setbcd(buf, bit + 15, 4, min / 10);
        this.setbcd(buf, bit + 20, 4, hour % 10);
        this.setbcd(buf, bit + 25, 4, hour / 10);
        this.setbcd(buf, bit + 30, 4, day % 10);
        this.setbcd(buf, bit + 35, 4, day / 10 % 10);
        this.setbcd(buf, bit + 40, 4, day / 100);
    }

    private void getSDN(byte[] buf, int bit, int nbits) {
        int k;
        int i;
        double tc = 0.0;
        double ftc = 0.0;
        if (nbits > 38) {
            i = this.getbcd(buf, bit + 8, 7, 59);
            tc += (double)i;
            i = this.getbcd(buf, bit + 15, 7, 59);
            tc += (double)(i * 60);
            i = this.getbcd(buf, bit + 22, 6, 23);
            tc += (double)(i * 3600);
            i = this.getbcd(buf, bit + 28, 10, 366);
            tc += (double)((i - 1) * 86400);
        }
        if (nbits > 48) {
            i = this.getbcd(buf, bit + 38, 12, 999);
            ftc += (double)i * 0.001;
        }
        if (nbits > 59 && this.is(this.VFT)) {
            i = 0;
            for (k = 50; k <= 60; ++k) {
                i = (i << 1) + buf[bit + k];
            }
            ftc += (double)i * 5.0E-9;
        }
        if (nbits > 66 && this.is(this.EXT)) {
            i = 0;
            for (k = 61; k <= 63; ++k) {
                i = (i << 1) + (1 - buf[bit + k]);
            }
            ftc += (double)i * 6.25E-10;
            i = 0;
            for (k = 65; k <= 67; ++k) {
                i = (i << 1) + (1 - buf[bit + k]);
            }
            ftc += (double)i * 1.024E-5;
        }
        this.time.fromJ1950(tc, ftc);
    }

    private void setSDN(byte[] buf, int bit, int nbits) {
        double tc = this.time.getWSec() - this.yis;
        double ftc = this.time.getFSec();
        int day = (int)(tc / 86400.0);
        int hour = (int)((tc -= (double)(day * 86400)) / 3600.0);
        int min = (int)((tc -= (double)(hour * 3600)) / 60.0);
        int sec = (int)(tc -= (double)(min * 60));
        this.setbcd(buf, bit + 8, 7, sec);
        this.setbcd(buf, bit + 15, 7, min);
        this.setbcd(buf, bit + 22, 6, hour);
        this.setbcd(buf, bit + 28, 10, ++day);
        if (nbits < 49) {
            return;
        }
        int msec = (int)(ftc * 1000.0);
        this.setbcd(buf, bit + 38, 12, msec);
        if (nbits < 60) {
            return;
        }
        int tics = (int)((ftc - (double)msec * 0.001) / 5.0E-9);
        int k = 50;
        int i = 1024;
        while (k <= 60) {
            buf[bit + k] = (tics & i) != 0 ? (byte)1 : 0;
            ++k;
            i >>= 1;
        }
        if (nbits < 67 || !this.is(this.EXT)) {
            return;
        }
        for (k = 61; k <= 63; ++k) {
            buf[bit + k] = 1;
        }
        k = 65;
        i = 8192;
        while (k <= 67) {
            buf[bit + k] = (tics & i) != 0 ? (byte)0 : 1;
            ++k;
            i >>= 1;
        }
    }

    private boolean is(int flag) {
        return (flag & this.tcflags) != 0;
    }

    private int getbcd(byte[] buf, int bit, int nbits, int maxval) {
        int bcd = 0;
        int mult = 1;
        int val = 0;
        int j = 0;
        int i = 0;
        while (i < nbits) {
            bcd += buf[bit + i] << j;
            if (j == 3 || i == nbits - 1) {
                if (bcd > 9) {
                    throw new MidasException("Bad BCD digit=" + bcd + " at offset=" + (bit + i));
                }
                val += bcd * mult;
                mult *= 10;
                bcd = 0;
                j = -1;
            }
            ++i;
            ++j;
        }
        if (val > maxval) {
            throw new MidasException("Bad BCD value=" + val + " max=" + maxval);
        }
        return val;
    }

    private void setbcd(byte[] buf, int bit, int nbits, int val) {
        int mult = 1;
        int i = 0;
        while (i < nbits) {
            int bcd = val / mult % 10;
            if (i < nbits) {
                byte by = buf[bit + i] = (bcd & 1) != 0 ? (byte)1 : 0;
            }
            if (++i < nbits) {
                byte by = buf[bit + i] = (bcd & 2) != 0 ? (byte)1 : 0;
            }
            if (++i < nbits) {
                byte by = buf[bit + i] = (bcd & 4) != 0 ? (byte)1 : 0;
            }
            if (++i < nbits) {
                buf[bit + i] = (bcd & 8) != 0 ? (byte)1 : 0;
            }
            ++i;
            mult *= 10;
        }
    }

    private void setBits(byte[] buf, int bit, int nbits, int val) {
        for (int i = 0; i < nbits; ++i) {
            buf[bit + i] = (val >> i & 1) != 0 ? (byte)1 : 0;
        }
    }

    public void setFillWords(byte[] data, int offset, int words) {
        int i = 0;
        while (i < words) {
            int n = offset;
            data[n] = (byte)(data[n] | this.fill);
            ++i;
            offset += 2;
        }
    }

    public void setTimeCodeWords(byte[] data, int offset, int words) {
        int i = 0;
        while (i < words) {
            data[offset] = this.buffer[i] != 0 ? (byte)(data[offset] | this.fill) : (byte)(data[offset] & this.mask);
            ++i;
            offset += 2;
        }
    }

    public int findTimeCodeWords(byte[] data, int offset, int words) {
        boolean tdc;
        boolean bl = tdc = (this.tcflags & this.TDC) != 0;
        if (this.tcmode == 3) {
            offset += 2;
        }
        int i = 0;
        while (i < words - this.tcbits) {
            if (tdc) {
                if ((data[offset + 0] & this.fill) != 0 && (data[offset + 4] & this.fill) != 0 && (data[offset + 8] & this.fill) != 0 && (data[offset + 12] & this.fill) == 0 && (data[offset + 16] & this.fill) == 0 && (data[offset + 20] & this.fill) != 0 && (data[offset + 24] & this.fill) == 0 && offset >= 4 && (data[offset - 4] & this.fill) != 0 && offset >= 8 && (data[offset - 8] & this.fill) != 0 && offset >= 12 && (data[offset - 12] & this.fill) != 0) {
                    this.parseTimeCodeWords(data, offset, words - i);
                    return i;
                }
            } else if ((data[offset + 0] & this.fill) != 0 && (data[offset + 2] & this.fill) != 0 && (data[offset + 4] & this.fill) != 0 && (data[offset + 6] & this.fill) == 0 && (data[offset + 8] & this.fill) == 0 && (data[offset + 10] & this.fill) != 0 && (data[offset + 12] & this.fill) == 0 && offset >= 2 && (data[offset - 2] & this.fill) != 0 && offset >= 4 && (data[offset - 4] & this.fill) != 0 && offset >= 6 && (data[offset - 6] & this.fill) != 0) {
                this.parseTimeCodeWords(data, offset, words - i);
                return i;
            }
            ++i;
            offset += 2;
        }
        return -1;
    }

    private void parseTimeCodeWords(byte[] data, int offset, int words) {
        int inc = (this.tcflags & this.TDC) != 0 ? 4 : 2;
        int i = 0;
        while (i < this.tcbits) {
            this.buffer[i] = (data[offset] & this.fill) != 0 ? (byte)1 : 0;
            ++i;
            offset += inc;
        }
        this.getTC();
    }
}

