/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.sys.inc.PacketHandler;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.Native;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;

public class SDDSPacket
implements PacketHandler,
Cloneable {
    public static final int UDP = 1;
    public static final int ICE = 2;
    public byte[] buf = new byte[64];
    private static final long ticsPerSecond = 4000000000L;
    private static final long ticsPerMilliSecond = 4000000L;
    private static final double secondsPerYear = 3.1536E7;
    private static final double SR2L = Math.pow(2.0, 63.0) / 1.25E8;
    private static final double DFDT2I = Math.pow(2.0, 31.0) / 2.0;
    private int headerOffset = 8;
    private int headerLength = 56;
    private int dataLength = 1024;
    private int totalLength = 1080;
    private int size;
    private int bytes;
    private int count;
    private int fixedSize = 1024;
    private int bpa = 1;
    private int ipoff;
    private int missed;
    private int flags;
    private boolean header = false;
    private boolean udp = false;
    private boolean ice = false;
    private boolean tc1ms = true;
    private double npktoff;
    private double yearInSeconds;
    private final byte TCS_1MSV = (byte)-128;
    private final byte TCS_TTV = (byte)64;
    private final byte TCS_SSC = (byte)32;
    private double sampleRate = 0.0;
    private static int leapSecSoY;
    private static int leapSecAdj;

    public SDDSPacket() {
        this("SB", 0);
    }

    public SDDSPacket(String format, int flags) {
        this.flags = flags;
        this.setCount(0);
        this.setFormat(format);
        this.setTC(0, 0.0, 0.0, 0.0);
        if ((flags & 2) != 0) {
            this.setICE(true);
        } else if ((flags & 1) != 0) {
            this.setUDP(true);
        }
        this.setKeys(43605);
        this.setPort(0);
        this.setAddress(0);
    }

    public void setUDP(boolean state) {
        this.udp = state;
        if (!this.udp) {
            this.ice = false;
        }
        if (this.udp) {
            this.headerOffset = 0;
            this.headerLength = 64;
        } else {
            this.headerOffset = 8;
            this.headerLength = 56;
        }
        this.totalLength = this.headerLength + this.dataLength;
    }

    public void setICE(boolean state) {
        this.ice = state;
        this.setUDP(state);
    }

    public void setAddress(int addr) {
        this.buf[4] = (byte)(addr >> 24 & 0xFF);
        this.buf[5] = (byte)(addr >> 16 & 0xFF);
        this.buf[6] = (byte)(addr >> 8 & 0xFF);
        this.buf[7] = (byte)(addr >> 0 & 0xFF);
    }

    public int getAddress() {
        return this.buf[4] << 24 | this.buf[5] << 16 | this.buf[6] << 8 | this.buf[7];
    }

    public String getAddrStr() {
        return this.getAddrStr(this.buf[4]) + "." + this.getAddrStr(this.buf[5]) + "." + this.getAddrStr(this.buf[6]) + "." + this.getAddrStr(this.buf[7]);
    }

    private String getAddrStr(byte b) {
        int i = b;
        return "" + (i &= 0xFF);
    }

    public void setPort(int port) {
        this.buf[2] = (byte)(port >> 8 & 0xFF);
        this.buf[3] = (byte)(port >> 0 & 0xFF);
    }

    public int getPort() {
        return this.buf[2] << 8 & 0xFF00 | this.buf[3] & 0xFF;
    }

    public void setKeys(int key) {
        this.buf[0] = (byte)(key >> 8 & 0xFF);
        this.buf[1] = (byte)(key >> 0 & 0xFF);
    }

    public void setBits(int bits) {
        this.buf[9] = 0;
        if (bits < 0) {
            this.buf[9] = -128;
            bits = -bits;
            this.bpa = 2 * bits / 8;
        } else {
            this.bpa = bits / 8;
        }
        this.buf[9] = (byte)(this.buf[9] | (byte)bits);
        this.buf[8] = -128;
        if (bits <= 4) {
            this.buf[8] = (byte)(this.buf[8] | 0);
        } else if (bits <= 8) {
            this.buf[8] = (byte)(this.buf[8] | 1);
        } else if (bits <= 16) {
            this.buf[8] = (byte)(this.buf[8] | 2);
        }
    }

    public int getBits() {
        int bits = 0x1F & this.buf[9];
        if (this.buf[9] < 0) {
            bits = -bits;
        }
        return bits;
    }

    public void setCount(int count) {
        this.count = count &= 0xFFFF;
        this.buf[10] = (byte)(count >> 8 & 0xFF);
        this.buf[11] = (byte)(count & 0xFF);
    }

    public void upCount() {
        if ((++this.count & 0x1F) == 31) {
            ++this.count;
        }
        this.setCount(this.count);
    }

    public void setFormat(String format) {
        int bps = Data.getBPS((char)format.charAt(1));
        int n = bps = bps < 0 ? -bps : 8 * bps;
        if (format.charAt(0) == 'C') {
            bps = -bps;
        }
        this.setBits(bps);
    }

    public void setSSC(double f, double dfdt) {
        long lrate = (long)(f * SR2L);
        int idfdt = (int)(dfdt * DFDT2I);
        Convert.packL((byte[])this.buf, (int)28, (int)idfdt, (byte)73);
        Convert.packX((byte[])this.buf, (int)32, (long)lrate, (byte)73);
        this.buf[12] = f > 0.0 ? 32 : 0;
    }

    public void setDelta(double delta) {
        this.sampleRate = delta == 0.0 ? 0.0 : (double)Math.round(1.0 / delta);
        double ssc = this.buf[9] < 0 ? this.sampleRate * 2.0 : this.sampleRate;
        this.setSSC(ssc, 0.0);
    }

    public double getSSC() {
        long lrate = Convert.unpackX((byte[])this.buf, (int)32, (byte)73);
        double rate = (double)lrate / SR2L;
        return rate;
    }

    public void setTC(int offset, double delta, double wsec, double fsec) {
        int mask;
        if (wsec > 3.1536E7) {
            if (this.yearInSeconds == 0.0) {
                this.yearInSeconds = new Time(wsec, fsec).getYiS();
            }
            wsec -= this.yearInSeconds;
        }
        if (leapSecAdj != 0 && wsec > (double)leapSecSoY) {
            wsec += (double)leapSecAdj;
        }
        long tics = (long)(wsec * 4.0E9) + (long)(fsec * 4.0E9);
        Convert.packX((byte[])this.buf, (int)16, (long)tics, (byte)73);
        int n = mask = this.sampleRate > 0.0 ? 32 : 0;
        if (delta > 0.0) {
            int msec;
            int mtic;
            mask |= 0x40;
            if (this.tc1ms && (mtic = (int)(((double)(msec = (int)(fsec * 1000.0) + 1) * 0.001 - fsec) / delta)) * this.bpa < 1024) {
                mask |= 0xFFFFFF80;
            }
        }
        this.buf[12] = (byte)mask;
    }

    public Time getTC() {
        return SDDSPacket.getTC(this.buf, 0, 0L);
    }

    public static Time getTC(byte[] buf, int off, long lbuf) {
        long tics = 0L;
        if (buf == null && lbuf != 0L) {
            buf = new byte[24];
            Native.p2ja((long)lbuf, (int)off, (Object)buf, (int)0, (int)24);
            off = 0;
        }
        if (buf != null) {
            if ((buf[off + 12] & 0xC0) == 0) {
                return null;
            }
            tics = Convert.unpackX((byte[])buf, (int)(off + 16), (byte)73);
        }
        long wsec = tics / 4000000000L;
        long fsec = tics - wsec * 4000000000L;
        if (leapSecAdj != 0 && wsec > (long)leapSecSoY) {
            wsec -= (long)leapSecAdj;
        }
        return new Time((double)wsec, (double)fsec * 2.5E-10);
    }

    public int getTCS() {
        return this.buf[12];
    }

    public int getTCO() {
        if ((this.buf[12] & 0x80) == 0) {
            return -1;
        }
        int off = this.buf[12] << 8 & 0x700 | this.buf[13] & 0xFF;
        return off;
    }

    public int getCount() {
        int count = this.buf[10] << 8 & 0xFF00 | this.buf[11] & 0xFF;
        return count;
    }

    public String getFormat() {
        if (this.bpa == 2) {
            return "SI";
        }
        return "SB";
    }

    public int getSize() {
        return this.fixedSize / this.bpa;
    }

    public int getBytes() {
        return this.fixedSize;
    }

    private void updateCount() {
        int ncount = this.getCount();
        if (this.count != 0) {
            if ((++this.count & 0x1F) == 31) {
                ++this.count;
            }
            if (ncount > this.count) {
                this.missed += ncount - this.count;
            }
        }
        this.count = ncount;
    }

    public String getConfiguration(DataFile df) {
        String config = "SDDS";
        if (this.ice) {
            config = config + "/ICE";
        } else if (this.udp) {
            config = config + "/UDP";
        }
        if (df.hp != null) {
            config = config + "/DET";
            if (df.hp.aux != null && df.hp.aux.length() > 0) {
                config = config + "=" + df.hp.aux;
            }
        }
        return config;
    }

    public void setFileName(DataFile df, FileName filename) {
        DataFile hp = new DataFile();
        hp.init(null, (Object)filename, "3000", "NH", df.getPacketHandlerFlags());
        String srec = "FORM|SB,BPS|SB,FRAM|SI,SOFF|SI,OTIC|SI,YTIC|CL,PTIC|SL,SSC|6I,SSD|4B,AAD|5L";
        if (this.udp) {
            srec = "KEY|2B,PORT|SI,ADDR|4B," + srec;
        }
        hp.setSubRecords(srec);
        hp.setDataRep("IEEE");
        df.hp = hp;
    }

    public double naturalDataOffset(DataFile df, double boffset) {
        int bpp = this.fixedSize;
        if (bpp == 0) {
            bpp = this.getBytes();
        }
        double npkt = Math.floor(boffset / (double)bpp);
        return npkt * (double)bpp;
    }

    public double dataToPacketOffset(DataFile df, double boffset) {
        int bpp = this.fixedSize;
        double npkt = Math.floor(boffset / (double)bpp);
        double bpkthdr = npkt * (double)this.headerLength;
        this.ipoff = (int)(boffset - npkt * (double)bpp);
        if (df.hp == null) {
            boffset += bpkthdr;
            if (this.ipoff > 0) {
                boffset += (double)this.headerLength;
            }
        } else {
            if (this.ipoff > 0) {
                npkt += 1.0;
            }
            this.npktoff = npkt;
        }
        return boffset;
    }

    public double packetToDataOffset(DataFile df, double boffset) {
        if (df.hp != null) {
            return boffset;
        }
        int bpp = this.fixedSize;
        double npkt = Math.floor(boffset / (double)(bpp + this.headerLength));
        return npkt * (double)bpp;
    }

    public void seek(DataFile df, double boffset) {
        boffset = this.dataToPacketOffset(df, boffset);
        if (df.hp != null) {
            df.hp.seek(this.npktoff);
        }
        if (df.io != null) {
            df.io.seek((long)(df.getDataStart() + boffset));
        }
    }

    public void open(DataFile df) {
        this.setFormat(df.getFormat());
        if (df.hp != null) {
            df.hp.open();
        }
        this.missed = 0;
    }

    public int read(DataFile df, byte[] buf, int boff, int bytes, long lbuf) {
        boolean bl = this.header = this.ipoff == 0;
        if (this.header) {
            if (df.hp != null) {
                df.hp.read(this.buf, this.headerOffset, this.headerLength);
            } else {
                df.io.read(this.buf, this.headerOffset, this.headerLength);
            }
        }
        if (this.header) {
            this.updateCount();
        }
        int nbp = this.getBytes();
        int nb = Math.min(bytes, nbp - this.ipoff);
        nb = buf != null ? df.io.read(buf, boff, nb) : df.io.read(lbuf, boff, nb);
        if (nb < 0) {
            return nb;
        }
        this.ipoff += nb;
        if (this.ipoff == nbp) {
            this.ipoff = 0;
        }
        if (bytes > nb) {
            nb += this.read(df, buf, boff + nb, bytes - nb, lbuf);
        }
        return nb;
    }

    public int write(DataFile df, byte[] buf, int boff, int bytes, long lbuf) {
        boolean bl = this.header = this.ipoff == 0;
        if (this.header) {
            if (df.hp != null) {
                df.hp.write(this.buf, this.headerOffset, this.headerLength);
            } else {
                df.io.write(this.buf, this.headerOffset, this.headerLength);
            }
        }
        int nbp = this.getBytes();
        int nb = Math.min(bytes, nbp - this.ipoff);
        nb = buf != null ? df.io.write(buf, boff, nb) : df.io.write(lbuf, boff, nb);
        if (nb < 0) {
            return nb;
        }
        this.ipoff += nb;
        if (this.ipoff == nbp) {
            this.ipoff = 0;
        }
        if (bytes > nb) {
            nb += this.write(df, buf, boff + nb, bytes - nb, lbuf);
        }
        return nb;
    }

    public void close(DataFile df) {
        if (df.hp != null) {
            df.hp.close();
        }
        if (this.missed > 0) {
            Shell.warning((CharSequence)("Packet sequence inconsistency, missed " + this.missed + " packets"));
        }
    }

    public boolean hasHeader() {
        return this.header;
    }

    public String listHeader() {
        int tcs = this.getTCS();
        String list = "SDDS-Packet Addr=" + this.getAddrStr() + " Port=" + this.getPort() + " Count=" + this.getCount() + " Elem=" + this.getSize() + " Bits=" + this.getBits();
        if ((tcs & 0x20) != 0) {
            int ssc = (int)(this.getSSC() + 0.5);
            list = list + " SSC=" + ssc;
        }
        if ((tcs & 0x40) != 0) {
            Time t = this.getTC();
            String ts = t != null ? t.toString(12) : null;
            list = list + " TC=" + ts;
            if ((tcs & 0xFFFFFF80) != 0) {
                list = list + " 1MSV";
            }
        }
        return list;
    }

    public PacketHandler cloneOf() {
        PacketHandler ph = null;
        try {
            ph = (PacketHandler)this.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ph;
    }

    public void setBuffer(byte[] buffer, int boff) {
        System.arraycopy(buffer, boff, this.buf, 0, 64);
    }

    public void getBuffer(byte[] buffer, int boff) {
        System.arraycopy(this.buf, 0, buffer, boff, 64);
    }

    private static void getLeapSec() {
        Table tbl;
        int soy = 0;
        int adj = 0;
        TextFile tf = new TextFile("nxm.ice.cfg.global_flags.cfg");
        if (tf.exists() && (tbl = new Table(tf)) != null) {
            if (tbl.containsKey("LEAPSECDOY")) {
                soy = 86400 * tbl.getL("LEAPSECDOY");
                adj = 1;
            }
            if (tbl.containsKey("LEAPSECSOY")) {
                soy = tbl.getL("LEAPSECSOY");
                adj = 1;
            }
            if (tbl.containsKey("LEAPSECADJ")) {
                adj = tbl.getL("LEAPSECADJ");
            }
        }
        leapSecSoY = soy;
        leapSecAdj = adj;
    }

    static {
        SDDSPacket.getLeapSec();
    }
}

