/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Shell;

public class NetIO {
    public static int RXBUFSIZE = 0x800000;
    public static int TXBUFSIZE = 262080;
    public static String flagsList = "Input,Output,InOut,OutIn,RMIF,HTTP,RTable,UDP,Thread,ThrSlv";
    public static int INPUT = 1;
    public static int OUTPUT = 2;
    public static int INOUT = 4;
    public static int OUTIN = 8;
    public static int RMIF = 16;
    public static int HTTP = 32;
    public static int RTAB = 64;
    public static int UDP = 128;
    public static int THREAD = 256;
    public static int THRSLV = 512;
    public static int MSG = 0;
    public static int SET = 1;
    public static int GET = 2;
    public static int RET = 3;
    public static int ACK = 4;
    public static int MSGR = 5;
    protected int sock;
    protected MulticastSocket ms;
    protected DatagramPacket dp;
    protected boolean useNative;
    protected InetSocketAddress lisa;
    protected InetSocketAddress risa;
    protected InetAddress lia;
    protected InetAddress ria;
    protected static boolean canUseNative = NetIO.load();

    public NetIO(boolean useNative) {
        this.useNative = useNative && canUseNative;
    }

    public static boolean load() {
        try {
            return Shell.loadLibrary((String)"ice", (String)"lib", (String)"NetIO");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int open(String url, int chans, int flags) {
        if (this.useNative) {
            this.sock = this.nioOpen(url, chans, flags);
            return this.sock;
        }
        int i0 = url.indexOf(":", 4);
        int i1 = url.indexOf("/", 4);
        int i2 = url.indexOf(":", i1);
        int i3 = url.length();
        if (i0 < 0 || i0 > i1) {
            i0 = i1;
        }
        if (i2 < 0) {
            i2 = i3;
        }
        String lhost = url.substring(4, i0);
        int lport = i1 > i0 ? Convert.s2l((String)url.substring(i0 + 1, i1)) : 29495;
        String rhost = url.substring(i1 + 1, i2);
        int rport = i3 > i2 ? Convert.s2l((String)url.substring(i2 + 1, i3)) : 29495;
        this.lisa = new InetSocketAddress(lhost, lport);
        this.lia = this.lisa.getAddress();
        this.risa = new InetSocketAddress(rhost, rport);
        this.ria = this.risa.getAddress();
        String slisa = this.lisa.toString().substring(1);
        String srisa = this.risa.toString().substring(1);
        System.out.println("Open local=" + slisa + " remote=" + srisa + " native=" + this.useNative);
        try {
            this.ms = new MulticastSocket(lport);
            this.ms.setInterface(this.lisa.getAddress());
            this.ms.setReuseAddress(true);
            this.ms.setLoopbackMode(false);
            if (flags > 0) {
                this.ms.setSendBufferSize(TXBUFSIZE);
            } else {
                this.ms.setSoTimeout(1);
                this.ms.setReceiveBufferSize(RXBUFSIZE);
                if (this.ria.isMulticastAddress()) {
                    this.ms.joinGroup(this.ria);
                }
            }
            return 1;
        }
        catch (Exception e) {
            System.out.println("openErr: " + e);
            return -1;
        }
    }

    public int send(int chan, byte[] buffer, int off, int bytes, int flags) {
        if (this.useNative) {
            return this.nioSendB(this.sock, chan, buffer, off, bytes, flags);
        }
        if (this.dp != null) {
            this.dp.setData(buffer, off, bytes);
        } else {
            this.dp = new DatagramPacket(buffer, off, bytes);
        }
        try {
            this.ms.send(this.dp);
            return this.dp.getLength();
        }
        catch (Exception e) {
            System.out.println("sendErr: " + e);
            return -1;
        }
    }

    public int recv(int chan, byte[] buffer, int off, int bytes, int flags) {
        if (this.useNative) {
            return this.nioRecvB(this.sock, chan, buffer, off, bytes, flags);
        }
        if (this.dp != null) {
            this.dp.setData(buffer, off, bytes);
        } else {
            this.dp = new DatagramPacket(buffer, off, bytes);
        }
        try {
            this.ms.receive(this.dp);
            return this.dp.getLength();
        }
        catch (SocketTimeoutException e) {
            return 0;
        }
        catch (Exception e) {
            System.out.println("recvErr: " + e);
            return -1;
        }
    }

    public int send(int chan, long vaddr, int bytes, int flags) {
        if (this.useNative) {
            return this.nioSend(this.sock, chan, vaddr, bytes, flags);
        }
        return 0;
    }

    public int recv(int chan, long vaddr, int bytes, int flags) {
        if (this.useNative) {
            return this.nioRecv(this.sock, chan, vaddr, bytes, flags);
        }
        return 0;
    }

    public int msg(int chan, int func, byte[] buffer, int bytes, int flags) {
        if (this.useNative) {
            return this.nioMsg(this.sock, chan, func, buffer, bytes, flags);
        }
        return 0;
    }

    public int file(String fname, String aname, int flags) {
        if (this.useNative) {
            return this.nioFile(this.sock, fname, aname, flags);
        }
        return 0;
    }

    public int close() {
        if (this.useNative) {
            if (this.sock > 0) {
                this.nioClose(this.sock);
            }
            return this.sock;
        }
        if (this.ms != null) {
            this.ms.close();
        }
        return 1;
    }

    public native int nioOpen(String var1, int var2, int var3);

    public native int nioClose(int var1);

    public native long nioAlloc(int var1);

    public native int nioFree(long var1);

    public native int nioSendBank(int var1, int var2, int var3, long var4, int var6, int var7, long var8, int var10, int var11);

    public native int nioSend(int var1, int var2, long var3, int var5, int var6);

    public native int nioRecv(int var1, int var2, long var3, int var5, int var6);

    public native int nioSendB(int var1, int var2, byte[] var3, int var4, int var5, int var6);

    public native int nioRecvB(int var1, int var2, byte[] var3, int var4, int var5, int var6);

    public native int nioMsg(int var1, int var2, int var3, byte[] var4, int var5, int var6);

    public native int nioFile(int var1, String var2, String var3, int var4);

    public static native int swap2(long var0, long var2, int var4);

    public static native int cvt12to16(long var0, long var2, int var4);

    public static native int cvt16to12(long var0, long var2, int var4);
}

