/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.DevIce;
import nxm.ice.lib.IceBlockResource;
import nxm.ice.lib.RamDiskResource;
import nxm.sys.inc.Keyable;
import nxm.sys.inc.MidasReference;
import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Results;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;

public class MDevIce
extends DevIce
implements Keyable {
    public Midas M;
    public String config;

    public MDevIce() {
        this.config = "ICEPIC,DEVNO=0,AUTODETECT,";
        MDevIce.load();
    }

    public MDevIce(Args MA, String alias) {
        this(MA.M, MDevIce.getConfig(MA, alias));
    }

    public MDevIce(Midas M, String config) {
        this.M = M;
        this.config = config;
        MDevIce.load();
    }

    public static boolean load() {
        if (!useNative) {
            try {
                useNative = Shell.loadLibrary((String)"ice", (String)"lib", (String)"DevIce");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return useNative;
    }

    public static int detect() {
        return MDevIce.detect(0);
    }

    public static int detect(int flags) {
        MDevIce.load();
        return DevIce.detect(flags);
    }

    @Override
    public int open(String config, int flags) {
        int stat = super.open(config, flags);
        long maxalloc = this.getIntFlagDef("MAXALLOC", -1);
        if (maxalloc > 0L) {
            this.setMaxAlloc(maxalloc << 20);
        }
        return stat;
    }

    public int open(int flags) {
        return this.open(this.config, flags);
    }

    public int open() {
        return this.open(this.config, 0);
    }

    public static String getConfig(Args MA, String alias) {
        int i;
        String hwfile = MA.M.results.getString("ENV.HWFILE");
        Data devnos = MA.M.results.getData("ENV.ICEPICS");
        String rconfig = null;
        String config = alias;
        if (config == null || config.length() == 0) {
            return null;
        }
        if (config.equals("DUMMY")) {
            return "DEVNO=99,TEST,NOLOCK,";
        }
        for (Results rt = MA.M.results; rt != null && rconfig == null; rt = rt.getPrevious()) {
            Object o = rt.get("HWALIAS." + alias);
            if (o != null && o instanceof String) {
                rconfig = (String)o;
            }
            if ((o = rt.get("HWALIAS_" + alias)) == null || !(o instanceof String)) continue;
            rconfig = (String)o;
        }
        if (rconfig != null) {
            config = rconfig;
        } else if (hwfile != null) {
            int i2;
            DataFile hwf = new DataFile();
            hwf.init((MidasReference)MA.M, (Object)hwfile);
            hwf.open();
            Object entry = hwf.keywords.get(alias);
            if (entry instanceof String) {
                config = (String)entry;
            }
            if (config.startsWith("ALIAS=") && (entry = hwf.keywords.get(alias = config.substring(6, i2 = config.indexOf(44)))) instanceof String) {
                config = (String)entry + config.substring(i2);
            }
            hwf.close();
        }
        config = config.trim();
        if (!config.endsWith(",")) {
            config = config + ",";
        }
        if (devnos != null && (i = config.indexOf("DEVNO=")) >= 0) {
            int devno = config.charAt(i + 6) - 48;
            devno = devnos.getL(devno);
            config = config.substring(0, i + 6) + devno + config.substring(i + 7);
        }
        if (MA.find("/FLAGS")) {
            config = MA.getS("/FLAGS") + "," + config;
        }
        if (config.indexOf(94) >= 0) {
            config = MA.evaluateCarets(config);
        }
        if (MA.find("/VERBOSE")) {
            config = config + "VERBOSE=" + MA.getL("/VERBOSE") + ",";
        }
        if (MA.find("/VB")) {
            config = config + "VERBOSE=" + MA.getL("/VB") + ",";
        }
        if (MA.getState("/SKIPONCARD")) {
            config = config + "SKIPONCARD,";
        }
        if (MA.getState("/SKIPONCORE")) {
            config = config + "SKIPONCORE,";
        }
        if (MA.find("/PORT")) {
            config = config + "PORT=" + MA.getS("/PORT") + ",";
        }
        if (MA.find("/TC") && !MA.find("/NOTC")) {
            String tcmode = MA.getS("/TC");
            if (tcmode.length() == 0) {
                tcmode = "SDN4";
            }
            config = config + "TC=" + tcmode + ",";
        }
        return config;
    }

    public static String getConfigEntry(String config, String name) {
        Table t = new Table("{" + config + "}");
        return t.getS(name);
    }

    public String getPortKey() {
        String cname;
        String port = this.getStrFlagDef("PORT", "Unknown");
        if (port.indexOf("CORE") >= 0 && (cname = this.getKeyS(0, 370, 4)) != null) {
            port = port + ":" + cname;
        }
        return port;
    }

    public int setKey(int dmac, int key, Data data) {
        data = data.convertTo((char)this.getKeyType(key));
        return this.setKey(dmac, key, data.buf, data.size * data.bpe);
    }

    public int getKey(int dmac, int key, Data data) {
        data.setType(this.getKeyType(key));
        data.setSize(this.getKeySize(key));
        return this.getKey(dmac, key, data.buf, data.size * data.bpe);
    }

    public Data getKey(int dmac, int key) {
        Data data = new Data(0);
        int status = this.getKey(dmac, key, data);
        if (status < 0) {
            data = null;
        }
        return data;
    }

    public DevIce.DmaMap mapFile(DataFile df) {
        DevIce.DmaMap map;
        if (df.io instanceof IceBlockResource) {
            IceBlockResource ibr = (IceBlockResource)df.io;
            map = ibr.map;
        } else if (df.io instanceof RamDiskResource) {
            RamDiskResource rdr = (RamDiskResource)df.io;
            map = rdr.map;
        } else {
            map = new DevIce.DmaMap();
            map.vbytes = map.bytes = (long)df.getDataSize();
            int psize = this.long2phys(map.bytes);
            map.mode = 3;
            if (this.mapMem(map, psize, 1) < 0) {
                return null;
            }
        }
        map.dev = this;
        return map;
    }

    public String getConfig() {
        return this.config;
    }

    public String getMcfg(int dmac) {
        int type = this.getKeyL(0, 101);
        boolean isY = type >= 5 && type <= 8;
        String mcfgList = isY ? "ENA,LEN,TEN,SEN,PLY,COE,MCOE,MCEN,8BIT,1BIT,BIT1,BIT4,LSBX,UOPT,CLKI,MSBI,SGO,TGO,GGO,XGO,IQ,MUX,VHS,ALT,LP1,LP2,FLIP,CLKM,IOM1,IOM2,?,BMUX" : "ENA,LEN,TEN,SEN,PLY,COE,MCOE,MCEN,8BIT,1BIT,BIT1,BIT4,LSBX,UOPT,CLKI,MSBI,SGO,TGO,GGO,XGO,DUAL,MUX,VHS,ALT,LP1,LP2,LP3,SP1,IOM1,IOM2,?,?";
        return Parser.mask2s((String)mcfgList, (int)this.getKeyL(dmac, 14));
    }

    public String getFlag(int dmac) {
        return Parser.mask2s((String)"Test,NoBrk,BigEnd,HS,MuxClk,IntClk,TC,Resv,NoLock,Disable,Verbose,NcClk,Boot,Tuner,ClkInv,MsbInv,VHS,Dual,Mux,Alt,SGo,TGo,GGo,XGo,Op1,Op2,Op3,Op4,Bit0,Bit4,RGo,NIO", (int)this.getKeyL(dmac, 10));
    }

    public String toString() {
        String ctype = Parser.get((String)cardList, (int)this.getKeyL(0, 101));
        String ptype = Parser.get((String)ioptList, (int)this.getKeyL(0, 102));
        int pindex = this.getKeyL(0, 103);
        int i1 = this.getKeyL(0, 191);
        int i2 = this.getKeyL(0, 191);
        String mtype1 = i1 < 0 ? Parser.get((String)imtList, (int)(-i1)) : Parser.get((String)omtList, (int)i1);
        String mtype2 = i2 < 0 ? Parser.get((String)imtList, (int)(-i2)) : Parser.get((String)omtList, (int)i2);
        return "ICE-DSP Card=" + ctype + " Port=" + ptype + pindex + " Mod1=" + mtype1 + " Mod2=" + mtype2;
    }

    public void modifyAlgorithm(int arg1, int arg2) {
        int[] args = new int[]{arg1, arg2};
        this.modifyAlgorithm(args);
    }

    public void modifyAlgorithm(int arg1, int arg2, int arg3) {
        int[] args = new int[]{arg1, arg2, arg3};
        this.modifyAlgorithm(args);
    }

    public void modifyAlgorithm(int arg1, int arg2, int arg3, int arg4) {
        int[] args = new int[]{arg1, arg2, arg3, arg4};
        this.modifyAlgorithm(args);
    }

    public void modifyAlgorithm(int[] args) {
        byte[] head = new byte[8];
        Data data = new Data(args);
        Convert.packI((byte[])head, (int)0, (short)7);
        this.send(0, head, data.buf, data.buf.length, 0x200000);
    }

    public String[] getKeys() {
        return keys;
    }

    public Object getKey(String key) {
        Data value = null;
        int ikey = this.name2key(key);
        if (ikey <= 0) {
            return null;
        }
        byte type = this.getKeyType(ikey);
        if (type == 76) {
            value = new Data(this.getKeyL(-1, ikey));
        }
        if (type == 68) {
            value = new Data(this.getKeyD(-1, ikey));
        }
        return value;
    }

    public Object setKey(String key, Object value) {
        int ikey = this.name2key(key);
        if (ikey <= 0) {
            return null;
        }
        byte type = this.getKeyType(ikey);
        if (type == 76) {
            this.setKeyL(-1, ikey, Convert.o2l((Object)value));
        }
        if (type == 68) {
            this.setKeyD(-1, ikey, Convert.o2d((Object)value));
        }
        return value;
    }

    public int setKeyD(int dmac, int key, double data1, double data2) {
        byte[] bbuf = new byte[16];
        Convert.packD((byte[])bbuf, (int)0, (double)data1);
        Convert.packD((byte[])bbuf, (int)8, (double)data2);
        return this.setKey(dmac, key, bbuf, 16);
    }

    public int setKeyD(int dmac, int key, double data1, double data2, double data3) {
        byte[] bbuf = new byte[24];
        Convert.packD((byte[])bbuf, (int)0, (double)data1);
        Convert.packD((byte[])bbuf, (int)8, (double)data2);
        Convert.packD((byte[])bbuf, (int)16, (double)data3);
        return this.setKey(dmac, key, bbuf, 24);
    }

    public String setKeyTable(int dmac, String table) {
        byte[] tbuf = table.getBytes();
        int tlen = tbuf.length;
        int blen = Math.max(tlen, 1024);
        byte[] bbuf = new byte[blen];
        System.arraycopy(tbuf, 0, bbuf, 0, tlen);
        bbuf[tlen] = 0;
        int len = this.setKey(dmac, 350, bbuf, blen);
        return new String(bbuf, 0, len);
    }

    public String getKeyTable(int dmac, String table) {
        byte[] tbuf = table.getBytes();
        int tlen = tbuf.length;
        int blen = Math.max(tlen, 1024);
        byte[] bbuf = new byte[blen];
        System.arraycopy(tbuf, 0, bbuf, 0, tlen);
        bbuf[tlen] = 0;
        int len = this.getKey(dmac, 350, bbuf, blen);
        return new String(bbuf, 0, len);
    }
}

