/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import nxm.ice.lib.IceHW;
import nxm.ice.lib.IcePM;

public class IceV6M
extends IcePM {
    public static int ftt2;

    public static void initAlgorithm() {
        IceV6M.resetDMA();
        IceHW.FTTStruct ftt = (IceHW.FTTStruct)IceV6M.getObjectAt(1152);
        ftt.stages = 0;
        ftt2 = 0;
        runMode = 0;
    }

    public static void openAlgorithm(int port, int type, int route) {
        IceV6M.awBus(0x1008008, route);
        IceV6M.awBus(16809988, 240);
        if (type == 9) {
            IceV6M.initTBank(port);
        }
        runMode = 2;
    }

    public static void processAlgorithm() {
        IceHW.FTTStruct ftt = (IceHW.FTTStruct)IceV6M.getObjectAt(1152);
        int stages = ftt.stages;
        if (stages < 0) {
            stages = -stages;
        }
        int cstage = ftt.cstage;
        if (stages > 1) {
            IceV6M.doTBank(cstage, true);
        }
        if (stages > 0) {
            IceV6M.doTBank(stages - 1, false);
        }
        if (ftt2 > 0) {
            IceV6M.doTBank(4, false);
        }
        if (dcfgA != 0) {
            IceV6M.processDelay(dcfgA, delayA);
        }
        if (dcfgB != 0) {
            IceV6M.processDelay(dcfgB, delayB);
        }
    }

    public static void closeAlgorithm(int port, int type, int route) {
        IceV6M.awBus(16809996, route);
        if (type == 9) {
            IceV6M.exitTBank(port);
            IceV6M.udelay(1000);
            runMode = 0;
        }
        if (IceV6M.arBus(0x1008000) == 0) {
            IceV6M.resetDMA();
        }
    }

    public static void modifyAlgorithm(int data, int size) {
    }

    protected static void initTBank(int port) {
        int act;
        int fttloc = 1152;
        IceHW.FTTStruct ftt = (IceHW.FTTStruct)IceV6M.getObjectAt(fttloc);
        IceHW.TBStruct tb = null;
        if (port == 2 && ftt.stages == 1) {
            fttloc = 1536;
            ftt = (IceHW.FTTStruct)IceV6M.getObjectAt(fttloc);
            ftt2 = 1;
        }
        int oact = ftt.active;
        if (port == 3) {
            port = 7;
        }
        int top = (act = oact | port) == 2 ? 1 : 0;
        int stages = ftt.stages;
        ftt.chantop = top;
        ftt.active = act;
        for (int i = 0; i < 3; ++i) {
            int tbi = fttloc + (i > 1 ? 256 : (i > 0 ? 176 : 96));
            tb = (IceHW.TBStruct)IceV6M.getObjectAt(tbi);
            tb.chan = top;
            tb.pindx = 0;
            tb.tphase = 0;
            tb.tdphase = 0;
        }
        if (oact != 0) {
            return;
        }
        ftt.cstage = 0;
        ftt.lstage = -1;
        ftt.busy = -1;
        ftt.dca0 = null;
        ftt.dca1 = null;
        tb = (IceHW.TBStruct)IceV6M.getObjectAt(fttloc + 96);
        int nchan = tb.nchan;
        int pcfg = tb.pcfg;
        int pstrt = tb.pstrt;
        int psize = tb.psize;
        int inc = stages > 1 ? 2 : 1;
        int i = 0;
        int j = 0;
        int adr = pstrt | pcfg;
        while (i < nchan) {
            IceV6M.setupDMAt(j, adr + (ftt.stages < 0 ? (j & 0xE) << 5 : 0));
            ++i;
            j += inc;
            adr += psize;
        }
        ftt.tbctl = IceV6M.arBus(-2142699520);
        if (stages > 1) {
            IceV6M.ssBank(0);
        }
    }

    protected static void doTBank(int stage, boolean bpass) {
        int addr;
        int io;
        boolean odd;
        int act;
        int fttloc = stage == 4 ? 1536 : 1152;
        IceHW.FTTStruct ftt = (IceHW.FTTStruct)IceV6M.getObjectAt(fttloc);
        IceHW.TBStruct tb = null;
        IceHW.TBStruct tbn = null;
        if (stage == 4) {
            stage = 0;
        }
        if ((act = ftt.active) == 0) {
            return;
        }
        int dcaa = fttloc + (bpass ? 348 : 344);
        int dci = IceV6M.arMem(dcaa);
        if (dci != 0 && IceV6M.dmaSync(dci) != 0) {
            return;
        }
        int tbi = fttloc + (stage == 0 ? 96 : (stage == 1 ? 176 : 256));
        tb = (IceHW.TBStruct)IceV6M.getObjectAt(tbi);
        int tbni = tbi + 80;
        tbn = (IceHW.TBStruct)IceV6M.getObjectAt(tbni);
        int chan = tb.chan;
        int ctop = ftt.chantop;
        boolean bl = odd = (chan & 1) != 0 && act != 7;
        int n = bpass ? 7 : (io = odd ? ftt.omodb : ftt.omoda);
        if (stage == ftt.busy) {
            IceV6M.awBus(16809996, 0x1000000 << io);
            ftt.busy = -1;
            if (chan == ctop) {
                tbn.pindx = tbn.pindx + tb.prod & tbn.pmask;
            }
            IceV6M.ssBank(0);
        }
        if (bpass && ftt.busy >= 0) {
            return;
        }
        if (stage == 0) {
            int chani = chan;
            if (bpass) {
                chani <<= 1;
            }
            addr = IceV6M.arMem(-41943040 + (chani << 2));
        } else {
            addr = chan == ctop ? IceV6M.getBase(tb, chan) : ftt.addr;
        }
        int mask = tb.pmask;
        int indx = tb.index;
        int xfer = tb.xfer;
        int size = tb.psize;
        int diff = (addr & mask) - indx;
        if (diff < 0) {
            diff += size;
        }
        if (diff < xfer) {
            if (bpass && chan == ctop && ftt.stages > 2) {
                ftt.cstage = 1 - ftt.cstage;
            }
            return;
        }
        if (bpass) {
            IceV6M.ssBank(0);
            if (chan == ctop) {
                ftt.base = IceV6M.getBase(tbn, chan);
            }
            int base = ftt.base;
            int incr = tbn.psize;
            if (act != 7) {
                incr <<= 1;
            }
            int lstage = ftt.lstage;
            int phinc = tbn.phinc;
            int dphinc = tbn.dphinc;
            int tphase = tbn.tphase;
            int tdphase = tbn.tdphase;
            int start = tphase;
            int taddr = Integer.MIN_VALUE;
            int tinc = 65536;
            int cpb2 = tbn.mchan << 1;
            for (int i = 1; i < cpb2; i += 2) {
                if (stage != lstage) {
                    IceV6M.awBus(taddr + 24, -phinc);
                }
                if (chan == ctop) {
                    IceV6M.awBus(taddr + 28, -start);
                }
                start += tdphase;
                IceV6M.setupDMAt(i, base);
                phinc += dphinc;
                base += incr;
                taddr += tinc;
            }
            if (chan == ctop) {
                tbn.tphase = tphase + tbn.tphinc;
                tbn.tdphase = tdphase + tbn.tdphinc;
            }
            if (act == 3) {
                base = odd ? (base -= tbn.psize) : ftt.base + tbn.psize;
            }
            int cm = stage == 0 && ftt.stages > 2 ? -1 : 1;
            IceV6M.ssBank(cm);
            ftt.lstage = stage;
            ftt.busy = stage;
            ftt.base = base;
        }
        int j = ftt.stages < 0 ? chan : 0;
        int start = indx + ((j & 0xE) << 5);
        int stop = start + xfer & mask;
        int base = addr & ~mask;
        dci = -41926912 + (io << 3);
        IceV6M.awMem(dci + 0, base + start);
        IceV6M.awMem(dci + 4, base + stop);
        IceV6M.awBus(0x1008008, 0x1000000 << io);
        if ((act & 3) != 3) {
            ++chan;
        }
        if (++chan >= tb.nchan) {
            chan = ctop;
            tb.index = indx = indx + tb.cons & mask;
        }
        if (stage > 0) {
            addr += size;
            if ((act & 3) != 3) {
                addr += size;
            }
            ftt.addr = addr;
        }
        tb.chan = chan;
        IceV6M.awMem(dcaa, dci);
    }

    protected static void exitTBank(int port) {
        int act;
        IceHW.FTTStruct ftt = (IceHW.FTTStruct)IceV6M.getObjectAt(1152);
        if (port > 2) {
            port = 7;
        }
        if (port == 2) {
            ftt2 = 0;
        }
        ftt.active = act = ftt.active & ~port;
        if (act != 0) {
            return;
        }
        if (ftt.stages > 1) {
            IceV6M.ssBank(0);
        }
    }

    static int getBase(IceHW.TBStruct tb, int chan) {
        return tb.pcfg | tb.pstrt + tb.psize * chan + tb.pindx;
    }

    static void ssBank(int mode) {
        int ctl = IceV6M.arMem(1504);
        if (mode < 0) {
            ctl &= Short.MAX_VALUE;
        }
        if (mode == 0) {
            ctl &= 0xFFFFFFFE;
        }
        IceV6M.awBus(-2142699520, ctl);
    }
}

