/*
 * Decompiled with CFR 0.152.
 */
package nxm.ice.lib;

import java.io.InputStream;
import java.io.OutputStream;
import nxm.ice.lib.MDevIce;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Midas;
import nxm.sys.lib.OS;
import nxm.sys.lib.Query;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;

public class IceSys {
    public static Table config;
    public static Midas M;
    public static boolean isLoaded;

    public IceSys() {
        IceSys.load();
    }

    public static boolean load() {
        M = Shell.getMidasContext();
        String file = IceSys.M.io.name("HOME", "iceauto", "tbl", "AUX");
        config = Convert.o2t((Object)file, (Object)M);
        return true;
    }

    public static void query(String uri) {
        String key;
        int k = 0;
        String list = null;
        int maxitems = 32;
        Object obj = config;
        Query q = new Query(obj, list, maxitems);
        int ls = uri.length();
        int le = uri.indexOf("=");
        if (le < 0) {
            le = ls;
        }
        int j = 0;
        while ((k = uri.indexOf("/", j)) > j) {
            int i;
            if ((i = uri.indexOf("/", ++k)) < 0) {
                i = le;
            }
            key = uri.substring(k, i);
            System.out.println("Key=" + key);
            q.parse();
            obj = q.getObject(key);
            q = new Query(obj, list, maxitems);
            j = k;
        }
        if (k < 0) {
            k = 0;
        }
        key = uri.substring(k, le);
        q.parse();
        obj = q.getObject(key);
        System.out.println(uri.substring(0, le) + "=" + obj);
    }

    public static Table getNICs() {
        Table t = new Table();
        int n = config.getL("NICS");
        t.put("NICS", n);
        for (int i = 0; i < n; ++i) {
            String key = "NIC" + i + "AUTO";
            String value = config.getS(key);
            Table tp = new Table("{" + value + "}");
            t.put(key, (Object)tp);
        }
        return t;
    }

    public static Table getPICs() {
        Table t = new Table();
        int n = config.getL("PICS");
        t.put("PICS", n);
        for (int i = 1; i <= n; ++i) {
            String key = "PIC" + i + "AUTO";
            String value = config.getS(key);
            MDevIce pic = new MDevIce(M, value);
            while (value.endsWith(",")) {
                value = value.substring(0, value.length() - 1);
            }
            pic.open();
            int act = pic.getKeyL(0, 17);
            int temp = -1;
            int[] temps = new int[]{-1, -1, -1, -1, -1};
            if (act >= 0) {
                temp = temps[0] = (int)pic.getKeyD(0, 106);
                if (pic.getKeyL(0, 191) != 0) {
                    temps[1] = (int)pic.getKeyD(1, 106);
                    if (temps[1] > temp) {
                        temp = temps[1];
                    }
                }
                if (pic.getKeyL(0, 192) != 0) {
                    temps[2] = (int)pic.getKeyD(2, 106);
                    if (temps[2] > temp) {
                        temp = temps[2];
                    }
                }
                if (pic.getKeyL(0, 195) != 0) {
                    temps[3] = (int)pic.getKeyD(11, 106);
                    if (temps[3] > temp) {
                        temp = temps[3];
                    }
                }
                if (pic.getKeyL(0, 196) != 0) {
                    temps[4] = (int)pic.getKeyD(12, 106);
                    if (temps[4] > temp) {
                        temp = temps[4];
                    }
                }
            }
            int flags = act >= 0 ? pic.getKeyL(0, 161) : 0;
            pic.close();
            value = value.replace("ICEPIC", "ACTIVE=" + act + ",TEMP=" + temp + ",FLAGS=" + Convert.l2x((int)flags));
            value = value + ",COMPTEMP=(" + temps[0] + "," + temps[1] + "," + temps[2] + "," + temps[3] + "," + temps[4] + ")";
            Table tp = new Table("{" + value + "}");
            t.put(key, (Object)tp);
        }
        return t;
    }

    public static Table getQICs() {
        Table t = new Table();
        int n = config.getL("QICS");
        t.put("QICS", n);
        return t;
    }

    public static Table getDisks() {
        Table t = new Table();
        String list = IceSys.M.results.getS("AUX.READ");
        String[] auxes = StringUtil.cleanSplit((String)list, (String)"|");
        for (int i = 0; i < auxes.length; ++i) {
            String aux = auxes[i];
            String path = IceSys.M.io.getAuxPath(aux);
            Table tab = OS.getStatFS((String)path);
            t.put(aux, (Object)tab);
        }
        return t;
    }

    public static Table getFS() {
        return null;
    }

    public static int runCommand(String cmd, int flags, byte[] buf) {
        int boff = 0;
        int timeout = 20;
        try {
            Runtime runtime = Runtime.getRuntime();
            Process osProcess = runtime.exec(cmd);
            OutputStream osInput = osProcess.getOutputStream();
            InputStream osOutput = osProcess.getInputStream();
            int state = 0;
            while (state >= 0 && timeout != 0 && boff < buf.length) {
                int bytes = osOutput.available();
                if (bytes > 0) {
                    bytes = Math.min(bytes, buf.length - boff);
                    if ((bytes = osOutput.read(buf, boff, bytes)) > 0) {
                        boff += bytes;
                    }
                    state = 1;
                }
                try {
                    int status = osProcess.exitValue();
                    if (osOutput.available() > 0) {
                        state = 0;
                        continue;
                    }
                    state = -1;
                }
                catch (IllegalThreadStateException e) {
                    if (state == 0) {
                        Time.sleep((double)0.1);
                        --timeout;
                        continue;
                    }
                    state = 0;
                }
            }
            osInput.close();
            osOutput.close();
        }
        catch (Exception e) {
            Shell.printStackTrace((CharSequence)"Error running OS cmd", (Throwable)e);
        }
        return boff;
    }

    static {
        isLoaded = IceSys.load();
    }
}

